from .audio_tag.model_config import ZipformerForSequenceClassificationConfig
from .audio_clap.model_config import ZipformerForClapConfig
from .asr.model_config import ZipformerForAsrConfig
from .tta.model_config import ZipformerForTtaConfig
from .audio_captioning.model_config import ZipformerForAudioCaptioningConfig, ZipformerForAudioCaptioningWithMaskingConfig
from .spk_id.model_config import ZipformerForSpeakerIdentificationConfig
from .spk_veri.model_config import ZipformerForSpeakerVerificationConfig
from .asr_llm.model_config import AsrLLMConfig
from .music_tag.model_config import ZipformerForMusicTaggingConfig
from .audio_frame_classification.model_config import ZipformerForFrameClassificationConfig, ZipformerForDESEDConfig

CONFIG_REGISTRY = {
    "zipformer-tag": ZipformerForSequenceClassificationConfig,
    "zipformer-clap": ZipformerForClapConfig,
    "zipformer-asr": ZipformerForAsrConfig,
    "zipformer-tta": ZipformerForTtaConfig,
    "zipformer-captioning": ZipformerForAudioCaptioningConfig,
    "zipformer-spkid":ZipformerForSpeakerIdentificationConfig,
    "zipformer-spkveri":ZipformerForSpeakerVerificationConfig,
    "asr-llm": AsrLLMConfig,
    "zipformer-music": ZipformerForMusicTaggingConfig,
    "zipformer-masked-captioning": ZipformerForAudioCaptioningWithMaskingConfig,
    "zipformer-frame-classification": ZipformerForFrameClassificationConfig,
    "zipformer-desed": ZipformerForDESEDConfig,
}