#!/bin/bash

# Ensure Python paths and debugging flags are set
AUDENPATH=/apdcephfs_cq10/share_1603164/user/jamelynli/workspace/Auden
cd $AUDENPATH/egs/asr_whisper
export PYTHONPATH=$AUDENPATH:$PYTHONPATH
export HYDRA_FULL_ERROR=1

# decode with vanilla large-v3
python decode.py ++exp_dir=exp \
    inference.remove_input_restriction=false \
    no_language=False \
    model.config_path="./configs/model/large-v3.json" \
    lora.use_lora=False \
    data.num_filters=128 \
    tokenizer.path="./configs/tokenizer/expand_yue.json" \
    ++num_debug_batch=100000

# decode with vanilla medium
# python decode.py ++exp_dir=exp \
#     inference.remove_input_restriction=false \
#     no_language=False \
#     model.config_path="./configs/model/medium.json" \
#     lora.use_lora=False \
#     tokenizer.path="./configs/tokenizer/base.json" # ++num_debug_batch=4

# decode with token_expansion example
# python decode.py ++exp_dir=exp/aishell_fft \
#     inference.remove_input_restriction=false \
#     inference.epoch=-1 \
#     no_language=False \
#     lora.use_lora=False \
#     model.config_path="./configs/model/expand_example.json" \
#     tokenizer.path="./configs/tokenizer/expand_example.json" \
#     ++num_debug_batch=4

# decode with trained lora
# python decode.py ++exp_dir=exp/aishell_yue_lora \
#     data.test_set_name="[aishell, librispeech, cv-yue, cv-zh-HK]" \
#     inference.remove_input_restriction=False \
#     inference.epoch=999 \
#     no_language=True \
#     lora.use_lora=False \
#     model.config_path="./configs/model/medium_yue.json" \
#     tokenizer.path="./configs/tokenizer/expand_yue.json" \
#     ++num_debug_batch=4
