#!/bin/bash

. /opt/conda/bin/activate # activate conda env
# Ensure Python paths and debugging flags are set
AUDENPATH=/apdcephfs_cq10/share_1603164/user/jamelynli/workspace/Auden
cd $AUDENPATH/egs/asr_whisper
export PYTHONPATH=$AUDENPATH:$PYTHONPATH
export HYDRA_FULL_ERROR=1
export OMP_NUM_THREADS=8

MASTER_ADDR=$(hostname --ip-address)
MASTER_PORT=29507
ngpu=8

# train fully-finetune
torchrun --nnodes=1 --nproc_per_node=${ngpu} \
         --rdzv_id=100 \
         --rdzv_backend=c10d \
         --rdzv_endpoint="$MASTER_ADDR:$MASTER_PORT" \
    train.py \
    ++exp_dir=exp/aishell_yue_fft \
    data.max_duration=32 \
    trainer.ref_duration=32 \
    trainer.base_lr=0.00001 \
    lora.use_lora=false \
    trainer.valid_interval=500 \
    model.config_path="./configs/model/medium_yue.json" \
    tokenizer.path="./configs/tokenizer/expand_yue.json"
