#!/bin/bash
export PYTHONPATH=/apdcephfs_cq10/share_1603164/user/mingyuehuo/Auden_fresh:/apdcephfs_cq10/share_1603164/user/yiwenyshao/lhotse:$PYTHONPATH

# # ----------------train from scratch using CrossEntropy loss------------------
export CUDA_VISIBLE_DEVICES=0,1,2,3
torchrun --nproc_per_node=4 \
        --master-port=29501 \
        train.py \
        exp_dir=exp/voxceleb2_scratch_CE \
        model.config.loss_type=ce \
        model.id2label_json=configs/voxceleb2/id2label_voxceleb2.json \
        data.max_duration=300 \
        data.use_infinite_dataset=true \
        trainer.use_fp16=false \
        trainer.lr_steps_per_epoch=10000 \
        


# ----------------train from scratch using AAM-Softmax loss------------------
# export CUDA_VISIBLE_DEVICES=0,1,2,3
# torchrun --nproc_per_node=4 \
#         --master-port=29501 \
#         train.py \
#         exp_dir=exp/voxceleb2_scratch_AAMS \
#         model.id2label_json=configs/voxceleb2/id2label_voxceleb2.json \
#         model.config.loss_type=aams \
#         +model.config.margin=0.2 \
#         +model.config.scale=64 \
#         data.max_duration=200 \
#         data.use_infinite_dataset=true \
#         trainer.use_fp16=false \
#         trainer.lr_steps_per_epoch=10000 \


# # # # # ----------------ASR init------------------
# pretrained_checkpoint=/apdcephfs_cq10/share_1603164/user/yiwenyshao/independent/auden/egs/asr/exp/auden_zh_r3large_full_8gpu/averaged_iter1412000_avg10.pt
# # ASR is large model, set config_preset=large
# export CUDA_VISIBLE_DEVICES=4,5,6,7
# torchrun --nproc_per_node=4 \
#         --master-port=29502 \
#         train.py \
#         exp_dir=exp/voxceleb2_asr_init \
#         model.id2label_json=configs/voxceleb2/id2label_voxceleb2.json \
#         model.config.loss_type=ce \
#         +model.config_preset=large \
#         data.max_duration=300 \
#         data.use_infinite_dataset=true \
#         trainer.use_fp16=false \
#         trainer.lr_steps_per_epoch=10000 \
#         trainer.base_lr=0.0045 \
#         trainer.initialization.checkpoint=$pretrained_checkpoint \
