from ..zipformer.model_config import ZipformerConfig
from dataclasses import dataclass, asdict, field
from typing import Dict, Any, Literal, Optional

@dataclass
class ZipformerForClapConfig(ZipformerConfig):
    name: str = "zipformer-clap"
    text_encoder_type: str = "bert-base-uncased"
    init_text_encoder_from_scratch: bool = False
    temp: float = 0.07
    embed_reg: bool = True
    shared_emb_dim: int = 1024
    pooling: Literal['mean', 'mhap'] = 'mean'
    mhap: Dict[str, Any] = field(default_factory=dict)

    @classmethod
    def from_preset(cls, preset: str, **kwargs):
        presets = {
            "base": {
                **asdict(ZipformerConfig.from_preset("base")),
                "name": "zipformer-clap",
                "shared_emb_dim": 1024,
            },
            "large": {
                **asdict(ZipformerConfig.from_preset("large")),
                "name": "zipformer-clap",
                "shared_emb_dim": 1024,
            }
        }

        if preset not in presets:
            raise ValueError(
                f"Unsupported preset '{preset}' for {cls.__name__}. Supported: {list(presets.keys())}"
            )

        config_dict = presets[preset].copy()
        config_dict.update(kwargs)
        return cls(**config_dict)

