from .audio_tag.model import ZipformerForSequenceClassificationModel
from .audio_clap.model import ZipformerForClapModel
from .asr.model import ZipformerForAsrModel
from .tta.model import ZipformerForTtaModel
from .audio_captioning.model import ZipformerForAudioCaptioningModel, ZipformerForAudioCaptioningWithMaskingModel
from .spk_id.model import ZipformerForSpeakerIdentificationModel
from .spk_veri.model import ZipformerForSpeakerVerificationModel
from .asr_llm.model import AsrLLMModel
from .music_tag.model import ZipformerForMusicTaggingModel
from .audio_frame_classification.model import ZipformerForFrameClassificationModel, ZipformerForDESED

# Maps model_type string → model class
MODEL_REGISTRY = {
    "zipformer-tag": ZipformerForSequenceClassificationModel,
    "zipformer-clap": ZipformerForClapModel,
    "zipformer-asr": ZipformerForAsrModel,
    "zipformer-tta": ZipformerForTtaModel,
    "zipformer-captioning": ZipformerForAudioCaptioningModel,
    "zipformer-spkid": ZipformerForSpeakerIdentificationModel,
    "zipformer-spkveri": ZipformerForSpeakerVerificationModel,
    "asr-llm": AsrLLMModel,
    "zipformer-music": ZipformerForMusicTaggingModel,
    "zipformer-masked-captioning": ZipformerForAudioCaptioningWithMaskingModel,
    "zipformer-frame-classification": ZipformerForFrameClassificationModel,
    "zipformer-desed": ZipformerForDESED,
}
