import json
from dataclasses import dataclass
from typing import Union, Tuple, List, Optional

@dataclass
class ZipformerConfig:
    feature_dim: int = 80,
    output_downsampling_factor: int = 2,
    downsampling_factor: Tuple[int] = (2, 4),
    encoder_dim: Union[int, Tuple[int]] = 384,
    num_encoder_layers: Union[int, Tuple[int]] = 4,
    encoder_unmasked_dim: Union[int, Tuple[int]] = 256,
    query_head_dim: Union[int, Tuple[int]] = 24,
    pos_head_dim: Union[int, Tuple[int]] = 4,
    value_head_dim: Union[int, Tuple[int]] = 12,
    pos_dim: int = 256,
    num_heads: Union[int, Tuple[int]] = 8,
    feedforward_dim: Union[int, Tuple[int]] = 1536,
    cnn_module_kernel: Union[int, Tuple[int]] = 31,
    dropout: float = None,
    warmup_batches: float = 4000.0,
    causal: bool = False,
    chunk_size: List[int] = [-1],
    left_context_frames: List[int] = [-1],
    # MoE-specific parameters
    num_experts: Optional[int] = 1,
    top_k: Optional[int] = None,
    granularity: Optional[int] = None,
    num_shared_experts: Optional[int] = 0,
    moe_type: Optional[str] = None,
    normalize_moe_score: Optional[bool] = False,
    balance_expert: Optional[bool] = None,
    specialize_expert: Optional[bool] = None,
    # ASR-specific parameters
    decoder_dim: Optional[int] = None,
    context_size: Optional[int] = None,
    joiner_dim: Optional[int] = None,
    vocab_size: Optional[int] = None,
    blank_id: Optional[int] = None,
    use_transducer: Optional[bool] = None,
    use_ctc: Optional[bool] = None,
    use_attention_decoder: Optional[bool] = None,
    predict_lid: Optional[bool] = None,
    detach_lid: Optional[bool] = None,

    def to_dict(self):
        """Convert config to dictionary."""
        return self.__dict__

    def to_json(self, json_path: str):
        """Save config to a JSON file."""
        with open(json_path, "w") as f:
            json.dump(self.to_dict(), f, indent=4)
