export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export TOKENIZERS_PARALLELISM=false
num_nodes=1
num_gpus=$(echo $CUDA_VISIBLE_DEVICES | awk -F "," '{print NF}')
job_id=2024
HOST_NODE_ADDR="localhost:0"

# torchrun --nnodes=$num_nodes --nproc_per_node=$num_gpus --rdzv_id=$job_id --rdzv_backend="c10d" --rdzv_endpoint=$HOST_NODE_ADDR \
#     train.py \
#         exp_dir=exp/test_zipformer \
#         model.config.speech_encoder_type=zipformer \
#         model.config.speech_encoder_path=/apdcephfs_cq10/share_1603164/user/yiwenyshao/independent/auden/egs/asr/exp/zh_asr_v1/averaged_iter1412000_avg10.pt \
#         model.config.llm_path=/apdcephfs_cq10/share_1603164/user/yiwenyshao/tencent_ailab_asr/egs/tencent/ASR/models/Qwen2.5-7B-Instruct \
#         model.config.use_flash_attn=false \
#         model.config.stage=1 \

torchrun --nnodes=$num_nodes --nproc_per_node=$num_gpus --rdzv_id=$job_id --rdzv_backend="c10d" --rdzv_endpoint=$HOST_NODE_ADDR \
    train.py \
        exp_dir=exp/test_whisper_fbank \
        model.config.speech_encoder_type=whisper \
        model.config.speech_encoder_path=/apdcephfs_cq10/share_1603164/user/yiwenyshao/tencent_ailab_asr/egs/tencent/ASR/models/yuekai_whisper/whisper-large-v2-multi-hans-zh-epoch-3-avg-10.pt \
        model.config.llm_path=/apdcephfs_cq10/share_1603164/user/yiwenyshao/tencent_ailab_asr/egs/tencent/ASR/models/Qwen2.5-7B-Instruct \
        model.config.use_flash_attn=false \
        model.config.stage=1 \
        data.whisper_fbank=true