#!/bin/bash
export PYTHONPATH=/apdcephfs_cq12/share_302080740/user/raytseng/research/Auden-refactor-online/Auden:$PYTHONPATH

# valid_sets='[/apdcephfs_cq12/share_302080740/user/raytseng/research/Auden-refactor-online/Auden/egs/audio_captioning/manifests/audiocaps_val.jsonl.gz,/apdcephfs_cq12/share_302080740/user/raytseng/data/WavCaps/manifest/MusicCaps_eval_500.jsonl.gz,/apdcephfs_cq12/share_302080740/user/raytseng/data/ParaSpeechCaps/dev_500.jsonl.gz]'
valid_sets='[/apdcephfs_cq12/share_302080740/user/raytseng/research/Auden-refactor-online/Auden/egs/audio_captioning/manifests/audiocaps_val.jsonl.gz,/apdcephfs_cq12/share_302080740/user/raytseng/data/ParaSpeechCaps/dev_500.jsonl.gz,/apdcephfs_cq12/share_302080740/user/raytseng/data/WavCaps/manifest/MusicCaps_eval_500.jsonl.gz]'

# train a audio captioning model completely from scratch, batch size 6400, lr 5e-3, fp16, WITH PARALLEL CAPTIONING GENERATION
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 torchrun --nproc_per_node=8 \
        --master_port=29503 \
        train.py \
        exp_dir=exp/testing \
        model.name="zipformer-masked-captioning" \
        data.train_data_config=configs/captionstew_full/train_data_config_captionstew_full.yaml \
        data.max_duration=640 \
        data.valid_sets=$valid_sets \
        data.use_infinite_dataset=true \
        data.num_workers=12 \
        trainer.use_fp16=true \
        trainer.lr_steps_per_epoch=25000 \
        trainer.base_lr=0.005 \
        trainer.warmup_batches=20000 \
        trainer.valid_interval=30 \