#!/bin/bash

# # ----------------train from scratch ------------------
export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
torchrun --nproc_per_node=4 \
        train.py \
        exp_dir=exp/emotion_scratch_noRAVDESS \
        model.id2label_json=configs/emotion/id2label_emotion.json \
        data.train_data_config=configs/emotion/train_data_config.yaml \
        data.max_duration=300 \
        data.use_infinite_dataset=true \
        trainer.use_fp16=false \
        trainer.lr_steps_per_epoch=10000 \


# # ----------------train from asr init ------------------
# pretrained_checkpoint=/apdcephfs_cq10/share_1603164/user/yiwenyshao/independent/auden/egs/asr/exp/auden_zh_r3large_full_8gpu/averaged_iter1412000_avg10.pt
# export CUDA_VISIBLE_DEVICES=4,5,6,7
# torchrun --nproc_per_node=4 \
#         train.py \
#         exp_dir=exp/emotion_asr_init \
#         model.id2label_json=configs/emotion/id2label_emotion.json \
#         +model.config_preset=large \
#         data.train_data_config=configs/emotion/train_data_config.yaml \
#         data.max_duration=300 \
#         data.use_infinite_dataset=true \
#         trainer.use_fp16=false \
#         trainer.lr_steps_per_epoch=10000 \
#         trainer.base_lr=0.0045 \
#         trainer.initialization.checkpoint=$pretrained_checkpoint \


# # # ----------------train on ONE dataset for linear probing: init and freeze------------------
# # pretrained_checkpoint=/apdcephfs_cq10/share_1603164/user/mingyuehuo/Auden/egs/spkid/exp/0618_emotion_init_CE/averaged_epoch40_avg5.pt
# export CUDA_VISIBLE_DEVICES=0,1,2,3
# torchrun --nproc_per_node=1 \
#         train.py \
#         exp_dir=exp/lp_veri \
#         model.id2label_json=configs/emotion/id2label_emotion_CREMA.json \
#         +model.config_preset=large \
#         data.train_data_config=configs/emotion/train_data_config_CREMA.yaml \
#         data.max_duration=300 \
#         data.use_infinite_dataset=true \
#         data.valid_sets='[/apdcephfs_cq10/share_1603164/user/mingyuehuo/process_data/emotion_manifests_norm/CREMA_valid_norm.jsonl.gz]' \
#         trainer.use_fp16=false \
#         trainer.lr_steps_per_epoch=10000 \
#         trainer.base_lr=0.0045 \
#         trainer.initialization.checkpoint=$pretrained_checkpoint \
#         trainer.freeze_modules='[encoder_embed, encoder]' \
#         trainer.save_every_n=1 \
