##########################################################################################
# Machine Environment Config

DEBUG_MODE = False
USE_CUDA = not DEBUG_MODE
CUDA_DEVICE_NUM = 0

##########################################################################################
# Train Params
env_params = {
    'graph_size': 50, 
    'group_size': 50, 
    'tunnel_per_graph': 18,
    'node_dim': 2, 
    'data_distribution': 'uniform', # or normals
}
#
lower_params = {
    'encoder_type': 'revmha',
    'decoder_type': 'decoder',
    'lower_solver_size': 100,
    'embedding_dim': 256, 
    'mid_dim': 64,
    'data_augment':True, 
    'n_layers': 6, 
    'n_heads': 8, 
    'embedding_dim': 256, 
    'multi_pointer':8, 
    'tanh_clipping':10, 
    'add_init_projection': True,
    'val_type': 'noAug_nTraj',
    'ff_hidden_rate': 4,
}

optimizer_params = {
    'learning_rate': 1e-4,
    'weight_decay': 1e-6,
    'lr_actor':3e-4,
    'lr_critic':3e-4,
    'lr_enc':3e-4,
    'lr_lower':3e-4,
}

running_params = {
    'use_cuda': USE_CUDA, 
    'start_from_ckpt': False,
    'cuda_device_num': CUDA_DEVICE_NUM,
    'total_epoch': 500, 
    'train_size': 10000, 
    'train_batch_size':100, 
    'eval_size': 1000,
    'divide_std': True,
    'log_per_epoch': 1,
    'saveckpt_per_epoch': 20,
}

logger_params = {
    'log_file': {
        'desc': 'train__tsp_n20',
        'filename': 'run_log'
    }
}