# DET: LEARN TO SOLVE THE TUNNEL TRAVELING SALESMAN PROBLEM USING DOUBLE-ENCODER TRANSFORMER
This is the supplementary materials for the submission DET: LEARN TO SOLVE THE TUNNEL TRAVELING SALESMAN PROBLEM USING DOUBLE-ENCODER TRANSFORMER

We provide the code to learn to solve tunnel TSPs for training.

## Code Running
We have provided the code for all the models used in the paper.

You can create the environment and run the training code using the following code. DET-POMO and DET-POMO-Regret can share the same environment.

For DET-POMO:
```
conda create -n POMO python==3.7
conda activate POMO
python NEWTWDE_2Encoder.py
```

For DET-InViT:
```
conda create -n InViT python==3.9
conda activate InViT
python train.py
```

For DET-POMO-Regret:
```
conda creste -n Regret python==3.7
conda activate Regret
python train_n100.py
```

## About Single-Encoder Models
We can also provide a quick solution to eliminate the impact of the tunnel encoder, which is to remove the influence of the tunnel (delete the information from tunnels) when calculating the score. The corresponding code location for this calculation are as follows:

> POMO: lines 216-226 in DET-POMO/NEWTWDE_Model.py
>
> InViT: lines 131-159 in DET-InViT/TSP_net.py
>
> POMO-Regret: lines 383-394 in DET-POMO-Regret/TSPModel.py
