import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm, colors
from mpl_toolkits.mplot3d import Axes3D

rs = np.random.RandomState(42)
g = np.array([2, 1.5, 3])
n_samples = 10000
u = rs.randn(n_samples, 3)
u/= np.linalg.norm(u, axis=1, keepdims=True)
ghat = 3 * u @ g[:, None] * u

fig = plt.figure()
ax = fig.add_subplot(projection='3d')
rs = np.random.RandomState(42)

ax.view_init(28, -25)
ax.scatter(ghat[:, 0], ghat[:, 1], ghat[:, 2], c='b', alpha=0.025, s=1)
ax.scatter(ghat[:, 0], ghat[:, 1], np.zeros_like(ghat[:, 2]), c='gray', alpha=0.025, s=1)
ax.quiver(0, 0, 0, g[0], g[1], g[2], color='r', alpha=1)
ax.quiver(0, 0, 0, g[0], g[1], 0, color='black', alpha=0.7)
ax.set_zlim(0,10.8)
ax.set_xlim(-5,10)
ax.set_ylim(-5,10)
ax.xaxis.set_pane_color((1.0, 1.0, 1.0, 0.0))
ax.yaxis.set_pane_color((1.0, 1.0, 1.0, 0.0))
ax.set_xticks([])
ax.set_yticks([])
ax.set_zticks([])
plt.savefig('./result/3d_with_projection.pdf', bbox_inches='tight', pad_inches=0.0, format='pdf')
