This folder contains the code to generate the figures and experiments from the paper: *"Zeroth-Order Hard-Thresholding: Gradient Error vs. Expansivity"*.
The dependencies are: `numpy`, `matplotlib`, `scipy`, `tensorflow`, `numba`, `keras` and `pillow`.
To obtain Figures 2, 6, 10 and 5 (synthetic examples), run the following scripts with python (or pdflatex for `fig.tex`)): 
- Figure 2: `sensitivity.py`
- Figure 6: `rhogamma.py`
- Figure 10:
  - (Figure 7): `s2d.py`
  - (Figure 8): `s2dk.py`
  - (Figure 9) `s2.py`
- Figure 5:
  - (a) `fig.tex`
  - (b) `3d.py`

We also provide the code for executing SZOHT on real-life examples (adversarial attacks and asset management), as in Figures 3, 4 and 11:
- adversarial attacks on CIFAR: `cd Demos/demo_adv_attacks; python main_CIFAR.py` (to use it on other datasets: for MNIST, the pre-trained model can be obtained by training a DNN from scratch with this [script](https://github.com/huanzhang12/ZOO-Attack/blob/master/train_models.py). For Imagenet, the pre-trained model can be downloaded from [here](http://download.huan-zhang.com/datasets/adv/img.tar.gz). To use the code on MNIST and Imagenet, `setup_mnist.py` and `setup_inception.py` from [here](https://github.com/huanzhang12/ZOO-Attack) are also needed, which will download the corresponding dataset.)
- asset management on port4: `cd Demos/demo_asset_risk; python main_port4.py` (to use it on the other datasets: port3.txt and port5.txt can be downloaded from [here](http://people.brunel.ac.uk/~mastjjb/jeb/orlib/files/))
