This is the reference implementation for the paper "Asynchronous Neural Networks for Learning in Graphs"
This paper and the repository contains three sets of experiments. The core of the codebase is copied from
DropGNN: https://github.com/KarolisMart/DropGNN

You can install the required packages with conda from the environment.yml file with the command
`conda env create -f environment.yml`

1. The first set of experiments experiment on synthetic graphs that beyond 1-WL expressiveness. You can run these
datasets with the following command
`python main_synthetic.py --dataset=<dataset> --model=<model>`
dataset can be one of (limitsone, limitstwo, triangles, lcc, maxlimit, meanlimit, fourcycles, skipcircles, rookshrikande)
model can be one of
    * none, ports, ids, random, dropout, (from https://github.com/KarolisMart/DropGNN)
    * smp, ppgn, from https://github.com/cvignac/SMP
    * ds, dss, from https://github.com/beabevi/ESAN . Additionally you need to seed another flag
        --permutation=node|edge|egonets   (this defines the permutation performed on the subgraphs)
    * ampc, ampr


2. The second set of experiments targets the long-range information propagation on shortest path parity graphs. They can
be run with the following command:
`python main_synthetic.py --dataset=<dataset> --model=<model>`
dataset can be one of (oddeven, multioddeven) --- multioddeven does three executions in parallel
model can be one of amprnn, ampgru, amplstm, ampatt, ampact, ampiter, itergnn, universal, neg
After running all experiments `python plot_longrange` generates all table bodys and plots.


3. The third set of experiments runs models on several graph classification benchmarks with the following command:
`python main_graph_classification.py --dataset=<dataset> --model=<model> --seed=seed`
dataset can be on of (MUTAG, PTC|GINPTC*, PROTEINS, IMDB-BINARY, IMDB-MULTI)
    * We believe there is a mismatch between the dataset DropGNN used and the original GIN dataset. We make the GIN
     dataset (that also ESAN uses) available as GINPTC
model can be one of (gin, gcn, gat, sage**, dropgnn, amp)
    ** sage takes an additional parameter --aggr to specify the aggregation strategy - can be one of 'add' 'mean' 'max'

Runs are for one single seed (to keep the runtime for AMP acceptable) you can merge runs with different seeds with `python merge.py`. For GNNs, we would recommend running all seeds at once (comment out the "continue" in line 381 in the main file) - the final results is available via printing
