from os import listdir
from collections import defaultdict
from ast import literal_eval
import torch

results = defaultdict(list)
new_or_old = True

for f in listdir('result'):
    dataset, model, hidden, messages, extra, seed = f.split('_')
    with open("result/" + f, "r") as res:
        results[dataset+model+messages+hidden+extra].append(literal_eval(res.readline()))

for dataset in sorted(results.keys()):
    tensors = [torch.tensor(r) for r in results[dataset]]
    combined = torch.stack(tensors, dim=0)
    acc_mean = combined.mean(dim=0)
    best_epoch = acc_mean.argmax().item()
    print(dataset)
    print('Mean: {:1f}, Std: {:1f}'.format(combined[:,best_epoch].mean()*100,
                                           combined[:,best_epoch].std()*100), flush=True)
