(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   3870121,      68809]
NotebookOptionsPosition[   3861443,      68666]
NotebookOutlinePosition[   3861931,      68684]
CellTagsIndexPosition[   3861888,      68681]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Deterministic", "Title",
 CellChangeTimes->{{3.842070073962578*^9, 
  3.8420700767767477`*^9}},ExpressionUUID->"5456db10-a9f9-4cc5-a909-\
0594ca62e42e"],

Cell[BoxData["Quit"], "Input",
 CellLabel->
  "In[328]:=",ExpressionUUID->"5de380ec-5a95-4971-aa0e-aff680691f81"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb1", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<Common.nb\>\""}], 
      "}"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb1", ",", "All", ",", "Notebook"}], "]"}], "\n", 
 RowBox[{"SelectionEvaluate", "[", "nb1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetSelectedNotebook", "[", 
   RowBox[{"EvaluationNotebook", "[", "]"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8108743602905073`*^9, 3.810874388830778*^9}, {
  3.842070948026979*^9, 3.842070948196617*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"1cbe9e6b-6665-4c6b-b908-7ef240d92def"],

Cell[BoxData[{
 RowBox[{"<<", "MaTeX`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.8461426895663347`*^9},
 CellLabel->"In[5]:=",ExpressionUUID->"04f50bba-1a0a-4c24-b0b3-e05412e59d72"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"threshold", "=", 
    RowBox[{"10", "^", 
     RowBox[{"-", "3"}]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"requires", " ", "\[Gamma]"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EG", "[", 
    RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"V", ",", "\[IndentingNewLine]", 
       RowBox[{"iterates", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Q", "[", "zstart", "]"}], ",", 
          RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Hzdiffs", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Q", "[", "zstart", "]"}], ",", 
          RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"zbar", "=", 
        RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", "Hz",
        ",", "Hzbar", ",", "Hzdiff"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"V", "[", "vec_", "]"}], ":=", 
       RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Norm", "[", 
            RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"iterates", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
           RowBox[{
            RowBox[{"Hzdiffs", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "Hzdiff"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"iterates", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Hz", "=", 
            RowBox[{"z", "-", 
             RowBox[{"\[Gamma]", "*", 
              RowBox[{"V", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"zbar", "=", 
            RowBox[{"Q", "[", "Hz", "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Hzbar", "=", 
            RowBox[{"zbar", "-", 
             RowBox[{"\[Gamma]", "*", 
              RowBox[{"V", "[", "zbar", "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Hzdiff", "=", 
            RowBox[{"Hzbar", "-", "Hz"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Hzdiffs", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "Hzdiff"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"z", "=", 
            RowBox[{"z", "+", 
             RowBox[{"(", "Hzdiff", ")"}]}]}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"iterates", ",", "Hzdiffs"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"requires", " ", "\[Gamma]", " ", "and", " ", "\[Alpha]"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EGPlus", "[", 
    RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"V", ",", "\[IndentingNewLine]", 
       RowBox[{"iterates", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Q", "[", "zstart", "]"}], ",", 
          RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Hzdiffs", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Q", "[", "zstart", "]"}], ",", 
          RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"zbar", "=", 
        RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", "Hz",
        ",", "Hzbar", ",", "Hzdiff"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"V", "[", "vec_", "]"}], ":=", 
       RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Norm", "[", 
            RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"iterates", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
           RowBox[{
            RowBox[{"Hzdiffs", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "Hzdiff"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"iterates", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Hz", "=", 
            RowBox[{"z", "-", 
             RowBox[{"\[Gamma]", "*", 
              RowBox[{"V", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"zbar", "=", 
            RowBox[{"Q", "[", "Hz", "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Hzbar", "=", 
            RowBox[{"zbar", "-", 
             RowBox[{"\[Gamma]", "*", 
              RowBox[{"V", "[", "zbar", "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Hzdiff", "=", 
            RowBox[{"Hzbar", "-", "Hz"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Hzdiffs", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "Hzdiff"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"z", "=", 
            RowBox[{"z", "+", 
             RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", 
              RowBox[{"(", "Hzdiff", ")"}]}]}]}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"iterates", ",", "Hzdiffs"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"requires", " ", "\[Sigma]"}], ",", 
    RowBox[{"\[Gamma]", " ", "and", " ", "\[Lambda]"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AdaptiveEGPlus", "[", 
    RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"\[Alpha]", ",", "V", ",", "\[IndentingNewLine]", 
       RowBox[{"iterates", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Q", "[", "zstart", "]"}], ",", 
          RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Hzdiffs", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Q", "[", "zstart", "]"}], ",", 
          RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"zbar", "=", 
        RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", "Hz",
        ",", "Hzbar", ",", "Hzdiff"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"V", "[", "vec_", "]"}], ":=", 
       RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Norm", "[", 
            RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"iterates", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
           RowBox[{
            RowBox[{"Hzdiffs", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "Hzdiff"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"iterates", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Hz", "=", 
            RowBox[{"z", "-", 
             RowBox[{"\[Gamma]", "*", 
              RowBox[{"V", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"zbar", "=", 
            RowBox[{"Q", "[", "Hz", "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Hzbar", "=", 
            RowBox[{"zbar", "-", 
             RowBox[{"\[Gamma]", "*", 
              RowBox[{"V", "[", "zbar", "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Hzdiff", "=", 
            RowBox[{"Hzbar", "-", "Hz"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Hzdiffs", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "Hzdiff"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"\[Alpha]", "=", 
            RowBox[{"Evaluate", "@", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Sigma]", "/", "\[Gamma]"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"zbar", "-", "z"}], ")"}], ".", 
                  RowBox[{"(", "Hzdiff", ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"Total", "[", 
                  RowBox[{
                   RowBox[{"(", "Hzdiff", ")"}], "^", "2"}], "]"}], ")"}]}]}],
               ")"}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"z", "=", 
            RowBox[{"z", "+", 
             RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", 
              RowBox[{"(", "Hzdiff", ")"}]}]}]}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"iterates", ",", "Hzdiffs"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Linesearch", "[", 
     RowBox[{
     "W_", ",", "z_", ",", "\[Gamma]0_", ",", "\[Nu]_", ",", "\[Tau]_"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"V", ",", "G", ",", "\[Gamma]", ",", "i"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Gamma]", "=", "\[Gamma]0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"i", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"V", "[", "vec_", "]"}], ":=", 
        RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"G", "[", "vec_", "]"}], ":=", 
        RowBox[{"Q", "[", 
         RowBox[{"z", "-", 
          RowBox[{"\[Gamma]", "*", 
           RowBox[{"V", "[", "z", "]"}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Gamma]", "*", 
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"V", "[", 
              RowBox[{"G", "[", "z", "]"}], "]"}], "-", 
             RowBox[{"V", "[", "z", "]"}]}], "]"}]}], ">", 
          RowBox[{"\[Nu]", "*", 
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"G", "[", "z", "]"}], "-", "z"}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Gamma]", "*=", "\[Tau]"}], ";", 
          RowBox[{"i", "++"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"\[Gamma]", ",", "i"}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"requires", " ", "\[Lambda]", " ", "and", " ", "\[Tau]"}], ",", 
    " ", "\[Nu]"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CurvatureEGPlus", "[", 
    RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "J", ",", "\[Alpha]", ",", "\[Sigma]", ",", "\[Gamma]", ",", "i", ",", 
       "\[Gamma]0", ",", "Lips", ",", "V", ",", "\[IndentingNewLine]", 
       RowBox[{"iterates", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Q", "[", "zstart", "]"}], ",", 
          RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Hzdiffs", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Q", "[", "zstart", "]"}], ",", 
          RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"zbar", "=", 
        RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", "Hz",
        ",", "Hzbar", ",", "Hzdiff"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"linesearchSteps", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"V", "[", "vec_", "]"}], ":=", 
       RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"J", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
       RowBox[{"Evaluate", "@", 
        RowBox[{"(", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"W", "[", 
            RowBox[{"x", ",", "y"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Lips", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
       RowBox[{"Evaluate", "@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"SingularValueList", "[", 
           RowBox[{
            RowBox[{"J", "[", 
             RowBox[{"x", ",", "y"}], "]"}], ",", "1"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Norm", "[", 
            RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"iterates", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
           RowBox[{
            RowBox[{"Hzdiffs", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "Hzdiff"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"\[Gamma]0", "=", 
            RowBox[{"\[Nu]", "/", 
             RowBox[{"Re", "[", 
              RowBox[{"Lips", "[", 
               RowBox[{
                RowBox[{"z", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{"z", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Gamma]", ",", 
              RowBox[{"linesearchSteps", "[", 
               RowBox[{"[", "n", "]"}], "]"}]}], "}"}], "=", 
            RowBox[{"Linesearch", "[", 
             RowBox[{
             "W", ",", "z", ",", "\[Gamma]0", ",", "\[Nu]", ",", "\[Tau]"}], 
             "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"\[Sigma]", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "\[Gamma]"}], "/", "2"}], "*", "0.99"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"iterates", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Hz", "=", 
            RowBox[{"z", "-", 
             RowBox[{"\[Gamma]", "*", 
              RowBox[{"V", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"zbar", "=", 
            RowBox[{"Q", "[", "Hz", "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Hzbar", "=", 
            RowBox[{"zbar", "-", 
             RowBox[{"\[Gamma]", "*", 
              RowBox[{"V", "[", "zbar", "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Hzdiff", "=", 
            RowBox[{"Hzbar", "-", "Hz"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Hzdiffs", "[", 
             RowBox[{"[", "n", "]"}], "]"}], "=", "Hzdiff"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"\[Alpha]", "=", 
            RowBox[{"Evaluate", "@", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Sigma]", "/", "\[Gamma]"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"zbar", "-", "z"}], ")"}], ".", 
                  RowBox[{"(", "Hzdiff", ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"Total", "[", 
                  RowBox[{
                   RowBox[{"(", "Hzdiff", ")"}], "^", "2"}], "]"}], ")"}]}]}],
               ")"}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"z", "=", 
            RowBox[{"z", "+", 
             RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", 
              RowBox[{"(", "Hzdiff", ")"}]}]}]}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"iterates", ",", "Hzdiffs"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"numTotalIterates", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"plotIterates", "[", 
     RowBox[{"W_", ",", "iterates_", ",", "legends_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"Length", "[", "iterates", "]"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"iteratesReduces", "=", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ArrayResample", "[", 
            RowBox[{"#", ",", "numTotalIterates"}], "]"}], "&"}], ",", 
          "iterates"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"legend", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "legends", "]"}], "\[NotEqual]", "0"}], ",", 
          RowBox[{
           RowBox[{"ListLinePlot", "[", 
            RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
             RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Joined", "\[Rule]", "True"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"PlotLegends", "\[Rule]", 
              RowBox[{"Placed", "[", 
               RowBox[{"legends", ",", "Below"}], "]"}]}]}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", 
          StyleBox[
           RowBox[{"{", "}"}],
           FontWeight->"Plain"]}], 
         StyleBox["]",
          FontWeight->"Plain"]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"lines", "=", 
        RowBox[{"ListLinePlot", "[", 
         RowBox[{"iterates", ",", 
          RowBox[{"PlotLegends", "\[Rule]", "legend"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"markers", "=", 
        RowBox[{"ListLinePlot", "[", 
         RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
          RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Joined", "\[Rule]", "False"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Show", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"plotFlow", "[", 
          RowBox[{"W", ",", "side"}], "]"}], ",", "\[IndentingNewLine]", 
         "lines", ",", "\[IndentingNewLine]", "markers", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"legends", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<CEG\>\"", ",", "\"\<CEG+\>\"", ",", "\"\<AdaptiveEG+\>\"", ",", 
     "\"\<CurvatureEG+\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotAllDeteterministicMethods", "[", "W_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"EGPlusIterates", "=", 
      RowBox[{"EGPlus", "[", 
       RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"EGIterates", "=", 
      RowBox[{"EG", "[", 
       RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CurvatureEGPlusIterates", "=", 
      RowBox[{"CurvatureEGPlus", "[", 
       RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AdaptiveEGPlusIterates", "=", 
      RowBox[{"AdaptiveEGPlus", "[", 
       RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"iterates", "=", 
      RowBox[{"Map", "[", 
       RowBox[{"First", ",", 
        RowBox[{"{", 
         RowBox[{
         "EGIterates", ",", "EGPlusIterates", ",", "AdaptiveEGPlusIterates", 
          ",", "CurvatureEGPlusIterates"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"plotIterates", "[", 
      RowBox[{"W", ",", "iterates", ",", "legends"}], "]"}]}]}], 
   "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.842069908505763*^9, 3.842069926770582*^9}, {
   3.842069961044794*^9, 3.8420699942043753`*^9}, {3.842070025929253*^9, 
   3.84207003030805*^9}, {3.842076073782155*^9, 3.842076077121072*^9}, {
   3.84207670372499*^9, 3.8420767443392277`*^9}, {3.8420771076473827`*^9, 
   3.842077124153285*^9}, {3.8420775118301497`*^9, 3.84207751417109*^9}, {
   3.842077751684244*^9, 3.842077755121297*^9}, {3.842078219786165*^9, 
   3.842078220612997*^9}, 3.842078278904468*^9, {3.8420786380882177`*^9, 
   3.842078656480147*^9}, {3.842078688768298*^9, 3.842078817453376*^9}, {
   3.8420790463322287`*^9, 3.842079047747064*^9}, {3.842079125264635*^9, 
   3.842079146257187*^9}, {3.842079330253166*^9, 3.842079374564219*^9}, {
   3.842079413423921*^9, 3.8420794329380074`*^9}, {3.842079606542272*^9, 
   3.842079632204604*^9}, {3.84207976776322*^9, 3.842079768964768*^9}, {
   3.8420798189555283`*^9, 3.8420798990252934`*^9}, {3.842080017988669*^9, 
   3.842080075028363*^9}, {3.84208047357727*^9, 3.8420804737237997`*^9}, {
   3.84208065027213*^9, 3.842080663504405*^9}, {3.842080848386829*^9, 
   3.8420809261091833`*^9}, {3.842080963597786*^9, 3.842081008996512*^9}, {
   3.84208108925989*^9, 3.842081090746418*^9}, {3.842081225161275*^9, 
   3.842081237183427*^9}, {3.842081337507799*^9, 3.842081355032723*^9}, {
   3.842081452190667*^9, 3.842081473636014*^9}, {3.842082344528778*^9, 
   3.842082344713876*^9}, {3.842084103813345*^9, 3.842084105871266*^9}, 
   3.842084256300619*^9, {3.842102996568274*^9, 3.842102999477243*^9}, {
   3.842103185251973*^9, 3.842103185723213*^9}, {3.842103251538865*^9, 
   3.8421032555502853`*^9}, {3.842103334849203*^9, 3.842103364781497*^9}, {
   3.842103441466267*^9, 3.842103446165299*^9}, {3.842103493683999*^9, 
   3.8421034938157043`*^9}, {3.8421476534505167`*^9, 3.842147656354602*^9}, {
   3.8422435386828957`*^9, 3.842243558836317*^9}, {3.842243593481468*^9, 
   3.8422436148803883`*^9}, {3.8422436477524223`*^9, 3.842243680780398*^9}, {
   3.842243737765085*^9, 3.8422437425588417`*^9}, {3.8422448121176853`*^9, 
   3.8422448153172407`*^9}, {3.842244849857335*^9, 3.842244867679373*^9}, 
   3.842244899401927*^9, {3.8422449975711727`*^9, 3.842245041701214*^9}, {
   3.842246662363735*^9, 3.842246662777418*^9}, {3.842246788485887*^9, 
   3.842246791175125*^9}, {3.8422469422032423`*^9, 3.8422469786876802`*^9}, {
   3.842247009096758*^9, 3.842247049973588*^9}, {3.842247080558751*^9, 
   3.842247120196384*^9}, {3.842247158785543*^9, 3.842247165822761*^9}, {
   3.8422473886738787`*^9, 3.8422474735204678`*^9}, {3.8422478875769176`*^9, 
   3.84224794015978*^9}, {3.842247972926413*^9, 3.842247974353508*^9}, {
   3.842248184542603*^9, 3.8422484466171093`*^9}, {3.8422484920842867`*^9, 
   3.842248501456633*^9}, {3.8422486436720448`*^9, 3.8422486451323967`*^9}, {
   3.842248678363942*^9, 3.8422486792876053`*^9}, {3.842248979059058*^9, 
   3.842249000277972*^9}, {3.842249108698155*^9, 3.842249117908152*^9}, {
   3.8422523467282352`*^9, 3.8422523815456877`*^9}, {3.842252447456657*^9, 
   3.842252472010071*^9}, {3.84225262285277*^9, 3.842252624604828*^9}, {
   3.842252688435546*^9, 3.842252729619727*^9}, {3.842253136394267*^9, 
   3.842253185736291*^9}, {3.8422538985632277`*^9, 3.842254028985124*^9}, {
   3.8422541060771112`*^9, 3.842254200351254*^9}, {3.8422545976250134`*^9, 
   3.842254631941186*^9}, {3.842256386115899*^9, 3.842256421322956*^9}, 
   3.8422566730798683`*^9, {3.842256723075224*^9, 3.842256729715376*^9}, {
   3.842258205527823*^9, 3.842258207129943*^9}, {3.8422591158442583`*^9, 
   3.842259131675467*^9}, {3.842259823086475*^9, 3.8422598309567947`*^9}, {
   3.8422598778604937`*^9, 3.842259885835726*^9}, {3.842259920715208*^9, 
   3.842259922330418*^9}, {3.842259956175989*^9, 3.842260008364979*^9}, {
   3.842260743125742*^9, 3.8422607447016487`*^9}, {3.8422610901541567`*^9, 
   3.8422611305036907`*^9}, {3.842261218484199*^9, 3.8422612540655317`*^9}, 
   3.842269291125626*^9, {3.842325084559558*^9, 3.842325086261828*^9}, {
   3.842431799622961*^9, 3.842431800201025*^9}, {3.8462474872329617`*^9, 
   3.846247519957283*^9}, {3.846568465828855*^9, 3.846568469463748*^9}, {
   3.8465693989112473`*^9, 3.846569416041548*^9}, {3.8465694572775087`*^9, 
   3.846569458618218*^9}, {3.846569514934112*^9, 3.846569533514154*^9}, {
   3.8465695865199327`*^9, 3.846569629162483*^9}, {3.846569920361495*^9, 
   3.8465699206573963`*^9}, {3.846569965567026*^9, 3.8465699695555363`*^9}, {
   3.846570874833755*^9, 3.846570919117766*^9}, 3.850190240190556*^9, {
   3.8501903193964367`*^9, 3.850190403851899*^9}, {3.8501904502665777`*^9, 
   3.8501904603678503`*^9}, {3.8501905250470123`*^9, 3.850190573458688*^9}, {
   3.850190613843788*^9, 3.850190624801569*^9}, {3.8501941144455233`*^9, 
   3.850194118291656*^9}, 3.850194165247427*^9, {3.85019441196485*^9, 
   3.850194463057474*^9}, {3.85468730416439*^9, 3.854687304506547*^9}, {
   3.854687439285182*^9, 3.8546874849834213`*^9}, {3.854687569795597*^9, 
   3.8546875709575567`*^9}, {3.854688273069387*^9, 3.8546882900339727`*^9}, {
   3.8546883394918423`*^9, 3.8546883409876842`*^9}, {3.854689730501114*^9, 
   3.8546897529585867`*^9}, {3.854689786447074*^9, 3.854689792843731*^9}},
 CellLabel->
  "In[275]:=",ExpressionUUID->"cb787e10-0a13-4d00-81a9-4db836ecde03"],

Cell[CellGroupData[{

Cell["Forsaken", "Chapter",
 CellChangeTimes->{{3.842254991342189*^9, 
  3.84225499239752*^9}},ExpressionUUID->"7bb35a59-a623-41d4-a1c7-\
cbcffd38cf99"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"boundary", "=", 
   RowBox[{"3", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"side", "=", 
   RowBox[{"3", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{"y", "\[Element]", "Reals"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Q", "[", "z_", "]"}], ":=", 
    RowBox[{"Clip", "[", 
     RowBox[{"z", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "boundary"}], ",", "boundary"}], "}"}]}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"phi", "[", "z_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["z", "2"], "/", "4"}], "-", 
   RowBox[{
    SuperscriptBox["z", "4"], "/", "2"}], "+", 
   RowBox[{
    SuperscriptBox["z", "6"], "/", "6"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Forsaken", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"y", "-", "0.45"}], ")"}]}], "+", 
   RowBox[{"phi", "[", "x", "]"}], "-", 
   RowBox[{"phi", "[", "y", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"W", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
    RowBox[{"Evaluate", "@", 
     RowBox[{"getW", "[", "Forsaken", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"padding", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"initialPointData", "=", 
   RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"-", "boundary"}], "+", "padding"}], ",", 
         RowBox[{"boundary", "-", "padding"}], ",", "0.75"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{
          RowBox[{"-", " ", "boundary"}], "+", "padding"}], ",", 
         RowBox[{"boundary", "-", "padding"}], ",", "0.75"}], "}"}]}], "]"}], 
     ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "initialPointData", "]"}]}], "Input",
 CellChangeTimes->{{3.8422550968517227`*^9, 3.842255119845605*^9}, {
   3.842255327640332*^9, 3.842255345671736*^9}, {3.842255790630328*^9, 
   3.84225580267626*^9}, {3.842258066529896*^9, 3.842258148266314*^9}, {
   3.8422582821830072`*^9, 3.8422582965165863`*^9}, 3.84225906427493*^9, {
   3.8422592662545357`*^9, 3.842259271953205*^9}, {3.842259324140627*^9, 
   3.8422593704495373`*^9}, {3.842260030892354*^9, 3.842260079634514*^9}, {
   3.842260116975806*^9, 3.8422601527128983`*^9}, 3.8422613535408*^9, {
   3.8461470058330708`*^9, 3.846147006863482*^9}, {3.8462150191280737`*^9, 
   3.846215026011571*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"f3033ba4-a454-4ace-a66b-07cb7b279915"],

Cell[BoxData["16"], "Output",
 CellChangeTimes->{
  3.842258296846727*^9, 3.842259064803944*^9, {3.842259272472679*^9, 
   3.842259277419405*^9}, {3.842259324703802*^9, 3.842259370789962*^9}, 
   3.842260032936039*^9, {3.8422600709072323`*^9, 3.842260080275134*^9}, {
   3.8422601269754467`*^9, 3.842260153063032*^9}, 3.842261353984456*^9, 
   3.842323345695924*^9, 3.842431558805439*^9, {3.8461426745440607`*^9, 
   3.846142674803009*^9}, 3.846147007587738*^9, 3.8462147753829727`*^9, {
   3.846215020734768*^9, 3.84621502639184*^9}, 3.846298103646503*^9, 
   3.846298842180579*^9, 3.846298879091235*^9, {3.8465751483652287`*^9, 
   3.8465751652585783`*^9}, 3.8499382223301573`*^9, 3.850196271502496*^9, 
   3.854687172661141*^9, 3.8546874929990873`*^9, 3.854687851637327*^9, 
   3.854688293182974*^9, {3.8546883589372272`*^9, 3.854688363191389*^9}},
 CellLabel->"Out[42]=",ExpressionUUID->"55a424c7-7d77-4980-9395-86c2dd9dd813"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"plotFlow", "[", 
    RowBox[{"W", ",", "side"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"initialPointData", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.842256020318223*^9, 3.842256021867135*^9}, {
  3.842259283927796*^9, 3.842259286053268*^9}, {3.8422613564053583`*^9, 
  3.842261367456438*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"a68cf950-7433-4665-ab51-9a16a5526102"],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.12702486321737294`, 
        0.6825502504445621}, {-0.15859867017162593`, 
        0.6835370446319317}, {-0.21401826075772262`, 
        0.6657984934378398}, {-0.23802224083322843`, 
        0.6414453595762438}, {-0.2547094630415601, 
        0.6057462889216412}, {-0.26181673868907707`, 
        0.5584941055939887}, {-0.2598446627503448, 0.5297250019187422}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.25943433527913057`, 
        0.5237390490817774}, {-0.25791901982696025`, 
        0.5016332738994}, {-0.2514094962393709, 
        0.4708056979947869}, {-0.24162817456587132`, 
        0.4390232596947784}, {-0.22880215066296467`, 
        0.4068867115491709}, {-0.2131585203871542, 
        0.37499680610776115`}, {-0.1947649412367179, 
        0.3442157824300341}, {-0.17381662139651394`, 
        0.31519669036772385`}, {-0.1664612117240181, 0.3066032351256413}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1625596473328543, 
        0.30204496842637907`}, {-0.15073198275291547`, 
        0.2882264986590003}, {-0.1259294471922968, 
        0.26359217604203433`}, {-0.09312421598638322, 
        0.23687348261877464`}, {-0.05925305727019926, 
        0.21533294264796027`}, {-0.024882565713048088`, 0.1987566945120675}, {
        0.00942066401576676, 0.1869308765935728}, {0.03871921434798018, 
        0.1806674797169317}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.04462116781312979, 0.17964728019157275`}, {
        0.07457469463138554, 0.17717818734714275`}, {0.1326605419020214, 
        0.18386087956002034`}, {0.18176527201549197`, 0.20350306303247262`}, {
        0.22064189215386734`, 0.2331402276330914}, {0.24746186662247488`, 
        0.2679445395556307}, {0.2497000587374462, 0.27325633212580797`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.2520298576705231, 0.27878553070529793`}, {
        0.2640827492591745, 0.3073900725413197}, {0.2699164237139695, 
        0.3499818330252841}, {0.26481629075129015`, 0.3945048375436299}, {
        0.24879441673249453`, 0.4399353658958868}, {0.22242857105393876`, 
        0.4854271915566973}, {0.20967108126283837`, 0.5013500737350742}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.205919472064328, 0.5060325333901756}, {0.1864471706940415,
         0.5303363083128265}, {0.14240874353709157`, 0.5739692566770221}, {
        0.11043817119415812`, 0.6014632342016905}, {0.0763428778598409, 
        0.6280441725908175}, {0.0405953006151685, 0.6535369780130068}, {
        0.02591483228667488, 0.6631694278932763}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.020898292873663234`, 0.6664609825894192}, {
        0.0036678765411700814`, 0.6777665566368616}, {-0.034112768533399604`, 
        0.7004658123477601}, {-0.07242000877978581, 
        0.7213676490310804}, {-0.108990115518863, 
        0.7391070314723185}, {-0.14571321949913765`, 
        0.7544731640150639}, {-0.18246960303747548`, 
        0.7668806204092751}, {-0.19455150206311062`, 0.769800890586852}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.20038356016642644`, 
        0.7712105353220772}, {-0.21913954845074224`, 
        0.7757439744049112}, {-0.2555496205733008, 
        0.7802311967691231}, {-0.2915263842395138, 
        0.7795102582690621}, {-0.35115222665010254`, 
        0.763975204086384}, {-0.37961611811050056`, 
        0.7474902559589645}, {-0.40647719011729805`, 
        0.7240181274109208}, {-0.417374401781736, 0.7098760365817244}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.42103660916071356`, 
        0.705123328184046}, {-0.43087071219660067`, 
        0.692360909444301}, {-0.4516989216323925, 
        0.6519047525547086}, {-0.46779267834338545`, 
        0.6017281589184296}, {-0.477659532494593, 
        0.5426930463374974}, {-0.4796383972500232, 
        0.47892844596632655`}, {-0.47950853699933327`, 0.4768909347121198}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.479126902893057, 
        0.4709030840619343}, {-0.47748131385732473`, 
        0.4450837424058853}, {-0.47301551239650086`, 
        0.4103790799920948}, {-0.4661308214838271, 
        0.37522717015072293`}, {-0.4567170697355791, 
        0.3400407243075375}, {-0.4445118816650327, 
        0.305198765389597}, {-0.4296966848202046, 
        0.2712108247685608}, {-0.41427939553951076`, 0.24214757119325292`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4114676740648869, 
        0.2368471728733963}, {-0.4099070271751887, 
        0.2339051851172469}, {-0.38693055698156814`, 
        0.19863028723400758`}, {-0.36088900420012415`, 
        0.16579850923402806`}, {-0.33220394188972, 
        0.13570419882694174`}, {-0.2859200981409383, 
        0.09634687979356349}, {-0.24371150523839577`, 0.06892225244667696}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.23868024676819655`, 
        0.06565324063788083}, {-0.2359695645373219, 
        0.06389200092517092}, {-0.18382952089991417`, 
        0.03832230901691595}, {-0.13097714704975855`, 
        0.019620550863950557`}, {-0.07854983649523417, 
        0.007402771600997767}, {-0.027684982744720244`, 
        0.0012850163627805844`}, {-0.01374698247166773, 
        0.0004312801241994286}, {-0.010144885364869535`, 
        0.0003210699871842854}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.0041476917593834955`, 0.00013757922905909461`}, {
        7.858835603125435*^-6, 0.000010435571665048216`}, {
        0.027784663601900825`, 0.001734115412072282}, {0.054512219780927226`, 
        0.005060506629221975}, {0.10585056831251305`, 
        0.014687366698048904`}, {0.152901256405968, 0.029816154122576204`}, {
        0.19563731280240637`, 0.04958662793466012}, {0.2227673976968338, 
        0.06717883331732145}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.22780164720105012`, 0.0704432370805373}, {
        0.24751523587496227`, 0.08322629699834844}, {0.29165543283178064`, 
        0.12240642112923242`}, {0.3282430917194472, 0.16558267590259984`}, {
        0.3573911361416318, 0.21197258188845058`}, {0.3760074067150763, 
        0.2541499785204507}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.37843018431767456`, 0.2596390721330928}, {
        0.3789528101601851, 0.2608231437419974}, {0.3924855460736807, 
        0.3117917727010221}, {0.39741037663042156`, 0.3646795885397622}, {
        0.3928640291468017, 0.4196366228601952}, {0.38403958862784504`, 
        0.4580732189388927}, {0.37149971571979173`, 0.4942338166290146}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3693244847405995, 0.4998182265735086}, {
        0.3513555162027229, 0.53873618758482}, {0.32701701059027577`, 
        0.5811505919594641}, {0.2973590530197779, 0.6251957241046833}, {
        0.26266199871999385`, 0.6711490797112754}, {0.23874811937048498`, 
        0.7001019097700374}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.23492717980066, 0.7047279686546329}, {0.2229699337915496, 
        0.7192047545668148}, {0.20126454924802548`, 0.7440816166465566}, {
        0.17832694433507099`, 0.7695568444588757}, {0.15425710663255798`, 
        0.7954883861631994}, {0.129184093510295, 0.8216830164377178}, {
        0.10315702041576495`, 0.8480882370340226}, {0.07622500279645086, 
        0.8746515497037053}, {0.07089792746720876, 0.8797641183527483}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.06656902561252835, 0.883918707229225}, {
        0.04843715609983576, 0.9013204561983577}, {0.019842595773402638`, 
        0.9280424582695714}, {-0.009509562735365497, 
        0.9547650576689378}, {-0.03957020397898544, 
        0.9814357561480485}, {-0.07507834023038057, 
        1.0111080170875675`}, {-0.11133907169021579`, 
        1.0385780874480548`}, {-0.11471320695834412`, 1.0408815076481772`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.11966860598620498`, 
        1.0442644088401536`}, {-0.14835239835849143`, 
        1.0638459672295093`}, {-0.1861183202352074, 
        1.086911656431932}, {-0.22464605080695027`, 
        1.1071237367553661`}, {-0.2639448035603067, 
        1.1238307898998559`}, {-0.3040145784952764, 
        1.1370328158654006`}, {-0.3357504291718867, 1.1445679896923058`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3415881349254546, 
        1.1459540602297462`}, {-0.34485537561185997`, 
        1.146729814652001}, {-0.38684139527785816`, 
        1.153069722355517}, {-0.4303468378610722, 
        1.1562004750718096`}, {-0.475371703361502, 
        1.1561220728008779`}, {-0.5219159917791483, 
        1.1528345155427224`}, {-0.5619098502398333, 
        1.1478393873437205`}, {-0.5802350637267606, 1.1448204500925276`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.586155264373206, 
        1.1438451428046295`}, {-0.6039331499571183, 
        1.1409163735941097`}, {-0.6479858909310025, 
        1.13206547429389}, {-0.6940680731614851, 
        1.1212866894430618`}, {-0.7425460527256532, 
        1.108247617830295}, {-0.7937861857005939, 
        1.092615858244259}, {-0.8183747490453251, 1.0843178210086868`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-0.8240597449519063, 
        1.0823992742820845`}, {-0.8477884720863063, 
        1.074391410684955}, {-0.9045529118827895, 
        1.0535742751523827`}, {-0.9434425407039863, 
        1.0379540305662016`}, {-0.9824989640707504, 
        1.0206103037306546`}, {-1.0217221819830828`, 
        1.0015430946457415`}, {-1.0449277179140881`, 0.989294834117677}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0502339420114843`, 
        0.9864941224530795}, {-1.0611121944409831`, 
        0.9807524033114617}, {-1.0918031930785337`, 
        0.9628639277482297}, {-1.1211732493093378`, 
        0.9435930764373166}, {-1.1492223631333949`, 
        0.9229398493787231}, {-1.1759505345507038`, 
        0.9009042465724494}, {-1.2008123191506175`, 
        0.877391340047695}, {-1.2232622725224873`, 
        0.8523062018336595}, {-1.23509417379205, 0.8365658362176409}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.2386993641893929`, 
        0.8317697334040113}, {-1.243300394666313, 
        0.8256488319303427}, {-1.2609266855820955`, 
        0.7974192303377442}, {-1.276113087850166, 
        0.7676135662421681}, {-1.2888315440508564`, 
        0.7362280088299192}, {-1.2990820541841677`, 
        0.7032625581009968}, {-1.306864618250099, 
        0.6687172140554005}, {-1.3126230593539197`, 
        0.6322981735562658}, {-1.315262242998456, 0.6074972539828245}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3158971467590543`, 
        0.6015309404464121}, {-1.316632191388483, 
        0.5946235837813709}, {-1.3188920143537897`, 
        0.5556934447307162}, {-1.3194025282498396`, 
        0.5155077564043026}, {-1.3185807791559194`, 
        0.4744443882123609}, {-1.3168438131513167`, 
        0.43288120956512544`}, {-1.3141916302360308`, 
        0.3908182204625959}, {-1.3117651897935367`, 
        0.36186825599798217`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3112640571007375`, 
        0.35588922045500304`}, {-1.310624230410062, 
        0.34825542090477213`}, {-1.3063457497112008`, 
        0.30558743634821667`}, {-1.3015603241772369`, 
        0.2632088922494883}, {-1.2962679538081718`, 
        0.2211197886085884}, {-1.2904686386040043`, 
        0.179320125425517}, {-1.284229044831124, 
        0.1380334538038864}, {-1.2809400522772996`, 
        0.11786637135126747`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2799742883475627`, 
        0.11194460640895347`}, {-1.2776158387559198`, 
        0.09748332484730883}, {-1.2706290203783928`, 
        0.05766973855578446}, {-1.2632685896985416`, 
        0.018592694929314355`}, {-1.2555614158730555`, -0.019725635002736}, \
{-1.247534368058621, -0.057263080211001086`}, {-1.2391874462552397`, \
-0.09401964069547977}, {-1.2321618896601814`, -0.12318256920545072`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2307566494003601`, -0.12901569013786568`}, \
{-1.2305206504629107`, -0.12999531645617196`}, {-1.2215263009203952`, \
-0.1652984780103835}, {-1.2121967178664539`, -0.20003749587542008`}, \
{-1.202531901301088, -0.23421237005128187`}, {-1.192531851224296, \
-0.2678231005379676}, {-1.1770250402494915`, -0.3167806282224171}, \
{-1.1626397679407674`, -0.35905484901301915`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1607069018242615`, -0.3647349923717438}, \
{-1.160464940863989, -0.36544604676388504`}, {-1.1428515530677892`, \
-0.4138193561623707}, {-1.124184876860891, -0.46190055641787386`}, \
{-1.1040362131616845`, -0.5103060802808613}, {-1.0819768628885578`, \
-0.5596523605017997}, {-1.0691943989092314`, -0.5864688496794512}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.06661270552024, -0.5918850161507885}, \
{-1.0580068260415114`, -0.6099393970806891}, {-1.0321261026205455`, \
-0.6611671900175284}, {-1.0035151981848374`, -0.7136535338749181}, \
{-0.9713546182935635, -0.7677162232154584}, {-0.9539432000520901, \
-0.79533869744191}, {-0.9499677455445681, -0.8014253444495989}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9466867220739431, -0.8064487780348281}, \
{-0.9356443629467253, -0.8233552580391486}, {-0.9164581069774691, \
-0.851765905007175}, {-0.8963844321443216, -0.8805706383459886}, \
{-0.8662364443963907, -0.9212539947673799}, {-0.8334711411961713, \
-0.9617740021490844}, {-0.8020453809459256, -0.9976175523965282}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7980898887703322, -1.0021291022021734`}, \
{-0.7980885225436631, -1.0021306604911018`}, {-0.7600885884388654, \
-1.0423239697934332`}, {-0.7194033836014226, -1.0812955898806962`}, \
{-0.67596495275098, -1.1179871805775083`}, {-0.6297732958875359, \
-1.152398741883871}, {-0.6181662167447372, -1.160018603491648}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6131504676928355, -1.1633113624333788`}, \
{-0.5808284130110888, -1.184530273799785}, {-0.5296497638578531, \
-1.2136479968931089`}, {-0.4767568081640434, -1.2390181317317013`}, \
{-0.4221495459296582, -1.2606406783155633`}, {-0.398265306570969, \
-1.2682208965613548`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.39254641735623547`, -1.27003591891648}, \
{-0.3658279771546955, -1.2785156366446953`}, {-0.3198759127445309, \
-1.2902367233315322`}, {-0.273763781049976, -1.2997258909908216`}, \
{-0.22749158207103107`, -1.3069831396225633`}, {-0.1810593158076963, \
-1.3120084692267568`}, {-0.15719201870802005`, -1.3136721707497463`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.15120654271503536`, -1.3140893962731794`}, \
{-0.13477609810288127`, -1.3152347021538777`}, {-0.08895104479950026, \
-1.3170946607544016`}, {-0.043584155897551526`, -1.317588345028328}, {
        0.001324568602964954, -1.316715754975657}, {
        0.04572315922159654, -1.3148042473220074`}, {
        0.0885868965109439, -1.3122393857795664`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.09457030220037649, -1.311795068618714}, {
        0.13283403037184713`, -1.3088465493886308`}, {
        0.17554631090346767`, -1.3048003591089028`}, {
        0.2258604435395959, -1.2992543273464012`}, {
        0.27588381217998037`, -1.2930859408960527`}, {
        0.32561641682462283`, -1.2862951997578564`}, {
        0.333037592946179, -1.2851825006955033`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.33897126704302744`, -1.2842928312555484`}, {
        0.37505825747352456`, -1.2788821039318121`}, {
        0.42467524428619324`, -1.2708879233811174`}, {
        0.47493328742213636`, -1.2623539280689702`}, {
        0.5258323868813556, -1.2532801179953696`}, {
        0.5755486645284549, -1.2440066954719375`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5814408906959706, -1.242874792593873}, {
        0.6300420003060614, -1.2334170161931646`}, {
        0.6843290053444179, -1.2224356497232736`}, {
        0.7402335577789233, -1.2107223937506424`}, {
        0.7977556576095768, -1.198277248275271}, {
        0.8164260720849787, -1.194112865501307}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8222821696294482, -1.1928066796226284`}, {
        0.8326240967182723, -1.1904999422400688`}, {
        0.8678278305451337, -1.18239509670622}, {
        0.903360551060283, -1.173940914592348}, {
        0.939215950233843, -1.1651155988170765`}, {
        0.9753877200359355, -1.1558973522990281`}, {
        1.0118695524366832`, -1.1462643779568267`}, {
        1.0486551394062082`, -1.1361948787090954`}, {
        1.0550332203831818`, -1.1343841504597365`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.060805124227625, -1.1327455150486392`}, {
        1.0857381729146331`, -1.1256670574744574`}, {
        1.1227586831027647`, -1.1146564995551533`}, {
        1.1590030382820944`, -1.1031361726370412`}, {
        1.194046707272853, -1.091095259333493}, {
        1.227577428489352, -1.0785378483772043`}, {
        1.2592515048521271`, -1.0654632112094018`}, {
        1.2867725067758637`, -1.052784259734134}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.292089872179487, -1.0500134962801932`}, {
        1.3403004664001759`, -1.0231686287531958`}, {
        1.3814513738235554`, -0.9924773020912467}, {
        1.4121614257933512`, -0.9598483454732761}, {
        1.433334837492728, -0.9253186703041483}, {
        1.447230073669648, -0.8889127864731502}, {
        1.4492075879163826`, -0.8799240939831322}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.450496759793225, -0.874064227442676}, {
        1.455652464719626, -0.8506292275536925}, {
        1.4606313314681285`, -0.8104343500455208}, {
        1.4633494771691506`, -0.7682849050521277}, {
        1.464255182720192, -0.7241119497439177}, {
        1.4639902823107245`, -0.6894393797225671}, {
        1.4627862676155088`, -0.6536123260161593}, {
        1.4618231971017928`, -0.6350749174408312}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4615119000532364`, -0.6290829983703197}, {
        1.4608686298691977`, -0.6167011820276722}, {
        1.4584628603064445`, -0.5787763411600836}, {
        1.4556943936170472`, -0.5399501767826131}, {
        1.4526886644908041`, -0.5003350622644803}, {
        1.4494796288843441`, -0.4601587509433629}, {
        1.4460880570888128`, -0.4194801446141478}, {
        1.443508762317786, -0.38976920986011393`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4429898362116402`, -0.38379169234057786`}, {
        1.4425267260668602`, -0.378457119708535}, {
        1.4388084127811362`, -0.33724755265821915`}, {
        1.4349499180651881`, -0.29600328458824043`}, {
        1.430968042752563, -0.2548761566236338}, {
        1.426972404031183, -0.21493570168370535`}, {
        1.4228665842265633`, -0.17514578107471618`}, {
        1.419653889083354, -0.14493253665116915`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4190194617091572`, -0.13896617243945114`}, {
        1.4186643234865264`, -0.1356263354968864}, {
        1.414379361958896, -0.09649730565043621}, {
        1.4100254397914944`, -0.05787863223558566}, {
        1.4056162971321453`, -0.0198902559525548}, {1.40116567412867, 
        0.017347882498438688`}, {1.396687310928893, 0.05371584241716965}, {
        1.390883769529806, 0.09937432395986652}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.390119902915453, 0.10532549110051923`}, {
        1.3839749001930854`, 0.15221342566298188`}, {1.3775236373711879`, 
        0.2001289065807078}, {1.3710233468455082`, 0.24729854332704457`}, {
        1.3644653978349914`, 0.2939470996607394}, {1.3578300802841752`, 
        0.34036647736036746`}, {1.3574360740740383`, 0.3430874779355065}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3565762300004283`, 0.3490255473329687}, {
        1.3511115332306074`, 0.38676465567971907`}, {1.3443038957118352`, 
        0.43334961387258464`}, {1.3373509758095088`, 0.48042147442974314`}, {
        1.3301678210590504`, 0.5283330131202606}, {1.3227054296786669`, 
        0.5773711891153455}, {1.3213082638461155`, 0.5864191729843008}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3203926120720806`, 0.5923488931993452}, {
        1.3149147998865645`, 0.6278229615862082}, {1.3067284646278745`, 
        0.6799514741663553}, {1.2980684052631135`, 0.7340062616106046}, {
        1.2888697926335657`, 0.7902538697721349}, {1.2823483989182816`, 
        0.8293123771462457}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.2813602886636302`, 0.8352304543783079}, {
        1.2790677975805158`, 0.8489608445041247}, {1.2685571869004793`, 
        0.9099748285508031}, {1.2573276150883426`, 0.9722069627380749}, {
        1.2453203643286417`, 1.0353265904372007`}, {1.2380683722897203`, 
        1.0712806458096997`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.2368820536869904`, 1.0771621973203827`}, {
        1.2324767168059125`, 1.0990030550194405`}, {1.223235259643004, 
        1.141937639074281}, {1.215236948731389, 1.1761288391364895`}, {
        1.2069720427155735`, 1.2089312925176998`}, {1.1897385149115216`, 
        1.2688127731747936`}, {1.1754705117453528`, 1.3088965722577965`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.1734584525785159`, 1.3145491484765792`}, {
        1.171698527474471, 1.3194933921419398`}, {1.1530542197617244`, 
        1.3598711305934221`}, {1.131960157368948, 1.3932767228648308`}, {
        1.1105259252838013`, 1.4156941206752338`}, {1.067300436612837, 
        1.439792402508421}, {1.0233449985390128`, 1.4468419875441338`}, {
        0.9976020636562407, 1.4463566733951305`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9916050559989247, 1.4461779146239824`}, {
        0.9653325266093912, 1.4451315413776233`}, {0.934746585538384, 
        1.443351457939841}, {0.9022602645509294, 1.440909981184253}, {
        0.8678413596170131, 1.437993886423205}, {0.8311550412809476, 
        1.4347188686788122`}, {0.7985667354329703, 1.4317286675946785`}, {
        0.7640226801658898, 1.428496977819458}, {0.7523787815431557, 
        1.4273890775718043`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.7464057582589179, 1.4268207529762151`}, {
        0.7274236628141972, 1.4250146338295635`}, {0.6886704707123861, 
        1.4212724701014081`}, {0.6477858812334221, 1.4172565761883265`}, {
        0.6047926717502686, 1.4129530416436538`}, {0.562659742085417, 
        1.4086399423416203`}, {0.5189758369341929, 1.404052134939244}, {
        0.5076100228867757, 1.4028233954298734`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5016447807615342, 1.4021785028905738`}, {
        0.4740136156835526, 1.399191342966998}, {0.428045737720452, 
        1.3940592899553537`}, {0.38141465382542394`, 1.3886689757046344`}, {
        0.3344628147790006, 1.383033400015163}, {0.2831238972304674, 
        1.3766321744897687`}, {0.2633034942301193, 1.3740532892849546`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2573536462488289, 1.3732791387830918`}, {
        0.2320459160347847, 1.3699862828802485`}, {0.18173737157520864`, 
        1.3631222923595763`}, {0.1327067642349952, 1.3560667701007258`}, {
        0.08506348491812366, 1.348831800510986}, {0.03868886196898663, 
        1.3414211921315395`}, {0.019937013629275465`, 1.3382615983494532`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.014020413693803047`, 
        1.3372646804974877`}, {-0.006250698068539812, 
        1.3338490983362008`}, {-0.04958878865057961, 
        1.3261296724987852`}, {-0.09143104287933718, 
        1.3182983288110282`}, {-0.13203854508334856`, 
        1.3104026305034773`}, {-0.17147806555823514`, 
        1.302474954508165}, {-0.2098163745996183, 
        1.2945476777571236`}, {-0.22166008708204885`, 1.2920296869549792`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2275289190694866, 
        1.2907819645887346`}, {-0.24723607488228727`, 
        1.286592194096866}, {-0.2839859590119842, 
        1.2785450498964643`}, {-0.32023208218076, 
        1.270386350871791}, {-0.35614049958066557`, 
        1.262096202738718}, {-0.4032829777036802, 
        1.2508462340204074`}, {-0.45078469347535666`, 
        1.2390238323732785`}, {-0.4612476597147224, 1.23631167404733}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4670557034746327, 
        1.2348061416886715`}, {-0.4991170726191883, 
        1.226495352255025}, {-0.5487515408586686, 
        1.2131271481233414`}, {-0.6002603554735157, 
        1.1986676089052257`}, {-0.6542733917755728, 
        1.182797714652992}, {-0.697943120894651, 1.1693965026216115`}}]}, 
      {Arrowheads[{{0.0006685329578423794, 1.}}], 
       ArrowBox[{{-0.7040951482703488, 
        1.1654103792578472`}, {-0.7109324629872322, 
        1.1654103792578472`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.24017776779883498`, 
        0.84040262014396}, {-0.28953895610067754`, 
        0.8556509246177588}, {-0.3407498214628198, 
        0.865305371595066}, {-0.3941264725649757, 
        0.8676062200201089}, {-0.433786577669217, 
        0.8636207712036137}, {-0.4748226934156393, 
        0.8539658359071203}, {-0.4755531760221542, 0.8536877728155357}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.4811606538425698, 
        0.8515532488654365}, {-0.5175627004427625, 
        0.8376965662731584}, {-0.5619481719551204, 
        0.8134434398048691}, {-0.6077443328211647, 
        0.7793249353646055}, {-0.6542964897135372, 
        0.7336341798175187}, {-0.6722896926546577, 0.712006817383642}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6761270723605695, 
        0.7073943866803516}, {-0.6776833568003978, 
        0.7055237732192291}, {-0.7010519710508025, 
        0.6734097822526084}, {-0.724072278546205, 
        0.6376366159432564}, {-0.7464142253680595, 
        0.5985486833167715}, {-0.7622291259716752, 
        0.5677433745475925}, {-0.777433860675131, 
        0.5351612509596876}, {-0.7920284294784266, 
        0.5008023125530564}, {-0.7928854209498218, 0.49858784315160415`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7950508966239472, 
        0.4929922453189529}, {-0.8060128323815623, 
        0.4646665593276993}, {-0.8191702665574111, 
        0.4271514932015954}, {-0.8312839291788459, 
        0.388654616092724}, {-0.8423538202458666, 
        0.34917592800108527`}, {-0.8523799397584736, 
        0.30871542892667875`}, {-0.8611781463778647, 
        0.2677864976259997}, {-0.8620607432646539, 0.2629011289271861}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8631274428867678, 
        0.25699671092740134`}, {-0.8685642987652378, 
        0.2269025128555433}, {-0.8745383969205931, 
        0.18606347461530925`}, {-0.8791004408439307, 
        0.1452693829052975}, {-0.8829286886527589, 
        0.08614600049951272}, {-0.8830630002492001, 
        0.028789717039140364`}, {-0.8823924644814344, 
        0.018318237447939537`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8820090428811448, 
        0.012330500991111184`}, {-0.8795033756332545, -0.02679946747581939}, \
{-0.8722498148049219, -0.08062155304536692}, {-0.8654494172584153, \
-0.11410781286466293`}, {-0.8567086068256258, -0.146737176164979}, \
{-0.8460273835065536, -0.17850964294631483`}, {-0.8334057473011991, \
-0.20942521320867058`}, {-0.8283400282962866, -0.21988176323717754`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.825724111430865, -0.22528148350337676`}, \
{-0.8188436982095617, -0.2394838869520462}, {-0.802341236231642, \
-0.26868566417644185`}, {-0.7838983613674395, -0.29703054488185754`}, \
{-0.7635150736169543, -0.3245185290682929}, {-0.7282900643139907, \
-0.36480237513992564`}, {-0.68765066075339, -0.4032395882038069}, \
{-0.6773098039018378, -0.41142623528440475`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6726055589328993, -0.4151504908170202}, \
{-0.6415257677269919, -0.4397557324903194}, {-0.5898442900266359, \
-0.4742763722298458}, {-0.562011055579325, -0.4907507378352243}, \
{-0.5329711222747269, -0.5066509471853268}, {-0.5027244901128419, \
-0.5219770002801528}, {-0.47127115909367, -0.5367288971197026}, \
{-0.4674818859391597, -0.5383183844297995}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4619489473856845, -0.540639287478931}, \
{-0.41612806866077096`, -0.5598597823603965}, {-0.3587648811599246, \
-0.5810866698099164}, {-0.30965110128856876`, -0.597444087568453}, \
{-0.2598947808051624, -0.6123336413128226}, {-0.23530953167893864`, \
-0.6188882389640014}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.22951203582052015`, -0.6204338915030995}, \
{-0.20975053974500216`, -0.6257024431901437}, {-0.1594729981433845, \
-0.6374976053475346}, {-0.10955848737581131`, -0.6477198674946254}, \
{-0.06030996974561996, -0.6563270672910367}, {-0.011692011679860202`, \
-0.6632019638088726}, {0.006069527875835427, -0.665060621243352}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.012036943478777169`, -0.6656850818279908}, {
        0.03633082039441839, -0.6682273161202372}, {
        0.09075873599829468, -0.6715619625676668}, {
        0.14420812295879928`, -0.6722211275981453}, {
        0.19667898127593217`, -0.6702048112116729}, {
        0.24817131094969336`, -0.6655130134082495}, {
        0.25150873325937495`, -0.6650119727000362}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2574422398688171, -0.6641211869145037}, {
        0.29906658423401605`, -0.6578722052021341}, {
        0.34974627338283343`, -0.647008857607585}, {
        0.40021037839614565`, -0.6329229706246026}, {
        0.45045889927395255`, -0.6156145442531866}, {
        0.4879498236725201, -0.6001919419232449}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.49349866508232765`, -0.5979093208401903}, {
        0.501049271716189, -0.5948032356920655}, {
        0.5525389314227896, -0.5702087021399668}, {
        0.604927878393755, -0.541830943596891}, {
        0.6582161126290844, -0.5096699600628378}, {
        0.6875896534825715, -0.491056546948403}, {
        0.7027408283537734, -0.4810148174694975}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7077421087279373, -0.47770012372512183`}, {
        0.7174097075307708, -0.47129273864020893`}, {
        0.7648037819629677, -0.43660263959316514`}, {
        0.8132562830774767, -0.3992775729606929}, {
        0.8620935615183223, -0.36076727428072997`}, {
        0.8978334095207153, -0.3313142300792595}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.9024637046491001, -0.3274984251806757}, {
        0.9117003946118417, -0.3198865115057857}, {
        0.9366626479978328, -0.298610600662707}, {
        0.9615577977359504, -0.2768488629559061}, {
        0.9863858438261943, -0.2546012983853829}, {
        1.0111467862685644`, -0.2318679069511374}, {
        1.0356093084895905`, -0.2087189568452523}, {
        1.0595420939158022`, -0.1852247162598103}, {
        1.079155897295327, -0.1652451023926814}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.083351234329103, -0.16095580892668668`}, {
        1.1058184543837828`, -0.13720036365025548`}, {
        1.1392140219519802`, -0.09995958954567058}, {
        1.1704913047588232`, -0.062179843527067034`}, {
        1.1990813822072295`, -0.024027388079503186`}, {1.224415333700114, 
        0.014331514311962848`}, {1.2316539883575226`, 
        0.026998204909215104`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2346309911834734`, 0.032207567074997064`}, {
        1.2464152813379612`, 0.052828520050336426`}, {1.2652839430484346`, 
        0.09145123918894499}, {1.280873291975223, 0.13011733971821354`}, {
        1.293035301262014, 0.16874448962856703`}, {1.3021284542086327`, 
        0.20733551778713014`}, {1.3088006684898397`, 0.24594191641914168`}, {
        1.3102303907338324`, 0.25810858658245184`}}]}, 
      {Arrowheads[{{0.0017189774753443002`, 1.}}], 
       ArrowBox[{{1.3115293998450215`, 0.2794590202080621}, {
        1.312739309728405, 0.2794590202080621}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.5363362975390406, 
        0.76715324492146}, {-0.5598938430140652, 
        0.744148175903389}, {-0.5831210422301636, 
        0.7166755361695751}, {-0.6056512599614053, 
        0.6847712814021556}, {-0.6271178609818594, 
        0.6484713672832678}, {-0.6471931195411236, 
        0.6071514691819374}, {-0.6633185979416829, 0.5662892663209227}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6655205824256971, 
        0.5607079538335761}, {-0.6816797226870436, 
        0.5099917119483619}, {-0.6952644140805726, 
        0.4558084369318584}, {-0.7058144683118281, 
        0.39892966190619755`}, {-0.7129076664681326, 
        0.3401708205652817}, {-0.7136676766191251, 0.32631461731613365`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7139962815613958, 
        0.32032362250793067`}, {-0.7161840358496054, 
        0.28043735515079016`}, {-0.7152836037563662, 
        0.22063470790440104`}, {-0.7096198280422824, 
        0.16212779974040872`}, {-0.6987874221182233, 
        0.10591396863501541`}, {-0.6918214338394032, 
        0.08272160132290851}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6900954649043689, 
        0.07697520843386092}, {-0.6826982966198094, 
        0.05234728242276101}, {-0.6612643621826619, 
        0.001781808938186393}, {-0.633824223502503, -0.04520461523384077}, \
{-0.6001751300269739, -0.08821316850871452}, {-0.5644338821900554, \
-0.12366942582092641`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5600945165301228, -0.12780478332421322`}, \
{-0.516649589743801, -0.16195448103040988`}, {-0.46764885183447286`, \
-0.1924343671664885}, {-0.41444981422935157`, -0.21849606213788525`}, \
{-0.35804121064635563`, -0.2401521595413884}, {-0.3509708590633803, \
-0.2422339830865399}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3452151750015952, -0.24392871049261822`}, \
{-0.29941177480340286`, -0.25741525297378665`}, {-0.24001987215183926`, \
-0.2700794181703588}, {-0.18094816275626904`, -0.27811354515559134`}, \
{-0.12262182225449633`, -0.2817924489600838}, {-0.10915469438086645`, \
-0.28169784594961256`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.10315484241611174`, -0.281655698576871}, \
{-0.06546602628432645, -0.2813909446144358}, {-0.017248350761352275`, \
-0.27790735316841764`}, {0.029072432683442343`, -0.2715518448311742}, {
        0.07349632405005738, -0.26232441960270547`}, {
        0.11602332333849281`, -0.2502250774830115}, {
        0.13260896199381422`, -0.24426107784172904`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.13825502710931475`, -0.2422308195548286}, {
        0.15668823477230256`, -0.23560245593408424`}, {
        0.19552586257504062`, -0.2188051924179159}, {
        0.2325362067467069, -0.19983328693450636`}, {
        0.26771926728730167`, -0.17868673948385566`}, {
        0.30128268297383565`, -0.1557598717348549}, {
        0.3334340925833198, -0.13144700535639542`}, {
        0.34456043001812275`, -0.1221451253290927}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3491636615812815, -0.11829671537484673`}, {
        0.3641734961157542, -0.10574814034847707`}, {
        0.39350089357113893`, -0.07866327671109985}, {
        0.42943120468383206`, -0.04237721058141797}, {
        0.463713055400106, -0.004861630691796993}, {0.4963464457199608, 
        0.033883462957763164`}, {0.5134832509692874, 
        0.055992180446801126`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.5171590225636239, 0.060734405998825104`}, {
        0.5273313756433966, 0.07385807036726261}, {0.5597472800143054, 
        0.1194635132022348}, {0.5904991384076915, 0.16623157310412887`}, {
        0.6128578840435241, 0.20246401644585102`}, {0.6342561057797629, 
        0.23954813837287012`}, {0.6465375385001277, 
        0.26255542844291474`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6493630161166322, 0.26784850658692816`}, {
        0.6546055574253609, 0.2776695650367381}, {0.6738553712027712, 
        0.31700607556544247`}, {0.6895459754311337, 0.3515162928374147}, {
        0.7044778483993148, 0.3870827802756242}, {0.7182941713568991, 
        0.4241452733659825}, {0.7306381255534711, 0.4631435075944013}, {
        0.7374536744016632, 0.4904358951808904}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7389073728702149, 0.4962571287926372}, {0.743116192761504,
         0.5131110530052492}, {0.7529341179045385, 0.5665928239466254}, {
        0.7594831646059319, 0.6243024685693059}, {0.7621545964890417, 
        0.6869536350240667}, {0.7618307568776295, 0.7202804412072461}, {
        0.7611404834701337, 0.734400080893801}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7608475085669005, 0.740392923767269}, {0.7601266135694245,
         0.7551389323859834}, {0.7570421665644269, 0.7915291085602786}, {
        0.7525774158626368, 0.8294509697301317}, {0.7483870774277144, 
        0.8608995897688375}, {0.7431297697776961, 0.8933494194634362}, {
        0.7304264247752716, 0.9457492515581235}, {0.7212596538770514, 
        0.9764235636370747}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7195416752859157, 0.9821723504273809}, {
        0.7144882248333342, 0.9990824617391078}, {0.6968736747710688, 
        1.0519836020824467`}, {0.6759064244681472, 1.1040206027504944`}, {
        0.6515695177573302, 1.1536418216890516`}, {0.6238459984713784, 
        1.1992956168439177`}, {0.6227462218986457, 1.2007353938905165`}}]}, 
      {Arrowheads[{{0.018574026191876775`, 1.}}], 
       ArrowBox[{{0.6191040908655929, 1.2055035047887732`}, {
        0.5929120423005046, 1.2397929334440048`}, {0.5589438249349217, 
        1.2739447167182247`}, {0.532300256784743, 1.2950494719476662`}, {
        0.5043409394682978, 1.3129025466170388`}, {0.47521347692090943`, 
        1.3272405024209981`}, {0.4450654730779008, 1.337799901054198}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9006992167051403, -0.20694155106116677`}, \
{-0.8826894928755505, -0.2592046182166136}, {-0.8596270082485928, \
-0.3097234851892964}, {-0.8308312682060339, -0.35874315117961014`}, \
{-0.796302272747874, -0.40626361618755485`}, {-0.7873509866841664, \
-0.4164952721522941}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7834003122325646, -0.421011041342306}, \
{-0.7560400218741128, -0.4522848802131304}, {-0.7152722444003062, \
-0.49174609775815403`}, {-0.669141593165745, -0.5301725591418353}, \
{-0.6440642436772956, -0.5489778774079446}, {-0.6176442833268866, \
-0.5674847489032626}, {-0.602535498810386, -0.577394031564561}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5975183193543759, -0.5806846105874975}, \
{-0.5898817121145176, -0.5856931736277892}, {-0.5607765300401887, \
-0.6036031515815244}, {-0.5304461702215773, -0.6211766408895218}, \
{-0.49900806577636053`, -0.6383755996768354}, {-0.4664622167045386, \
-0.6552000279434647}, {-0.43280862300611134`, -0.6716499256894098}, \
{-0.3857770763674646, -0.6931389138325371}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.38031974051571765`, -0.6956324024331201}, \
{-0.3787757229318903, -0.6963378730783143}, {-0.3230395836260312, \
-0.7199050696383846}, {-0.283139170860897, -0.7357532113697092}, \
{-0.2429677548336321, -0.7509400872855965}, {-0.2025253355442364, \
-0.7654656973860458}, {-0.1618119129927102, -0.7793300416710577}, \
{-0.156169547300138, -0.7811495392508586}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.15045911217263833`, -0.7829909872285702}, \
{-0.1210586336647713, -0.7924717799323248}, {-0.08049664404613761, \
-0.8048295719615408}, {-0.040125944136809276`, -0.8164034177587052}, {
        0.00005346606321357528, -0.8271933173238182}, {
        0.048197331207703795`, -0.8390642565291309}, {
        0.08093061634980508, -0.8462848441383848}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.08678975861389975, -0.847577303781507}, {
        0.09594650587592207, -0.8495971772996768}, {
        0.14330099006786823`, -0.8587920796354555}, {
        0.1902607837835426, -0.8666489635364674}, {
        0.23706602779223393`, -0.8730376361657224}, {
        0.28395686286323085`, -0.8778279046862306}, {
        0.3242614794335138, -0.8805664457343579}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.330247677192609, -0.8809731844576232}, {
        0.3309332889965336, -0.881019769097992}, {
        0.3779953061921422, -0.8826132294010067}, {
        0.42559308556731423`, -0.8824051553599868}, {
        0.47417679823930736`, -0.8801924167396442}, {
        0.5237464442081216, -0.875975013539979}, {
        0.5696429297740561, -0.8703263581757889}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5755905397829171, -0.8695414833789112}, {
        0.6298785439679233, -0.8606321117227476}, {
        0.6875244744072389, -0.8487071461232338}, {
        0.7474495027187448, -0.8337193084480059}, {
        0.8091958926186638, -0.815605650902036}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8149059403957947, -0.8137639125925532}, {
        0.8419486789339866, -0.8049369843765326}, {
        0.8745465582371453, -0.793488619518738}, {
        0.907656954738959, -0.7810647636092354}, {
        0.9412798684394273, -0.7676654166480249}, {
        0.9851342464084496, -0.749689481538708}, {
        1.0293899743898307`, -0.7299567053628802}, {
        1.0377816338708947`, -0.7253083887597729}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0430302154497733`, -0.7224010890831217}, {
        1.0850479699520743`, -0.699126571531611}, {
        1.138261902592108, -0.6651305181483697}, {
        1.1892290178827778`, -0.6296444522610597}, {
        1.2357024984747207`, -0.5911783613656129}, {
        1.2402110739150465`, -0.5866518431781684}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.244445280813925, -0.5824007854347958}, {
        1.276734140034962, -0.549983426459586}, {
        1.311375738230528, -0.5063108285405362}, {
        1.339602204255895, -0.4605485569027977}, {
        1.3613884493055401`, -0.413084600840705}, {
        1.3720380334153615`, -0.3823685978956594}}]}, 
      {Arrowheads[{{0.00027321485249625526`, 1.}}], 
       ArrowBox[{{1.3742605142926956`, -0.37434322129968906`}, {
        1.3748205218538696`, -0.37434322129968906`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -0.7864170130565192}, {-1.471954889637079, \
-0.8043544247070936}, {-1.4337653581600633`, -0.8332637641713465}, \
{-1.4007232869599495`, -0.8621672120177628}, {-1.370973453954144, \
-0.8910924156858344}, {-1.3433450532682485`, -0.9200505007581241}, \
{-1.321286273480508, -0.9451222904025524}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.3173487949321334`, -0.9496487262529694}, \
{-1.2944525488561895`, -0.9780653151153577}, {-1.272473827554896, \
-1.0069731213422164`}, {-1.2511873034232535`, -1.0356159628571229`}, \
{-1.2305929764612629`, -1.0639938396600774`}, {-1.2106908466689235`, \
-1.09210675175108}, {-1.1786580249399279`, -1.137938756624258}, \
{-1.175123568634828, -1.1428879457334884`}}]}, 
      {Arrowheads[{{0.01999999999999999, 1.}}], 
       ArrowBox[{{-1.1716365829080644`, -1.1477706632699989`}, \
{-1.1472155064610596`, -1.1819667362028583`}, {-1.1106563205572155`, \
-1.225783791043853}, {-1.0734291388103498`, -1.2646102213257666`}, \
{-1.0355834288160166`, -1.3004976976144207`}, {-1.0078486562701399`, \
-1.3217937476596036`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.003089730688414, -1.325447872357475}, \
{-0.9965006623267483, -1.3305072659165553`}, {-0.9559486267628459, \
-1.3548243499165031`}, {-0.9136951095446104, -1.3736343732985972`}, \
{-0.8695862862678662, -1.3875929017554847`}, {-0.8234683325284372, \
-1.3973555009798135`}, {-0.7790639202736506, -1.402926445780127}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7731105901314913, -1.4036733461874493`}, \
{-0.7671235232562517, -1.4044244791804132`}, {-0.7078963671369601, \
-1.4077708954302883`}, {-0.6459615480113599, -1.4082252714148722`}, \
{-0.5814937497202484, -1.4066181288195985`}, {-0.5484224554218304, \
-1.405149001889673}, {-0.5333273677619416, -1.4043511893964276`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.527335730393085, -1.4040345166313815`}, \
{-0.5149428604004437, -1.4033795229850994`}, {-0.48105496465608816`, \
-1.4013096921058774`}, {-0.4467587681887636, -1.398939509252007}, \
{-0.41369890306609025`, -1.3964343633859768`}, {-0.3805366381594581, \
-1.3937416994059613`}, {-0.3472719734688671, -1.3908615173119605`}, \
{-0.31390490899431744`, -1.3877938171039743`}, {-0.28808795630926365`, \
-1.3852926144687938`}}]}, 
      {Arrowheads[{{0.01118534425257845, 1.}}], 
       ArrowBox[{{-0.2821159180921656, -1.3847140303923449`}, \
{-0.28055792763969034`, -1.3845630888822118`}, {-0.24735351230886715`, \
-1.3811938227468818`}, {-0.21429166300184782`, -1.377686018697984}, \
{-0.18137237971863232`, -1.3740396767355187`}, {-0.14867268908377224`, \
-1.370273150969758}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.0084517815711076`, 1.5}, {-1.0249862448288576`, 
        1.4728759631187207`}, {-1.0499841031495707`, 
        1.4377043206924498`}, {-1.0744418761015886`, 
        1.4074108654424475`}, {-1.0982598053059658`, 
        1.3803084095104496`}, {-1.1213658343732902`, 
        1.3553477870923785`}, {-1.1612644040661222`, 
        1.3159747972469575`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.1655382636474496`, 
        1.3117637206599513`}, {-1.2026129502164637`, 
        1.2776795868749875`}, {-1.2367506606241034`, 
        1.2468204889809387`}, {-1.2538512253610659`, 
        1.2303008048168182`}, {-1.2696935564196157`, 
        1.214252252247263}, {-1.2987377213215738`, 
        1.1828418183861027`}, {-1.322594831797833, 
        1.1525486181673086`}, {-1.3312009449111717`, 
        1.1391160277333887`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3344377361478366`, 
        1.1340639803770936`}, {-1.3415737613092549`, 
        1.1229259321017444`}, {-1.3639456826070573`, 
        1.074572839477134}, {-1.3764845017523315`, 
        1.0258426546448813`}, {-1.3824659263665902`, 
        0.9759366239668239}, {-1.385165664071347, 
        0.9240559938047997}, {-1.384984309784923, 0.9030940923115796}}]}, 
      {Arrowheads[{{0.018410379435117762`, 1.}}], 
       ArrowBox[{{-1.384932402041828, 
        0.8970943168502638}, {-1.3846923797292718`, 
        0.8693512501095502}, {-1.3811547382030345`, 
        0.8109728788318165}, {-1.3773592582920187`, 
        0.7683209834001015}, {-1.3729831941278805`, 
        0.7236288158163234}, {-1.3680999907527656`, 0.6769147014451757}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8229559166608289, 
        0.12431559072348561`}, {-0.8211573832231699, 
        0.07145960237502327}, {-0.8157407797229232, 
        0.02050090148427367}, {-0.8067061061600888, -0.028560511948763176`}, \
{-0.7940533625346664, -0.07572463792408754}, {-0.7811853361278853, \
-0.11057428837155484`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-0.7791070258007147, -0.11620284290926483`}, \
{-0.7774102571500277, -0.12079809260004118`}, {-0.7564044983095444, \
-0.16358749213496587`}, {-0.7310360860132163, -0.20409283652886204`}, \
{-0.7013050202610435, -0.24231412578172992`}, {-0.6802789972489748, \
-0.2651797069327157}, {-0.6573808922174382, -0.28709103184032425`}, \
{-0.6356529623528308, -0.3054741678726263}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.630999341623912, -0.3092578999626126}, \
{-0.6059684360959606, -0.32805091292541066`}, {-0.5775622401770264, \
-0.3470510805415453}, {-0.5475002725806375, -0.3650002147916168}, \
{-0.5157825333067939, -0.38189831567562516`}, {-0.48240902235549565`, \
-0.3977453831935703}, {-0.44770518664510756`, -0.41247457995873393`}, \
{-0.42065701150599055`, -0.4227340842669007}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.41504701614647277`, -0.42486198277627296`}, \
{-0.4119964730939947, -0.4260190685843978}, {-0.37528288170215723`, \
-0.43837884907056185`}, {-0.33756441246959495`, -0.4495539214172263}, \
{-0.2847646711966765, -0.46291876980896307`}, {-0.23193459445191733`, \
-0.47378301679899637`}, {-0.1822926505129931, -0.4816374320033207}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17634937735659145`, -0.482448712407455}, \
{-0.12618343454687614`, -0.4880097065739532}, {-0.07612935698636593, \
-0.49119618941824233`}, {-0.027131309834296076`, -0.4919353683451162}, {
        0.02067371890729157, -0.49020630902504475`}, {
        0.06303106941359277, -0.4863618110989587}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.06899384269658401, -0.4857136208274493}, {
        0.11228056172750883`, -0.47927478098809884`}, {
        0.15605598495536394`, -0.47006052893647}, {
        0.19851630047435945`, -0.45835231742362853`}, {
        0.23974682200969344`, -0.4441690671428742}, {
        0.29215466708698673`, -0.42193689062019274`}, {
        0.2983036653395982, -0.4187472483555434}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3036297419381436, -0.4159844765469377}, {
        0.34286817954129156`, -0.3956304979253541}, {
        0.392165130900998, -0.36546654464053385`}, {
        0.4403232926944963, -0.33166168634790744`}, {
        0.48559638746204664`, -0.2964009483074228}, {
        0.5022752327023081, -0.28239370636787764`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5068698672591578, -0.2785350364818933}, {
        0.5306213081382098, -0.2585880812812664}, {
        0.5753980547229863, -0.21822308526943845`}, {
        0.6199266272163758, -0.17530596027193862`}, {
        0.6448395991702189, -0.1503188197700867}, {
        0.6698908665230541, -0.1248086112159883}, {
        0.6808888240143348, -0.11344228174468525`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6850610163689783, -0.10913034355451436`}, {
        0.6950804292748816, -0.0987753346096435}, {
        0.720408287425701, -0.07221898995105225}, {
        0.7459044287863853, -0.04518498734704828}, {
        0.771598841167807, -0.017718736904465435`}, {0.7974915245699662, 
        0.01017976137669635}, {0.8235824789928629, 0.03851050749643708}, {
        0.8488548696095384, 0.06627572133834078}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.852866997752584, 0.07073693688522235}, {
        0.8759968018844718, 0.09654801173429227}, {0.9022295705990852, 
        0.12627458697306596`}, {0.9284794108262376, 0.15647304429173708`}, {
        0.9487158993449821, 0.17992785937047379`}, {0.9688116434978846, 
        0.20372173939796345`}, {1.0069054188062916`, 0.2533514625520826}, {
        1.0074752200014083`, 0.254168635880435}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0109070142322738`, 0.25909030108207143`}, {
        1.0427505610323156`, 0.3047583294192268}, {1.0639271884156736`, 
        0.33651344298300656`}, {1.0837946448546791`, 0.3691608564954745}, {
        1.1023529303493327`, 0.40270056995663067`}, {1.1196020448996338`, 
        0.43713258336647487`}, {1.1321695748453697`, 0.4655774477733148}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.134594375350809, 0.47106564807111934`}, {
        1.135306821985371, 0.4726781724100093}, {1.1492320950863328`, 
        0.509558612772236}, {1.1613778642025194`, 0.5477739044531549}, {
        1.1717441293339304`, 0.5873240474527661}, {1.1803049870420885`, 
        0.6284967581009655}, {1.1870345338885158`, 0.6715797527276488}, {
        1.1905163414513282`, 0.7035622742338861}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.191165700446406, 0.7095270318061191}, {1.191932769873213, 
        0.716573031332816}, {1.1949996949961792`, 0.7634765939164674}, {
        1.196380975994842, 0.8257087138690729}, {1.195103722272968, 
        0.8905595573674072}, {1.1934948959105482`, 0.9239790588561904}, {
        1.1918323865440064`, 0.9492640348767425}}]}, 
      {Arrowheads[{{0.0102128947069636, 1.}}], 
       ArrowBox[{{1.191438731280855, 0.9552511072442518}, {
        1.1912535370904567`, 0.9580677113233663}, {1.188390346220181, 
        0.9928303381329223}, {1.1849160237072085`, 1.0282717626488453`}, {
        1.1792852986023312`, 1.0771891615384939`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6322381920236446, 
        0.48954847901901866`}, {-0.6391550070435292, 
        0.4450960693791035}, {-0.643571038463079, 
        0.398887506085972}, {-0.6452456233482929, 
        0.35155532374369114`}, {-0.6438217272594584, 
        0.30389007229363746`}, {-0.6390354129614322, 
        0.25655588940733953`}, {-0.6379938944025583, 0.2506777339966347}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6369470917384078, 
        0.2447697559853073}, {-0.6307856633270669, 
        0.20999569128409362`}, {-0.6189714612292153, 
        0.1646523941231958}, {-0.6030919362999203, 
        0.12120337263894092`}, {-0.5829661007638727, 
        0.08013843473362553}, {-0.5589727613828972, 
        0.04161914638854658}, {-0.5465198952857125, 0.025391711865340862`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5428671203721753, 
        0.02063175016055441}, {-0.5314907249188191, 
        0.0058070735850012795`}, {-0.5088216241196272, \
-0.019045689380904385`}, {-0.4843292958480132, -0.04215690855620659}, \
{-0.4580137401039772, -0.0635265839409053}, {-0.4298749568875192, \
-0.0831547155350005}, {-0.40029295724378844`, -0.10100930091204562`}, \
{-0.369647752217934, -0.11705833764559405`}, {-0.35446315857848004`, \
-0.12387929069473899`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3489899967476489, -0.12633784709505463`}, \
{-0.3379393418099559, -0.13130182573564578`}, {-0.3051677260198538, \
-0.14373976518220102`}, {-0.2718042508285233, -0.15440297938695996`}, \
{-0.23832026221685904`, -0.16332229175162324`}, {-0.20471576018486112`, \
-0.17049770227619088`}, {-0.1709907447325295, -0.1759292109606628}, \
{-0.12512499260572468`, -0.18073794823703732`}, {-0.11661586000283873`, \
-0.18109597816566284`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1106211641205189, -0.1813482107537589}, \
{-0.08051418939940796, -0.1826149906376302}, {-0.03715833511357984, \
-0.18156033816244127`}, {0.004942570251760023, -0.17757399081147074`}, {
        0.04551990374436398, -0.17098216242330258`}, {
        0.08430504241198439, -0.16211106683652093`}, {
        0.12129798625462121`, -0.1509607040511258}, {
        0.12566648030079794`, -0.14929405603184426`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.13127235593101116`, -0.1471553278072721}, {
        0.15649873527227443`, -0.13753107406711718`}, {
        0.18999472691300107`, -0.12218790388663026`}, {
        0.22187339862485816`, -0.10529692051180019`}, {
        0.2521347504078457, -0.08685812394262701}, {
        0.2807787822619636, -0.06687151417911072}, {
        0.31835921156255476`, -0.03707213099712306}, {
        0.33455084708719673`, -0.02254294035122297}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.33901654266455505`, -0.018535751434992274`}, {
        0.35342358292924136`, -0.00560792618038972}, {0.3859718963620235, 
        0.027521100271089394`}, {0.4160041518609012, 0.06231494835731435}, {
        0.4422182769018579, 0.09642376986269592}, {0.4664680055067965, 
        0.1314050181607898}, {0.48875264417936365`, 0.16722679472999308`}, {
        0.4889792360921372, 0.16763528988062146`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.49188965939422513`, 0.172882140002615}, {
        0.5090714994232053, 0.20385720104870253`}, {0.5273319920001198, 
        0.24136759780788936`}, {0.5434415426719059, 0.2798293456985249}, {
        0.5572661425513347, 0.319367688973744}, {0.5685393187700297, 
        0.3602291539103993}, {0.5756155898285069, 0.39643093868959484`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5767666118732372, 0.4023194994859648}, {
        0.5768425360927864, 0.40270792330875704`}, {0.5819109082608043, 
        0.4470916107363095}, {0.583238928668991, 0.4938221629795201}, {
        0.5803210907122537, 0.5433415268248523}, {0.575251002292674, 
        0.580362464495829}, {0.5671720833908265, 0.6193958193614255}, {
        0.5616042778119867, 0.640007295211706}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5600395736334213, 0.6457996782129913}, {
        0.5560843340067109, 0.6604415914216422}, {0.5419877541403273, 
        0.7034997806764788}, {0.5256927935817752, 0.7459263926634481}, {
        0.5060729631564663, 0.7905482409401361}, {0.48296421098063547`, 
        0.837249766750162}, {0.46695339431211125`, 0.8663651055390811}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.4640622450030545, 0.8716226007290685}, {
        0.45620248517051737`, 0.8859154113371454}, {0.4257709363848225, 
        0.9359415034525655}, {0.39165271528226137`, 0.9867243718479026}, {
        0.37383451685485203`, 1.012073702916228}, {0.35515094133691055`, 
        1.0372785096092143`}, {0.3277217015429138, 1.0685471606892958`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.32376502584281464`, 1.0730576725675913`}, {
        0.3185277711825085, 1.0790280126069272`}, {0.2799639372642434, 
        1.117773924806448}, {0.240708057870609, 1.154344616822057}, {
        0.20006808752623623`, 1.1865648684698429`}, {0.15847920784060723`, 
        1.2140161960213085`}, {0.1389903271272832, 1.2243219443437827`}}]}, 
      {Arrowheads[{{0.009094684054451267, 1.}}], 
       ArrowBox[{{0.13368626162061328`, 1.227126741858926}, {
        0.1163766004232043, 1.2362801157479577`}, {0.07412458453441688, 
        1.2536007417080528`}, {0.032087479434634476`, 
        1.2662221879598576`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.23154267397474682`, 
        0.8975789783991697}, {-0.26528976028608203`, 
        0.9138180206111962}, {-0.30015729362302135`, 
        0.92831255364258}, {-0.33627648180684927`, 
        0.9407000205593665}, {-0.37379582982631543`, 
        0.950688864088019}, {-0.4129898102843838, 
        0.957776948899597}, {-0.45408049895172975`, 
        0.9613967062670189}, {-0.46077908046629135`, 0.9613698194214642}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.46677903213481975`, 
        0.9613457367446322}, {-0.4974125533147557, 
        0.9612227795557149}, {-0.5433986248877194, 
        0.9566769971238891}, {-0.5924513651848784, 
        0.9471811873297457}, {-0.6477024097847539, 
        0.9308875610251097}, {-0.6993401150028478, 0.9103035603843869}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7049136167933079, 
        0.9080818318249678}, {-0.7073182166079139, 
        0.907123301930669}, {-0.7481173575446678, 
        0.8873229059679819}, {-0.7909187002525161, 
        0.8633411775589165}, {-0.8354960103531153, 
        0.83461432355949}, {-0.8816230534681219, 
        0.8005785508257193}, {-0.9050817487556408, 
        0.7814310755812164}, {-0.9068512353011433, 0.7798667724488504}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.9113464901604522, 
        0.7758927714737801}, {-0.9285559249959876, 
        0.7606788819486507}, {-0.9520455821891625, 
        0.7383219699280221}, {-0.975550720335165, 
        0.7143603395193306}, {-0.9971324524742216, 
        0.6916302519412482}, {-1.018435456668925, 
        0.6674655400283498}, {-1.046897609496355, 
        0.6278216856305633}, {-1.0674160424525938`, 0.5950381876999645}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0705992424571682`, 
        0.5899522032592807}, {-1.07352445999515, 
        0.5852784124630972}, {-1.0989563520713446`, 
        0.5414740458195905}, {-1.1219983273023388`, 
        0.4951474922240025}, {-1.1423774683481938`, 
        0.4466689837732566}, {-1.1598208578689713`, 
        0.3964087525642764}, {-1.1669191493156843`, 
        0.37107955776481716`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1685382226200316`, 
        0.3653021360530888}, {-1.1742731203098875`, 
        0.3448380086173804}, {-1.1856788801161589`, 
        0.2924279619528874}, {-1.1931823704642868`, 
        0.2466091753844019}, {-1.198659161079715, 
        0.20066524214264275`}, {-1.2021675686713826`, 
        0.15496563856131626`}, {-1.2031092065869184`, 0.128404041813934}}]}, 
      {Arrowheads[{{0.00838556703362356, 1.}}], 
       ArrowBox[{{-1.2033217796710098`, 
        0.12240780860600088`}, {-1.203765909948228, 
        0.10987984097412824`}, {-1.2036196174526668`, 
        0.06551334515985487}, {-1.201955332774814, 0.021820800865883547`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.5846294015164717, 
        0.8486035374250669}, {-0.6266336896127048, 
        0.8242199347129426}, {-0.6704506158747108, 
        0.7923935467654227}, {-0.7157906082508622, 
        0.7519641968479027}, {-0.7389897228242118, 
        0.7279522355115287}, {-0.762519166237061, 
        0.7011041229160174}, {-0.7671622324207698, 0.6952901973908168}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.770906431167238, 
        0.6906018100617936}, {-0.7861303892439236, 
        0.6715387696151187}, {-0.8095748425993133, 
        0.6393750861625819}, {-0.8282897436689806, 
        0.611384232965095}, {-0.8466862754323692, 
        0.5816110576344427}, {-0.8647644378894791, 
        0.550055560170625}, {-0.8825242310403103, 
        0.5167177405736418}, {-0.8971284677327476, 0.48713305232145604`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8997813044571106, 
        0.48175143300908824`}, {-0.916175881166609, 
        0.44569627192693695`}, {-0.9318395310779446, 
        0.40826290711390467`}, {-0.9467283975547376, 
        0.36954778864108573`}, {-0.9606322388887893, 
        0.32998160100709384`}, {-0.9733408133719013, 
        0.2899950287105423}, {-0.9827780631533243, 0.2568741777862797}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9844222257076172, 
        0.2511038459504958}, {-0.9848541210040731, 
        0.2495880717514313}, {-0.9951721617853049, 
        0.20876073012976076`}, {-1.006831815093939, 
        0.1545847096454755}, {-1.015977151348547, 
        0.10112082315335996`}, {-1.0226081705491292`, 
        0.048369070653413976`}, {-1.0252491452594055`, 
        0.014984261279620777`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0257223095204782`, 
        0.009002947412079335}, {-1.0267248726956855`, -0.003670547854362726}, \
{-1.028307473765435, -0.05488088053523592}, {-1.0273353137938837`, \
-0.10488505436659541`}, {-1.0249533154941561`, -0.1414800348135072}, \
{-1.021164146519028, -0.17748926853321081`}, {-1.0159678068684994`, \
-0.21291275552570624`}, {-1.01273562592237, -0.22996457716813398`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0116182197685015`, -0.23585960927044664`}, \
{-1.0093642965425706`, -0.24775049579099345`}, {-1.001303157207986, \
-0.28213821682388995`}, {-0.9917339305314903, -0.3162116461192132}, \
{-0.9806566165130832, -0.34997078367696327`}, {-0.9680712151527652, \
-0.38341562949714003`}, {-0.9504674245652674, -0.42384796166963185`}, \
{-0.9316262632197643, -0.4611865069634929}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9288058927409835, -0.4664799440090677}, \
{-0.9068057405146756, -0.5048287238269226}, {-0.8807478470515816, \
-0.5453771538117211}, {-0.851310825605863, -0.5861487241691472}, \
{-0.8179335824867601, -0.6273278760010585}, {-0.7883507228932821, \
-0.6602951340716615}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7843435001337798, -0.6647607992803093}, \
{-0.780616117694273, -0.6689146093074557}, {-0.7393584312284016, \
-0.7109089240883384}, {-0.7164029320229531, -0.7327555570579969}, \
{-0.6922121828611221, -0.7546838896826771}, {-0.6667861837429084, \
-0.7766939219623791}, {-0.640124934668312, -0.7987856538971028}, \
{-0.6122523523575194, -0.8208875685633077}, {-0.6063700988719347, \
-0.8253489686511417}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6015895602980478, -0.8289747721405187}, \
{-0.5831923535307171, -0.8429281490374533}, {-0.5529449381879049, \
-0.8649073953195395}, {-0.5215101063290829, -0.8868253074095663}, \
{-0.489020793323006, -0.9085484520860472}, {-0.45560993453842885`, \
-0.9299433961274947}, {-0.4212775299753516, -0.9510101395339097}, \
{-0.40217611525901586`, -0.9622467669827617}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.397004569263999, -0.9652889885429747}, \
{-0.38602357963377415`, -0.9717486823052917}, {-0.35035506972193875`, \
-0.9922965023136727}, {-0.31401353251420105`, -1.0123097933997725`}, \
{-0.25753346438611585`, -1.0397572450706205`}, {-0.200550757775471, \
-1.065182997542908}, {-0.18273015434818712`, -1.0728861876877729`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17722267253402277`, -1.0752668691168281`}, \
{-0.16304877645394372`, -1.0813937220622925`}, {-0.12555285851985856`, \
-1.0965563314626254`}, {-0.08806300397321554, -1.1106708257439069`}, \
{-0.05057921281401466, -1.123737204906137}, {-0.013189944386254093`, \
-1.135698696035253}, {0.02401634196606787, -1.1464985262171927`}, {
        0.049526304456228756`, -1.153139460635522}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.05533277668316323, -1.1546510426802152`}, {
        0.061039646242951315`, -1.156136695451956}, {
        0.09787996844439617, -1.164613203739543}, {
        0.13455952486255396`, -1.1719621140329624`}, {
        0.17110053178957604`, -1.178217489285223}, {
        0.20750298922546248`, -1.183379329496325}, {
        0.24376689717021327`, -1.1874476346662686`}, {
        0.29218077115351765`, -1.1912239715541206`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.29816260149323526`, -1.1916905610812578`}, {
        0.2990211994319643, -1.1917575326908625`}, {
        0.3546970756123242, -1.1939763674820427`}, {
        0.4107945257112934, -1.1941041390398095`}, {
        0.46731354972887124`, -1.1921408473641624`}, {
        0.5249518166028997, -1.188270356673535}, {
        0.5378945968570257, -1.1870526384581996`}}]}, 
      {Arrowheads[{{0.013846559364612812`, 1.}}], 
       ArrowBox[{{0.5438682160501097, -1.1864906120032905`}, {
        0.5844069952712201, -1.1826765311863603`}, {
        0.6456790857338324, -1.175359370902639}, {
        0.7087680879907367, -1.1663188758223704`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7468538202868837, 
        0.07299985600577912}, {-0.7381359897819815, 
        0.03451645140623947}, {-0.7268524426821459, -0.0025557205654536917`}, \
{-0.7129042200906728, -0.03806968147105262}, {-0.6962593635894364, \
-0.0719737046202673}, {-0.6768859147603112, -0.10421606332280779`}, \
{-0.6545519230565767, -0.1347431454844137}, {-0.64765537820266, \
-0.14256222343610309`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6436865031904829, -0.1470620046683095}, \
{-0.6291854316343879, -0.1635028473340015}, {-0.6009944726299323, \
-0.19044570466604638`}, {-0.5701870781793981, -0.21552225327502378`}, \
{-0.5367138887983092, -0.2387969646420793}, {-0.500706907696455, \
-0.2601263274308824}, {-0.46242818957125326`, -0.27946535605999623`}, \
{-0.4496998501672448, -0.28493212756763203`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4441868273019583, -0.2872999491164039}, \
{-0.42213978912012184`, -0.29676906494798405`}, {-0.3802093171777187, \
-0.3119965714850631}, {-0.337004384578701, -0.32510699306145086`}, \
{-0.29283281733977984`, -0.33607451371494124`}, {-0.24821256949496429`, \
-0.34486292133588203`}, {-0.21331748797676278`, -0.34988795838628123`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.20737874842674509`, -0.35074316161186886`}, \
{-0.2003927400811343, -0.35174917590510907`}, {-0.13759818255398706`, \
-0.35705563823453385`}, {-0.07657260602839598, -0.3578860923044697}, \
{-0.01747764950608867, -0.35440284914057624`}, {
        0.03177734175742348, -0.3478059051467061}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.03772423975181774, -0.3470094101722904}, {
        0.039525048011208375`, -0.346768219768513}, {
        0.09392151384563215, -0.3349353807753076}, {
        0.1454796422602285, -0.3190248162988931}, {
        0.19446059466463406`, -0.2994497986912873}, {
        0.24112553246848534`, -0.2766236003045082}, {
        0.2618642717634404, -0.264822981129406}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.26707914757380535`, -0.261855647261694}, {
        0.28037811721703343`, -0.254288356215263}, {
        0.31814820227136775`, -0.22993787165083523`}, {
        0.35443578763148825`, -0.20357214661122494`}, {
        0.389240873297395, -0.1751911810964321}, {
        0.42282952329644247`, -0.1452051678927382}, {
        0.4553452382994599, -0.1141413902717865}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.459546085062976, -0.10985749334183376`}, {
        0.48715570837602384`, -0.08164857677749171}, {
        0.5178932434565577, -0.04807799886593908}, {
        0.5478930590144548, -0.013536054981551157`}, {0.5773678071665829, 
        0.021753765945887762`}, {0.6063174879129418, 0.05779146391637767}, {
        0.6167457299113, 0.07128712254481617}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6204143661301069, 0.07603487025231469}, {
        0.6347421012535318, 0.09457703892991859}, {0.6687532238318128, 
        0.14053352316262596`}, {0.7022483773004579, 0.18774642945734116`}, {
        0.7333793617567308, 0.2333644113225668}, {0.7585555038299009, 
        0.2721955249666274}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7618195911630219, 0.2772299796423355}, {0.764014054003477,
         0.28061466962770826`}, {0.7941862853780965, 0.32970729544673494`}, {
        0.8235128973807799, 0.38133551525804815`}, {0.8510066836578649, 
        0.435997393141185}, {0.8743148070957645, 0.4888674702202189}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8767351783171902, 0.4943576253319161}, {
        0.8767822490901752, 0.4944643964927312}, {0.8888575369321114, 
        0.5253690353923763}, {0.9001669454479978, 0.5577133860055608}, {
        0.9107104746378337, 0.5914974483322846}, {0.9204881245016192, 
        0.6267212223725475}, {0.929281688330488, 0.6636688747585354}, {
        0.9368729594155722, 0.7026245721224333}, {0.9403902076499324, 
        0.7251758538341152}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9413148292331355, 0.7311041820072071}, {
        0.9432619377568731, 0.7435883144642417}, {0.9484486233543894, 
        0.7865601017839601}, {0.9523590527635035, 0.8333179185215053}, {
        0.9545815040490387, 0.8824006092008071}, {0.9549864522199956, 
        0.9335113606886563}, {0.9539096293773349, 0.9704105320437095}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.9537346068122364, 0.9764079787589132}, {
        0.9534443722853744, 0.9863533598518435}, {0.9498588531314349, 
        1.0400888804748614`}, {0.9441334836444374, 1.093880196342203}, {
        0.9388566547131613, 1.135673054088635}, {0.9322381119513625, 
        1.17638501402869}, {0.9223364012869996, 1.2138269721142108`}}]}, 
      {Arrowheads[{{0.013937741304700407`, 1.}}], 
       ArrowBox[{{0.9207339442232367, 1.219606894620558}, {0.908166990912523, 
        1.2565533055265548`}, {0.8944413479717293, 1.2918228869851553`}, {
        0.8790628127541699, 1.3217852406509836`}, {0.84369600410261, 
        1.3661069707370226`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0863426908642362`, -1.5}, {
        1.102655010867748, -1.4816324256319815`}, {
        1.1264375557841442`, -1.4578461846519668`}, {
        1.1725144575096142`, -1.4165103341755527`}, {
        1.216315635919208, -1.3808732921477884`}, {
        1.258978952670864, -1.3480856543443493`}, {
        1.2666998521293786`, -1.3423415532800163`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.2715137544508353`, -1.3387601646611318`}, {
        1.2984188487069719`, -1.3187436392053802`}, {
        1.3177792751601805`, -1.3038684150252713`}, {
        1.335857454789662, -1.2895310841955219`}, {
        1.3693034335484058`, -1.2617358875166322`}, {
        1.3973907681201125`, -1.2354873144877294`}, {
        1.4203702807337064`, -1.2104188124885797`}, {
        1.445390689873563, -1.1753999730248845`}}]}, 
      {Arrowheads[{{0.018013829478021028`, 1.}}], 
       ArrowBox[{{1.4488787607895706`, -1.1705180306568408`}, {
        1.449440104377487, -1.1697323680052294`}, {
        1.4673145049480818`, -1.130644151690877}, {
        1.4730840118049517`, -1.1116427835677127`}, {
        1.4778133919343723`, -1.0928477612674032`}, {
        1.4813052335967902`, -1.0741444656326231`}, {
        1.4854761436476411`, -1.0367288931288388`}, {
        1.4869137937907664`, -0.9989673919499867}, {
        1.4866348776194067`, -0.9604507766278998}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.5, -0.4681793116971826}, {-1.472632075906381, \
-0.4848195158761078}, {-1.4210443654571507`, -0.5214509162300867}, \
{-1.3791798673147313`, -0.5576048460902399}, {-1.3418773703106053`, \
-0.5938108388505017}, {-1.3170832939696473`, -0.6218121441888388}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.313105719008389, -0.6263042369558652}, \
{-1.309886660734279, -0.6299396953772929}, {-1.2869435652397687`, \
-0.6623734010609867}, {-1.2653963939670982`, -0.6951773483295458}, \
{-1.2443240268629343`, -0.7285439386028654}, {-1.2240335039450554`, \
-0.7624090380743139}, {-1.205847698999217, -0.7922691862144895}, \
{-1.1877829780163132`, -0.8225340105253827}, {-1.184239033883532, \
-0.828591366465328}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.1812091209732862`, -0.8337701334765312}, \
{-1.1698393409963437`, -0.8532035110069938}, {-1.152016787939308, \
-0.8842776876593226}, {-1.1340816378769127`, -0.9156321397613956}, \
{-1.115800209840864, -0.9471424665922391}, {-1.0971725038311613`, \
-0.978808668151853}, {-1.0781985198478048`, -1.0106307444402374`}, \
{-1.0596638906767313`, -1.0407005328934344`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0564317980058406`, -1.0457551647365593`}, \
{-1.038539205230097, -1.0732992347143795`}, {-1.0176857464132374`, \
-1.1037848270779023`}, {-0.9961497532577072, -1.1337046509257267`}, \
{-0.9687335449063074, -1.169310265377009}, {-0.940058821999085, \
-1.203004406259903}, {-0.9099451296019088, -1.2342116490486772`}, \
{-0.9093426946679416, -1.2347459641372007`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9048538658689174, -1.2387272222314532`}, \
{-0.8782120127806476, -1.2623565692176009`}, {-0.844832675671131, \
-1.287282807234232}, {-0.809868127592023, -1.3090734692765809`}, \
{-0.7732696213834447, -1.3275123293845925`}, {-0.7349884098855168, \
-1.3423831615982127`}, {-0.6970823796563689, -1.3534258274670399`}}]}, 
      {Arrowheads[{{0.003195458095457159, 1.}}], 
       ArrowBox[{{-0.6901018885545579, -1.3627347654908197`}, \
{-0.654936944168146, -1.3627347654908197`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -1.1855648815248672`}, {-1.4662536354371873`, \
-1.2053454756786}, {-1.4210770246915816`, -1.2347686230312511`}, \
{-1.3801255563853987`, -1.263186512457561}, {-1.3441216978288166`, \
-1.2893457058694193`}, {-1.3066626620967432`, -1.3160949342316495`}, \
{-1.3011904079395948`, -1.3197694677525997`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.2962092099510394`, -1.3231142646969316`}, \
{-1.271930477602374, -1.3394170557039629`}, {-1.2380677898788304`, \
-1.361004595509456}, {-1.205944095696938, -1.3791229719813094`}, \
{-1.1751135746300219`, -1.394074266708174}, {-1.1451304062514067`, \
-1.4061605612787016`}, {-1.0866293943405574`, -1.4231483223754495`}, \
{-1.0805151061477967`, -1.4242135022458826`}}]}, 
      {Arrowheads[{{0.01624842530950693, 1.}}], 
       ArrowBox[{{-1.074604133761836, -1.4252432621462525`}, \
{-1.0365137153641533`, -1.431879054515611}, {-0.9858412983438547, \
-1.436257064379732}, {-0.9340070017437097, -1.4374450239220866`}, \
{-0.8804056840277664, -1.436605605096949}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7197927325727591, 1.5}, {-0.727077761924682, 
        1.486377813124913}, {-0.7590335063067366, 
        1.4362819180656063`}, {-0.7909061191826798, 
        1.3963913455672132`}, {-0.8248553289250299, 
        1.3592885104051617`}, {-0.8589960064784387, 
        1.3284309276801018`}, {-0.8737531925370269, 1.3185462973403248`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-0.8787382316759437, 
        1.315207227891591}, {-0.9121387187212575, 
        1.2928349770911542`}, {-0.9659323211875865, 
        1.2605162504054854`}, {-1.0194225336579898`, 
        1.228962958909001}, {-1.072305966136541, 
        1.1989405377908853`}, {-1.0845625289537795`, 
        1.1919112823896187`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0897673158027856`, 
        1.1889262876063047`}, {-1.123356561787279, 
        1.1696625354205046`}, {-1.1713482637742418`, 
        1.1403425001672254`}, {-1.2150658131053205`, 
        1.1105948008737003`}, {-1.2532939507884049`, 
        1.0800338063825825`}, {-1.2793443300385023`, 
        1.0556260788910545`}, {-1.284373751837968, 1.0500352001092772`}}]}, 
      {Arrowheads[{{0.004350573624300164, 1.}}], 
       ArrowBox[{{-1.288386495808791, 
        1.0455744954760804`}, {-1.3019171854037908`, 
        1.0305333141284483`}, {-1.3205808924707474`, 1.0045701425079423`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5203024102113541, 1.5}, {-0.5371532318262536, 
        1.467046423782276}, {-0.5566382998562858, 
        1.4335591759601232`}, {-0.5758033955911115, 
        1.4060510591425797`}, {-0.6034250858196214, 
        1.3722607292120585`}, {-0.6378231569715508, 
        1.3429881613054468`}, {-0.6716797518070998, 1.3182907585554142`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6766039121777949, 
        1.314863251000504}, {-0.7079849696766667, 
        1.2933014780595276`}, {-0.743979181523161, 
        1.2715277107267564`}, {-0.7808403028214743, 
        1.2514775870250898`}, {-0.8187045986282765, 
        1.232419091153481}, {-0.8575739453279783, 
        1.2139710121663927`}, {-0.887117612953812, 1.2004729523887727`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8925749917034391, 
        1.1979795576781185`}, {-0.8974502193049909, 
        1.195752139118288}, {-0.9365231175041816, 
        1.1780752397853944`}, {-0.9758095158401845, 
        1.1599855152223237`}, {-1.015309414313, 
        1.1414829654290761`}, {-1.0550228129226276`, 
        1.1225675904056511`}, {-1.0939045431789152`, 
        1.102965200990848}, {-1.1090730485348566`, 1.0945360733459268`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1143176721382073`, 
        1.0916216397372858`}, {-1.13090943659171, 
        1.0824016080234653`}, {-1.1660374931610127`, 
        1.060876811503503}, {-1.1992887128868222`, 
        1.0383908114309615`}, {-1.229727179584832, 
        1.0147410861492352`}, {-1.2564169770707336`, 
        0.9897251140017185}, {-1.2793581053445275`, 
        0.9633428949884119}, {-1.2961910409252544`, 0.9390058292114016}}]}, 
      {Arrowheads[{{0.005389957066688717, 1.}}], 
       ArrowBox[{{-1.2994294053593252`, 
        0.9339641084509062}, {-1.314308467602703, 
        0.9063622511782664}, {-1.3269459282809057`, 0.8755288960091054}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3446033746702703, 1.5}, {-0.3577593085868577, 
        1.4736885121404404`}, {-0.37630357282117743`, 
        1.4411217433113679`}, {-0.39428707142560415`, 
        1.414776892092624}, {-0.4067629544334471, 
        1.4004217344391094`}, {-0.4191177325456056, 
        1.3873414919189009`}, {-0.4436355971370981, 
        1.3632779216723856`}, {-0.46785241275641853`, 
        1.3428052598804736`}, {-0.4919166046515592, 
        1.3249278995509826`}, {-0.49874171369852355`, 1.3204655072063356`}}]}, 
      {Arrowheads[{{0.013049909238544521`, 1.}}], 
       ArrowBox[{{-0.5037635916924529, 
        1.317182103269247}, {-0.5286488296285039, 
        1.3009116386515507`}, {-0.565650297638948, 
        1.2799818952904618`}, {-0.6032391890045617, 
        1.2611881095268642`}, {-0.6417336840470148, 
        1.2435797214199056`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.5, -1.4004968513051506`}, {-1.4826776370242565`, \
-1.4049878506754614`}, {-1.4448726097074143`, -1.4149203348860995`}, \
{-1.4116030399002744`, -1.4234481271917396`}, {-1.387306908214823, \
-1.4290849171447864`}, {-1.36460642920351, -1.4340228778351178`}, \
{-1.3217405936772437`, -1.4426129540807906`}, {-1.2832059636094197`, \
-1.4488904887090375`}, {-1.265604851765152, -1.451092544904854}}]}, 
      {Arrowheads[{{0.008410430244037781, 1.}}], 
       ArrowBox[{{-1.259651264354409, -1.4518373918305003`}, \
{-1.247770886363392, -1.453323733159118}, {-1.2019804871247175`, \
-1.4572215998704214`}, {-1.159017651013966, -1.45891427446949}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.5, -1.0045132003631996`}, {-1.485708505139749, \
-1.0134207713935024`}, {-1.4446829087510478`, -1.0418114651588632`}, \
{-1.4094301020351148`, -1.0697260819321417`}, {-1.369666527329365, \
-1.1081943780813004`}, {-1.333808613639296, -1.1451978370211096`}, \
{-1.3189434003043092`, -1.160660380007022}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.314785128321807, -1.164985744051763}, \
{-1.2992124396372149`, -1.1811841909065424`}, {-1.2671397450111095`, \
-1.215136334683223}, {-1.2369434473534566`, -1.2467577926187792`}, \
{-1.207976464256733, -1.2757520889808398`}, {-1.1798981927385377`, \
-1.3019590788606767`}, {-1.1523680298164691`, -1.325218617349563}, \
{-1.1428124257819021`, -1.3319136307335158`}}]}, 
      {Arrowheads[{{0.003895932708220032, 1.}}], 
       ArrowBox[{{-1.1323328070260952`, -1.3582833944855843`}, \
{-1.105175604695955, -1.3582833944855843`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.18382426614256758`, 1.5}, {-0.19093924176723054`, 
        1.486318249652206}, {-0.2094378294878278, 
        1.4551172724355657`}, {-0.22724347466742534`, 
        1.4300542965654337`}, {-0.2387621736815254, 
        1.4172357247488803`}, {-0.25010287446611046`, 
        1.4055621942023706`}, {-0.2724661643092744, 
        1.3841281321638514`}, {-0.29425798236620637`, 
        1.3659997395149817`}, {-0.31559422955116356`, 
        1.3503129825437141`}, {-0.34661685418635585`, 
        1.3301063091735923`}, {-0.34768288275178316`, 1.3295023807871185`}}]}, 
      {Arrowheads[{{0.002314893300286829, 1.}}], 
       ArrowBox[{{-0.35579732021593097`, 
        1.3144917735821473`}, {-0.3741789647762453, 
        1.3144917735821473`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.017229442696264627`, 1.}}], 
       ArrowBox[{{-0.03644267847927633, 1.5}, {-0.05512714776299307, 
        1.47054633150413}, {-0.07362434010703414, 
        1.446326164190298}, {-0.08422138144147386, 
        1.435321556711002}, {-0.0946521189201026, 
        1.4252377914358805`}, {-0.11520328369412924`, 
        1.4066402477486206`}, {-0.1351750499613158, 
        1.3907937305587204`}, {-0.15464147435636266`, 
        1.3770425754720212`}, {-0.18391089903206875`, 
        1.358652843760174}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.33668070509341497`, -0.6527031086760351}, \
{-0.3008771323090242, -0.6657329076263793}, {-0.2645504122638067, \
-0.6781584705107697}, {-0.2136123297236373, -0.6943378563616138}, \
{-0.16252287928478576`, -0.7091926553038934}, {-0.13023577055160576`, \
-0.7178848030676176}, {-0.10752998681288317`, -0.7236178814156433}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.10171256188569419`, -0.7250867473783916}, \
{-0.09810857060216295, -0.72599673421839}, {-0.0661412794364574, \
-0.7335284487562107}, {-0.034333897054489165`, -0.7404799466810795}, {
        0.028610174064619572`, -0.7525341476589154}, {
        0.09053267546154724, -0.7620511921188514}, {
        0.134375951271472, -0.7672010542964526}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.14035088817814442`, -0.7677425230901797}, {
        0.18038349536513265`, -0.7710774901505953}, {
        0.22471518288605624`, -0.7732294359003398}, {
        0.2686510554530671, -0.7738072461393326}, {
        0.3124753227735517, -0.772644975354184}, {
        0.35647219455489665`, -0.769576678031504}, {
        0.37988593730675096`, -0.7669398448802857}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3858482463154776, -0.7662683753839885}, {
        0.4006416707971019, -0.7646023541712927}, {
        0.4449837515001672, -0.7577220037735503}, {
        0.49924075550857827`, -0.746463516240014}, {
        0.5549901574703152, -0.7315575045725504}, {
        0.6122319573853785, -0.7130039687711599}, {
        0.6187295320344043, -0.7105479372009244}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.6243419669237573, -0.7084264814241586}, {
        0.6709661552537679, -0.6908029088358421}, {
        0.7231541127232632, -0.6684320972000051}, {
        0.7770730031814228, -0.6427791607421773}, {
        0.8046613989013498, -0.6286859506313733}, {
        0.832642229108639, -0.6137003191677842}, {
        0.8421930128429084, -0.6083555747331024}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8474289121427168, -0.6054254964880267}, {
        0.8610154938032908, -0.5978222663514102}, {
        0.8897811929853047, -0.5810517921822512}, {
        0.9187950819935035, -0.5633822294357158}, {
        0.9479129161667097, -0.5448069108872122}, {
        0.9771346955049234, -0.5253258365367406}, {
        1.0064604200081442`, -0.504939006384301}, {
        1.0436215822474915`, -0.47857792812366956`}, {
        1.048590966075309, -0.47482612521985224`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0533794872017286`, -0.4712108706753101}, {
        1.0803780851704519`, -0.4508273740955062}, {
        1.1269710009934468`, -0.4088930204317751}, {
        1.170108627168636, -0.3650265421557988}, {
        1.2108542243552294`, -0.32044597374404715`}, {
        1.2241357878545547`, -0.30345370559880575`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2278307497178238`, -0.29872641707059144`}, {
        1.2468157635646318`, -0.2744372250607448}, {
        1.2776306565936837`, -0.22739158828223655`}, {
        1.3029363152392266`, -0.1797003555848672}, {
        1.3230213983377084`, -0.13170258625661752`}, {
        1.3371534918937518`, -0.08696940402626249}}]}, 
      {Arrowheads[{{0.003005248802224667, 1.}}], 
       ArrowBox[{{1.3408154676640407`, -0.05469988453526136}, {
        1.3450635805290914`, -0.05469988453526136}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.590014821142007, -0.6526475896914061}, \
{-0.5605863750002678, -0.6716326184270776}, {-0.5298765196740457, \
-0.6904281437017935}, {-0.49802567983963825`, -0.7089891167056167}, \
{-0.4651742801733426, -0.7272704886286089}, {-0.4313223206751592, \
-0.7452722594707706}, {-0.39646980134508747`, -0.7629944292321017}, \
{-0.38107862488328914`, -0.7703851258196748}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.37566988854768996`, -0.7729823495782233}, \
{-0.3432306002479615, -0.7885593873657615}, {-0.2887110164052429, \
-0.8132544719590776}, {-0.2479500726016019, -0.8309085410403179}, \
{-0.2068625429044176, -0.8479846306182507}, {-0.1555139092074973, \
-0.8683731525473327}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.14990869418034636`, -0.8705130746893015}, \
{-0.10122081181147863`, -0.8888330739019915}, {-0.04851101619155888, \
-0.9075189314816987}, {0.004019248884227758, -0.9249404419129299}, {
        0.04021465470943958, -0.936269935879137}, {
        0.07601438633678356, -0.9469359741907255}, {
        0.07739097664753679, -0.9473224869831537}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.08316759617194872, -0.94894442004903}, {
        0.11152193011836595`, -0.9569056215085072}, {
        0.14684077240629334`, -0.9661459424932943}, {
        0.18207439955267232`, -0.9746240018058988}, {
        0.21732629790960933`, -0.9823068641071329}, {
        0.252699953829211, -0.9891615940578085}, {
        0.28829885366358365`, -0.9951552563187376}, {
        0.31759945070889467`, -0.9992929375890314}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3235405058958053, -1.000131903181939}, {
        0.3259546048654228, -1.0004728099585405`}, {
        0.3639425064363372, -1.0047795131115116`}, {
        0.4022625583763268, -1.0080753657776511`}, {
        0.4409147606853917, -1.0103603679569584`}, {
        0.48015330938558537`, -1.0115729540373493`}, {
        0.5202324004989609, -1.0116515584067383`}, {
        0.5611520340255186, -1.0105961810651256`}, {
        0.5630292558057806, -1.0104977640348833`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.5690210270068257, -1.010183633688806}, {
        0.6029122099652583, -1.008406822012511}, {
        0.6457697732518903, -1.0049866785790522`}, {
        0.6899815688191246, -1.000238948094906}, {
        0.7355475966669613, -0.9941636305600726}, {
        0.7824678567954007, -0.9867607259745519}, {
        0.8071821466228662, -0.9821946801630913}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8130822944123782, -0.9811046085774064}, {
        0.8368214370380871, -0.9767187243982332}, {
        0.8929591872585692, -0.9647137917356359}, {
        0.9504876146754584, -0.9506205787045566}, {
        1.0090132265073664`, -0.9343137360227922}, {
        1.045668812099385, -0.9226464178960343}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0513861784964509`, -0.9208266043117076}, {
        1.067562224562588, -0.9156778371473437}, {
        1.1251608106494186`, -0.8945974555352131}, {
        1.1744942655353157`, -0.8753362451049582}, {
        1.2215538349220842`, -0.8541530008569206}, {
        1.259892806382439, -0.8301422382225747}, {
        1.2693814637717278`, -0.8229862779341267}}]}, 
      {Arrowheads[{{0.017871810852133636`, 1.}}], 
       ArrowBox[{{1.2741718826731299`, -0.8193735384266215}, {
        1.2940318433884364`, -0.804395962108048}, {
        1.325774752851653, -0.777805215966719}, {
        1.3527254072293091`, -0.749525529771786}, {
        1.375049954264846, -0.7196360195385142}, {
        1.3929145417017075`, -0.6882158012821699}, {
        1.4068069315197282`, -0.65536973947691}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.015190292999712014`, 1.}}], 
       ArrowBox[{{0.013823115102344876`, 0.4635058809487205}, {
        0.013310444957492087`, 0.4624492932724729}, {0.010001688019841143`, 
        0.4397932099057668}, {0.017845869281084187`, 0.4126631963516861}, {
        0.018744110157493707`, 0.4107700482602931}, {0.019688042121585616`, 
        0.40888294519421703`}, {0.02808565531183254, 0.3971147467059466}, {
        0.03767067165808521, 0.38674575325110316`}, {0.0583137152515523, 
        0.36945093194680334`}, {0.08023637068460406, 0.3598721505307402}, {
        0.10027194480670604`, 0.3587776410537689}, {0.12261629223420971`, 
        0.3725893732032201}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 1.2521043105247793`}, {1.4980465521849604`, 
        1.2533580827671333`}, {1.4573966829438039`, 1.2838263381374133`}, {
        1.4234324898742332`, 1.311339639160273}, {1.3928111348904557`, 
        1.3373754630094226`}, {1.3663771930473647`, 1.3602390969196259`}, {
        1.347872021422468, 1.3754119272568803`}, {1.3307600970166222`, 
        1.3887499596505908`}, {1.3126183401979514`, 1.4018859804642678`}}]}, 
      {Arrowheads[{{0.013173559964671679`, 1.}}], 
       ArrowBox[{{1.3077585457848413`, 1.405404843670234}, {1.29877861437781, 
        1.4119070014847825`}, {1.2706732784877433`, 1.428716300814758}, {
        1.2454428232808714`, 1.440520528164035}, {1.2004741240981014`, 
        1.4538211261892482`}, {1.1612139117572573`, 
        1.4581461838959178`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{0.779495000374682, -1.5}, {
        0.8039566319024228, -1.4737646729030078`}, {
        0.8453875465863334, -1.435032100860241}, {
        0.8870812604305527, -1.402767712203624}, {
        0.939702772501922, -1.367919615748177}, {
        0.967772719732795, -1.353450352774664}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.9731058717532598, -1.3507012639207685`}, {
        0.9791826483321852, -1.3475688576633371`}, {
        1.0187725530462124`, -1.328559304652182}, {
        1.0577787035371713`, -1.310224035205262}, {
        1.096432360840673, -1.2927853564923943`}, {
        1.1295623244806807`, -1.277482676829843}, {
        1.161748701551005, -1.2625318998917898`}, {
        1.190520197669025, -1.2490877917941432`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.195952690424058, -1.2465406422716834`}, {
        1.2232906959826044`, -1.2336860541891776`}, {
        1.2794104392243475`, -1.2057380200050023`}, {
        1.3284600263651116`, -1.1781779979597087`}, {
        1.3698198762936047`, -1.1507935166086192`}, {
        1.4015511944940875`, -1.124466631362044}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3384797699165798`, 1.5}, {-1.342642925313217, 
        1.485750991347845}, {-1.3552381748510594`, 
        1.4441285756266034`}, {-1.3668187113981791`, 
        1.4067224982393405`}, {-1.3765871667768421`, 
        1.3744632795757294`}, {-1.3829413722882737`, 
        1.3510605342460476`}, {-1.3884011801702218`, 
        1.329407436964026}, {-1.3976906999891898`, 
        1.2888401902297038`}, {-1.4013071714336633`, 
        1.2685527237921854`}}]}, 
      {Arrowheads[{{0.012958668780858542`, 1.}}], 
       ArrowBox[{{-1.4023601403016495`, 
        1.2626458416566546`}, {-1.4040957679355401`, 
        1.2529094209738931`}, {-1.4082860749604547`, 
        1.2202327914195341`}, {-1.4114011364160124`, 
        1.1803505405767956`}, {-1.4122465209390813`, 
        1.1431254510876874`}, {-1.4114817094392373`, 1.1077022036567443`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.5, -0.23320093635394684`}, {-1.4542681044556498`, \
-0.2635829724166063}, {-1.4144997509056092`, -0.29566473872311827`}, \
{-1.3774205103883594`, -0.32938787082711857`}, {-1.3467673680191068`, \
-0.3622062283080765}, {-1.3238287573873673`, -0.3937122116124906}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.320297193334532, -0.3985627842942181}, \
{-1.314131583254466, -0.40703119641222607`}, {-1.284889949983278, \
-0.45148260457629885`}, {-1.256616156298548, -0.49597528355841786`}, \
{-1.2302780417867358`, -0.5405505041766295}, {-1.2051405609603099`, \
-0.5855115644649482}, {-1.1954814222315846`, -0.6033837886206316}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.1926286681242915`, -0.6086622158488239}, \
{-1.1804686683317398`, -0.6311617624573886}, {-1.155809104732984, \
-0.6777291967612533}, {-1.1307086109959998`, -0.7254419659838449}, \
{-1.1086774662477568`, -0.766911417903014}, {-1.085591756380107, \
-0.8093068148248418}, {-1.079464856817961, -0.8203019468608698}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0765442654548238`, -0.8255431438701004}, \
{-1.0614514813930502`, -0.8526281567493285}, {-1.0362566412865868`, \
-0.8968754436764739}, {-1.0095556649258486`, -0.9415023794536542}, \
{-0.9808969811759672, -0.9859626679282455}, {-0.9506617175917466, \
-1.029704920562109}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-0.9471152664166856, -1.0345442624833636`}, \
{-0.9177064915087758, -1.0743833029696608`}, {-0.8907976198704327, \
-1.107901735626248}, {-0.862313716921894, -1.1398800344134195`}, \
{-0.8322547826631593, -1.1703181993311753`}, {-0.8006208170942286, \
-1.1992162303795157`}, {-0.785798991414842, -1.2111820268030966`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7811304702305265, -1.2149509669660068`}, \
{-0.7673881417217422, -1.2260452753784161`}, {-0.73253307805234, \
-1.2502764821478523`}, {-0.6960556260860226, -1.271909850687825}, \
{-0.6579557858227892, -1.2909453809983336`}, {-0.6184281608254989, \
-1.3073888411886805`}, {-0.5776673546570104, -1.3212459993681684`}, \
{-0.5689515918343866, -1.3235852416120417`}}]}, 
      {Arrowheads[{{0.0060455746028531725`, 1.}}], 
       ArrowBox[{{-0.5631566790834637, -1.325140550651812}, \
{-0.5356733673173236, -1.3325168555367972`}, {-0.49244619880643836`, \
-1.3412014096945668`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5344729750894809, -1.5}, {
        0.535370999646272, -1.4988869297014433`}, {
        0.5682961663935204, -1.4632596737770205`}, {
        0.6011056311071309, -1.4338595131237035`}, {
        0.646344187526227, -1.3994626197894287`}, {
        0.6807581031949483, -1.3805133570336638`}, {
        0.7155915657657345, -1.3631392232944457`}, {
        0.7255273334382875, -1.3585100306234854`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.7309660042315214, -1.355976089029284}, {
        0.7509849827926437, -1.3466490081343414`}, {
        0.7868915517576569, -1.3312731150324961`}, {
        0.8222269935388558, -1.315879276706967}, {
        0.858032355615858, -1.3010726836805724`}, {
        0.8943076379886634, -1.2868533359533134`}, {
        0.9310528406572722, -1.2732212335251891`}, {
        0.9530850390006463, -1.2653070184182134`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9587317813984004, -1.2632786446130664`}, {
        0.9680513544119494, -1.2599309484646892`}, {
        1.0050865700429603`, -1.2467370528403028`}, {
        1.0421584875503047`, -1.2336395466520298`}, {
        1.0792671069339828`, -1.2206384298998705`}, {
        1.1158815748198632`, -1.2076256599015507`}, {
        1.1514710378338142`, -1.1944931939747965`}, {
        1.1844793119252366`, -1.1818376797751353`}}]}, 
      {Arrowheads[{{0.009104628674621336, 1.}}], 
       ArrowBox[{{1.1900607325930246`, -1.1796362089533796`}, {
        1.2195749492459296`, -1.1678691743359848`}, {
        1.256254271021559, -1.1524683799671966`}, {
        1.2905669483895696`, -1.1368483580857798`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.4264736238456911, -0.4957078902889265}, \
{-0.3879910594759242, -0.5098088301498038}, {-0.34860871336366606`, \
-0.5228253504204573}, {-0.3087579754648996, -0.5346798991363215}, \
{-0.2684388457796248, -0.5453724762973965}, {-0.22765132430784168`, \
-0.5549030819036823}, {-0.19590297426321734`, -0.5611752055150316}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1900167415815961, -0.5623380747328777}, \
{-0.1717450945079048, -0.5659477750438564}, {-0.11656938525018387`, \
-0.5745285945967015}, {-0.062124196534678926`, -0.5806455405622177}, \
{-0.008409528361389692, -0.5842986129404052}, {
        0.04218278879510662, -0.5854010200229597}, {
        0.04848581207279511, -0.5852264316800909}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.05448351166887361, -0.5850603005415291}, {
        0.09157436456780862, -0.5840329157044567}, {
        0.14279193279836977`, -0.579783618797445}, {
        0.19271391158694667`, -0.5726012507612276}, {
        0.24147837277857123`, -0.5624201009532518}, {
        0.2892233882182756, -0.549174458730965}, {
        0.29083087909327543`, -0.5486178215469943}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.29650057958929715`, -0.546654534434672}, {
        0.3331406611253248, -0.5339669154105988}, {
        0.37663403086960034`, -0.5159565524885097}, {
        0.4197034974511021, -0.49514336996469743`}, {
        0.46234906086983013`, -0.47152736783916227`}, {
        0.5049292186958774, -0.4451773052495899}, {
        0.5111353953120984, -0.44097714608573724`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.5161044033509545, -0.43761426649975993`}, {
        0.5478024684993371, -0.41616194133366624`}, {
        0.5909688102802089, -0.3844812760913912}, {
        0.634428244038493, -0.3501353095227648}, {
        0.6604734439964877, -0.3285450631139188}, {
        0.686788906271294, -0.30617380361534124`}, {
        0.7052031510331602, -0.29013769322965777`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7097278965021437, -0.2861973025839332}, {
        0.7133746308629123, -0.28302153102703215`}, {
        0.7402306177713421, -0.25908824534899144`}, {
        0.7673638434222855, -0.2344548524563257}, {
        0.7947812842414435, -0.2092022582241414}, {
        0.8224829402288163, -0.1833304626524385}, {
        0.8504688113844039, -0.15683946574121702`}, {
        0.8786168628277982, -0.12980373627251465`}, {
        0.8856315820244437, -0.12295878553466401`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8899258690879873, -0.11876842771988477`}, {
        0.9068050596785907, -0.10229774302836905`}, {
        0.935033401936782, -0.0743214860087803}, {
        0.9633018896023716, -0.045874965213748335`}, {
        0.9874777758886307, -0.021363135530361108`}, {1.0114540325397432`, 
        0.0034493461348475926`}, {1.0484194676342093`, 0.04472332147855078}, {
        1.056272118223302, 0.05409916143745045}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.0601246351603169`, 0.05869895635135827}, {
        1.08350062938677, 0.08660922413429194}, {1.1072940336747055`, 
        0.11601480460088238`}, {1.1296665128746475`, 0.14571771524152105`}, {
        1.1506180669865969`, 0.17571795605620802`}, {1.170148696010553, 
        0.2060155270449433}, {1.1880559923698613`, 0.23663551222149928`}, {
        1.1974902416768332`, 0.2548025948380789}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.200255442887694, 0.2601274105403783}, {1.204137548487867, 
        0.2676029955996484}, {1.2183933643645697`, 0.29891797717939067`}, {
        1.23082343999997, 0.33058045696072613`}, {1.241495586896465, 
        0.36268245648891256`}, {1.2504776165564513`, 0.3953159973092079}, {
        1.2577695289799296`, 0.4284810794216121}, {1.2633713241668991`, 
        0.46217770282612514`}, {1.2663874815577334`, 0.4893723901531191}}]}, 
      {Arrowheads[{{0.006712480287059476, 1.}}], 
       ArrowBox[{{1.267048884848494, 0.4953358242046511}, {1.269522981350511, 
        0.5176431086300645}, {1.2727979618338385`, 0.5756564398191182}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7063808538244103, 
        0.8355245592596028}, {-0.7536942642553222, 
        0.8021104549898415}, {-0.8030180760320691, 
        0.760736086232847}, {-0.8283737246941394, 
        0.7365669555014396}, {-0.8541597844154787, 
        0.7098115420439861}, {-0.8800518215562037, 
        0.6805828013659275}, {-0.8841275550333307, 0.6755679651693782}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8879117701623255, 
        0.670911816991164}, {-0.9057254024764302, 
        0.6489936889727049}, {-0.9274930337007218, 
        0.6197668729502359}, {-0.9487545429320658, 
        0.5887149301292958}, {-0.969509930170462, 
        0.5558378605098843}, {-0.9897591954159105, 
        0.5211356640920016}, {-1.009168720190749, 
        0.48487861358269835`}, {-1.0168134824254296`, 
        0.46914082898156645`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0194350991604306`, 
        0.4637438737571123}, {-1.0274048860173157`, 
        0.44733698168902497`}, {-1.04446769289561, 
        0.40851076841098166`}, {-1.0603571408256325`, 
        0.36839997374856814`}, {-1.0748490720990997`, 
        0.3274580965597532}, {-1.0877193290077285`, 
        0.28613863570250553`}, {-1.0989679115515185`, 
        0.24444159117682504`}, {-1.1003753536058853`, 
        0.2382903326375866}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1017136036995403`, 
        0.2324414791869663}, {-1.1085948197304702`, 
        0.20236696298271167`}, {-1.1192804172506752`, 
        0.1442899814523662}, {-1.1269218284773128`, 
        0.08710409206512439}, {-1.1315190534103836`, 
        0.030809294820986283`}, {-1.1325255458274697`, \
-0.005096707543836638}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1326936676715689`, -0.01109435166845229}, \
{-1.133072092049887, -0.02459441028004811}, {-1.133088332396487, \
-0.05343672212287785}, {-1.1323619499365305`, -0.0819154006722344}, \
{-1.1279877987947131`, -0.1291775209546952}, {-1.1218147085349446`, \
-0.17542497649720545`}, {-1.1146827100387446`, -0.22188753250697135`}, \
{-1.109334137326999, -0.24940851470580572`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.1081894822162004`, -0.2552983164577599}, \
{-1.1057723063711937`, -0.267735850167602}, {-1.0950834975322923`, \
-0.31296992947909746`}, {-1.0826162835220396`, -0.3575897704414576}, \
{-1.0682414829293163`, -0.4020131275906138}, {-1.0518299143430017`, \
-0.4466577554624973}, {-1.0365176284493445`, -0.4838968562985486}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0342358643587106`, -0.48944605017105786`}, \
{-1.0333815777630961`, -0.491523654057108}, {-1.0128964731895993`, \
-0.536610823374446}, {-0.9898589337720212, -0.5823368729459207}, \
{-0.9637532926598712, -0.6291194123029419}, {-0.9345795498531493, \
-0.6769584414455093}, {-0.9194832453579722, -0.6998523438759017}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9161802759453657, -0.7048613750256736}, \
{-0.9023377053518555, -0.725853960373623}, {-0.8662099859015995, \
-0.7757057508888765}, {-0.8253786182479905, -0.8264135947928629}, \
{-0.8031990663449287, -0.852088536765631}, {-0.7798436023910287, \
-0.8779774920855824}, {-0.7665655536211159, -0.8921061936690066}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7624565750809563, -0.8964784122541768}, \
{-0.7553122263862904, -0.9040804607527171}, {-0.7296049383307139, \
-0.9303974427670348}, {-0.690813990515847, -0.9675952595548543}, \
{-0.6493526416915236, -1.0039104398120007`}, {-0.6052208918577435, \
-1.0393429835384738`}, {-0.5832393929594015, -1.0555699887781709`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5784122176895762, -1.0591334672633574`}, \
{-0.5584187410145066, -1.073892890734274}, {-0.5093969407907208, \
-1.1067093768386196`}, {-0.4586062428152937, -1.1369416572907292`}, \
{-0.40604664708822524`, -1.164589732090603}, {-0.37184896119335986`, \
-1.1803664685605146`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.36640079210536797`, -1.1828799230734608`}, \
{-0.35171815360951597`, -1.1896536012382404`}, {-0.30674130585499726`, \
-1.2078610331674957`}, {-0.26149319597693504`, -1.2238708269100715`}, \
{-0.21597382397532938`, -1.2376829824659683`}, {-0.17018318985018055`, \
-1.2492974998351862`}, {-0.1383729252165265, -1.2559644096069844`}}]}, 
      {Arrowheads[{{0.0006876429688738445, 1.}}], 
       ArrowBox[{{-0.132267487316828, -1.258838981315296}, \
{-0.1246572923551649, -1.258838981315296}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -0.020153319442996274`}, {-1.4966374575492656`, \
-0.022357256074857983`}, {-1.4632806647084757`, -0.04694929109326862}, \
{-1.4357056703958957`, -0.0707938479182172}, {-1.4030865915635076`, \
-0.10315952363622644`}, {-1.3758871835258188`, -0.13869286683354454`}, \
{-1.3521083179179583`, -0.17323958804960937`}, {-1.3380676217064615`, \
-0.1944581865609232}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.334756588136587, -0.1994618908586575}, \
{-1.32951994080983, -0.2073756235894337}, {-1.3093125407011663`, \
-0.24069028777677706`}, {-1.2909149360847767`, -0.27331946143062785`}, \
{-1.2737559454534708`, -0.30539902536997454`}, {-1.257544030828237, \
-0.33703995298905565`}, {-1.241987654230064, -0.36835321768210977`}, \
{-1.2268539948759085`, -0.3994596647671185}, {-1.221386240618148, \
-0.4108094211518136}}]}, 
      {Arrowheads[{{0.015770934901140902`, 1.}}], 
       ArrowBox[{{-1.2187821651400248`, -0.4162148620130421}, \
{-1.2118844953524759`, -0.43053278268397155`}, {-1.1970791556597675`, \
-0.46157257143266905`}, {-1.182437975797782, -0.4925790310132108}, \
{-1.1677271684079888`, -0.523738024539488}, {-1.1527129461318568`, \
-0.555235415125392}, {-1.1373953089693858`, -0.5870712027709226}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.44875824519260976`, 
        0.7626629198444593}, {-0.48180905526533196`, 
        0.7309281766801876}, {-0.5125309011423449, 
        0.6886363913170149}, {-0.5368291218660507, 
        0.640841495957913}, {-0.5569160749384542, 
        0.5834668452574584}, {-0.5635427373913258, 0.5567755486349601}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5649662895181249, 
        0.5509475348351657}, {-0.5712497025623454, 
        0.5169216518963432}, {-0.5757907309298331, 
        0.480679967104944}, {-0.5783423655819634, 
        0.4429830742520161}, {-0.5786527292292866, 
        0.4042059853813568}, {-0.5765281243624814, 
        0.36473821330914596`}, {-0.5718766680874517, 
        0.32499464720323346`}, {-0.5695705525287914, 0.31243204850258344`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5684872344094748, 
        0.3065306569842752}, {-0.5646064775101014, 
        0.28539017623146873`}, {-0.5543816300440311, 
        0.24646817830723522`}, {-0.541061434856684, 
        0.20866924034748924`}, {-0.5248468566847282, 
        0.17225406502544224`}, {-0.5059388602648318, 
        0.13748335501430578`}, {-0.4880282129161192, 
        0.10978737983665429`}, {-0.47247903522182544`, 
        0.08924648447893885}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4688576808004878, 
        0.08446257476458821}, {-0.4682740224223064, 
        0.08369154584546555}, {-0.4466762887833939, 
        0.059195853040739765`}, {-0.423235011999381, 
        0.03630030142247649}, {-0.3982557046625148, 
        0.015104491069555224`}, {-0.372043879365042, \
-0.0042919779391446256`}, {-0.34459953610696226`, -0.021889105603623407`}, \
{-0.3159226748882756, -0.037686891923880944`}, {-0.2766918991389217, \
-0.05504239167547449}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2712048643851568, -0.0574698285152245}, \
{-0.25656091103286305`, -0.06394824052501677}, {-0.1956481002625858, \
-0.08313982373583655}, {-0.15339969993027452`, -0.09246592819429678}, \
{-0.11196919373429873`, -0.09879109364785063}, {-0.07135658167465893, \
-0.10211532009649806`}, {-0.03715976895468929, -0.10239313083986447`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.03116069132997606, -0.10241426832054067`}, {
        0.007021816831564699, -0.1000977270897481}, {
        0.04400131687005089, -0.09542944985569946}, {
        0.0793766363641039, -0.08843377583809309}, {
        0.11314777531372334`, -0.07911070503692913}, {
        0.14531443754268158`, -0.06782291889128711}, {
        0.17587632687475105`, -0.05493309884024659}, {
        0.19882970165831343`, -0.042465460270831826`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.20410212526072574`, -0.03960162554153516}, {
        0.2321857868482226, -0.02434735702197037}, {
        0.2634574954621296, -0.0030894559076768534`}, {0.2926645323693797, 
        0.019571280318039244`}, {0.3198068975699731, 0.043634851655178025`}, {
        0.34488459106390995`, 0.06910125810373963}, {0.37259462122281095`, 
        0.101281134480979}, {0.38387475649086034`, 0.11629604135798337`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3874786311199401, 0.1210931329412112}, {0.397599223081717,
         0.13456458006797217`}, {0.41989839664062817`, 
        0.16895159486471922`}, {0.43949214189954433`, 0.20444217887122018`}, {
        0.46459336267340057`, 0.2622837526027909}, {0.4821085526700691, 
        0.32256731734121064`}, {0.48431802156250264`, 
        0.3382082561028299}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.48515726090716615`, 0.34414927262547723`}, {
        0.49103160574422683`, 0.38573404812322126`}, {0.49190128867946004`, 
        0.4185925472534005}, {0.49007283440468025`, 0.4524840782075509}, {
        0.4862609255960793, 0.48148005944635575`}, {0.48014736271476544`, 
        0.5114575084037987}, {0.47173214576073874`, 0.5424164250798799}, {
        0.46101527473399917`, 0.5743568094745993}, {0.45894052461446067`, 
        0.5795356565042331}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.45670920359108574`, 0.5851053249405627}, {
        0.4477321183517398, 0.6075133011053727}, {0.43161804533115355`, 
        0.6421205394896154}, {0.41267305567224055`, 0.6781785246273279}, {
        0.3908971493750007, 0.7156872565185096}, {0.3650727804722286, 
        0.7564757015774699}, {0.3395234739137319, 0.7938905143386392}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.33613990930908966`, 0.7988454604096084}, {
        0.3359793642173871, 0.7990805652071504}, {0.30369331018983425`, 
        0.8433280514558326}, {0.26829102796892795`, 0.8890443643717978}, {
        0.22999566081173, 0.9355852938123792}, {0.1890303519753022, 
        0.9823066296349102}, {0.18587159196463468`, 0.9858022665102714}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.18184888522103598`, 0.9902539887000543}, {
        0.17137738337140931`, 1.0018422600097927`}, {0.1533198896210541, 
        1.021185551035423}, {0.10718207513838668`, 1.0642016652757942`}, {
        0.05987234022536127, 1.1029877675338688`}, {0.012955768134153292`, 
        1.13838617197609}, {0.0003366208490598252, 1.1462905646969967`}}]}, 
      {Arrowheads[{{0.019710794300019988`, 1.}}], 
       ArrowBox[{{-0.004748210694997435, 
        1.1494756060104745`}, {-0.034581004510847724`, 
        1.1681622979837805`}, {-0.08240043731109997, 
        1.1920631312765324`}, {-0.13016498986806171`, 
        1.209835657573937}, {-0.17774116192261408`, 
        1.2220229691194446`}, {-0.22499545321563813`, 
        1.229168158156505}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 1.0096393731201305`}, {1.4845009095226973`, 
        1.0233620477105159`}, {1.449365735000493, 1.0588947525798424`}, {
        1.4202349087116195`, 1.0938871464388509`}, {1.384127489708439, 
        1.1437216193125088`}, {1.3560682330046843`, 1.1915746778627776`}, {
        1.3527143889160047`, 1.1974718489113243`}}]}, 
      {Arrowheads[{{0.01659560672596972, 1.}}], 
       ArrowBox[{{1.3497482075011025`, 1.2026873803141527`}, {
        1.3309726048823518`, 1.235701121339279}, {1.3069045670577535`, 
        1.2773671462980065`}, {1.2848917098286239`, 1.314112334221186}, {
        1.264509386004598, 1.3457490902670972`}, {1.245332948395312, 
        1.372089819594021}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6493768941287084, 0.41400890409198365`}, {
        0.6591593867569084, 0.46019236771227423`}, {0.6659871777141885, 
        0.5090938645527692}, {0.6693141011972386, 0.5664448389451757}, {
        0.6675884789907284, 0.6285312374755135}, {0.6654100122932207, 
        0.6522898011805877}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6648621593714151, 0.6582647369271936}, {0.664559994702382,
         0.6615601733673558}, {0.6597264368886326, 0.696192870443579}, {
        0.6530878055494808, 0.7324293287041834}, {0.6446441006849262, 
        0.7702695481491686}, {0.6327633969895321, 0.8145096180988469}, {
        0.6180106577101873, 0.8608625771034852}, {0.6070169236511198, 
        0.890552932351447}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6049334864493031, 0.8961795911669507}, {
        0.6001849727597272, 0.9090037196737737}, {0.5790854320509872, 
        0.9586083403204017}, {0.5546120194451993, 1.0088076012647487`}, {
        0.5266647188035959, 1.0587326647281938`}, {0.5088965302971649, 
        1.0885343980280249`}, {0.49541214406840384`, 
        1.1091817579361187`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.49213134310638, 1.1142053368443856`}, {
        0.48989348048027326`, 1.117631963335367}, {0.4595354516376262, 
        1.1539622291391456`}, {0.427242782780847, 1.1868265556531228`}, {
        0.3941707615976445, 1.2175583537336976`}, {0.35954003576159577`, 
        1.2440250949474676`}, {0.3236769714452164, 1.266164594411341}, {
        0.31322248415188075`, 1.271211447086947}}]}, 
      {Arrowheads[{{0.008496060503542754, 1.}}], 
       ArrowBox[{{0.30781914576396213`, 1.273819882300949}, {
        0.2869079348210223, 1.2839146672422264`}, {0.2495525820078091, 
        1.2976312125029794`}, {0.21193056912437253`, 1.3076701292564559`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3763301967882926`, -1.5}, {
        1.3868936435133958`, -1.479301431659909}, {
        1.4049096033418647`, -1.4450837049199963`}, {
        1.4207385461295083`, -1.4151252728760728`}, {
        1.431780391440064, -1.3929972665805554`}, {
        1.4415560627225226`, -1.3724517909460032`}, {
        1.45872129054272, -1.3339006009082115`}, {
        1.4715703236036886`, -1.2997163871152453`}, {
        1.4767915273616712`, -1.282483934723454}}]}, 
      {Arrowheads[{{0.006882116107992417, 1.}}], 
       ArrowBox[{{1.4785313423736464`, -1.2767417187989083`}, {
        1.480962082350897, -1.2687191223103584`}, {
        1.48953514415676, -1.2307717703985097`}, {
        1.4943256013303756`, -1.1957994133824157`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 0.8004675190663401}, {1.4872274707718425`, 
        0.8115453102031743}, {1.4522319368770327`, 0.8467258694769534}, {
        1.4238628097928117`, 0.8820980216397839}, {1.3951312062874524`, 
        0.9328779765521028}, {1.3701324650524633`, 0.9840687772556409}, {
        1.3647218258541844`, 0.9956844717076626}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.3621883657116112`, 1.001123366789018}, {1.34638097396483, 
        1.03505906752331}, {1.3251239831719086`, 1.0856483369192413`}, {
        1.30569531180163, 1.1350606706663955`}, {1.2874287789819256`, 
        1.182520153987734}, {1.2715552142961444`, 1.2232796555205}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.14124974124168843`, 0.4984254268667703}, {
        0.10081701313255512`, 0.5319656722808478}, {0.05642037773507419, 
        0.5593862864203641}, {0.011319770118619229`, 
        0.5787683079884278}, {-0.010600846288473654`, 
        0.5848691761550393}, {-0.03152943457355817, 
        0.5881602695108276}, {-0.06077188389469293, 
        0.587072572462926}, {-0.07293889016940477, 0.5825122911800693}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.07855722132096057, 
        0.5804065003377828}, {-0.08538352180928847, 
        0.5778479539176352}, {-0.11221614510445532`, 
        0.5428700344799412}, {-0.11346539773935244`, 
        0.5393714875519076}, {-0.11458747069735058`, 
        0.5357420358152981}, {-0.11624657515431534`, 
        0.5174131021403587}, {-0.11522841227143486`, 
        0.49727779654214943`}, {-0.10785456894870514`, 
        0.45456528262373924`}, {-0.09005352004810824, 
        0.4090992400422999}, {-0.06354792405446026, 
        0.36626036082842095`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.05980439982528157, 
        0.3615845624958017}, {-0.040126115357160076`, 
        0.3383795051305284}, {-0.014892891221609608`, 0.31539491820253096`}, {
        0.038953501948185254`, 0.28335658963731025`}, {0.09143732116364209, 
        0.27121858929072545`}, {0.14746621829010892`, 0.2817213757985828}, {
        0.14890966154702567`, 0.28297450309493566`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.15344046502754546`, 0.28690792651746594`}, {
        0.1846777957657932, 0.31402665919069417`}, {0.19962703175894195`, 
        0.3597730358809179}, {0.1909519434086748, 0.4116055683226428}, {
        0.1615542727848969, 0.46217066577141325`}, {0.13363458651142868`, 
        0.4900602498739562}}]}, 
      {Arrowheads[{{0.001546583614558306, 1.}}], 
       ArrowBox[{{0.12697802275455028`, 0.5050076833052989}, {
        0.11867101980988783`, 0.5050076833052989}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.32313378495326023`, -1.5}, {
        0.34147907259288224`, -1.4797058172206803`}, {
        0.37155732503504835`, -1.4520157136735499`}, {
        0.41287501132604876`, -1.419642040119646}, {
        0.44238135597150463`, -1.4027316742246543`}, {
        0.47187143449745883`, -1.3873655933520233`}, {
        0.5015274605826748, -1.3729605192566998`}, {
        0.518920044270944, -1.3652173766007243`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5244013796078213, -1.3627770973288582`}, {
        0.5312886963342317, -1.3597108780203693`}, {
        0.5617111258576675, -1.3459859545787256`}, {
        0.5924254370697946, -1.3329944983204174`}, {
        0.6234316299706133, -1.3207365092454455`}, {
        0.6547297045601235, -1.309211987353809}, {
        0.6864255218506267, -1.2981662356066932`}, {
        0.7186249428544244, -1.287344556965282}, {
        0.7485990518870244, -1.277631272443141}}]}, 
      {Arrowheads[{{0.002638154299599981, 1.}}], 
       ArrowBox[{{0.7560015568389673, -1.2668996966567212`}, {
        0.7828499329683618, -1.2668996966567212`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, 0.17535835801672126`}, {-1.4797009911027752`, 
        0.15922523643254244`}, {-1.4529290160112522`, 
        0.13386834054777888`}, {-1.4222341492366017`, 
        0.10002403719330386`}, {-1.3925219002458749`, 
        0.055097966015299905`}, {-1.3673543714530438`, 
        0.01166380810862478}, {-1.3541059156683912`, \
-0.012371328645622827`}}]}, 
      {Arrowheads[{{0.010016124538564986`, 1.}}], 
       ArrowBox[{{-1.3512095149181873`, -0.01762593259779828}, \
{-1.3412099708297678`, -0.035766945675239845`}, {-1.3187236999759278`, \
-0.08150591186046591}, {-1.2988413096339433`, -0.125755928065711}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.783865066004282, 0.4481566502706902}, {0.8051998605582156,
         0.5084599417695997}, {0.8185318872943566, 0.5556158401919321}, {
        0.8299365201070689, 0.605994808176195}, {0.8390088134478466, 
        0.6601196473510882}, {0.8412194153537547, 0.6804960702979513}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8418665475545746, 0.6864610698716866}, {
        0.8453438217681841, 0.7185131593453115}, {0.8473592202321119, 
        0.7493975890917945}, {0.8484390498137777, 0.7815230299273548}, {
        0.8485833105131816, 0.8148894818519925}, {0.8477920023303235, 
        0.8494969448657079}, {0.844479626658415, 0.9045468768188001}, {
        0.8422101823073426, 0.9259603229236746}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8415778304881667, 0.9319269074723745}, {
        0.8383922754469847, 0.9619843579475217}, {0.8293062651791037, 
        1.020760465328738}, {0.8169979123378429, 1.0798262760393147`}, {
        0.8013368888945209, 1.137270072084386}, {0.791155562969827, 
        1.1659409503260143`}}]}, 
      {Arrowheads[{{0.017984123634941195`, 1.}}], 
       ArrowBox[{{0.7891477397818654, 1.1715950325721338`}, {
        0.7821928668204564, 1.1911801354690872`}, {0.7683497718163181, 
        1.2257410744653372`}, {0.7529500261915336, 1.2574241850394283`}, {
        0.7402717849986172, 1.2757361751254739`}, {0.7268893802409411, 
        1.2923167454056959`}, {0.6987653601477333, 1.3218828766392046`}, {
        0.668030039291692, 1.3445381523655562`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.058219090505088916`, -0.4112699757291027}, \
{-0.02584519719356819, -0.40975709606779426`}, {
        0.03733257999963281, -0.4032428636526958}, {
        0.08443138702900033, -0.395089398565539}, {
        0.12982921259895047`, -0.3841997408817527}, {
        0.17352605670948326`, -0.3705738906013369}, {
        0.1770864404972297, -0.36918672652096535`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.1826771040175301, -0.36700854347016765`}, {
        0.21552191936059872`, -0.35421184772429154`}, {
        0.25601045796278077`, -0.33535579499658713`}, {
        0.2951853299265135, -0.31424791516419404`}, {
        0.33304653525179667`, -0.29088820822711237`}, {
        0.3695940739386303, -0.2652766741853422}, {
        0.3905162944898067, -0.24906017447291776`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.395258589579711, -0.24538449259328377`}, {
        0.40508727561233626`, -0.23776642529341413`}, {
        0.4397854698982364, -0.20871057380585878`}, {
        0.4736886567963307, -0.17810911972267635`}, {
        0.506796836306619, -0.14596206304386677`}, {
        0.5463560039499014, -0.10528911951029586`}, {
        0.5693746646104111, -0.08060627126638187}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.5734668004720078, -0.07621828492977661}, {
        0.5855411373867534, -0.0632710057588452}, {
        0.6243522366171752, -0.01990772178951462}, {0.6627893016411671, 
        0.024800732397695993`}, {0.6983277765087393, 0.06751726835209107}, {
        0.7296248861222396, 0.1059635127766293}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.7334127805764226, 0.1106166682225574}, {
        0.7339138052131896, 0.11123214089354018`}, {0.7545735001268609, 
        0.1369563419960292}, {0.7752915865639767, 0.16306460013368518`}, {
        0.7960287506096644, 0.18962043603373532`}, {0.816745678349051, 
        0.21668737042340697`}, {0.8375206381992445, 0.24423676120900334`}, {
        0.858337832711768, 0.27231369655356685`}, {0.879016849173372, 
        0.3010922925694339}, {0.8791356220729373, 0.30126528187204127`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8825317412432522, 0.30621163149383507`}, {
        0.8993772748708069, 0.3307466653689406}, {0.9184731852549827, 
        0.3602225579545436}, {0.9370515607021468, 0.39070380287684797`}, {
        0.9551124012122991, 0.4221904001358537}, {0.9726557067854396, 
        0.4546823497315607}, {0.989415802737045, 0.4884542330361882}, {
        1.0009950569506523`, 0.5144899937775249}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0034332600532831`, 0.5199722529496473}, {
        1.0051270143825917`, 0.5237806314219551}, {1.0197893417220798`, 
        0.5606615448888616}, {1.0334027847555094`, 0.5990969734369076}, {
        1.0457032612191348`, 0.6394310074484029}, {1.0564266888492102`, 
        0.6820077373056566}, {1.0655730676457358`, 0.726827163008669}, {
        1.0693128404011525`, 0.7500791074794605}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.070265617547431, 0.7560029757856882}, {
        1.0731423976087113`, 0.7738892845574402}, {1.0788359394737266`, 
        0.8217779417673563}, {1.0827656067883458`, 0.8719950167268653}, {
        1.084876127014402, 0.9242833171474393}, {1.0851122276137295`, 
        0.9783856507405505}, {1.084607454484232, 0.9952316651847259}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.084427751440052, 1.0012289734822801`}, {
        1.0834601543723834`, 1.0335210136594342`}, {1.0799061530764205`, 
        1.0889084020573256`}, {1.0762451381893838`, 1.134022042986849}, {
        1.0713293371387702`, 1.1781031044024188`}, {1.0626687995710422`, 
        1.2238226554923544`}, {1.0588701607607007`, 1.2394097810629103`}}]}, 
      {Arrowheads[{{0.012395795032865043`, 1.}}], 
       ArrowBox[{{1.0574495176637047`, 1.2452391698122525`}, {
        1.0526647571413692`, 1.2648726929794571`}, {1.0420499436699906`, 
        1.3030083735616702`}, {1.0302135881152013`, 1.335315340334104}, {
        1.0033965878880047`, 1.3828173837920847`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.2811740296422659, 
        0.9772574802070793}, {-0.3186298913366256, 
        0.9935540335773917}, {-0.3575338656478726, 
        1.0074094145311463`}, {-0.39814443410815975`, 
        1.0183406717485357`}, {-0.4340451050964298, 
        1.0249960795416113`}, {-0.47154605396613897`, 
        1.0291143483084213`}, {-0.5109116795832866, 
        1.0305011465499407`}, {-0.513080237654703, 1.0304207165437917`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5190761150892068, 
        1.0301983344617613`}, {-0.552406380813872, 
        1.0289621427671445`}, {-0.604032020259, 
        1.0230808895974168`}, {-0.6595993097695235, 
        1.0124419087848915`}, {-0.6889929658849046, 
        1.005163166961665}, {-0.7196358196878264, 
        0.9963447861259085}, {-0.7515278711782895, 
        0.9859867662776233}, {-0.7537968438421276, 0.9851722084867003}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7594439685073932, 
        0.9831448991824869}, {-0.7846691203562932, 
        0.9740891074168084}, {-0.8277379715194735, 
        0.9567252044230441}, {-0.872712886533191, 
        0.9362335446254137}, {-0.9191706758122256, 
        0.9122386876270433}, {-0.9666881497713568, 
        0.8843651930310586}, {-0.9749414159593269, 0.8787894415036098}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.9799131676407865, 
        0.8754306195050657}, {-1.014282320479431, 
        0.852211465769722}, {-1.0609702000052945`, 
        0.8153759107752951}, {-1.0864476502366438`, 
        0.7937878869952977}, {-1.1111302124084426`, 
        0.7706553659244927}, {-1.139620737325321, 
        0.735631828861714}, {-1.1546430074773029`, 0.7135791135856178}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1580209294345702`, 
        0.7086203190495827}, {-1.1653684891968887`, 
        0.6978340902191061}, {-1.1895039528430753`, 
        0.6587278592134309}, {-1.2104148400384995`, 
        0.6170046434816212}, {-1.2280204255271276`, 
        0.5728821110799347}, {-1.2422399840529261`, 
        0.5265779300646297}, {-1.2507871919595936`, 0.4891609768723738}}]}, 
      {Arrowheads[{{0.004603781193380076, 1.}}], 
       ArrowBox[{{-1.2521233624858048`, 
        0.4833116479942131}, {-1.2532358631471754`, 
        0.47844147452617547`}, {-1.2611704103411563`, 0.4288221185550415}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 0.6211177934763256}, {1.4678333849204643`, 
        0.649881126678817}, {1.4411859883457863`, 0.6795547608522278}, {
        1.4147972659599397`, 0.7222453111076074}, {1.3922129980963749`, 
        0.7658126608718185}, {1.3709406979517467`, 0.8098596996018278}, {
        1.3675757705095397`, 0.8179806972807927}}]}, 
      {Arrowheads[{{0.015141452680794878`, 1.}}], 
       ArrowBox[{{1.365279029038642, 0.8235237089726313}, {
        1.3522923332449925`, 0.8548661162634335}, {1.3355619458861894`, 
        0.900790508779227}, {1.3200435777854163`, 0.9475914750718004}, {
        1.3054065423482548`, 0.9949693864312119}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.1257485529832957, -1.5}, {
        0.13845350371941764`, -1.4871605290437953`}, {
        0.16992878623027252`, -1.460769963743737}, {
        0.20901993475897707`, -1.4328856027289314`}, {
        0.25982997750361586`, -1.4065189917788705`}, {
        0.3099083737259984, -1.383907501871512}, {
        0.3289205925339207, -1.3758364312431268`}}]}, 
      {Arrowheads[{{0.008160576066662213, 1.}}], 
       ArrowBox[{{0.33444353153020384`, -1.3734918321636818`}, {
        0.36796491873038467`, -1.3592613266983562`}, {
        0.4256528262560104, -1.337916845800049}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, 0.3574810586000434}, {-1.4937127230661964`, 
        0.35236532334821435`}, {-1.4678834600477557`, 
        0.32684900917949194`}, {-1.4364936902389867`, 
        0.2900218735305615}, {-1.4108494575662396`, 
        0.24682145158680055`}, {-1.3890904487052576`, 
        0.20450926989741786`}, {-1.368688482997969, 
        0.1626836644474044}, {-1.3675587010767185`, 
        0.16007428647946412`}}]}, 
      {Arrowheads[{{0.006544454941708304, 1.}}], 
       ArrowBox[{{-1.3651747416437847`, 
        0.1545682227836714}, {-1.3510006035980688`, 
        0.1218312114761296}, {-1.3353316061475138`, 0.0819384150551629}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.5, 0.6349471744177637}, {-1.4988591359966155`, 
        0.6340128694189087}, {-1.476358336546276, 
        0.6111818317894921}, {-1.446665733754519, 
        0.5744238465036111}, {-1.4373521701012135`, 
        0.5580118077707091}, {-1.4287680870021218`, 
        0.5415361637974263}, {-1.4128398459783487`, 
        0.5084747071294488}, {-1.3990674137212828`, 
        0.47520929240913573`}, {-1.3869023001605127`, 
        0.44178196726816943`}, {-1.3827491837261618`, 
        0.4289418558257751}}]}, 
      {Arrowheads[{{0.0026132307026085623`, 1.}}], 
       ArrowBox[{{-1.3785805514384877`, 
        0.40057549884017374`}, {-1.3735741244668946`, 
        0.40057549884017374`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.2931650392349688, 
        0.709745169221083}, {-0.31771098487825533`, 
        0.6861195953922162}, {-0.34652919300075224`, 
        0.6305662914258824}, {-0.3549783971167772, 
        0.5938549044047154}, {-0.3584138830796887, 
        0.5513674559261958}, {-0.3561269910515872, 
        0.5041631886697051}, {-0.3534592073260186, 0.4885988975844848}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.352445564867198, 
        0.48268513998329116`}, {-0.34740906119457304`, 
        0.4533013453146255}, {-0.33198483976891846`, 
        0.4006817009952883}, {-0.3095790730348953, 
        0.3482040308460246}, {-0.2806872664489397, 
        0.2978343384058448}, {-0.25648058128084517`, 0.26570731728487884`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2528699538857285, 
        0.260915306244237}, {-0.2458049254674875, 
        0.25153862721375897`}, {-0.20615094223048075`, 
        0.21051331004188517`}, {-0.16294420887786215`, 
        0.17595479966234173`}, {-0.10822544981419625`, 
        0.14322694439163292`}, {-0.059928136303202845`, 
        0.12364563215715622`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.054367753618986936`, 
        0.12139127096048168`}, {-0.05278232030858539, 0.12074848438663122`}, {
        0.001672417602705447, 0.10783202004269693`}, {0.05342600188341215, 
        0.10379015175519003`}, {0.11500449043044317`, 0.10971585780783483`}, {
        0.1692774149552019, 0.12646945035886994`}, {0.1795927536093674, 
        0.13209481739687645`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.18486038062264434`, 0.13496746524320136`}, {
        0.2159192695032094, 0.15190512047716537`}, {0.2546045481199866, 
        0.18387705923159106`}, {0.2905281968318204, 0.2291379599116519}, {
        0.3142748766559375, 0.2796058239574759}, {0.32228494487191983`, 
        0.3196888934004693}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.32346071780394464`, 0.32557256215493857`}, {
        0.3251429281817724, 0.3339904873927855}, {0.32243069199875957`, 
        0.39100178624130294`}, {0.3088817977451867, 0.4416586454910327}, {
        0.28449500690222146`, 0.4935284199117792}, {0.2494557158681801, 
        0.5464831388249818}, {0.24877889568717265`, 0.5473351649005463}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.24504688855491036`, 0.5520332626820685}, {
        0.22810749269175734`, 0.5733576962387544}, {0.20439340370113937`, 
        0.6005122684488381}, {0.1649469459234559, 0.6416603700411914}, {
        0.12119377990775204`, 0.6835817158582403}, {0.09812101214176232, 
        0.7046769479693801}, {0.07734877294380771, 0.7232357171831727}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.07286107932407201, 0.7272181394782499}, {
        0.04957819377660784, 0.747566013480293}, {0.0241081431774431, 
        0.769359846880066}, {-0.002099031513618352, 
        0.791298854708681}, {-0.028981360110748144`, 
        0.8132953442987685}, {-0.05653884261394632, 
        0.8353493156503288}, {-0.08477147902321286, 
        0.8574607687633617}, {-0.09597844190764601, 
        0.8661454897766717}, {-0.10729637935669256`, 
        0.874805668946986}, {-0.11307938619442648`, 0.8788526890121527}}]}, 
      {Arrowheads[{{0.008493939754460523, 1.}}], 
       ArrowBox[{{-0.11799521086277556`, 
        0.8822928442165078}, {-0.15427938623325638`, 
        0.9076849611364158}, {-0.20313083696064926`, 
        0.9382788487329112}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.07170592455365979, -1.5}, {-0.0580708729479998, \
-1.4888588579265614`}, {-0.02089151743152478, -1.4625488239345263`}, {
        0.015452113473533542`, -1.4410003914225953`}, {
        0.05891930872416937, -1.4213276150048058`}, {
        0.10151267787561008`, -1.4041279736619363`}, {
        0.13978563179066766`, -1.389573907302118}}]}, 
      {Arrowheads[{{0.011703735068257837`, 1.}}], 
       ArrowBox[{{0.1453938298255623, -1.387441276344497}, {
        0.1619968704291404, -1.381127633680397}, {
        0.22104256292473784`, -1.3615557752385974`}, {
        0.27903205728585756`, -1.3443895722045578`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -0.6381256004021509}, {-1.4884312769549646`, \
-0.6445794885407993}, {-1.4498552921895427`, -0.6687335344072585}, \
{-1.417196843409184, -0.6927310267411292}, {-1.3815724832461889`, \
-0.7272707050840744}, {-1.3498932433041089`, -0.7620907606984532}, \
{-1.3210421924872373`, -0.7953349176713929}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3172490566794823`, -0.7999815873922667}, \
{-1.2917752161570175`, -0.832424201695038}, {-1.2659711520660382`, \
-0.8681229437648113}, {-1.2414365342031228`, -0.9041923992097194}, \
{-1.2178021883215426`, -0.940544649524979}, {-1.1946989401745687`, \
-0.9770917762058072}, {-1.1816696103459452`, -0.9978203978268294}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.1784765967920017`, -1.002900227001549}, \
{-1.1726232753359787`, -1.0122123932667368`}, {-1.1504478720230589`, \
-1.0468906185986893`}, {-1.1281727302358089`, -1.0811264522016644`}, \
{-1.1057978499742285`, -1.114919894075662}, {-1.0830754341362698`, \
-1.1476795570765512`}, {-1.0597576856198847`, -1.1788140540602001`}, \
{-1.0423192978321938`, -1.200333453946619}}]}, 
      {Arrowheads[{{0.012236189020807175`, 1.}}], 
       ArrowBox[{{-1.0385417637088894`, -1.2049950240627143`}, \
{-1.0358446044250729`, -1.2083233850266095`}, {-1.0113361905518345`, \
-1.2362075499757785`}, {-0.9860820969002876, -1.2620528163329003`}, \
{-0.9599319763705502, -1.2854454515231666`}, {-0.9328858289626223, \
-1.306385455546578}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 0.4659338734838492}, {1.4740452263933639`, 
        0.4885355736328016}, {1.4486225895280547`, 0.5161499161852187}, {
        1.4237892820502698`, 0.5553946662182301}, {1.4028505267062166`, 
        0.5950708578840258}, {1.3832777159269944`, 0.6350976590848203}, {
        1.370977869426221, 0.6648435606474133}}]}, 
      {Arrowheads[{{0.000490329262122424, 1.}}], 
       ArrowBox[{{1.3681566289172957`, 0.6745474826444859}, {
        1.3669653250167564`, 0.6745474826444859}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.188476432146091, 1.5}, {-1.2094249128322465`, 
        1.4607126843974443`}, {-1.2309699289796816`, 
        1.423376621977482}, {-1.2510172763348337`, 
        1.3913672120139786`}, {-1.2741375205818557`, 
        1.3570362093131338`}, {-1.2946781312782063`, 
        1.326294658386884}, {-1.3139066309635445`, 
        1.2967985098646255`}, {-1.3144451260717314`, 
        1.2959226966687785`}}]}, 
      {Arrowheads[{{0.002056122462482816, 1.}}], 
       ArrowBox[{{-1.3204241335171008`, 
        1.2744063109972958`}, {-1.3276745093293647`, 1.2744063109972958`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.8717861399184024, 1.5}, {-0.8759699999178087, 
        1.4922703603850036`}, {-0.8970354162278429, 
        1.457457528973495}, {-0.9179417152726934, 
        1.4279634996961004`}, {-0.949614516228287, 
        1.3942199094744494`}, {-0.9811440409911165, 
        1.36463165943938}, {-1.0125043054308183`, 
        1.3364669396299722`}, {-1.0300902687985867`, 1.322114573335111}}]}, 
      {Arrowheads[{{0.013010679783420813`, 1.}}], 
       ArrowBox[{{-1.0347386920418058`, 
        1.318320873116077}, {-1.0435260492242653`, 
        1.311149280271889}, {-1.0740469747273083`, 
        1.2880023014884103`}, {-1.1039047842957979`, 
        1.2663496234028178`}, {-1.1328763569212952`, 
        1.2458539549497079`}, {-1.1607385715953595`, 1.2261780050636772`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.013125799435159255`, 1.}}], 
       ArrowBox[{{1.5, 1.4414804993522718`}, {1.489448283390374, 
        1.4436930749546701`}, {1.4570982495128288`, 1.4504390137036873`}, {
        1.4293289256356878`, 1.4558877440097593`}, {1.4054736472559823`, 
        1.459806463097352}, {1.3839986561676378`, 1.4629338641338965`}, {
        1.3447950935378736`, 1.4678220120335799`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.012976768783036267`, 1.}}], 
       ArrowBox[{{0.09906610939362587, 1.5}, {0.08773492875454608, 
        1.483334108419489}, {0.06812557147849725, 1.459633710692922}, {
        0.057372138684016825`, 1.4494280961425485`}, {0.04677046039908369, 
        1.4400694725667986`}, {0.02585662236906592, 1.422806263165976}, {
        0.00549242321036939, 1.4081001112488964`}, {-0.014374601119203358`, 
        1.3953565785537143`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.01465689056562825, 1.}}], 
       ArrowBox[{{1.5, 0.32811911627001}, {1.4903064698500328`, 
        0.3361728996610317}, {1.4657910013768511`, 0.36139847386548235`}, {
        1.455479027970718, 0.37522157120684374`}, {1.4459917901636494`, 
        0.38898602723779835`}, {1.428428345906122, 0.41643098079699037`}, {
        1.413338582030245, 0.4437605667450232}, {1.4001308839796847`, 
        0.47107347545424305`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8798102077044306, -0.43857092101419837`}, \
{-0.858699925829089, -0.47130346835323195`}, {-0.8351866545713567, \
-0.5039077109227286}, {-0.809106236624489, -0.5364258870094984}, \
{-0.7802945146817423, -0.5689002349003516}, {-0.7486004644167159, \
-0.6013452581491785}, {-0.7263836210041796, -0.6220924682135569}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.721998420782346, -0.6261875895810417}, \
{-0.7138730615030088, -0.6337754603098704}, {-0.676036510785885, \
-0.6661813963120777}, {-0.6350000873940157, -0.6985332981713979}, \
{-0.6020142090450399, -0.7227886079503185}, {-0.5673313656532899, \
-0.7469005873123666}, {-0.5309515572187661, -0.7708692362575421}, \
{-0.5309011045147064, -0.7709008054172966}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.525814756474338, -0.7740834244036411}, \
{-0.4928747837414684, -0.7946945547858449}, {-0.45336871644173454`, \
-0.8182527099081429}, {-0.41270102653990204`, -0.8414198686353037}, \
{-0.3708717140359711, -0.8641960309673276}, {-0.32788077892994166`, \
-0.8865811969042142}, {-0.3169145528008438, -0.89202843101783}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3115409756460039, -0.8946976384958997}, \
{-0.27795827587238764`, -0.9113791135704254}, {-0.22756143056969824`, \
-0.9351666291136067}, {-0.17669024302187372`, -0.9579437435337574}, \
{-0.12534471322891416`, -0.9797104568308779}, {-0.09258939883296699, \
-0.9927825494511644}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.08701677853250485, -0.9950064880714679}, \
{-0.0774856676056407, -0.9988101934276163}, {-0.029804925333131442`, \
-1.0165825390009255`}, {0.017697513588613455`, -1.0330274935508048`}, {
        0.06502164915959381, -1.0481450570772546`}, {
        0.11218537222279998`, -1.0618059475038262`}, {
        0.1410505792772011, -1.0692184655978132`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.14686202040401827`, -1.070710830174429}, {
        0.159206573621222, -1.0738808827540711`}, {
        0.20608525335486003`, -1.0843698628279899`}, {
        0.2528214114237138, -1.0932728877255815`}, {
        0.29968704382271166`, -1.1005715159308314`}, {
        0.3469541465467818, -1.1062473059277234`}, {
        0.3834258764346377, -1.109348262248097}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.38940430629508893`, -1.1098565696390181`}, {
        0.3946227195959243, -1.110300257716258}, {
        0.44269276297013915`, -1.112730371296435}, {
        0.47689851975583913`, -1.1134645003212484`}, {
        0.5118449727032347, -1.1133976391745528`}, {
        0.5475321218123259, -1.1125297878563478`}, {
        0.5839599670831126, -1.1108609463666337`}, {
        0.6211285085155948, -1.1083911147054104`}, {
        0.6291556017043416, -1.1076985343919736`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6351333927351479, -1.1071827685613762`}, {
        0.6590377461097727, -1.1051202928726782`}, {
        0.6976876798656462, -1.1010484808684367`}, {
        0.7370783097832151, -1.096175678692686}, {
        0.7820628137049684, -1.0902096116268758`}, {
        0.8283835039090865, -1.0831661150797611`}, {
        0.8701324199250334, -1.0749426067982517`}, {
        0.8727431421798771, -1.07438571047751}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.8786111256874568, -1.073134003820672}, {
        0.9127603890772786, -1.0658495831579446`}, {
        0.9557229053939469, -1.0557919811356185`}, {
        0.9992014708656637, -1.0448014884056807`}, {
        1.0421759146844916`, -1.0337598412084632`}, {
        1.0845050042206634`, -1.0217202883142962`}, {
        1.1109745024464006`, -1.0134414000393648`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.1167009405225312`, -1.0116503369583314`}, {
        1.1261887394741799`, -1.0086828297231796`}, {
        1.1672271204450397`, -0.994647465435113}, {
        1.2066186068044107`, -0.9795994760991893}, {
        1.2433616582234592`, -0.9635241423645012}, {
        1.2774562747021856`, -0.9464214642310489}, {
        1.3089024562405893`, -0.9282914416988315}, {
        1.3337373123662732`, -0.9115132374493266}}]}, 
      {Arrowheads[{{0.005007336926839006, 1.}}], 
       ArrowBox[{{1.3386152814805574`, -0.9080280591187164}, {
        1.3620045391892375`, -0.8890032909121209}, {
        1.3831991967726838`, -0.8678586445261318}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3040677946957218, -0.7181862975851201}, {
        0.3569549319490194, -0.7108909005578685}, {
        0.40961412584764556`, -0.7006425990630752}, {
        0.46267235910988935`, -0.6870219218574238}, {
        0.5167566144540398, -0.6696093976975976}, {
        0.536699457055983, -0.6619361386368517}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.542299254524245, -0.6597815462590582}, {
        0.5718668918800967, -0.6484050265835968}, {
        0.6280031913880599, -0.623408808515421}, {
        0.6808073981151166, -0.5968842179566769}, {
        0.7352291852585214, -0.5666762050931063}, {
        0.757190256997766, -0.5536494198404686}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7623506848491598, -0.5505883768171579}, {
        0.763052698240841, -0.5501719591756835}, {
        0.7912926598362209, -0.5327089454393985}, {
        0.8199490700446608, -0.5142871638842512}, {
        0.849021928866161, -0.49490661451024187`}, {
        0.8784007672074626, -0.47458840941091324`}, {
        0.9079751159753063, -0.45335366067980765`}, {
        0.9377449751696925, -0.4312023683169255}, {
        0.9597243353783317, -0.4142822941454956}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9644787331759836, -0.41062228026824293`}, {
        0.9677103447906209, -0.4081345323222666}, {
        1.0016216257999664`, -0.38159702308397025`}, {
        1.0353892382010494`, -0.35398895604274494`}, {
        1.0623917872679816`, -0.32914076097359546`}, {
        1.0888030037699845`, -0.3036775424102503}, {
        1.1140849759877485`, -0.27779182934866975`}, {
        1.13841700782771, -0.25141944545686706`}, {
        1.1409816265033652`, -0.24862154178876994`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.1450358657331432`, -0.24419851745380078`}, {
        1.1623189980573057`, -0.2253432623685083}, {
        1.1848018347712834`, -0.19896110922602855`}, {
        1.2058655179696431`, -0.1722729860294278}, {
        1.2255100476523848`, -0.1452788927787061}, {
        1.259958715372515, -0.09084349590539265}, {
        1.2815595389197418`, -0.048028781002361756`}}]}, 
      {Arrowheads[{{0.013688996674990628`, 1.}}], 
       ArrowBox[{{1.2842621677315469`, -0.04267193514816723}, {
        1.2875649068331743`, -0.03612561839658121}, {1.3087241210299212`, 
        0.018562216456635958`}, {1.3238318569583143`, 0.07290748536316655}, {
        1.3319820529733, 0.11399806119559401`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.37397867707840293`, -0.8237593677219617}, {
        0.41939733219235825`, -0.8208796480747533}, {
        0.4653715920032173, -0.8160839947212383}, {
        0.5119014565109803, -0.8093724076614162}, {
        0.5594300885463623, -0.8004482025049269}, {
        0.6084006509400792, -0.7890146948614101}, {
        0.6109145094524068, -0.7883194256926184}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6166974077346754, -0.7867200234739958}, {
        0.6588131436921305, -0.775071884730866}, {
        0.7106675668025165, -0.7586197721132943}, {
        0.7627739071104332, -0.7399141867490696}, {
        0.816652433879277, -0.7182981675758072}, {
        0.8426752953022363, -0.7067104033585704}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8481564397009412, -0.704269695248094}, {
        0.8721224851644964, -0.6935978141072201}, {
        0.9290033990215396, -0.665639225857021}, {
        0.9577975157857923, -0.6504135949496228}, {
        0.9865935209355954, -0.6343244078684336}, {
        1.0153914144709488`, -0.6173716646134534}, {
        1.0441911963918526`, -0.599555365184682}, {
        1.0590112569764007`, -0.5901654069847994}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.064079565384923, -0.5869541377846074}, {
        1.0844852564936738`, -0.5740251362155677}, {
        1.123994034282294, -0.5468159671993253}, {
        1.1669893602515085`, -0.5099914595078073}, {
        1.2063943078194408`, -0.47116731261496825`}, {
        1.243491517901551, -0.4315304308560738}, {
        1.2445153271439822`, -0.4302298606532424}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.248226586542539, -0.4255153560476}, {
        1.2759732530120171`, -0.3902680793650686}, {
        1.3036568299157838`, -0.34770156974357935`}, {
        1.326359565377797, -0.30415221359323324`}, {
        1.3444099406606553`, -0.2599412008490704}, {
        1.3581364370269575`, -0.2153897214461312}, {
        1.3583354531278742`, -0.21453112004568806`}}]}, 
      {Arrowheads[{{0.0025353410423390797`, 1.}}], 
       ArrowBox[{{1.361373942443571, -0.18631147404968978`}, {
        1.3648765138720964`, -0.18631147404968978`}}]}}}}, {{}, 
    {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], PointBox[{{-1.2, -1.2}, {-1.2, -0.44999999999999996`}, {-1.2, 
      0.30000000000000004`}, {-1.2, 
      1.05}, {-0.44999999999999996`, -1.2}, {-0.44999999999999996`, \
-0.44999999999999996`}, {-0.44999999999999996`, 
      0.30000000000000004`}, {-0.44999999999999996`, 1.05}, {
      0.30000000000000004`, -1.2}, {
      0.30000000000000004`, -0.44999999999999996`}, {0.30000000000000004`, 
      0.30000000000000004`}, {0.30000000000000004`, 1.05}, {1.05, -1.2}, {
      1.05, -0.44999999999999996`}, {1.05, 0.30000000000000004`}, {1.05, 
      1.05}}]}, {{}, {}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
     TraditionalForm]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->Medium,
  Method->{
   "VectorLengthFunction" -> 
    Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
      System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
      System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
      System`VectorPlotsDump`imin = If[
         NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
         Min[System`VectorPlotsDump`m], 
         Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
         NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
         Max[System`VectorPlotsDump`m], 
         Max[System`VectorPlotsDump`m]]; Map[If[
         Or[# > System`VectorPlotsDump`imax, # < 
          System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
        System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
    "TransparentPolygonMesh" -> True},
  PlotRange->NCache[{{
      Rational[-3, 2], 
      Rational[3, 2]}, {
      Rational[-3, 2], 
      Rational[3, 2]}}, {{-1.5, 1.5}, {-1.5, 1.5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8422560226038313`*^9, 3.8422564281964073`*^9, 3.842257799915682*^9, 
   3.842258150591119*^9, {3.842259273889385*^9, 3.8422592867602262`*^9}, 
   3.842260037236755*^9, 3.842260084237234*^9, {3.84226135907244*^9, 
   3.84226136801762*^9}, 3.842323356998931*^9, 3.846142678748247*^9, 
   3.846147010761569*^9, 3.846214778703725*^9, {3.846215021933913*^9, 
   3.8462150274482594`*^9}, 3.846298106320731*^9, 3.8462988805064583`*^9, {
   3.846575149847267*^9, 3.8465751667562437`*^9}, 3.8499382254960423`*^9, 
   3.850196272895823*^9, 3.854687496013411*^9, 3.854687853818507*^9, 
   3.854688295011239*^9, 3.8546883649860888`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"793e43b7-4cdc-4877-a9b0-f26953c0ec67"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finding Lipschitz", "Section",
 CellChangeTimes->{{3.842255742954309*^9, 
  3.842255746677038*^9}},ExpressionUUID->"2ab9eb2a-2463-437f-b6e0-\
dc1c39191382"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"cons", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "boundary"}], "<=", "x", "\[LessEqual]", "boundary"}], "&&", 
    RowBox[{
     RowBox[{"-", "boundary"}], "<=", "y", "<=", "boundary"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"J", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"Evaluate", "@", 
    RowBox[{"(", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"W", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LocalLips", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"Evaluate", "@", 
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"J", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", "2"}], "]"}]}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.842256058548726*^9, 3.8422560604601393`*^9}, {
  3.849938198275566*^9, 3.8499382013432837`*^9}, {3.8546871803298388`*^9, 
  3.8546871804623823`*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"7a3b0d36-0796-4b56-969f-a147ea9dfbad"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"L", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Element]", "Reals"}], ",", 
      RowBox[{"y", "\[Element]", "Reals"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"MaxValue", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"LocalLips", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", "cons"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "//", "Simplify"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "/", 
   RowBox[{"(", 
    RowBox[{"2", "L"}], ")"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.842255806199869*^9, 3.842255806760653*^9}, {
  3.842256056088264*^9, 3.842256056531644*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"63908457-60db-42e7-a7fe-9df339a725cc"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "80"], " ", 
  SqrtBox[
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"993841", "+", 
      RowBox[{"1089", " ", 
       SqrtBox["801761"]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.8422558150326443`*^9, 3.842255822219304*^9}, 
   3.842255879144311*^9, 3.8422560289279203`*^9, 3.842256069257843*^9, 
   3.842256438527738*^9, 3.842258162352825*^9, 3.842259301807994*^9, 
   3.8423234162477694`*^9, 3.842431572014077*^9, 3.846142974962364*^9, 
   3.846147024334696*^9, 3.846214972677163*^9, 3.8462988919269733`*^9, 
   3.846575178133267*^9, 3.849938238991129*^9, 3.8501962914959297`*^9, 
   3.854687192814373*^9, 3.8546875103495817`*^9, 3.85468786804249*^9, 
   3.854688378585738*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"1b6160ce-833e-4b41-86ea-92dd651d524e"],

Cell[BoxData[
 RowBox[{"-", "0.04031422765953693`"}]], "Output",
 CellChangeTimes->{{3.8422558150326443`*^9, 3.842255822219304*^9}, 
   3.842255879144311*^9, 3.8422560289279203`*^9, 3.842256069257843*^9, 
   3.842256438527738*^9, 3.842258162352825*^9, 3.842259301807994*^9, 
   3.8423234162477694`*^9, 3.842431572014077*^9, 3.846142974962364*^9, 
   3.846147024334696*^9, 3.846214972677163*^9, 3.8462988919269733`*^9, 
   3.846575178133267*^9, 3.849938238991129*^9, 3.8501962914959297`*^9, 
   3.854687192814373*^9, 3.8546875103495817`*^9, 3.85468786804249*^9, 
   3.854688378587798*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"574ecfa2-719a-4ab5-a0c7-a13b4efb6285"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EG+ and CurvatureEG+", "Section",
 CellChangeTimes->{{3.842255767861527*^9, 
  3.842255778000063*^9}},ExpressionUUID->"57f2b376-2d37-498e-b7af-\
b03bdacdf089"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"T", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"1", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Gamma]"}], "/", "2"}], "*", "0.99"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"1", "/", "L"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8422557164457293`*^9, 3.842255716695437*^9}, {
   3.8422558834612513`*^9, 3.8422558836040087`*^9}, {3.842255949197114*^9, 
   3.842255949309389*^9}, {3.842256084359592*^9, 3.842256091149057*^9}, {
   3.842256188937827*^9, 3.8422562209313097`*^9}, {3.84225645888531*^9, 
   3.842256476453518*^9}, {3.842256693562649*^9, 3.8422566976440353`*^9}, {
   3.8422577736137943`*^9, 3.8422577773086967`*^9}, {3.842257818512106*^9, 
   3.84225782205579*^9}, {3.842257890331605*^9, 3.8422578937230186`*^9}, {
   3.84225815761279*^9, 3.842258187895604*^9}, {3.842259677033565*^9, 
   3.8422596771002893`*^9}, 3.8424317182980013`*^9, {3.8546875028069763`*^9, 
   3.854687512671019*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"5cc2ca19-f742-48cd-b84c-19f9b2eb4f45"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "10"}], ";", 
  RowBox[{"K", "=", "25"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Wreverse", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"-", 
    RowBox[{"W", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"SolveFlow", "[", 
    RowBox[{"Wreverse", ",", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", "0.5"}], "}"}], ",", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"iterates", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EGPlus", "[", 
       RowBox[{"W", ",", "init", ",", "T"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"init", ",", "initialPointData"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prox", "=", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
      RowBox[{"Append", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"Thickness", "\[Rule]", "0.005"}]}], "}"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{
          RowBox[{"orbit", "[", 
           RowBox[{"[", 
            RowBox[{";;", ";;", "1"}], "]"}], "]"}], ",", 
          RowBox[{"VertexColors", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Blue", ",", "Blue"}], "}"}]}]}], "]"}]}], "]"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"orbit", ",", "iterates"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"starts2", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Take", "[", 
       RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "iterates"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"plotFlow", "[", 
    RowBox[{"W", ",", "side"}], "]"}], ",", "prox", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dashing", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1000"}], "}"}], "]"}], ",", 
      RowBox[{"Arrowheads", "[", 
       RowBox[{"{", 
        RowBox[{"0.04", ",", 
         RowBox[{"-", "0"}]}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", "starts2", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"w1", "[", "t", "]"}], ",", 
        RowBox[{"w2", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"K", "-", "k"}], ",", "K"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<EG+\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Figs/Forsaken_EG+.png\>\"", ",", "%"}], "]"}]}], "Input",
 CellChangeTimes->{{3.842255891127036*^9, 3.842255899033785*^9}, {
   3.8422561635204973`*^9, 3.84225616557549*^9}, {3.842256450050214*^9, 
   3.842256469899137*^9}, 3.842256687569684*^9, {3.842258039229659*^9, 
   3.842258042713163*^9}, {3.842260168137576*^9, 3.842260168655904*^9}, {
   3.842260831987851*^9, 3.8422608576769743`*^9}, {3.846214989049528*^9, 
   3.846215001111899*^9}, {3.846575207403754*^9, 3.846575208023432*^9}, {
   3.850197651515747*^9, 3.8501978442587976`*^9}, {3.850197919908725*^9, 
   3.850197920476243*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"86a27973-472f-455a-9bd4-063575cf18f8"],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.12702486321737294`, 
        0.6825502504445621}, {-0.15859867017162593`, 
        0.6835370446319317}, {-0.21401826075772262`, 
        0.6657984934378398}, {-0.23802224083322843`, 
        0.6414453595762438}, {-0.2547094630415601, 
        0.6057462889216412}, {-0.26181673868907707`, 
        0.5584941055939887}, {-0.2598446627503448, 0.5297250019187422}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.25943433527913057`, 
        0.5237390490817774}, {-0.25791901982696025`, 
        0.5016332738994}, {-0.2514094962393709, 
        0.4708056979947869}, {-0.24162817456587132`, 
        0.4390232596947784}, {-0.22880215066296467`, 
        0.4068867115491709}, {-0.2131585203871542, 
        0.37499680610776115`}, {-0.1947649412367179, 
        0.3442157824300341}, {-0.17381662139651394`, 
        0.31519669036772385`}, {-0.1664612117240181, 0.3066032351256413}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1625596473328543, 
        0.30204496842637907`}, {-0.15073198275291547`, 
        0.2882264986590003}, {-0.1259294471922968, 
        0.26359217604203433`}, {-0.09312421598638322, 
        0.23687348261877464`}, {-0.05925305727019926, 
        0.21533294264796027`}, {-0.024882565713048088`, 0.1987566945120675}, {
        0.00942066401576676, 0.1869308765935728}, {0.03871921434798018, 
        0.1806674797169317}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.04462116781312979, 0.17964728019157275`}, {
        0.07457469463138554, 0.17717818734714275`}, {0.1326605419020214, 
        0.18386087956002034`}, {0.18176527201549197`, 0.20350306303247262`}, {
        0.22064189215386734`, 0.2331402276330914}, {0.24746186662247488`, 
        0.2679445395556307}, {0.2497000587374462, 0.27325633212580797`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.2520298576705231, 0.27878553070529793`}, {
        0.2640827492591745, 0.3073900725413197}, {0.2699164237139695, 
        0.3499818330252841}, {0.26481629075129015`, 0.3945048375436299}, {
        0.24879441673249453`, 0.4399353658958868}, {0.22242857105393876`, 
        0.4854271915566973}, {0.20967108126283837`, 0.5013500737350742}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.205919472064328, 0.5060325333901756}, {0.1864471706940415,
         0.5303363083128265}, {0.14240874353709157`, 0.5739692566770221}, {
        0.11043817119415812`, 0.6014632342016905}, {0.0763428778598409, 
        0.6280441725908175}, {0.0405953006151685, 0.6535369780130068}, {
        0.02591483228667488, 0.6631694278932763}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.020898292873663234`, 0.6664609825894192}, {
        0.0036678765411700814`, 0.6777665566368616}, {-0.034112768533399604`, 
        0.7004658123477601}, {-0.07242000877978581, 
        0.7213676490310804}, {-0.108990115518863, 
        0.7391070314723185}, {-0.14571321949913765`, 
        0.7544731640150639}, {-0.18246960303747548`, 
        0.7668806204092751}, {-0.19455150206311062`, 0.769800890586852}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.20038356016642644`, 
        0.7712105353220772}, {-0.21913954845074224`, 
        0.7757439744049112}, {-0.2555496205733008, 
        0.7802311967691231}, {-0.2915263842395138, 
        0.7795102582690621}, {-0.35115222665010254`, 
        0.763975204086384}, {-0.37961611811050056`, 
        0.7474902559589645}, {-0.40647719011729805`, 
        0.7240181274109208}, {-0.417374401781736, 0.7098760365817244}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.42103660916071356`, 
        0.705123328184046}, {-0.43087071219660067`, 
        0.692360909444301}, {-0.4516989216323925, 
        0.6519047525547086}, {-0.46779267834338545`, 
        0.6017281589184296}, {-0.477659532494593, 
        0.5426930463374974}, {-0.4796383972500232, 
        0.47892844596632655`}, {-0.47950853699933327`, 0.4768909347121198}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.479126902893057, 
        0.4709030840619343}, {-0.47748131385732473`, 
        0.4450837424058853}, {-0.47301551239650086`, 
        0.4103790799920948}, {-0.4661308214838271, 
        0.37522717015072293`}, {-0.4567170697355791, 
        0.3400407243075375}, {-0.4445118816650327, 
        0.305198765389597}, {-0.4296966848202046, 
        0.2712108247685608}, {-0.41427939553951076`, 0.24214757119325292`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4114676740648869, 
        0.2368471728733963}, {-0.4099070271751887, 
        0.2339051851172469}, {-0.38693055698156814`, 
        0.19863028723400758`}, {-0.36088900420012415`, 
        0.16579850923402806`}, {-0.33220394188972, 
        0.13570419882694174`}, {-0.2859200981409383, 
        0.09634687979356349}, {-0.24371150523839577`, 0.06892225244667696}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.23868024676819655`, 
        0.06565324063788083}, {-0.2359695645373219, 
        0.06389200092517092}, {-0.18382952089991417`, 
        0.03832230901691595}, {-0.13097714704975855`, 
        0.019620550863950557`}, {-0.07854983649523417, 
        0.007402771600997767}, {-0.027684982744720244`, 
        0.0012850163627805844`}, {-0.01374698247166773, 
        0.0004312801241994286}, {-0.010144885364869535`, 
        0.0003210699871842854}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.0041476917593834955`, 0.00013757922905909461`}, {
        7.858835603125435*^-6, 0.000010435571665048216`}, {
        0.027784663601900825`, 0.001734115412072282}, {0.054512219780927226`, 
        0.005060506629221975}, {0.10585056831251305`, 
        0.014687366698048904`}, {0.152901256405968, 0.029816154122576204`}, {
        0.19563731280240637`, 0.04958662793466012}, {0.2227673976968338, 
        0.06717883331732145}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.22780164720105012`, 0.0704432370805373}, {
        0.24751523587496227`, 0.08322629699834844}, {0.29165543283178064`, 
        0.12240642112923242`}, {0.3282430917194472, 0.16558267590259984`}, {
        0.3573911361416318, 0.21197258188845058`}, {0.3760074067150763, 
        0.2541499785204507}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.37843018431767456`, 0.2596390721330928}, {
        0.3789528101601851, 0.2608231437419974}, {0.3924855460736807, 
        0.3117917727010221}, {0.39741037663042156`, 0.3646795885397622}, {
        0.3928640291468017, 0.4196366228601952}, {0.38403958862784504`, 
        0.4580732189388927}, {0.37149971571979173`, 0.4942338166290146}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3693244847405995, 0.4998182265735086}, {
        0.3513555162027229, 0.53873618758482}, {0.32701701059027577`, 
        0.5811505919594641}, {0.2973590530197779, 0.6251957241046833}, {
        0.26266199871999385`, 0.6711490797112754}, {0.23874811937048498`, 
        0.7001019097700374}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.23492717980066, 0.7047279686546329}, {0.2229699337915496, 
        0.7192047545668148}, {0.20126454924802548`, 0.7440816166465566}, {
        0.17832694433507099`, 0.7695568444588757}, {0.15425710663255798`, 
        0.7954883861631994}, {0.129184093510295, 0.8216830164377178}, {
        0.10315702041576495`, 0.8480882370340226}, {0.07622500279645086, 
        0.8746515497037053}, {0.07089792746720876, 0.8797641183527483}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.06656902561252835, 0.883918707229225}, {
        0.04843715609983576, 0.9013204561983577}, {0.019842595773402638`, 
        0.9280424582695714}, {-0.009509562735365497, 
        0.9547650576689378}, {-0.03957020397898544, 
        0.9814357561480485}, {-0.07507834023038057, 
        1.0111080170875675`}, {-0.11133907169021579`, 
        1.0385780874480548`}, {-0.11471320695834412`, 1.0408815076481772`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.11966860598620498`, 
        1.0442644088401536`}, {-0.14835239835849143`, 
        1.0638459672295093`}, {-0.1861183202352074, 
        1.086911656431932}, {-0.22464605080695027`, 
        1.1071237367553661`}, {-0.2639448035603067, 
        1.1238307898998559`}, {-0.3040145784952764, 
        1.1370328158654006`}, {-0.3357504291718867, 1.1445679896923058`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3415881349254546, 
        1.1459540602297462`}, {-0.34485537561185997`, 
        1.146729814652001}, {-0.38684139527785816`, 
        1.153069722355517}, {-0.4303468378610722, 
        1.1562004750718096`}, {-0.475371703361502, 
        1.1561220728008779`}, {-0.5219159917791483, 
        1.1528345155427224`}, {-0.5619098502398333, 
        1.1478393873437205`}, {-0.5802350637267606, 1.1448204500925276`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.586155264373206, 
        1.1438451428046295`}, {-0.6039331499571183, 
        1.1409163735941097`}, {-0.6479858909310025, 
        1.13206547429389}, {-0.6940680731614851, 
        1.1212866894430618`}, {-0.7425460527256532, 
        1.108247617830295}, {-0.7937861857005939, 
        1.092615858244259}, {-0.8183747490453251, 1.0843178210086868`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-0.8240597449519063, 
        1.0823992742820845`}, {-0.8477884720863063, 
        1.074391410684955}, {-0.9045529118827895, 
        1.0535742751523827`}, {-0.9434425407039863, 
        1.0379540305662016`}, {-0.9824989640707504, 
        1.0206103037306546`}, {-1.0217221819830828`, 
        1.0015430946457415`}, {-1.0449277179140881`, 0.989294834117677}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0502339420114843`, 
        0.9864941224530795}, {-1.0611121944409831`, 
        0.9807524033114617}, {-1.0918031930785337`, 
        0.9628639277482297}, {-1.1211732493093378`, 
        0.9435930764373166}, {-1.1492223631333949`, 
        0.9229398493787231}, {-1.1759505345507038`, 
        0.9009042465724494}, {-1.2008123191506175`, 
        0.877391340047695}, {-1.2232622725224873`, 
        0.8523062018336595}, {-1.23509417379205, 0.8365658362176409}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.2386993641893929`, 
        0.8317697334040113}, {-1.243300394666313, 
        0.8256488319303427}, {-1.2609266855820955`, 
        0.7974192303377442}, {-1.276113087850166, 
        0.7676135662421681}, {-1.2888315440508564`, 
        0.7362280088299192}, {-1.2990820541841677`, 
        0.7032625581009968}, {-1.306864618250099, 
        0.6687172140554005}, {-1.3126230593539197`, 
        0.6322981735562658}, {-1.315262242998456, 0.6074972539828245}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3158971467590543`, 
        0.6015309404464121}, {-1.316632191388483, 
        0.5946235837813709}, {-1.3188920143537897`, 
        0.5556934447307162}, {-1.3194025282498396`, 
        0.5155077564043026}, {-1.3185807791559194`, 
        0.4744443882123609}, {-1.3168438131513167`, 
        0.43288120956512544`}, {-1.3141916302360308`, 
        0.3908182204625959}, {-1.3117651897935367`, 
        0.36186825599798217`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3112640571007375`, 
        0.35588922045500304`}, {-1.310624230410062, 
        0.34825542090477213`}, {-1.3063457497112008`, 
        0.30558743634821667`}, {-1.3015603241772369`, 
        0.2632088922494883}, {-1.2962679538081718`, 
        0.2211197886085884}, {-1.2904686386040043`, 
        0.179320125425517}, {-1.284229044831124, 
        0.1380334538038864}, {-1.2809400522772996`, 
        0.11786637135126747`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2799742883475627`, 
        0.11194460640895347`}, {-1.2776158387559198`, 
        0.09748332484730883}, {-1.2706290203783928`, 
        0.05766973855578446}, {-1.2632685896985416`, 
        0.018592694929314355`}, {-1.2555614158730555`, -0.019725635002736}, \
{-1.247534368058621, -0.057263080211001086`}, {-1.2391874462552397`, \
-0.09401964069547977}, {-1.2321618896601814`, -0.12318256920545072`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2307566494003601`, -0.12901569013786568`}, \
{-1.2305206504629107`, -0.12999531645617196`}, {-1.2215263009203952`, \
-0.1652984780103835}, {-1.2121967178664539`, -0.20003749587542008`}, \
{-1.202531901301088, -0.23421237005128187`}, {-1.192531851224296, \
-0.2678231005379676}, {-1.1770250402494915`, -0.3167806282224171}, \
{-1.1626397679407674`, -0.35905484901301915`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1607069018242615`, -0.3647349923717438}, \
{-1.160464940863989, -0.36544604676388504`}, {-1.1428515530677892`, \
-0.4138193561623707}, {-1.124184876860891, -0.46190055641787386`}, \
{-1.1040362131616845`, -0.5103060802808613}, {-1.0819768628885578`, \
-0.5596523605017997}, {-1.0691943989092314`, -0.5864688496794512}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.06661270552024, -0.5918850161507885}, \
{-1.0580068260415114`, -0.6099393970806891}, {-1.0321261026205455`, \
-0.6611671900175284}, {-1.0035151981848374`, -0.7136535338749181}, \
{-0.9713546182935635, -0.7677162232154584}, {-0.9539432000520901, \
-0.79533869744191}, {-0.9499677455445681, -0.8014253444495989}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9466867220739431, -0.8064487780348281}, \
{-0.9356443629467253, -0.8233552580391486}, {-0.9164581069774691, \
-0.851765905007175}, {-0.8963844321443216, -0.8805706383459886}, \
{-0.8662364443963907, -0.9212539947673799}, {-0.8334711411961713, \
-0.9617740021490844}, {-0.8020453809459256, -0.9976175523965282}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7980898887703322, -1.0021291022021734`}, \
{-0.7980885225436631, -1.0021306604911018`}, {-0.7600885884388654, \
-1.0423239697934332`}, {-0.7194033836014226, -1.0812955898806962`}, \
{-0.67596495275098, -1.1179871805775083`}, {-0.6297732958875359, \
-1.152398741883871}, {-0.6181662167447372, -1.160018603491648}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6131504676928355, -1.1633113624333788`}, \
{-0.5808284130110888, -1.184530273799785}, {-0.5296497638578531, \
-1.2136479968931089`}, {-0.4767568081640434, -1.2390181317317013`}, \
{-0.4221495459296582, -1.2606406783155633`}, {-0.398265306570969, \
-1.2682208965613548`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.39254641735623547`, -1.27003591891648}, \
{-0.3658279771546955, -1.2785156366446953`}, {-0.3198759127445309, \
-1.2902367233315322`}, {-0.273763781049976, -1.2997258909908216`}, \
{-0.22749158207103107`, -1.3069831396225633`}, {-0.1810593158076963, \
-1.3120084692267568`}, {-0.15719201870802005`, -1.3136721707497463`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.15120654271503536`, -1.3140893962731794`}, \
{-0.13477609810288127`, -1.3152347021538777`}, {-0.08895104479950026, \
-1.3170946607544016`}, {-0.043584155897551526`, -1.317588345028328}, {
        0.001324568602964954, -1.316715754975657}, {
        0.04572315922159654, -1.3148042473220074`}, {
        0.0885868965109439, -1.3122393857795664`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.09457030220037649, -1.311795068618714}, {
        0.13283403037184713`, -1.3088465493886308`}, {
        0.17554631090346767`, -1.3048003591089028`}, {
        0.2258604435395959, -1.2992543273464012`}, {
        0.27588381217998037`, -1.2930859408960527`}, {
        0.32561641682462283`, -1.2862951997578564`}, {
        0.333037592946179, -1.2851825006955033`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.33897126704302744`, -1.2842928312555484`}, {
        0.37505825747352456`, -1.2788821039318121`}, {
        0.42467524428619324`, -1.2708879233811174`}, {
        0.47493328742213636`, -1.2623539280689702`}, {
        0.5258323868813556, -1.2532801179953696`}, {
        0.5755486645284549, -1.2440066954719375`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5814408906959706, -1.242874792593873}, {
        0.6300420003060614, -1.2334170161931646`}, {
        0.6843290053444179, -1.2224356497232736`}, {
        0.7402335577789233, -1.2107223937506424`}, {
        0.7977556576095768, -1.198277248275271}, {
        0.8164260720849787, -1.194112865501307}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8222821696294482, -1.1928066796226284`}, {
        0.8326240967182723, -1.1904999422400688`}, {
        0.8678278305451337, -1.18239509670622}, {
        0.903360551060283, -1.173940914592348}, {
        0.939215950233843, -1.1651155988170765`}, {
        0.9753877200359355, -1.1558973522990281`}, {
        1.0118695524366832`, -1.1462643779568267`}, {
        1.0486551394062082`, -1.1361948787090954`}, {
        1.0550332203831818`, -1.1343841504597365`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.060805124227625, -1.1327455150486392`}, {
        1.0857381729146331`, -1.1256670574744574`}, {
        1.1227586831027647`, -1.1146564995551533`}, {
        1.1590030382820944`, -1.1031361726370412`}, {
        1.194046707272853, -1.091095259333493}, {
        1.227577428489352, -1.0785378483772043`}, {
        1.2592515048521271`, -1.0654632112094018`}, {
        1.2867725067758637`, -1.052784259734134}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.292089872179487, -1.0500134962801932`}, {
        1.3403004664001759`, -1.0231686287531958`}, {
        1.3814513738235554`, -0.9924773020912467}, {
        1.4121614257933512`, -0.9598483454732761}, {
        1.433334837492728, -0.9253186703041483}, {
        1.447230073669648, -0.8889127864731502}, {
        1.4492075879163826`, -0.8799240939831322}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.450496759793225, -0.874064227442676}, {
        1.455652464719626, -0.8506292275536925}, {
        1.4606313314681285`, -0.8104343500455208}, {
        1.4633494771691506`, -0.7682849050521277}, {
        1.464255182720192, -0.7241119497439177}, {
        1.4639902823107245`, -0.6894393797225671}, {
        1.4627862676155088`, -0.6536123260161593}, {
        1.4618231971017928`, -0.6350749174408312}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4615119000532364`, -0.6290829983703197}, {
        1.4608686298691977`, -0.6167011820276722}, {
        1.4584628603064445`, -0.5787763411600836}, {
        1.4556943936170472`, -0.5399501767826131}, {
        1.4526886644908041`, -0.5003350622644803}, {
        1.4494796288843441`, -0.4601587509433629}, {
        1.4460880570888128`, -0.4194801446141478}, {
        1.443508762317786, -0.38976920986011393`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4429898362116402`, -0.38379169234057786`}, {
        1.4425267260668602`, -0.378457119708535}, {
        1.4388084127811362`, -0.33724755265821915`}, {
        1.4349499180651881`, -0.29600328458824043`}, {
        1.430968042752563, -0.2548761566236338}, {
        1.426972404031183, -0.21493570168370535`}, {
        1.4228665842265633`, -0.17514578107471618`}, {
        1.419653889083354, -0.14493253665116915`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4190194617091572`, -0.13896617243945114`}, {
        1.4186643234865264`, -0.1356263354968864}, {
        1.414379361958896, -0.09649730565043621}, {
        1.4100254397914944`, -0.05787863223558566}, {
        1.4056162971321453`, -0.0198902559525548}, {1.40116567412867, 
        0.017347882498438688`}, {1.396687310928893, 0.05371584241716965}, {
        1.390883769529806, 0.09937432395986652}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.390119902915453, 0.10532549110051923`}, {
        1.3839749001930854`, 0.15221342566298188`}, {1.3775236373711879`, 
        0.2001289065807078}, {1.3710233468455082`, 0.24729854332704457`}, {
        1.3644653978349914`, 0.2939470996607394}, {1.3578300802841752`, 
        0.34036647736036746`}, {1.3574360740740383`, 0.3430874779355065}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3565762300004283`, 0.3490255473329687}, {
        1.3511115332306074`, 0.38676465567971907`}, {1.3443038957118352`, 
        0.43334961387258464`}, {1.3373509758095088`, 0.48042147442974314`}, {
        1.3301678210590504`, 0.5283330131202606}, {1.3227054296786669`, 
        0.5773711891153455}, {1.3213082638461155`, 0.5864191729843008}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3203926120720806`, 0.5923488931993452}, {
        1.3149147998865645`, 0.6278229615862082}, {1.3067284646278745`, 
        0.6799514741663553}, {1.2980684052631135`, 0.7340062616106046}, {
        1.2888697926335657`, 0.7902538697721349}, {1.2823483989182816`, 
        0.8293123771462457}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.2813602886636302`, 0.8352304543783079}, {
        1.2790677975805158`, 0.8489608445041247}, {1.2685571869004793`, 
        0.9099748285508031}, {1.2573276150883426`, 0.9722069627380749}, {
        1.2453203643286417`, 1.0353265904372007`}, {1.2380683722897203`, 
        1.0712806458096997`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.2368820536869904`, 1.0771621973203827`}, {
        1.2324767168059125`, 1.0990030550194405`}, {1.223235259643004, 
        1.141937639074281}, {1.215236948731389, 1.1761288391364895`}, {
        1.2069720427155735`, 1.2089312925176998`}, {1.1897385149115216`, 
        1.2688127731747936`}, {1.1754705117453528`, 1.3088965722577965`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.1734584525785159`, 1.3145491484765792`}, {
        1.171698527474471, 1.3194933921419398`}, {1.1530542197617244`, 
        1.3598711305934221`}, {1.131960157368948, 1.3932767228648308`}, {
        1.1105259252838013`, 1.4156941206752338`}, {1.067300436612837, 
        1.439792402508421}, {1.0233449985390128`, 1.4468419875441338`}, {
        0.9976020636562407, 1.4463566733951305`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9916050559989247, 1.4461779146239824`}, {
        0.9653325266093912, 1.4451315413776233`}, {0.934746585538384, 
        1.443351457939841}, {0.9022602645509294, 1.440909981184253}, {
        0.8678413596170131, 1.437993886423205}, {0.8311550412809476, 
        1.4347188686788122`}, {0.7985667354329703, 1.4317286675946785`}, {
        0.7640226801658898, 1.428496977819458}, {0.7523787815431557, 
        1.4273890775718043`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.7464057582589179, 1.4268207529762151`}, {
        0.7274236628141972, 1.4250146338295635`}, {0.6886704707123861, 
        1.4212724701014081`}, {0.6477858812334221, 1.4172565761883265`}, {
        0.6047926717502686, 1.4129530416436538`}, {0.562659742085417, 
        1.4086399423416203`}, {0.5189758369341929, 1.404052134939244}, {
        0.5076100228867757, 1.4028233954298734`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5016447807615342, 1.4021785028905738`}, {
        0.4740136156835526, 1.399191342966998}, {0.428045737720452, 
        1.3940592899553537`}, {0.38141465382542394`, 1.3886689757046344`}, {
        0.3344628147790006, 1.383033400015163}, {0.2831238972304674, 
        1.3766321744897687`}, {0.2633034942301193, 1.3740532892849546`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2573536462488289, 1.3732791387830918`}, {
        0.2320459160347847, 1.3699862828802485`}, {0.18173737157520864`, 
        1.3631222923595763`}, {0.1327067642349952, 1.3560667701007258`}, {
        0.08506348491812366, 1.348831800510986}, {0.03868886196898663, 
        1.3414211921315395`}, {0.019937013629275465`, 1.3382615983494532`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.014020413693803047`, 
        1.3372646804974877`}, {-0.006250698068539812, 
        1.3338490983362008`}, {-0.04958878865057961, 
        1.3261296724987852`}, {-0.09143104287933718, 
        1.3182983288110282`}, {-0.13203854508334856`, 
        1.3104026305034773`}, {-0.17147806555823514`, 
        1.302474954508165}, {-0.2098163745996183, 
        1.2945476777571236`}, {-0.22166008708204885`, 1.2920296869549792`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2275289190694866, 
        1.2907819645887346`}, {-0.24723607488228727`, 
        1.286592194096866}, {-0.2839859590119842, 
        1.2785450498964643`}, {-0.32023208218076, 
        1.270386350871791}, {-0.35614049958066557`, 
        1.262096202738718}, {-0.4032829777036802, 
        1.2508462340204074`}, {-0.45078469347535666`, 
        1.2390238323732785`}, {-0.4612476597147224, 1.23631167404733}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4670557034746327, 
        1.2348061416886715`}, {-0.4991170726191883, 
        1.226495352255025}, {-0.5487515408586686, 
        1.2131271481233414`}, {-0.6002603554735157, 
        1.1986676089052257`}, {-0.6542733917755728, 
        1.182797714652992}, {-0.697943120894651, 1.1693965026216115`}}]}, 
      {Arrowheads[{{0.0006685329578423794, 1.}}], 
       ArrowBox[{{-0.7040951482703488, 
        1.1654103792578472`}, {-0.7109324629872322, 
        1.1654103792578472`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.24017776779883498`, 
        0.84040262014396}, {-0.28953895610067754`, 
        0.8556509246177588}, {-0.3407498214628198, 
        0.865305371595066}, {-0.3941264725649757, 
        0.8676062200201089}, {-0.433786577669217, 
        0.8636207712036137}, {-0.4748226934156393, 
        0.8539658359071203}, {-0.4755531760221542, 0.8536877728155357}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.4811606538425698, 
        0.8515532488654365}, {-0.5175627004427625, 
        0.8376965662731584}, {-0.5619481719551204, 
        0.8134434398048691}, {-0.6077443328211647, 
        0.7793249353646055}, {-0.6542964897135372, 
        0.7336341798175187}, {-0.6722896926546577, 0.712006817383642}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6761270723605695, 
        0.7073943866803516}, {-0.6776833568003978, 
        0.7055237732192291}, {-0.7010519710508025, 
        0.6734097822526084}, {-0.724072278546205, 
        0.6376366159432564}, {-0.7464142253680595, 
        0.5985486833167715}, {-0.7622291259716752, 
        0.5677433745475925}, {-0.777433860675131, 
        0.5351612509596876}, {-0.7920284294784266, 
        0.5008023125530564}, {-0.7928854209498218, 0.49858784315160415`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7950508966239472, 
        0.4929922453189529}, {-0.8060128323815623, 
        0.4646665593276993}, {-0.8191702665574111, 
        0.4271514932015954}, {-0.8312839291788459, 
        0.388654616092724}, {-0.8423538202458666, 
        0.34917592800108527`}, {-0.8523799397584736, 
        0.30871542892667875`}, {-0.8611781463778647, 
        0.2677864976259997}, {-0.8620607432646539, 0.2629011289271861}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8631274428867678, 
        0.25699671092740134`}, {-0.8685642987652378, 
        0.2269025128555433}, {-0.8745383969205931, 
        0.18606347461530925`}, {-0.8791004408439307, 
        0.1452693829052975}, {-0.8829286886527589, 
        0.08614600049951272}, {-0.8830630002492001, 
        0.028789717039140364`}, {-0.8823924644814344, 
        0.018318237447939537`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8820090428811448, 
        0.012330500991111184`}, {-0.8795033756332545, -0.02679946747581939}, \
{-0.8722498148049219, -0.08062155304536692}, {-0.8654494172584153, \
-0.11410781286466293`}, {-0.8567086068256258, -0.146737176164979}, \
{-0.8460273835065536, -0.17850964294631483`}, {-0.8334057473011991, \
-0.20942521320867058`}, {-0.8283400282962866, -0.21988176323717754`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.825724111430865, -0.22528148350337676`}, \
{-0.8188436982095617, -0.2394838869520462}, {-0.802341236231642, \
-0.26868566417644185`}, {-0.7838983613674395, -0.29703054488185754`}, \
{-0.7635150736169543, -0.3245185290682929}, {-0.7282900643139907, \
-0.36480237513992564`}, {-0.68765066075339, -0.4032395882038069}, \
{-0.6773098039018378, -0.41142623528440475`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6726055589328993, -0.4151504908170202}, \
{-0.6415257677269919, -0.4397557324903194}, {-0.5898442900266359, \
-0.4742763722298458}, {-0.562011055579325, -0.4907507378352243}, \
{-0.5329711222747269, -0.5066509471853268}, {-0.5027244901128419, \
-0.5219770002801528}, {-0.47127115909367, -0.5367288971197026}, \
{-0.4674818859391597, -0.5383183844297995}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4619489473856845, -0.540639287478931}, \
{-0.41612806866077096`, -0.5598597823603965}, {-0.3587648811599246, \
-0.5810866698099164}, {-0.30965110128856876`, -0.597444087568453}, \
{-0.2598947808051624, -0.6123336413128226}, {-0.23530953167893864`, \
-0.6188882389640014}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.22951203582052015`, -0.6204338915030995}, \
{-0.20975053974500216`, -0.6257024431901437}, {-0.1594729981433845, \
-0.6374976053475346}, {-0.10955848737581131`, -0.6477198674946254}, \
{-0.06030996974561996, -0.6563270672910367}, {-0.011692011679860202`, \
-0.6632019638088726}, {0.006069527875835427, -0.665060621243352}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.012036943478777169`, -0.6656850818279908}, {
        0.03633082039441839, -0.6682273161202372}, {
        0.09075873599829468, -0.6715619625676668}, {
        0.14420812295879928`, -0.6722211275981453}, {
        0.19667898127593217`, -0.6702048112116729}, {
        0.24817131094969336`, -0.6655130134082495}, {
        0.25150873325937495`, -0.6650119727000362}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2574422398688171, -0.6641211869145037}, {
        0.29906658423401605`, -0.6578722052021341}, {
        0.34974627338283343`, -0.647008857607585}, {
        0.40021037839614565`, -0.6329229706246026}, {
        0.45045889927395255`, -0.6156145442531866}, {
        0.4879498236725201, -0.6001919419232449}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.49349866508232765`, -0.5979093208401903}, {
        0.501049271716189, -0.5948032356920655}, {
        0.5525389314227896, -0.5702087021399668}, {
        0.604927878393755, -0.541830943596891}, {
        0.6582161126290844, -0.5096699600628378}, {
        0.6875896534825715, -0.491056546948403}, {
        0.7027408283537734, -0.4810148174694975}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7077421087279373, -0.47770012372512183`}, {
        0.7174097075307708, -0.47129273864020893`}, {
        0.7648037819629677, -0.43660263959316514`}, {
        0.8132562830774767, -0.3992775729606929}, {
        0.8620935615183223, -0.36076727428072997`}, {
        0.8978334095207153, -0.3313142300792595}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.9024637046491001, -0.3274984251806757}, {
        0.9117003946118417, -0.3198865115057857}, {
        0.9366626479978328, -0.298610600662707}, {
        0.9615577977359504, -0.2768488629559061}, {
        0.9863858438261943, -0.2546012983853829}, {
        1.0111467862685644`, -0.2318679069511374}, {
        1.0356093084895905`, -0.2087189568452523}, {
        1.0595420939158022`, -0.1852247162598103}, {
        1.079155897295327, -0.1652451023926814}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.083351234329103, -0.16095580892668668`}, {
        1.1058184543837828`, -0.13720036365025548`}, {
        1.1392140219519802`, -0.09995958954567058}, {
        1.1704913047588232`, -0.062179843527067034`}, {
        1.1990813822072295`, -0.024027388079503186`}, {1.224415333700114, 
        0.014331514311962848`}, {1.2316539883575226`, 
        0.026998204909215104`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2346309911834734`, 0.032207567074997064`}, {
        1.2464152813379612`, 0.052828520050336426`}, {1.2652839430484346`, 
        0.09145123918894499}, {1.280873291975223, 0.13011733971821354`}, {
        1.293035301262014, 0.16874448962856703`}, {1.3021284542086327`, 
        0.20733551778713014`}, {1.3088006684898397`, 0.24594191641914168`}, {
        1.3102303907338324`, 0.25810858658245184`}}]}, 
      {Arrowheads[{{0.0017189774753443002`, 1.}}], 
       ArrowBox[{{1.3115293998450215`, 0.2794590202080621}, {
        1.312739309728405, 0.2794590202080621}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.5363362975390406, 
        0.76715324492146}, {-0.5598938430140652, 
        0.744148175903389}, {-0.5831210422301636, 
        0.7166755361695751}, {-0.6056512599614053, 
        0.6847712814021556}, {-0.6271178609818594, 
        0.6484713672832678}, {-0.6471931195411236, 
        0.6071514691819374}, {-0.6633185979416829, 0.5662892663209227}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6655205824256971, 
        0.5607079538335761}, {-0.6816797226870436, 
        0.5099917119483619}, {-0.6952644140805726, 
        0.4558084369318584}, {-0.7058144683118281, 
        0.39892966190619755`}, {-0.7129076664681326, 
        0.3401708205652817}, {-0.7136676766191251, 0.32631461731613365`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7139962815613958, 
        0.32032362250793067`}, {-0.7161840358496054, 
        0.28043735515079016`}, {-0.7152836037563662, 
        0.22063470790440104`}, {-0.7096198280422824, 
        0.16212779974040872`}, {-0.6987874221182233, 
        0.10591396863501541`}, {-0.6918214338394032, 
        0.08272160132290851}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6900954649043689, 
        0.07697520843386092}, {-0.6826982966198094, 
        0.05234728242276101}, {-0.6612643621826619, 
        0.001781808938186393}, {-0.633824223502503, -0.04520461523384077}, \
{-0.6001751300269739, -0.08821316850871452}, {-0.5644338821900554, \
-0.12366942582092641`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5600945165301228, -0.12780478332421322`}, \
{-0.516649589743801, -0.16195448103040988`}, {-0.46764885183447286`, \
-0.1924343671664885}, {-0.41444981422935157`, -0.21849606213788525`}, \
{-0.35804121064635563`, -0.2401521595413884}, {-0.3509708590633803, \
-0.2422339830865399}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3452151750015952, -0.24392871049261822`}, \
{-0.29941177480340286`, -0.25741525297378665`}, {-0.24001987215183926`, \
-0.2700794181703588}, {-0.18094816275626904`, -0.27811354515559134`}, \
{-0.12262182225449633`, -0.2817924489600838}, {-0.10915469438086645`, \
-0.28169784594961256`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.10315484241611174`, -0.281655698576871}, \
{-0.06546602628432645, -0.2813909446144358}, {-0.017248350761352275`, \
-0.27790735316841764`}, {0.029072432683442343`, -0.2715518448311742}, {
        0.07349632405005738, -0.26232441960270547`}, {
        0.11602332333849281`, -0.2502250774830115}, {
        0.13260896199381422`, -0.24426107784172904`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.13825502710931475`, -0.2422308195548286}, {
        0.15668823477230256`, -0.23560245593408424`}, {
        0.19552586257504062`, -0.2188051924179159}, {
        0.2325362067467069, -0.19983328693450636`}, {
        0.26771926728730167`, -0.17868673948385566`}, {
        0.30128268297383565`, -0.1557598717348549}, {
        0.3334340925833198, -0.13144700535639542`}, {
        0.34456043001812275`, -0.1221451253290927}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3491636615812815, -0.11829671537484673`}, {
        0.3641734961157542, -0.10574814034847707`}, {
        0.39350089357113893`, -0.07866327671109985}, {
        0.42943120468383206`, -0.04237721058141797}, {
        0.463713055400106, -0.004861630691796993}, {0.4963464457199608, 
        0.033883462957763164`}, {0.5134832509692874, 
        0.055992180446801126`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.5171590225636239, 0.060734405998825104`}, {
        0.5273313756433966, 0.07385807036726261}, {0.5597472800143054, 
        0.1194635132022348}, {0.5904991384076915, 0.16623157310412887`}, {
        0.6128578840435241, 0.20246401644585102`}, {0.6342561057797629, 
        0.23954813837287012`}, {0.6465375385001277, 
        0.26255542844291474`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6493630161166322, 0.26784850658692816`}, {
        0.6546055574253609, 0.2776695650367381}, {0.6738553712027712, 
        0.31700607556544247`}, {0.6895459754311337, 0.3515162928374147}, {
        0.7044778483993148, 0.3870827802756242}, {0.7182941713568991, 
        0.4241452733659825}, {0.7306381255534711, 0.4631435075944013}, {
        0.7374536744016632, 0.4904358951808904}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7389073728702149, 0.4962571287926372}, {0.743116192761504,
         0.5131110530052492}, {0.7529341179045385, 0.5665928239466254}, {
        0.7594831646059319, 0.6243024685693059}, {0.7621545964890417, 
        0.6869536350240667}, {0.7618307568776295, 0.7202804412072461}, {
        0.7611404834701337, 0.734400080893801}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7608475085669005, 0.740392923767269}, {0.7601266135694245,
         0.7551389323859834}, {0.7570421665644269, 0.7915291085602786}, {
        0.7525774158626368, 0.8294509697301317}, {0.7483870774277144, 
        0.8608995897688375}, {0.7431297697776961, 0.8933494194634362}, {
        0.7304264247752716, 0.9457492515581235}, {0.7212596538770514, 
        0.9764235636370747}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7195416752859157, 0.9821723504273809}, {
        0.7144882248333342, 0.9990824617391078}, {0.6968736747710688, 
        1.0519836020824467`}, {0.6759064244681472, 1.1040206027504944`}, {
        0.6515695177573302, 1.1536418216890516`}, {0.6238459984713784, 
        1.1992956168439177`}, {0.6227462218986457, 1.2007353938905165`}}]}, 
      {Arrowheads[{{0.018574026191876775`, 1.}}], 
       ArrowBox[{{0.6191040908655929, 1.2055035047887732`}, {
        0.5929120423005046, 1.2397929334440048`}, {0.5589438249349217, 
        1.2739447167182247`}, {0.532300256784743, 1.2950494719476662`}, {
        0.5043409394682978, 1.3129025466170388`}, {0.47521347692090943`, 
        1.3272405024209981`}, {0.4450654730779008, 1.337799901054198}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9006992167051403, -0.20694155106116677`}, \
{-0.8826894928755505, -0.2592046182166136}, {-0.8596270082485928, \
-0.3097234851892964}, {-0.8308312682060339, -0.35874315117961014`}, \
{-0.796302272747874, -0.40626361618755485`}, {-0.7873509866841664, \
-0.4164952721522941}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7834003122325646, -0.421011041342306}, \
{-0.7560400218741128, -0.4522848802131304}, {-0.7152722444003062, \
-0.49174609775815403`}, {-0.669141593165745, -0.5301725591418353}, \
{-0.6440642436772956, -0.5489778774079446}, {-0.6176442833268866, \
-0.5674847489032626}, {-0.602535498810386, -0.577394031564561}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5975183193543759, -0.5806846105874975}, \
{-0.5898817121145176, -0.5856931736277892}, {-0.5607765300401887, \
-0.6036031515815244}, {-0.5304461702215773, -0.6211766408895218}, \
{-0.49900806577636053`, -0.6383755996768354}, {-0.4664622167045386, \
-0.6552000279434647}, {-0.43280862300611134`, -0.6716499256894098}, \
{-0.3857770763674646, -0.6931389138325371}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.38031974051571765`, -0.6956324024331201}, \
{-0.3787757229318903, -0.6963378730783143}, {-0.3230395836260312, \
-0.7199050696383846}, {-0.283139170860897, -0.7357532113697092}, \
{-0.2429677548336321, -0.7509400872855965}, {-0.2025253355442364, \
-0.7654656973860458}, {-0.1618119129927102, -0.7793300416710577}, \
{-0.156169547300138, -0.7811495392508586}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.15045911217263833`, -0.7829909872285702}, \
{-0.1210586336647713, -0.7924717799323248}, {-0.08049664404613761, \
-0.8048295719615408}, {-0.040125944136809276`, -0.8164034177587052}, {
        0.00005346606321357528, -0.8271933173238182}, {
        0.048197331207703795`, -0.8390642565291309}, {
        0.08093061634980508, -0.8462848441383848}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.08678975861389975, -0.847577303781507}, {
        0.09594650587592207, -0.8495971772996768}, {
        0.14330099006786823`, -0.8587920796354555}, {
        0.1902607837835426, -0.8666489635364674}, {
        0.23706602779223393`, -0.8730376361657224}, {
        0.28395686286323085`, -0.8778279046862306}, {
        0.3242614794335138, -0.8805664457343579}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.330247677192609, -0.8809731844576232}, {
        0.3309332889965336, -0.881019769097992}, {
        0.3779953061921422, -0.8826132294010067}, {
        0.42559308556731423`, -0.8824051553599868}, {
        0.47417679823930736`, -0.8801924167396442}, {
        0.5237464442081216, -0.875975013539979}, {
        0.5696429297740561, -0.8703263581757889}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5755905397829171, -0.8695414833789112}, {
        0.6298785439679233, -0.8606321117227476}, {
        0.6875244744072389, -0.8487071461232338}, {
        0.7474495027187448, -0.8337193084480059}, {
        0.8091958926186638, -0.815605650902036}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8149059403957947, -0.8137639125925532}, {
        0.8419486789339866, -0.8049369843765326}, {
        0.8745465582371453, -0.793488619518738}, {
        0.907656954738959, -0.7810647636092354}, {
        0.9412798684394273, -0.7676654166480249}, {
        0.9851342464084496, -0.749689481538708}, {
        1.0293899743898307`, -0.7299567053628802}, {
        1.0377816338708947`, -0.7253083887597729}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0430302154497733`, -0.7224010890831217}, {
        1.0850479699520743`, -0.699126571531611}, {
        1.138261902592108, -0.6651305181483697}, {
        1.1892290178827778`, -0.6296444522610597}, {
        1.2357024984747207`, -0.5911783613656129}, {
        1.2402110739150465`, -0.5866518431781684}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.244445280813925, -0.5824007854347958}, {
        1.276734140034962, -0.549983426459586}, {
        1.311375738230528, -0.5063108285405362}, {
        1.339602204255895, -0.4605485569027977}, {
        1.3613884493055401`, -0.413084600840705}, {
        1.3720380334153615`, -0.3823685978956594}}]}, 
      {Arrowheads[{{0.00027321485249625526`, 1.}}], 
       ArrowBox[{{1.3742605142926956`, -0.37434322129968906`}, {
        1.3748205218538696`, -0.37434322129968906`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -0.7864170130565192}, {-1.471954889637079, \
-0.8043544247070936}, {-1.4337653581600633`, -0.8332637641713465}, \
{-1.4007232869599495`, -0.8621672120177628}, {-1.370973453954144, \
-0.8910924156858344}, {-1.3433450532682485`, -0.9200505007581241}, \
{-1.321286273480508, -0.9451222904025524}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.3173487949321334`, -0.9496487262529694}, \
{-1.2944525488561895`, -0.9780653151153577}, {-1.272473827554896, \
-1.0069731213422164`}, {-1.2511873034232535`, -1.0356159628571229`}, \
{-1.2305929764612629`, -1.0639938396600774`}, {-1.2106908466689235`, \
-1.09210675175108}, {-1.1786580249399279`, -1.137938756624258}, \
{-1.175123568634828, -1.1428879457334884`}}]}, 
      {Arrowheads[{{0.01999999999999999, 1.}}], 
       ArrowBox[{{-1.1716365829080644`, -1.1477706632699989`}, \
{-1.1472155064610596`, -1.1819667362028583`}, {-1.1106563205572155`, \
-1.225783791043853}, {-1.0734291388103498`, -1.2646102213257666`}, \
{-1.0355834288160166`, -1.3004976976144207`}, {-1.0078486562701399`, \
-1.3217937476596036`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.003089730688414, -1.325447872357475}, \
{-0.9965006623267483, -1.3305072659165553`}, {-0.9559486267628459, \
-1.3548243499165031`}, {-0.9136951095446104, -1.3736343732985972`}, \
{-0.8695862862678662, -1.3875929017554847`}, {-0.8234683325284372, \
-1.3973555009798135`}, {-0.7790639202736506, -1.402926445780127}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7731105901314913, -1.4036733461874493`}, \
{-0.7671235232562517, -1.4044244791804132`}, {-0.7078963671369601, \
-1.4077708954302883`}, {-0.6459615480113599, -1.4082252714148722`}, \
{-0.5814937497202484, -1.4066181288195985`}, {-0.5484224554218304, \
-1.405149001889673}, {-0.5333273677619416, -1.4043511893964276`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.527335730393085, -1.4040345166313815`}, \
{-0.5149428604004437, -1.4033795229850994`}, {-0.48105496465608816`, \
-1.4013096921058774`}, {-0.4467587681887636, -1.398939509252007}, \
{-0.41369890306609025`, -1.3964343633859768`}, {-0.3805366381594581, \
-1.3937416994059613`}, {-0.3472719734688671, -1.3908615173119605`}, \
{-0.31390490899431744`, -1.3877938171039743`}, {-0.28808795630926365`, \
-1.3852926144687938`}}]}, 
      {Arrowheads[{{0.01118534425257845, 1.}}], 
       ArrowBox[{{-0.2821159180921656, -1.3847140303923449`}, \
{-0.28055792763969034`, -1.3845630888822118`}, {-0.24735351230886715`, \
-1.3811938227468818`}, {-0.21429166300184782`, -1.377686018697984}, \
{-0.18137237971863232`, -1.3740396767355187`}, {-0.14867268908377224`, \
-1.370273150969758}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.0084517815711076`, 1.5}, {-1.0249862448288576`, 
        1.4728759631187207`}, {-1.0499841031495707`, 
        1.4377043206924498`}, {-1.0744418761015886`, 
        1.4074108654424475`}, {-1.0982598053059658`, 
        1.3803084095104496`}, {-1.1213658343732902`, 
        1.3553477870923785`}, {-1.1612644040661222`, 
        1.3159747972469575`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.1655382636474496`, 
        1.3117637206599513`}, {-1.2026129502164637`, 
        1.2776795868749875`}, {-1.2367506606241034`, 
        1.2468204889809387`}, {-1.2538512253610659`, 
        1.2303008048168182`}, {-1.2696935564196157`, 
        1.214252252247263}, {-1.2987377213215738`, 
        1.1828418183861027`}, {-1.322594831797833, 
        1.1525486181673086`}, {-1.3312009449111717`, 
        1.1391160277333887`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3344377361478366`, 
        1.1340639803770936`}, {-1.3415737613092549`, 
        1.1229259321017444`}, {-1.3639456826070573`, 
        1.074572839477134}, {-1.3764845017523315`, 
        1.0258426546448813`}, {-1.3824659263665902`, 
        0.9759366239668239}, {-1.385165664071347, 
        0.9240559938047997}, {-1.384984309784923, 0.9030940923115796}}]}, 
      {Arrowheads[{{0.018410379435117762`, 1.}}], 
       ArrowBox[{{-1.384932402041828, 
        0.8970943168502638}, {-1.3846923797292718`, 
        0.8693512501095502}, {-1.3811547382030345`, 
        0.8109728788318165}, {-1.3773592582920187`, 
        0.7683209834001015}, {-1.3729831941278805`, 
        0.7236288158163234}, {-1.3680999907527656`, 0.6769147014451757}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8229559166608289, 
        0.12431559072348561`}, {-0.8211573832231699, 
        0.07145960237502327}, {-0.8157407797229232, 
        0.02050090148427367}, {-0.8067061061600888, -0.028560511948763176`}, \
{-0.7940533625346664, -0.07572463792408754}, {-0.7811853361278853, \
-0.11057428837155484`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-0.7791070258007147, -0.11620284290926483`}, \
{-0.7774102571500277, -0.12079809260004118`}, {-0.7564044983095444, \
-0.16358749213496587`}, {-0.7310360860132163, -0.20409283652886204`}, \
{-0.7013050202610435, -0.24231412578172992`}, {-0.6802789972489748, \
-0.2651797069327157}, {-0.6573808922174382, -0.28709103184032425`}, \
{-0.6356529623528308, -0.3054741678726263}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.630999341623912, -0.3092578999626126}, \
{-0.6059684360959606, -0.32805091292541066`}, {-0.5775622401770264, \
-0.3470510805415453}, {-0.5475002725806375, -0.3650002147916168}, \
{-0.5157825333067939, -0.38189831567562516`}, {-0.48240902235549565`, \
-0.3977453831935703}, {-0.44770518664510756`, -0.41247457995873393`}, \
{-0.42065701150599055`, -0.4227340842669007}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.41504701614647277`, -0.42486198277627296`}, \
{-0.4119964730939947, -0.4260190685843978}, {-0.37528288170215723`, \
-0.43837884907056185`}, {-0.33756441246959495`, -0.4495539214172263}, \
{-0.2847646711966765, -0.46291876980896307`}, {-0.23193459445191733`, \
-0.47378301679899637`}, {-0.1822926505129931, -0.4816374320033207}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17634937735659145`, -0.482448712407455}, \
{-0.12618343454687614`, -0.4880097065739532}, {-0.07612935698636593, \
-0.49119618941824233`}, {-0.027131309834296076`, -0.4919353683451162}, {
        0.02067371890729157, -0.49020630902504475`}, {
        0.06303106941359277, -0.4863618110989587}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.06899384269658401, -0.4857136208274493}, {
        0.11228056172750883`, -0.47927478098809884`}, {
        0.15605598495536394`, -0.47006052893647}, {
        0.19851630047435945`, -0.45835231742362853`}, {
        0.23974682200969344`, -0.4441690671428742}, {
        0.29215466708698673`, -0.42193689062019274`}, {
        0.2983036653395982, -0.4187472483555434}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3036297419381436, -0.4159844765469377}, {
        0.34286817954129156`, -0.3956304979253541}, {
        0.392165130900998, -0.36546654464053385`}, {
        0.4403232926944963, -0.33166168634790744`}, {
        0.48559638746204664`, -0.2964009483074228}, {
        0.5022752327023081, -0.28239370636787764`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5068698672591578, -0.2785350364818933}, {
        0.5306213081382098, -0.2585880812812664}, {
        0.5753980547229863, -0.21822308526943845`}, {
        0.6199266272163758, -0.17530596027193862`}, {
        0.6448395991702189, -0.1503188197700867}, {
        0.6698908665230541, -0.1248086112159883}, {
        0.6808888240143348, -0.11344228174468525`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6850610163689783, -0.10913034355451436`}, {
        0.6950804292748816, -0.0987753346096435}, {
        0.720408287425701, -0.07221898995105225}, {
        0.7459044287863853, -0.04518498734704828}, {
        0.771598841167807, -0.017718736904465435`}, {0.7974915245699662, 
        0.01017976137669635}, {0.8235824789928629, 0.03851050749643708}, {
        0.8488548696095384, 0.06627572133834078}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.852866997752584, 0.07073693688522235}, {
        0.8759968018844718, 0.09654801173429227}, {0.9022295705990852, 
        0.12627458697306596`}, {0.9284794108262376, 0.15647304429173708`}, {
        0.9487158993449821, 0.17992785937047379`}, {0.9688116434978846, 
        0.20372173939796345`}, {1.0069054188062916`, 0.2533514625520826}, {
        1.0074752200014083`, 0.254168635880435}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0109070142322738`, 0.25909030108207143`}, {
        1.0427505610323156`, 0.3047583294192268}, {1.0639271884156736`, 
        0.33651344298300656`}, {1.0837946448546791`, 0.3691608564954745}, {
        1.1023529303493327`, 0.40270056995663067`}, {1.1196020448996338`, 
        0.43713258336647487`}, {1.1321695748453697`, 0.4655774477733148}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.134594375350809, 0.47106564807111934`}, {
        1.135306821985371, 0.4726781724100093}, {1.1492320950863328`, 
        0.509558612772236}, {1.1613778642025194`, 0.5477739044531549}, {
        1.1717441293339304`, 0.5873240474527661}, {1.1803049870420885`, 
        0.6284967581009655}, {1.1870345338885158`, 0.6715797527276488}, {
        1.1905163414513282`, 0.7035622742338861}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.191165700446406, 0.7095270318061191}, {1.191932769873213, 
        0.716573031332816}, {1.1949996949961792`, 0.7634765939164674}, {
        1.196380975994842, 0.8257087138690729}, {1.195103722272968, 
        0.8905595573674072}, {1.1934948959105482`, 0.9239790588561904}, {
        1.1918323865440064`, 0.9492640348767425}}]}, 
      {Arrowheads[{{0.0102128947069636, 1.}}], 
       ArrowBox[{{1.191438731280855, 0.9552511072442518}, {
        1.1912535370904567`, 0.9580677113233663}, {1.188390346220181, 
        0.9928303381329223}, {1.1849160237072085`, 1.0282717626488453`}, {
        1.1792852986023312`, 1.0771891615384939`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6322381920236446, 
        0.48954847901901866`}, {-0.6391550070435292, 
        0.4450960693791035}, {-0.643571038463079, 
        0.398887506085972}, {-0.6452456233482929, 
        0.35155532374369114`}, {-0.6438217272594584, 
        0.30389007229363746`}, {-0.6390354129614322, 
        0.25655588940733953`}, {-0.6379938944025583, 0.2506777339966347}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6369470917384078, 
        0.2447697559853073}, {-0.6307856633270669, 
        0.20999569128409362`}, {-0.6189714612292153, 
        0.1646523941231958}, {-0.6030919362999203, 
        0.12120337263894092`}, {-0.5829661007638727, 
        0.08013843473362553}, {-0.5589727613828972, 
        0.04161914638854658}, {-0.5465198952857125, 0.025391711865340862`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5428671203721753, 
        0.02063175016055441}, {-0.5314907249188191, 
        0.0058070735850012795`}, {-0.5088216241196272, \
-0.019045689380904385`}, {-0.4843292958480132, -0.04215690855620659}, \
{-0.4580137401039772, -0.0635265839409053}, {-0.4298749568875192, \
-0.0831547155350005}, {-0.40029295724378844`, -0.10100930091204562`}, \
{-0.369647752217934, -0.11705833764559405`}, {-0.35446315857848004`, \
-0.12387929069473899`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3489899967476489, -0.12633784709505463`}, \
{-0.3379393418099559, -0.13130182573564578`}, {-0.3051677260198538, \
-0.14373976518220102`}, {-0.2718042508285233, -0.15440297938695996`}, \
{-0.23832026221685904`, -0.16332229175162324`}, {-0.20471576018486112`, \
-0.17049770227619088`}, {-0.1709907447325295, -0.1759292109606628}, \
{-0.12512499260572468`, -0.18073794823703732`}, {-0.11661586000283873`, \
-0.18109597816566284`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1106211641205189, -0.1813482107537589}, \
{-0.08051418939940796, -0.1826149906376302}, {-0.03715833511357984, \
-0.18156033816244127`}, {0.004942570251760023, -0.17757399081147074`}, {
        0.04551990374436398, -0.17098216242330258`}, {
        0.08430504241198439, -0.16211106683652093`}, {
        0.12129798625462121`, -0.1509607040511258}, {
        0.12566648030079794`, -0.14929405603184426`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.13127235593101116`, -0.1471553278072721}, {
        0.15649873527227443`, -0.13753107406711718`}, {
        0.18999472691300107`, -0.12218790388663026`}, {
        0.22187339862485816`, -0.10529692051180019`}, {
        0.2521347504078457, -0.08685812394262701}, {
        0.2807787822619636, -0.06687151417911072}, {
        0.31835921156255476`, -0.03707213099712306}, {
        0.33455084708719673`, -0.02254294035122297}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.33901654266455505`, -0.018535751434992274`}, {
        0.35342358292924136`, -0.00560792618038972}, {0.3859718963620235, 
        0.027521100271089394`}, {0.4160041518609012, 0.06231494835731435}, {
        0.4422182769018579, 0.09642376986269592}, {0.4664680055067965, 
        0.1314050181607898}, {0.48875264417936365`, 0.16722679472999308`}, {
        0.4889792360921372, 0.16763528988062146`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.49188965939422513`, 0.172882140002615}, {
        0.5090714994232053, 0.20385720104870253`}, {0.5273319920001198, 
        0.24136759780788936`}, {0.5434415426719059, 0.2798293456985249}, {
        0.5572661425513347, 0.319367688973744}, {0.5685393187700297, 
        0.3602291539103993}, {0.5756155898285069, 0.39643093868959484`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5767666118732372, 0.4023194994859648}, {
        0.5768425360927864, 0.40270792330875704`}, {0.5819109082608043, 
        0.4470916107363095}, {0.583238928668991, 0.4938221629795201}, {
        0.5803210907122537, 0.5433415268248523}, {0.575251002292674, 
        0.580362464495829}, {0.5671720833908265, 0.6193958193614255}, {
        0.5616042778119867, 0.640007295211706}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5600395736334213, 0.6457996782129913}, {
        0.5560843340067109, 0.6604415914216422}, {0.5419877541403273, 
        0.7034997806764788}, {0.5256927935817752, 0.7459263926634481}, {
        0.5060729631564663, 0.7905482409401361}, {0.48296421098063547`, 
        0.837249766750162}, {0.46695339431211125`, 0.8663651055390811}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.4640622450030545, 0.8716226007290685}, {
        0.45620248517051737`, 0.8859154113371454}, {0.4257709363848225, 
        0.9359415034525655}, {0.39165271528226137`, 0.9867243718479026}, {
        0.37383451685485203`, 1.012073702916228}, {0.35515094133691055`, 
        1.0372785096092143`}, {0.3277217015429138, 1.0685471606892958`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.32376502584281464`, 1.0730576725675913`}, {
        0.3185277711825085, 1.0790280126069272`}, {0.2799639372642434, 
        1.117773924806448}, {0.240708057870609, 1.154344616822057}, {
        0.20006808752623623`, 1.1865648684698429`}, {0.15847920784060723`, 
        1.2140161960213085`}, {0.1389903271272832, 1.2243219443437827`}}]}, 
      {Arrowheads[{{0.009094684054451267, 1.}}], 
       ArrowBox[{{0.13368626162061328`, 1.227126741858926}, {
        0.1163766004232043, 1.2362801157479577`}, {0.07412458453441688, 
        1.2536007417080528`}, {0.032087479434634476`, 
        1.2662221879598576`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.23154267397474682`, 
        0.8975789783991697}, {-0.26528976028608203`, 
        0.9138180206111962}, {-0.30015729362302135`, 
        0.92831255364258}, {-0.33627648180684927`, 
        0.9407000205593665}, {-0.37379582982631543`, 
        0.950688864088019}, {-0.4129898102843838, 
        0.957776948899597}, {-0.45408049895172975`, 
        0.9613967062670189}, {-0.46077908046629135`, 0.9613698194214642}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.46677903213481975`, 
        0.9613457367446322}, {-0.4974125533147557, 
        0.9612227795557149}, {-0.5433986248877194, 
        0.9566769971238891}, {-0.5924513651848784, 
        0.9471811873297457}, {-0.6477024097847539, 
        0.9308875610251097}, {-0.6993401150028478, 0.9103035603843869}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7049136167933079, 
        0.9080818318249678}, {-0.7073182166079139, 
        0.907123301930669}, {-0.7481173575446678, 
        0.8873229059679819}, {-0.7909187002525161, 
        0.8633411775589165}, {-0.8354960103531153, 
        0.83461432355949}, {-0.8816230534681219, 
        0.8005785508257193}, {-0.9050817487556408, 
        0.7814310755812164}, {-0.9068512353011433, 0.7798667724488504}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.9113464901604522, 
        0.7758927714737801}, {-0.9285559249959876, 
        0.7606788819486507}, {-0.9520455821891625, 
        0.7383219699280221}, {-0.975550720335165, 
        0.7143603395193306}, {-0.9971324524742216, 
        0.6916302519412482}, {-1.018435456668925, 
        0.6674655400283498}, {-1.046897609496355, 
        0.6278216856305633}, {-1.0674160424525938`, 0.5950381876999645}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0705992424571682`, 
        0.5899522032592807}, {-1.07352445999515, 
        0.5852784124630972}, {-1.0989563520713446`, 
        0.5414740458195905}, {-1.1219983273023388`, 
        0.4951474922240025}, {-1.1423774683481938`, 
        0.4466689837732566}, {-1.1598208578689713`, 
        0.3964087525642764}, {-1.1669191493156843`, 
        0.37107955776481716`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1685382226200316`, 
        0.3653021360530888}, {-1.1742731203098875`, 
        0.3448380086173804}, {-1.1856788801161589`, 
        0.2924279619528874}, {-1.1931823704642868`, 
        0.2466091753844019}, {-1.198659161079715, 
        0.20066524214264275`}, {-1.2021675686713826`, 
        0.15496563856131626`}, {-1.2031092065869184`, 0.128404041813934}}]}, 
      {Arrowheads[{{0.00838556703362356, 1.}}], 
       ArrowBox[{{-1.2033217796710098`, 
        0.12240780860600088`}, {-1.203765909948228, 
        0.10987984097412824`}, {-1.2036196174526668`, 
        0.06551334515985487}, {-1.201955332774814, 0.021820800865883547`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.5846294015164717, 
        0.8486035374250669}, {-0.6266336896127048, 
        0.8242199347129426}, {-0.6704506158747108, 
        0.7923935467654227}, {-0.7157906082508622, 
        0.7519641968479027}, {-0.7389897228242118, 
        0.7279522355115287}, {-0.762519166237061, 
        0.7011041229160174}, {-0.7671622324207698, 0.6952901973908168}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.770906431167238, 
        0.6906018100617936}, {-0.7861303892439236, 
        0.6715387696151187}, {-0.8095748425993133, 
        0.6393750861625819}, {-0.8282897436689806, 
        0.611384232965095}, {-0.8466862754323692, 
        0.5816110576344427}, {-0.8647644378894791, 
        0.550055560170625}, {-0.8825242310403103, 
        0.5167177405736418}, {-0.8971284677327476, 0.48713305232145604`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8997813044571106, 
        0.48175143300908824`}, {-0.916175881166609, 
        0.44569627192693695`}, {-0.9318395310779446, 
        0.40826290711390467`}, {-0.9467283975547376, 
        0.36954778864108573`}, {-0.9606322388887893, 
        0.32998160100709384`}, {-0.9733408133719013, 
        0.2899950287105423}, {-0.9827780631533243, 0.2568741777862797}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9844222257076172, 
        0.2511038459504958}, {-0.9848541210040731, 
        0.2495880717514313}, {-0.9951721617853049, 
        0.20876073012976076`}, {-1.006831815093939, 
        0.1545847096454755}, {-1.015977151348547, 
        0.10112082315335996`}, {-1.0226081705491292`, 
        0.048369070653413976`}, {-1.0252491452594055`, 
        0.014984261279620777`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0257223095204782`, 
        0.009002947412079335}, {-1.0267248726956855`, -0.003670547854362726}, \
{-1.028307473765435, -0.05488088053523592}, {-1.0273353137938837`, \
-0.10488505436659541`}, {-1.0249533154941561`, -0.1414800348135072}, \
{-1.021164146519028, -0.17748926853321081`}, {-1.0159678068684994`, \
-0.21291275552570624`}, {-1.01273562592237, -0.22996457716813398`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0116182197685015`, -0.23585960927044664`}, \
{-1.0093642965425706`, -0.24775049579099345`}, {-1.001303157207986, \
-0.28213821682388995`}, {-0.9917339305314903, -0.3162116461192132}, \
{-0.9806566165130832, -0.34997078367696327`}, {-0.9680712151527652, \
-0.38341562949714003`}, {-0.9504674245652674, -0.42384796166963185`}, \
{-0.9316262632197643, -0.4611865069634929}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9288058927409835, -0.4664799440090677}, \
{-0.9068057405146756, -0.5048287238269226}, {-0.8807478470515816, \
-0.5453771538117211}, {-0.851310825605863, -0.5861487241691472}, \
{-0.8179335824867601, -0.6273278760010585}, {-0.7883507228932821, \
-0.6602951340716615}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7843435001337798, -0.6647607992803093}, \
{-0.780616117694273, -0.6689146093074557}, {-0.7393584312284016, \
-0.7109089240883384}, {-0.7164029320229531, -0.7327555570579969}, \
{-0.6922121828611221, -0.7546838896826771}, {-0.6667861837429084, \
-0.7766939219623791}, {-0.640124934668312, -0.7987856538971028}, \
{-0.6122523523575194, -0.8208875685633077}, {-0.6063700988719347, \
-0.8253489686511417}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6015895602980478, -0.8289747721405187}, \
{-0.5831923535307171, -0.8429281490374533}, {-0.5529449381879049, \
-0.8649073953195395}, {-0.5215101063290829, -0.8868253074095663}, \
{-0.489020793323006, -0.9085484520860472}, {-0.45560993453842885`, \
-0.9299433961274947}, {-0.4212775299753516, -0.9510101395339097}, \
{-0.40217611525901586`, -0.9622467669827617}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.397004569263999, -0.9652889885429747}, \
{-0.38602357963377415`, -0.9717486823052917}, {-0.35035506972193875`, \
-0.9922965023136727}, {-0.31401353251420105`, -1.0123097933997725`}, \
{-0.25753346438611585`, -1.0397572450706205`}, {-0.200550757775471, \
-1.065182997542908}, {-0.18273015434818712`, -1.0728861876877729`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17722267253402277`, -1.0752668691168281`}, \
{-0.16304877645394372`, -1.0813937220622925`}, {-0.12555285851985856`, \
-1.0965563314626254`}, {-0.08806300397321554, -1.1106708257439069`}, \
{-0.05057921281401466, -1.123737204906137}, {-0.013189944386254093`, \
-1.135698696035253}, {0.02401634196606787, -1.1464985262171927`}, {
        0.049526304456228756`, -1.153139460635522}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.05533277668316323, -1.1546510426802152`}, {
        0.061039646242951315`, -1.156136695451956}, {
        0.09787996844439617, -1.164613203739543}, {
        0.13455952486255396`, -1.1719621140329624`}, {
        0.17110053178957604`, -1.178217489285223}, {
        0.20750298922546248`, -1.183379329496325}, {
        0.24376689717021327`, -1.1874476346662686`}, {
        0.29218077115351765`, -1.1912239715541206`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.29816260149323526`, -1.1916905610812578`}, {
        0.2990211994319643, -1.1917575326908625`}, {
        0.3546970756123242, -1.1939763674820427`}, {
        0.4107945257112934, -1.1941041390398095`}, {
        0.46731354972887124`, -1.1921408473641624`}, {
        0.5249518166028997, -1.188270356673535}, {
        0.5378945968570257, -1.1870526384581996`}}]}, 
      {Arrowheads[{{0.013846559364612812`, 1.}}], 
       ArrowBox[{{0.5438682160501097, -1.1864906120032905`}, {
        0.5844069952712201, -1.1826765311863603`}, {
        0.6456790857338324, -1.175359370902639}, {
        0.7087680879907367, -1.1663188758223704`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7468538202868837, 
        0.07299985600577912}, {-0.7381359897819815, 
        0.03451645140623947}, {-0.7268524426821459, -0.0025557205654536917`}, \
{-0.7129042200906728, -0.03806968147105262}, {-0.6962593635894364, \
-0.0719737046202673}, {-0.6768859147603112, -0.10421606332280779`}, \
{-0.6545519230565767, -0.1347431454844137}, {-0.64765537820266, \
-0.14256222343610309`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6436865031904829, -0.1470620046683095}, \
{-0.6291854316343879, -0.1635028473340015}, {-0.6009944726299323, \
-0.19044570466604638`}, {-0.5701870781793981, -0.21552225327502378`}, \
{-0.5367138887983092, -0.2387969646420793}, {-0.500706907696455, \
-0.2601263274308824}, {-0.46242818957125326`, -0.27946535605999623`}, \
{-0.4496998501672448, -0.28493212756763203`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4441868273019583, -0.2872999491164039}, \
{-0.42213978912012184`, -0.29676906494798405`}, {-0.3802093171777187, \
-0.3119965714850631}, {-0.337004384578701, -0.32510699306145086`}, \
{-0.29283281733977984`, -0.33607451371494124`}, {-0.24821256949496429`, \
-0.34486292133588203`}, {-0.21331748797676278`, -0.34988795838628123`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.20737874842674509`, -0.35074316161186886`}, \
{-0.2003927400811343, -0.35174917590510907`}, {-0.13759818255398706`, \
-0.35705563823453385`}, {-0.07657260602839598, -0.3578860923044697}, \
{-0.01747764950608867, -0.35440284914057624`}, {
        0.03177734175742348, -0.3478059051467061}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.03772423975181774, -0.3470094101722904}, {
        0.039525048011208375`, -0.346768219768513}, {
        0.09392151384563215, -0.3349353807753076}, {
        0.1454796422602285, -0.3190248162988931}, {
        0.19446059466463406`, -0.2994497986912873}, {
        0.24112553246848534`, -0.2766236003045082}, {
        0.2618642717634404, -0.264822981129406}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.26707914757380535`, -0.261855647261694}, {
        0.28037811721703343`, -0.254288356215263}, {
        0.31814820227136775`, -0.22993787165083523`}, {
        0.35443578763148825`, -0.20357214661122494`}, {
        0.389240873297395, -0.1751911810964321}, {
        0.42282952329644247`, -0.1452051678927382}, {
        0.4553452382994599, -0.1141413902717865}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.459546085062976, -0.10985749334183376`}, {
        0.48715570837602384`, -0.08164857677749171}, {
        0.5178932434565577, -0.04807799886593908}, {
        0.5478930590144548, -0.013536054981551157`}, {0.5773678071665829, 
        0.021753765945887762`}, {0.6063174879129418, 0.05779146391637767}, {
        0.6167457299113, 0.07128712254481617}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6204143661301069, 0.07603487025231469}, {
        0.6347421012535318, 0.09457703892991859}, {0.6687532238318128, 
        0.14053352316262596`}, {0.7022483773004579, 0.18774642945734116`}, {
        0.7333793617567308, 0.2333644113225668}, {0.7585555038299009, 
        0.2721955249666274}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7618195911630219, 0.2772299796423355}, {0.764014054003477,
         0.28061466962770826`}, {0.7941862853780965, 0.32970729544673494`}, {
        0.8235128973807799, 0.38133551525804815`}, {0.8510066836578649, 
        0.435997393141185}, {0.8743148070957645, 0.4888674702202189}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8767351783171902, 0.4943576253319161}, {
        0.8767822490901752, 0.4944643964927312}, {0.8888575369321114, 
        0.5253690353923763}, {0.9001669454479978, 0.5577133860055608}, {
        0.9107104746378337, 0.5914974483322846}, {0.9204881245016192, 
        0.6267212223725475}, {0.929281688330488, 0.6636688747585354}, {
        0.9368729594155722, 0.7026245721224333}, {0.9403902076499324, 
        0.7251758538341152}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9413148292331355, 0.7311041820072071}, {
        0.9432619377568731, 0.7435883144642417}, {0.9484486233543894, 
        0.7865601017839601}, {0.9523590527635035, 0.8333179185215053}, {
        0.9545815040490387, 0.8824006092008071}, {0.9549864522199956, 
        0.9335113606886563}, {0.9539096293773349, 0.9704105320437095}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.9537346068122364, 0.9764079787589132}, {
        0.9534443722853744, 0.9863533598518435}, {0.9498588531314349, 
        1.0400888804748614`}, {0.9441334836444374, 1.093880196342203}, {
        0.9388566547131613, 1.135673054088635}, {0.9322381119513625, 
        1.17638501402869}, {0.9223364012869996, 1.2138269721142108`}}]}, 
      {Arrowheads[{{0.013937741304700407`, 1.}}], 
       ArrowBox[{{0.9207339442232367, 1.219606894620558}, {0.908166990912523, 
        1.2565533055265548`}, {0.8944413479717293, 1.2918228869851553`}, {
        0.8790628127541699, 1.3217852406509836`}, {0.84369600410261, 
        1.3661069707370226`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0863426908642362`, -1.5}, {
        1.102655010867748, -1.4816324256319815`}, {
        1.1264375557841442`, -1.4578461846519668`}, {
        1.1725144575096142`, -1.4165103341755527`}, {
        1.216315635919208, -1.3808732921477884`}, {
        1.258978952670864, -1.3480856543443493`}, {
        1.2666998521293786`, -1.3423415532800163`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.2715137544508353`, -1.3387601646611318`}, {
        1.2984188487069719`, -1.3187436392053802`}, {
        1.3177792751601805`, -1.3038684150252713`}, {
        1.335857454789662, -1.2895310841955219`}, {
        1.3693034335484058`, -1.2617358875166322`}, {
        1.3973907681201125`, -1.2354873144877294`}, {
        1.4203702807337064`, -1.2104188124885797`}, {
        1.445390689873563, -1.1753999730248845`}}]}, 
      {Arrowheads[{{0.018013829478021028`, 1.}}], 
       ArrowBox[{{1.4488787607895706`, -1.1705180306568408`}, {
        1.449440104377487, -1.1697323680052294`}, {
        1.4673145049480818`, -1.130644151690877}, {
        1.4730840118049517`, -1.1116427835677127`}, {
        1.4778133919343723`, -1.0928477612674032`}, {
        1.4813052335967902`, -1.0741444656326231`}, {
        1.4854761436476411`, -1.0367288931288388`}, {
        1.4869137937907664`, -0.9989673919499867}, {
        1.4866348776194067`, -0.9604507766278998}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.5, -0.4681793116971826}, {-1.472632075906381, \
-0.4848195158761078}, {-1.4210443654571507`, -0.5214509162300867}, \
{-1.3791798673147313`, -0.5576048460902399}, {-1.3418773703106053`, \
-0.5938108388505017}, {-1.3170832939696473`, -0.6218121441888388}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.313105719008389, -0.6263042369558652}, \
{-1.309886660734279, -0.6299396953772929}, {-1.2869435652397687`, \
-0.6623734010609867}, {-1.2653963939670982`, -0.6951773483295458}, \
{-1.2443240268629343`, -0.7285439386028654}, {-1.2240335039450554`, \
-0.7624090380743139}, {-1.205847698999217, -0.7922691862144895}, \
{-1.1877829780163132`, -0.8225340105253827}, {-1.184239033883532, \
-0.828591366465328}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.1812091209732862`, -0.8337701334765312}, \
{-1.1698393409963437`, -0.8532035110069938}, {-1.152016787939308, \
-0.8842776876593226}, {-1.1340816378769127`, -0.9156321397613956}, \
{-1.115800209840864, -0.9471424665922391}, {-1.0971725038311613`, \
-0.978808668151853}, {-1.0781985198478048`, -1.0106307444402374`}, \
{-1.0596638906767313`, -1.0407005328934344`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0564317980058406`, -1.0457551647365593`}, \
{-1.038539205230097, -1.0732992347143795`}, {-1.0176857464132374`, \
-1.1037848270779023`}, {-0.9961497532577072, -1.1337046509257267`}, \
{-0.9687335449063074, -1.169310265377009}, {-0.940058821999085, \
-1.203004406259903}, {-0.9099451296019088, -1.2342116490486772`}, \
{-0.9093426946679416, -1.2347459641372007`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9048538658689174, -1.2387272222314532`}, \
{-0.8782120127806476, -1.2623565692176009`}, {-0.844832675671131, \
-1.287282807234232}, {-0.809868127592023, -1.3090734692765809`}, \
{-0.7732696213834447, -1.3275123293845925`}, {-0.7349884098855168, \
-1.3423831615982127`}, {-0.6970823796563689, -1.3534258274670399`}}]}, 
      {Arrowheads[{{0.003195458095457159, 1.}}], 
       ArrowBox[{{-0.6901018885545579, -1.3627347654908197`}, \
{-0.654936944168146, -1.3627347654908197`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -1.1855648815248672`}, {-1.4662536354371873`, \
-1.2053454756786}, {-1.4210770246915816`, -1.2347686230312511`}, \
{-1.3801255563853987`, -1.263186512457561}, {-1.3441216978288166`, \
-1.2893457058694193`}, {-1.3066626620967432`, -1.3160949342316495`}, \
{-1.3011904079395948`, -1.3197694677525997`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.2962092099510394`, -1.3231142646969316`}, \
{-1.271930477602374, -1.3394170557039629`}, {-1.2380677898788304`, \
-1.361004595509456}, {-1.205944095696938, -1.3791229719813094`}, \
{-1.1751135746300219`, -1.394074266708174}, {-1.1451304062514067`, \
-1.4061605612787016`}, {-1.0866293943405574`, -1.4231483223754495`}, \
{-1.0805151061477967`, -1.4242135022458826`}}]}, 
      {Arrowheads[{{0.01624842530950693, 1.}}], 
       ArrowBox[{{-1.074604133761836, -1.4252432621462525`}, \
{-1.0365137153641533`, -1.431879054515611}, {-0.9858412983438547, \
-1.436257064379732}, {-0.9340070017437097, -1.4374450239220866`}, \
{-0.8804056840277664, -1.436605605096949}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7197927325727591, 1.5}, {-0.727077761924682, 
        1.486377813124913}, {-0.7590335063067366, 
        1.4362819180656063`}, {-0.7909061191826798, 
        1.3963913455672132`}, {-0.8248553289250299, 
        1.3592885104051617`}, {-0.8589960064784387, 
        1.3284309276801018`}, {-0.8737531925370269, 1.3185462973403248`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-0.8787382316759437, 
        1.315207227891591}, {-0.9121387187212575, 
        1.2928349770911542`}, {-0.9659323211875865, 
        1.2605162504054854`}, {-1.0194225336579898`, 
        1.228962958909001}, {-1.072305966136541, 
        1.1989405377908853`}, {-1.0845625289537795`, 
        1.1919112823896187`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0897673158027856`, 
        1.1889262876063047`}, {-1.123356561787279, 
        1.1696625354205046`}, {-1.1713482637742418`, 
        1.1403425001672254`}, {-1.2150658131053205`, 
        1.1105948008737003`}, {-1.2532939507884049`, 
        1.0800338063825825`}, {-1.2793443300385023`, 
        1.0556260788910545`}, {-1.284373751837968, 1.0500352001092772`}}]}, 
      {Arrowheads[{{0.004350573624300164, 1.}}], 
       ArrowBox[{{-1.288386495808791, 
        1.0455744954760804`}, {-1.3019171854037908`, 
        1.0305333141284483`}, {-1.3205808924707474`, 1.0045701425079423`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5203024102113541, 1.5}, {-0.5371532318262536, 
        1.467046423782276}, {-0.5566382998562858, 
        1.4335591759601232`}, {-0.5758033955911115, 
        1.4060510591425797`}, {-0.6034250858196214, 
        1.3722607292120585`}, {-0.6378231569715508, 
        1.3429881613054468`}, {-0.6716797518070998, 1.3182907585554142`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6766039121777949, 
        1.314863251000504}, {-0.7079849696766667, 
        1.2933014780595276`}, {-0.743979181523161, 
        1.2715277107267564`}, {-0.7808403028214743, 
        1.2514775870250898`}, {-0.8187045986282765, 
        1.232419091153481}, {-0.8575739453279783, 
        1.2139710121663927`}, {-0.887117612953812, 1.2004729523887727`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8925749917034391, 
        1.1979795576781185`}, {-0.8974502193049909, 
        1.195752139118288}, {-0.9365231175041816, 
        1.1780752397853944`}, {-0.9758095158401845, 
        1.1599855152223237`}, {-1.015309414313, 
        1.1414829654290761`}, {-1.0550228129226276`, 
        1.1225675904056511`}, {-1.0939045431789152`, 
        1.102965200990848}, {-1.1090730485348566`, 1.0945360733459268`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1143176721382073`, 
        1.0916216397372858`}, {-1.13090943659171, 
        1.0824016080234653`}, {-1.1660374931610127`, 
        1.060876811503503}, {-1.1992887128868222`, 
        1.0383908114309615`}, {-1.229727179584832, 
        1.0147410861492352`}, {-1.2564169770707336`, 
        0.9897251140017185}, {-1.2793581053445275`, 
        0.9633428949884119}, {-1.2961910409252544`, 0.9390058292114016}}]}, 
      {Arrowheads[{{0.005389957066688717, 1.}}], 
       ArrowBox[{{-1.2994294053593252`, 
        0.9339641084509062}, {-1.314308467602703, 
        0.9063622511782664}, {-1.3269459282809057`, 0.8755288960091054}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3446033746702703, 1.5}, {-0.3577593085868577, 
        1.4736885121404404`}, {-0.37630357282117743`, 
        1.4411217433113679`}, {-0.39428707142560415`, 
        1.414776892092624}, {-0.4067629544334471, 
        1.4004217344391094`}, {-0.4191177325456056, 
        1.3873414919189009`}, {-0.4436355971370981, 
        1.3632779216723856`}, {-0.46785241275641853`, 
        1.3428052598804736`}, {-0.4919166046515592, 
        1.3249278995509826`}, {-0.49874171369852355`, 1.3204655072063356`}}]}, 
      {Arrowheads[{{0.013049909238544521`, 1.}}], 
       ArrowBox[{{-0.5037635916924529, 
        1.317182103269247}, {-0.5286488296285039, 
        1.3009116386515507`}, {-0.565650297638948, 
        1.2799818952904618`}, {-0.6032391890045617, 
        1.2611881095268642`}, {-0.6417336840470148, 
        1.2435797214199056`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.5, -1.4004968513051506`}, {-1.4826776370242565`, \
-1.4049878506754614`}, {-1.4448726097074143`, -1.4149203348860995`}, \
{-1.4116030399002744`, -1.4234481271917396`}, {-1.387306908214823, \
-1.4290849171447864`}, {-1.36460642920351, -1.4340228778351178`}, \
{-1.3217405936772437`, -1.4426129540807906`}, {-1.2832059636094197`, \
-1.4488904887090375`}, {-1.265604851765152, -1.451092544904854}}]}, 
      {Arrowheads[{{0.008410430244037781, 1.}}], 
       ArrowBox[{{-1.259651264354409, -1.4518373918305003`}, \
{-1.247770886363392, -1.453323733159118}, {-1.2019804871247175`, \
-1.4572215998704214`}, {-1.159017651013966, -1.45891427446949}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.5, -1.0045132003631996`}, {-1.485708505139749, \
-1.0134207713935024`}, {-1.4446829087510478`, -1.0418114651588632`}, \
{-1.4094301020351148`, -1.0697260819321417`}, {-1.369666527329365, \
-1.1081943780813004`}, {-1.333808613639296, -1.1451978370211096`}, \
{-1.3189434003043092`, -1.160660380007022}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.314785128321807, -1.164985744051763}, \
{-1.2992124396372149`, -1.1811841909065424`}, {-1.2671397450111095`, \
-1.215136334683223}, {-1.2369434473534566`, -1.2467577926187792`}, \
{-1.207976464256733, -1.2757520889808398`}, {-1.1798981927385377`, \
-1.3019590788606767`}, {-1.1523680298164691`, -1.325218617349563}, \
{-1.1428124257819021`, -1.3319136307335158`}}]}, 
      {Arrowheads[{{0.003895932708220032, 1.}}], 
       ArrowBox[{{-1.1323328070260952`, -1.3582833944855843`}, \
{-1.105175604695955, -1.3582833944855843`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.18382426614256758`, 1.5}, {-0.19093924176723054`, 
        1.486318249652206}, {-0.2094378294878278, 
        1.4551172724355657`}, {-0.22724347466742534`, 
        1.4300542965654337`}, {-0.2387621736815254, 
        1.4172357247488803`}, {-0.25010287446611046`, 
        1.4055621942023706`}, {-0.2724661643092744, 
        1.3841281321638514`}, {-0.29425798236620637`, 
        1.3659997395149817`}, {-0.31559422955116356`, 
        1.3503129825437141`}, {-0.34661685418635585`, 
        1.3301063091735923`}, {-0.34768288275178316`, 1.3295023807871185`}}]}, 
      {Arrowheads[{{0.002314893300286829, 1.}}], 
       ArrowBox[{{-0.35579732021593097`, 
        1.3144917735821473`}, {-0.3741789647762453, 
        1.3144917735821473`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.017229442696264627`, 1.}}], 
       ArrowBox[{{-0.03644267847927633, 1.5}, {-0.05512714776299307, 
        1.47054633150413}, {-0.07362434010703414, 
        1.446326164190298}, {-0.08422138144147386, 
        1.435321556711002}, {-0.0946521189201026, 
        1.4252377914358805`}, {-0.11520328369412924`, 
        1.4066402477486206`}, {-0.1351750499613158, 
        1.3907937305587204`}, {-0.15464147435636266`, 
        1.3770425754720212`}, {-0.18391089903206875`, 
        1.358652843760174}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.33668070509341497`, -0.6527031086760351}, \
{-0.3008771323090242, -0.6657329076263793}, {-0.2645504122638067, \
-0.6781584705107697}, {-0.2136123297236373, -0.6943378563616138}, \
{-0.16252287928478576`, -0.7091926553038934}, {-0.13023577055160576`, \
-0.7178848030676176}, {-0.10752998681288317`, -0.7236178814156433}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.10171256188569419`, -0.7250867473783916}, \
{-0.09810857060216295, -0.72599673421839}, {-0.0661412794364574, \
-0.7335284487562107}, {-0.034333897054489165`, -0.7404799466810795}, {
        0.028610174064619572`, -0.7525341476589154}, {
        0.09053267546154724, -0.7620511921188514}, {
        0.134375951271472, -0.7672010542964526}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.14035088817814442`, -0.7677425230901797}, {
        0.18038349536513265`, -0.7710774901505953}, {
        0.22471518288605624`, -0.7732294359003398}, {
        0.2686510554530671, -0.7738072461393326}, {
        0.3124753227735517, -0.772644975354184}, {
        0.35647219455489665`, -0.769576678031504}, {
        0.37988593730675096`, -0.7669398448802857}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3858482463154776, -0.7662683753839885}, {
        0.4006416707971019, -0.7646023541712927}, {
        0.4449837515001672, -0.7577220037735503}, {
        0.49924075550857827`, -0.746463516240014}, {
        0.5549901574703152, -0.7315575045725504}, {
        0.6122319573853785, -0.7130039687711599}, {
        0.6187295320344043, -0.7105479372009244}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.6243419669237573, -0.7084264814241586}, {
        0.6709661552537679, -0.6908029088358421}, {
        0.7231541127232632, -0.6684320972000051}, {
        0.7770730031814228, -0.6427791607421773}, {
        0.8046613989013498, -0.6286859506313733}, {
        0.832642229108639, -0.6137003191677842}, {
        0.8421930128429084, -0.6083555747331024}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8474289121427168, -0.6054254964880267}, {
        0.8610154938032908, -0.5978222663514102}, {
        0.8897811929853047, -0.5810517921822512}, {
        0.9187950819935035, -0.5633822294357158}, {
        0.9479129161667097, -0.5448069108872122}, {
        0.9771346955049234, -0.5253258365367406}, {
        1.0064604200081442`, -0.504939006384301}, {
        1.0436215822474915`, -0.47857792812366956`}, {
        1.048590966075309, -0.47482612521985224`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0533794872017286`, -0.4712108706753101}, {
        1.0803780851704519`, -0.4508273740955062}, {
        1.1269710009934468`, -0.4088930204317751}, {
        1.170108627168636, -0.3650265421557988}, {
        1.2108542243552294`, -0.32044597374404715`}, {
        1.2241357878545547`, -0.30345370559880575`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2278307497178238`, -0.29872641707059144`}, {
        1.2468157635646318`, -0.2744372250607448}, {
        1.2776306565936837`, -0.22739158828223655`}, {
        1.3029363152392266`, -0.1797003555848672}, {
        1.3230213983377084`, -0.13170258625661752`}, {
        1.3371534918937518`, -0.08696940402626249}}]}, 
      {Arrowheads[{{0.003005248802224667, 1.}}], 
       ArrowBox[{{1.3408154676640407`, -0.05469988453526136}, {
        1.3450635805290914`, -0.05469988453526136}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.590014821142007, -0.6526475896914061}, \
{-0.5605863750002678, -0.6716326184270776}, {-0.5298765196740457, \
-0.6904281437017935}, {-0.49802567983963825`, -0.7089891167056167}, \
{-0.4651742801733426, -0.7272704886286089}, {-0.4313223206751592, \
-0.7452722594707706}, {-0.39646980134508747`, -0.7629944292321017}, \
{-0.38107862488328914`, -0.7703851258196748}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.37566988854768996`, -0.7729823495782233}, \
{-0.3432306002479615, -0.7885593873657615}, {-0.2887110164052429, \
-0.8132544719590776}, {-0.2479500726016019, -0.8309085410403179}, \
{-0.2068625429044176, -0.8479846306182507}, {-0.1555139092074973, \
-0.8683731525473327}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.14990869418034636`, -0.8705130746893015}, \
{-0.10122081181147863`, -0.8888330739019915}, {-0.04851101619155888, \
-0.9075189314816987}, {0.004019248884227758, -0.9249404419129299}, {
        0.04021465470943958, -0.936269935879137}, {
        0.07601438633678356, -0.9469359741907255}, {
        0.07739097664753679, -0.9473224869831537}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.08316759617194872, -0.94894442004903}, {
        0.11152193011836595`, -0.9569056215085072}, {
        0.14684077240629334`, -0.9661459424932943}, {
        0.18207439955267232`, -0.9746240018058988}, {
        0.21732629790960933`, -0.9823068641071329}, {
        0.252699953829211, -0.9891615940578085}, {
        0.28829885366358365`, -0.9951552563187376}, {
        0.31759945070889467`, -0.9992929375890314}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3235405058958053, -1.000131903181939}, {
        0.3259546048654228, -1.0004728099585405`}, {
        0.3639425064363372, -1.0047795131115116`}, {
        0.4022625583763268, -1.0080753657776511`}, {
        0.4409147606853917, -1.0103603679569584`}, {
        0.48015330938558537`, -1.0115729540373493`}, {
        0.5202324004989609, -1.0116515584067383`}, {
        0.5611520340255186, -1.0105961810651256`}, {
        0.5630292558057806, -1.0104977640348833`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.5690210270068257, -1.010183633688806}, {
        0.6029122099652583, -1.008406822012511}, {
        0.6457697732518903, -1.0049866785790522`}, {
        0.6899815688191246, -1.000238948094906}, {
        0.7355475966669613, -0.9941636305600726}, {
        0.7824678567954007, -0.9867607259745519}, {
        0.8071821466228662, -0.9821946801630913}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8130822944123782, -0.9811046085774064}, {
        0.8368214370380871, -0.9767187243982332}, {
        0.8929591872585692, -0.9647137917356359}, {
        0.9504876146754584, -0.9506205787045566}, {
        1.0090132265073664`, -0.9343137360227922}, {
        1.045668812099385, -0.9226464178960343}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0513861784964509`, -0.9208266043117076}, {
        1.067562224562588, -0.9156778371473437}, {
        1.1251608106494186`, -0.8945974555352131}, {
        1.1744942655353157`, -0.8753362451049582}, {
        1.2215538349220842`, -0.8541530008569206}, {
        1.259892806382439, -0.8301422382225747}, {
        1.2693814637717278`, -0.8229862779341267}}]}, 
      {Arrowheads[{{0.017871810852133636`, 1.}}], 
       ArrowBox[{{1.2741718826731299`, -0.8193735384266215}, {
        1.2940318433884364`, -0.804395962108048}, {
        1.325774752851653, -0.777805215966719}, {
        1.3527254072293091`, -0.749525529771786}, {
        1.375049954264846, -0.7196360195385142}, {
        1.3929145417017075`, -0.6882158012821699}, {
        1.4068069315197282`, -0.65536973947691}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.015190292999712014`, 1.}}], 
       ArrowBox[{{0.013823115102344876`, 0.4635058809487205}, {
        0.013310444957492087`, 0.4624492932724729}, {0.010001688019841143`, 
        0.4397932099057668}, {0.017845869281084187`, 0.4126631963516861}, {
        0.018744110157493707`, 0.4107700482602931}, {0.019688042121585616`, 
        0.40888294519421703`}, {0.02808565531183254, 0.3971147467059466}, {
        0.03767067165808521, 0.38674575325110316`}, {0.0583137152515523, 
        0.36945093194680334`}, {0.08023637068460406, 0.3598721505307402}, {
        0.10027194480670604`, 0.3587776410537689}, {0.12261629223420971`, 
        0.3725893732032201}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 1.2521043105247793`}, {1.4980465521849604`, 
        1.2533580827671333`}, {1.4573966829438039`, 1.2838263381374133`}, {
        1.4234324898742332`, 1.311339639160273}, {1.3928111348904557`, 
        1.3373754630094226`}, {1.3663771930473647`, 1.3602390969196259`}, {
        1.347872021422468, 1.3754119272568803`}, {1.3307600970166222`, 
        1.3887499596505908`}, {1.3126183401979514`, 1.4018859804642678`}}]}, 
      {Arrowheads[{{0.013173559964671679`, 1.}}], 
       ArrowBox[{{1.3077585457848413`, 1.405404843670234}, {1.29877861437781, 
        1.4119070014847825`}, {1.2706732784877433`, 1.428716300814758}, {
        1.2454428232808714`, 1.440520528164035}, {1.2004741240981014`, 
        1.4538211261892482`}, {1.1612139117572573`, 
        1.4581461838959178`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{0.779495000374682, -1.5}, {
        0.8039566319024228, -1.4737646729030078`}, {
        0.8453875465863334, -1.435032100860241}, {
        0.8870812604305527, -1.402767712203624}, {
        0.939702772501922, -1.367919615748177}, {
        0.967772719732795, -1.353450352774664}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.9731058717532598, -1.3507012639207685`}, {
        0.9791826483321852, -1.3475688576633371`}, {
        1.0187725530462124`, -1.328559304652182}, {
        1.0577787035371713`, -1.310224035205262}, {
        1.096432360840673, -1.2927853564923943`}, {
        1.1295623244806807`, -1.277482676829843}, {
        1.161748701551005, -1.2625318998917898`}, {
        1.190520197669025, -1.2490877917941432`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.195952690424058, -1.2465406422716834`}, {
        1.2232906959826044`, -1.2336860541891776`}, {
        1.2794104392243475`, -1.2057380200050023`}, {
        1.3284600263651116`, -1.1781779979597087`}, {
        1.3698198762936047`, -1.1507935166086192`}, {
        1.4015511944940875`, -1.124466631362044}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3384797699165798`, 1.5}, {-1.342642925313217, 
        1.485750991347845}, {-1.3552381748510594`, 
        1.4441285756266034`}, {-1.3668187113981791`, 
        1.4067224982393405`}, {-1.3765871667768421`, 
        1.3744632795757294`}, {-1.3829413722882737`, 
        1.3510605342460476`}, {-1.3884011801702218`, 
        1.329407436964026}, {-1.3976906999891898`, 
        1.2888401902297038`}, {-1.4013071714336633`, 
        1.2685527237921854`}}]}, 
      {Arrowheads[{{0.012958668780858542`, 1.}}], 
       ArrowBox[{{-1.4023601403016495`, 
        1.2626458416566546`}, {-1.4040957679355401`, 
        1.2529094209738931`}, {-1.4082860749604547`, 
        1.2202327914195341`}, {-1.4114011364160124`, 
        1.1803505405767956`}, {-1.4122465209390813`, 
        1.1431254510876874`}, {-1.4114817094392373`, 1.1077022036567443`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.5, -0.23320093635394684`}, {-1.4542681044556498`, \
-0.2635829724166063}, {-1.4144997509056092`, -0.29566473872311827`}, \
{-1.3774205103883594`, -0.32938787082711857`}, {-1.3467673680191068`, \
-0.3622062283080765}, {-1.3238287573873673`, -0.3937122116124906}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.320297193334532, -0.3985627842942181}, \
{-1.314131583254466, -0.40703119641222607`}, {-1.284889949983278, \
-0.45148260457629885`}, {-1.256616156298548, -0.49597528355841786`}, \
{-1.2302780417867358`, -0.5405505041766295}, {-1.2051405609603099`, \
-0.5855115644649482}, {-1.1954814222315846`, -0.6033837886206316}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.1926286681242915`, -0.6086622158488239}, \
{-1.1804686683317398`, -0.6311617624573886}, {-1.155809104732984, \
-0.6777291967612533}, {-1.1307086109959998`, -0.7254419659838449}, \
{-1.1086774662477568`, -0.766911417903014}, {-1.085591756380107, \
-0.8093068148248418}, {-1.079464856817961, -0.8203019468608698}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0765442654548238`, -0.8255431438701004}, \
{-1.0614514813930502`, -0.8526281567493285}, {-1.0362566412865868`, \
-0.8968754436764739}, {-1.0095556649258486`, -0.9415023794536542}, \
{-0.9808969811759672, -0.9859626679282455}, {-0.9506617175917466, \
-1.029704920562109}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-0.9471152664166856, -1.0345442624833636`}, \
{-0.9177064915087758, -1.0743833029696608`}, {-0.8907976198704327, \
-1.107901735626248}, {-0.862313716921894, -1.1398800344134195`}, \
{-0.8322547826631593, -1.1703181993311753`}, {-0.8006208170942286, \
-1.1992162303795157`}, {-0.785798991414842, -1.2111820268030966`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7811304702305265, -1.2149509669660068`}, \
{-0.7673881417217422, -1.2260452753784161`}, {-0.73253307805234, \
-1.2502764821478523`}, {-0.6960556260860226, -1.271909850687825}, \
{-0.6579557858227892, -1.2909453809983336`}, {-0.6184281608254989, \
-1.3073888411886805`}, {-0.5776673546570104, -1.3212459993681684`}, \
{-0.5689515918343866, -1.3235852416120417`}}]}, 
      {Arrowheads[{{0.0060455746028531725`, 1.}}], 
       ArrowBox[{{-0.5631566790834637, -1.325140550651812}, \
{-0.5356733673173236, -1.3325168555367972`}, {-0.49244619880643836`, \
-1.3412014096945668`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5344729750894809, -1.5}, {
        0.535370999646272, -1.4988869297014433`}, {
        0.5682961663935204, -1.4632596737770205`}, {
        0.6011056311071309, -1.4338595131237035`}, {
        0.646344187526227, -1.3994626197894287`}, {
        0.6807581031949483, -1.3805133570336638`}, {
        0.7155915657657345, -1.3631392232944457`}, {
        0.7255273334382875, -1.3585100306234854`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.7309660042315214, -1.355976089029284}, {
        0.7509849827926437, -1.3466490081343414`}, {
        0.7868915517576569, -1.3312731150324961`}, {
        0.8222269935388558, -1.315879276706967}, {
        0.858032355615858, -1.3010726836805724`}, {
        0.8943076379886634, -1.2868533359533134`}, {
        0.9310528406572722, -1.2732212335251891`}, {
        0.9530850390006463, -1.2653070184182134`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9587317813984004, -1.2632786446130664`}, {
        0.9680513544119494, -1.2599309484646892`}, {
        1.0050865700429603`, -1.2467370528403028`}, {
        1.0421584875503047`, -1.2336395466520298`}, {
        1.0792671069339828`, -1.2206384298998705`}, {
        1.1158815748198632`, -1.2076256599015507`}, {
        1.1514710378338142`, -1.1944931939747965`}, {
        1.1844793119252366`, -1.1818376797751353`}}]}, 
      {Arrowheads[{{0.009104628674621336, 1.}}], 
       ArrowBox[{{1.1900607325930246`, -1.1796362089533796`}, {
        1.2195749492459296`, -1.1678691743359848`}, {
        1.256254271021559, -1.1524683799671966`}, {
        1.2905669483895696`, -1.1368483580857798`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.4264736238456911, -0.4957078902889265}, \
{-0.3879910594759242, -0.5098088301498038}, {-0.34860871336366606`, \
-0.5228253504204573}, {-0.3087579754648996, -0.5346798991363215}, \
{-0.2684388457796248, -0.5453724762973965}, {-0.22765132430784168`, \
-0.5549030819036823}, {-0.19590297426321734`, -0.5611752055150316}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1900167415815961, -0.5623380747328777}, \
{-0.1717450945079048, -0.5659477750438564}, {-0.11656938525018387`, \
-0.5745285945967015}, {-0.062124196534678926`, -0.5806455405622177}, \
{-0.008409528361389692, -0.5842986129404052}, {
        0.04218278879510662, -0.5854010200229597}, {
        0.04848581207279511, -0.5852264316800909}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.05448351166887361, -0.5850603005415291}, {
        0.09157436456780862, -0.5840329157044567}, {
        0.14279193279836977`, -0.579783618797445}, {
        0.19271391158694667`, -0.5726012507612276}, {
        0.24147837277857123`, -0.5624201009532518}, {
        0.2892233882182756, -0.549174458730965}, {
        0.29083087909327543`, -0.5486178215469943}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.29650057958929715`, -0.546654534434672}, {
        0.3331406611253248, -0.5339669154105988}, {
        0.37663403086960034`, -0.5159565524885097}, {
        0.4197034974511021, -0.49514336996469743`}, {
        0.46234906086983013`, -0.47152736783916227`}, {
        0.5049292186958774, -0.4451773052495899}, {
        0.5111353953120984, -0.44097714608573724`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.5161044033509545, -0.43761426649975993`}, {
        0.5478024684993371, -0.41616194133366624`}, {
        0.5909688102802089, -0.3844812760913912}, {
        0.634428244038493, -0.3501353095227648}, {
        0.6604734439964877, -0.3285450631139188}, {
        0.686788906271294, -0.30617380361534124`}, {
        0.7052031510331602, -0.29013769322965777`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7097278965021437, -0.2861973025839332}, {
        0.7133746308629123, -0.28302153102703215`}, {
        0.7402306177713421, -0.25908824534899144`}, {
        0.7673638434222855, -0.2344548524563257}, {
        0.7947812842414435, -0.2092022582241414}, {
        0.8224829402288163, -0.1833304626524385}, {
        0.8504688113844039, -0.15683946574121702`}, {
        0.8786168628277982, -0.12980373627251465`}, {
        0.8856315820244437, -0.12295878553466401`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8899258690879873, -0.11876842771988477`}, {
        0.9068050596785907, -0.10229774302836905`}, {
        0.935033401936782, -0.0743214860087803}, {
        0.9633018896023716, -0.045874965213748335`}, {
        0.9874777758886307, -0.021363135530361108`}, {1.0114540325397432`, 
        0.0034493461348475926`}, {1.0484194676342093`, 0.04472332147855078}, {
        1.056272118223302, 0.05409916143745045}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.0601246351603169`, 0.05869895635135827}, {
        1.08350062938677, 0.08660922413429194}, {1.1072940336747055`, 
        0.11601480460088238`}, {1.1296665128746475`, 0.14571771524152105`}, {
        1.1506180669865969`, 0.17571795605620802`}, {1.170148696010553, 
        0.2060155270449433}, {1.1880559923698613`, 0.23663551222149928`}, {
        1.1974902416768332`, 0.2548025948380789}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.200255442887694, 0.2601274105403783}, {1.204137548487867, 
        0.2676029955996484}, {1.2183933643645697`, 0.29891797717939067`}, {
        1.23082343999997, 0.33058045696072613`}, {1.241495586896465, 
        0.36268245648891256`}, {1.2504776165564513`, 0.3953159973092079}, {
        1.2577695289799296`, 0.4284810794216121}, {1.2633713241668991`, 
        0.46217770282612514`}, {1.2663874815577334`, 0.4893723901531191}}]}, 
      {Arrowheads[{{0.006712480287059476, 1.}}], 
       ArrowBox[{{1.267048884848494, 0.4953358242046511}, {1.269522981350511, 
        0.5176431086300645}, {1.2727979618338385`, 0.5756564398191182}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7063808538244103, 
        0.8355245592596028}, {-0.7536942642553222, 
        0.8021104549898415}, {-0.8030180760320691, 
        0.760736086232847}, {-0.8283737246941394, 
        0.7365669555014396}, {-0.8541597844154787, 
        0.7098115420439861}, {-0.8800518215562037, 
        0.6805828013659275}, {-0.8841275550333307, 0.6755679651693782}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8879117701623255, 
        0.670911816991164}, {-0.9057254024764302, 
        0.6489936889727049}, {-0.9274930337007218, 
        0.6197668729502359}, {-0.9487545429320658, 
        0.5887149301292958}, {-0.969509930170462, 
        0.5558378605098843}, {-0.9897591954159105, 
        0.5211356640920016}, {-1.009168720190749, 
        0.48487861358269835`}, {-1.0168134824254296`, 
        0.46914082898156645`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0194350991604306`, 
        0.4637438737571123}, {-1.0274048860173157`, 
        0.44733698168902497`}, {-1.04446769289561, 
        0.40851076841098166`}, {-1.0603571408256325`, 
        0.36839997374856814`}, {-1.0748490720990997`, 
        0.3274580965597532}, {-1.0877193290077285`, 
        0.28613863570250553`}, {-1.0989679115515185`, 
        0.24444159117682504`}, {-1.1003753536058853`, 
        0.2382903326375866}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1017136036995403`, 
        0.2324414791869663}, {-1.1085948197304702`, 
        0.20236696298271167`}, {-1.1192804172506752`, 
        0.1442899814523662}, {-1.1269218284773128`, 
        0.08710409206512439}, {-1.1315190534103836`, 
        0.030809294820986283`}, {-1.1325255458274697`, \
-0.005096707543836638}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1326936676715689`, -0.01109435166845229}, \
{-1.133072092049887, -0.02459441028004811}, {-1.133088332396487, \
-0.05343672212287785}, {-1.1323619499365305`, -0.0819154006722344}, \
{-1.1279877987947131`, -0.1291775209546952}, {-1.1218147085349446`, \
-0.17542497649720545`}, {-1.1146827100387446`, -0.22188753250697135`}, \
{-1.109334137326999, -0.24940851470580572`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.1081894822162004`, -0.2552983164577599}, \
{-1.1057723063711937`, -0.267735850167602}, {-1.0950834975322923`, \
-0.31296992947909746`}, {-1.0826162835220396`, -0.3575897704414576}, \
{-1.0682414829293163`, -0.4020131275906138}, {-1.0518299143430017`, \
-0.4466577554624973}, {-1.0365176284493445`, -0.4838968562985486}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0342358643587106`, -0.48944605017105786`}, \
{-1.0333815777630961`, -0.491523654057108}, {-1.0128964731895993`, \
-0.536610823374446}, {-0.9898589337720212, -0.5823368729459207}, \
{-0.9637532926598712, -0.6291194123029419}, {-0.9345795498531493, \
-0.6769584414455093}, {-0.9194832453579722, -0.6998523438759017}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9161802759453657, -0.7048613750256736}, \
{-0.9023377053518555, -0.725853960373623}, {-0.8662099859015995, \
-0.7757057508888765}, {-0.8253786182479905, -0.8264135947928629}, \
{-0.8031990663449287, -0.852088536765631}, {-0.7798436023910287, \
-0.8779774920855824}, {-0.7665655536211159, -0.8921061936690066}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7624565750809563, -0.8964784122541768}, \
{-0.7553122263862904, -0.9040804607527171}, {-0.7296049383307139, \
-0.9303974427670348}, {-0.690813990515847, -0.9675952595548543}, \
{-0.6493526416915236, -1.0039104398120007`}, {-0.6052208918577435, \
-1.0393429835384738`}, {-0.5832393929594015, -1.0555699887781709`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5784122176895762, -1.0591334672633574`}, \
{-0.5584187410145066, -1.073892890734274}, {-0.5093969407907208, \
-1.1067093768386196`}, {-0.4586062428152937, -1.1369416572907292`}, \
{-0.40604664708822524`, -1.164589732090603}, {-0.37184896119335986`, \
-1.1803664685605146`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.36640079210536797`, -1.1828799230734608`}, \
{-0.35171815360951597`, -1.1896536012382404`}, {-0.30674130585499726`, \
-1.2078610331674957`}, {-0.26149319597693504`, -1.2238708269100715`}, \
{-0.21597382397532938`, -1.2376829824659683`}, {-0.17018318985018055`, \
-1.2492974998351862`}, {-0.1383729252165265, -1.2559644096069844`}}]}, 
      {Arrowheads[{{0.0006876429688738445, 1.}}], 
       ArrowBox[{{-0.132267487316828, -1.258838981315296}, \
{-0.1246572923551649, -1.258838981315296}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -0.020153319442996274`}, {-1.4966374575492656`, \
-0.022357256074857983`}, {-1.4632806647084757`, -0.04694929109326862}, \
{-1.4357056703958957`, -0.0707938479182172}, {-1.4030865915635076`, \
-0.10315952363622644`}, {-1.3758871835258188`, -0.13869286683354454`}, \
{-1.3521083179179583`, -0.17323958804960937`}, {-1.3380676217064615`, \
-0.1944581865609232}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.334756588136587, -0.1994618908586575}, \
{-1.32951994080983, -0.2073756235894337}, {-1.3093125407011663`, \
-0.24069028777677706`}, {-1.2909149360847767`, -0.27331946143062785`}, \
{-1.2737559454534708`, -0.30539902536997454`}, {-1.257544030828237, \
-0.33703995298905565`}, {-1.241987654230064, -0.36835321768210977`}, \
{-1.2268539948759085`, -0.3994596647671185}, {-1.221386240618148, \
-0.4108094211518136}}]}, 
      {Arrowheads[{{0.015770934901140902`, 1.}}], 
       ArrowBox[{{-1.2187821651400248`, -0.4162148620130421}, \
{-1.2118844953524759`, -0.43053278268397155`}, {-1.1970791556597675`, \
-0.46157257143266905`}, {-1.182437975797782, -0.4925790310132108}, \
{-1.1677271684079888`, -0.523738024539488}, {-1.1527129461318568`, \
-0.555235415125392}, {-1.1373953089693858`, -0.5870712027709226}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.44875824519260976`, 
        0.7626629198444593}, {-0.48180905526533196`, 
        0.7309281766801876}, {-0.5125309011423449, 
        0.6886363913170149}, {-0.5368291218660507, 
        0.640841495957913}, {-0.5569160749384542, 
        0.5834668452574584}, {-0.5635427373913258, 0.5567755486349601}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5649662895181249, 
        0.5509475348351657}, {-0.5712497025623454, 
        0.5169216518963432}, {-0.5757907309298331, 
        0.480679967104944}, {-0.5783423655819634, 
        0.4429830742520161}, {-0.5786527292292866, 
        0.4042059853813568}, {-0.5765281243624814, 
        0.36473821330914596`}, {-0.5718766680874517, 
        0.32499464720323346`}, {-0.5695705525287914, 0.31243204850258344`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5684872344094748, 
        0.3065306569842752}, {-0.5646064775101014, 
        0.28539017623146873`}, {-0.5543816300440311, 
        0.24646817830723522`}, {-0.541061434856684, 
        0.20866924034748924`}, {-0.5248468566847282, 
        0.17225406502544224`}, {-0.5059388602648318, 
        0.13748335501430578`}, {-0.4880282129161192, 
        0.10978737983665429`}, {-0.47247903522182544`, 
        0.08924648447893885}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4688576808004878, 
        0.08446257476458821}, {-0.4682740224223064, 
        0.08369154584546555}, {-0.4466762887833939, 
        0.059195853040739765`}, {-0.423235011999381, 
        0.03630030142247649}, {-0.3982557046625148, 
        0.015104491069555224`}, {-0.372043879365042, \
-0.0042919779391446256`}, {-0.34459953610696226`, -0.021889105603623407`}, \
{-0.3159226748882756, -0.037686891923880944`}, {-0.2766918991389217, \
-0.05504239167547449}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2712048643851568, -0.0574698285152245}, \
{-0.25656091103286305`, -0.06394824052501677}, {-0.1956481002625858, \
-0.08313982373583655}, {-0.15339969993027452`, -0.09246592819429678}, \
{-0.11196919373429873`, -0.09879109364785063}, {-0.07135658167465893, \
-0.10211532009649806`}, {-0.03715976895468929, -0.10239313083986447`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.03116069132997606, -0.10241426832054067`}, {
        0.007021816831564699, -0.1000977270897481}, {
        0.04400131687005089, -0.09542944985569946}, {
        0.0793766363641039, -0.08843377583809309}, {
        0.11314777531372334`, -0.07911070503692913}, {
        0.14531443754268158`, -0.06782291889128711}, {
        0.17587632687475105`, -0.05493309884024659}, {
        0.19882970165831343`, -0.042465460270831826`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.20410212526072574`, -0.03960162554153516}, {
        0.2321857868482226, -0.02434735702197037}, {
        0.2634574954621296, -0.0030894559076768534`}, {0.2926645323693797, 
        0.019571280318039244`}, {0.3198068975699731, 0.043634851655178025`}, {
        0.34488459106390995`, 0.06910125810373963}, {0.37259462122281095`, 
        0.101281134480979}, {0.38387475649086034`, 0.11629604135798337`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3874786311199401, 0.1210931329412112}, {0.397599223081717,
         0.13456458006797217`}, {0.41989839664062817`, 
        0.16895159486471922`}, {0.43949214189954433`, 0.20444217887122018`}, {
        0.46459336267340057`, 0.2622837526027909}, {0.4821085526700691, 
        0.32256731734121064`}, {0.48431802156250264`, 
        0.3382082561028299}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.48515726090716615`, 0.34414927262547723`}, {
        0.49103160574422683`, 0.38573404812322126`}, {0.49190128867946004`, 
        0.4185925472534005}, {0.49007283440468025`, 0.4524840782075509}, {
        0.4862609255960793, 0.48148005944635575`}, {0.48014736271476544`, 
        0.5114575084037987}, {0.47173214576073874`, 0.5424164250798799}, {
        0.46101527473399917`, 0.5743568094745993}, {0.45894052461446067`, 
        0.5795356565042331}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.45670920359108574`, 0.5851053249405627}, {
        0.4477321183517398, 0.6075133011053727}, {0.43161804533115355`, 
        0.6421205394896154}, {0.41267305567224055`, 0.6781785246273279}, {
        0.3908971493750007, 0.7156872565185096}, {0.3650727804722286, 
        0.7564757015774699}, {0.3395234739137319, 0.7938905143386392}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.33613990930908966`, 0.7988454604096084}, {
        0.3359793642173871, 0.7990805652071504}, {0.30369331018983425`, 
        0.8433280514558326}, {0.26829102796892795`, 0.8890443643717978}, {
        0.22999566081173, 0.9355852938123792}, {0.1890303519753022, 
        0.9823066296349102}, {0.18587159196463468`, 0.9858022665102714}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.18184888522103598`, 0.9902539887000543}, {
        0.17137738337140931`, 1.0018422600097927`}, {0.1533198896210541, 
        1.021185551035423}, {0.10718207513838668`, 1.0642016652757942`}, {
        0.05987234022536127, 1.1029877675338688`}, {0.012955768134153292`, 
        1.13838617197609}, {0.0003366208490598252, 1.1462905646969967`}}]}, 
      {Arrowheads[{{0.019710794300019988`, 1.}}], 
       ArrowBox[{{-0.004748210694997435, 
        1.1494756060104745`}, {-0.034581004510847724`, 
        1.1681622979837805`}, {-0.08240043731109997, 
        1.1920631312765324`}, {-0.13016498986806171`, 
        1.209835657573937}, {-0.17774116192261408`, 
        1.2220229691194446`}, {-0.22499545321563813`, 
        1.229168158156505}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 1.0096393731201305`}, {1.4845009095226973`, 
        1.0233620477105159`}, {1.449365735000493, 1.0588947525798424`}, {
        1.4202349087116195`, 1.0938871464388509`}, {1.384127489708439, 
        1.1437216193125088`}, {1.3560682330046843`, 1.1915746778627776`}, {
        1.3527143889160047`, 1.1974718489113243`}}]}, 
      {Arrowheads[{{0.01659560672596972, 1.}}], 
       ArrowBox[{{1.3497482075011025`, 1.2026873803141527`}, {
        1.3309726048823518`, 1.235701121339279}, {1.3069045670577535`, 
        1.2773671462980065`}, {1.2848917098286239`, 1.314112334221186}, {
        1.264509386004598, 1.3457490902670972`}, {1.245332948395312, 
        1.372089819594021}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6493768941287084, 0.41400890409198365`}, {
        0.6591593867569084, 0.46019236771227423`}, {0.6659871777141885, 
        0.5090938645527692}, {0.6693141011972386, 0.5664448389451757}, {
        0.6675884789907284, 0.6285312374755135}, {0.6654100122932207, 
        0.6522898011805877}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6648621593714151, 0.6582647369271936}, {0.664559994702382,
         0.6615601733673558}, {0.6597264368886326, 0.696192870443579}, {
        0.6530878055494808, 0.7324293287041834}, {0.6446441006849262, 
        0.7702695481491686}, {0.6327633969895321, 0.8145096180988469}, {
        0.6180106577101873, 0.8608625771034852}, {0.6070169236511198, 
        0.890552932351447}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6049334864493031, 0.8961795911669507}, {
        0.6001849727597272, 0.9090037196737737}, {0.5790854320509872, 
        0.9586083403204017}, {0.5546120194451993, 1.0088076012647487`}, {
        0.5266647188035959, 1.0587326647281938`}, {0.5088965302971649, 
        1.0885343980280249`}, {0.49541214406840384`, 
        1.1091817579361187`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.49213134310638, 1.1142053368443856`}, {
        0.48989348048027326`, 1.117631963335367}, {0.4595354516376262, 
        1.1539622291391456`}, {0.427242782780847, 1.1868265556531228`}, {
        0.3941707615976445, 1.2175583537336976`}, {0.35954003576159577`, 
        1.2440250949474676`}, {0.3236769714452164, 1.266164594411341}, {
        0.31322248415188075`, 1.271211447086947}}]}, 
      {Arrowheads[{{0.008496060503542754, 1.}}], 
       ArrowBox[{{0.30781914576396213`, 1.273819882300949}, {
        0.2869079348210223, 1.2839146672422264`}, {0.2495525820078091, 
        1.2976312125029794`}, {0.21193056912437253`, 1.3076701292564559`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3763301967882926`, -1.5}, {
        1.3868936435133958`, -1.479301431659909}, {
        1.4049096033418647`, -1.4450837049199963`}, {
        1.4207385461295083`, -1.4151252728760728`}, {
        1.431780391440064, -1.3929972665805554`}, {
        1.4415560627225226`, -1.3724517909460032`}, {
        1.45872129054272, -1.3339006009082115`}, {
        1.4715703236036886`, -1.2997163871152453`}, {
        1.4767915273616712`, -1.282483934723454}}]}, 
      {Arrowheads[{{0.006882116107992417, 1.}}], 
       ArrowBox[{{1.4785313423736464`, -1.2767417187989083`}, {
        1.480962082350897, -1.2687191223103584`}, {
        1.48953514415676, -1.2307717703985097`}, {
        1.4943256013303756`, -1.1957994133824157`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 0.8004675190663401}, {1.4872274707718425`, 
        0.8115453102031743}, {1.4522319368770327`, 0.8467258694769534}, {
        1.4238628097928117`, 0.8820980216397839}, {1.3951312062874524`, 
        0.9328779765521028}, {1.3701324650524633`, 0.9840687772556409}, {
        1.3647218258541844`, 0.9956844717076626}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.3621883657116112`, 1.001123366789018}, {1.34638097396483, 
        1.03505906752331}, {1.3251239831719086`, 1.0856483369192413`}, {
        1.30569531180163, 1.1350606706663955`}, {1.2874287789819256`, 
        1.182520153987734}, {1.2715552142961444`, 1.2232796555205}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.14124974124168843`, 0.4984254268667703}, {
        0.10081701313255512`, 0.5319656722808478}, {0.05642037773507419, 
        0.5593862864203641}, {0.011319770118619229`, 
        0.5787683079884278}, {-0.010600846288473654`, 
        0.5848691761550393}, {-0.03152943457355817, 
        0.5881602695108276}, {-0.06077188389469293, 
        0.587072572462926}, {-0.07293889016940477, 0.5825122911800693}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.07855722132096057, 
        0.5804065003377828}, {-0.08538352180928847, 
        0.5778479539176352}, {-0.11221614510445532`, 
        0.5428700344799412}, {-0.11346539773935244`, 
        0.5393714875519076}, {-0.11458747069735058`, 
        0.5357420358152981}, {-0.11624657515431534`, 
        0.5174131021403587}, {-0.11522841227143486`, 
        0.49727779654214943`}, {-0.10785456894870514`, 
        0.45456528262373924`}, {-0.09005352004810824, 
        0.4090992400422999}, {-0.06354792405446026, 
        0.36626036082842095`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.05980439982528157, 
        0.3615845624958017}, {-0.040126115357160076`, 
        0.3383795051305284}, {-0.014892891221609608`, 0.31539491820253096`}, {
        0.038953501948185254`, 0.28335658963731025`}, {0.09143732116364209, 
        0.27121858929072545`}, {0.14746621829010892`, 0.2817213757985828}, {
        0.14890966154702567`, 0.28297450309493566`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.15344046502754546`, 0.28690792651746594`}, {
        0.1846777957657932, 0.31402665919069417`}, {0.19962703175894195`, 
        0.3597730358809179}, {0.1909519434086748, 0.4116055683226428}, {
        0.1615542727848969, 0.46217066577141325`}, {0.13363458651142868`, 
        0.4900602498739562}}]}, 
      {Arrowheads[{{0.001546583614558306, 1.}}], 
       ArrowBox[{{0.12697802275455028`, 0.5050076833052989}, {
        0.11867101980988783`, 0.5050076833052989}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.32313378495326023`, -1.5}, {
        0.34147907259288224`, -1.4797058172206803`}, {
        0.37155732503504835`, -1.4520157136735499`}, {
        0.41287501132604876`, -1.419642040119646}, {
        0.44238135597150463`, -1.4027316742246543`}, {
        0.47187143449745883`, -1.3873655933520233`}, {
        0.5015274605826748, -1.3729605192566998`}, {
        0.518920044270944, -1.3652173766007243`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5244013796078213, -1.3627770973288582`}, {
        0.5312886963342317, -1.3597108780203693`}, {
        0.5617111258576675, -1.3459859545787256`}, {
        0.5924254370697946, -1.3329944983204174`}, {
        0.6234316299706133, -1.3207365092454455`}, {
        0.6547297045601235, -1.309211987353809}, {
        0.6864255218506267, -1.2981662356066932`}, {
        0.7186249428544244, -1.287344556965282}, {
        0.7485990518870244, -1.277631272443141}}]}, 
      {Arrowheads[{{0.002638154299599981, 1.}}], 
       ArrowBox[{{0.7560015568389673, -1.2668996966567212`}, {
        0.7828499329683618, -1.2668996966567212`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, 0.17535835801672126`}, {-1.4797009911027752`, 
        0.15922523643254244`}, {-1.4529290160112522`, 
        0.13386834054777888`}, {-1.4222341492366017`, 
        0.10002403719330386`}, {-1.3925219002458749`, 
        0.055097966015299905`}, {-1.3673543714530438`, 
        0.01166380810862478}, {-1.3541059156683912`, \
-0.012371328645622827`}}]}, 
      {Arrowheads[{{0.010016124538564986`, 1.}}], 
       ArrowBox[{{-1.3512095149181873`, -0.01762593259779828}, \
{-1.3412099708297678`, -0.035766945675239845`}, {-1.3187236999759278`, \
-0.08150591186046591}, {-1.2988413096339433`, -0.125755928065711}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.783865066004282, 0.4481566502706902}, {0.8051998605582156,
         0.5084599417695997}, {0.8185318872943566, 0.5556158401919321}, {
        0.8299365201070689, 0.605994808176195}, {0.8390088134478466, 
        0.6601196473510882}, {0.8412194153537547, 0.6804960702979513}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8418665475545746, 0.6864610698716866}, {
        0.8453438217681841, 0.7185131593453115}, {0.8473592202321119, 
        0.7493975890917945}, {0.8484390498137777, 0.7815230299273548}, {
        0.8485833105131816, 0.8148894818519925}, {0.8477920023303235, 
        0.8494969448657079}, {0.844479626658415, 0.9045468768188001}, {
        0.8422101823073426, 0.9259603229236746}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8415778304881667, 0.9319269074723745}, {
        0.8383922754469847, 0.9619843579475217}, {0.8293062651791037, 
        1.020760465328738}, {0.8169979123378429, 1.0798262760393147`}, {
        0.8013368888945209, 1.137270072084386}, {0.791155562969827, 
        1.1659409503260143`}}]}, 
      {Arrowheads[{{0.017984123634941195`, 1.}}], 
       ArrowBox[{{0.7891477397818654, 1.1715950325721338`}, {
        0.7821928668204564, 1.1911801354690872`}, {0.7683497718163181, 
        1.2257410744653372`}, {0.7529500261915336, 1.2574241850394283`}, {
        0.7402717849986172, 1.2757361751254739`}, {0.7268893802409411, 
        1.2923167454056959`}, {0.6987653601477333, 1.3218828766392046`}, {
        0.668030039291692, 1.3445381523655562`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.058219090505088916`, -0.4112699757291027}, \
{-0.02584519719356819, -0.40975709606779426`}, {
        0.03733257999963281, -0.4032428636526958}, {
        0.08443138702900033, -0.395089398565539}, {
        0.12982921259895047`, -0.3841997408817527}, {
        0.17352605670948326`, -0.3705738906013369}, {
        0.1770864404972297, -0.36918672652096535`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.1826771040175301, -0.36700854347016765`}, {
        0.21552191936059872`, -0.35421184772429154`}, {
        0.25601045796278077`, -0.33535579499658713`}, {
        0.2951853299265135, -0.31424791516419404`}, {
        0.33304653525179667`, -0.29088820822711237`}, {
        0.3695940739386303, -0.2652766741853422}, {
        0.3905162944898067, -0.24906017447291776`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.395258589579711, -0.24538449259328377`}, {
        0.40508727561233626`, -0.23776642529341413`}, {
        0.4397854698982364, -0.20871057380585878`}, {
        0.4736886567963307, -0.17810911972267635`}, {
        0.506796836306619, -0.14596206304386677`}, {
        0.5463560039499014, -0.10528911951029586`}, {
        0.5693746646104111, -0.08060627126638187}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.5734668004720078, -0.07621828492977661}, {
        0.5855411373867534, -0.0632710057588452}, {
        0.6243522366171752, -0.01990772178951462}, {0.6627893016411671, 
        0.024800732397695993`}, {0.6983277765087393, 0.06751726835209107}, {
        0.7296248861222396, 0.1059635127766293}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.7334127805764226, 0.1106166682225574}, {
        0.7339138052131896, 0.11123214089354018`}, {0.7545735001268609, 
        0.1369563419960292}, {0.7752915865639767, 0.16306460013368518`}, {
        0.7960287506096644, 0.18962043603373532`}, {0.816745678349051, 
        0.21668737042340697`}, {0.8375206381992445, 0.24423676120900334`}, {
        0.858337832711768, 0.27231369655356685`}, {0.879016849173372, 
        0.3010922925694339}, {0.8791356220729373, 0.30126528187204127`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8825317412432522, 0.30621163149383507`}, {
        0.8993772748708069, 0.3307466653689406}, {0.9184731852549827, 
        0.3602225579545436}, {0.9370515607021468, 0.39070380287684797`}, {
        0.9551124012122991, 0.4221904001358537}, {0.9726557067854396, 
        0.4546823497315607}, {0.989415802737045, 0.4884542330361882}, {
        1.0009950569506523`, 0.5144899937775249}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0034332600532831`, 0.5199722529496473}, {
        1.0051270143825917`, 0.5237806314219551}, {1.0197893417220798`, 
        0.5606615448888616}, {1.0334027847555094`, 0.5990969734369076}, {
        1.0457032612191348`, 0.6394310074484029}, {1.0564266888492102`, 
        0.6820077373056566}, {1.0655730676457358`, 0.726827163008669}, {
        1.0693128404011525`, 0.7500791074794605}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.070265617547431, 0.7560029757856882}, {
        1.0731423976087113`, 0.7738892845574402}, {1.0788359394737266`, 
        0.8217779417673563}, {1.0827656067883458`, 0.8719950167268653}, {
        1.084876127014402, 0.9242833171474393}, {1.0851122276137295`, 
        0.9783856507405505}, {1.084607454484232, 0.9952316651847259}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.084427751440052, 1.0012289734822801`}, {
        1.0834601543723834`, 1.0335210136594342`}, {1.0799061530764205`, 
        1.0889084020573256`}, {1.0762451381893838`, 1.134022042986849}, {
        1.0713293371387702`, 1.1781031044024188`}, {1.0626687995710422`, 
        1.2238226554923544`}, {1.0588701607607007`, 1.2394097810629103`}}]}, 
      {Arrowheads[{{0.012395795032865043`, 1.}}], 
       ArrowBox[{{1.0574495176637047`, 1.2452391698122525`}, {
        1.0526647571413692`, 1.2648726929794571`}, {1.0420499436699906`, 
        1.3030083735616702`}, {1.0302135881152013`, 1.335315340334104}, {
        1.0033965878880047`, 1.3828173837920847`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.2811740296422659, 
        0.9772574802070793}, {-0.3186298913366256, 
        0.9935540335773917}, {-0.3575338656478726, 
        1.0074094145311463`}, {-0.39814443410815975`, 
        1.0183406717485357`}, {-0.4340451050964298, 
        1.0249960795416113`}, {-0.47154605396613897`, 
        1.0291143483084213`}, {-0.5109116795832866, 
        1.0305011465499407`}, {-0.513080237654703, 1.0304207165437917`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5190761150892068, 
        1.0301983344617613`}, {-0.552406380813872, 
        1.0289621427671445`}, {-0.604032020259, 
        1.0230808895974168`}, {-0.6595993097695235, 
        1.0124419087848915`}, {-0.6889929658849046, 
        1.005163166961665}, {-0.7196358196878264, 
        0.9963447861259085}, {-0.7515278711782895, 
        0.9859867662776233}, {-0.7537968438421276, 0.9851722084867003}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7594439685073932, 
        0.9831448991824869}, {-0.7846691203562932, 
        0.9740891074168084}, {-0.8277379715194735, 
        0.9567252044230441}, {-0.872712886533191, 
        0.9362335446254137}, {-0.9191706758122256, 
        0.9122386876270433}, {-0.9666881497713568, 
        0.8843651930310586}, {-0.9749414159593269, 0.8787894415036098}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.9799131676407865, 
        0.8754306195050657}, {-1.014282320479431, 
        0.852211465769722}, {-1.0609702000052945`, 
        0.8153759107752951}, {-1.0864476502366438`, 
        0.7937878869952977}, {-1.1111302124084426`, 
        0.7706553659244927}, {-1.139620737325321, 
        0.735631828861714}, {-1.1546430074773029`, 0.7135791135856178}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1580209294345702`, 
        0.7086203190495827}, {-1.1653684891968887`, 
        0.6978340902191061}, {-1.1895039528430753`, 
        0.6587278592134309}, {-1.2104148400384995`, 
        0.6170046434816212}, {-1.2280204255271276`, 
        0.5728821110799347}, {-1.2422399840529261`, 
        0.5265779300646297}, {-1.2507871919595936`, 0.4891609768723738}}]}, 
      {Arrowheads[{{0.004603781193380076, 1.}}], 
       ArrowBox[{{-1.2521233624858048`, 
        0.4833116479942131}, {-1.2532358631471754`, 
        0.47844147452617547`}, {-1.2611704103411563`, 0.4288221185550415}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 0.6211177934763256}, {1.4678333849204643`, 
        0.649881126678817}, {1.4411859883457863`, 0.6795547608522278}, {
        1.4147972659599397`, 0.7222453111076074}, {1.3922129980963749`, 
        0.7658126608718185}, {1.3709406979517467`, 0.8098596996018278}, {
        1.3675757705095397`, 0.8179806972807927}}]}, 
      {Arrowheads[{{0.015141452680794878`, 1.}}], 
       ArrowBox[{{1.365279029038642, 0.8235237089726313}, {
        1.3522923332449925`, 0.8548661162634335}, {1.3355619458861894`, 
        0.900790508779227}, {1.3200435777854163`, 0.9475914750718004}, {
        1.3054065423482548`, 0.9949693864312119}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.1257485529832957, -1.5}, {
        0.13845350371941764`, -1.4871605290437953`}, {
        0.16992878623027252`, -1.460769963743737}, {
        0.20901993475897707`, -1.4328856027289314`}, {
        0.25982997750361586`, -1.4065189917788705`}, {
        0.3099083737259984, -1.383907501871512}, {
        0.3289205925339207, -1.3758364312431268`}}]}, 
      {Arrowheads[{{0.008160576066662213, 1.}}], 
       ArrowBox[{{0.33444353153020384`, -1.3734918321636818`}, {
        0.36796491873038467`, -1.3592613266983562`}, {
        0.4256528262560104, -1.337916845800049}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, 0.3574810586000434}, {-1.4937127230661964`, 
        0.35236532334821435`}, {-1.4678834600477557`, 
        0.32684900917949194`}, {-1.4364936902389867`, 
        0.2900218735305615}, {-1.4108494575662396`, 
        0.24682145158680055`}, {-1.3890904487052576`, 
        0.20450926989741786`}, {-1.368688482997969, 
        0.1626836644474044}, {-1.3675587010767185`, 
        0.16007428647946412`}}]}, 
      {Arrowheads[{{0.006544454941708304, 1.}}], 
       ArrowBox[{{-1.3651747416437847`, 
        0.1545682227836714}, {-1.3510006035980688`, 
        0.1218312114761296}, {-1.3353316061475138`, 0.0819384150551629}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.5, 0.6349471744177637}, {-1.4988591359966155`, 
        0.6340128694189087}, {-1.476358336546276, 
        0.6111818317894921}, {-1.446665733754519, 
        0.5744238465036111}, {-1.4373521701012135`, 
        0.5580118077707091}, {-1.4287680870021218`, 
        0.5415361637974263}, {-1.4128398459783487`, 
        0.5084747071294488}, {-1.3990674137212828`, 
        0.47520929240913573`}, {-1.3869023001605127`, 
        0.44178196726816943`}, {-1.3827491837261618`, 
        0.4289418558257751}}]}, 
      {Arrowheads[{{0.0026132307026085623`, 1.}}], 
       ArrowBox[{{-1.3785805514384877`, 
        0.40057549884017374`}, {-1.3735741244668946`, 
        0.40057549884017374`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.2931650392349688, 
        0.709745169221083}, {-0.31771098487825533`, 
        0.6861195953922162}, {-0.34652919300075224`, 
        0.6305662914258824}, {-0.3549783971167772, 
        0.5938549044047154}, {-0.3584138830796887, 
        0.5513674559261958}, {-0.3561269910515872, 
        0.5041631886697051}, {-0.3534592073260186, 0.4885988975844848}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.352445564867198, 
        0.48268513998329116`}, {-0.34740906119457304`, 
        0.4533013453146255}, {-0.33198483976891846`, 
        0.4006817009952883}, {-0.3095790730348953, 
        0.3482040308460246}, {-0.2806872664489397, 
        0.2978343384058448}, {-0.25648058128084517`, 0.26570731728487884`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2528699538857285, 
        0.260915306244237}, {-0.2458049254674875, 
        0.25153862721375897`}, {-0.20615094223048075`, 
        0.21051331004188517`}, {-0.16294420887786215`, 
        0.17595479966234173`}, {-0.10822544981419625`, 
        0.14322694439163292`}, {-0.059928136303202845`, 
        0.12364563215715622`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.054367753618986936`, 
        0.12139127096048168`}, {-0.05278232030858539, 0.12074848438663122`}, {
        0.001672417602705447, 0.10783202004269693`}, {0.05342600188341215, 
        0.10379015175519003`}, {0.11500449043044317`, 0.10971585780783483`}, {
        0.1692774149552019, 0.12646945035886994`}, {0.1795927536093674, 
        0.13209481739687645`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.18486038062264434`, 0.13496746524320136`}, {
        0.2159192695032094, 0.15190512047716537`}, {0.2546045481199866, 
        0.18387705923159106`}, {0.2905281968318204, 0.2291379599116519}, {
        0.3142748766559375, 0.2796058239574759}, {0.32228494487191983`, 
        0.3196888934004693}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.32346071780394464`, 0.32557256215493857`}, {
        0.3251429281817724, 0.3339904873927855}, {0.32243069199875957`, 
        0.39100178624130294`}, {0.3088817977451867, 0.4416586454910327}, {
        0.28449500690222146`, 0.4935284199117792}, {0.2494557158681801, 
        0.5464831388249818}, {0.24877889568717265`, 0.5473351649005463}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.24504688855491036`, 0.5520332626820685}, {
        0.22810749269175734`, 0.5733576962387544}, {0.20439340370113937`, 
        0.6005122684488381}, {0.1649469459234559, 0.6416603700411914}, {
        0.12119377990775204`, 0.6835817158582403}, {0.09812101214176232, 
        0.7046769479693801}, {0.07734877294380771, 0.7232357171831727}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.07286107932407201, 0.7272181394782499}, {
        0.04957819377660784, 0.747566013480293}, {0.0241081431774431, 
        0.769359846880066}, {-0.002099031513618352, 
        0.791298854708681}, {-0.028981360110748144`, 
        0.8132953442987685}, {-0.05653884261394632, 
        0.8353493156503288}, {-0.08477147902321286, 
        0.8574607687633617}, {-0.09597844190764601, 
        0.8661454897766717}, {-0.10729637935669256`, 
        0.874805668946986}, {-0.11307938619442648`, 0.8788526890121527}}]}, 
      {Arrowheads[{{0.008493939754460523, 1.}}], 
       ArrowBox[{{-0.11799521086277556`, 
        0.8822928442165078}, {-0.15427938623325638`, 
        0.9076849611364158}, {-0.20313083696064926`, 
        0.9382788487329112}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.07170592455365979, -1.5}, {-0.0580708729479998, \
-1.4888588579265614`}, {-0.02089151743152478, -1.4625488239345263`}, {
        0.015452113473533542`, -1.4410003914225953`}, {
        0.05891930872416937, -1.4213276150048058`}, {
        0.10151267787561008`, -1.4041279736619363`}, {
        0.13978563179066766`, -1.389573907302118}}]}, 
      {Arrowheads[{{0.011703735068257837`, 1.}}], 
       ArrowBox[{{0.1453938298255623, -1.387441276344497}, {
        0.1619968704291404, -1.381127633680397}, {
        0.22104256292473784`, -1.3615557752385974`}, {
        0.27903205728585756`, -1.3443895722045578`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -0.6381256004021509}, {-1.4884312769549646`, \
-0.6445794885407993}, {-1.4498552921895427`, -0.6687335344072585}, \
{-1.417196843409184, -0.6927310267411292}, {-1.3815724832461889`, \
-0.7272707050840744}, {-1.3498932433041089`, -0.7620907606984532}, \
{-1.3210421924872373`, -0.7953349176713929}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3172490566794823`, -0.7999815873922667}, \
{-1.2917752161570175`, -0.832424201695038}, {-1.2659711520660382`, \
-0.8681229437648113}, {-1.2414365342031228`, -0.9041923992097194}, \
{-1.2178021883215426`, -0.940544649524979}, {-1.1946989401745687`, \
-0.9770917762058072}, {-1.1816696103459452`, -0.9978203978268294}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.1784765967920017`, -1.002900227001549}, \
{-1.1726232753359787`, -1.0122123932667368`}, {-1.1504478720230589`, \
-1.0468906185986893`}, {-1.1281727302358089`, -1.0811264522016644`}, \
{-1.1057978499742285`, -1.114919894075662}, {-1.0830754341362698`, \
-1.1476795570765512`}, {-1.0597576856198847`, -1.1788140540602001`}, \
{-1.0423192978321938`, -1.200333453946619}}]}, 
      {Arrowheads[{{0.012236189020807175`, 1.}}], 
       ArrowBox[{{-1.0385417637088894`, -1.2049950240627143`}, \
{-1.0358446044250729`, -1.2083233850266095`}, {-1.0113361905518345`, \
-1.2362075499757785`}, {-0.9860820969002876, -1.2620528163329003`}, \
{-0.9599319763705502, -1.2854454515231666`}, {-0.9328858289626223, \
-1.306385455546578}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 0.4659338734838492}, {1.4740452263933639`, 
        0.4885355736328016}, {1.4486225895280547`, 0.5161499161852187}, {
        1.4237892820502698`, 0.5553946662182301}, {1.4028505267062166`, 
        0.5950708578840258}, {1.3832777159269944`, 0.6350976590848203}, {
        1.370977869426221, 0.6648435606474133}}]}, 
      {Arrowheads[{{0.000490329262122424, 1.}}], 
       ArrowBox[{{1.3681566289172957`, 0.6745474826444859}, {
        1.3669653250167564`, 0.6745474826444859}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.188476432146091, 1.5}, {-1.2094249128322465`, 
        1.4607126843974443`}, {-1.2309699289796816`, 
        1.423376621977482}, {-1.2510172763348337`, 
        1.3913672120139786`}, {-1.2741375205818557`, 
        1.3570362093131338`}, {-1.2946781312782063`, 
        1.326294658386884}, {-1.3139066309635445`, 
        1.2967985098646255`}, {-1.3144451260717314`, 
        1.2959226966687785`}}]}, 
      {Arrowheads[{{0.002056122462482816, 1.}}], 
       ArrowBox[{{-1.3204241335171008`, 
        1.2744063109972958`}, {-1.3276745093293647`, 1.2744063109972958`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.8717861399184024, 1.5}, {-0.8759699999178087, 
        1.4922703603850036`}, {-0.8970354162278429, 
        1.457457528973495}, {-0.9179417152726934, 
        1.4279634996961004`}, {-0.949614516228287, 
        1.3942199094744494`}, {-0.9811440409911165, 
        1.36463165943938}, {-1.0125043054308183`, 
        1.3364669396299722`}, {-1.0300902687985867`, 1.322114573335111}}]}, 
      {Arrowheads[{{0.013010679783420813`, 1.}}], 
       ArrowBox[{{-1.0347386920418058`, 
        1.318320873116077}, {-1.0435260492242653`, 
        1.311149280271889}, {-1.0740469747273083`, 
        1.2880023014884103`}, {-1.1039047842957979`, 
        1.2663496234028178`}, {-1.1328763569212952`, 
        1.2458539549497079`}, {-1.1607385715953595`, 1.2261780050636772`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.013125799435159255`, 1.}}], 
       ArrowBox[{{1.5, 1.4414804993522718`}, {1.489448283390374, 
        1.4436930749546701`}, {1.4570982495128288`, 1.4504390137036873`}, {
        1.4293289256356878`, 1.4558877440097593`}, {1.4054736472559823`, 
        1.459806463097352}, {1.3839986561676378`, 1.4629338641338965`}, {
        1.3447950935378736`, 1.4678220120335799`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.012976768783036267`, 1.}}], 
       ArrowBox[{{0.09906610939362587, 1.5}, {0.08773492875454608, 
        1.483334108419489}, {0.06812557147849725, 1.459633710692922}, {
        0.057372138684016825`, 1.4494280961425485`}, {0.04677046039908369, 
        1.4400694725667986`}, {0.02585662236906592, 1.422806263165976}, {
        0.00549242321036939, 1.4081001112488964`}, {-0.014374601119203358`, 
        1.3953565785537143`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.01465689056562825, 1.}}], 
       ArrowBox[{{1.5, 0.32811911627001}, {1.4903064698500328`, 
        0.3361728996610317}, {1.4657910013768511`, 0.36139847386548235`}, {
        1.455479027970718, 0.37522157120684374`}, {1.4459917901636494`, 
        0.38898602723779835`}, {1.428428345906122, 0.41643098079699037`}, {
        1.413338582030245, 0.4437605667450232}, {1.4001308839796847`, 
        0.47107347545424305`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8798102077044306, -0.43857092101419837`}, \
{-0.858699925829089, -0.47130346835323195`}, {-0.8351866545713567, \
-0.5039077109227286}, {-0.809106236624489, -0.5364258870094984}, \
{-0.7802945146817423, -0.5689002349003516}, {-0.7486004644167159, \
-0.6013452581491785}, {-0.7263836210041796, -0.6220924682135569}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.721998420782346, -0.6261875895810417}, \
{-0.7138730615030088, -0.6337754603098704}, {-0.676036510785885, \
-0.6661813963120777}, {-0.6350000873940157, -0.6985332981713979}, \
{-0.6020142090450399, -0.7227886079503185}, {-0.5673313656532899, \
-0.7469005873123666}, {-0.5309515572187661, -0.7708692362575421}, \
{-0.5309011045147064, -0.7709008054172966}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.525814756474338, -0.7740834244036411}, \
{-0.4928747837414684, -0.7946945547858449}, {-0.45336871644173454`, \
-0.8182527099081429}, {-0.41270102653990204`, -0.8414198686353037}, \
{-0.3708717140359711, -0.8641960309673276}, {-0.32788077892994166`, \
-0.8865811969042142}, {-0.3169145528008438, -0.89202843101783}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3115409756460039, -0.8946976384958997}, \
{-0.27795827587238764`, -0.9113791135704254}, {-0.22756143056969824`, \
-0.9351666291136067}, {-0.17669024302187372`, -0.9579437435337574}, \
{-0.12534471322891416`, -0.9797104568308779}, {-0.09258939883296699, \
-0.9927825494511644}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.08701677853250485, -0.9950064880714679}, \
{-0.0774856676056407, -0.9988101934276163}, {-0.029804925333131442`, \
-1.0165825390009255`}, {0.017697513588613455`, -1.0330274935508048`}, {
        0.06502164915959381, -1.0481450570772546`}, {
        0.11218537222279998`, -1.0618059475038262`}, {
        0.1410505792772011, -1.0692184655978132`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.14686202040401827`, -1.070710830174429}, {
        0.159206573621222, -1.0738808827540711`}, {
        0.20608525335486003`, -1.0843698628279899`}, {
        0.2528214114237138, -1.0932728877255815`}, {
        0.29968704382271166`, -1.1005715159308314`}, {
        0.3469541465467818, -1.1062473059277234`}, {
        0.3834258764346377, -1.109348262248097}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.38940430629508893`, -1.1098565696390181`}, {
        0.3946227195959243, -1.110300257716258}, {
        0.44269276297013915`, -1.112730371296435}, {
        0.47689851975583913`, -1.1134645003212484`}, {
        0.5118449727032347, -1.1133976391745528`}, {
        0.5475321218123259, -1.1125297878563478`}, {
        0.5839599670831126, -1.1108609463666337`}, {
        0.6211285085155948, -1.1083911147054104`}, {
        0.6291556017043416, -1.1076985343919736`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6351333927351479, -1.1071827685613762`}, {
        0.6590377461097727, -1.1051202928726782`}, {
        0.6976876798656462, -1.1010484808684367`}, {
        0.7370783097832151, -1.096175678692686}, {
        0.7820628137049684, -1.0902096116268758`}, {
        0.8283835039090865, -1.0831661150797611`}, {
        0.8701324199250334, -1.0749426067982517`}, {
        0.8727431421798771, -1.07438571047751}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.8786111256874568, -1.073134003820672}, {
        0.9127603890772786, -1.0658495831579446`}, {
        0.9557229053939469, -1.0557919811356185`}, {
        0.9992014708656637, -1.0448014884056807`}, {
        1.0421759146844916`, -1.0337598412084632`}, {
        1.0845050042206634`, -1.0217202883142962`}, {
        1.1109745024464006`, -1.0134414000393648`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.1167009405225312`, -1.0116503369583314`}, {
        1.1261887394741799`, -1.0086828297231796`}, {
        1.1672271204450397`, -0.994647465435113}, {
        1.2066186068044107`, -0.9795994760991893}, {
        1.2433616582234592`, -0.9635241423645012}, {
        1.2774562747021856`, -0.9464214642310489}, {
        1.3089024562405893`, -0.9282914416988315}, {
        1.3337373123662732`, -0.9115132374493266}}]}, 
      {Arrowheads[{{0.005007336926839006, 1.}}], 
       ArrowBox[{{1.3386152814805574`, -0.9080280591187164}, {
        1.3620045391892375`, -0.8890032909121209}, {
        1.3831991967726838`, -0.8678586445261318}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3040677946957218, -0.7181862975851201}, {
        0.3569549319490194, -0.7108909005578685}, {
        0.40961412584764556`, -0.7006425990630752}, {
        0.46267235910988935`, -0.6870219218574238}, {
        0.5167566144540398, -0.6696093976975976}, {
        0.536699457055983, -0.6619361386368517}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.542299254524245, -0.6597815462590582}, {
        0.5718668918800967, -0.6484050265835968}, {
        0.6280031913880599, -0.623408808515421}, {
        0.6808073981151166, -0.5968842179566769}, {
        0.7352291852585214, -0.5666762050931063}, {
        0.757190256997766, -0.5536494198404686}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7623506848491598, -0.5505883768171579}, {
        0.763052698240841, -0.5501719591756835}, {
        0.7912926598362209, -0.5327089454393985}, {
        0.8199490700446608, -0.5142871638842512}, {
        0.849021928866161, -0.49490661451024187`}, {
        0.8784007672074626, -0.47458840941091324`}, {
        0.9079751159753063, -0.45335366067980765`}, {
        0.9377449751696925, -0.4312023683169255}, {
        0.9597243353783317, -0.4142822941454956}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9644787331759836, -0.41062228026824293`}, {
        0.9677103447906209, -0.4081345323222666}, {
        1.0016216257999664`, -0.38159702308397025`}, {
        1.0353892382010494`, -0.35398895604274494`}, {
        1.0623917872679816`, -0.32914076097359546`}, {
        1.0888030037699845`, -0.3036775424102503}, {
        1.1140849759877485`, -0.27779182934866975`}, {
        1.13841700782771, -0.25141944545686706`}, {
        1.1409816265033652`, -0.24862154178876994`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.1450358657331432`, -0.24419851745380078`}, {
        1.1623189980573057`, -0.2253432623685083}, {
        1.1848018347712834`, -0.19896110922602855`}, {
        1.2058655179696431`, -0.1722729860294278}, {
        1.2255100476523848`, -0.1452788927787061}, {
        1.259958715372515, -0.09084349590539265}, {
        1.2815595389197418`, -0.048028781002361756`}}]}, 
      {Arrowheads[{{0.013688996674990628`, 1.}}], 
       ArrowBox[{{1.2842621677315469`, -0.04267193514816723}, {
        1.2875649068331743`, -0.03612561839658121}, {1.3087241210299212`, 
        0.018562216456635958`}, {1.3238318569583143`, 0.07290748536316655}, {
        1.3319820529733, 0.11399806119559401`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.37397867707840293`, -0.8237593677219617}, {
        0.41939733219235825`, -0.8208796480747533}, {
        0.4653715920032173, -0.8160839947212383}, {
        0.5119014565109803, -0.8093724076614162}, {
        0.5594300885463623, -0.8004482025049269}, {
        0.6084006509400792, -0.7890146948614101}, {
        0.6109145094524068, -0.7883194256926184}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6166974077346754, -0.7867200234739958}, {
        0.6588131436921305, -0.775071884730866}, {
        0.7106675668025165, -0.7586197721132943}, {
        0.7627739071104332, -0.7399141867490696}, {
        0.816652433879277, -0.7182981675758072}, {
        0.8426752953022363, -0.7067104033585704}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8481564397009412, -0.704269695248094}, {
        0.8721224851644964, -0.6935978141072201}, {
        0.9290033990215396, -0.665639225857021}, {
        0.9577975157857923, -0.6504135949496228}, {
        0.9865935209355954, -0.6343244078684336}, {
        1.0153914144709488`, -0.6173716646134534}, {
        1.0441911963918526`, -0.599555365184682}, {
        1.0590112569764007`, -0.5901654069847994}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.064079565384923, -0.5869541377846074}, {
        1.0844852564936738`, -0.5740251362155677}, {
        1.123994034282294, -0.5468159671993253}, {
        1.1669893602515085`, -0.5099914595078073}, {
        1.2063943078194408`, -0.47116731261496825`}, {
        1.243491517901551, -0.4315304308560738}, {
        1.2445153271439822`, -0.4302298606532424}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.248226586542539, -0.4255153560476}, {
        1.2759732530120171`, -0.3902680793650686}, {
        1.3036568299157838`, -0.34770156974357935`}, {
        1.326359565377797, -0.30415221359323324`}, {
        1.3444099406606553`, -0.2599412008490704}, {
        1.3581364370269575`, -0.2153897214461312}, {
        1.3583354531278742`, -0.21453112004568806`}}]}, 
      {Arrowheads[{{0.0025353410423390797`, 1.}}], 
       ArrowBox[{{1.361373942443571, -0.18631147404968978`}, {
        1.3648765138720964`, -0.18631147404968978`}}]}}}}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJw12HlUTf/3P3BRKipz0UCiDA0iUqhNEUJKRIMmlAaaM6uEUiRURKWQSmme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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwd13c8Vu//B/DSkpWSaMmqrEQkit4oGWW0CFFmSlGRTxqSBtKwUikSWWUk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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwd13c8Vv/7B3AjUkrRoqloiYiyUleitIkUKkRlJDNClFGJlPJBW0gyMqJC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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwd13k4Ff/3AHBUtAlRluxEolVokROpSEkSWZNKG1FJKUWLpeyJNiHJEimK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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwdl3c8V4/bxlGo+CaKSEaKkiirVHSbaRAiURkpJUpooCRaRHapREMSJSMr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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJw113k0F1/cB3BRkqJIqyWytfpJJSV9SpaSUoSSsmeLsmUpRZRkabGGRBRt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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwdl3c8lv/3x1GiskelQSX6lJGshBwppUhIImSUikpFRkZIkVBGQ1YpW0a2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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwd13c8V//3AHBaVBJaVPoQZSRKNNVRyRailISQUNJQZJRQkpJoGNmZLSMk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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwd13c8lf/7B3AplUJFCNWnYWdEkkRXw8qoZCSVBu1pRKKEkiilKImslJGM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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwd13k8VO/3AHApokhJSGlBSKSFFpWTSJItRZFEoVS0kZStbKWVZEslJFLW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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJw113k8VN/7AHAtlChUVCoUUQiVlPVR1pKSrU2ULUkoWlRkSVlSEpJsyVKy
FSLhIduI7Ps+9plhMHNnKJ/qN98/fvef83per/s69yzPc8/77LB1M3VYzsXF
RSzj4vpfq3zgf08b/H/78EyXjNmdNijcELrvnmY75LzKLP4U0AbWq2rJKbXt
EB1bku8W0gZO+/Cxr2kHWOHt9MDQNtjFIun8N9AB8fuXRqYftwGjrm1glXMn
jK9b/i7xQRtMh5hmv2R3Qt92X43XLm3gkBrwKjygC9z+PTfqtGyDkSzJ37OC
3cDQ2Ew2V2+DjckRme8SuqFf+XXORtE2OHvfnRkv3wMVTn4qm5itUPPx0/2W
4h64K21Fs6lpBXKWjOW+Y71w6br0JeJlK3SzPYncrl7Y/kvQsf9CK/A4WMvo
OvbBBxmW3E6xViBKHMWGiD6wja4+09rbAg3L3jjdDugHh5NGov+9aAG9UHf2
X6EBqHwSpvFJpwUWSc+3uSYNwOwbc2meuWbor7/06qvCINzNNBkQetUMZzbv
ed5VMghCIcH/zRxuBn7hwLiy40PwiL/M4PrHJnjasPynQ/cQWL3hx419jWAx
2WQ2sn8Ydl/eL7BxWSMwb3nGXPUahtoT04qftv+E0/s1FqpwGGSW5y9T2dcA
hty1xBw3GWyuh5Bn1evBx07rLNWIDCMNdUqKWj/A/6+5XPYLMjC+5rXqH66D
0BTXr6pdZJDe/uFtqCwJHq5rCQvZNgIbrkgPmgnXwiX9cveEyyMwplrymr1Y
DeSoa3YeaSMwvXRcor6jCmLuRcSuoo0A6XjN5d2ZlbBnuP7OOcVRsHLOt7Z/
8B38aqz8rniMguBHn9dt+hVg6fHsrFLhKJisfvCMxFcORafuZH/+PQok4VYn
6VelcD9K/tCM5hjMuwesXbb2G8SxLN4M+o5B17GLKvleRaDiKu4UWDkGF22G
AusHCsAnI+jPEPc49Mk33/ihmge6kRvvTxuMg892i69yz3LB9dRQxvvgcZgb
DKVWfPkIpnVSNKH6cTCs+vMoRScNBu7qi+zin4DH7sJ8JZVJ8GaZ/dXBExMQ
YhUoaucWDanaSVdVwybgpIfZrqu+j+Hl4n6S0s8J4JLPzpU6SpQJTbrqlfFP
gl3pSJoEPsbfYdMRvUaT4HrD/EhUYzS+MN1w0DtkEiK+F0XV7n6Lz5N07eNI
kwCKOQK8RBreUl+YkeeZgtEPcn5UUibWem4V2akzBZKHLVdkmn1CsU1yXtcf
TsG2w0U/0gzyUbPNZPZv8RQ0PYoTuKZdiF5CojeqWFNQW3vjDLdWMWoYyP79
oEiBV2K95UHapXjF+Mrj104UGJQ6arhKqhxTIoU67yVR4Nrnv0PnMyrwhZVS
4IEuCmzett7w9IFK7FN5T03jp8KDf5cF/5VVYQAc3vBFmwpjLWdW3TeuwVji
Tgl4UGGwqIx/cLAWhaHKTCKFCisyBqaOetRh2qnOxX1tVPhPZO3umjX16HIk
IOAEFw3yXZp/B6Y2oNIdcqieHA2YcqqiyTqNKHP7h8ecGQ1CFNbkqo83oaKR
k7vYPRr8uNCbpFbdjKS7hyIS4mmQlex68uvrFux9nFqnWUaDf24/L8u7t2Kh
ssZETR8NNrP5aGmGbZj5cvuz5WwaXFI4dV9Dsh1rj3rJFfJPA1ei8vplXB0Y
E/7653vxadhZ6rSSd6gD17L3L8UoTINvOanbqbwT825XeuirTsPHx8Tmgyld
eN6Sf9AFpsGlOlvIP6Qbq/TX2FZpT8N57w4fO48enNpltHeZ5jT4GIuKTVv3
4tlQSXLrgWlQPc7cude4D/dbbaONSk1Dw4rAwINa/Rh6gLeuW4Aznj9Pdwnt
H8BfmzPUTxE0yBFP+1q7exDf26e4DLTQQGFDvv+FnUM4TZIREHpPg/Ox9wfs
BIaxdooe6HqbBhP6h63+PRvGj3G52901aECKCxlgCpBxvL3aPfAXFbptXisp
RJDR9fuCwIYsKnS6Dg9FCI9g8161qJuWVKBc7g3/7/UI0oXdTjEJClheSdNQ
Ex/FobG8ir4nFBBVTzyxNnUUd4X9VndZRwH168uzZOTGcGx7ct/IkykI6345
t+fTGCpqNuv5MSdBmUcm463KONbzgEOkySRc5d8ht/rbODbK6l/wSZiA9VvD
Bys0J3BnYE7S9/5xsL9V/UCsbAIf5tzl2sg3DtYWB0zOq08iV4Jhit2eMQgv
sf2SlD+JIWnvyLOHRiFRa35aYM8U7hVRnzM5NAIpR1ZuKHs1haISvhZ+u8mg
O1S2Cf9NId08pGWIfxjuFL8Tk7tEwf8omVqmDQMQFsKDUkUUbKaqk1tc+oDn
n/idQR4q6vLbCNf86wZn/TclCUZUHF7OHp4J7oRh5ZVHvwdS8XRU3dEVgu3Q
7qRuWJJPxQcv2M/9o1ugpytfWLibitNBW2MXj3L+y3Yzo46zVAysFrOhOdXB
/m2T+ed+UzG39zzP55QquCe18DRhkYo+9wRNWlkIrZMRgVQKFZUpNZIbB7+A
W4vYNsZPKrq6Cl9UX5cJeUu8/A4pVFz0W3ebaI6CgpsfmVQXKirlhasdqXqM
593CfkvIUHHZoWteh0pSsXtja3ZMKwXdb6qMr4z7jCtKCfNuVwpaxonM7Fhf
jJdEUulWS1OYnrPkrZJUjrRryfoJd6ZwacKd23FDFV5zdTQVHp1EnYNrP96y
rcUl/f2KepqTGCwMbYJhPzDm7/qBmsAJ1O5qWJET8RMZ6nVRZ0rG0eiIyycD
1WasTNVQogyPYaNymFt/VAtm1XS75DFH0TiA5vdwsBUDhhlWuqwRVNF58SFw
fTs6l2l6h02QsfCs/NmD+zpQKMKgnkoaxnvuqb8aVTvxaIZB7lGNIVyYcJKI
lutCv7GZiPTmfjy8tJDby92NwR07U3vMerF4nCmyjNSNpja8qivqu1Da9Ob7
oBs9WJB1L9xGvQPbbftSBJb3YqHePlj40IqP1sy/M/fqxUrpls8OW5tR9mpO
wcGuXvSU/u5nJVOP35J+k7K29qFNk5m0gXwN0m7abW3R78M0uUPRFccrMO/b
Kc+6s334oicwQnftVzSn7a5vPd2H60LTedeG5OAm7fnvh/f3YeTLaZuAf7HI
p3Zqr8XvXkyKWvvwKo8vLC+2jn6e0YvG6+zP/f6VAsrZh75c1OlFtkKqdWbB
Z2CybofpVvegf++VxZeZxbDb7MB4j1IPHlUYKVvYVwFvbotMVD/uRt+aarHd
s1Uwr5Z/v6q2C9fbJmzUek4C4SfnII3oRN10o5UfNzTA6KavOSbrOrFS9VPQ
hHcTaMkXBJUKd2BAf9qT/Cst8KglSvwXXzt+Njt/pH0lx1vJN7+JM1qRVTe8
n+9VO2Qn7mCfq2vB4LIidwHxTtBtaNfrjmjGW0cy9kXGd8HffU4VbxIb0Yy8
ruLYhh6w9Y9x71zegMlZz+4O+PZC98Erybmn6/BTh1XWr4k+SDI6ddv6WQ0+
GGry19MfgEcNDY0zxZVoHXAuxj5xEI7ZBItp9pSj09uQUDZjCPrD51UmO77h
u5H1UvVJw/C7O3mBNVKAt/o0wqf1yHDqViwXrTAHyXKkNmkKGWbXS1ebBb5D
4QOFO0tDRuDBNgmJo9+f4nTXUumM7Cjwe7TknN0YCNnjmVNzdaNwWHjl43t9
byE9rvzDwpUxOF+5MyPmZTa8+VNqJstxha2PU2ZNYQGsPCTZkPZ2HJ59KQk/
rlrC8a9HmI/mBCQN5R/XcaoAhY9Gl/O7J6DVaCR5e3kVKKqNtKl6TMLJuNuG
Q7tI4F2832mafwripd0LfN/UQ/UpkbiI1CnQFGxce0KyCXgdvTq6NSiwcs06
t3mbFhAmmV482UqBIsbz3p1qbdBN+xJj60CFe5nus/QdHeBlf6HYlkWFZ+pd
5bpbuoAuelD+rh8N9r/SkLTY2QORpzfR01dPg4foJ8030AfrxHk3twVPQ3Jq
pNCEB2fd5yJeFq2YAR7RD6q234fAqfXvwoLnDKy4t7Dj9CYyZGbLHBPun4FW
h0Xt09YjkGiQpux9iA6VQof1LxeNgiohbxccSAfL91/3dciMg/TqnPRHVXSQ
3vhsJ3fOBKhEyNrlMOhw23qNxlqTKVjluPq23rpZUDgauf48xxdN506/CBKe
hW09e2IpozRIGLG2buOZhaSZp9f2ts/AiQX4VjxMB+1/4lmxnbMQ49k+Bsl0
mL/FFn03OwfjDwcD1hrRQc/XvkiVPg/ZK+qsP/TNwM2hqlDFfgao1f7wv20x
A9mnrPuJbCbUhwtKuRZPAzlW5KqRDQG+3f6Hkjku4BlgdOyhEWB2zneo1pgG
vjMeBqctWFBi7sv460MFQ+32b2rvWHCyqWyhl+OmovWyQoxeFtzcpJsYnjcF
GZ5LtxqXsYHkxaqRK5yEUd/Kbdzb2GCR53qn/OMEUL56fy6QZ0OW3zqVly/G
gfDd/nKHChtelJlqHr46BrdoCkoTqmzwr9735/2BURhN5t60lxO/JV32PMkg
Q1oxf0aTMhsqLj1q/Zs2DIqVzZ7ue9lQY3g/ui99EPJv70l5KskGWW52846F
PpjU7218sokNusXOtWztHiAPtxbk8bKhNng87HpIJ2TJ/VC2+M2C/G/bVDW6
2yBw2RGjdAoLIrdIb/dTaIE0mzBqfxcL3gjw3FLd8RPKXnzi2VnNgjJekRU6
y0kwJj+qHfeJBaySjRZZKyphsLDS9lo8C2KseUHqVAn4JvSQPgRx+mf32LwY
+AwpffN1Lh4syBxP2H3f/h1cqukXq77IAgkgDuy0vwrnWV2GaMCClRuCM+Rc
EnHomRTTbh8L6N8V6u7o5qKLvs6JIlHOel+SDfh7qwg1L64xL1vBAu8Nstdv
q5Xjl+GMbbemCZAYDXZzl6zCOos7f7rbCfgrEqncvViLH1XLvoyWECDUIrg9
q7QeU8uNHz9NIeBT7h/7f55NKJqnK08KJcC5L6JmIbwF4+2LhoJuEmAZniTU
bdeGvDz39pedJeCAiGBBlXIHxu6dHjHXIiDr3zJtN+4u5Ip2ilWRJGBunUbP
665uPL+kFH1sFQF2P516RLN6UUrR5LA7lQnsxen3w0/6cet3Re+gBiZEjzi/
Y10dxIApbtNrWUywTz/fUiE7jEJr82ppT5mwMd/q5DVpMqaKmW/vdGbC7+ip
fIU9IxjQy46n6zMhu+ZBspnyKO6rnTaek2DCm/W5lL3HxrDw0JBj6CIDltF3
KwtfHcedUQLpdj8ZYPfv5pBF1AR6jyX6rUtkQAZ9W+2mpknk+WJmLHSdAU55
AaiyiYINXULpQyoMOH782crVrlRkzBdb9y7NQ+hiR+PqNhqGRltcP/VtHubR
1f227gz+e3c35r7nPGRGThr3ltFRwz3b9Zn0PKx5Ud5gKjaHyQESqz41z4F3
hcOrVX1zaHzeYb/AzTngqy5fVRw+jw3DKmFk3jnY2MYaPaDGwI/bx47RFGZB
M2LtbGYrA9X0d/naKtOBvbmiO92SiefwhqCE5Mz/7rFGD6uY6OJJr9D8TYOv
6jzhztsIDPsYsnyhiAofBAepay4RmNE4vKPUmgLxA1cbal8QaHDh8JQ9bRKe
1bzcrZVPoLeLlOAVmwkQ35ejPlpH4Nsr285KlYzB+/mG0J52Aqs2j7RvXjkK
NxxHlyY7CWy9G0ajqJFhnarUYf8WAl1KM3T9fgzCfrPK3s5qzvs1cwWDgn0g
HlzEM8Dpf/mX88xxsy54xOMrYJNI4LvZvaTu+DbQflvxZ9ljAj1zDkRW0Zug
0jqs8PhVAntUO7PEG0mweFvr69tjBN40rlK0HKkAM3s7fksZAtuGZ9eH2nyB
pAvt7YnLCbSKldonPJAMdaEuT5P7mDhXEGrrFR6ELm9cx10/M/Gyobpurlk2
rvU2ObryCROLJA+uXBwpxt9bX+edPsfENuU8qRipSpRL23JDZQ8Tg16VeMbk
k7B9aVWtH5uBhOuijMjuRiw5ZuzOKGcgjxJ8nvjegqmxuywPBjFQYAdvuYFz
OzqVTWSMGjGQ9JgykLi2C/dffmvmy8fAO6J8xc65PehOGXvpWTOPDnSzd4qW
/RjhncLgezDPuT8GGfotH0JDl1/n3eTmcbz03PUH/cPojJlRiW1zuKmnyClS
awQ35B+95uYxh/fi2riOfBjFEV6hLT68cxhZ7VsjJDaOIicNCx13z6Jz2LEm
vYQJPCcR5eUjSccqzxvWz2SnsKZ3q85RrhkMaX40WvCdgpgzc+p2MQ2FZg8M
7XagYcKi3405YyqmVoYlOa2bwZvRzkvChVN45g6N9KiIjplDZ8nPmRO4VMRL
urb3f+PQ+yG1Yhxzcwwm9rLm8E9I1IEnUyMoUXNuh2fWPEaKdx2v+jCM2k94
f701YWD4yQTnX4n9KCirE/m1l4Fea6LXhTV04cPjdyPFjjPxs5pzLzHbiv33
FJzjEpm4ztSRh1BvQEOl4MTKASa2sL536v34jqt46f+tWE3gGqXjmU8P5WHT
Ey3mxA4CfZeO70msvo20d0k7oxUIfGTQdvdDWg7krBq58F6JwG0Xz1QqGJfD
4C71rq2ynLzV89v0y48EL1++Jhw4dWMjOVMje6IZGF+cTII5/Tdpy9gfOt0O
Zb/avGVnmXg+ON7597luMNatupzUzMQ/2ulHeW/0A5eylv+/TCZaqBADQybD
sDbo/huJR0xU1H04tPXBCGQcjVZ4Z8FEERtbhk/5GLxhmHHPSDA5dTC+V0SK
U4c9yod3jzNQlclN/fiRAv5PJoKOvmWgQx77YeHZaZDnDtNnmjFwp9gWUuuu
WfjTJnqpeWketyR7ms1yzQM1U/Ou96t55JP1UOV3ZMD6Vbf4fu2ax8z5h+U2
H5kweY9CnU2bwySaF5KKCQjpzjvYITqHP62ydnEHs6Dp+2+X1dyzKPSiwCtu
CxtMrvMmaJXOYF/dsvc6XmwQG+iQcLSeRs/Wh32UAs45GqjdnTRJxYHm//bG
9rLhUoxUc80ZCvomVHfS6WyYENXfuCV7EiXbj4X3L7CBfeF1QTt1HPlX2enG
LLLhVWVmWLzAGOpqWjzVZrLBKqVMMU98BKPNTqwyorDhJplWPSA+jII3nFJq
+thgrdvYvVG+H3VeiVH96tnwfaw4xkioGxuS6O3iX9nwIKFTvWipDcveNoTv
TGWDk2PIcBmtCdtkpdlzz9mwZavBA0UBEmrET/b2cOZT1s0r4XutHIX6pZtE
7NgwJrm58xvvZ2z67N/ZaMSG5sY/eUpZYWgd4iaxheOO8ktZE7fOpwCmhD3/
t5UNPOtF3UY/FkLyZ0+y7wo2KOjs0Tp/7Tuce3DiQgSVBUlaiupywyRQO5Y+
L9HCiXfYPnui1QTqScdnhApZEKeEuvGkVrhwTWODThwLQok9qr3zHXDw/eoz
Ib4sYGzP9xbY0QOxNTHbC+xYIN+F7WjVD2c/821+oscCgW36d+gfh2BMz6+q
aBcLZK4G+AiHkuHp5k/5LI4LPti3xledHoXk4Vhy7xABpC1uFSoK4xBV5fiW
VURA/GfDLf6cvAt29b1U9YwAfff8EsHDFIhLXyH+7RIBXqp3Ol460yAjeLrt
pAIBLjK/U3WLZyCs9dpTvgUmmJc+t8wXmIMASoFNYTET0vT3lXXqzoO96+bQ
B15MGA4U545xY0ClhTbBrcyE/yxO+fD6MuGOzoYQVxoDrpAFH05fIeBxatSL
hSQG1D3NUPsnzoLJZt7GjxYM0M57fKv1AwumIldKyK5hQMhY2+Nla9kgnS4q
9b5sHo49SvtDNmVD9+3WDkGPeQhgqPXlBnA8mX/u/U6ZeSBJrUjL5ORBQunS
sYDeOdgl6pWtXsrZp4/W9j+ezsEgr4GFzU82qI9aDT7WnAP/W/3xEt1siLCS
eeDfzfG33bASeZANnkoXHX8pzYJs5FRZxAgblDP5jrkF0CEy0Se+b5STpzJy
wd2NM2Bcal6twImzHOzXS66fgdWXz8T1DbPhVr93uuqJaag53OO1eYAz3t25
krwPaCDu8InEy/ne8OXlB4KSqHAzJe9PTQsbhCuOzVYUUYDrFV3W+gcbArpz
Y0Yrp8Dni/Pnzgo2aOubahpXTMLAx4XrB4o4eb7vWUhK7gSY/Pvm75nFhj1d
0qpTHF/nzJ3nev2WDcHEy3Q/hzHoVlx5LimSDbYWKQ9Py4+Cwp3DuaGP2XBa
rZk3f5IMuyhT89Z32MDoO+lw7/UwVB8MjdtxhQ2iR+kN2U8G4bFsze4hC47H
d3419W/tgypv82XpOmwwZQZ9idrcA9oPZPifKrHhgnbphkXrTggKSe18x/H/
mtcBAZYZbWCV8+MR92o2GPzMD6r42ww21UkfSAwW9PVp7BXEBmgf9d+7coAF
sddlq04n1ILh6YyLP2s4Ps6MictK+A67Np5QPpTLAsf2pzbyj75BoWpn/+nX
LJCNi0z3Xv8ZzA2F3WT9WWBLX+5m2fQW8m/+1/nDmQVcSoF0rxsLWgbUf/2q
Ziwwfz4YusvgLTpO2ercV2dBw/JD4nV8n3DonS/9uSQn38j3/SQ1vqLHPWnB
23ws0LrobL8yvhxV64RM9jAJUDK9NBsVWIV29admkns5fpb9uqv4PAnVmh91
9FQQ8Nk1ZNdd8QbcPrsi9/t7AjIu8StPdjaharJ836nnBEgdrNbaxHHDjjc1
52/cIiDW8HeETlQbyuza+mXjBQLcEpdvSnLswK2Nl6uktAnY8NZjgnyoC9No
VQ7BUgRo1isvNK7pwQi3FmmZ1QQ8Ul9fdYTci13hb+oHOb72lkxU3lvaj1IC
hviU4+vgf1F+SUmDyBZcZ7+a4+saHcVz4/rDuPEigCTH1yLv7oT66JBxa1vc
f+lXmSBgpDZqYTCCl428dM/pMSF8/LBJgdko0kUuX54TY8IyVXttxtUxlFEk
529lM6B98eZr+9BxvK/9lcv7BwNKtvx6afl1AssOtL1Mf8MA8jZnPioxieIy
LffErjKAKyaHRteioNidxWnT/Qy4QCn5m/qKiu+70kzeseeBZRXywuUvDYfC
TS5cKJiHRNOtUqY3ZnDBX4EouD4PISL9sinTdNww6upPFpsHijrsNzg4h6bG
1ctWkeaglO+anf/8HNqXOzmbOc3Bdj7N7q1p83ibLWq74u8sjKrdXz5gzEAn
ODVWJTILL8X6tLeMMdCt49NcyRY6pET5nHzswMR4Db2nk9wzEL+dv6GYc85b
e9SSL/fSQGHWdPVOaQLLBo8pXoumQooxbdrnCoEvrpS13lelgEXV2S0Grwh0
3GEWfqtyElZtHDHeVESgtcJZ93HlCahd8eKLVQOBHrQ8WYPnY2B06NJKRY6n
r1tZBh7sGIHICek7x7sI5E9wsfdYQ4YtN7+HbeH4uvFTY6bvlUEQKBe5WllF
YNSF/CZGZi/09NrKqeYRSA3CScW5TgiN/XNUO57AYGsRs7PqbTC0OBrnFUBg
SYyeRM3eJjDUU490dCSwAJ4wj6wnwaUcm2AXfQLjgp28tOUrIImtUt0lSWCt
xhNP13/5IGXStzjwl4km0vfsMpWToPm0xPWkLiZKDBpF0q+9wHMfiK692Uxc
M3bEx90pFzf18dcE+DOR7WlQ7rC5BHP0moOfmzMx5tlStPW3SqRRdqQqSDFx
Inu/7zbDOvzSkJymMM/A4MNatWu+NqLL/SSPE98Y+BbvHfRc04oLpU/Y+/0Z
yPvO9rrup3YsXu0g46XHwO0iDuhk3oWWKsTlxJUMXMoc3Gq90IPx91L/48N5
rAtYrZgV34+xouabV3nOo/ZRuzrK8SEU/Hs6q2DnPObNH8ywXEbGB0EJ7A0/
5jBsVf0hXfsR3CZ/MmLWaQ4fK9lsYTaN4ub80G1VS7N4spSeOa03jpccutxi
183i38Hjj+xrJ3B6auXCFx46kqvG7RfNp9CXZjIrMDyNEt2ntpjTKVjA/fqv
YzQN3x7XPlP4goadW1t5YndRkWkQaH5FfQZdTA+RpEOmcJ9q/IDcOB1nI2U1
xiomsHz6Xy6fzhy2rFpyGWwYwzzuLEUv3nlczs9eEsseQbv7SpokzjyTrma/
5ncZRhOu1JB7lxh4UP5HiahEPxrdUGHXTzIwJzI96P3xLqyIeSNnz9mHlf5n
C064tqKly3ZNw3QmFprfEs7TqEdLibumcqNMBHYG5VpLBaoZHz4UxEdgc9ee
hk7zT6h+NLZ8hJMXXK/9raJazoGbmVWMpSKBPm7rw8xff4LoAOHjzhxfG0bb
WSfKVgBrvVop/x5OnUj+Mb55oQ4uTK87kCZK4P8Bb4TfhA==
     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwV13k4VP8XB3CVEIksKWkRKRWRlIRjK2tKlhalLGVJhb6JUipp1YYiuxIh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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwd13dcTY//B/AISflIadEgREmikobeoYyIUqKMhlTI1lRGkab2pKgQkjaS
epe0lfZOe487zrknovqd7+/8cx/ncR/nce54v877+Vpnfe34hYVcXFzkAi6u
/71W//jfwQTl/z8IdPvIfuUYRcDbzJiLnUZstO2UMn37lYS/gnX/KdWwsO4u
t+fNZxx47l3M/LKXhd+ejGYLqVOweXLRjcPpTITs2xvPvqBgtVHeqQkRJvIK
jGzi7aOANPpb1jM+hccSP0l6LpsG9lXnZ87Rk9guUh+yRWYazm4Wmlu1fQLl
x6W9zBSnwRZGLxzNGsPKEE1xqx3ToJx/l0tdchR9LDiTZ5Sm4ZTlXHXVlWFM
LmpRfyc3DWaDA6vh1SBe3xw1ryo9DQp1/TGnSvpR/m7hofcrp+FY55PHfnW9
GLBILSJ8wTQ0vpu3fxrXjfYuofVWDArW5K4ZPe3dgVaHU/66dlBQWB1jrXqp
BT1mLTR3lVJA3NPJ0z/RgEW+LsoTaRTYll1ScEuqwUAX08ut0fT39+Go/Kwu
RcehXNXtDyjwvl/SkG5TgMmXVEMlLlJQajfyM8IoDaXqzv3ONKSgR/H4ilYz
J0wqf5nJtYsCqY0jYdkdb8DZS8qWR5qCN8zIXSbduTDmtcUdF1PAk7g3ve1e
MTRceqEjPsEBoeBbO+aYFWDXVhg/W8eBgdlspTTZWriS4e549BMHMsxFGexj
DbB7pbTn0FMOKAYwDgm5NcP6RkZf9D0ORNjnqexKaYMcroMqStYc2Dd3OHRm
tBMSMi8ZXNnHgXPtr7blSfVAYMmOlMXrOfD3LI/qu+ZeyDo2lpLAxYHzf3qv
/HrRD8VzCRPtHSQkrtM6FPBgEFaOq1zTzCYhb/iG6hf3YZDc7VWh7UsCbudZ
/DxiFOLWng48aU4CD98eMbfqcQiVrVT/J0vCATNUzlw3BUlj+p44RcCu4P2u
L3SZkOvuq+6YQcDv1OpPwq4sGAlW/O/MNQK2fwqyCHzBhjXM68EqcvS8Gurd
+PuOgFFVcWfZHjY8/LTi3qwfPbdrE0KuRbBB4+2e+mYNDlSA7ZJl+mxQVBc/
6JDPAdkXurwP5ljgeZyxnrmagkspPc0zmSzw135d//4MBX06AeWn7FgwZMB7
8okfBfoJ6/uN17BgjWLFZvd3FMRbk3VPaphQ9kpTIqqQgnrFGafn95mgcNRl
bdpPCnTjjbyFtjPhNZ/Qy5Q2Ci7LRyoMFjDgn9r9xpZuCuavrlp+V4QBxwuG
DUT6KTo+Wssm7aagyHBYgXuAAoU5pZMbMydBhTvGahn9vuFeQfFV5AQkOKrY
OvVQcEbLZiZJYQLWsY4IunVS4PnKtOSb+Tis8tp2WK2FghfpLj4XPcZg5dnd
GcW1FJjU7ElNDhuFPU3XFilUULDJU2pLxrMRcNj5KteJ/vwOJnaRjKhh2Cuo
IfD6Iz3nDy/KCT8agiX/zNtzUyiI+nBSRMlmEFI+hK7KeE7B15fl4XmqA7C4
fMtJ/1A6N9uMb6fM9MGrSI6E/kMKWJYWv65m90LyBe+frNsUOFpfTBm26YHU
Yl4vPxsKJH4p5r+T+AVxfowja40p6Ly54NYl2w6wSpiWK9ahgAoiHu583wpf
xlWcvbdSEHs187oQ0QQ1ZacF74tTkLxtl3kMNMDSrx/3li2i4NRAasTXiFp4
Zu4YcovBAZlvmpdOsarA6O337KdtHKhW+70jsKkU2hRsk02KOZAeDaU6HUVw
6K/kTPp7DgSN+nVYLv0CypIMy8IIDsRGh+wvTUiHcM9hx6C7HFi6ckOuBE88
5Ofmv95kx4EX4Zd/LUtwRItymT1BxzgQJ+AvlTeWhKIZZ0Ir1DggoP6AL8wk
E4Mu3BNokeaARolp/Vf3L7jp/PtHOTwc+LRpU0myehGOYZaaJYMEbfGOUm7p
EjTX/29pbTMJ9dvvBF5klSOfn4Xv33wSqrMb2vqyfmBYi9fSlpckXIl2+/Bd
pRZn8j48NvEnwWFJ09XiZfVYHWX67vwNEr4LPvrh39WAO869DWaZkuDhFKlc
9qEJN48JJ4xoktDQ83T91vstGDkgpa20loQUPmFPb+M2vP15p+17bhJ0t/8y
ypDvQGWeFo3dQwRMDlx7/pKnCw+NXrpcUEbADj7WmdsTv7Bqeun9JW8IcJoq
t3p3pQcf6rvND3oTIDcyfPDo5V588bn+sqwNAetr/J9YX+9DNN+10hcIGLtf
eET5bj+a6PUmlYgRUHT2toBo5AAeGg5I9WGwwUQmd9gmdxC5feZqbxSzYcSi
s816dAjlfw6TK8PZ8GuRyE65TSP4VNPMddSSDTKuC3Sdbo3ioQH1HFs5NpxN
DUi6UjOGCuuXSg5OsGD+h6KejtoE5m7aEZf6jgXCFWIXMGUSh1Oj639bsUBf
npgc2cRAkV7f78RKFvw5If6s7DgTG3fb25TlMiGKOSsl/x8Li7Z7KSeeYoKR
jpiwRBELP8pLqD/sYMDLxX9XX7Fl4+qcfjbFnAKn2pNJsX/YWHlH3dyROQl2
fAY8L5wJPP7BTWpB2wR8uXCaZdlNYFB9qdLXt+Og75a2wWc7iTdY7g8mrMbg
/WM73vlrJL4Yy+YVXTAK60pSdA7FkbhY/k+A8uNhaNjqf5vrK4lSbRXjDHIQ
nqHKIu8aEjVK/RayDw8AozFMt7+ZxEBbrS3cQX3Q7fd7vJQ+33rrQf7Kbz2g
8GLNiuCfJFaZ2ynPNHSBi+hE/JlvJOp/7NG3EGuH1z5Pz4mkk/hBbM0b1TPN
8ENaMcU9hr5felWx3dt6WCk4vW/LPRJ79zBq1QVqIOrHTSreisTNZ+ICo/6V
gtTvQQH1PSQeFTg/bypdCMOCvTv2SpGIy7yepE1nglTUwcKJ3wQqPfh79kBI
NGRXD3GfrCPwWXifpPyCGCxbrM0JSCbQ77b7LS/tTFzCtzjY9w6BztqHtLl6
89Hedv6DmgGBm08s1hmO+Y4ZBy5a3pQgcLVGjtXAukrU4mt8v2iUjYV9Kpsk
gn5i7HL/ijeZbHTtuxS3+XY9qi5b8mGJKxvfR3waUVjdhALHwhdkarKRv3dO
ZkV+C16pDjbZNMPClf45fw0s23HzdF10eRYLg1VWztyic7DTx7K+1Y6FZfUV
J0Q+duOpEzpLnYVZaLlfc8uwWi/29997Fp3HxBNfioJWPevDw4L7rnKbMXEV
mcCnyzuAjncb1oW0MjBfMnKAvD+IjyrbJT2Hp3BGRPLAwUXDaFZ52V6qYxIV
b//Qyg8bwaU1QZ6GaRPoYWFc/lNxDLsXlM62WIyjRFdAlFvDOB6+k+CVMDKK
Yyc9Q5M9JjFn+S4u4/0juNipITRLloHPfm44w+88hIOKcp0vrZnoc2tNve6d
AYxmLianZVlYumLCwNe0Dx//9zZVp52FQb5PdYtX9OCRK4VvlJ3ZOLGO9Lxp
1YFpC6c/Xphh406zZIN7vs149kmtVZ81gQKusTFjqXX4+OnXz/MZBCrv66TC
v1Xg8d7ddfFjBG5MyWZssSrEm5uF/PYLkPjj2WmPT8KpKDC5bv6aLInBCySC
Ult8oHDAc/86JRJtzTp51qtnw++wf83l20jkN7vL63PzG2TinhOwicTb3Daz
ZXGVsMbhh3i7KInR/d2m4Sfr4OpMyJUHC+kcdSUfen6mCVYtKDv8fZhAlVTt
sOX2bWApZ3FtuIyek2Cbs8kPu+CGoZM5I5HAcjkF2blfPfDjY1zVKxcCn7fq
128S6IfgZ5MXnh4kUOdZ81vRM4PgmbYpUVaQwHFT7s435cPQviiq0aqRjcRs
qzSv+RjIbE2I2fKEjSOCUebHBCZBeFYpY5s2G8NSXl7z6WeA8g+H6gX9LPzi
YcywtGBB3Cv7ryZ3WOhwL2BDRAEb3vqtUTJYwkJ34evx36YJ6O9Uv17txUSe
qqSHHykSfFcu+t03wsDAyb5OoWwOmFc8L5DLnMLQyt8NITspuBF7qeiKzSQ2
qe/81O1PwULtz9vvzI/jHWv7Cusi2p971wQc9RzD47NPtXb1UnBliOd35fgI
ui6xjdvBpiBATGmPreYwsssD9Ap+0/5cuXtr5o1BDGPu3/1lmoK4D9bkl+B+
PCVfVCzAooDLxmf9lme9tMfNykWHKJAX+A0HdnRj8ZHx95W0Q370LP7ls6YD
L0Qc2zJOe/rjavXSaa4WbG60nhHMpuBkPudD0FQ9/klVL/tKu0LiFiPRprMa
e7n1hg/S7lp0r2754PJS2uNG9ly0I5x28o99Ir6idJBoqehZClpvOuW9CHiP
x8HidYYe/XkY289dfaaEvQ9zfHtpN7gst7iYeSUFjOdw9wdhCh5R82UCUnmg
SHYPCc3SPuY6Fse/5jscefrWb/EABz5IrZfj9a2Etkw94auVHKjtDjyVfKMW
woflu5TSOTATF7XvYmwD+PGQKXK0E0DxoGLMd/r5uHytsYIrB/IlbibbUm1g
Mi7YwH2GAz4Kd8Rv7+yC2/uKJG7spt1gKKlH6vVA+E3Ve3KSHMgUNSE153vh
t6DtSOMMCdtaWlXlqvph3TJjQ37aAYn9082M1EFIXlHGZfaBBL+a5v3+KcMw
32PJv9OLBJ2JchOhslF4eDhmt4gJCTYxV2oeLZgA6QOxgzfovd7icq2m4eQU
9F8OO9QzTEBwuMDNdZZMGBywv7ubdrNLyRGcDWPBTjmf9w12BPhe9N59J5cN
PuduNF9dR4CztubH4EICDHujKrVa2dAzKc+2eEbCnNanLpdANkgrf/L6c4AD
Wz/uurtqLxvWetTbDJXSPSM+ZUcIxQLrk7XVUesoqLrPSyxPYcHY1H+2h6wo
MPU0emNHz3/MnuW+XwIpSM/HXyZCLOiX3zL36j0F2o4OPU6lTIh7F9rF+42C
8UGPj9YuTEg3GX4XR3tW2NHB5dVmJjgt2Gq6q52C1Fvi1wNSGbB0qoRnNe3j
8xcPfwxcxIAzbMdpSdrPNTtLdA6dmAJv0Y27O+hzrrNS/hnxkzA/nHv8C91T
TWanD2d1TwBK2+ty09ermDftUhedgCT4u3WY7oVt8VO/tuuOw4WFe7O9mym4
ZVglGH1hDIYf3QiiaO9LW4aa3XUbBXbJp7a95XSuqqevSHqOQFrKuqgbSNF9
bSxk8M4wpB0yLH6YQ8EWy3OfQuyG4LzmVuH/9Ykpt4pPGnqDsK7GMMw0ns7R
k4RpO+EBSM+RXrgqhIKbSiIqq9v6YGFU/8aPnhQE95hvrQ7phYwaifI9tyi4
tiIo68qeHkirGLuI1hRESHZ8927sglzH+0GaRrSvqxQ8n0t2wOrKB7Gl2hQI
3pHKMDjfCtfHU3bd3kL3jwaFt4HvmsC7MN/dXJQCfLI9fWS6HhzDieLghbS/
BTmpcKwWTPuanyhOcsDpTeqOU3ZVQN3mv67fwoGiCplTk0dLIcQvRu5PIQce
a873wKkiCLyUtsjgHQfCS3zEGnlz4W/vpM2JMA64yFSuPXkiDUaMNIKl3Dnw
I9ekPudALGzp2fQiw4YDwVnb9CZFPVFAtj54lQEHbt6yZESlvUJ7y0ErfVUO
ZD/bF8m9PQsXGVnqGNM54p9rEcs3zkNVtbQMhcUc2KFj+vdLYhEm3X33pW6C
BJXZn/q/H5Xgkt2RcxqNJLiJDX4PMq3AaHGHhnN5JJRlNQ8GiFaj/+JHh7Yn
kvD+W+S9xba1GLhYaeNLH/r6otSfsZr1aHOLU/76KglpEXvCNv7XiAVesEKW
zt2QpbGfYXcTjihPrORXJ6Ex8kBHY3oL7k9id4EkCeHbCm94PGxDoZBqgVdc
JLg3/1cgf6YDwzOqz6zpJ8DnlFtSs3oXBr9tZ3p8J+BBhJFBtHQ3ankGY+JL
AqQnA/IbHvdg4j2FBDMvAvTuxx7a5t2Lru5PDl+2JODNWNsOyYA+bF/BLRGt
ScC7fx7TY7H9GMoST49cRcDWn3+LGVkDGFqrf1RwnA3cAXNtD1oHcdS+buNb
eu9YXrRePsA7jJOz713GnrAhf/+Kd5sOjWBlpnyTyWk2PHEV0ZqLHMWHfD+e
m6xn0/3XIsKJGMO4yunj+4ZYYBG52Tjx7ARmJY4ttE9iwVRPm+qmhkl8PatX
/8eMBcY6d8//OMZAe643nA28LHi5TIwMs2WikZa9q2A6E9wv2agbr2Oh4OyJ
ZWwDJkhsKl8h0sBCD8NSE57vDLAxHTDKcmIjGLx302qZgroaj/QyHgJbMjfz
WDVOwsuD/zrvehFIbn5g6vZlAtTefOpgjBD4JTQwOtVnHLImWpSmdpE4uycr
Vk97DGStqzrcHEns+Tz4qLZ9BMqO7RdZl0DihHxPy4lzw+C8qNzWuYBE76yH
t2MrBiH//cu6ZtrLZw12KllJDUCjbuKsdguJV8Q7S0It+oB726sPJ2hf5xrN
CGuE9ECMW+S9m7THXywjlkRc7wJw4rZKLSSxu9lF/XJ2Gzh1je4dTyWRI5R7
oep3E0QHsh4OR5IofsuS43KgHsqUa9003Gk/O6RtLjesBrGBmsmz50jUFdur
Gri3FLRe/3FJ303iI+PGUOfmArgVPmTgsprEjXvrExKfZoDrgQvPB0kC/wVo
2nkZhoFt5Za8VdUEjmw4cPCKcDyq2bO/r0gi8BSX4oiraxbqRXgtqHUi8F5e
TZeAECJ3FzNJm3bPiLd47IZtJcgU9xFSFSWQmaW/f0l2JUZkP05y72ejvkUY
/+UVtfhZISSn+j0b7dajj0JePYa82qBdc5ONZpu+xmdZNmF6i+CLFapsNP95
7Z4jdyv2+K6p5yNYmOJuy89+3Y7RtWnf1r1noYK3JW/OUToHJf1EsAULF8kc
9DOZ68YLDplmt/lZKHaGuyT7TC+e3HX99dcMJjq/GVTBoj60N4y4Ln+UiTsG
1ryhtg2g6dEskdBCBu4n1ixseDOIURNs7ZYfU9ga1Ctrv3UYCyrK95zLn8SI
kcqN0gUj2KzBY7bsyQSqnxOUPW4+hpv3zrTHaoxjQZLO5SraT5s/2ekuxVEU
CJVJVX03iR/XN8iKiI2gVIn8jlfHGajWFuEnpjuERR6W6YXOTDRX6XSu2zeA
x0bvqIVrsDC3aqnupjV96LL82eGicRaufvLkQlZiN4qcS62U8Waj78NlW1p6
2tG4/PMj/yW0T3P+zXjyNKPjQ8PIQw4EHnRI9clRqMPML5Z1Q5/pXhRd9nru
ezlyc139a8Eg8DrJp1TfWIAnInWi9wiRyMUQ3Lbe7C1++35d8R/tZYVSfqWg
t2GgEhHR7E372mAdprn/zYHqiUfdQPv6Nbv6hPfRYkjm61RjbSSxcplEm45T
FVw5FlTTL0z7+4VG9b9vdTCt5lrImSfQo9F0s1p5E3Aq1VJSBwh8YbGvdryx
DUwn1JQPfSdQhify0TTRBX+SM3xL4wnMNW7SvifWC/XF0jdHbxH4zbTiqtyR
fpAorgvV2keg5+JwXng6CBff2ikL8BOYcOO52wO+ETi55peRSzUbpefOmTS+
GAPzYocYA/r3Irp1J1LNJ2FN3vo4NXquNM8nVc6KMmFvtopCZSs9J0RQlugj
FrALFMvwGguZm4oJx142mF0wXnX0DxOjDbWenxImwc7n+x8HRyZeWni/3ns5
B5J3vRcIrGDgiar1p3d/58DI8Y9HbYOncOPXZ5kn9tB71nHATk9nErX6Zwvy
Q+k9We4c19Y6jkLLjB+Gl1CwQWHxnJDZGCYlnP0XRTvDRbPaoxtH0KtrftUx
goLAISiv4B/GO2G3Iwja12fdXof66AxizDsTQpf2Nc9d/ubjZ/ux/2vv7tVM
CvKdzV1nbXvR+oLg9/wBCu4eaEyLKPmFcSdTUtfTDrm7cUi8NbUddR0Fh5bS
9w/9iRgd1ow5X0siuDMpqG17OJjsWY/2phs9/OMoaGfP6OnyVmOZ6XbruccU
/NcXmBShU4LxMd/5k27QPvdz+vPjQh7KqMj8TTGn4OCGmhpDv7f4r7VdSmMf
BTrBV/tXHHSCuKTLvha0G27PmnXa7v0Afc+ONq0TomBrQbGV4b2vcMB7+Xr3
GQ6o7lnaJ1T+HZ4E9UdY9nIgh3XoiJdyFexzNzmcW8aBxpBmN4XSWrj872ud
fSoHjrX+DKmeagAvpfwN+qEcyL1vKeMh3gI+T9R2Kjlx4B1VUu94pB32H9Fb
NniK7j9SvOvtnnTBfOvya5s1aL+H6J3ad6sHSgw0zn8Q54CY8k+bw4p9cFN2
oankNAnNjFCW/b9+UAz8Fc9fT8Ko8I6/Nb2DsL7MaIL7HQkv7TSlLvcNw/OK
ZYIed0lYZC12VXHBGLwxXB43dpSEG3fzjUu0J+DOSdW00tUkxGZY8wdHTcH4
5cHy1F4CFsZ+Tna/z4T/RKvePUoiwP60KIZkseDfAE/VK3pPR9marUhoZsMe
zxvEkDgBNyQTi9LbCJgNiul3r6X9vLWExy+d9jXmF8c/YkNyuY6t0kkOCBxf
uExZgw3LX0ZqD9ZxgNjXmZM2xYIXITXO5nIU+MauPryF3rstX1c159hSkCTK
CPc4yQKJnXJpD2g/8ihc2m/Ox4LPV12M9NIouJ/nsdKqgAneM9ehpZgCr+Fv
i2WvM+EReO1tqKMgtyHKV3UtE/qJitBZ2tf3/TU0FJ4xINtVr9GX9nGszdMD
oewpkLKdadKn5/yF3cnayL1TkPGF73cdfS7a8iRii/8kaIcZFHnRvraR0e7X
qpqAIf9E51fdFOydV32UQ/cUyrxa05b2dcP9s90Pt45Dkswx3cEmClpWTL9J
NhiDgnOFsJP2tZfeyBtlq1Hai9x+NmUU5BwL97e1G4GL52xfOhZQoJXoc/uT
xTD8e1pO71cK3Ey4944dGoJlszc7dd9SMMsbmygjOwgFZeaRC+gcXDe5o0eS
/bDWeaNxQhB9/8zBNodPfVCr1iIh+4CCP4HVsauu9UIeBopH0Llo2XFsZb9k
D6x8PKs8bUlfP3JD/lhAF/DNnzhtdozOhdrnpT8b2yFSs8nohxbdZ17Lsh1W
t4Jj6I6VNvT/E3PorKGEdROoWdh37qR7qGNuBWWaXg/aSf/JnOGic7r2Nt/Y
0loQWfz3xPgYB45wE0mZXZXgoPWnf6aRA/EJ+ybTyktgrL3u+PMCDpRmpB5/
1VQI4bUXE8eSOaD0PEZPmP8zSDRODowHc6AvPTYwxz4VHLY84Uuje6mD+DVd
U/9IqFjp16FlTXt76O+Z52a+mK58fT5WnwNvtTxH191KRgseF7kfO+hc6fzw
buPPxiz2x921qznQKrY2fof8V9ReyOPxciEH+neNCIfwfUOry6dS9o2RoLGp
UOXzRAlWi6RtfV1HwsLRvwJ+eRWodXGb5LfPJNyaC+4UulONar0WBv7PSajg
TddTj6rFzmWqusQjEsz/peVfdKhHCeKNzOhlEvb/U4jP027EBRfC3M2MSAjo
P8rdsaIZJ/RBSnEnCYEnqGLP3hYMJTryDegcWozGd97LacMW1pXIp7MEfK45
sjMnsAPnLx4fpboJ2BYkFCnt0IV+slXWGkUEJGX/vth2vBtdr948q5lAgHzB
0vn/EnvwjigXV8U9Aja4HEjfmNBLP96TlVLOECBzMXCEmdyHPk0dZglqBEh9
S76Dn/pxeSTXnKUAAQOvP4uN1g0g1XZkTfgQG0YuGSwsnh7EQikt+xa6T/P1
EY8C5IcR85Z6fPZlg0yco8OxyyP4PWShYPYJNlR5K/5I+zKKfMRspIokGwpk
m1Nei43j8tMPA0O6WVDRMi6x8eEELhU5uEvgGQvOyYiueTkziQn2QQZDRiww
ezsqmOXMwM9pq/WAiwVHmk0HTrgxcWnLvJXuaybdN1tTzquw8Kb/5WjZfUxY
Lra7ZGSAhZmr+OQM3zNANeRubQm9Vz2cDgbq5k9BkeRz7lxhAiOPSj7g/zwJ
AUOaN6WDCMz06yfSn07AyhnXyb1sAt0WV1iZ243DHU05cSkdEs9r8pWfWj0G
AbtKP5W5kbit3kRMN3sE+PwP7qx7SeIrF8cjKqrDcO2X2bZq2sO+eeGLlsQP
gn0lLzd/HYkeZoIPYpj9sC1xKMWL9vXhyyVN1LY+eFUsIlXXRGKbn1ylrmUP
KMT/SdKtJnHDcOcWoeVdwObabsSkva6DO0ddDNtAxO3lmewUEht9KvTvRjSB
jqSHxsFwEgcEFj7OH6yDBauku3VcSYzM2r2tK+QHtKytFxM+TaKrDG+fhG8J
7P7A17JWgz4v3Xb30bV8eH9aYiBZhMSyVdOGrTrp8H/1gPUR
     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwd13k4Vd/XAHAhzRo1qIQyZMpXk3mJQmgSoUxlqFBKKkRJlBSlQRQhoSRj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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwV13k0Fv8XB3AVpU0qEilEJdFKKctFKUtKkrTaQ0klShSRCkm+kVL2pbJl
rchy7Wu27DuPfX22eQYp/eY3/8z5nJk55zNn7p37ekuY3zKwWszFxUUs4uL6
/7nm5/8PBsgf+P/RCNMmaasFPjOhtmC1uYpoGyiGiQQ4zTIBvcMMtbo6QFAj
2FZWhQVGh4+1HvneDTqNK16ynVjwsfdldIhxH8jTDD52RLPgdNC2Ip+Rfljg
X9ouW8KCmPESb5UXA+DbHOJu2MECfuXlBdXHh2DBzCS0cIgFrOhj1uc2j4C8
XNtsyzAL1rsYbPJZOwYVlqcC+7pZcInfOBulJsCYb6WPYDUL7LwGeJ+dm4JU
JY3cT19YoBrSFPwkjA5LvP/o0rxZ8MlTbGXADAPWiGfcMrjIgoqmh19ERVjQ
kJCmMy7JAr21c482S7NBTyHec9EIE96EbQl6u54AI27pE+JxTLBnOot9aiRg
V922/fEmTMhmZoYesuZA8kqZL8FCTFhvEP42pZED1zPTk27UMMD/aHCzjgQJ
+X1eu3Q8GHBv8PS91cYkCNlltaw7wIC0G4c22LiRsGHmael8CR2W3W9fviaE
BJ6oh8bnttDhSs6mZ7qJJAxNGN87c2cayjJ7O65+J2EN2SD+O3cK7jlYdDbm
kyC5PttLl2sK5HkGzmUXkYCP9c4fOTIJoWev0yqLSbhRFcT4YTsBl7Vt3J9R
1y/ebZevejkOTUlWV7SQhDsrwpc8iBuDcaN9Eyd/kGCTHvvsd8oo2HI2yuZn
kOAo1aTxNWkE5j9wJWZR+5F0ytpu9GEYiiYdBk5Hk6A7o7do0HUIwsuDPv/3
lgSTdTBZf2oQ3tLMOrxfkFCU0+m5VHAAmtjRr4F637uy51+N1fXD9tfb2wpu
kVBq3epq4NEHUqqPW4RNSeANc+xkGfXAjYbe1xdPk2Ba5e/9JaoTOt9MiASr
kCAf9ubowkgb/Plod5AmQ8LO2Ircid0tUKBjlmEkRIKCk62WiGsjnNq/7vaq
JSS8L7r942V9PRyYLdYVneZAXFD2n9VWP2FSR00yvI0DZOOKiKnj5eBPhBGf
ijgQ1WxivVSnCFwiRQ7rJXHgw52anbZ9PyD4h7Rz+BsOqJIS7/c7psHuIR2+
eDcO+H7iqj4TFgmo93rzfaoeuAYLa2n65lgcxB26Rp8DwjcGlhVaReM6t0LH
e4ocyF1ucqskOA0rTG6lJ4lz4KJSreC+4mzUJ10TU3k5YFDZ8a2ipwAXbYuX
cWMQYFqebFpTWoIrSNYrvjYCHB8unX0fUoFPXVePGCMB8m/dlh6+8hNfrPBl
nvlI3X9o/l3v8nrct2mv5KQfAUn5ha9l+hpQQ1rvldBdAv7eo5mKZDSi0cG8
0kJjAix331h93qsZjw6rhDerENDWEucQfK4VaeFajCNbCejTdfSIkG5HlXvK
Ci08BKzre8XQ+9eBogsC67xH2aAokL0tuLML61r1S2Wr2KDcZr7BB3tw/zJ+
pw8JbOiTbelKNOrDT7HTxnE+bBinbf+acLYfc3/3/BCwZsNFy2HRP+dpKHXG
vypRgw1FXdxN45YDWNUurSYpygadCb7Un66D6PL+Qq00mwXKO1MV58KG0Oro
Sdsr5SxI/XOLzPo5jNqfuhzOvmNB9rukmZ3LR3FtNd+UnxULWju9pAUNx1DU
z2nqwW4WdO2uKU5JHsevvBIp91lMaJzqcdcUnMRkxcjK+lQmWCtlStZ4T2Fl
aYYC2jDB78ZZZ0duOj565FN2W5gJCjZtORLqDOxYmmDLV8SAvW5zbkv/MvAM
/WB8qRkDqiSssslUJgo9mFeJo9NhS9+mrrzzLPR29y7gW0YHkRvbUnGShYqq
60+F8k7D4qTB6Bo7NuYFFR86yZ6E2OtW58Na2Cj1xyVCpWwCepfXjWXIEBg+
fOxp+uNxSB8IFh68TmCHfLOD9NYxmNkscSs+hMCpzwb7fRNGoDXsTmBENoFH
KpL1HESGYUfOWq49NQQOnM2h3bw7CKS5b5htC4EVbWGrdmXRoPsFa//SVgJd
og93uU32wfI3slHX6wnksurJtZPpgW32Nw1+FBO48EJ/k+2tDsgOY9gPpBF4
wp1e1ZveAvt/9zM/fyAw0mLtg86FXzD4TC013oPA+F/Rvy2/18KITpislSWB
SwVqusUjyuFjkIMYHCMwx2h5cH5uASyo7TjrKUHg5qhtMuM7MiHj978tFn/Y
KOvi05svHQbKNnn/LWqm1oxu3ayAIDS2nlS7kcjG96cLvmrvSsNiZYPEUHc2
Btj710Q05+Ip3nwxzzNsVBORMHwtVIKjs2JbZsXZeF6YsDSIrkRhzZhd1VMs
HK6vWEhdW4f7DpLrvn9noTKfz9lDB3/hyjfO3lZuLOTU95IpXU2YKpu5w06d
hdyNdl+/urfiP26/PG0uFs48kpcv29qBWmFxv8x/MHF2h2z/9couXHVdz/6v
PRPn9bS3Kt7vxdX78oSUNzOxvEwueUCoH78+lDm8sYSBXZEjg2ddaXjG9oLa
ZXMGLm5TNYwcGUDfO533lafo2PMmQ/vU1SHkkpVNd16YRl27rDGfvmGUVB7T
yCGmkOtD+fNB+1F8o+B1k1M9iaUWO5+TvOMof3RPwYj7BJpW2zwaSJrA7TI+
7U6rxtEx1eJotdEUTnUlBshRz70UvRyizUXHS3GL7JbEDONMggixVZ/al2iF
2p7EQcwo/bj2myATpbtKyxk+NLwvzvOjooqJ4p+1pIY0+9ApmLeFYcvC7GRa
6MGGTlTM9X3lT2fh4jVfGhJ+t6DN/lyOw0U2Gr/83Ru45Rd6HMqRKqW+W5LS
LTN6RBXOVz6d1h1mo+6rTXcyFQvxrVRtzPPVBGaG9pt9l01F3h4vzowUVYcn
yGWbzJ3h8f41OSl7CPyp9iN+ICUdeNqKnu/aS6Bh/WdVv/RC+O/0xX/60gTW
LrposKS/ElY15Lo/Fqb6ILA66N9cPfAWHb6SyE2gGLcGbWahCf4N7uSyGWfj
/qqko+bL28Hp87j1omo2ntwzsIIj2Q3OMjtjPT6yMUK+ZHhDch8syFgkf3/I
xhes+b/iXTQIGYu8dFiPjZPb7F1Ntw3BuxUpz82F2NjAl6xY4j8CGyUkV57t
YKHs6X8bv4qOQxZwF00HsXDV9rnan3WTkP9NX2dIk4Xar1qHl0bRoa5E6kfV
BBOvznp9t1Zlws1v36d0nzKxpkm+uCuCBTuSY166r2Ui//Z6s3vdbIhvz1ut
EMDAwX2Gz4FGQPAexSXzixjI5k7geRDHAXaKrP3lumlMvlP1u0qWBJUBIvbr
kylsCxwfCX1KwosvnutHxSdR7tzmYd88EkIEQzvn48ZxbRPNg6eXBCJuaKB2
7RjaffI/J8kkYevPpdbFFiPo1a//w22WhMEs/uyToUMYrtzwaj21Lgti7zLI
G8CRXUR0N3X/ydK3/BeqqP/8xmVeKiMk+Ghck6kI6EXHFwd3KrSTENHf/IzH
tRNvXZ2I9q0gQSLrU7qWaSvmaD9s6vhKws1HUtapJxuR20FzUUwUCUbORhNp
QbU4NK1XoOlHQo/t4ePyhWXouu2MON89EnRkosTOns7Hslnm1f0mlBvqS1v9
5VKQ78Oy2JYTJEQezDQUsHFCgcUmX9fsJWH0ivLDEeIz7DhQfHuIcsOO4oZa
HMuGkzFX+wz/cUDj/U2vTV7FsGjpgYYzwxw4lKl23IaohJcvng2W/+RAg37h
0yXS9eCgJin2IZ0DLumzB+n6jXDt1+q/n95yoML435J8lxbQWR3AX+zKgQ6a
2d83ie2QFje+P+sq5YhGTwO+8S6oYWSe0lbjgHtFb2bklj7A/b2NspQL3ifY
Hr/R0g+nl8/MrVwggKVpddglcgBKiVYJj3YCfFoPGC/yoNz1zmJhQzoBl8X0
I5Y+HIGbhm0l2s8JELQr7isIGoPPq4YC/ag5b5TmfPn2zwnYnvrezGgbATpR
F464iU+D7h9/5SNTbDi6kecscZQBnKMqe1elsuFM28+CK85MsBCPWLzSng3y
hbOvGqk6VO2fODmzgw0iYlJvdan5zjnkPjzbwwL3r0+emPkSUGD+gtALYgGd
D++dPcKB5VEpm5laLNgo5zjAlccBP9atjfZ/mRAs+Lj3nQgJq/Oqn0+kMeH7
XOEaq8skJEYM8upeY0Ie36G/Z3xJOHVqRaWmCBOk1DdzayWQcDvugY8b5evy
9OhqmwISNosvKLxwZ4BAkduQVx0JAcXXvOb2MEBfvVnei6qzEgcbvuhcOggL
b1BMp+p6HcdFTlqADuz5P0VMGvXdv7ilPraahrVRUht7B0go/2v9IzxlCv5d
DFEfpq4PG8lZ32JOgkugQfWZPhJECjZd6945CSsMxEMMu0i4Yh8c2nJ+ApRN
Zt/xt5Kg15VhaOgyDnoG5Xc+1JPwSTvm6rWAMej/IDG2qJKqU+b9U+oho0Db
9OqBDrV/BUEy8HTQCBxK5bK9/42EP2xu72Mew+A23v6fN+Xtk3KROXtMh0C4
lWf+YQQJS9Ztm325bxDU+EK0DV+TkEFflG1I0qB+qcsyfi8S5OZqK4mUfuhc
uSkl05EEV80Td86Y9sGTFKNrOpYkbP8e+cxofQ8M8vSc7Tag8gW/7k6uK50g
cGn4ySM1EtwaigbKo9ugkJ9uoipHggfDbW/aWDPATrlaBWESDvSonzY42Agn
doiIuHKT4J1EFwzzqwcTy56f2+gcEHj8LcS1txp+qk6/O9nOAeXNsnziJWXw
jHPNgbuYAzsuWr7WrSqEdo5xvwnl6y2PlhXeHMkGYaemV/aUr/PsP5yp8kgF
ib8Wq1UoXwv87api+IbB2Xq5vKZrHOB/LGZ8/sl9HDQMpymd5kCfu9x7w22x
eEBOodDpEAdC1ZuNNt5Jx408v0o9xThQ//gjy+/dDzTPYaSZLuMA7brkjOqJ
QtwrcbB4BZ2A+EnOQUPZUjy2RKfxQQsBW9S5Ih8tVOBe+t6bsXkEJAfslC0t
+Ikvj8m2uMUS4CvUY7pVqR6/cH/knafqPUYe965f+wv784cieO9QffdjxYnG
gUY8tFInI8iIgOmD/EqrvjZjksx/ET5KBETUnChyetaKcZcsc2vFCLDyusDd
fqEdX4QMzJ9YQoCEe+hZgX2duHGv+Z3mITY0jcQIi/F1o6DOWI5BORtsCx6k
r2b3oPlDV/3gT2xwpCVarbjTh34b30TcfsYGpl52Tal9P1a8lVubaMEGwwet
HM5dGmY2dPxaCmww1ajYPuIxgN9cpJyUNrKh+HbgEkbIIC6Zu2zMmWZB3oG3
ntZ5QygaH0VvLKLysUuJZuDUMF6OjZqwDmTBk/gbOb67RnHVbr/b+0xZ8N3T
JmCF8xiuFxV4Ey7Ngvi6hqIDjeO4esrAb8UkE5QKprQOKE9izWIrnvx4Joy+
5WpqSp1C/sbXN5imTIir89VZI0fHB7GF8Q38TMhvNg83OsfAY8ZqGc+zGBBb
L9cSy8/E1A8OuzXOM2D4iaPz7WIm3p7lC3Jro8OJjCNTPjYsXMsjZ/1pahpo
biH+DvMsjLPLOdw2OQXcgY8Gdj1gYwFN5OD65kkIDn+gGtnHxgrYneUSNwHi
i77nuu8n0LOz5eS5K+MwoP1m8tttAo9ZfxPY+WcUHDxoblVhlFdtc+vpHiPQ
Xvmp8GwugZwxPv2L9CHIUL7AnVFL4EXbM9vXHR+EjxtYlxiUr9cNq+YMetNA
94bouWxqPb+rcEtJTh9I+G9ZaVdH4O75tSlS5d2w/Kb7x21FBO6dsH7vtLID
HAQctOtSCBTYsEnx8ukWsKrl/7mD8r2qdodAfugvkBIdda1yI/C1ekD7vZka
UHNXKDpgRqDG00e7ng2Wwa01voElagRml643W85bAFkhBaqlmwkc1tsS8rEq
HaRrGT3Ws2yU/6sQe2LgLYz5dj+sqqe8LOz5wTI+BIXGrBtnKfekKFmBhnU6
OindjZtyYaOnfGxnMC81X4fngwNPsnHGu01EPrkE5SU/upduYmOwwle7Svkq
3Hf1455ToyxcsqjaPzWqDp/wb4wcSWNh++PfykaPfqFoi9qzw84s9NorVa8t
2Yz8/2iqrUdYOPcr/PSOslZ8R5/gVplj4usNsq9v2nYgQ/ew9c90Jq5dyaf1
ib8bdXMjyPJrTGzd6lhmi70op6Qtf0qAiWPPqrZ/Uu7HhSMKo2d/MDDFVKeZ
EUnDJ24RR8PPM5BP6NJuDb5B3DD2UNG1mY4/uv19hZ8N4b+liXcFBqdxv3Wb
bfDyEXSu2WKn2zqFh8fP8SmEjKJtdUHC8sRJ3BW7ec9N+XE8+cg1ke/SBIZu
7Tp9oH0C82ISvLUGxigH/dGwpXw1V7Fq0FRtFO8fkfY2l6Xj+Ep/Vbfbw1i1
2CPT1IqB3A1br0o4DuKDvVYHn+xkonysUyrtFA2PZ0ised7FxM23Ng1/W9aH
+Do+atsDFkqoewu263fi4gsfE+aputZ6eKEo07kFz83WnttsSflzaeHAwbAG
tPnG8BxJZ6NLz90DlVGVaBIhzAUTlGc1CztAvQA16tI9E/mpnBaftYkTkoT5
CVPCcdspXxc8y9P77guG7ruZeyhPX07wXWRxNxOKbA7YZFHentaZu/jbvwje
6yw/IriDwK2KGnuLs6tgadBmifdCBBbe1hJysmqAX3a0dbsXExjXX/TG63oz
mKa9ZF8dofpsF8No0712aDon/vp2ORu/bW7dxR3YDZlTiyOuRbNR82ltms1w
H3wXLFy3wpmNvwKuiA0KDUD5ieiq8RNspD2/I6FkOQSqMr8drq5lo9B221LN
hhHQZD3wd2tkYYzGt1fSFuMQFJjIln7Jwr2HP2oPC09BzPi+Jl4VFj4NsPaw
nqKDaJhEd1o/E4PHy3w0LJnwYjqopvUBE0dEa36KFrMg9bqXaxQ3EyUvnPQI
n2dDFx1+sz0Y+Pyt3OOMOQLOv2m42jFIx3rtNZEHvlGee6+VXp88jfemIlv+
HCKBVN/2utRkCsWfNaSXUz5d2PfPxOP3BN6zPFPLKCRBW8GH69/DcfyccIXb
p5+Ev70HPbcOj2JGWh7HmEWC2PBYqqXCCG6TeXumjPL0lqurRi/dGMLhwvdE
4gwJl6XO9An7DuDH0cogJoMELc7ij6fe9OP+4ZPvJoZIyLq3ejlI9eILWf6b
QZRDXKP9466s7kSBuxd3JZeR0BV99EgzqwU/eWxaX5dBgngGuTa07xf6fl64
5Ui5omyDxvYNhTUoyW2g8deHBGWnjqRz7FJMjNc6mX6XckA6eVe5IBcznS+W
l1NOc9RevXhGOgl5/XzETTVJ4NLYfvfzZ4DDL4I++1NuMAvrOHK7OhHyesR5
LgqS8MxeeQh1c6BYuFAx/w8H0m675N3YVwJ3HGN2fRnggOxRPu11EVVAxsuk
CFRxwE2vQyvwYT0oLWL/a0rhwFd8tUo/rhGeflpVUxXEAW/6moev6lognedg
daUzB7Q017z2XNQBCX03O0IvccB+pP5ajXo3PLt2voxbhQOVNl9u/9Sl6uxS
Xfo3UQ6Y9KlY6/HQYGzdh8sXfxMgW6Ni5tkwALfpy595NxPw3U9sS0TmENw7
53e0KpkAO668q2HpI3B6MPLRe08CJpzNtgbUjoHg/RjixlkCah9oL76xfBIm
NX7s+07NdcHmqNpVptPwi39eXGCEDVVn34SetmTA8XOX+E3j2VCWwX1L4B0T
Dm+hdw1fY8O13Kytx/JYcNfogMI9cTYQU8IRLcVs0Ph36odyKwti5LY9WRxB
wJ0PxzWd/FjQobcka0abA+U7oXeNOguirdYnna/gQOZYur8fhwk0jWPhoVtJ
cL/ybvfyBCZIKARm/TMj4UGS5W+zq9TcbS/wO+xPwq9Jv81665iQu3NKbiGJ
hD1NIkk3ShmwVpX25HgRVdc9Rv4G9xmQk2N4s4zyrFjkfyX+OxhQGjpgYdBB
wo19lz+cSqTDaR2TcWnKxx3Ggn+VFtOBr/XOZinK0wXd9qv7DKbBDGINO6i1
2KNXe+RCp8Box4anGZSvc2WzV/J3TwL9eemVGcrngnMWF+4KTIK/EldWSycJ
RbC7QFN9AhoLAngdWiivD8ud8TQfB7PZ9sFuyvsFbNZvpftj8PAd/6ntVI4M
FSI3JrmNgtbhVYfOIAkztuk1R51HYG4oK8CUypVtK3btQYthmCnjWW1I5YmB
Tc4uiupDECBamC4TTsKJpwOfFdcOwt2Le3QHA0iQkn0mWdREg3cWd2M8Pak8
4DStZfCyH9IGRwNWUH3xZafD6VblPiA7T0R7mZPQMJGbcqC6G9bvC7X9q0/C
CmJL9yGBTpi7KXruqSoJ8/e1dg5caAOdMFfRvbtIuK4cXrc3qhnWtPS1rady
KKpYin2e/gWdezljJxaTkKCeeX/H8XoguSprByY58PMc39IX56pB6KOY4EIL
B5revjYLUCkDX8079xMLOFA2nTZ98UQhHA99rrAQz4G1Jxz6ucayoF346Wee
QA4o+ld5hQqmQNhLk5W1VC7NxJmvf6tD4Ot/RXamlhwwHjoqpMz7BOt0lPKL
TnJgawZzLdd4HHZE3OTMyFO5OIp476CXgQJSwwpcmzmQkBxn/+BWDj7cvudP
GzcHNgpp+GmnFiIRkn3s0SQBc2nSZuqBpbgiISdhqJEAac2YsjCLSrzFOfOQ
N4cAmmnLnetSNRg297uwPYoARxlxJzO7ekxbOX9I15sAjdODD8fUf6Gpt43i
SXsCBnYIxdoJNOGl9++CKqm++xml1vpmqBmF8dblZEUCohibHLd8b8XpsPz/
ekQJ+FfDk9Dg247GWy6VqnERsKvr5pEA804Mt9rwIYPGhpx2fWtDtW6stBXY
t66EDflHT5UrbO9F/HP72v5YNvjWuJ44+KIPhTkxfwY82XDbq7Y23qcft/0a
86ebsOFrbY1I5ivKGYo2lwSV2LDq+qeW6PABvDd9oXOlABtCOy6r13wfRDsd
wV1u4yw4dsDfzadrCKcPOWqvyGfBoZuaLGG+EfwdkasO/iwQt9Gc8dcbRZBH
qw8XWXA8XcD63Ycx9LG92e67lQWBLfJnNGbHUYKnr/naEBOO35Dd+958Eo/t
qN5/L5oJxrX7+NTappC2l0mjGzPB73LuBNuQjoSF7iIuXiY8mRPi2WrLQOfa
tIi6Lwz4veyyTLUkE99sSw30P8mA7pK9ZVbNTJT1+0/3dwEdRPKrGyopr5mv
HN001DgNuzwV979bzsZ0u9GMnPopSG4QmFz8lI2DL1xGnnybhGvCoaE7xikP
3o0zsPCaAFf5oqmewwRu8X5qG3d4HK7ZMipk7xHY2j/8qr15FF4cSdUKiyLw
ObPgwvILI+DoVfiwLJ/AhdrItD/FQ2A7/t9prnrq+Y2f9rtsHASD3tId2q0E
ts0cibO/QAPm+9YYTcrX8j+2+I/69gGf/N3rJymP7+H3iMyx6IZAk6OfHQsI
3LbMONjjUzskSIWnRCcTqFil8Joz0QzRQ95X/gsm8F2JS2XzkV/gnerxps2V
8rvIT5sNijXgrZOTx7xC+fxvzPtXMmUgw+W1UUmFwEtucqJLP+eD3mDQ89/C
BLqtsT1VbJ8GswlfOCYEG+sv6IVvjXkNYjabbz3/yUbnziN6gnnhKHfBvtOF
co/Saf8FoegMPLWCdvzAPTZelNiw88URxMFTXckhlHvUdMwirTRK0SFrTu35
BjZ20FoG+suqsFeqRqSUxsINQkpFaRvrUUJS3XRlEgszX0oMny/5hYn7+4r+
3WGhRvmhJ3W2zShxdezCAXkW1h9TnXy5qg1LHSxLxVhMNEl6K7M+tQMf0w++
kkxkYvSORJmJ893Y6WRT8ugqE0tGsla3LOlDuysrGrRWMrGgTNPpvlk/WnxU
rXZMZaCkXmJ1eBkN3ew+hxSeZGDNvaiPs/KDuGxQP+puHh13p0lMzicP4Z3m
R8kmldOo35zx48f+EXzw9gLNPXsK3ay+HfxQPIp+c7TX33wm0cH88mq2yTiy
VsqKFytMYFjsFslnPJPoa2aeGJE9hsu01SbJlClMTKopWr9uFF0fj5zQN6Zj
2dUyYxeVYcyM+fbI2YWBqjz/HY9QHsTsJeyDwipMDHQhXB3X01Bm/Nrjf1NM
fKhV+cLndS9m7gSLld4sFG5RmpKv78Amna46IV42tujnfvlONuNb2XN2rjfZ
SF7j/b5MtAFTyiwCy7LZKG1wveREbAVaquvcnKOzMdzgu5TcGyoXmRUIRK0n
8H+vQQ6T
     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJw113k8VN/7AHBLpQjZS4hISqWkXT1tSpStSCEUqSSFpChSIVqElC1rkl3R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     "],
     VertexColors->{
       RGBColor[0, 0, 1], 
       RGBColor[0, 0, 1]}]}, 
   {Dashing[{0, 1000}], Arrowheads[{0.04, 0}], ArrowBox[CompressedData["
1:eJxTTMoPSmVmYGAQAGImKDYGg8/7YXTht6fxW7s/7q/e8vvsO4uvcPEzYHBn
//aFbDppzZ/2/36w6NDUsIdweRMwfdn+r4/6D7Hqz/sFi7kXPv9/wh4mfxas
/4O98w/3I8eLvux/9GFnfsWV9/Ywc2HqLpx8d8b1x+X9ppy3Ge0cv8DthdEv
ygr/cly/vv++yOGQjHP34OIw+/8rf9E9s/X2/gVpHIzb4y7AzYfZL3axLK5/
yv392xf/ZX778IM9TB/M/nUb73TcNLlt/z52l2mvJ8JfMHOmsURFiIVdtz+R
7qCy9P0tuDyMrg+/rh5cftl+u3C3YZXtFbg4zP4LISvfyRuet//rJ3dh7s2P
cHGY/VXbPi0tnf7ZfuWmmZl3Aj/B3Q33J/elm0fmf7LfsGvv54cC1+HyMHve
xW/kFVnx0f7cAd4kW5kbcPNh9MotExyTN3ywd/plN8fv4id7AD4rInQ=
     "]]}, {{{}, {}, 
     
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwVm3c8Vf8fx5EQ0qDQQFLZlDSQd5FIO1K2pMiW4ltWEmWU7EiSTdl7fuxr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        "]]},
      Annotation[#, "Charting`Private`Tag$6353#1"]& ]}, {}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
     TraditionalForm]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->Medium,
  Method->{
   "VectorLengthFunction" -> 
    Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
      System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
      System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
      System`VectorPlotsDump`imin = If[
         NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
         Min[System`VectorPlotsDump`m], 
         Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
         NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
         Max[System`VectorPlotsDump`m], 
         Max[System`VectorPlotsDump`m]]; Map[If[
         Or[# > System`VectorPlotsDump`imax, # < 
          System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
        System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
    "TransparentPolygonMesh" -> True},
  PlotLabel->FormBox["\"EG+\"", TraditionalForm],
  PlotRange->NCache[{{
      Rational[-3, 2], 
      Rational[3, 2]}, {
      Rational[-3, 2], 
      Rational[3, 2]}}, {{-1.5, 1.5}, {-1.5, 1.5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.842255893501729*^9, 3.8422559516370363`*^9, {3.84225607832467*^9, 
   3.842256092896615*^9}, {3.842256166303149*^9, 3.8422562179602547`*^9}, 
   3.842256251646392*^9, 3.842256330515581*^9, {3.842256442758244*^9, 
   3.842256478058552*^9}, 3.842256737221937*^9, {3.842257779470612*^9, 
   3.842257823595839*^9}, 3.842258008637545*^9, 3.84225804371808*^9, 
   3.842258083626482*^9, {3.842258163126957*^9, 3.842258191645133*^9}, {
   3.842258300753871*^9, 3.8422583071100817`*^9}, {3.842259068211711*^9, 
   3.842259072289281*^9}, 3.8422591447465057`*^9, {3.842259308736352*^9, 
   3.84225933049012*^9}, 3.842259376478981*^9, {3.842259668781228*^9, 
   3.8422596794430027`*^9}, 3.842260087755558*^9, {3.842260136779088*^9, 
   3.842260170303474*^9}, {3.8422608347621613`*^9, 3.842260858349124*^9}, 
   3.846147035102055*^9, {3.846214982524981*^9, 3.846215031814941*^9}, 
   3.8462988960477057`*^9, {3.846575192754656*^9, 3.8465752096860323`*^9}, 
   3.849938244962203*^9, 3.850196412980701*^9, {3.850197668095614*^9, 
   3.850197845483735*^9}, 3.850197921364224*^9, 3.8546875163685703`*^9, 
   3.854687870738076*^9, 3.854688443077024*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"73be76b7-1793-412b-9b5c-33cb47b906aa"],

Cell[BoxData["\<\"Figs/Forsaken_EG+.png\"\>"], "Output",
 CellChangeTimes->{
  3.842255893501729*^9, 3.8422559516370363`*^9, {3.84225607832467*^9, 
   3.842256092896615*^9}, {3.842256166303149*^9, 3.8422562179602547`*^9}, 
   3.842256251646392*^9, 3.842256330515581*^9, {3.842256442758244*^9, 
   3.842256478058552*^9}, 3.842256737221937*^9, {3.842257779470612*^9, 
   3.842257823595839*^9}, 3.842258008637545*^9, 3.84225804371808*^9, 
   3.842258083626482*^9, {3.842258163126957*^9, 3.842258191645133*^9}, {
   3.842258300753871*^9, 3.8422583071100817`*^9}, {3.842259068211711*^9, 
   3.842259072289281*^9}, 3.8422591447465057`*^9, {3.842259308736352*^9, 
   3.84225933049012*^9}, 3.842259376478981*^9, {3.842259668781228*^9, 
   3.8422596794430027`*^9}, 3.842260087755558*^9, {3.842260136779088*^9, 
   3.842260170303474*^9}, {3.8422608347621613`*^9, 3.842260858349124*^9}, 
   3.846147035102055*^9, {3.846214982524981*^9, 3.846215031814941*^9}, 
   3.8462988960477057`*^9, {3.846575192754656*^9, 3.8465752096860323`*^9}, 
   3.849938244962203*^9, 3.850196412980701*^9, {3.850197668095614*^9, 
   3.850197845483735*^9}, 3.850197921364224*^9, 3.8546875163685703`*^9, 
   3.854687870738076*^9, 3.854688443853499*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"a75d45c5-1373-464d-81d7-4d16b0e2117a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "=", "200"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Alpha]", "=", 
     RowBox[{"1", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Lambda]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Tau]", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Nu]", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Sigma]", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Gamma]"}], "/", "2"}], "*", "0.99"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Gamma]", "=", 
     RowBox[{"1", "/", "L"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k", "=", "10"}], ";", 
    RowBox[{"K", "=", "25"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Wreverse", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"-", 
      RowBox[{"W", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{"SolveFlow", "[", 
      RowBox[{"Wreverse", ",", 
       RowBox[{"{", 
        RowBox[{"0.2", ",", "0.5"}], "}"}], ",", "T"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"iterates", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"CurvatureEGPlus", "[", 
         RowBox[{"W", ",", "init", ",", "T"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"init", ",", "initialPointData"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"prox", "=", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
        RowBox[{"Append", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"Thickness", "\[Rule]", "0.005"}]}], "}"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{
            RowBox[{"orbit", "[", 
             RowBox[{"[", 
              RowBox[{";;", ";;", "1"}], "]"}], "]"}], ",", 
            RowBox[{"VertexColors", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", "Red"}], "}"}]}]}], "]"}]}], "]"}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"orbit", ",", "iterates"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"starts2", "=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "iterates"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"plotFlow", "[", 
      RowBox[{"W", ",", "side"}], "]"}], ",", "prox", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1000"}], "}"}], "]"}], ",", 
        RowBox[{"Arrowheads", "[", 
         RowBox[{"{", 
          RowBox[{"0.04", ",", 
           RowBox[{"-", "0"}]}], "}"}], "]"}], ",", 
        RowBox[{"Arrow", "[", "starts2", "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"w1", "[", "t", "]"}], ",", 
          RowBox[{"w2", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"K", "-", "k"}], ",", "K"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "\"\<CurvatureEG+\>\""}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<Figs/Forsaken_CurvatureEG+.png\>\"", ",", "%"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.842255034436146*^9, 3.842255055711933*^9}, {
   3.8422551171775723`*^9, 3.84225518995469*^9}, {3.842258218438591*^9, 
   3.842258239079123*^9}, 3.84225909058992*^9, {3.8422596939224463`*^9, 
   3.842259763877337*^9}, {3.842259897403494*^9, 3.842259907781207*^9}, {
   3.842260095920251*^9, 3.842260099452983*^9}, {3.842260175910911*^9, 
   3.8422601763764544`*^9}, {3.842260238364037*^9, 3.8422602386691732`*^9}, {
   3.842260277884756*^9, 3.842260428886235*^9}, {3.8422604741742373`*^9, 
   3.842260497160059*^9}, 3.842260548760397*^9, {3.842260702010556*^9, 
   3.8422607813041058`*^9}, {3.842260823260478*^9, 3.8422608247817*^9}, {
   3.842260870024293*^9, 3.842260871300672*^9}, {3.842431626328824*^9, 
   3.8424317146192923`*^9}, {3.8462150445918627`*^9, 
   3.8462150486486053`*^9}, {3.84657521407722*^9, 3.846575214783814*^9}, {
   3.850197877435403*^9, 3.850197913973687*^9}, {3.854687519281102*^9, 
   3.854687549010069*^9}, {3.85468775224855*^9, 3.854687754860714*^9}, {
   3.8546878011330013`*^9, 3.8546878060494757`*^9}, {3.8546878728562*^9, 
   3.854687873992015*^9}, {3.854687910643365*^9, 3.854687910914865*^9}, {
   3.8546885026000433`*^9, 3.8546885120049477`*^9}, {3.854688813646214*^9, 
   3.854688813794299*^9}, {3.854688885615902*^9, 3.85468889276929*^9}, {
   3.854688946906612*^9, 3.854688960264389*^9}, {3.8546889910088*^9, 
   3.854688997497847*^9}, {3.8546892109694643`*^9, 3.854689237072304*^9}, {
   3.854689562034709*^9, 3.854689562862485*^9}, {3.854689811583969*^9, 
   3.854689905834342*^9}, {3.854689965669438*^9, 3.8546899658983517`*^9}, {
   3.8546900042308073`*^9, 3.85469000457339*^9}, {3.8546900377454844`*^9, 
   3.85469006696767*^9}},
 CellLabel->
  "In[629]:=",ExpressionUUID->"00868d79-3639-4ad9-aec1-91dd8b258d69"],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.12702486321737294`, 
        0.6825502504445621}, {-0.15859867017162593`, 
        0.6835370446319317}, {-0.21401826075772262`, 
        0.6657984934378398}, {-0.23802224083322843`, 
        0.6414453595762438}, {-0.2547094630415601, 
        0.6057462889216412}, {-0.26181673868907707`, 
        0.5584941055939887}, {-0.2598446627503448, 0.5297250019187422}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.25943433527913057`, 
        0.5237390490817774}, {-0.25791901982696025`, 
        0.5016332738994}, {-0.2514094962393709, 
        0.4708056979947869}, {-0.24162817456587132`, 
        0.4390232596947784}, {-0.22880215066296467`, 
        0.4068867115491709}, {-0.2131585203871542, 
        0.37499680610776115`}, {-0.1947649412367179, 
        0.3442157824300341}, {-0.17381662139651394`, 
        0.31519669036772385`}, {-0.1664612117240181, 0.3066032351256413}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1625596473328543, 
        0.30204496842637907`}, {-0.15073198275291547`, 
        0.2882264986590003}, {-0.1259294471922968, 
        0.26359217604203433`}, {-0.09312421598638322, 
        0.23687348261877464`}, {-0.05925305727019926, 
        0.21533294264796027`}, {-0.024882565713048088`, 0.1987566945120675}, {
        0.00942066401576676, 0.1869308765935728}, {0.03871921434798018, 
        0.1806674797169317}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.04462116781312979, 0.17964728019157275`}, {
        0.07457469463138554, 0.17717818734714275`}, {0.1326605419020214, 
        0.18386087956002034`}, {0.18176527201549197`, 0.20350306303247262`}, {
        0.22064189215386734`, 0.2331402276330914}, {0.24746186662247488`, 
        0.2679445395556307}, {0.2497000587374462, 0.27325633212580797`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.2520298576705231, 0.27878553070529793`}, {
        0.2640827492591745, 0.3073900725413197}, {0.2699164237139695, 
        0.3499818330252841}, {0.26481629075129015`, 0.3945048375436299}, {
        0.24879441673249453`, 0.4399353658958868}, {0.22242857105393876`, 
        0.4854271915566973}, {0.20967108126283837`, 0.5013500737350742}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.205919472064328, 0.5060325333901756}, {0.1864471706940415,
         0.5303363083128265}, {0.14240874353709157`, 0.5739692566770221}, {
        0.11043817119415812`, 0.6014632342016905}, {0.0763428778598409, 
        0.6280441725908175}, {0.0405953006151685, 0.6535369780130068}, {
        0.02591483228667488, 0.6631694278932763}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.020898292873663234`, 0.6664609825894192}, {
        0.0036678765411700814`, 0.6777665566368616}, {-0.034112768533399604`, 
        0.7004658123477601}, {-0.07242000877978581, 
        0.7213676490310804}, {-0.108990115518863, 
        0.7391070314723185}, {-0.14571321949913765`, 
        0.7544731640150639}, {-0.18246960303747548`, 
        0.7668806204092751}, {-0.19455150206311062`, 0.769800890586852}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.20038356016642644`, 
        0.7712105353220772}, {-0.21913954845074224`, 
        0.7757439744049112}, {-0.2555496205733008, 
        0.7802311967691231}, {-0.2915263842395138, 
        0.7795102582690621}, {-0.35115222665010254`, 
        0.763975204086384}, {-0.37961611811050056`, 
        0.7474902559589645}, {-0.40647719011729805`, 
        0.7240181274109208}, {-0.417374401781736, 0.7098760365817244}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.42103660916071356`, 
        0.705123328184046}, {-0.43087071219660067`, 
        0.692360909444301}, {-0.4516989216323925, 
        0.6519047525547086}, {-0.46779267834338545`, 
        0.6017281589184296}, {-0.477659532494593, 
        0.5426930463374974}, {-0.4796383972500232, 
        0.47892844596632655`}, {-0.47950853699933327`, 0.4768909347121198}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.479126902893057, 
        0.4709030840619343}, {-0.47748131385732473`, 
        0.4450837424058853}, {-0.47301551239650086`, 
        0.4103790799920948}, {-0.4661308214838271, 
        0.37522717015072293`}, {-0.4567170697355791, 
        0.3400407243075375}, {-0.4445118816650327, 
        0.305198765389597}, {-0.4296966848202046, 
        0.2712108247685608}, {-0.41427939553951076`, 0.24214757119325292`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4114676740648869, 
        0.2368471728733963}, {-0.4099070271751887, 
        0.2339051851172469}, {-0.38693055698156814`, 
        0.19863028723400758`}, {-0.36088900420012415`, 
        0.16579850923402806`}, {-0.33220394188972, 
        0.13570419882694174`}, {-0.2859200981409383, 
        0.09634687979356349}, {-0.24371150523839577`, 0.06892225244667696}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.23868024676819655`, 
        0.06565324063788083}, {-0.2359695645373219, 
        0.06389200092517092}, {-0.18382952089991417`, 
        0.03832230901691595}, {-0.13097714704975855`, 
        0.019620550863950557`}, {-0.07854983649523417, 
        0.007402771600997767}, {-0.027684982744720244`, 
        0.0012850163627805844`}, {-0.01374698247166773, 
        0.0004312801241994286}, {-0.010144885364869535`, 
        0.0003210699871842854}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.0041476917593834955`, 0.00013757922905909461`}, {
        7.858835603125435*^-6, 0.000010435571665048216`}, {
        0.027784663601900825`, 0.001734115412072282}, {0.054512219780927226`, 
        0.005060506629221975}, {0.10585056831251305`, 
        0.014687366698048904`}, {0.152901256405968, 0.029816154122576204`}, {
        0.19563731280240637`, 0.04958662793466012}, {0.2227673976968338, 
        0.06717883331732145}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.22780164720105012`, 0.0704432370805373}, {
        0.24751523587496227`, 0.08322629699834844}, {0.29165543283178064`, 
        0.12240642112923242`}, {0.3282430917194472, 0.16558267590259984`}, {
        0.3573911361416318, 0.21197258188845058`}, {0.3760074067150763, 
        0.2541499785204507}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.37843018431767456`, 0.2596390721330928}, {
        0.3789528101601851, 0.2608231437419974}, {0.3924855460736807, 
        0.3117917727010221}, {0.39741037663042156`, 0.3646795885397622}, {
        0.3928640291468017, 0.4196366228601952}, {0.38403958862784504`, 
        0.4580732189388927}, {0.37149971571979173`, 0.4942338166290146}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3693244847405995, 0.4998182265735086}, {
        0.3513555162027229, 0.53873618758482}, {0.32701701059027577`, 
        0.5811505919594641}, {0.2973590530197779, 0.6251957241046833}, {
        0.26266199871999385`, 0.6711490797112754}, {0.23874811937048498`, 
        0.7001019097700374}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.23492717980066, 0.7047279686546329}, {0.2229699337915496, 
        0.7192047545668148}, {0.20126454924802548`, 0.7440816166465566}, {
        0.17832694433507099`, 0.7695568444588757}, {0.15425710663255798`, 
        0.7954883861631994}, {0.129184093510295, 0.8216830164377178}, {
        0.10315702041576495`, 0.8480882370340226}, {0.07622500279645086, 
        0.8746515497037053}, {0.07089792746720876, 0.8797641183527483}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.06656902561252835, 0.883918707229225}, {
        0.04843715609983576, 0.9013204561983577}, {0.019842595773402638`, 
        0.9280424582695714}, {-0.009509562735365497, 
        0.9547650576689378}, {-0.03957020397898544, 
        0.9814357561480485}, {-0.07507834023038057, 
        1.0111080170875675`}, {-0.11133907169021579`, 
        1.0385780874480548`}, {-0.11471320695834412`, 1.0408815076481772`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.11966860598620498`, 
        1.0442644088401536`}, {-0.14835239835849143`, 
        1.0638459672295093`}, {-0.1861183202352074, 
        1.086911656431932}, {-0.22464605080695027`, 
        1.1071237367553661`}, {-0.2639448035603067, 
        1.1238307898998559`}, {-0.3040145784952764, 
        1.1370328158654006`}, {-0.3357504291718867, 1.1445679896923058`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3415881349254546, 
        1.1459540602297462`}, {-0.34485537561185997`, 
        1.146729814652001}, {-0.38684139527785816`, 
        1.153069722355517}, {-0.4303468378610722, 
        1.1562004750718096`}, {-0.475371703361502, 
        1.1561220728008779`}, {-0.5219159917791483, 
        1.1528345155427224`}, {-0.5619098502398333, 
        1.1478393873437205`}, {-0.5802350637267606, 1.1448204500925276`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.586155264373206, 
        1.1438451428046295`}, {-0.6039331499571183, 
        1.1409163735941097`}, {-0.6479858909310025, 
        1.13206547429389}, {-0.6940680731614851, 
        1.1212866894430618`}, {-0.7425460527256532, 
        1.108247617830295}, {-0.7937861857005939, 
        1.092615858244259}, {-0.8183747490453251, 1.0843178210086868`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-0.8240597449519063, 
        1.0823992742820845`}, {-0.8477884720863063, 
        1.074391410684955}, {-0.9045529118827895, 
        1.0535742751523827`}, {-0.9434425407039863, 
        1.0379540305662016`}, {-0.9824989640707504, 
        1.0206103037306546`}, {-1.0217221819830828`, 
        1.0015430946457415`}, {-1.0449277179140881`, 0.989294834117677}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0502339420114843`, 
        0.9864941224530795}, {-1.0611121944409831`, 
        0.9807524033114617}, {-1.0918031930785337`, 
        0.9628639277482297}, {-1.1211732493093378`, 
        0.9435930764373166}, {-1.1492223631333949`, 
        0.9229398493787231}, {-1.1759505345507038`, 
        0.9009042465724494}, {-1.2008123191506175`, 
        0.877391340047695}, {-1.2232622725224873`, 
        0.8523062018336595}, {-1.23509417379205, 0.8365658362176409}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.2386993641893929`, 
        0.8317697334040113}, {-1.243300394666313, 
        0.8256488319303427}, {-1.2609266855820955`, 
        0.7974192303377442}, {-1.276113087850166, 
        0.7676135662421681}, {-1.2888315440508564`, 
        0.7362280088299192}, {-1.2990820541841677`, 
        0.7032625581009968}, {-1.306864618250099, 
        0.6687172140554005}, {-1.3126230593539197`, 
        0.6322981735562658}, {-1.315262242998456, 0.6074972539828245}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3158971467590543`, 
        0.6015309404464121}, {-1.316632191388483, 
        0.5946235837813709}, {-1.3188920143537897`, 
        0.5556934447307162}, {-1.3194025282498396`, 
        0.5155077564043026}, {-1.3185807791559194`, 
        0.4744443882123609}, {-1.3168438131513167`, 
        0.43288120956512544`}, {-1.3141916302360308`, 
        0.3908182204625959}, {-1.3117651897935367`, 
        0.36186825599798217`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3112640571007375`, 
        0.35588922045500304`}, {-1.310624230410062, 
        0.34825542090477213`}, {-1.3063457497112008`, 
        0.30558743634821667`}, {-1.3015603241772369`, 
        0.2632088922494883}, {-1.2962679538081718`, 
        0.2211197886085884}, {-1.2904686386040043`, 
        0.179320125425517}, {-1.284229044831124, 
        0.1380334538038864}, {-1.2809400522772996`, 
        0.11786637135126747`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2799742883475627`, 
        0.11194460640895347`}, {-1.2776158387559198`, 
        0.09748332484730883}, {-1.2706290203783928`, 
        0.05766973855578446}, {-1.2632685896985416`, 
        0.018592694929314355`}, {-1.2555614158730555`, -0.019725635002736}, \
{-1.247534368058621, -0.057263080211001086`}, {-1.2391874462552397`, \
-0.09401964069547977}, {-1.2321618896601814`, -0.12318256920545072`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2307566494003601`, -0.12901569013786568`}, \
{-1.2305206504629107`, -0.12999531645617196`}, {-1.2215263009203952`, \
-0.1652984780103835}, {-1.2121967178664539`, -0.20003749587542008`}, \
{-1.202531901301088, -0.23421237005128187`}, {-1.192531851224296, \
-0.2678231005379676}, {-1.1770250402494915`, -0.3167806282224171}, \
{-1.1626397679407674`, -0.35905484901301915`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1607069018242615`, -0.3647349923717438}, \
{-1.160464940863989, -0.36544604676388504`}, {-1.1428515530677892`, \
-0.4138193561623707}, {-1.124184876860891, -0.46190055641787386`}, \
{-1.1040362131616845`, -0.5103060802808613}, {-1.0819768628885578`, \
-0.5596523605017997}, {-1.0691943989092314`, -0.5864688496794512}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.06661270552024, -0.5918850161507885}, \
{-1.0580068260415114`, -0.6099393970806891}, {-1.0321261026205455`, \
-0.6611671900175284}, {-1.0035151981848374`, -0.7136535338749181}, \
{-0.9713546182935635, -0.7677162232154584}, {-0.9539432000520901, \
-0.79533869744191}, {-0.9499677455445681, -0.8014253444495989}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9466867220739431, -0.8064487780348281}, \
{-0.9356443629467253, -0.8233552580391486}, {-0.9164581069774691, \
-0.851765905007175}, {-0.8963844321443216, -0.8805706383459886}, \
{-0.8662364443963907, -0.9212539947673799}, {-0.8334711411961713, \
-0.9617740021490844}, {-0.8020453809459256, -0.9976175523965282}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7980898887703322, -1.0021291022021734`}, \
{-0.7980885225436631, -1.0021306604911018`}, {-0.7600885884388654, \
-1.0423239697934332`}, {-0.7194033836014226, -1.0812955898806962`}, \
{-0.67596495275098, -1.1179871805775083`}, {-0.6297732958875359, \
-1.152398741883871}, {-0.6181662167447372, -1.160018603491648}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6131504676928355, -1.1633113624333788`}, \
{-0.5808284130110888, -1.184530273799785}, {-0.5296497638578531, \
-1.2136479968931089`}, {-0.4767568081640434, -1.2390181317317013`}, \
{-0.4221495459296582, -1.2606406783155633`}, {-0.398265306570969, \
-1.2682208965613548`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.39254641735623547`, -1.27003591891648}, \
{-0.3658279771546955, -1.2785156366446953`}, {-0.3198759127445309, \
-1.2902367233315322`}, {-0.273763781049976, -1.2997258909908216`}, \
{-0.22749158207103107`, -1.3069831396225633`}, {-0.1810593158076963, \
-1.3120084692267568`}, {-0.15719201870802005`, -1.3136721707497463`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.15120654271503536`, -1.3140893962731794`}, \
{-0.13477609810288127`, -1.3152347021538777`}, {-0.08895104479950026, \
-1.3170946607544016`}, {-0.043584155897551526`, -1.317588345028328}, {
        0.001324568602964954, -1.316715754975657}, {
        0.04572315922159654, -1.3148042473220074`}, {
        0.0885868965109439, -1.3122393857795664`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.09457030220037649, -1.311795068618714}, {
        0.13283403037184713`, -1.3088465493886308`}, {
        0.17554631090346767`, -1.3048003591089028`}, {
        0.2258604435395959, -1.2992543273464012`}, {
        0.27588381217998037`, -1.2930859408960527`}, {
        0.32561641682462283`, -1.2862951997578564`}, {
        0.333037592946179, -1.2851825006955033`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.33897126704302744`, -1.2842928312555484`}, {
        0.37505825747352456`, -1.2788821039318121`}, {
        0.42467524428619324`, -1.2708879233811174`}, {
        0.47493328742213636`, -1.2623539280689702`}, {
        0.5258323868813556, -1.2532801179953696`}, {
        0.5755486645284549, -1.2440066954719375`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5814408906959706, -1.242874792593873}, {
        0.6300420003060614, -1.2334170161931646`}, {
        0.6843290053444179, -1.2224356497232736`}, {
        0.7402335577789233, -1.2107223937506424`}, {
        0.7977556576095768, -1.198277248275271}, {
        0.8164260720849787, -1.194112865501307}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8222821696294482, -1.1928066796226284`}, {
        0.8326240967182723, -1.1904999422400688`}, {
        0.8678278305451337, -1.18239509670622}, {
        0.903360551060283, -1.173940914592348}, {
        0.939215950233843, -1.1651155988170765`}, {
        0.9753877200359355, -1.1558973522990281`}, {
        1.0118695524366832`, -1.1462643779568267`}, {
        1.0486551394062082`, -1.1361948787090954`}, {
        1.0550332203831818`, -1.1343841504597365`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.060805124227625, -1.1327455150486392`}, {
        1.0857381729146331`, -1.1256670574744574`}, {
        1.1227586831027647`, -1.1146564995551533`}, {
        1.1590030382820944`, -1.1031361726370412`}, {
        1.194046707272853, -1.091095259333493}, {
        1.227577428489352, -1.0785378483772043`}, {
        1.2592515048521271`, -1.0654632112094018`}, {
        1.2867725067758637`, -1.052784259734134}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.292089872179487, -1.0500134962801932`}, {
        1.3403004664001759`, -1.0231686287531958`}, {
        1.3814513738235554`, -0.9924773020912467}, {
        1.4121614257933512`, -0.9598483454732761}, {
        1.433334837492728, -0.9253186703041483}, {
        1.447230073669648, -0.8889127864731502}, {
        1.4492075879163826`, -0.8799240939831322}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.450496759793225, -0.874064227442676}, {
        1.455652464719626, -0.8506292275536925}, {
        1.4606313314681285`, -0.8104343500455208}, {
        1.4633494771691506`, -0.7682849050521277}, {
        1.464255182720192, -0.7241119497439177}, {
        1.4639902823107245`, -0.6894393797225671}, {
        1.4627862676155088`, -0.6536123260161593}, {
        1.4618231971017928`, -0.6350749174408312}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4615119000532364`, -0.6290829983703197}, {
        1.4608686298691977`, -0.6167011820276722}, {
        1.4584628603064445`, -0.5787763411600836}, {
        1.4556943936170472`, -0.5399501767826131}, {
        1.4526886644908041`, -0.5003350622644803}, {
        1.4494796288843441`, -0.4601587509433629}, {
        1.4460880570888128`, -0.4194801446141478}, {
        1.443508762317786, -0.38976920986011393`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4429898362116402`, -0.38379169234057786`}, {
        1.4425267260668602`, -0.378457119708535}, {
        1.4388084127811362`, -0.33724755265821915`}, {
        1.4349499180651881`, -0.29600328458824043`}, {
        1.430968042752563, -0.2548761566236338}, {
        1.426972404031183, -0.21493570168370535`}, {
        1.4228665842265633`, -0.17514578107471618`}, {
        1.419653889083354, -0.14493253665116915`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4190194617091572`, -0.13896617243945114`}, {
        1.4186643234865264`, -0.1356263354968864}, {
        1.414379361958896, -0.09649730565043621}, {
        1.4100254397914944`, -0.05787863223558566}, {
        1.4056162971321453`, -0.0198902559525548}, {1.40116567412867, 
        0.017347882498438688`}, {1.396687310928893, 0.05371584241716965}, {
        1.390883769529806, 0.09937432395986652}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.390119902915453, 0.10532549110051923`}, {
        1.3839749001930854`, 0.15221342566298188`}, {1.3775236373711879`, 
        0.2001289065807078}, {1.3710233468455082`, 0.24729854332704457`}, {
        1.3644653978349914`, 0.2939470996607394}, {1.3578300802841752`, 
        0.34036647736036746`}, {1.3574360740740383`, 0.3430874779355065}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3565762300004283`, 0.3490255473329687}, {
        1.3511115332306074`, 0.38676465567971907`}, {1.3443038957118352`, 
        0.43334961387258464`}, {1.3373509758095088`, 0.48042147442974314`}, {
        1.3301678210590504`, 0.5283330131202606}, {1.3227054296786669`, 
        0.5773711891153455}, {1.3213082638461155`, 0.5864191729843008}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3203926120720806`, 0.5923488931993452}, {
        1.3149147998865645`, 0.6278229615862082}, {1.3067284646278745`, 
        0.6799514741663553}, {1.2980684052631135`, 0.7340062616106046}, {
        1.2888697926335657`, 0.7902538697721349}, {1.2823483989182816`, 
        0.8293123771462457}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.2813602886636302`, 0.8352304543783079}, {
        1.2790677975805158`, 0.8489608445041247}, {1.2685571869004793`, 
        0.9099748285508031}, {1.2573276150883426`, 0.9722069627380749}, {
        1.2453203643286417`, 1.0353265904372007`}, {1.2380683722897203`, 
        1.0712806458096997`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.2368820536869904`, 1.0771621973203827`}, {
        1.2324767168059125`, 1.0990030550194405`}, {1.223235259643004, 
        1.141937639074281}, {1.215236948731389, 1.1761288391364895`}, {
        1.2069720427155735`, 1.2089312925176998`}, {1.1897385149115216`, 
        1.2688127731747936`}, {1.1754705117453528`, 1.3088965722577965`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.1734584525785159`, 1.3145491484765792`}, {
        1.171698527474471, 1.3194933921419398`}, {1.1530542197617244`, 
        1.3598711305934221`}, {1.131960157368948, 1.3932767228648308`}, {
        1.1105259252838013`, 1.4156941206752338`}, {1.067300436612837, 
        1.439792402508421}, {1.0233449985390128`, 1.4468419875441338`}, {
        0.9976020636562407, 1.4463566733951305`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9916050559989247, 1.4461779146239824`}, {
        0.9653325266093912, 1.4451315413776233`}, {0.934746585538384, 
        1.443351457939841}, {0.9022602645509294, 1.440909981184253}, {
        0.8678413596170131, 1.437993886423205}, {0.8311550412809476, 
        1.4347188686788122`}, {0.7985667354329703, 1.4317286675946785`}, {
        0.7640226801658898, 1.428496977819458}, {0.7523787815431557, 
        1.4273890775718043`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.7464057582589179, 1.4268207529762151`}, {
        0.7274236628141972, 1.4250146338295635`}, {0.6886704707123861, 
        1.4212724701014081`}, {0.6477858812334221, 1.4172565761883265`}, {
        0.6047926717502686, 1.4129530416436538`}, {0.562659742085417, 
        1.4086399423416203`}, {0.5189758369341929, 1.404052134939244}, {
        0.5076100228867757, 1.4028233954298734`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5016447807615342, 1.4021785028905738`}, {
        0.4740136156835526, 1.399191342966998}, {0.428045737720452, 
        1.3940592899553537`}, {0.38141465382542394`, 1.3886689757046344`}, {
        0.3344628147790006, 1.383033400015163}, {0.2831238972304674, 
        1.3766321744897687`}, {0.2633034942301193, 1.3740532892849546`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2573536462488289, 1.3732791387830918`}, {
        0.2320459160347847, 1.3699862828802485`}, {0.18173737157520864`, 
        1.3631222923595763`}, {0.1327067642349952, 1.3560667701007258`}, {
        0.08506348491812366, 1.348831800510986}, {0.03868886196898663, 
        1.3414211921315395`}, {0.019937013629275465`, 1.3382615983494532`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.014020413693803047`, 
        1.3372646804974877`}, {-0.006250698068539812, 
        1.3338490983362008`}, {-0.04958878865057961, 
        1.3261296724987852`}, {-0.09143104287933718, 
        1.3182983288110282`}, {-0.13203854508334856`, 
        1.3104026305034773`}, {-0.17147806555823514`, 
        1.302474954508165}, {-0.2098163745996183, 
        1.2945476777571236`}, {-0.22166008708204885`, 1.2920296869549792`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2275289190694866, 
        1.2907819645887346`}, {-0.24723607488228727`, 
        1.286592194096866}, {-0.2839859590119842, 
        1.2785450498964643`}, {-0.32023208218076, 
        1.270386350871791}, {-0.35614049958066557`, 
        1.262096202738718}, {-0.4032829777036802, 
        1.2508462340204074`}, {-0.45078469347535666`, 
        1.2390238323732785`}, {-0.4612476597147224, 1.23631167404733}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4670557034746327, 
        1.2348061416886715`}, {-0.4991170726191883, 
        1.226495352255025}, {-0.5487515408586686, 
        1.2131271481233414`}, {-0.6002603554735157, 
        1.1986676089052257`}, {-0.6542733917755728, 
        1.182797714652992}, {-0.697943120894651, 1.1693965026216115`}}]}, 
      {Arrowheads[{{0.0006685329578423794, 1.}}], 
       ArrowBox[{{-0.7040951482703488, 
        1.1654103792578472`}, {-0.7109324629872322, 
        1.1654103792578472`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.24017776779883498`, 
        0.84040262014396}, {-0.28953895610067754`, 
        0.8556509246177588}, {-0.3407498214628198, 
        0.865305371595066}, {-0.3941264725649757, 
        0.8676062200201089}, {-0.433786577669217, 
        0.8636207712036137}, {-0.4748226934156393, 
        0.8539658359071203}, {-0.4755531760221542, 0.8536877728155357}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.4811606538425698, 
        0.8515532488654365}, {-0.5175627004427625, 
        0.8376965662731584}, {-0.5619481719551204, 
        0.8134434398048691}, {-0.6077443328211647, 
        0.7793249353646055}, {-0.6542964897135372, 
        0.7336341798175187}, {-0.6722896926546577, 0.712006817383642}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6761270723605695, 
        0.7073943866803516}, {-0.6776833568003978, 
        0.7055237732192291}, {-0.7010519710508025, 
        0.6734097822526084}, {-0.724072278546205, 
        0.6376366159432564}, {-0.7464142253680595, 
        0.5985486833167715}, {-0.7622291259716752, 
        0.5677433745475925}, {-0.777433860675131, 
        0.5351612509596876}, {-0.7920284294784266, 
        0.5008023125530564}, {-0.7928854209498218, 0.49858784315160415`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7950508966239472, 
        0.4929922453189529}, {-0.8060128323815623, 
        0.4646665593276993}, {-0.8191702665574111, 
        0.4271514932015954}, {-0.8312839291788459, 
        0.388654616092724}, {-0.8423538202458666, 
        0.34917592800108527`}, {-0.8523799397584736, 
        0.30871542892667875`}, {-0.8611781463778647, 
        0.2677864976259997}, {-0.8620607432646539, 0.2629011289271861}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8631274428867678, 
        0.25699671092740134`}, {-0.8685642987652378, 
        0.2269025128555433}, {-0.8745383969205931, 
        0.18606347461530925`}, {-0.8791004408439307, 
        0.1452693829052975}, {-0.8829286886527589, 
        0.08614600049951272}, {-0.8830630002492001, 
        0.028789717039140364`}, {-0.8823924644814344, 
        0.018318237447939537`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8820090428811448, 
        0.012330500991111184`}, {-0.8795033756332545, -0.02679946747581939}, \
{-0.8722498148049219, -0.08062155304536692}, {-0.8654494172584153, \
-0.11410781286466293`}, {-0.8567086068256258, -0.146737176164979}, \
{-0.8460273835065536, -0.17850964294631483`}, {-0.8334057473011991, \
-0.20942521320867058`}, {-0.8283400282962866, -0.21988176323717754`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.825724111430865, -0.22528148350337676`}, \
{-0.8188436982095617, -0.2394838869520462}, {-0.802341236231642, \
-0.26868566417644185`}, {-0.7838983613674395, -0.29703054488185754`}, \
{-0.7635150736169543, -0.3245185290682929}, {-0.7282900643139907, \
-0.36480237513992564`}, {-0.68765066075339, -0.4032395882038069}, \
{-0.6773098039018378, -0.41142623528440475`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6726055589328993, -0.4151504908170202}, \
{-0.6415257677269919, -0.4397557324903194}, {-0.5898442900266359, \
-0.4742763722298458}, {-0.562011055579325, -0.4907507378352243}, \
{-0.5329711222747269, -0.5066509471853268}, {-0.5027244901128419, \
-0.5219770002801528}, {-0.47127115909367, -0.5367288971197026}, \
{-0.4674818859391597, -0.5383183844297995}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4619489473856845, -0.540639287478931}, \
{-0.41612806866077096`, -0.5598597823603965}, {-0.3587648811599246, \
-0.5810866698099164}, {-0.30965110128856876`, -0.597444087568453}, \
{-0.2598947808051624, -0.6123336413128226}, {-0.23530953167893864`, \
-0.6188882389640014}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.22951203582052015`, -0.6204338915030995}, \
{-0.20975053974500216`, -0.6257024431901437}, {-0.1594729981433845, \
-0.6374976053475346}, {-0.10955848737581131`, -0.6477198674946254}, \
{-0.06030996974561996, -0.6563270672910367}, {-0.011692011679860202`, \
-0.6632019638088726}, {0.006069527875835427, -0.665060621243352}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.012036943478777169`, -0.6656850818279908}, {
        0.03633082039441839, -0.6682273161202372}, {
        0.09075873599829468, -0.6715619625676668}, {
        0.14420812295879928`, -0.6722211275981453}, {
        0.19667898127593217`, -0.6702048112116729}, {
        0.24817131094969336`, -0.6655130134082495}, {
        0.25150873325937495`, -0.6650119727000362}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2574422398688171, -0.6641211869145037}, {
        0.29906658423401605`, -0.6578722052021341}, {
        0.34974627338283343`, -0.647008857607585}, {
        0.40021037839614565`, -0.6329229706246026}, {
        0.45045889927395255`, -0.6156145442531866}, {
        0.4879498236725201, -0.6001919419232449}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.49349866508232765`, -0.5979093208401903}, {
        0.501049271716189, -0.5948032356920655}, {
        0.5525389314227896, -0.5702087021399668}, {
        0.604927878393755, -0.541830943596891}, {
        0.6582161126290844, -0.5096699600628378}, {
        0.6875896534825715, -0.491056546948403}, {
        0.7027408283537734, -0.4810148174694975}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7077421087279373, -0.47770012372512183`}, {
        0.7174097075307708, -0.47129273864020893`}, {
        0.7648037819629677, -0.43660263959316514`}, {
        0.8132562830774767, -0.3992775729606929}, {
        0.8620935615183223, -0.36076727428072997`}, {
        0.8978334095207153, -0.3313142300792595}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.9024637046491001, -0.3274984251806757}, {
        0.9117003946118417, -0.3198865115057857}, {
        0.9366626479978328, -0.298610600662707}, {
        0.9615577977359504, -0.2768488629559061}, {
        0.9863858438261943, -0.2546012983853829}, {
        1.0111467862685644`, -0.2318679069511374}, {
        1.0356093084895905`, -0.2087189568452523}, {
        1.0595420939158022`, -0.1852247162598103}, {
        1.079155897295327, -0.1652451023926814}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.083351234329103, -0.16095580892668668`}, {
        1.1058184543837828`, -0.13720036365025548`}, {
        1.1392140219519802`, -0.09995958954567058}, {
        1.1704913047588232`, -0.062179843527067034`}, {
        1.1990813822072295`, -0.024027388079503186`}, {1.224415333700114, 
        0.014331514311962848`}, {1.2316539883575226`, 
        0.026998204909215104`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2346309911834734`, 0.032207567074997064`}, {
        1.2464152813379612`, 0.052828520050336426`}, {1.2652839430484346`, 
        0.09145123918894499}, {1.280873291975223, 0.13011733971821354`}, {
        1.293035301262014, 0.16874448962856703`}, {1.3021284542086327`, 
        0.20733551778713014`}, {1.3088006684898397`, 0.24594191641914168`}, {
        1.3102303907338324`, 0.25810858658245184`}}]}, 
      {Arrowheads[{{0.0017189774753443002`, 1.}}], 
       ArrowBox[{{1.3115293998450215`, 0.2794590202080621}, {
        1.312739309728405, 0.2794590202080621}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.5363362975390406, 
        0.76715324492146}, {-0.5598938430140652, 
        0.744148175903389}, {-0.5831210422301636, 
        0.7166755361695751}, {-0.6056512599614053, 
        0.6847712814021556}, {-0.6271178609818594, 
        0.6484713672832678}, {-0.6471931195411236, 
        0.6071514691819374}, {-0.6633185979416829, 0.5662892663209227}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6655205824256971, 
        0.5607079538335761}, {-0.6816797226870436, 
        0.5099917119483619}, {-0.6952644140805726, 
        0.4558084369318584}, {-0.7058144683118281, 
        0.39892966190619755`}, {-0.7129076664681326, 
        0.3401708205652817}, {-0.7136676766191251, 0.32631461731613365`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7139962815613958, 
        0.32032362250793067`}, {-0.7161840358496054, 
        0.28043735515079016`}, {-0.7152836037563662, 
        0.22063470790440104`}, {-0.7096198280422824, 
        0.16212779974040872`}, {-0.6987874221182233, 
        0.10591396863501541`}, {-0.6918214338394032, 
        0.08272160132290851}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6900954649043689, 
        0.07697520843386092}, {-0.6826982966198094, 
        0.05234728242276101}, {-0.6612643621826619, 
        0.001781808938186393}, {-0.633824223502503, -0.04520461523384077}, \
{-0.6001751300269739, -0.08821316850871452}, {-0.5644338821900554, \
-0.12366942582092641`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5600945165301228, -0.12780478332421322`}, \
{-0.516649589743801, -0.16195448103040988`}, {-0.46764885183447286`, \
-0.1924343671664885}, {-0.41444981422935157`, -0.21849606213788525`}, \
{-0.35804121064635563`, -0.2401521595413884}, {-0.3509708590633803, \
-0.2422339830865399}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3452151750015952, -0.24392871049261822`}, \
{-0.29941177480340286`, -0.25741525297378665`}, {-0.24001987215183926`, \
-0.2700794181703588}, {-0.18094816275626904`, -0.27811354515559134`}, \
{-0.12262182225449633`, -0.2817924489600838}, {-0.10915469438086645`, \
-0.28169784594961256`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.10315484241611174`, -0.281655698576871}, \
{-0.06546602628432645, -0.2813909446144358}, {-0.017248350761352275`, \
-0.27790735316841764`}, {0.029072432683442343`, -0.2715518448311742}, {
        0.07349632405005738, -0.26232441960270547`}, {
        0.11602332333849281`, -0.2502250774830115}, {
        0.13260896199381422`, -0.24426107784172904`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.13825502710931475`, -0.2422308195548286}, {
        0.15668823477230256`, -0.23560245593408424`}, {
        0.19552586257504062`, -0.2188051924179159}, {
        0.2325362067467069, -0.19983328693450636`}, {
        0.26771926728730167`, -0.17868673948385566`}, {
        0.30128268297383565`, -0.1557598717348549}, {
        0.3334340925833198, -0.13144700535639542`}, {
        0.34456043001812275`, -0.1221451253290927}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3491636615812815, -0.11829671537484673`}, {
        0.3641734961157542, -0.10574814034847707`}, {
        0.39350089357113893`, -0.07866327671109985}, {
        0.42943120468383206`, -0.04237721058141797}, {
        0.463713055400106, -0.004861630691796993}, {0.4963464457199608, 
        0.033883462957763164`}, {0.5134832509692874, 
        0.055992180446801126`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.5171590225636239, 0.060734405998825104`}, {
        0.5273313756433966, 0.07385807036726261}, {0.5597472800143054, 
        0.1194635132022348}, {0.5904991384076915, 0.16623157310412887`}, {
        0.6128578840435241, 0.20246401644585102`}, {0.6342561057797629, 
        0.23954813837287012`}, {0.6465375385001277, 
        0.26255542844291474`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6493630161166322, 0.26784850658692816`}, {
        0.6546055574253609, 0.2776695650367381}, {0.6738553712027712, 
        0.31700607556544247`}, {0.6895459754311337, 0.3515162928374147}, {
        0.7044778483993148, 0.3870827802756242}, {0.7182941713568991, 
        0.4241452733659825}, {0.7306381255534711, 0.4631435075944013}, {
        0.7374536744016632, 0.4904358951808904}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7389073728702149, 0.4962571287926372}, {0.743116192761504,
         0.5131110530052492}, {0.7529341179045385, 0.5665928239466254}, {
        0.7594831646059319, 0.6243024685693059}, {0.7621545964890417, 
        0.6869536350240667}, {0.7618307568776295, 0.7202804412072461}, {
        0.7611404834701337, 0.734400080893801}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7608475085669005, 0.740392923767269}, {0.7601266135694245,
         0.7551389323859834}, {0.7570421665644269, 0.7915291085602786}, {
        0.7525774158626368, 0.8294509697301317}, {0.7483870774277144, 
        0.8608995897688375}, {0.7431297697776961, 0.8933494194634362}, {
        0.7304264247752716, 0.9457492515581235}, {0.7212596538770514, 
        0.9764235636370747}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7195416752859157, 0.9821723504273809}, {
        0.7144882248333342, 0.9990824617391078}, {0.6968736747710688, 
        1.0519836020824467`}, {0.6759064244681472, 1.1040206027504944`}, {
        0.6515695177573302, 1.1536418216890516`}, {0.6238459984713784, 
        1.1992956168439177`}, {0.6227462218986457, 1.2007353938905165`}}]}, 
      {Arrowheads[{{0.018574026191876775`, 1.}}], 
       ArrowBox[{{0.6191040908655929, 1.2055035047887732`}, {
        0.5929120423005046, 1.2397929334440048`}, {0.5589438249349217, 
        1.2739447167182247`}, {0.532300256784743, 1.2950494719476662`}, {
        0.5043409394682978, 1.3129025466170388`}, {0.47521347692090943`, 
        1.3272405024209981`}, {0.4450654730779008, 1.337799901054198}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9006992167051403, -0.20694155106116677`}, \
{-0.8826894928755505, -0.2592046182166136}, {-0.8596270082485928, \
-0.3097234851892964}, {-0.8308312682060339, -0.35874315117961014`}, \
{-0.796302272747874, -0.40626361618755485`}, {-0.7873509866841664, \
-0.4164952721522941}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7834003122325646, -0.421011041342306}, \
{-0.7560400218741128, -0.4522848802131304}, {-0.7152722444003062, \
-0.49174609775815403`}, {-0.669141593165745, -0.5301725591418353}, \
{-0.6440642436772956, -0.5489778774079446}, {-0.6176442833268866, \
-0.5674847489032626}, {-0.602535498810386, -0.577394031564561}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5975183193543759, -0.5806846105874975}, \
{-0.5898817121145176, -0.5856931736277892}, {-0.5607765300401887, \
-0.6036031515815244}, {-0.5304461702215773, -0.6211766408895218}, \
{-0.49900806577636053`, -0.6383755996768354}, {-0.4664622167045386, \
-0.6552000279434647}, {-0.43280862300611134`, -0.6716499256894098}, \
{-0.3857770763674646, -0.6931389138325371}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.38031974051571765`, -0.6956324024331201}, \
{-0.3787757229318903, -0.6963378730783143}, {-0.3230395836260312, \
-0.7199050696383846}, {-0.283139170860897, -0.7357532113697092}, \
{-0.2429677548336321, -0.7509400872855965}, {-0.2025253355442364, \
-0.7654656973860458}, {-0.1618119129927102, -0.7793300416710577}, \
{-0.156169547300138, -0.7811495392508586}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.15045911217263833`, -0.7829909872285702}, \
{-0.1210586336647713, -0.7924717799323248}, {-0.08049664404613761, \
-0.8048295719615408}, {-0.040125944136809276`, -0.8164034177587052}, {
        0.00005346606321357528, -0.8271933173238182}, {
        0.048197331207703795`, -0.8390642565291309}, {
        0.08093061634980508, -0.8462848441383848}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.08678975861389975, -0.847577303781507}, {
        0.09594650587592207, -0.8495971772996768}, {
        0.14330099006786823`, -0.8587920796354555}, {
        0.1902607837835426, -0.8666489635364674}, {
        0.23706602779223393`, -0.8730376361657224}, {
        0.28395686286323085`, -0.8778279046862306}, {
        0.3242614794335138, -0.8805664457343579}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.330247677192609, -0.8809731844576232}, {
        0.3309332889965336, -0.881019769097992}, {
        0.3779953061921422, -0.8826132294010067}, {
        0.42559308556731423`, -0.8824051553599868}, {
        0.47417679823930736`, -0.8801924167396442}, {
        0.5237464442081216, -0.875975013539979}, {
        0.5696429297740561, -0.8703263581757889}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5755905397829171, -0.8695414833789112}, {
        0.6298785439679233, -0.8606321117227476}, {
        0.6875244744072389, -0.8487071461232338}, {
        0.7474495027187448, -0.8337193084480059}, {
        0.8091958926186638, -0.815605650902036}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8149059403957947, -0.8137639125925532}, {
        0.8419486789339866, -0.8049369843765326}, {
        0.8745465582371453, -0.793488619518738}, {
        0.907656954738959, -0.7810647636092354}, {
        0.9412798684394273, -0.7676654166480249}, {
        0.9851342464084496, -0.749689481538708}, {
        1.0293899743898307`, -0.7299567053628802}, {
        1.0377816338708947`, -0.7253083887597729}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0430302154497733`, -0.7224010890831217}, {
        1.0850479699520743`, -0.699126571531611}, {
        1.138261902592108, -0.6651305181483697}, {
        1.1892290178827778`, -0.6296444522610597}, {
        1.2357024984747207`, -0.5911783613656129}, {
        1.2402110739150465`, -0.5866518431781684}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.244445280813925, -0.5824007854347958}, {
        1.276734140034962, -0.549983426459586}, {
        1.311375738230528, -0.5063108285405362}, {
        1.339602204255895, -0.4605485569027977}, {
        1.3613884493055401`, -0.413084600840705}, {
        1.3720380334153615`, -0.3823685978956594}}]}, 
      {Arrowheads[{{0.00027321485249625526`, 1.}}], 
       ArrowBox[{{1.3742605142926956`, -0.37434322129968906`}, {
        1.3748205218538696`, -0.37434322129968906`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -0.7864170130565192}, {-1.471954889637079, \
-0.8043544247070936}, {-1.4337653581600633`, -0.8332637641713465}, \
{-1.4007232869599495`, -0.8621672120177628}, {-1.370973453954144, \
-0.8910924156858344}, {-1.3433450532682485`, -0.9200505007581241}, \
{-1.321286273480508, -0.9451222904025524}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.3173487949321334`, -0.9496487262529694}, \
{-1.2944525488561895`, -0.9780653151153577}, {-1.272473827554896, \
-1.0069731213422164`}, {-1.2511873034232535`, -1.0356159628571229`}, \
{-1.2305929764612629`, -1.0639938396600774`}, {-1.2106908466689235`, \
-1.09210675175108}, {-1.1786580249399279`, -1.137938756624258}, \
{-1.175123568634828, -1.1428879457334884`}}]}, 
      {Arrowheads[{{0.01999999999999999, 1.}}], 
       ArrowBox[{{-1.1716365829080644`, -1.1477706632699989`}, \
{-1.1472155064610596`, -1.1819667362028583`}, {-1.1106563205572155`, \
-1.225783791043853}, {-1.0734291388103498`, -1.2646102213257666`}, \
{-1.0355834288160166`, -1.3004976976144207`}, {-1.0078486562701399`, \
-1.3217937476596036`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.003089730688414, -1.325447872357475}, \
{-0.9965006623267483, -1.3305072659165553`}, {-0.9559486267628459, \
-1.3548243499165031`}, {-0.9136951095446104, -1.3736343732985972`}, \
{-0.8695862862678662, -1.3875929017554847`}, {-0.8234683325284372, \
-1.3973555009798135`}, {-0.7790639202736506, -1.402926445780127}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7731105901314913, -1.4036733461874493`}, \
{-0.7671235232562517, -1.4044244791804132`}, {-0.7078963671369601, \
-1.4077708954302883`}, {-0.6459615480113599, -1.4082252714148722`}, \
{-0.5814937497202484, -1.4066181288195985`}, {-0.5484224554218304, \
-1.405149001889673}, {-0.5333273677619416, -1.4043511893964276`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.527335730393085, -1.4040345166313815`}, \
{-0.5149428604004437, -1.4033795229850994`}, {-0.48105496465608816`, \
-1.4013096921058774`}, {-0.4467587681887636, -1.398939509252007}, \
{-0.41369890306609025`, -1.3964343633859768`}, {-0.3805366381594581, \
-1.3937416994059613`}, {-0.3472719734688671, -1.3908615173119605`}, \
{-0.31390490899431744`, -1.3877938171039743`}, {-0.28808795630926365`, \
-1.3852926144687938`}}]}, 
      {Arrowheads[{{0.01118534425257845, 1.}}], 
       ArrowBox[{{-0.2821159180921656, -1.3847140303923449`}, \
{-0.28055792763969034`, -1.3845630888822118`}, {-0.24735351230886715`, \
-1.3811938227468818`}, {-0.21429166300184782`, -1.377686018697984}, \
{-0.18137237971863232`, -1.3740396767355187`}, {-0.14867268908377224`, \
-1.370273150969758}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.0084517815711076`, 1.5}, {-1.0249862448288576`, 
        1.4728759631187207`}, {-1.0499841031495707`, 
        1.4377043206924498`}, {-1.0744418761015886`, 
        1.4074108654424475`}, {-1.0982598053059658`, 
        1.3803084095104496`}, {-1.1213658343732902`, 
        1.3553477870923785`}, {-1.1612644040661222`, 
        1.3159747972469575`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.1655382636474496`, 
        1.3117637206599513`}, {-1.2026129502164637`, 
        1.2776795868749875`}, {-1.2367506606241034`, 
        1.2468204889809387`}, {-1.2538512253610659`, 
        1.2303008048168182`}, {-1.2696935564196157`, 
        1.214252252247263}, {-1.2987377213215738`, 
        1.1828418183861027`}, {-1.322594831797833, 
        1.1525486181673086`}, {-1.3312009449111717`, 
        1.1391160277333887`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3344377361478366`, 
        1.1340639803770936`}, {-1.3415737613092549`, 
        1.1229259321017444`}, {-1.3639456826070573`, 
        1.074572839477134}, {-1.3764845017523315`, 
        1.0258426546448813`}, {-1.3824659263665902`, 
        0.9759366239668239}, {-1.385165664071347, 
        0.9240559938047997}, {-1.384984309784923, 0.9030940923115796}}]}, 
      {Arrowheads[{{0.018410379435117762`, 1.}}], 
       ArrowBox[{{-1.384932402041828, 
        0.8970943168502638}, {-1.3846923797292718`, 
        0.8693512501095502}, {-1.3811547382030345`, 
        0.8109728788318165}, {-1.3773592582920187`, 
        0.7683209834001015}, {-1.3729831941278805`, 
        0.7236288158163234}, {-1.3680999907527656`, 0.6769147014451757}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8229559166608289, 
        0.12431559072348561`}, {-0.8211573832231699, 
        0.07145960237502327}, {-0.8157407797229232, 
        0.02050090148427367}, {-0.8067061061600888, -0.028560511948763176`}, \
{-0.7940533625346664, -0.07572463792408754}, {-0.7811853361278853, \
-0.11057428837155484`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-0.7791070258007147, -0.11620284290926483`}, \
{-0.7774102571500277, -0.12079809260004118`}, {-0.7564044983095444, \
-0.16358749213496587`}, {-0.7310360860132163, -0.20409283652886204`}, \
{-0.7013050202610435, -0.24231412578172992`}, {-0.6802789972489748, \
-0.2651797069327157}, {-0.6573808922174382, -0.28709103184032425`}, \
{-0.6356529623528308, -0.3054741678726263}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.630999341623912, -0.3092578999626126}, \
{-0.6059684360959606, -0.32805091292541066`}, {-0.5775622401770264, \
-0.3470510805415453}, {-0.5475002725806375, -0.3650002147916168}, \
{-0.5157825333067939, -0.38189831567562516`}, {-0.48240902235549565`, \
-0.3977453831935703}, {-0.44770518664510756`, -0.41247457995873393`}, \
{-0.42065701150599055`, -0.4227340842669007}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.41504701614647277`, -0.42486198277627296`}, \
{-0.4119964730939947, -0.4260190685843978}, {-0.37528288170215723`, \
-0.43837884907056185`}, {-0.33756441246959495`, -0.4495539214172263}, \
{-0.2847646711966765, -0.46291876980896307`}, {-0.23193459445191733`, \
-0.47378301679899637`}, {-0.1822926505129931, -0.4816374320033207}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17634937735659145`, -0.482448712407455}, \
{-0.12618343454687614`, -0.4880097065739532}, {-0.07612935698636593, \
-0.49119618941824233`}, {-0.027131309834296076`, -0.4919353683451162}, {
        0.02067371890729157, -0.49020630902504475`}, {
        0.06303106941359277, -0.4863618110989587}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.06899384269658401, -0.4857136208274493}, {
        0.11228056172750883`, -0.47927478098809884`}, {
        0.15605598495536394`, -0.47006052893647}, {
        0.19851630047435945`, -0.45835231742362853`}, {
        0.23974682200969344`, -0.4441690671428742}, {
        0.29215466708698673`, -0.42193689062019274`}, {
        0.2983036653395982, -0.4187472483555434}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3036297419381436, -0.4159844765469377}, {
        0.34286817954129156`, -0.3956304979253541}, {
        0.392165130900998, -0.36546654464053385`}, {
        0.4403232926944963, -0.33166168634790744`}, {
        0.48559638746204664`, -0.2964009483074228}, {
        0.5022752327023081, -0.28239370636787764`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5068698672591578, -0.2785350364818933}, {
        0.5306213081382098, -0.2585880812812664}, {
        0.5753980547229863, -0.21822308526943845`}, {
        0.6199266272163758, -0.17530596027193862`}, {
        0.6448395991702189, -0.1503188197700867}, {
        0.6698908665230541, -0.1248086112159883}, {
        0.6808888240143348, -0.11344228174468525`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6850610163689783, -0.10913034355451436`}, {
        0.6950804292748816, -0.0987753346096435}, {
        0.720408287425701, -0.07221898995105225}, {
        0.7459044287863853, -0.04518498734704828}, {
        0.771598841167807, -0.017718736904465435`}, {0.7974915245699662, 
        0.01017976137669635}, {0.8235824789928629, 0.03851050749643708}, {
        0.8488548696095384, 0.06627572133834078}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.852866997752584, 0.07073693688522235}, {
        0.8759968018844718, 0.09654801173429227}, {0.9022295705990852, 
        0.12627458697306596`}, {0.9284794108262376, 0.15647304429173708`}, {
        0.9487158993449821, 0.17992785937047379`}, {0.9688116434978846, 
        0.20372173939796345`}, {1.0069054188062916`, 0.2533514625520826}, {
        1.0074752200014083`, 0.254168635880435}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0109070142322738`, 0.25909030108207143`}, {
        1.0427505610323156`, 0.3047583294192268}, {1.0639271884156736`, 
        0.33651344298300656`}, {1.0837946448546791`, 0.3691608564954745}, {
        1.1023529303493327`, 0.40270056995663067`}, {1.1196020448996338`, 
        0.43713258336647487`}, {1.1321695748453697`, 0.4655774477733148}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.134594375350809, 0.47106564807111934`}, {
        1.135306821985371, 0.4726781724100093}, {1.1492320950863328`, 
        0.509558612772236}, {1.1613778642025194`, 0.5477739044531549}, {
        1.1717441293339304`, 0.5873240474527661}, {1.1803049870420885`, 
        0.6284967581009655}, {1.1870345338885158`, 0.6715797527276488}, {
        1.1905163414513282`, 0.7035622742338861}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.191165700446406, 0.7095270318061191}, {1.191932769873213, 
        0.716573031332816}, {1.1949996949961792`, 0.7634765939164674}, {
        1.196380975994842, 0.8257087138690729}, {1.195103722272968, 
        0.8905595573674072}, {1.1934948959105482`, 0.9239790588561904}, {
        1.1918323865440064`, 0.9492640348767425}}]}, 
      {Arrowheads[{{0.0102128947069636, 1.}}], 
       ArrowBox[{{1.191438731280855, 0.9552511072442518}, {
        1.1912535370904567`, 0.9580677113233663}, {1.188390346220181, 
        0.9928303381329223}, {1.1849160237072085`, 1.0282717626488453`}, {
        1.1792852986023312`, 1.0771891615384939`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6322381920236446, 
        0.48954847901901866`}, {-0.6391550070435292, 
        0.4450960693791035}, {-0.643571038463079, 
        0.398887506085972}, {-0.6452456233482929, 
        0.35155532374369114`}, {-0.6438217272594584, 
        0.30389007229363746`}, {-0.6390354129614322, 
        0.25655588940733953`}, {-0.6379938944025583, 0.2506777339966347}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6369470917384078, 
        0.2447697559853073}, {-0.6307856633270669, 
        0.20999569128409362`}, {-0.6189714612292153, 
        0.1646523941231958}, {-0.6030919362999203, 
        0.12120337263894092`}, {-0.5829661007638727, 
        0.08013843473362553}, {-0.5589727613828972, 
        0.04161914638854658}, {-0.5465198952857125, 0.025391711865340862`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5428671203721753, 
        0.02063175016055441}, {-0.5314907249188191, 
        0.0058070735850012795`}, {-0.5088216241196272, \
-0.019045689380904385`}, {-0.4843292958480132, -0.04215690855620659}, \
{-0.4580137401039772, -0.0635265839409053}, {-0.4298749568875192, \
-0.0831547155350005}, {-0.40029295724378844`, -0.10100930091204562`}, \
{-0.369647752217934, -0.11705833764559405`}, {-0.35446315857848004`, \
-0.12387929069473899`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3489899967476489, -0.12633784709505463`}, \
{-0.3379393418099559, -0.13130182573564578`}, {-0.3051677260198538, \
-0.14373976518220102`}, {-0.2718042508285233, -0.15440297938695996`}, \
{-0.23832026221685904`, -0.16332229175162324`}, {-0.20471576018486112`, \
-0.17049770227619088`}, {-0.1709907447325295, -0.1759292109606628}, \
{-0.12512499260572468`, -0.18073794823703732`}, {-0.11661586000283873`, \
-0.18109597816566284`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1106211641205189, -0.1813482107537589}, \
{-0.08051418939940796, -0.1826149906376302}, {-0.03715833511357984, \
-0.18156033816244127`}, {0.004942570251760023, -0.17757399081147074`}, {
        0.04551990374436398, -0.17098216242330258`}, {
        0.08430504241198439, -0.16211106683652093`}, {
        0.12129798625462121`, -0.1509607040511258}, {
        0.12566648030079794`, -0.14929405603184426`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.13127235593101116`, -0.1471553278072721}, {
        0.15649873527227443`, -0.13753107406711718`}, {
        0.18999472691300107`, -0.12218790388663026`}, {
        0.22187339862485816`, -0.10529692051180019`}, {
        0.2521347504078457, -0.08685812394262701}, {
        0.2807787822619636, -0.06687151417911072}, {
        0.31835921156255476`, -0.03707213099712306}, {
        0.33455084708719673`, -0.02254294035122297}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.33901654266455505`, -0.018535751434992274`}, {
        0.35342358292924136`, -0.00560792618038972}, {0.3859718963620235, 
        0.027521100271089394`}, {0.4160041518609012, 0.06231494835731435}, {
        0.4422182769018579, 0.09642376986269592}, {0.4664680055067965, 
        0.1314050181607898}, {0.48875264417936365`, 0.16722679472999308`}, {
        0.4889792360921372, 0.16763528988062146`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.49188965939422513`, 0.172882140002615}, {
        0.5090714994232053, 0.20385720104870253`}, {0.5273319920001198, 
        0.24136759780788936`}, {0.5434415426719059, 0.2798293456985249}, {
        0.5572661425513347, 0.319367688973744}, {0.5685393187700297, 
        0.3602291539103993}, {0.5756155898285069, 0.39643093868959484`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5767666118732372, 0.4023194994859648}, {
        0.5768425360927864, 0.40270792330875704`}, {0.5819109082608043, 
        0.4470916107363095}, {0.583238928668991, 0.4938221629795201}, {
        0.5803210907122537, 0.5433415268248523}, {0.575251002292674, 
        0.580362464495829}, {0.5671720833908265, 0.6193958193614255}, {
        0.5616042778119867, 0.640007295211706}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5600395736334213, 0.6457996782129913}, {
        0.5560843340067109, 0.6604415914216422}, {0.5419877541403273, 
        0.7034997806764788}, {0.5256927935817752, 0.7459263926634481}, {
        0.5060729631564663, 0.7905482409401361}, {0.48296421098063547`, 
        0.837249766750162}, {0.46695339431211125`, 0.8663651055390811}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.4640622450030545, 0.8716226007290685}, {
        0.45620248517051737`, 0.8859154113371454}, {0.4257709363848225, 
        0.9359415034525655}, {0.39165271528226137`, 0.9867243718479026}, {
        0.37383451685485203`, 1.012073702916228}, {0.35515094133691055`, 
        1.0372785096092143`}, {0.3277217015429138, 1.0685471606892958`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.32376502584281464`, 1.0730576725675913`}, {
        0.3185277711825085, 1.0790280126069272`}, {0.2799639372642434, 
        1.117773924806448}, {0.240708057870609, 1.154344616822057}, {
        0.20006808752623623`, 1.1865648684698429`}, {0.15847920784060723`, 
        1.2140161960213085`}, {0.1389903271272832, 1.2243219443437827`}}]}, 
      {Arrowheads[{{0.009094684054451267, 1.}}], 
       ArrowBox[{{0.13368626162061328`, 1.227126741858926}, {
        0.1163766004232043, 1.2362801157479577`}, {0.07412458453441688, 
        1.2536007417080528`}, {0.032087479434634476`, 
        1.2662221879598576`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.23154267397474682`, 
        0.8975789783991697}, {-0.26528976028608203`, 
        0.9138180206111962}, {-0.30015729362302135`, 
        0.92831255364258}, {-0.33627648180684927`, 
        0.9407000205593665}, {-0.37379582982631543`, 
        0.950688864088019}, {-0.4129898102843838, 
        0.957776948899597}, {-0.45408049895172975`, 
        0.9613967062670189}, {-0.46077908046629135`, 0.9613698194214642}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.46677903213481975`, 
        0.9613457367446322}, {-0.4974125533147557, 
        0.9612227795557149}, {-0.5433986248877194, 
        0.9566769971238891}, {-0.5924513651848784, 
        0.9471811873297457}, {-0.6477024097847539, 
        0.9308875610251097}, {-0.6993401150028478, 0.9103035603843869}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7049136167933079, 
        0.9080818318249678}, {-0.7073182166079139, 
        0.907123301930669}, {-0.7481173575446678, 
        0.8873229059679819}, {-0.7909187002525161, 
        0.8633411775589165}, {-0.8354960103531153, 
        0.83461432355949}, {-0.8816230534681219, 
        0.8005785508257193}, {-0.9050817487556408, 
        0.7814310755812164}, {-0.9068512353011433, 0.7798667724488504}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.9113464901604522, 
        0.7758927714737801}, {-0.9285559249959876, 
        0.7606788819486507}, {-0.9520455821891625, 
        0.7383219699280221}, {-0.975550720335165, 
        0.7143603395193306}, {-0.9971324524742216, 
        0.6916302519412482}, {-1.018435456668925, 
        0.6674655400283498}, {-1.046897609496355, 
        0.6278216856305633}, {-1.0674160424525938`, 0.5950381876999645}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0705992424571682`, 
        0.5899522032592807}, {-1.07352445999515, 
        0.5852784124630972}, {-1.0989563520713446`, 
        0.5414740458195905}, {-1.1219983273023388`, 
        0.4951474922240025}, {-1.1423774683481938`, 
        0.4466689837732566}, {-1.1598208578689713`, 
        0.3964087525642764}, {-1.1669191493156843`, 
        0.37107955776481716`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1685382226200316`, 
        0.3653021360530888}, {-1.1742731203098875`, 
        0.3448380086173804}, {-1.1856788801161589`, 
        0.2924279619528874}, {-1.1931823704642868`, 
        0.2466091753844019}, {-1.198659161079715, 
        0.20066524214264275`}, {-1.2021675686713826`, 
        0.15496563856131626`}, {-1.2031092065869184`, 0.128404041813934}}]}, 
      {Arrowheads[{{0.00838556703362356, 1.}}], 
       ArrowBox[{{-1.2033217796710098`, 
        0.12240780860600088`}, {-1.203765909948228, 
        0.10987984097412824`}, {-1.2036196174526668`, 
        0.06551334515985487}, {-1.201955332774814, 0.021820800865883547`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.5846294015164717, 
        0.8486035374250669}, {-0.6266336896127048, 
        0.8242199347129426}, {-0.6704506158747108, 
        0.7923935467654227}, {-0.7157906082508622, 
        0.7519641968479027}, {-0.7389897228242118, 
        0.7279522355115287}, {-0.762519166237061, 
        0.7011041229160174}, {-0.7671622324207698, 0.6952901973908168}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.770906431167238, 
        0.6906018100617936}, {-0.7861303892439236, 
        0.6715387696151187}, {-0.8095748425993133, 
        0.6393750861625819}, {-0.8282897436689806, 
        0.611384232965095}, {-0.8466862754323692, 
        0.5816110576344427}, {-0.8647644378894791, 
        0.550055560170625}, {-0.8825242310403103, 
        0.5167177405736418}, {-0.8971284677327476, 0.48713305232145604`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8997813044571106, 
        0.48175143300908824`}, {-0.916175881166609, 
        0.44569627192693695`}, {-0.9318395310779446, 
        0.40826290711390467`}, {-0.9467283975547376, 
        0.36954778864108573`}, {-0.9606322388887893, 
        0.32998160100709384`}, {-0.9733408133719013, 
        0.2899950287105423}, {-0.9827780631533243, 0.2568741777862797}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9844222257076172, 
        0.2511038459504958}, {-0.9848541210040731, 
        0.2495880717514313}, {-0.9951721617853049, 
        0.20876073012976076`}, {-1.006831815093939, 
        0.1545847096454755}, {-1.015977151348547, 
        0.10112082315335996`}, {-1.0226081705491292`, 
        0.048369070653413976`}, {-1.0252491452594055`, 
        0.014984261279620777`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0257223095204782`, 
        0.009002947412079335}, {-1.0267248726956855`, -0.003670547854362726}, \
{-1.028307473765435, -0.05488088053523592}, {-1.0273353137938837`, \
-0.10488505436659541`}, {-1.0249533154941561`, -0.1414800348135072}, \
{-1.021164146519028, -0.17748926853321081`}, {-1.0159678068684994`, \
-0.21291275552570624`}, {-1.01273562592237, -0.22996457716813398`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0116182197685015`, -0.23585960927044664`}, \
{-1.0093642965425706`, -0.24775049579099345`}, {-1.001303157207986, \
-0.28213821682388995`}, {-0.9917339305314903, -0.3162116461192132}, \
{-0.9806566165130832, -0.34997078367696327`}, {-0.9680712151527652, \
-0.38341562949714003`}, {-0.9504674245652674, -0.42384796166963185`}, \
{-0.9316262632197643, -0.4611865069634929}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9288058927409835, -0.4664799440090677}, \
{-0.9068057405146756, -0.5048287238269226}, {-0.8807478470515816, \
-0.5453771538117211}, {-0.851310825605863, -0.5861487241691472}, \
{-0.8179335824867601, -0.6273278760010585}, {-0.7883507228932821, \
-0.6602951340716615}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7843435001337798, -0.6647607992803093}, \
{-0.780616117694273, -0.6689146093074557}, {-0.7393584312284016, \
-0.7109089240883384}, {-0.7164029320229531, -0.7327555570579969}, \
{-0.6922121828611221, -0.7546838896826771}, {-0.6667861837429084, \
-0.7766939219623791}, {-0.640124934668312, -0.7987856538971028}, \
{-0.6122523523575194, -0.8208875685633077}, {-0.6063700988719347, \
-0.8253489686511417}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6015895602980478, -0.8289747721405187}, \
{-0.5831923535307171, -0.8429281490374533}, {-0.5529449381879049, \
-0.8649073953195395}, {-0.5215101063290829, -0.8868253074095663}, \
{-0.489020793323006, -0.9085484520860472}, {-0.45560993453842885`, \
-0.9299433961274947}, {-0.4212775299753516, -0.9510101395339097}, \
{-0.40217611525901586`, -0.9622467669827617}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.397004569263999, -0.9652889885429747}, \
{-0.38602357963377415`, -0.9717486823052917}, {-0.35035506972193875`, \
-0.9922965023136727}, {-0.31401353251420105`, -1.0123097933997725`}, \
{-0.25753346438611585`, -1.0397572450706205`}, {-0.200550757775471, \
-1.065182997542908}, {-0.18273015434818712`, -1.0728861876877729`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17722267253402277`, -1.0752668691168281`}, \
{-0.16304877645394372`, -1.0813937220622925`}, {-0.12555285851985856`, \
-1.0965563314626254`}, {-0.08806300397321554, -1.1106708257439069`}, \
{-0.05057921281401466, -1.123737204906137}, {-0.013189944386254093`, \
-1.135698696035253}, {0.02401634196606787, -1.1464985262171927`}, {
        0.049526304456228756`, -1.153139460635522}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.05533277668316323, -1.1546510426802152`}, {
        0.061039646242951315`, -1.156136695451956}, {
        0.09787996844439617, -1.164613203739543}, {
        0.13455952486255396`, -1.1719621140329624`}, {
        0.17110053178957604`, -1.178217489285223}, {
        0.20750298922546248`, -1.183379329496325}, {
        0.24376689717021327`, -1.1874476346662686`}, {
        0.29218077115351765`, -1.1912239715541206`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.29816260149323526`, -1.1916905610812578`}, {
        0.2990211994319643, -1.1917575326908625`}, {
        0.3546970756123242, -1.1939763674820427`}, {
        0.4107945257112934, -1.1941041390398095`}, {
        0.46731354972887124`, -1.1921408473641624`}, {
        0.5249518166028997, -1.188270356673535}, {
        0.5378945968570257, -1.1870526384581996`}}]}, 
      {Arrowheads[{{0.013846559364612812`, 1.}}], 
       ArrowBox[{{0.5438682160501097, -1.1864906120032905`}, {
        0.5844069952712201, -1.1826765311863603`}, {
        0.6456790857338324, -1.175359370902639}, {
        0.7087680879907367, -1.1663188758223704`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7468538202868837, 
        0.07299985600577912}, {-0.7381359897819815, 
        0.03451645140623947}, {-0.7268524426821459, -0.0025557205654536917`}, \
{-0.7129042200906728, -0.03806968147105262}, {-0.6962593635894364, \
-0.0719737046202673}, {-0.6768859147603112, -0.10421606332280779`}, \
{-0.6545519230565767, -0.1347431454844137}, {-0.64765537820266, \
-0.14256222343610309`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6436865031904829, -0.1470620046683095}, \
{-0.6291854316343879, -0.1635028473340015}, {-0.6009944726299323, \
-0.19044570466604638`}, {-0.5701870781793981, -0.21552225327502378`}, \
{-0.5367138887983092, -0.2387969646420793}, {-0.500706907696455, \
-0.2601263274308824}, {-0.46242818957125326`, -0.27946535605999623`}, \
{-0.4496998501672448, -0.28493212756763203`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4441868273019583, -0.2872999491164039}, \
{-0.42213978912012184`, -0.29676906494798405`}, {-0.3802093171777187, \
-0.3119965714850631}, {-0.337004384578701, -0.32510699306145086`}, \
{-0.29283281733977984`, -0.33607451371494124`}, {-0.24821256949496429`, \
-0.34486292133588203`}, {-0.21331748797676278`, -0.34988795838628123`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.20737874842674509`, -0.35074316161186886`}, \
{-0.2003927400811343, -0.35174917590510907`}, {-0.13759818255398706`, \
-0.35705563823453385`}, {-0.07657260602839598, -0.3578860923044697}, \
{-0.01747764950608867, -0.35440284914057624`}, {
        0.03177734175742348, -0.3478059051467061}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.03772423975181774, -0.3470094101722904}, {
        0.039525048011208375`, -0.346768219768513}, {
        0.09392151384563215, -0.3349353807753076}, {
        0.1454796422602285, -0.3190248162988931}, {
        0.19446059466463406`, -0.2994497986912873}, {
        0.24112553246848534`, -0.2766236003045082}, {
        0.2618642717634404, -0.264822981129406}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.26707914757380535`, -0.261855647261694}, {
        0.28037811721703343`, -0.254288356215263}, {
        0.31814820227136775`, -0.22993787165083523`}, {
        0.35443578763148825`, -0.20357214661122494`}, {
        0.389240873297395, -0.1751911810964321}, {
        0.42282952329644247`, -0.1452051678927382}, {
        0.4553452382994599, -0.1141413902717865}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.459546085062976, -0.10985749334183376`}, {
        0.48715570837602384`, -0.08164857677749171}, {
        0.5178932434565577, -0.04807799886593908}, {
        0.5478930590144548, -0.013536054981551157`}, {0.5773678071665829, 
        0.021753765945887762`}, {0.6063174879129418, 0.05779146391637767}, {
        0.6167457299113, 0.07128712254481617}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6204143661301069, 0.07603487025231469}, {
        0.6347421012535318, 0.09457703892991859}, {0.6687532238318128, 
        0.14053352316262596`}, {0.7022483773004579, 0.18774642945734116`}, {
        0.7333793617567308, 0.2333644113225668}, {0.7585555038299009, 
        0.2721955249666274}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7618195911630219, 0.2772299796423355}, {0.764014054003477,
         0.28061466962770826`}, {0.7941862853780965, 0.32970729544673494`}, {
        0.8235128973807799, 0.38133551525804815`}, {0.8510066836578649, 
        0.435997393141185}, {0.8743148070957645, 0.4888674702202189}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8767351783171902, 0.4943576253319161}, {
        0.8767822490901752, 0.4944643964927312}, {0.8888575369321114, 
        0.5253690353923763}, {0.9001669454479978, 0.5577133860055608}, {
        0.9107104746378337, 0.5914974483322846}, {0.9204881245016192, 
        0.6267212223725475}, {0.929281688330488, 0.6636688747585354}, {
        0.9368729594155722, 0.7026245721224333}, {0.9403902076499324, 
        0.7251758538341152}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9413148292331355, 0.7311041820072071}, {
        0.9432619377568731, 0.7435883144642417}, {0.9484486233543894, 
        0.7865601017839601}, {0.9523590527635035, 0.8333179185215053}, {
        0.9545815040490387, 0.8824006092008071}, {0.9549864522199956, 
        0.9335113606886563}, {0.9539096293773349, 0.9704105320437095}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.9537346068122364, 0.9764079787589132}, {
        0.9534443722853744, 0.9863533598518435}, {0.9498588531314349, 
        1.0400888804748614`}, {0.9441334836444374, 1.093880196342203}, {
        0.9388566547131613, 1.135673054088635}, {0.9322381119513625, 
        1.17638501402869}, {0.9223364012869996, 1.2138269721142108`}}]}, 
      {Arrowheads[{{0.013937741304700407`, 1.}}], 
       ArrowBox[{{0.9207339442232367, 1.219606894620558}, {0.908166990912523, 
        1.2565533055265548`}, {0.8944413479717293, 1.2918228869851553`}, {
        0.8790628127541699, 1.3217852406509836`}, {0.84369600410261, 
        1.3661069707370226`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0863426908642362`, -1.5}, {
        1.102655010867748, -1.4816324256319815`}, {
        1.1264375557841442`, -1.4578461846519668`}, {
        1.1725144575096142`, -1.4165103341755527`}, {
        1.216315635919208, -1.3808732921477884`}, {
        1.258978952670864, -1.3480856543443493`}, {
        1.2666998521293786`, -1.3423415532800163`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.2715137544508353`, -1.3387601646611318`}, {
        1.2984188487069719`, -1.3187436392053802`}, {
        1.3177792751601805`, -1.3038684150252713`}, {
        1.335857454789662, -1.2895310841955219`}, {
        1.3693034335484058`, -1.2617358875166322`}, {
        1.3973907681201125`, -1.2354873144877294`}, {
        1.4203702807337064`, -1.2104188124885797`}, {
        1.445390689873563, -1.1753999730248845`}}]}, 
      {Arrowheads[{{0.018013829478021028`, 1.}}], 
       ArrowBox[{{1.4488787607895706`, -1.1705180306568408`}, {
        1.449440104377487, -1.1697323680052294`}, {
        1.4673145049480818`, -1.130644151690877}, {
        1.4730840118049517`, -1.1116427835677127`}, {
        1.4778133919343723`, -1.0928477612674032`}, {
        1.4813052335967902`, -1.0741444656326231`}, {
        1.4854761436476411`, -1.0367288931288388`}, {
        1.4869137937907664`, -0.9989673919499867}, {
        1.4866348776194067`, -0.9604507766278998}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.5, -0.4681793116971826}, {-1.472632075906381, \
-0.4848195158761078}, {-1.4210443654571507`, -0.5214509162300867}, \
{-1.3791798673147313`, -0.5576048460902399}, {-1.3418773703106053`, \
-0.5938108388505017}, {-1.3170832939696473`, -0.6218121441888388}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.313105719008389, -0.6263042369558652}, \
{-1.309886660734279, -0.6299396953772929}, {-1.2869435652397687`, \
-0.6623734010609867}, {-1.2653963939670982`, -0.6951773483295458}, \
{-1.2443240268629343`, -0.7285439386028654}, {-1.2240335039450554`, \
-0.7624090380743139}, {-1.205847698999217, -0.7922691862144895}, \
{-1.1877829780163132`, -0.8225340105253827}, {-1.184239033883532, \
-0.828591366465328}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.1812091209732862`, -0.8337701334765312}, \
{-1.1698393409963437`, -0.8532035110069938}, {-1.152016787939308, \
-0.8842776876593226}, {-1.1340816378769127`, -0.9156321397613956}, \
{-1.115800209840864, -0.9471424665922391}, {-1.0971725038311613`, \
-0.978808668151853}, {-1.0781985198478048`, -1.0106307444402374`}, \
{-1.0596638906767313`, -1.0407005328934344`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0564317980058406`, -1.0457551647365593`}, \
{-1.038539205230097, -1.0732992347143795`}, {-1.0176857464132374`, \
-1.1037848270779023`}, {-0.9961497532577072, -1.1337046509257267`}, \
{-0.9687335449063074, -1.169310265377009}, {-0.940058821999085, \
-1.203004406259903}, {-0.9099451296019088, -1.2342116490486772`}, \
{-0.9093426946679416, -1.2347459641372007`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9048538658689174, -1.2387272222314532`}, \
{-0.8782120127806476, -1.2623565692176009`}, {-0.844832675671131, \
-1.287282807234232}, {-0.809868127592023, -1.3090734692765809`}, \
{-0.7732696213834447, -1.3275123293845925`}, {-0.7349884098855168, \
-1.3423831615982127`}, {-0.6970823796563689, -1.3534258274670399`}}]}, 
      {Arrowheads[{{0.003195458095457159, 1.}}], 
       ArrowBox[{{-0.6901018885545579, -1.3627347654908197`}, \
{-0.654936944168146, -1.3627347654908197`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -1.1855648815248672`}, {-1.4662536354371873`, \
-1.2053454756786}, {-1.4210770246915816`, -1.2347686230312511`}, \
{-1.3801255563853987`, -1.263186512457561}, {-1.3441216978288166`, \
-1.2893457058694193`}, {-1.3066626620967432`, -1.3160949342316495`}, \
{-1.3011904079395948`, -1.3197694677525997`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.2962092099510394`, -1.3231142646969316`}, \
{-1.271930477602374, -1.3394170557039629`}, {-1.2380677898788304`, \
-1.361004595509456}, {-1.205944095696938, -1.3791229719813094`}, \
{-1.1751135746300219`, -1.394074266708174}, {-1.1451304062514067`, \
-1.4061605612787016`}, {-1.0866293943405574`, -1.4231483223754495`}, \
{-1.0805151061477967`, -1.4242135022458826`}}]}, 
      {Arrowheads[{{0.01624842530950693, 1.}}], 
       ArrowBox[{{-1.074604133761836, -1.4252432621462525`}, \
{-1.0365137153641533`, -1.431879054515611}, {-0.9858412983438547, \
-1.436257064379732}, {-0.9340070017437097, -1.4374450239220866`}, \
{-0.8804056840277664, -1.436605605096949}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7197927325727591, 1.5}, {-0.727077761924682, 
        1.486377813124913}, {-0.7590335063067366, 
        1.4362819180656063`}, {-0.7909061191826798, 
        1.3963913455672132`}, {-0.8248553289250299, 
        1.3592885104051617`}, {-0.8589960064784387, 
        1.3284309276801018`}, {-0.8737531925370269, 1.3185462973403248`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-0.8787382316759437, 
        1.315207227891591}, {-0.9121387187212575, 
        1.2928349770911542`}, {-0.9659323211875865, 
        1.2605162504054854`}, {-1.0194225336579898`, 
        1.228962958909001}, {-1.072305966136541, 
        1.1989405377908853`}, {-1.0845625289537795`, 
        1.1919112823896187`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0897673158027856`, 
        1.1889262876063047`}, {-1.123356561787279, 
        1.1696625354205046`}, {-1.1713482637742418`, 
        1.1403425001672254`}, {-1.2150658131053205`, 
        1.1105948008737003`}, {-1.2532939507884049`, 
        1.0800338063825825`}, {-1.2793443300385023`, 
        1.0556260788910545`}, {-1.284373751837968, 1.0500352001092772`}}]}, 
      {Arrowheads[{{0.004350573624300164, 1.}}], 
       ArrowBox[{{-1.288386495808791, 
        1.0455744954760804`}, {-1.3019171854037908`, 
        1.0305333141284483`}, {-1.3205808924707474`, 1.0045701425079423`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5203024102113541, 1.5}, {-0.5371532318262536, 
        1.467046423782276}, {-0.5566382998562858, 
        1.4335591759601232`}, {-0.5758033955911115, 
        1.4060510591425797`}, {-0.6034250858196214, 
        1.3722607292120585`}, {-0.6378231569715508, 
        1.3429881613054468`}, {-0.6716797518070998, 1.3182907585554142`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6766039121777949, 
        1.314863251000504}, {-0.7079849696766667, 
        1.2933014780595276`}, {-0.743979181523161, 
        1.2715277107267564`}, {-0.7808403028214743, 
        1.2514775870250898`}, {-0.8187045986282765, 
        1.232419091153481}, {-0.8575739453279783, 
        1.2139710121663927`}, {-0.887117612953812, 1.2004729523887727`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8925749917034391, 
        1.1979795576781185`}, {-0.8974502193049909, 
        1.195752139118288}, {-0.9365231175041816, 
        1.1780752397853944`}, {-0.9758095158401845, 
        1.1599855152223237`}, {-1.015309414313, 
        1.1414829654290761`}, {-1.0550228129226276`, 
        1.1225675904056511`}, {-1.0939045431789152`, 
        1.102965200990848}, {-1.1090730485348566`, 1.0945360733459268`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1143176721382073`, 
        1.0916216397372858`}, {-1.13090943659171, 
        1.0824016080234653`}, {-1.1660374931610127`, 
        1.060876811503503}, {-1.1992887128868222`, 
        1.0383908114309615`}, {-1.229727179584832, 
        1.0147410861492352`}, {-1.2564169770707336`, 
        0.9897251140017185}, {-1.2793581053445275`, 
        0.9633428949884119}, {-1.2961910409252544`, 0.9390058292114016}}]}, 
      {Arrowheads[{{0.005389957066688717, 1.}}], 
       ArrowBox[{{-1.2994294053593252`, 
        0.9339641084509062}, {-1.314308467602703, 
        0.9063622511782664}, {-1.3269459282809057`, 0.8755288960091054}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3446033746702703, 1.5}, {-0.3577593085868577, 
        1.4736885121404404`}, {-0.37630357282117743`, 
        1.4411217433113679`}, {-0.39428707142560415`, 
        1.414776892092624}, {-0.4067629544334471, 
        1.4004217344391094`}, {-0.4191177325456056, 
        1.3873414919189009`}, {-0.4436355971370981, 
        1.3632779216723856`}, {-0.46785241275641853`, 
        1.3428052598804736`}, {-0.4919166046515592, 
        1.3249278995509826`}, {-0.49874171369852355`, 1.3204655072063356`}}]}, 
      {Arrowheads[{{0.013049909238544521`, 1.}}], 
       ArrowBox[{{-0.5037635916924529, 
        1.317182103269247}, {-0.5286488296285039, 
        1.3009116386515507`}, {-0.565650297638948, 
        1.2799818952904618`}, {-0.6032391890045617, 
        1.2611881095268642`}, {-0.6417336840470148, 
        1.2435797214199056`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.5, -1.4004968513051506`}, {-1.4826776370242565`, \
-1.4049878506754614`}, {-1.4448726097074143`, -1.4149203348860995`}, \
{-1.4116030399002744`, -1.4234481271917396`}, {-1.387306908214823, \
-1.4290849171447864`}, {-1.36460642920351, -1.4340228778351178`}, \
{-1.3217405936772437`, -1.4426129540807906`}, {-1.2832059636094197`, \
-1.4488904887090375`}, {-1.265604851765152, -1.451092544904854}}]}, 
      {Arrowheads[{{0.008410430244037781, 1.}}], 
       ArrowBox[{{-1.259651264354409, -1.4518373918305003`}, \
{-1.247770886363392, -1.453323733159118}, {-1.2019804871247175`, \
-1.4572215998704214`}, {-1.159017651013966, -1.45891427446949}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.5, -1.0045132003631996`}, {-1.485708505139749, \
-1.0134207713935024`}, {-1.4446829087510478`, -1.0418114651588632`}, \
{-1.4094301020351148`, -1.0697260819321417`}, {-1.369666527329365, \
-1.1081943780813004`}, {-1.333808613639296, -1.1451978370211096`}, \
{-1.3189434003043092`, -1.160660380007022}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.314785128321807, -1.164985744051763}, \
{-1.2992124396372149`, -1.1811841909065424`}, {-1.2671397450111095`, \
-1.215136334683223}, {-1.2369434473534566`, -1.2467577926187792`}, \
{-1.207976464256733, -1.2757520889808398`}, {-1.1798981927385377`, \
-1.3019590788606767`}, {-1.1523680298164691`, -1.325218617349563}, \
{-1.1428124257819021`, -1.3319136307335158`}}]}, 
      {Arrowheads[{{0.003895932708220032, 1.}}], 
       ArrowBox[{{-1.1323328070260952`, -1.3582833944855843`}, \
{-1.105175604695955, -1.3582833944855843`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.18382426614256758`, 1.5}, {-0.19093924176723054`, 
        1.486318249652206}, {-0.2094378294878278, 
        1.4551172724355657`}, {-0.22724347466742534`, 
        1.4300542965654337`}, {-0.2387621736815254, 
        1.4172357247488803`}, {-0.25010287446611046`, 
        1.4055621942023706`}, {-0.2724661643092744, 
        1.3841281321638514`}, {-0.29425798236620637`, 
        1.3659997395149817`}, {-0.31559422955116356`, 
        1.3503129825437141`}, {-0.34661685418635585`, 
        1.3301063091735923`}, {-0.34768288275178316`, 1.3295023807871185`}}]}, 
      {Arrowheads[{{0.002314893300286829, 1.}}], 
       ArrowBox[{{-0.35579732021593097`, 
        1.3144917735821473`}, {-0.3741789647762453, 
        1.3144917735821473`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.017229442696264627`, 1.}}], 
       ArrowBox[{{-0.03644267847927633, 1.5}, {-0.05512714776299307, 
        1.47054633150413}, {-0.07362434010703414, 
        1.446326164190298}, {-0.08422138144147386, 
        1.435321556711002}, {-0.0946521189201026, 
        1.4252377914358805`}, {-0.11520328369412924`, 
        1.4066402477486206`}, {-0.1351750499613158, 
        1.3907937305587204`}, {-0.15464147435636266`, 
        1.3770425754720212`}, {-0.18391089903206875`, 
        1.358652843760174}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.33668070509341497`, -0.6527031086760351}, \
{-0.3008771323090242, -0.6657329076263793}, {-0.2645504122638067, \
-0.6781584705107697}, {-0.2136123297236373, -0.6943378563616138}, \
{-0.16252287928478576`, -0.7091926553038934}, {-0.13023577055160576`, \
-0.7178848030676176}, {-0.10752998681288317`, -0.7236178814156433}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.10171256188569419`, -0.7250867473783916}, \
{-0.09810857060216295, -0.72599673421839}, {-0.0661412794364574, \
-0.7335284487562107}, {-0.034333897054489165`, -0.7404799466810795}, {
        0.028610174064619572`, -0.7525341476589154}, {
        0.09053267546154724, -0.7620511921188514}, {
        0.134375951271472, -0.7672010542964526}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.14035088817814442`, -0.7677425230901797}, {
        0.18038349536513265`, -0.7710774901505953}, {
        0.22471518288605624`, -0.7732294359003398}, {
        0.2686510554530671, -0.7738072461393326}, {
        0.3124753227735517, -0.772644975354184}, {
        0.35647219455489665`, -0.769576678031504}, {
        0.37988593730675096`, -0.7669398448802857}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3858482463154776, -0.7662683753839885}, {
        0.4006416707971019, -0.7646023541712927}, {
        0.4449837515001672, -0.7577220037735503}, {
        0.49924075550857827`, -0.746463516240014}, {
        0.5549901574703152, -0.7315575045725504}, {
        0.6122319573853785, -0.7130039687711599}, {
        0.6187295320344043, -0.7105479372009244}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.6243419669237573, -0.7084264814241586}, {
        0.6709661552537679, -0.6908029088358421}, {
        0.7231541127232632, -0.6684320972000051}, {
        0.7770730031814228, -0.6427791607421773}, {
        0.8046613989013498, -0.6286859506313733}, {
        0.832642229108639, -0.6137003191677842}, {
        0.8421930128429084, -0.6083555747331024}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8474289121427168, -0.6054254964880267}, {
        0.8610154938032908, -0.5978222663514102}, {
        0.8897811929853047, -0.5810517921822512}, {
        0.9187950819935035, -0.5633822294357158}, {
        0.9479129161667097, -0.5448069108872122}, {
        0.9771346955049234, -0.5253258365367406}, {
        1.0064604200081442`, -0.504939006384301}, {
        1.0436215822474915`, -0.47857792812366956`}, {
        1.048590966075309, -0.47482612521985224`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0533794872017286`, -0.4712108706753101}, {
        1.0803780851704519`, -0.4508273740955062}, {
        1.1269710009934468`, -0.4088930204317751}, {
        1.170108627168636, -0.3650265421557988}, {
        1.2108542243552294`, -0.32044597374404715`}, {
        1.2241357878545547`, -0.30345370559880575`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2278307497178238`, -0.29872641707059144`}, {
        1.2468157635646318`, -0.2744372250607448}, {
        1.2776306565936837`, -0.22739158828223655`}, {
        1.3029363152392266`, -0.1797003555848672}, {
        1.3230213983377084`, -0.13170258625661752`}, {
        1.3371534918937518`, -0.08696940402626249}}]}, 
      {Arrowheads[{{0.003005248802224667, 1.}}], 
       ArrowBox[{{1.3408154676640407`, -0.05469988453526136}, {
        1.3450635805290914`, -0.05469988453526136}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.590014821142007, -0.6526475896914061}, \
{-0.5605863750002678, -0.6716326184270776}, {-0.5298765196740457, \
-0.6904281437017935}, {-0.49802567983963825`, -0.7089891167056167}, \
{-0.4651742801733426, -0.7272704886286089}, {-0.4313223206751592, \
-0.7452722594707706}, {-0.39646980134508747`, -0.7629944292321017}, \
{-0.38107862488328914`, -0.7703851258196748}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.37566988854768996`, -0.7729823495782233}, \
{-0.3432306002479615, -0.7885593873657615}, {-0.2887110164052429, \
-0.8132544719590776}, {-0.2479500726016019, -0.8309085410403179}, \
{-0.2068625429044176, -0.8479846306182507}, {-0.1555139092074973, \
-0.8683731525473327}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.14990869418034636`, -0.8705130746893015}, \
{-0.10122081181147863`, -0.8888330739019915}, {-0.04851101619155888, \
-0.9075189314816987}, {0.004019248884227758, -0.9249404419129299}, {
        0.04021465470943958, -0.936269935879137}, {
        0.07601438633678356, -0.9469359741907255}, {
        0.07739097664753679, -0.9473224869831537}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.08316759617194872, -0.94894442004903}, {
        0.11152193011836595`, -0.9569056215085072}, {
        0.14684077240629334`, -0.9661459424932943}, {
        0.18207439955267232`, -0.9746240018058988}, {
        0.21732629790960933`, -0.9823068641071329}, {
        0.252699953829211, -0.9891615940578085}, {
        0.28829885366358365`, -0.9951552563187376}, {
        0.31759945070889467`, -0.9992929375890314}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3235405058958053, -1.000131903181939}, {
        0.3259546048654228, -1.0004728099585405`}, {
        0.3639425064363372, -1.0047795131115116`}, {
        0.4022625583763268, -1.0080753657776511`}, {
        0.4409147606853917, -1.0103603679569584`}, {
        0.48015330938558537`, -1.0115729540373493`}, {
        0.5202324004989609, -1.0116515584067383`}, {
        0.5611520340255186, -1.0105961810651256`}, {
        0.5630292558057806, -1.0104977640348833`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.5690210270068257, -1.010183633688806}, {
        0.6029122099652583, -1.008406822012511}, {
        0.6457697732518903, -1.0049866785790522`}, {
        0.6899815688191246, -1.000238948094906}, {
        0.7355475966669613, -0.9941636305600726}, {
        0.7824678567954007, -0.9867607259745519}, {
        0.8071821466228662, -0.9821946801630913}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8130822944123782, -0.9811046085774064}, {
        0.8368214370380871, -0.9767187243982332}, {
        0.8929591872585692, -0.9647137917356359}, {
        0.9504876146754584, -0.9506205787045566}, {
        1.0090132265073664`, -0.9343137360227922}, {
        1.045668812099385, -0.9226464178960343}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0513861784964509`, -0.9208266043117076}, {
        1.067562224562588, -0.9156778371473437}, {
        1.1251608106494186`, -0.8945974555352131}, {
        1.1744942655353157`, -0.8753362451049582}, {
        1.2215538349220842`, -0.8541530008569206}, {
        1.259892806382439, -0.8301422382225747}, {
        1.2693814637717278`, -0.8229862779341267}}]}, 
      {Arrowheads[{{0.017871810852133636`, 1.}}], 
       ArrowBox[{{1.2741718826731299`, -0.8193735384266215}, {
        1.2940318433884364`, -0.804395962108048}, {
        1.325774752851653, -0.777805215966719}, {
        1.3527254072293091`, -0.749525529771786}, {
        1.375049954264846, -0.7196360195385142}, {
        1.3929145417017075`, -0.6882158012821699}, {
        1.4068069315197282`, -0.65536973947691}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.015190292999712014`, 1.}}], 
       ArrowBox[{{0.013823115102344876`, 0.4635058809487205}, {
        0.013310444957492087`, 0.4624492932724729}, {0.010001688019841143`, 
        0.4397932099057668}, {0.017845869281084187`, 0.4126631963516861}, {
        0.018744110157493707`, 0.4107700482602931}, {0.019688042121585616`, 
        0.40888294519421703`}, {0.02808565531183254, 0.3971147467059466}, {
        0.03767067165808521, 0.38674575325110316`}, {0.0583137152515523, 
        0.36945093194680334`}, {0.08023637068460406, 0.3598721505307402}, {
        0.10027194480670604`, 0.3587776410537689}, {0.12261629223420971`, 
        0.3725893732032201}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 1.2521043105247793`}, {1.4980465521849604`, 
        1.2533580827671333`}, {1.4573966829438039`, 1.2838263381374133`}, {
        1.4234324898742332`, 1.311339639160273}, {1.3928111348904557`, 
        1.3373754630094226`}, {1.3663771930473647`, 1.3602390969196259`}, {
        1.347872021422468, 1.3754119272568803`}, {1.3307600970166222`, 
        1.3887499596505908`}, {1.3126183401979514`, 1.4018859804642678`}}]}, 
      {Arrowheads[{{0.013173559964671679`, 1.}}], 
       ArrowBox[{{1.3077585457848413`, 1.405404843670234}, {1.29877861437781, 
        1.4119070014847825`}, {1.2706732784877433`, 1.428716300814758}, {
        1.2454428232808714`, 1.440520528164035}, {1.2004741240981014`, 
        1.4538211261892482`}, {1.1612139117572573`, 
        1.4581461838959178`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{0.779495000374682, -1.5}, {
        0.8039566319024228, -1.4737646729030078`}, {
        0.8453875465863334, -1.435032100860241}, {
        0.8870812604305527, -1.402767712203624}, {
        0.939702772501922, -1.367919615748177}, {
        0.967772719732795, -1.353450352774664}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.9731058717532598, -1.3507012639207685`}, {
        0.9791826483321852, -1.3475688576633371`}, {
        1.0187725530462124`, -1.328559304652182}, {
        1.0577787035371713`, -1.310224035205262}, {
        1.096432360840673, -1.2927853564923943`}, {
        1.1295623244806807`, -1.277482676829843}, {
        1.161748701551005, -1.2625318998917898`}, {
        1.190520197669025, -1.2490877917941432`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.195952690424058, -1.2465406422716834`}, {
        1.2232906959826044`, -1.2336860541891776`}, {
        1.2794104392243475`, -1.2057380200050023`}, {
        1.3284600263651116`, -1.1781779979597087`}, {
        1.3698198762936047`, -1.1507935166086192`}, {
        1.4015511944940875`, -1.124466631362044}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3384797699165798`, 1.5}, {-1.342642925313217, 
        1.485750991347845}, {-1.3552381748510594`, 
        1.4441285756266034`}, {-1.3668187113981791`, 
        1.4067224982393405`}, {-1.3765871667768421`, 
        1.3744632795757294`}, {-1.3829413722882737`, 
        1.3510605342460476`}, {-1.3884011801702218`, 
        1.329407436964026}, {-1.3976906999891898`, 
        1.2888401902297038`}, {-1.4013071714336633`, 
        1.2685527237921854`}}]}, 
      {Arrowheads[{{0.012958668780858542`, 1.}}], 
       ArrowBox[{{-1.4023601403016495`, 
        1.2626458416566546`}, {-1.4040957679355401`, 
        1.2529094209738931`}, {-1.4082860749604547`, 
        1.2202327914195341`}, {-1.4114011364160124`, 
        1.1803505405767956`}, {-1.4122465209390813`, 
        1.1431254510876874`}, {-1.4114817094392373`, 1.1077022036567443`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.5, -0.23320093635394684`}, {-1.4542681044556498`, \
-0.2635829724166063}, {-1.4144997509056092`, -0.29566473872311827`}, \
{-1.3774205103883594`, -0.32938787082711857`}, {-1.3467673680191068`, \
-0.3622062283080765}, {-1.3238287573873673`, -0.3937122116124906}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.320297193334532, -0.3985627842942181}, \
{-1.314131583254466, -0.40703119641222607`}, {-1.284889949983278, \
-0.45148260457629885`}, {-1.256616156298548, -0.49597528355841786`}, \
{-1.2302780417867358`, -0.5405505041766295}, {-1.2051405609603099`, \
-0.5855115644649482}, {-1.1954814222315846`, -0.6033837886206316}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.1926286681242915`, -0.6086622158488239}, \
{-1.1804686683317398`, -0.6311617624573886}, {-1.155809104732984, \
-0.6777291967612533}, {-1.1307086109959998`, -0.7254419659838449}, \
{-1.1086774662477568`, -0.766911417903014}, {-1.085591756380107, \
-0.8093068148248418}, {-1.079464856817961, -0.8203019468608698}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0765442654548238`, -0.8255431438701004}, \
{-1.0614514813930502`, -0.8526281567493285}, {-1.0362566412865868`, \
-0.8968754436764739}, {-1.0095556649258486`, -0.9415023794536542}, \
{-0.9808969811759672, -0.9859626679282455}, {-0.9506617175917466, \
-1.029704920562109}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-0.9471152664166856, -1.0345442624833636`}, \
{-0.9177064915087758, -1.0743833029696608`}, {-0.8907976198704327, \
-1.107901735626248}, {-0.862313716921894, -1.1398800344134195`}, \
{-0.8322547826631593, -1.1703181993311753`}, {-0.8006208170942286, \
-1.1992162303795157`}, {-0.785798991414842, -1.2111820268030966`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7811304702305265, -1.2149509669660068`}, \
{-0.7673881417217422, -1.2260452753784161`}, {-0.73253307805234, \
-1.2502764821478523`}, {-0.6960556260860226, -1.271909850687825}, \
{-0.6579557858227892, -1.2909453809983336`}, {-0.6184281608254989, \
-1.3073888411886805`}, {-0.5776673546570104, -1.3212459993681684`}, \
{-0.5689515918343866, -1.3235852416120417`}}]}, 
      {Arrowheads[{{0.0060455746028531725`, 1.}}], 
       ArrowBox[{{-0.5631566790834637, -1.325140550651812}, \
{-0.5356733673173236, -1.3325168555367972`}, {-0.49244619880643836`, \
-1.3412014096945668`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5344729750894809, -1.5}, {
        0.535370999646272, -1.4988869297014433`}, {
        0.5682961663935204, -1.4632596737770205`}, {
        0.6011056311071309, -1.4338595131237035`}, {
        0.646344187526227, -1.3994626197894287`}, {
        0.6807581031949483, -1.3805133570336638`}, {
        0.7155915657657345, -1.3631392232944457`}, {
        0.7255273334382875, -1.3585100306234854`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.7309660042315214, -1.355976089029284}, {
        0.7509849827926437, -1.3466490081343414`}, {
        0.7868915517576569, -1.3312731150324961`}, {
        0.8222269935388558, -1.315879276706967}, {
        0.858032355615858, -1.3010726836805724`}, {
        0.8943076379886634, -1.2868533359533134`}, {
        0.9310528406572722, -1.2732212335251891`}, {
        0.9530850390006463, -1.2653070184182134`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9587317813984004, -1.2632786446130664`}, {
        0.9680513544119494, -1.2599309484646892`}, {
        1.0050865700429603`, -1.2467370528403028`}, {
        1.0421584875503047`, -1.2336395466520298`}, {
        1.0792671069339828`, -1.2206384298998705`}, {
        1.1158815748198632`, -1.2076256599015507`}, {
        1.1514710378338142`, -1.1944931939747965`}, {
        1.1844793119252366`, -1.1818376797751353`}}]}, 
      {Arrowheads[{{0.009104628674621336, 1.}}], 
       ArrowBox[{{1.1900607325930246`, -1.1796362089533796`}, {
        1.2195749492459296`, -1.1678691743359848`}, {
        1.256254271021559, -1.1524683799671966`}, {
        1.2905669483895696`, -1.1368483580857798`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.4264736238456911, -0.4957078902889265}, \
{-0.3879910594759242, -0.5098088301498038}, {-0.34860871336366606`, \
-0.5228253504204573}, {-0.3087579754648996, -0.5346798991363215}, \
{-0.2684388457796248, -0.5453724762973965}, {-0.22765132430784168`, \
-0.5549030819036823}, {-0.19590297426321734`, -0.5611752055150316}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1900167415815961, -0.5623380747328777}, \
{-0.1717450945079048, -0.5659477750438564}, {-0.11656938525018387`, \
-0.5745285945967015}, {-0.062124196534678926`, -0.5806455405622177}, \
{-0.008409528361389692, -0.5842986129404052}, {
        0.04218278879510662, -0.5854010200229597}, {
        0.04848581207279511, -0.5852264316800909}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.05448351166887361, -0.5850603005415291}, {
        0.09157436456780862, -0.5840329157044567}, {
        0.14279193279836977`, -0.579783618797445}, {
        0.19271391158694667`, -0.5726012507612276}, {
        0.24147837277857123`, -0.5624201009532518}, {
        0.2892233882182756, -0.549174458730965}, {
        0.29083087909327543`, -0.5486178215469943}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.29650057958929715`, -0.546654534434672}, {
        0.3331406611253248, -0.5339669154105988}, {
        0.37663403086960034`, -0.5159565524885097}, {
        0.4197034974511021, -0.49514336996469743`}, {
        0.46234906086983013`, -0.47152736783916227`}, {
        0.5049292186958774, -0.4451773052495899}, {
        0.5111353953120984, -0.44097714608573724`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.5161044033509545, -0.43761426649975993`}, {
        0.5478024684993371, -0.41616194133366624`}, {
        0.5909688102802089, -0.3844812760913912}, {
        0.634428244038493, -0.3501353095227648}, {
        0.6604734439964877, -0.3285450631139188}, {
        0.686788906271294, -0.30617380361534124`}, {
        0.7052031510331602, -0.29013769322965777`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7097278965021437, -0.2861973025839332}, {
        0.7133746308629123, -0.28302153102703215`}, {
        0.7402306177713421, -0.25908824534899144`}, {
        0.7673638434222855, -0.2344548524563257}, {
        0.7947812842414435, -0.2092022582241414}, {
        0.8224829402288163, -0.1833304626524385}, {
        0.8504688113844039, -0.15683946574121702`}, {
        0.8786168628277982, -0.12980373627251465`}, {
        0.8856315820244437, -0.12295878553466401`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8899258690879873, -0.11876842771988477`}, {
        0.9068050596785907, -0.10229774302836905`}, {
        0.935033401936782, -0.0743214860087803}, {
        0.9633018896023716, -0.045874965213748335`}, {
        0.9874777758886307, -0.021363135530361108`}, {1.0114540325397432`, 
        0.0034493461348475926`}, {1.0484194676342093`, 0.04472332147855078}, {
        1.056272118223302, 0.05409916143745045}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.0601246351603169`, 0.05869895635135827}, {
        1.08350062938677, 0.08660922413429194}, {1.1072940336747055`, 
        0.11601480460088238`}, {1.1296665128746475`, 0.14571771524152105`}, {
        1.1506180669865969`, 0.17571795605620802`}, {1.170148696010553, 
        0.2060155270449433}, {1.1880559923698613`, 0.23663551222149928`}, {
        1.1974902416768332`, 0.2548025948380789}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.200255442887694, 0.2601274105403783}, {1.204137548487867, 
        0.2676029955996484}, {1.2183933643645697`, 0.29891797717939067`}, {
        1.23082343999997, 0.33058045696072613`}, {1.241495586896465, 
        0.36268245648891256`}, {1.2504776165564513`, 0.3953159973092079}, {
        1.2577695289799296`, 0.4284810794216121}, {1.2633713241668991`, 
        0.46217770282612514`}, {1.2663874815577334`, 0.4893723901531191}}]}, 
      {Arrowheads[{{0.006712480287059476, 1.}}], 
       ArrowBox[{{1.267048884848494, 0.4953358242046511}, {1.269522981350511, 
        0.5176431086300645}, {1.2727979618338385`, 0.5756564398191182}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7063808538244103, 
        0.8355245592596028}, {-0.7536942642553222, 
        0.8021104549898415}, {-0.8030180760320691, 
        0.760736086232847}, {-0.8283737246941394, 
        0.7365669555014396}, {-0.8541597844154787, 
        0.7098115420439861}, {-0.8800518215562037, 
        0.6805828013659275}, {-0.8841275550333307, 0.6755679651693782}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8879117701623255, 
        0.670911816991164}, {-0.9057254024764302, 
        0.6489936889727049}, {-0.9274930337007218, 
        0.6197668729502359}, {-0.9487545429320658, 
        0.5887149301292958}, {-0.969509930170462, 
        0.5558378605098843}, {-0.9897591954159105, 
        0.5211356640920016}, {-1.009168720190749, 
        0.48487861358269835`}, {-1.0168134824254296`, 
        0.46914082898156645`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0194350991604306`, 
        0.4637438737571123}, {-1.0274048860173157`, 
        0.44733698168902497`}, {-1.04446769289561, 
        0.40851076841098166`}, {-1.0603571408256325`, 
        0.36839997374856814`}, {-1.0748490720990997`, 
        0.3274580965597532}, {-1.0877193290077285`, 
        0.28613863570250553`}, {-1.0989679115515185`, 
        0.24444159117682504`}, {-1.1003753536058853`, 
        0.2382903326375866}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1017136036995403`, 
        0.2324414791869663}, {-1.1085948197304702`, 
        0.20236696298271167`}, {-1.1192804172506752`, 
        0.1442899814523662}, {-1.1269218284773128`, 
        0.08710409206512439}, {-1.1315190534103836`, 
        0.030809294820986283`}, {-1.1325255458274697`, \
-0.005096707543836638}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1326936676715689`, -0.01109435166845229}, \
{-1.133072092049887, -0.02459441028004811}, {-1.133088332396487, \
-0.05343672212287785}, {-1.1323619499365305`, -0.0819154006722344}, \
{-1.1279877987947131`, -0.1291775209546952}, {-1.1218147085349446`, \
-0.17542497649720545`}, {-1.1146827100387446`, -0.22188753250697135`}, \
{-1.109334137326999, -0.24940851470580572`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.1081894822162004`, -0.2552983164577599}, \
{-1.1057723063711937`, -0.267735850167602}, {-1.0950834975322923`, \
-0.31296992947909746`}, {-1.0826162835220396`, -0.3575897704414576}, \
{-1.0682414829293163`, -0.4020131275906138}, {-1.0518299143430017`, \
-0.4466577554624973}, {-1.0365176284493445`, -0.4838968562985486}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0342358643587106`, -0.48944605017105786`}, \
{-1.0333815777630961`, -0.491523654057108}, {-1.0128964731895993`, \
-0.536610823374446}, {-0.9898589337720212, -0.5823368729459207}, \
{-0.9637532926598712, -0.6291194123029419}, {-0.9345795498531493, \
-0.6769584414455093}, {-0.9194832453579722, -0.6998523438759017}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9161802759453657, -0.7048613750256736}, \
{-0.9023377053518555, -0.725853960373623}, {-0.8662099859015995, \
-0.7757057508888765}, {-0.8253786182479905, -0.8264135947928629}, \
{-0.8031990663449287, -0.852088536765631}, {-0.7798436023910287, \
-0.8779774920855824}, {-0.7665655536211159, -0.8921061936690066}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7624565750809563, -0.8964784122541768}, \
{-0.7553122263862904, -0.9040804607527171}, {-0.7296049383307139, \
-0.9303974427670348}, {-0.690813990515847, -0.9675952595548543}, \
{-0.6493526416915236, -1.0039104398120007`}, {-0.6052208918577435, \
-1.0393429835384738`}, {-0.5832393929594015, -1.0555699887781709`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5784122176895762, -1.0591334672633574`}, \
{-0.5584187410145066, -1.073892890734274}, {-0.5093969407907208, \
-1.1067093768386196`}, {-0.4586062428152937, -1.1369416572907292`}, \
{-0.40604664708822524`, -1.164589732090603}, {-0.37184896119335986`, \
-1.1803664685605146`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.36640079210536797`, -1.1828799230734608`}, \
{-0.35171815360951597`, -1.1896536012382404`}, {-0.30674130585499726`, \
-1.2078610331674957`}, {-0.26149319597693504`, -1.2238708269100715`}, \
{-0.21597382397532938`, -1.2376829824659683`}, {-0.17018318985018055`, \
-1.2492974998351862`}, {-0.1383729252165265, -1.2559644096069844`}}]}, 
      {Arrowheads[{{0.0006876429688738445, 1.}}], 
       ArrowBox[{{-0.132267487316828, -1.258838981315296}, \
{-0.1246572923551649, -1.258838981315296}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -0.020153319442996274`}, {-1.4966374575492656`, \
-0.022357256074857983`}, {-1.4632806647084757`, -0.04694929109326862}, \
{-1.4357056703958957`, -0.0707938479182172}, {-1.4030865915635076`, \
-0.10315952363622644`}, {-1.3758871835258188`, -0.13869286683354454`}, \
{-1.3521083179179583`, -0.17323958804960937`}, {-1.3380676217064615`, \
-0.1944581865609232}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.334756588136587, -0.1994618908586575}, \
{-1.32951994080983, -0.2073756235894337}, {-1.3093125407011663`, \
-0.24069028777677706`}, {-1.2909149360847767`, -0.27331946143062785`}, \
{-1.2737559454534708`, -0.30539902536997454`}, {-1.257544030828237, \
-0.33703995298905565`}, {-1.241987654230064, -0.36835321768210977`}, \
{-1.2268539948759085`, -0.3994596647671185}, {-1.221386240618148, \
-0.4108094211518136}}]}, 
      {Arrowheads[{{0.015770934901140902`, 1.}}], 
       ArrowBox[{{-1.2187821651400248`, -0.4162148620130421}, \
{-1.2118844953524759`, -0.43053278268397155`}, {-1.1970791556597675`, \
-0.46157257143266905`}, {-1.182437975797782, -0.4925790310132108}, \
{-1.1677271684079888`, -0.523738024539488}, {-1.1527129461318568`, \
-0.555235415125392}, {-1.1373953089693858`, -0.5870712027709226}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.44875824519260976`, 
        0.7626629198444593}, {-0.48180905526533196`, 
        0.7309281766801876}, {-0.5125309011423449, 
        0.6886363913170149}, {-0.5368291218660507, 
        0.640841495957913}, {-0.5569160749384542, 
        0.5834668452574584}, {-0.5635427373913258, 0.5567755486349601}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5649662895181249, 
        0.5509475348351657}, {-0.5712497025623454, 
        0.5169216518963432}, {-0.5757907309298331, 
        0.480679967104944}, {-0.5783423655819634, 
        0.4429830742520161}, {-0.5786527292292866, 
        0.4042059853813568}, {-0.5765281243624814, 
        0.36473821330914596`}, {-0.5718766680874517, 
        0.32499464720323346`}, {-0.5695705525287914, 0.31243204850258344`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5684872344094748, 
        0.3065306569842752}, {-0.5646064775101014, 
        0.28539017623146873`}, {-0.5543816300440311, 
        0.24646817830723522`}, {-0.541061434856684, 
        0.20866924034748924`}, {-0.5248468566847282, 
        0.17225406502544224`}, {-0.5059388602648318, 
        0.13748335501430578`}, {-0.4880282129161192, 
        0.10978737983665429`}, {-0.47247903522182544`, 
        0.08924648447893885}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4688576808004878, 
        0.08446257476458821}, {-0.4682740224223064, 
        0.08369154584546555}, {-0.4466762887833939, 
        0.059195853040739765`}, {-0.423235011999381, 
        0.03630030142247649}, {-0.3982557046625148, 
        0.015104491069555224`}, {-0.372043879365042, \
-0.0042919779391446256`}, {-0.34459953610696226`, -0.021889105603623407`}, \
{-0.3159226748882756, -0.037686891923880944`}, {-0.2766918991389217, \
-0.05504239167547449}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2712048643851568, -0.0574698285152245}, \
{-0.25656091103286305`, -0.06394824052501677}, {-0.1956481002625858, \
-0.08313982373583655}, {-0.15339969993027452`, -0.09246592819429678}, \
{-0.11196919373429873`, -0.09879109364785063}, {-0.07135658167465893, \
-0.10211532009649806`}, {-0.03715976895468929, -0.10239313083986447`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.03116069132997606, -0.10241426832054067`}, {
        0.007021816831564699, -0.1000977270897481}, {
        0.04400131687005089, -0.09542944985569946}, {
        0.0793766363641039, -0.08843377583809309}, {
        0.11314777531372334`, -0.07911070503692913}, {
        0.14531443754268158`, -0.06782291889128711}, {
        0.17587632687475105`, -0.05493309884024659}, {
        0.19882970165831343`, -0.042465460270831826`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.20410212526072574`, -0.03960162554153516}, {
        0.2321857868482226, -0.02434735702197037}, {
        0.2634574954621296, -0.0030894559076768534`}, {0.2926645323693797, 
        0.019571280318039244`}, {0.3198068975699731, 0.043634851655178025`}, {
        0.34488459106390995`, 0.06910125810373963}, {0.37259462122281095`, 
        0.101281134480979}, {0.38387475649086034`, 0.11629604135798337`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3874786311199401, 0.1210931329412112}, {0.397599223081717,
         0.13456458006797217`}, {0.41989839664062817`, 
        0.16895159486471922`}, {0.43949214189954433`, 0.20444217887122018`}, {
        0.46459336267340057`, 0.2622837526027909}, {0.4821085526700691, 
        0.32256731734121064`}, {0.48431802156250264`, 
        0.3382082561028299}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.48515726090716615`, 0.34414927262547723`}, {
        0.49103160574422683`, 0.38573404812322126`}, {0.49190128867946004`, 
        0.4185925472534005}, {0.49007283440468025`, 0.4524840782075509}, {
        0.4862609255960793, 0.48148005944635575`}, {0.48014736271476544`, 
        0.5114575084037987}, {0.47173214576073874`, 0.5424164250798799}, {
        0.46101527473399917`, 0.5743568094745993}, {0.45894052461446067`, 
        0.5795356565042331}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.45670920359108574`, 0.5851053249405627}, {
        0.4477321183517398, 0.6075133011053727}, {0.43161804533115355`, 
        0.6421205394896154}, {0.41267305567224055`, 0.6781785246273279}, {
        0.3908971493750007, 0.7156872565185096}, {0.3650727804722286, 
        0.7564757015774699}, {0.3395234739137319, 0.7938905143386392}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.33613990930908966`, 0.7988454604096084}, {
        0.3359793642173871, 0.7990805652071504}, {0.30369331018983425`, 
        0.8433280514558326}, {0.26829102796892795`, 0.8890443643717978}, {
        0.22999566081173, 0.9355852938123792}, {0.1890303519753022, 
        0.9823066296349102}, {0.18587159196463468`, 0.9858022665102714}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.18184888522103598`, 0.9902539887000543}, {
        0.17137738337140931`, 1.0018422600097927`}, {0.1533198896210541, 
        1.021185551035423}, {0.10718207513838668`, 1.0642016652757942`}, {
        0.05987234022536127, 1.1029877675338688`}, {0.012955768134153292`, 
        1.13838617197609}, {0.0003366208490598252, 1.1462905646969967`}}]}, 
      {Arrowheads[{{0.019710794300019988`, 1.}}], 
       ArrowBox[{{-0.004748210694997435, 
        1.1494756060104745`}, {-0.034581004510847724`, 
        1.1681622979837805`}, {-0.08240043731109997, 
        1.1920631312765324`}, {-0.13016498986806171`, 
        1.209835657573937}, {-0.17774116192261408`, 
        1.2220229691194446`}, {-0.22499545321563813`, 
        1.229168158156505}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 1.0096393731201305`}, {1.4845009095226973`, 
        1.0233620477105159`}, {1.449365735000493, 1.0588947525798424`}, {
        1.4202349087116195`, 1.0938871464388509`}, {1.384127489708439, 
        1.1437216193125088`}, {1.3560682330046843`, 1.1915746778627776`}, {
        1.3527143889160047`, 1.1974718489113243`}}]}, 
      {Arrowheads[{{0.01659560672596972, 1.}}], 
       ArrowBox[{{1.3497482075011025`, 1.2026873803141527`}, {
        1.3309726048823518`, 1.235701121339279}, {1.3069045670577535`, 
        1.2773671462980065`}, {1.2848917098286239`, 1.314112334221186}, {
        1.264509386004598, 1.3457490902670972`}, {1.245332948395312, 
        1.372089819594021}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6493768941287084, 0.41400890409198365`}, {
        0.6591593867569084, 0.46019236771227423`}, {0.6659871777141885, 
        0.5090938645527692}, {0.6693141011972386, 0.5664448389451757}, {
        0.6675884789907284, 0.6285312374755135}, {0.6654100122932207, 
        0.6522898011805877}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6648621593714151, 0.6582647369271936}, {0.664559994702382,
         0.6615601733673558}, {0.6597264368886326, 0.696192870443579}, {
        0.6530878055494808, 0.7324293287041834}, {0.6446441006849262, 
        0.7702695481491686}, {0.6327633969895321, 0.8145096180988469}, {
        0.6180106577101873, 0.8608625771034852}, {0.6070169236511198, 
        0.890552932351447}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6049334864493031, 0.8961795911669507}, {
        0.6001849727597272, 0.9090037196737737}, {0.5790854320509872, 
        0.9586083403204017}, {0.5546120194451993, 1.0088076012647487`}, {
        0.5266647188035959, 1.0587326647281938`}, {0.5088965302971649, 
        1.0885343980280249`}, {0.49541214406840384`, 
        1.1091817579361187`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.49213134310638, 1.1142053368443856`}, {
        0.48989348048027326`, 1.117631963335367}, {0.4595354516376262, 
        1.1539622291391456`}, {0.427242782780847, 1.1868265556531228`}, {
        0.3941707615976445, 1.2175583537336976`}, {0.35954003576159577`, 
        1.2440250949474676`}, {0.3236769714452164, 1.266164594411341}, {
        0.31322248415188075`, 1.271211447086947}}]}, 
      {Arrowheads[{{0.008496060503542754, 1.}}], 
       ArrowBox[{{0.30781914576396213`, 1.273819882300949}, {
        0.2869079348210223, 1.2839146672422264`}, {0.2495525820078091, 
        1.2976312125029794`}, {0.21193056912437253`, 1.3076701292564559`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3763301967882926`, -1.5}, {
        1.3868936435133958`, -1.479301431659909}, {
        1.4049096033418647`, -1.4450837049199963`}, {
        1.4207385461295083`, -1.4151252728760728`}, {
        1.431780391440064, -1.3929972665805554`}, {
        1.4415560627225226`, -1.3724517909460032`}, {
        1.45872129054272, -1.3339006009082115`}, {
        1.4715703236036886`, -1.2997163871152453`}, {
        1.4767915273616712`, -1.282483934723454}}]}, 
      {Arrowheads[{{0.006882116107992417, 1.}}], 
       ArrowBox[{{1.4785313423736464`, -1.2767417187989083`}, {
        1.480962082350897, -1.2687191223103584`}, {
        1.48953514415676, -1.2307717703985097`}, {
        1.4943256013303756`, -1.1957994133824157`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 0.8004675190663401}, {1.4872274707718425`, 
        0.8115453102031743}, {1.4522319368770327`, 0.8467258694769534}, {
        1.4238628097928117`, 0.8820980216397839}, {1.3951312062874524`, 
        0.9328779765521028}, {1.3701324650524633`, 0.9840687772556409}, {
        1.3647218258541844`, 0.9956844717076626}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.3621883657116112`, 1.001123366789018}, {1.34638097396483, 
        1.03505906752331}, {1.3251239831719086`, 1.0856483369192413`}, {
        1.30569531180163, 1.1350606706663955`}, {1.2874287789819256`, 
        1.182520153987734}, {1.2715552142961444`, 1.2232796555205}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.14124974124168843`, 0.4984254268667703}, {
        0.10081701313255512`, 0.5319656722808478}, {0.05642037773507419, 
        0.5593862864203641}, {0.011319770118619229`, 
        0.5787683079884278}, {-0.010600846288473654`, 
        0.5848691761550393}, {-0.03152943457355817, 
        0.5881602695108276}, {-0.06077188389469293, 
        0.587072572462926}, {-0.07293889016940477, 0.5825122911800693}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.07855722132096057, 
        0.5804065003377828}, {-0.08538352180928847, 
        0.5778479539176352}, {-0.11221614510445532`, 
        0.5428700344799412}, {-0.11346539773935244`, 
        0.5393714875519076}, {-0.11458747069735058`, 
        0.5357420358152981}, {-0.11624657515431534`, 
        0.5174131021403587}, {-0.11522841227143486`, 
        0.49727779654214943`}, {-0.10785456894870514`, 
        0.45456528262373924`}, {-0.09005352004810824, 
        0.4090992400422999}, {-0.06354792405446026, 
        0.36626036082842095`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.05980439982528157, 
        0.3615845624958017}, {-0.040126115357160076`, 
        0.3383795051305284}, {-0.014892891221609608`, 0.31539491820253096`}, {
        0.038953501948185254`, 0.28335658963731025`}, {0.09143732116364209, 
        0.27121858929072545`}, {0.14746621829010892`, 0.2817213757985828}, {
        0.14890966154702567`, 0.28297450309493566`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.15344046502754546`, 0.28690792651746594`}, {
        0.1846777957657932, 0.31402665919069417`}, {0.19962703175894195`, 
        0.3597730358809179}, {0.1909519434086748, 0.4116055683226428}, {
        0.1615542727848969, 0.46217066577141325`}, {0.13363458651142868`, 
        0.4900602498739562}}]}, 
      {Arrowheads[{{0.001546583614558306, 1.}}], 
       ArrowBox[{{0.12697802275455028`, 0.5050076833052989}, {
        0.11867101980988783`, 0.5050076833052989}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.32313378495326023`, -1.5}, {
        0.34147907259288224`, -1.4797058172206803`}, {
        0.37155732503504835`, -1.4520157136735499`}, {
        0.41287501132604876`, -1.419642040119646}, {
        0.44238135597150463`, -1.4027316742246543`}, {
        0.47187143449745883`, -1.3873655933520233`}, {
        0.5015274605826748, -1.3729605192566998`}, {
        0.518920044270944, -1.3652173766007243`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5244013796078213, -1.3627770973288582`}, {
        0.5312886963342317, -1.3597108780203693`}, {
        0.5617111258576675, -1.3459859545787256`}, {
        0.5924254370697946, -1.3329944983204174`}, {
        0.6234316299706133, -1.3207365092454455`}, {
        0.6547297045601235, -1.309211987353809}, {
        0.6864255218506267, -1.2981662356066932`}, {
        0.7186249428544244, -1.287344556965282}, {
        0.7485990518870244, -1.277631272443141}}]}, 
      {Arrowheads[{{0.002638154299599981, 1.}}], 
       ArrowBox[{{0.7560015568389673, -1.2668996966567212`}, {
        0.7828499329683618, -1.2668996966567212`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, 0.17535835801672126`}, {-1.4797009911027752`, 
        0.15922523643254244`}, {-1.4529290160112522`, 
        0.13386834054777888`}, {-1.4222341492366017`, 
        0.10002403719330386`}, {-1.3925219002458749`, 
        0.055097966015299905`}, {-1.3673543714530438`, 
        0.01166380810862478}, {-1.3541059156683912`, \
-0.012371328645622827`}}]}, 
      {Arrowheads[{{0.010016124538564986`, 1.}}], 
       ArrowBox[{{-1.3512095149181873`, -0.01762593259779828}, \
{-1.3412099708297678`, -0.035766945675239845`}, {-1.3187236999759278`, \
-0.08150591186046591}, {-1.2988413096339433`, -0.125755928065711}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.783865066004282, 0.4481566502706902}, {0.8051998605582156,
         0.5084599417695997}, {0.8185318872943566, 0.5556158401919321}, {
        0.8299365201070689, 0.605994808176195}, {0.8390088134478466, 
        0.6601196473510882}, {0.8412194153537547, 0.6804960702979513}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.8418665475545746, 0.6864610698716866}, {
        0.8453438217681841, 0.7185131593453115}, {0.8473592202321119, 
        0.7493975890917945}, {0.8484390498137777, 0.7815230299273548}, {
        0.8485833105131816, 0.8148894818519925}, {0.8477920023303235, 
        0.8494969448657079}, {0.844479626658415, 0.9045468768188001}, {
        0.8422101823073426, 0.9259603229236746}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8415778304881667, 0.9319269074723745}, {
        0.8383922754469847, 0.9619843579475217}, {0.8293062651791037, 
        1.020760465328738}, {0.8169979123378429, 1.0798262760393147`}, {
        0.8013368888945209, 1.137270072084386}, {0.791155562969827, 
        1.1659409503260143`}}]}, 
      {Arrowheads[{{0.017984123634941195`, 1.}}], 
       ArrowBox[{{0.7891477397818654, 1.1715950325721338`}, {
        0.7821928668204564, 1.1911801354690872`}, {0.7683497718163181, 
        1.2257410744653372`}, {0.7529500261915336, 1.2574241850394283`}, {
        0.7402717849986172, 1.2757361751254739`}, {0.7268893802409411, 
        1.2923167454056959`}, {0.6987653601477333, 1.3218828766392046`}, {
        0.668030039291692, 1.3445381523655562`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.058219090505088916`, -0.4112699757291027}, \
{-0.02584519719356819, -0.40975709606779426`}, {
        0.03733257999963281, -0.4032428636526958}, {
        0.08443138702900033, -0.395089398565539}, {
        0.12982921259895047`, -0.3841997408817527}, {
        0.17352605670948326`, -0.3705738906013369}, {
        0.1770864404972297, -0.36918672652096535`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.1826771040175301, -0.36700854347016765`}, {
        0.21552191936059872`, -0.35421184772429154`}, {
        0.25601045796278077`, -0.33535579499658713`}, {
        0.2951853299265135, -0.31424791516419404`}, {
        0.33304653525179667`, -0.29088820822711237`}, {
        0.3695940739386303, -0.2652766741853422}, {
        0.3905162944898067, -0.24906017447291776`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.395258589579711, -0.24538449259328377`}, {
        0.40508727561233626`, -0.23776642529341413`}, {
        0.4397854698982364, -0.20871057380585878`}, {
        0.4736886567963307, -0.17810911972267635`}, {
        0.506796836306619, -0.14596206304386677`}, {
        0.5463560039499014, -0.10528911951029586`}, {
        0.5693746646104111, -0.08060627126638187}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.5734668004720078, -0.07621828492977661}, {
        0.5855411373867534, -0.0632710057588452}, {
        0.6243522366171752, -0.01990772178951462}, {0.6627893016411671, 
        0.024800732397695993`}, {0.6983277765087393, 0.06751726835209107}, {
        0.7296248861222396, 0.1059635127766293}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.7334127805764226, 0.1106166682225574}, {
        0.7339138052131896, 0.11123214089354018`}, {0.7545735001268609, 
        0.1369563419960292}, {0.7752915865639767, 0.16306460013368518`}, {
        0.7960287506096644, 0.18962043603373532`}, {0.816745678349051, 
        0.21668737042340697`}, {0.8375206381992445, 0.24423676120900334`}, {
        0.858337832711768, 0.27231369655356685`}, {0.879016849173372, 
        0.3010922925694339}, {0.8791356220729373, 0.30126528187204127`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8825317412432522, 0.30621163149383507`}, {
        0.8993772748708069, 0.3307466653689406}, {0.9184731852549827, 
        0.3602225579545436}, {0.9370515607021468, 0.39070380287684797`}, {
        0.9551124012122991, 0.4221904001358537}, {0.9726557067854396, 
        0.4546823497315607}, {0.989415802737045, 0.4884542330361882}, {
        1.0009950569506523`, 0.5144899937775249}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0034332600532831`, 0.5199722529496473}, {
        1.0051270143825917`, 0.5237806314219551}, {1.0197893417220798`, 
        0.5606615448888616}, {1.0334027847555094`, 0.5990969734369076}, {
        1.0457032612191348`, 0.6394310074484029}, {1.0564266888492102`, 
        0.6820077373056566}, {1.0655730676457358`, 0.726827163008669}, {
        1.0693128404011525`, 0.7500791074794605}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.070265617547431, 0.7560029757856882}, {
        1.0731423976087113`, 0.7738892845574402}, {1.0788359394737266`, 
        0.8217779417673563}, {1.0827656067883458`, 0.8719950167268653}, {
        1.084876127014402, 0.9242833171474393}, {1.0851122276137295`, 
        0.9783856507405505}, {1.084607454484232, 0.9952316651847259}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.084427751440052, 1.0012289734822801`}, {
        1.0834601543723834`, 1.0335210136594342`}, {1.0799061530764205`, 
        1.0889084020573256`}, {1.0762451381893838`, 1.134022042986849}, {
        1.0713293371387702`, 1.1781031044024188`}, {1.0626687995710422`, 
        1.2238226554923544`}, {1.0588701607607007`, 1.2394097810629103`}}]}, 
      {Arrowheads[{{0.012395795032865043`, 1.}}], 
       ArrowBox[{{1.0574495176637047`, 1.2452391698122525`}, {
        1.0526647571413692`, 1.2648726929794571`}, {1.0420499436699906`, 
        1.3030083735616702`}, {1.0302135881152013`, 1.335315340334104}, {
        1.0033965878880047`, 1.3828173837920847`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 0.6211177934763256}, {1.4678333849204643`, 
        0.649881126678817}, {1.4411859883457863`, 0.6795547608522278}, {
        1.4147972659599397`, 0.7222453111076074}, {1.3922129980963749`, 
        0.7658126608718185}, {1.3709406979517467`, 0.8098596996018278}, {
        1.3675757705095397`, 0.8179806972807927}}]}, 
      {Arrowheads[{{0.015141452680794878`, 1.}}], 
       ArrowBox[{{1.365279029038642, 0.8235237089726313}, {
        1.3522923332449925`, 0.8548661162634335}, {1.3355619458861894`, 
        0.900790508779227}, {1.3200435777854163`, 0.9475914750718004}, {
        1.3054065423482548`, 0.9949693864312119}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.1257485529832957, -1.5}, {
        0.13845350371941764`, -1.4871605290437953`}, {
        0.16992878623027252`, -1.460769963743737}, {
        0.20901993475897707`, -1.4328856027289314`}, {
        0.25982997750361586`, -1.4065189917788705`}, {
        0.3099083737259984, -1.383907501871512}, {
        0.3289205925339207, -1.3758364312431268`}}]}, 
      {Arrowheads[{{0.008160576066662213, 1.}}], 
       ArrowBox[{{0.33444353153020384`, -1.3734918321636818`}, {
        0.36796491873038467`, -1.3592613266983562`}, {
        0.4256528262560104, -1.337916845800049}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, 0.3574810586000434}, {-1.4937127230661964`, 
        0.35236532334821435`}, {-1.4678834600477557`, 
        0.32684900917949194`}, {-1.4364936902389867`, 
        0.2900218735305615}, {-1.4108494575662396`, 
        0.24682145158680055`}, {-1.3890904487052576`, 
        0.20450926989741786`}, {-1.368688482997969, 
        0.1626836644474044}, {-1.3675587010767185`, 
        0.16007428647946412`}}]}, 
      {Arrowheads[{{0.006544454941708304, 1.}}], 
       ArrowBox[{{-1.3651747416437847`, 
        0.1545682227836714}, {-1.3510006035980688`, 
        0.1218312114761296}, {-1.3353316061475138`, 0.0819384150551629}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.2811740296422659, 
        0.9772574802070793}, {-0.3186298913366256, 
        0.9935540335773917}, {-0.3575338656478726, 
        1.0074094145311463`}, {-0.39814443410815975`, 
        1.0183406717485357`}, {-0.4340451050964298, 
        1.0249960795416113`}, {-0.47154605396613897`, 
        1.0291143483084213`}, {-0.5109116795832866, 
        1.0305011465499407`}, {-0.513080237654703, 1.0304207165437917`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5190761150892068, 
        1.0301983344617613`}, {-0.552406380813872, 
        1.0289621427671445`}, {-0.604032020259, 
        1.0230808895974168`}, {-0.6595993097695235, 
        1.0124419087848915`}, {-0.6889929658849046, 
        1.005163166961665}, {-0.7196358196878264, 
        0.9963447861259085}, {-0.7515278711782895, 
        0.9859867662776233}, {-0.7537968438421276, 0.9851722084867003}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7594439685073932, 
        0.9831448991824869}, {-0.7846691203562932, 
        0.9740891074168084}, {-0.8277379715194735, 
        0.9567252044230441}, {-0.872712886533191, 
        0.9362335446254137}, {-0.9191706758122256, 
        0.9122386876270433}, {-0.9666881497713568, 
        0.8843651930310586}, {-0.9749414159593269, 0.8787894415036098}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.9799131676407865, 
        0.8754306195050657}, {-1.014282320479431, 
        0.852211465769722}, {-1.0609702000052945`, 
        0.8153759107752951}, {-1.0864476502366438`, 
        0.7937878869952977}, {-1.1111302124084426`, 
        0.7706553659244927}, {-1.139620737325321, 
        0.735631828861714}, {-1.1546430074773029`, 0.7135791135856178}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1580209294345702`, 
        0.7086203190495827}, {-1.1653684891968887`, 
        0.6978340902191061}, {-1.1895039528430753`, 
        0.6587278592134309}, {-1.2104148400384995`, 
        0.6170046434816212}, {-1.2280204255271276`, 
        0.5728821110799347}, {-1.2422399840529261`, 
        0.5265779300646297}, {-1.2507871919595936`, 0.4891609768723738}}]}, 
      {Arrowheads[{{0.004603781193380076, 1.}}], 
       ArrowBox[{{-1.2521233624858048`, 
        0.4833116479942131}, {-1.2532358631471754`, 
        0.47844147452617547`}, {-1.2611704103411563`, 0.4288221185550415}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.5, 0.6349471744177637}, {-1.4988591359966155`, 
        0.6340128694189087}, {-1.476358336546276, 
        0.6111818317894921}, {-1.446665733754519, 
        0.5744238465036111}, {-1.4373521701012135`, 
        0.5580118077707091}, {-1.4287680870021218`, 
        0.5415361637974263}, {-1.4128398459783487`, 
        0.5084747071294488}, {-1.3990674137212828`, 
        0.47520929240913573`}, {-1.3869023001605127`, 
        0.44178196726816943`}, {-1.3827491837261618`, 
        0.4289418558257751}}]}, 
      {Arrowheads[{{0.0026132307026085623`, 1.}}], 
       ArrowBox[{{-1.3785805514384877`, 
        0.40057549884017374`}, {-1.3735741244668946`, 
        0.40057549884017374`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.2931650392349688, 
        0.709745169221083}, {-0.31771098487825533`, 
        0.6861195953922162}, {-0.34652919300075224`, 
        0.6305662914258824}, {-0.3549783971167772, 
        0.5938549044047154}, {-0.3584138830796887, 
        0.5513674559261958}, {-0.3561269910515872, 
        0.5041631886697051}, {-0.3534592073260186, 0.4885988975844848}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.352445564867198, 
        0.48268513998329116`}, {-0.34740906119457304`, 
        0.4533013453146255}, {-0.33198483976891846`, 
        0.4006817009952883}, {-0.3095790730348953, 
        0.3482040308460246}, {-0.2806872664489397, 
        0.2978343384058448}, {-0.25648058128084517`, 0.26570731728487884`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2528699538857285, 
        0.260915306244237}, {-0.2458049254674875, 
        0.25153862721375897`}, {-0.20615094223048075`, 
        0.21051331004188517`}, {-0.16294420887786215`, 
        0.17595479966234173`}, {-0.10822544981419625`, 
        0.14322694439163292`}, {-0.059928136303202845`, 
        0.12364563215715622`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.054367753618986936`, 
        0.12139127096048168`}, {-0.05278232030858539, 0.12074848438663122`}, {
        0.001672417602705447, 0.10783202004269693`}, {0.05342600188341215, 
        0.10379015175519003`}, {0.11500449043044317`, 0.10971585780783483`}, {
        0.1692774149552019, 0.12646945035886994`}, {0.1795927536093674, 
        0.13209481739687645`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.18486038062264434`, 0.13496746524320136`}, {
        0.2159192695032094, 0.15190512047716537`}, {0.2546045481199866, 
        0.18387705923159106`}, {0.2905281968318204, 0.2291379599116519}, {
        0.3142748766559375, 0.2796058239574759}, {0.32228494487191983`, 
        0.3196888934004693}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.32346071780394464`, 0.32557256215493857`}, {
        0.3251429281817724, 0.3339904873927855}, {0.32243069199875957`, 
        0.39100178624130294`}, {0.3088817977451867, 0.4416586454910327}, {
        0.28449500690222146`, 0.4935284199117792}, {0.2494557158681801, 
        0.5464831388249818}, {0.24877889568717265`, 0.5473351649005463}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.24504688855491036`, 0.5520332626820685}, {
        0.22810749269175734`, 0.5733576962387544}, {0.20439340370113937`, 
        0.6005122684488381}, {0.1649469459234559, 0.6416603700411914}, {
        0.12119377990775204`, 0.6835817158582403}, {0.09812101214176232, 
        0.7046769479693801}, {0.07734877294380771, 0.7232357171831727}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.07286107932407201, 0.7272181394782499}, {
        0.04957819377660784, 0.747566013480293}, {0.0241081431774431, 
        0.769359846880066}, {-0.002099031513618352, 
        0.791298854708681}, {-0.028981360110748144`, 
        0.8132953442987685}, {-0.05653884261394632, 
        0.8353493156503288}, {-0.08477147902321286, 
        0.8574607687633617}, {-0.09597844190764601, 
        0.8661454897766717}, {-0.10729637935669256`, 
        0.874805668946986}, {-0.11307938619442648`, 0.8788526890121527}}]}, 
      {Arrowheads[{{0.008493939754460523, 1.}}], 
       ArrowBox[{{-0.11799521086277556`, 
        0.8822928442165078}, {-0.15427938623325638`, 
        0.9076849611364158}, {-0.20313083696064926`, 
        0.9382788487329112}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.07170592455365979, -1.5}, {-0.0580708729479998, \
-1.4888588579265614`}, {-0.02089151743152478, -1.4625488239345263`}, {
        0.015452113473533542`, -1.4410003914225953`}, {
        0.05891930872416937, -1.4213276150048058`}, {
        0.10151267787561008`, -1.4041279736619363`}, {
        0.13978563179066766`, -1.389573907302118}}]}, 
      {Arrowheads[{{0.011703735068257837`, 1.}}], 
       ArrowBox[{{0.1453938298255623, -1.387441276344497}, {
        0.1619968704291404, -1.381127633680397}, {
        0.22104256292473784`, -1.3615557752385974`}, {
        0.27903205728585756`, -1.3443895722045578`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5, -0.6381256004021509}, {-1.4884312769549646`, \
-0.6445794885407993}, {-1.4498552921895427`, -0.6687335344072585}, \
{-1.417196843409184, -0.6927310267411292}, {-1.3815724832461889`, \
-0.7272707050840744}, {-1.3498932433041089`, -0.7620907606984532}, \
{-1.3210421924872373`, -0.7953349176713929}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3172490566794823`, -0.7999815873922667}, \
{-1.2917752161570175`, -0.832424201695038}, {-1.2659711520660382`, \
-0.8681229437648113}, {-1.2414365342031228`, -0.9041923992097194}, \
{-1.2178021883215426`, -0.940544649524979}, {-1.1946989401745687`, \
-0.9770917762058072}, {-1.1816696103459452`, -0.9978203978268294}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.1784765967920017`, -1.002900227001549}, \
{-1.1726232753359787`, -1.0122123932667368`}, {-1.1504478720230589`, \
-1.0468906185986893`}, {-1.1281727302358089`, -1.0811264522016644`}, \
{-1.1057978499742285`, -1.114919894075662}, {-1.0830754341362698`, \
-1.1476795570765512`}, {-1.0597576856198847`, -1.1788140540602001`}, \
{-1.0423192978321938`, -1.200333453946619}}]}, 
      {Arrowheads[{{0.012236189020807175`, 1.}}], 
       ArrowBox[{{-1.0385417637088894`, -1.2049950240627143`}, \
{-1.0358446044250729`, -1.2083233850266095`}, {-1.0113361905518345`, \
-1.2362075499757785`}, {-0.9860820969002876, -1.2620528163329003`}, \
{-0.9599319763705502, -1.2854454515231666`}, {-0.9328858289626223, \
-1.306385455546578}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5, 0.4659338734838492}, {1.4740452263933639`, 
        0.4885355736328016}, {1.4486225895280547`, 0.5161499161852187}, {
        1.4237892820502698`, 0.5553946662182301}, {1.4028505267062166`, 
        0.5950708578840258}, {1.3832777159269944`, 0.6350976590848203}, {
        1.370977869426221, 0.6648435606474133}}]}, 
      {Arrowheads[{{0.000490329262122424, 1.}}], 
       ArrowBox[{{1.3681566289172957`, 0.6745474826444859}, {
        1.3669653250167564`, 0.6745474826444859}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.188476432146091, 1.5}, {-1.2094249128322465`, 
        1.4607126843974443`}, {-1.2309699289796816`, 
        1.423376621977482}, {-1.2510172763348337`, 
        1.3913672120139786`}, {-1.2741375205818557`, 
        1.3570362093131338`}, {-1.2946781312782063`, 
        1.326294658386884}, {-1.3139066309635445`, 
        1.2967985098646255`}, {-1.3144451260717314`, 
        1.2959226966687785`}}]}, 
      {Arrowheads[{{0.002056122462482816, 1.}}], 
       ArrowBox[{{-1.3204241335171008`, 
        1.2744063109972958`}, {-1.3276745093293647`, 1.2744063109972958`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.8717861399184024, 1.5}, {-0.8759699999178087, 
        1.4922703603850036`}, {-0.8970354162278429, 
        1.457457528973495}, {-0.9179417152726934, 
        1.4279634996961004`}, {-0.949614516228287, 
        1.3942199094744494`}, {-0.9811440409911165, 
        1.36463165943938}, {-1.0125043054308183`, 
        1.3364669396299722`}, {-1.0300902687985867`, 1.322114573335111}}]}, 
      {Arrowheads[{{0.013010679783420813`, 1.}}], 
       ArrowBox[{{-1.0347386920418058`, 
        1.318320873116077}, {-1.0435260492242653`, 
        1.311149280271889}, {-1.0740469747273083`, 
        1.2880023014884103`}, {-1.1039047842957979`, 
        1.2663496234028178`}, {-1.1328763569212952`, 
        1.2458539549497079`}, {-1.1607385715953595`, 1.2261780050636772`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.013125799435159255`, 1.}}], 
       ArrowBox[{{1.5, 1.4414804993522718`}, {1.489448283390374, 
        1.4436930749546701`}, {1.4570982495128288`, 1.4504390137036873`}, {
        1.4293289256356878`, 1.4558877440097593`}, {1.4054736472559823`, 
        1.459806463097352}, {1.3839986561676378`, 1.4629338641338965`}, {
        1.3447950935378736`, 1.4678220120335799`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.012976768783036267`, 1.}}], 
       ArrowBox[{{0.09906610939362587, 1.5}, {0.08773492875454608, 
        1.483334108419489}, {0.06812557147849725, 1.459633710692922}, {
        0.057372138684016825`, 1.4494280961425485`}, {0.04677046039908369, 
        1.4400694725667986`}, {0.02585662236906592, 1.422806263165976}, {
        0.00549242321036939, 1.4081001112488964`}, {-0.014374601119203358`, 
        1.3953565785537143`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.01465689056562825, 1.}}], 
       ArrowBox[{{1.5, 0.32811911627001}, {1.4903064698500328`, 
        0.3361728996610317}, {1.4657910013768511`, 0.36139847386548235`}, {
        1.455479027970718, 0.37522157120684374`}, {1.4459917901636494`, 
        0.38898602723779835`}, {1.428428345906122, 0.41643098079699037`}, {
        1.413338582030245, 0.4437605667450232}, {1.4001308839796847`, 
        0.47107347545424305`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8798102077044306, -0.43857092101419837`}, \
{-0.858699925829089, -0.47130346835323195`}, {-0.8351866545713567, \
-0.5039077109227286}, {-0.809106236624489, -0.5364258870094984}, \
{-0.7802945146817423, -0.5689002349003516}, {-0.7486004644167159, \
-0.6013452581491785}, {-0.7263836210041796, -0.6220924682135569}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.721998420782346, -0.6261875895810417}, \
{-0.7138730615030088, -0.6337754603098704}, {-0.676036510785885, \
-0.6661813963120777}, {-0.6350000873940157, -0.6985332981713979}, \
{-0.6020142090450399, -0.7227886079503185}, {-0.5673313656532899, \
-0.7469005873123666}, {-0.5309515572187661, -0.7708692362575421}, \
{-0.5309011045147064, -0.7709008054172966}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.525814756474338, -0.7740834244036411}, \
{-0.4928747837414684, -0.7946945547858449}, {-0.45336871644173454`, \
-0.8182527099081429}, {-0.41270102653990204`, -0.8414198686353037}, \
{-0.3708717140359711, -0.8641960309673276}, {-0.32788077892994166`, \
-0.8865811969042142}, {-0.3169145528008438, -0.89202843101783}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3115409756460039, -0.8946976384958997}, \
{-0.27795827587238764`, -0.9113791135704254}, {-0.22756143056969824`, \
-0.9351666291136067}, {-0.17669024302187372`, -0.9579437435337574}, \
{-0.12534471322891416`, -0.9797104568308779}, {-0.09258939883296699, \
-0.9927825494511644}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.08701677853250485, -0.9950064880714679}, \
{-0.0774856676056407, -0.9988101934276163}, {-0.029804925333131442`, \
-1.0165825390009255`}, {0.017697513588613455`, -1.0330274935508048`}, {
        0.06502164915959381, -1.0481450570772546`}, {
        0.11218537222279998`, -1.0618059475038262`}, {
        0.1410505792772011, -1.0692184655978132`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.14686202040401827`, -1.070710830174429}, {
        0.159206573621222, -1.0738808827540711`}, {
        0.20608525335486003`, -1.0843698628279899`}, {
        0.2528214114237138, -1.0932728877255815`}, {
        0.29968704382271166`, -1.1005715159308314`}, {
        0.3469541465467818, -1.1062473059277234`}, {
        0.3834258764346377, -1.109348262248097}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.38940430629508893`, -1.1098565696390181`}, {
        0.3946227195959243, -1.110300257716258}, {
        0.44269276297013915`, -1.112730371296435}, {
        0.47689851975583913`, -1.1134645003212484`}, {
        0.5118449727032347, -1.1133976391745528`}, {
        0.5475321218123259, -1.1125297878563478`}, {
        0.5839599670831126, -1.1108609463666337`}, {
        0.6211285085155948, -1.1083911147054104`}, {
        0.6291556017043416, -1.1076985343919736`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6351333927351479, -1.1071827685613762`}, {
        0.6590377461097727, -1.1051202928726782`}, {
        0.6976876798656462, -1.1010484808684367`}, {
        0.7370783097832151, -1.096175678692686}, {
        0.7820628137049684, -1.0902096116268758`}, {
        0.8283835039090865, -1.0831661150797611`}, {
        0.8701324199250334, -1.0749426067982517`}, {
        0.8727431421798771, -1.07438571047751}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.8786111256874568, -1.073134003820672}, {
        0.9127603890772786, -1.0658495831579446`}, {
        0.9557229053939469, -1.0557919811356185`}, {
        0.9992014708656637, -1.0448014884056807`}, {
        1.0421759146844916`, -1.0337598412084632`}, {
        1.0845050042206634`, -1.0217202883142962`}, {
        1.1109745024464006`, -1.0134414000393648`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.1167009405225312`, -1.0116503369583314`}, {
        1.1261887394741799`, -1.0086828297231796`}, {
        1.1672271204450397`, -0.994647465435113}, {
        1.2066186068044107`, -0.9795994760991893}, {
        1.2433616582234592`, -0.9635241423645012}, {
        1.2774562747021856`, -0.9464214642310489}, {
        1.3089024562405893`, -0.9282914416988315}, {
        1.3337373123662732`, -0.9115132374493266}}]}, 
      {Arrowheads[{{0.005007336926839006, 1.}}], 
       ArrowBox[{{1.3386152814805574`, -0.9080280591187164}, {
        1.3620045391892375`, -0.8890032909121209}, {
        1.3831991967726838`, -0.8678586445261318}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3040677946957218, -0.7181862975851201}, {
        0.3569549319490194, -0.7108909005578685}, {
        0.40961412584764556`, -0.7006425990630752}, {
        0.46267235910988935`, -0.6870219218574238}, {
        0.5167566144540398, -0.6696093976975976}, {
        0.536699457055983, -0.6619361386368517}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{0.542299254524245, -0.6597815462590582}, {
        0.5718668918800967, -0.6484050265835968}, {
        0.6280031913880599, -0.623408808515421}, {
        0.6808073981151166, -0.5968842179566769}, {
        0.7352291852585214, -0.5666762050931063}, {
        0.757190256997766, -0.5536494198404686}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7623506848491598, -0.5505883768171579}, {
        0.763052698240841, -0.5501719591756835}, {
        0.7912926598362209, -0.5327089454393985}, {
        0.8199490700446608, -0.5142871638842512}, {
        0.849021928866161, -0.49490661451024187`}, {
        0.8784007672074626, -0.47458840941091324`}, {
        0.9079751159753063, -0.45335366067980765`}, {
        0.9377449751696925, -0.4312023683169255}, {
        0.9597243353783317, -0.4142822941454956}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9644787331759836, -0.41062228026824293`}, {
        0.9677103447906209, -0.4081345323222666}, {
        1.0016216257999664`, -0.38159702308397025`}, {
        1.0353892382010494`, -0.35398895604274494`}, {
        1.0623917872679816`, -0.32914076097359546`}, {
        1.0888030037699845`, -0.3036775424102503}, {
        1.1140849759877485`, -0.27779182934866975`}, {
        1.13841700782771, -0.25141944545686706`}, {
        1.1409816265033652`, -0.24862154178876994`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.1450358657331432`, -0.24419851745380078`}, {
        1.1623189980573057`, -0.2253432623685083}, {
        1.1848018347712834`, -0.19896110922602855`}, {
        1.2058655179696431`, -0.1722729860294278}, {
        1.2255100476523848`, -0.1452788927787061}, {
        1.259958715372515, -0.09084349590539265}, {
        1.2815595389197418`, -0.048028781002361756`}}]}, 
      {Arrowheads[{{0.013688996674990628`, 1.}}], 
       ArrowBox[{{1.2842621677315469`, -0.04267193514816723}, {
        1.2875649068331743`, -0.03612561839658121}, {1.3087241210299212`, 
        0.018562216456635958`}, {1.3238318569583143`, 0.07290748536316655}, {
        1.3319820529733, 0.11399806119559401`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.37397867707840293`, -0.8237593677219617}, {
        0.41939733219235825`, -0.8208796480747533}, {
        0.4653715920032173, -0.8160839947212383}, {
        0.5119014565109803, -0.8093724076614162}, {
        0.5594300885463623, -0.8004482025049269}, {
        0.6084006509400792, -0.7890146948614101}, {
        0.6109145094524068, -0.7883194256926184}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6166974077346754, -0.7867200234739958}, {
        0.6588131436921305, -0.775071884730866}, {
        0.7106675668025165, -0.7586197721132943}, {
        0.7627739071104332, -0.7399141867490696}, {
        0.816652433879277, -0.7182981675758072}, {
        0.8426752953022363, -0.7067104033585704}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8481564397009412, -0.704269695248094}, {
        0.8721224851644964, -0.6935978141072201}, {
        0.9290033990215396, -0.665639225857021}, {
        0.9577975157857923, -0.6504135949496228}, {
        0.9865935209355954, -0.6343244078684336}, {
        1.0153914144709488`, -0.6173716646134534}, {
        1.0441911963918526`, -0.599555365184682}, {
        1.0590112569764007`, -0.5901654069847994}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.064079565384923, -0.5869541377846074}, {
        1.0844852564936738`, -0.5740251362155677}, {
        1.123994034282294, -0.5468159671993253}, {
        1.1669893602515085`, -0.5099914595078073}, {
        1.2063943078194408`, -0.47116731261496825`}, {
        1.243491517901551, -0.4315304308560738}, {
        1.2445153271439822`, -0.4302298606532424}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.248226586542539, -0.4255153560476}, {
        1.2759732530120171`, -0.3902680793650686}, {
        1.3036568299157838`, -0.34770156974357935`}, {
        1.326359565377797, -0.30415221359323324`}, {
        1.3444099406606553`, -0.2599412008490704}, {
        1.3581364370269575`, -0.2153897214461312}, {
        1.3583354531278742`, -0.21453112004568806`}}]}, 
      {Arrowheads[{{0.0025353410423390797`, 1.}}], 
       ArrowBox[{{1.361373942443571, -0.18631147404968978`}, {
        1.3648765138720964`, -0.18631147404968978`}}]}}}}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJzty/k31fkfB3BpIjFlydoiRMgoiiTNUyWElMaoJMmgUTciU5aiqCiZtCrU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     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJzt0Pc/1vsbB3ANQktOySgyUjQcLUp5KYkcpxAdRBkZ2UlpSqWU1VBGi5BR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     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJzt0fk31HsYB3DK1m46ulIptKEbypqLd6FU1GkTKdGUtdu4jS4tslxUVFqs
UQltWm5TY76y5IMkKWUyGvMdy8wYS0hJV1Lquv0b13POc97ndZ5f3uc8usyg
TT5jFBQUqkb2vzT9Of3E7GfWIZ2W87YUfCKlWuxILQM+STYv2fOPoJ8Ma+VU
viuTEF/pY2bqhI9kdVWI38UNcvI1zr07/0IvWfKnz8xzwR3k+8TiJRs9uoi1
bJNlQnI7sc9kzxPK2kmx4dic3IXtpLb7NCM2WE4q3YyNLDTaSCRrsviTn4RE
v9+8z9y7nWxdP8C9ZdVAbsrLFJzud5A0TtKTAu1C4ntsp312UzepTdLScawu
R/xccWCIVTdRCr8/tOJ7K3Remq00U+4gYxWhcfWmFEL+jNfhXo2kIWPSph5e
CwoPBxiqFfGJSZ/y9cE7EoSMSz1VWlxKshlTYxLYUizfuYyWp/lhlorNo1fW
MoiyjMNT5GX4QowX6ifLMKZi7rbXUj7mOrL6YndIwdfluvfYNaBe0XPc5ylN
6Ox1iVMsEMJNfVqNswENHeGjkkRVGrS//YuWGiEWzVhvYRcsxu9PzmwVC+rB
CqWS151uhGBdRE21ngBn1TuPKjGbsaZrUq71iddYtHlN3dsvLciINRRwFPiY
nfQp1fyGBHtdHmQf/vESjsWBDJGtFNu7co+3dT8HUzjuW0a1FAkrx/QEZVVB
GXmK6q4yhM/3fJ7dWwGq2pDSlssg03ZVCosrRUbrjfi5Ea3YNl/ffaCHN9KT
PfGYkRy1UXH25wNjSMyjwceuq9vhru6sVS3PJ5fk5ZWnO9vxbLzXAovgCjJP
1aAmzroNNbmvCjSrrxIxf0fo9U4J/DRvFJksv0aqrZP0+Y4SeCUyI2zVswh/
qwpbVUWCrV+jHgU+vEKuOjap7vNtwZtOztOxaleITcug93a6GWFB7lqeilkk
P1Tp2jfVZgT+fWDOB+9Mkqo0YbPq9SYY+heVaAdcJLKiXLoCTWA4mPwWpnKB
aGr5TC+ta0S/wKngUl8KiZx59gWzW4yPmk5mqpHnCXNyGdFMEMOAufP0t6h4
Mr19uxtnvhgRUV3Ol2aHkRIdF00/nZG/rXh2t3GZJukUM7p2V4gwaKJP3WqJ
Rt6wZXMMtwGs7rQVpTfPw79rYFX2/gbMOZnBKfa6ArWFzSlPgoW4v3Ig6ofD
NdilXph2z1eIU04eVb/cvgsHH8ask/feIJ23YzzVyoFe1Fqi0fsGZ+0dNJsV
uWBFew6/tRPC3V8gYCjwcDhRsH/FVSGqXr9zO5RJQc6XxElmNcBJL7KVeTkf
Mt4R/fJLDVDbYy6I0cqHkcNZ09qZIqwrc03i1VPoS3l7LH2fCONtzF4xhyg8
POhTGZApwrApZRKUS+HgDOHSkoci+DSoZtffpuDN5p5g14mQW1J7UjubwkUp
J5TVIcIaXX2V5kQKCrqGHWGfRTgQYf15YzSFLNfZJjbKNDo+S3wY+yk4Vz7J
SWPQGHPKZpmeJ4X+yj09uto0+kt2h7o4UeB8qXM21x+5/3pfxdKYwpS8O5ZT
TWlkH3AKY2tQkLZ9ZMltaTwoOWURPsBD/ofh6KrVNKL9dxlMFvGwZOWug4ne
NOL5t/86l89DuGdKhbE/DW7hXmPWOR56lSuaTf6g0aXmMnusLw/H763tOHKQ
xnSjkAUfF/Cw1MoYcWdo6O73CDAazAM7ZVzm9CQayYWxAxHleZCvudvnkUbj
1vlV8Xr+ebAbqtXwukXD4/CiAwWmeZgYbbV3/c2RfkOXj778ysXExRtsG3No
SGdN8Ey4zEVM0Rb/8ms0gl5c8Vt8l4tXrNSlm87R4L0/smo4iYtOqZtTRAyN
2BCNoPXXudgZn1N25hCNofFU3VMOF6WFzyTp7FGPetSjHvWo/x/+F+MNTNU=

     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJzt0+lXk/cSB/BEZem9ymJRL0hAitrioSqbV6z4LShSFgFZy6IoULBc2SII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     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJzt0/k31fkfB3BqMtKqmaKmNLSRJbqT0ah5NpNsIbsbaahvUQipmzWSpaFE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     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJztzP8z1HkcB3DEFTuoRplEKRXqQqlD4pkvVzlfaiQqpUPOFjIVO4WKPaEQ
J4U9MklSybddu+tb7y2L8qUr37If9gu7pZOuri/y5ejczdzv9wd4zbzmOY95
zuu1IiDcM0hFSUnp8cz+k23/Tj/5L4WH3mf4L3qK+UvTpa7OQ0TljJtTTpIM
j5ewxmTGMqK0WynomoscQvNXPQHeHeT7DINhN44c3Cu6thm+DSRI/ZN/mLYC
O/PV+jq8rhC9VO/gAhMFHg76WUTkPYBg3CbI4/ZLyNzrTF3KO1FqYhF7aECB
Ngsd91uT/SinXx89EjeAu63mXj+MU/DMSd6k/0GCuTf3jyQYixG4XJ9mP9wH
kdkyq+71EhRJjwszz4twdOFmG78xCcqviiSnjrzAGEtsuL9aik0C4rI9tBtd
97dspGfJYJTX+SnoRCculUQou6cMIIV1/bQ68zmiNPmaZv6DqGvO8X6k+xvK
VhbRi9fIQaVzy2lvW1CdVcxv+V2Oxj2TE6oOTSjyfObowlOgYFX0XPUSAazX
FqZPXH8Jvs5367++qYRwWlAQU/0KsRoxhf5u0eTRm21tapteI47StL4taSF2
87a2j50fQVn41Gq/jE6i7vjwTOGSERRGfDOsKXhOwkLkTqMeQwhgNXll3xCQ
n8MzJ85ZybHNPPKwQ5qAJMUzjjrbDkJi7FPhM1FPIgLXjUwrBlAb+zFV9U49
ib3gW2USPoDB/rM2qe0PiF2SI2PXcxkUJsdG8sbriUrIMn3LBBmy3E3aFJr1
xPxHn76H1jIwpB01bip1JCFerLPkqRQVaMjfK6wlSy9X7Ss4IYHt691iP/8a
sv74hcnGQTFYH3LOHeDxycEvXzXk9mJMF/+04p4Wj9DPhotJQR+8x59MXCEc
0mQRZVkwpw9zGt+K7xZVkFNpOxfvtBKhfcukHvtVCblJGD0binrRODWUG/G2
gJj2TnQ2NvfA3PYzc6Atk9S4Lq3WPNaD0xoqlYE2MdBfuFj5WnsX4uZuX7hD
l4VvayZ9K990QVjXcseQWQJDsVAlX6MLRuK+d06lFcj+y+vmaF0XIgOdQzZI
OAjwHtcOZXZDUBWofSOeh8ojffZn9878t87zSPGuRmJHFMtl7QtMxz0O2VfL
R5pu0eoc7V5IO/KhFVsN4cpbDFNWL+RqkY+UmvkwU5ymf/nYizB9g9R3g3xU
alnYDVmL4OFg73nQn48Bxu4Smq8IGYdUH9vN2GGewcWD8SKcEWVpKnbxUX/C
v45eKIL1ifSPBlZ8TC7X0e97IMK23tz5C/T4uPrx5vRwtwjpif1h18d5eK2X
PDQ8LMIu+1tVzd08aK11MiubFiGLPjFlXMrDcTL0rGEBhYpPXgWGTB60GQJW
4ioKpyPoziO7eaDVTvnaWFH4WvmLz+aVPPje3+GhfphCcHr+SekwFwrj3Dzt
0Jn7F5ePrivhIjg54NT9MxSijZTWqAdxIS/N5dQnUrixhkEz+FqFJg21vUGl
FI6EQ5LOrsKKVYEHnLgU9ENGDdkHq2Dke3nPk3oKfxRne2xs4UDLw0iqJqbw
3LK2bDKSA6iPo4eikCr8UiJdwsG7RjM7224KrmVl8QlRbJi/3fhnTD+F3hef
61uT2Xiv7LSPVkNhO/cizdGHjQZaXLDrLQr8PM/stDA2Jt4d6j6cRmG1j8fd
0LNsjG5Qdg9mUvBLsYx7lMTG1sph7uJoCuJIzqLWBDZaq0vPU5EUXv26OZg2
06cx50RtO0khrOWJreklNip0PrukhlNgVprOK85gQ/neCD33OIUdDQmcU5ls
DApiHVRDZz3rWc961rOe9f/x397hbOs=
     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJztyflP02cABvBSdIDbAEVBK/ehcloBRZ32CVGgQxEHuCircbowxtBKBG1Q
IICO+5DKgI3AOARUovAtFQRZS4FCORa5yvG2gBNhHA4Gok6ObLh/Yr/0SZ48
+eQxu3DZJ4BOo9Fka/2wnf9FKXZ2+pBerKhb8BbL5WLTpbll/c1xyJuJ2zYU
2SZmmxdMGGjdE2sEpSjy1SXiaHvvjJAwP8jK1fpH/s4Sd+kY9HwqjQaTZlc/
IS2Dc4d5WjO9HJ9f1DbXaK5DGWerX6FZLeiXuDfsbBuR+du6nLBbjXB/vcfR
apcUu+u/5/DetKJH0nzf6nULLOX7NDdRnYh9U2QWPNkKl8VzUt6pLnAZLof4
L6Vw61W7y1zshnOjQ+rFwhYcW8zW07nZi9uiI3vdOlowlOU/ldTYh6xt74Ln
77YgsvPRUuITOZ6Mtsx+6yPF6WTedrplPzgzI6v8HVIYbQmIN5/rx1Zu9cbE
gWZMs4s2v8oZgLi7jJce1oyne0rZ620GwfAcjO9a14xPbEXPv74/iJ1qK7WM
5CbIDR8OmxkOQUQfH5zRaILb80tk9YcheJSmlV253ggdfjq9YGoI1NSijebv
EnDiLJZn2QTv8x7lBh6QwFfGL3UuISiJ2LXgzW3Ad63aZ6/wFGgI0pL5Z4ix
Q2NhvOuhAtYVtaIoYxE6TXsk6S8VqD7xTUZ0RD0SaOqyfIYSp40TXBTFdWi7
9cJE7qVEcY1k7K/0GrDNssNvLCpxNLaC65v3GB/zd7MK18z4kSz9oyaApr8v
i3NyGNnWz3waEytBl6c0/bn2dxkNhxjIKuERUGuf6awEu+ddg1FnJQ5rK5KQ
r0BoqeRcyQYKy9w7hvtcFRiT+bWFnaSgUHtwXbBRgdnEGarKnULd7E9c6TxB
dLstL8abQjmXMzOpJFhxJTFfxVMoShl979lH4FCsNVWURqEm2PnqF00E90Pa
A9t/pkDrC3TKFRIcP3aG4/WAgh3NSZ9ZRgDtX/RW71GwClIvF9wmOD/WU8MX
UVhxLIiqjCc4k3AiMrufQmh3xb7QKAKDL4dtk+cpFESOJ0yGEWQyJo6+1xFg
w2fGMx8FExwcFS3FMQWIFooPDfgSXNUTxbF81v4D8ooXxwmesZ3UHcIFcI01
XQ5zI7DWcLSZLBGAc3XY6/FhgjcLr2LnJgWYtu8MithJ0DfJb6hgVMHdMOha
mgUBhzkgjLtcBa2VzR4jugSp+6OFT/Oq8NZvIOr8JgKza95KRVcVMqa99VO3
EFQZ36yLWS9Ev72x7sHtBB1vw0cs9wqh9seDlf2WBArh2aT6U0L8+sJE9wKT
IMfLM2nCU4hqFusdnUWQG8rMNzkiBMtwPpjlrrLKKqusssoqq/z/+19WgXjb

     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJzt0vk31XkcBnCjyVS0UKFi6uZURJsSkp4styghW+hK2bKXhAotUplKrlAT
aQhTEtfyNUT5VHbqkkvc770oRUbJNidLXGP6M+Z4znmf57zePz8Mp2MWruJi
YmJVU/dfv/oRIXn9o/uRJP99Z7nWJ5L4Mf6R0GIArQqfL17w7ybKMa3tbrx+
eGo113rc/JsorFoY6mXWD6NkZnNCSg8Jlwhi913pwz6puKiA/F7SJCUo6Bzt
xfmHP3d2OHwl0uc7Zu2t+oKE0RO3luT3E+eC2MktUT1omiMrvXS4n8xTeRtx
mtuNDTw7ZlTEIIlO9kpfs7kTM+UZkvvuDZIum5CRgbsdmJVrvMxeYoi4HN0t
ET23Dd/ZTEpNbYjUm3Lnrzv+FtzI60RFeYiYVx7i9cRVY77PpUtSwUOkajv3
1i+hT8jol9OHHb8PEO+UDZm+K4REKXjRVplrPUQha7FcSXI7iSjm3rcf/UCc
b3x/L7angZzYcaiC69hO3CtXL9o3Xk848yS9t7o0kaW3mhnqio0kO9Xvc2xE
BSGSnn9UvGsiYs+8VolPeJLPjx0UK0RN5JRjd8q2a3moNfRRLOuvJ96szfdl
Y0rxZdgvn1dcSZIPh61xGX6JCtnNHOlVheQxEd1jT5YhydrcRlP9CpHi+WYc
TKzGxtquQP78TJDokjqDea+RuyRodl/RM9QV6eUfVa2D91MjtjC8HDu10wpY
qvWwjxKtDbCqxYu0luUxjvU4E/UqeWzq7+7zsnVgVz2Yz+VXrmc2IKXK2dZ1
uA7KG5hnTYZ4qDnotUbH9zXGJj4ufhzRCKolOu3XxlcYvkGeuvY1QS18nYme
xCtEdausSFnUDNV8Uv2JUQuN6/1XnGa2QMZjIr1FowZ3jY9teMRtwSfdqx33
dldDgfLcuTqYD82ZmU0tB6qgXChMa5Ohcdq1qOyBSyWOFBVIUgk0FOW3Cnme
FUgsVQ8YWCKAcTtTa7tbOYTKcVXFbAEEd4ycPu8vw2+2SbIHxIWQ/TY4PLGm
FJaS6ZL6x4XIqLbvCnr/AoFWMcUMgRD+5tG2qoHPsfdt+Gx3/VasNdOOO2/6
FNUF7Ltmfm0IMS25Ge/+BBsd2eMmt9sQvmDh0Avxv+DgYFL3IKMNQSeXXK/a
y0Fqpf2FO5btaGD3fv1zbzpsBLosK6oNEV48u/LVj1BopWFyybIVc3ZVWykm
ZsDN8L3FDHMhjGLJlk8embj0UO8nJ54AO+ov7o6Jz8ImqYyR65ECnEu99T6Z
nYWw8qsslp0Ab54qyG0/wsGMhsKFC/UF0Psn4wTXhwP1se53+xkCzIjr1c9l
cxA8p5dlLSGA5Q2D8T7CwaBapVHsVxr+Uh+LC0c4mHC9G5XQQkN7uSjXQTEb
/vdUGyJLaaSWd2oz12ajfIXFIvFEGtI1glVZ1tkoULl8OzSSntpPiOj55Wxo
JkS764XS0BUxg06VZGNlUcmmPd40RnXuHIoUZcODU6HSZUCDtdi6MnBHDlQa
spbFa9II2+jS4RyRA931K+Wj1tKwKR2Tt/6Wg5vrQ0J0ZtAwcTv1ux0zF2Er
GM5Xxvmw+qivlZCUC4cR4ybbb3xwXc5ZDm/LgzI/vsCxhY+KWp3si9F5oJZ9
aWO08uEWfN9lVm8eOuaJDLI6+VB6sQ1mhhR6agIc/If48D0gqakVQcHv3OTk
uAQNg5NzwxUvUPggPcw2YtCQu6MRmH6GgqHERDN3Ew3N0lDIhFHgLGO4GurQ
EJ+pPmeWP4WScSVWI2hEjsU8M57yS5cFOXGGNPq8o33P+lFI+JbnJG5EQ81f
+fDcYxRudzHe5e6hMTuNpWThTYEdZrppxITG4iIScMSDgpmtrobIlIbsHhW+
thuFwbLRxjZzGknPlOXeOFFIujCZ+ciCRnpJ8DF5RwqnD/Yo+ljRUDUbGJiw
p1CjKqe93mba0572tKc97f+H/wUwtB7N
     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJzt0Pk31PsfB3AtbrlKXy2U7bpKi7RYKlI9cUuWLoV0c4kosqcS0WaStNxb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     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJzt0Ps/1PkeB3CXaHPZ6eye7SIp1pZUyiXDdtpXSdnYtcqlQilyK6KVjlNp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     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJzt0P0z1AkcB3BMx2QTDV03cXqYcFlCnl3Tu5O6yOQGt4TbyVPpcDdL7SoS
YRxxHSGxLg+HUnMevrvf5sR8PQ2qressdve7dm2LFE6Xi/NUTj/cX3C/7nvm
M+95zXx+eu+K+N4/WkdLS6t//T60k+OHiPFfz3rNBP/tN4SXoXuSn52Tw7vt
s+7LHWIEvOib50QoYBHqPuhybADUmDh1Ra1EUhBltm3iGSIUOu94hip4P5rq
PV37OzybIkrD40chkSRavdgrQsxUbvLXPBWUFfYexEAv6I+sLifvUMPR5EjB
FtdurHoWWydWqTHq7DxIC9vRakGcsd03hv73hnJxTx3YHXdeZa+MI+1Ywqm4
b+Oox/M75e4xE8jjTA7lBwmo+Zp8h/3CCahO9Li/rCCp3fXEX59MqmEzdfGG
mwufCj24xyU3R4W5otH0Op/rlMhucdppchQUu+RgoLqQqjmpP3J19yi2v93o
2Z5aQPleWlrIKFPC8t2zEXHzNcrG86fFUqYSD3UzI4MZeVT5jx6uG/sVmH0y
x0pfy6ZubiBC955VgAq0/c6Im0EFJb2XWjIUyJWbVdlXp1AWtsNBN++OoH1F
OfbKNolyrTUIa5+Rg69ls5kzGUVVqw7fDKqQI5NVERLnwEJlk2O6yVE5dEpX
cyIbuOAx0KXg0PA35G2pz8hCx+eNXnyrdXcGvulpKsCfJw8P1hyToeGcHSPv
9g30Xj534IKxDJG9hWx70c8oeZ7JKZNJMcgfC17bWgsqrcXEmiFFSyB7PMbs
DqS8tkuKFQkaczuS9JcbYTClLM6NlsBuA7FJ2doMDwN77fFiCR4s7G3LyiAQ
1t3qoieRQC1YNDVgCiEr8rmdxZSC7Xr1kD6PRLDDl691C6U4ndZxKtb2PrZK
67sU76Rwyg6RcetJpNaZty+FyXBpcRfH4xSJuTntIRZfBs4U/w8Jl4SVV0VJ
X7cM1Q8DnAv3k3gkaMqZH5bB9zo3ys2RRGd/q3f2jAziDL7vb9Ykjl/T96tc
leGxvuSp3JyEU2a+rGAjjfOWsaojW0gQQ5KhBhMaRmnxy+E6JLaF663dNqdx
nVkQZjsnRJ+ILl9b3zNEa8cMVyWE3suvGpbsaYQv3ot4KxKCaZF19pE7jZSF
16Y+94WYDkiJLfak8XFGN7H5lhDjb684JxyncdLvC1qULYTCa8P0HJtGtX9i
CTNeCO/OvlmDaBolvAuRT08IUdV1dF96LA2veQttBxshyAd2Pu4JNNRrxgvs
ZQF0HQ69ccuisb2yJXJxSAD32vyg6R9onGCoFAt3BWCtfRN1MY8Ga2eP3/Mo
AVbF4dHqchrxrcdv9RwQ4ADxi6+obP3//D3jeiMBPj3bUWJdSuNJTcQ/rt0E
2P7ZKWf4NOqKGhqZjwlox3R2tV2lMSo33TT8KwHGwNhB4ys09rBaxjtJAs3B
Ic3VXI011lhjjTXWWOP/738Bsui0nQ==
     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJztz/s31PkfB/DZQRGm71LzjdhVw4Y2l2ybSp6JL9rsyq17mm0R6YIskrZd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     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJztlfs/1PkXx2uT665EubSlVbGLUl9Srr2+ksKGFSZE6EKUYpPYKJdqFRKK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     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJztkvk31Psfx0lFka/y1dWiUCZtli+lhZ4la5I1MSF7osWkZCnJbRHq3rRI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     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJztkPtbzHkbxytCPVI68Di1Wp2RUNky9p1CopK0EdntsB3o7LRRSRFltue5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     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJzt0fs71HkbB/Ahx3QgYwtFskshWTwlbfumJCmSU3RS07ZyqhWdVEpttZK2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     "],
     VertexColors->{
       RGBColor[1, 0, 0], 
       RGBColor[1, 0, 0]}]}, 
   {Dashing[{0, 1000}], Arrowheads[{0.04, 0}], ArrowBox[CompressedData["
1:eJxTTMoPSmVmYGAQAGImKDYGg8/7YTQHf/i3wqIP+1cFtuSfnPANLn4GDO7s
7z8acS1h8qv9fTm62YI3EfpMwPRl+1m3nmwN2fll/wHJogZJzYtw+bNg/R/s
7x7Y1yC78Ov+R2q9zKfV39nDzIWpk4iwtqiVXb/fVDzPi0n3G9xeGH0k9sOk
RNFz9gLSE+57uzyHi8Ps/8OsXP5l9dX9Cr/e/xYTaYObD7N/gcRvh6MWz/fP
fTJr1Z2gj/YwfTD7xSJf/d999Ku90qMUm10fEP6CmZP8SZrRpOmVvVpz84kU
+dNweRj9zuVNxGf/q/YvolWqL5TchovD7H/nz9TWJbbRvi6u+LqN2le4OMz+
WYwPbvdaf7Oflva5f13NR7i7Yfbvk5mgPaXrq31q/PJfE0+dhsvD7Jm0fMV/
nsgv9l0sOnfeHnkMNx9GXz93pvVz0wf7E6+af3tzf7MHAHHGGmg=
     "]]}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwVm3c81d8fx41EaBhlJQ3KThlF8m4QoUSl7FEhQviWhogioWRLEpEV2TuO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        "]]},
      Annotation[#, "Charting`Private`Tag$111137#1"]& ]}, {}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
     TraditionalForm]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->Medium,
  Method->{
   "VectorLengthFunction" -> 
    Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
      System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
      System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
      System`VectorPlotsDump`imin = If[
         NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
         Min[System`VectorPlotsDump`m], 
         Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
         NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
         Max[System`VectorPlotsDump`m], 
         Max[System`VectorPlotsDump`m]]; Map[If[
         Or[# > System`VectorPlotsDump`imax, # < 
          System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
        System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
    "TransparentPolygonMesh" -> True},
  PlotLabel->FormBox["\"CurvatureEG+\"", TraditionalForm],
  PlotRange->NCache[{{
      Rational[-3, 2], 
      Rational[3, 2]}, {
      Rational[-3, 2], 
      Rational[3, 2]}}, {{-1.5, 1.5}, {-1.5, 1.5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.842255137435227*^9, {3.842255171965315*^9, 3.842255192419024*^9}, 
   3.842256135368812*^9, {3.842258228213975*^9, 3.842258241756844*^9}, 
   3.842258313976902*^9, {3.842259078969302*^9, 3.842259099472698*^9}, 
   3.8422591554518557`*^9, 3.842259200059991*^9, 3.842259394880515*^9, 
   3.842259441980701*^9, {3.8422597099315577`*^9, 3.842259715578828*^9}, {
   3.842259745622595*^9, 3.84225977352706*^9}, {3.842259901567774*^9, 
   3.84225990864587*^9}, 3.842259976146632*^9, 3.842260092972844*^9, 
   3.84226012586385*^9, {3.842260215008101*^9, 3.8422602395580883`*^9}, {
   3.8422602893358183`*^9, 3.842260429773628*^9}, 3.842260497743248*^9, {
   3.842260538216559*^9, 3.842260549699239*^9}, {3.842260711081716*^9, 
   3.842260732577292*^9}, {3.842260763265541*^9, 3.842260783711604*^9}, 
   3.842260873628326*^9, {3.842431629978351*^9, 3.8424317228476353`*^9}, 
   3.846147047420664*^9, {3.846215041515831*^9, 3.846215050755485*^9}, 
   3.846298899992257*^9, {3.846575187156955*^9, 3.846575216853552*^9}, 
   3.849938251223919*^9, {3.850197891158516*^9, 3.850197917492878*^9}, 
   3.854687546392644*^9, 3.854687587686191*^9, 3.8546877506639442`*^9, {
   3.854687809558236*^9, 3.854687823895797*^9}, 3.854687895189951*^9, 
   3.854687977710308*^9, 3.854688345214473*^9, {3.854688500406384*^9, 
   3.854688510786017*^9}, 3.854688810807906*^9, {3.85468893179261*^9, 
   3.854688961817659*^9}, {3.854688992053399*^9, 3.854688998583518*^9}, 
   3.8546892254368353`*^9, 3.8546894473974447`*^9, 3.85468956078953*^9, 
   3.854689718468178*^9, {3.8546898037300034`*^9, 3.8546899077633142`*^9}, 
   3.8546899677346897`*^9, 3.854690006844222*^9, {3.854690039799014*^9, 
   3.854690068747612*^9}},
 CellLabel->
  "Out[642]=",ExpressionUUID->"d175a9fb-0369-4e2a-824e-a1ec30f3a595"],

Cell[BoxData["\<\"Figs/Forsaken_CurvatureEG+.png\"\>"], "Output",
 CellChangeTimes->{
  3.842255137435227*^9, {3.842255171965315*^9, 3.842255192419024*^9}, 
   3.842256135368812*^9, {3.842258228213975*^9, 3.842258241756844*^9}, 
   3.842258313976902*^9, {3.842259078969302*^9, 3.842259099472698*^9}, 
   3.8422591554518557`*^9, 3.842259200059991*^9, 3.842259394880515*^9, 
   3.842259441980701*^9, {3.8422597099315577`*^9, 3.842259715578828*^9}, {
   3.842259745622595*^9, 3.84225977352706*^9}, {3.842259901567774*^9, 
   3.84225990864587*^9}, 3.842259976146632*^9, 3.842260092972844*^9, 
   3.84226012586385*^9, {3.842260215008101*^9, 3.8422602395580883`*^9}, {
   3.8422602893358183`*^9, 3.842260429773628*^9}, 3.842260497743248*^9, {
   3.842260538216559*^9, 3.842260549699239*^9}, {3.842260711081716*^9, 
   3.842260732577292*^9}, {3.842260763265541*^9, 3.842260783711604*^9}, 
   3.842260873628326*^9, {3.842431629978351*^9, 3.8424317228476353`*^9}, 
   3.846147047420664*^9, {3.846215041515831*^9, 3.846215050755485*^9}, 
   3.846298899992257*^9, {3.846575187156955*^9, 3.846575216853552*^9}, 
   3.849938251223919*^9, {3.850197891158516*^9, 3.850197917492878*^9}, 
   3.854687546392644*^9, 3.854687587686191*^9, 3.8546877506639442`*^9, {
   3.854687809558236*^9, 3.854687823895797*^9}, 3.854687895189951*^9, 
   3.854687977710308*^9, 3.854688345214473*^9, {3.854688500406384*^9, 
   3.854688510786017*^9}, 3.854688810807906*^9, {3.85468893179261*^9, 
   3.854688961817659*^9}, {3.854688992053399*^9, 3.854688998583518*^9}, 
   3.8546892254368353`*^9, 3.8546894473974447`*^9, 3.85468956078953*^9, 
   3.854689718468178*^9, {3.8546898037300034`*^9, 3.8546899077633142`*^9}, 
   3.8546899677346897`*^9, 3.854690006844222*^9, {3.854690039799014*^9, 
   3.854690069220744*^9}},
 CellLabel->
  "Out[643]=",ExpressionUUID->"3c3a1a4a-586c-4eb8-bab9-947eea96ef16"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"init", "=", 
   RowBox[{"{", 
    RowBox[{"1.0", ",", 
     RowBox[{"-", "0.8"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"1", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Tau]", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Nu]", "=", "0.99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Gamma]"}], "/", "2"}], "*", "0.99"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "=", 
    RowBox[{"1", "/", "L"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"legends", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<CEG\>\"", ",", "\"\<CEG+\>\"", ",", "\"\<AdaptiveEG+\>\"", ",", 
     "\"\<CurvatureEG+\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"plot", "=", 
  RowBox[{
  "plotAllDeteterministicMethods", "[", "W", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Figs/Forsaken_all.png\>\"", ",", "plot"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8462989307871723`*^9, 3.846298947138015*^9}, {
  3.84629899189009*^9, 3.8462990585264482`*^9}, {3.854687592348857*^9, 
  3.854687631175009*^9}, {3.8546888236361303`*^9, 3.854688843636015*^9}, {
  3.8546899243534193`*^9, 3.854689936894525*^9}, {3.854690126869982*^9, 
  3.854690165837874*^9}},
 CellLabel->
  "In[710]:=",ExpressionUUID->"8d6a0423-3c52-472c-bc40-38a90c550bab"],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{{3.850197952255444*^9, 3.8501979547173443`*^9}, {
  3.854687596224971*^9, 3.8546876316120872`*^9}, {3.854688824534726*^9, 
  3.854688844484852*^9}, {3.8546899250926*^9, 3.854689937846364*^9}, {
  3.854690127614172*^9, 3.85469016633962*^9}},
 CellLabel->
  "During evaluation of \
In[710]:=",ExpressionUUID->"1b5de814-de08-4d40-819a-e148e5b54b56"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{}}, {{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.12702486321737294`, 
            0.6825502504445621}, {-0.15859867017162593`, 
            0.6835370446319317}, {-0.21401826075772262`, 
            0.6657984934378398}, {-0.23802224083322843`, 
            0.6414453595762438}, {-0.2547094630415601, 
            0.6057462889216412}, {-0.26181673868907707`, 
            0.5584941055939887}, {-0.2598446627503448, 
            0.5297250019187422}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.25943433527913057`, 
            0.5237390490817774}, {-0.25791901982696025`, 
            0.5016332738994}, {-0.2514094962393709, 
            0.4708056979947869}, {-0.24162817456587132`, 
            0.4390232596947784}, {-0.22880215066296467`, 
            0.4068867115491709}, {-0.2131585203871542, 
            0.37499680610776115`}, {-0.1947649412367179, 
            0.3442157824300341}, {-0.17381662139651394`, 
            0.31519669036772385`}, {-0.1664612117240181, 
            0.3066032351256413}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.1625596473328543, 
            0.30204496842637907`}, {-0.15073198275291547`, 
            0.2882264986590003}, {-0.1259294471922968, 
            0.26359217604203433`}, {-0.09312421598638322, 
            0.23687348261877464`}, {-0.05925305727019926, 
            0.21533294264796027`}, {-0.024882565713048088`, 
            0.1987566945120675}, {0.00942066401576676, 0.1869308765935728}, {
            0.03871921434798018, 0.1806674797169317}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.04462116781312979, 0.17964728019157275`}, {
            0.07457469463138554, 0.17717818734714275`}, {0.1326605419020214, 
            0.18386087956002034`}, {0.18176527201549197`, 
            0.20350306303247262`}, {0.22064189215386734`, 
            0.2331402276330914}, {0.24746186662247488`, 0.2679445395556307}, {
            0.2497000587374462, 0.27325633212580797`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.2520298576705231, 0.27878553070529793`}, {
            0.2640827492591745, 0.3073900725413197}, {0.2699164237139695, 
            0.3499818330252841}, {0.26481629075129015`, 0.3945048375436299}, {
            0.24879441673249453`, 0.4399353658958868}, {0.22242857105393876`, 
            0.4854271915566973}, {0.20967108126283837`, 
            0.5013500737350742}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.205919472064328, 0.5060325333901756}, {
            0.1864471706940415, 0.5303363083128265}, {0.14240874353709157`, 
            0.5739692566770221}, {0.11043817119415812`, 0.6014632342016905}, {
            0.0763428778598409, 0.6280441725908175}, {0.0405953006151685, 
            0.6535369780130068}, {0.02591483228667488, 
            0.6631694278932763}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.020898292873663234`, 0.6664609825894192}, {
            0.0036678765411700814`, 
            0.6777665566368616}, {-0.034112768533399604`, 
            0.7004658123477601}, {-0.07242000877978581, 
            0.7213676490310804}, {-0.108990115518863, 
            0.7391070314723185}, {-0.14571321949913765`, 
            0.7544731640150639}, {-0.18246960303747548`, 
            0.7668806204092751}, {-0.19455150206311062`, 
            0.769800890586852}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.20038356016642644`, 
            0.7712105353220772}, {-0.21913954845074224`, 
            0.7757439744049112}, {-0.2555496205733008, 
            0.7802311967691231}, {-0.2915263842395138, 
            0.7795102582690621}, {-0.35115222665010254`, 
            0.763975204086384}, {-0.37961611811050056`, 
            0.7474902559589645}, {-0.40647719011729805`, 
            0.7240181274109208}, {-0.417374401781736, 0.7098760365817244}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.42103660916071356`, 
            0.705123328184046}, {-0.43087071219660067`, 
            0.692360909444301}, {-0.4516989216323925, 
            0.6519047525547086}, {-0.46779267834338545`, 
            0.6017281589184296}, {-0.477659532494593, 
            0.5426930463374974}, {-0.4796383972500232, 
            0.47892844596632655`}, {-0.47950853699933327`, 
            0.4768909347121198}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           ArrowBox[{{-0.479126902893057, 
            0.4709030840619343}, {-0.47748131385732473`, 
            0.4450837424058853}, {-0.47301551239650086`, 
            0.4103790799920948}, {-0.4661308214838271, 
            0.37522717015072293`}, {-0.4567170697355791, 
            0.3400407243075375}, {-0.4445118816650327, 
            0.305198765389597}, {-0.4296966848202046, 
            0.2712108247685608}, {-0.41427939553951076`, 
            0.24214757119325292`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4114676740648869, 
            0.2368471728733963}, {-0.4099070271751887, 
            0.2339051851172469}, {-0.38693055698156814`, 
            0.19863028723400758`}, {-0.36088900420012415`, 
            0.16579850923402806`}, {-0.33220394188972, 
            0.13570419882694174`}, {-0.2859200981409383, 
            0.09634687979356349}, {-0.24371150523839577`, 
            0.06892225244667696}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.23868024676819655`, 
            0.06565324063788083}, {-0.2359695645373219, 
            0.06389200092517092}, {-0.18382952089991417`, 
            0.03832230901691595}, {-0.13097714704975855`, 
            0.019620550863950557`}, {-0.07854983649523417, 
            0.007402771600997767}, {-0.027684982744720244`, 
            0.0012850163627805844`}, {-0.01374698247166773, 
            0.0004312801241994286}, {-0.010144885364869535`, 
            0.0003210699871842854}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.0041476917593834955`, 0.00013757922905909461`}, {
            7.858835603125435*^-6, 0.000010435571665048216`}, {
            0.027784663601900825`, 0.001734115412072282}, {
            0.054512219780927226`, 0.005060506629221975}, {
            0.10585056831251305`, 0.014687366698048904`}, {0.152901256405968, 
            0.029816154122576204`}, {0.19563731280240637`, 
            0.04958662793466012}, {0.2227673976968338, 
            0.06717883331732145}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.22780164720105012`, 0.0704432370805373}, {
            0.24751523587496227`, 0.08322629699834844}, {0.29165543283178064`,
             0.12240642112923242`}, {0.3282430917194472, 
            0.16558267590259984`}, {0.3573911361416318, 
            0.21197258188845058`}, {0.3760074067150763, 
            0.2541499785204507}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.37843018431767456`, 0.2596390721330928}, {
            0.3789528101601851, 0.2608231437419974}, {0.3924855460736807, 
            0.3117917727010221}, {0.39741037663042156`, 0.3646795885397622}, {
            0.3928640291468017, 0.4196366228601952}, {0.38403958862784504`, 
            0.4580732189388927}, {0.37149971571979173`, 
            0.4942338166290146}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.3693244847405995, 0.4998182265735086}, {
            0.3513555162027229, 0.53873618758482}, {0.32701701059027577`, 
            0.5811505919594641}, {0.2973590530197779, 0.6251957241046833}, {
            0.26266199871999385`, 0.6711490797112754}, {0.23874811937048498`, 
            0.7001019097700374}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.23492717980066, 0.7047279686546329}, {
            0.2229699337915496, 0.7192047545668148}, {0.20126454924802548`, 
            0.7440816166465566}, {0.17832694433507099`, 0.7695568444588757}, {
            0.15425710663255798`, 0.7954883861631994}, {0.129184093510295, 
            0.8216830164377178}, {0.10315702041576495`, 0.8480882370340226}, {
            0.07622500279645086, 0.8746515497037053}, {0.07089792746720876, 
            0.8797641183527483}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.06656902561252835, 0.883918707229225}, {
            0.04843715609983576, 0.9013204561983577}, {0.019842595773402638`, 
            0.9280424582695714}, {-0.009509562735365497, 
            0.9547650576689378}, {-0.03957020397898544, 
            0.9814357561480485}, {-0.07507834023038057, 
            1.0111080170875675`}, {-0.11133907169021579`, 
            1.0385780874480548`}, {-0.11471320695834412`, 
            1.0408815076481772`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.11966860598620498`, 
            1.0442644088401536`}, {-0.14835239835849143`, 
            1.0638459672295093`}, {-0.1861183202352074, 
            1.086911656431932}, {-0.22464605080695027`, 
            1.1071237367553661`}, {-0.2639448035603067, 
            1.1238307898998559`}, {-0.3040145784952764, 
            1.1370328158654006`}, {-0.3357504291718867, 
            1.1445679896923058`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3415881349254546, 
            1.1459540602297462`}, {-0.34485537561185997`, 
            1.146729814652001}, {-0.38684139527785816`, 
            1.153069722355517}, {-0.4303468378610722, 
            1.1562004750718096`}, {-0.475371703361502, 
            1.1561220728008779`}, {-0.5219159917791483, 
            1.1528345155427224`}, {-0.5619098502398333, 
            1.1478393873437205`}, {-0.5802350637267606, 
            1.1448204500925276`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.586155264373206, 
            1.1438451428046295`}, {-0.6039331499571183, 
            1.1409163735941097`}, {-0.6479858909310025, 
            1.13206547429389}, {-0.6940680731614851, 
            1.1212866894430618`}, {-0.7425460527256532, 
            1.108247617830295}, {-0.7937861857005939, 
            1.092615858244259}, {-0.8183747490453251, 
            1.0843178210086868`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-0.8240597449519063, 
            1.0823992742820845`}, {-0.8477884720863063, 
            1.074391410684955}, {-0.9045529118827895, 
            1.0535742751523827`}, {-0.9434425407039863, 
            1.0379540305662016`}, {-0.9824989640707504, 
            1.0206103037306546`}, {-1.0217221819830828`, 
            1.0015430946457415`}, {-1.0449277179140881`, 
            0.989294834117677}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0502339420114843`, 
            0.9864941224530795}, {-1.0611121944409831`, 
            0.9807524033114617}, {-1.0918031930785337`, 
            0.9628639277482297}, {-1.1211732493093378`, 
            0.9435930764373166}, {-1.1492223631333949`, 
            0.9229398493787231}, {-1.1759505345507038`, 
            0.9009042465724494}, {-1.2008123191506175`, 
            0.877391340047695}, {-1.2232622725224873`, 
            0.8523062018336595}, {-1.23509417379205, 0.8365658362176409}}]}, {
          
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           ArrowBox[{{-1.2386993641893929`, 
            0.8317697334040113}, {-1.243300394666313, 
            0.8256488319303427}, {-1.2609266855820955`, 
            0.7974192303377442}, {-1.276113087850166, 
            0.7676135662421681}, {-1.2888315440508564`, 
            0.7362280088299192}, {-1.2990820541841677`, 
            0.7032625581009968}, {-1.306864618250099, 
            0.6687172140554005}, {-1.3126230593539197`, 
            0.6322981735562658}, {-1.315262242998456, 0.6074972539828245}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3158971467590543`, 
            0.6015309404464121}, {-1.316632191388483, 
            0.5946235837813709}, {-1.3188920143537897`, 
            0.5556934447307162}, {-1.3194025282498396`, 
            0.5155077564043026}, {-1.3185807791559194`, 
            0.4744443882123609}, {-1.3168438131513167`, 
            0.43288120956512544`}, {-1.3141916302360308`, 
            0.3908182204625959}, {-1.3117651897935367`, 
            0.36186825599798217`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3112640571007375`, 
            0.35588922045500304`}, {-1.310624230410062, 
            0.34825542090477213`}, {-1.3063457497112008`, 
            0.30558743634821667`}, {-1.3015603241772369`, 
            0.2632088922494883}, {-1.2962679538081718`, 
            0.2211197886085884}, {-1.2904686386040043`, 
            0.179320125425517}, {-1.284229044831124, 
            0.1380334538038864}, {-1.2809400522772996`, 
            0.11786637135126747`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.2799742883475627`, 
            0.11194460640895347`}, {-1.2776158387559198`, 
            0.09748332484730883}, {-1.2706290203783928`, 
            0.05766973855578446}, {-1.2632685896985416`, 
            0.018592694929314355`}, {-1.2555614158730555`, \
-0.019725635002736}, {-1.247534368058621, -0.057263080211001086`}, \
{-1.2391874462552397`, -0.09401964069547977}, {-1.2321618896601814`, \
-0.12318256920545072`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.2307566494003601`, -0.12901569013786568`}, \
{-1.2305206504629107`, -0.12999531645617196`}, {-1.2215263009203952`, \
-0.1652984780103835}, {-1.2121967178664539`, -0.20003749587542008`}, \
{-1.202531901301088, -0.23421237005128187`}, {-1.192531851224296, \
-0.2678231005379676}, {-1.1770250402494915`, -0.3167806282224171}, \
{-1.1626397679407674`, -0.35905484901301915`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1607069018242615`, -0.3647349923717438}, \
{-1.160464940863989, -0.36544604676388504`}, {-1.1428515530677892`, \
-0.4138193561623707}, {-1.124184876860891, -0.46190055641787386`}, \
{-1.1040362131616845`, -0.5103060802808613}, {-1.0819768628885578`, \
-0.5596523605017997}, {-1.0691943989092314`, -0.5864688496794512}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.06661270552024, -0.5918850161507885}, \
{-1.0580068260415114`, -0.6099393970806891}, {-1.0321261026205455`, \
-0.6611671900175284}, {-1.0035151981848374`, -0.7136535338749181}, \
{-0.9713546182935635, -0.7677162232154584}, {-0.9539432000520901, \
-0.79533869744191}, {-0.9499677455445681, -0.8014253444495989}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9466867220739431, -0.8064487780348281}, \
{-0.9356443629467253, -0.8233552580391486}, {-0.9164581069774691, \
-0.851765905007175}, {-0.8963844321443216, -0.8805706383459886}, \
{-0.8662364443963907, -0.9212539947673799}, {-0.8334711411961713, \
-0.9617740021490844}, {-0.8020453809459256, -0.9976175523965282}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7980898887703322, -1.0021291022021734`}, \
{-0.7980885225436631, -1.0021306604911018`}, {-0.7600885884388654, \
-1.0423239697934332`}, {-0.7194033836014226, -1.0812955898806962`}, \
{-0.67596495275098, -1.1179871805775083`}, {-0.6297732958875359, \
-1.152398741883871}, {-0.6181662167447372, -1.160018603491648}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6131504676928355, -1.1633113624333788`}, \
{-0.5808284130110888, -1.184530273799785}, {-0.5296497638578531, \
-1.2136479968931089`}, {-0.4767568081640434, -1.2390181317317013`}, \
{-0.4221495459296582, -1.2606406783155633`}, {-0.398265306570969, \
-1.2682208965613548`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.39254641735623547`, -1.27003591891648}, \
{-0.3658279771546955, -1.2785156366446953`}, {-0.3198759127445309, \
-1.2902367233315322`}, {-0.273763781049976, -1.2997258909908216`}, \
{-0.22749158207103107`, -1.3069831396225633`}, {-0.1810593158076963, \
-1.3120084692267568`}, {-0.15719201870802005`, -1.3136721707497463`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.15120654271503536`, -1.3140893962731794`}, \
{-0.13477609810288127`, -1.3152347021538777`}, {-0.08895104479950026, \
-1.3170946607544016`}, {-0.043584155897551526`, -1.317588345028328}, {
            0.001324568602964954, -1.316715754975657}, {
            0.04572315922159654, -1.3148042473220074`}, {
            0.0885868965109439, -1.3122393857795664`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.09457030220037649, -1.311795068618714}, {
            0.13283403037184713`, -1.3088465493886308`}, {
            0.17554631090346767`, -1.3048003591089028`}, {
            0.2258604435395959, -1.2992543273464012`}, {
            0.27588381217998037`, -1.2930859408960527`}, {
            0.32561641682462283`, -1.2862951997578564`}, {
            0.333037592946179, -1.2851825006955033`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.33897126704302744`, -1.2842928312555484`}, {
            0.37505825747352456`, -1.2788821039318121`}, {
            0.42467524428619324`, -1.2708879233811174`}, {
            0.47493328742213636`, -1.2623539280689702`}, {
            0.5258323868813556, -1.2532801179953696`}, {
            0.5755486645284549, -1.2440066954719375`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5814408906959706, -1.242874792593873}, {
            0.6300420003060614, -1.2334170161931646`}, {
            0.6843290053444179, -1.2224356497232736`}, {
            0.7402335577789233, -1.2107223937506424`}, {
            0.7977556576095768, -1.198277248275271}, {
            0.8164260720849787, -1.194112865501307}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.8222821696294482, -1.1928066796226284`}, {
            0.8326240967182723, -1.1904999422400688`}, {
            0.8678278305451337, -1.18239509670622}, {
            0.903360551060283, -1.173940914592348}, {
            0.939215950233843, -1.1651155988170765`}, {
            0.9753877200359355, -1.1558973522990281`}, {
            1.0118695524366832`, -1.1462643779568267`}, {
            1.0486551394062082`, -1.1361948787090954`}, {
            1.0550332203831818`, -1.1343841504597365`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.060805124227625, -1.1327455150486392`}, {
            1.0857381729146331`, -1.1256670574744574`}, {
            1.1227586831027647`, -1.1146564995551533`}, {
            1.1590030382820944`, -1.1031361726370412`}, {
            1.194046707272853, -1.091095259333493}, {
            1.227577428489352, -1.0785378483772043`}, {
            1.2592515048521271`, -1.0654632112094018`}, {
            1.2867725067758637`, -1.052784259734134}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.292089872179487, -1.0500134962801932`}, {
            1.3403004664001759`, -1.0231686287531958`}, {
            1.3814513738235554`, -0.9924773020912467}, {
            1.4121614257933512`, -0.9598483454732761}, {
            1.433334837492728, -0.9253186703041483}, {
            1.447230073669648, -0.8889127864731502}, {
            1.4492075879163826`, -0.8799240939831322}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.450496759793225, -0.874064227442676}, {
            1.455652464719626, -0.8506292275536925}, {
            1.4606313314681285`, -0.8104343500455208}, {
            1.4633494771691506`, -0.7682849050521277}, {
            1.464255182720192, -0.7241119497439177}, {
            1.4639902823107245`, -0.6894393797225671}, {
            1.4627862676155088`, -0.6536123260161593}, {
            1.4618231971017928`, -0.6350749174408312}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.4615119000532364`, -0.6290829983703197}, {
            1.4608686298691977`, -0.6167011820276722}, {
            1.4584628603064445`, -0.5787763411600836}, {
            1.4556943936170472`, -0.5399501767826131}, {
            1.4526886644908041`, -0.5003350622644803}, {
            1.4494796288843441`, -0.4601587509433629}, {
            1.4460880570888128`, -0.4194801446141478}, {
            1.443508762317786, -0.38976920986011393`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.4429898362116402`, -0.38379169234057786`}, {
            1.4425267260668602`, -0.378457119708535}, {
            1.4388084127811362`, -0.33724755265821915`}, {
            1.4349499180651881`, -0.29600328458824043`}, {
            1.430968042752563, -0.2548761566236338}, {
            1.426972404031183, -0.21493570168370535`}, {
            1.4228665842265633`, -0.17514578107471618`}, {
            1.419653889083354, -0.14493253665116915`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.4190194617091572`, -0.13896617243945114`}, {
            1.4186643234865264`, -0.1356263354968864}, {
            1.414379361958896, -0.09649730565043621}, {
            1.4100254397914944`, -0.05787863223558566}, {
            1.4056162971321453`, -0.0198902559525548}, {1.40116567412867, 
            0.017347882498438688`}, {1.396687310928893, 
            0.05371584241716965}, {1.390883769529806, 
            0.09937432395986652}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.390119902915453, 0.10532549110051923`}, {
            1.3839749001930854`, 0.15221342566298188`}, {1.3775236373711879`, 
            0.2001289065807078}, {1.3710233468455082`, 
            0.24729854332704457`}, {1.3644653978349914`, 
            0.2939470996607394}, {1.3578300802841752`, 
            0.34036647736036746`}, {1.3574360740740383`, 
            0.3430874779355065}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.3565762300004283`, 0.3490255473329687}, {
            1.3511115332306074`, 0.38676465567971907`}, {1.3443038957118352`, 
            0.43334961387258464`}, {1.3373509758095088`, 
            0.48042147442974314`}, {1.3301678210590504`, 
            0.5283330131202606}, {1.3227054296786669`, 0.5773711891153455}, {
            1.3213082638461155`, 0.5864191729843008}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.3203926120720806`, 0.5923488931993452}, {
            1.3149147998865645`, 0.6278229615862082}, {1.3067284646278745`, 
            0.6799514741663553}, {1.2980684052631135`, 0.7340062616106046}, {
            1.2888697926335657`, 0.7902538697721349}, {1.2823483989182816`, 
            0.8293123771462457}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{1.2813602886636302`, 0.8352304543783079}, {
            1.2790677975805158`, 0.8489608445041247}, {1.2685571869004793`, 
            0.9099748285508031}, {1.2573276150883426`, 0.9722069627380749}, {
            1.2453203643286417`, 1.0353265904372007`}, {1.2380683722897203`, 
            1.0712806458096997`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{1.2368820536869904`, 1.0771621973203827`}, {
            1.2324767168059125`, 1.0990030550194405`}, {1.223235259643004, 
            1.141937639074281}, {1.215236948731389, 1.1761288391364895`}, {
            1.2069720427155735`, 1.2089312925176998`}, {1.1897385149115216`, 
            1.2688127731747936`}, {1.1754705117453528`, 
            1.3088965722577965`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.1734584525785159`, 1.3145491484765792`}, {
            1.171698527474471, 1.3194933921419398`}, {1.1530542197617244`, 
            1.3598711305934221`}, {1.131960157368948, 1.3932767228648308`}, {
            1.1105259252838013`, 1.4156941206752338`}, {1.067300436612837, 
            1.439792402508421}, {1.0233449985390128`, 1.4468419875441338`}, {
            0.9976020636562407, 1.4463566733951305`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9916050559989247, 1.4461779146239824`}, {
            0.9653325266093912, 1.4451315413776233`}, {0.934746585538384, 
            1.443351457939841}, {0.9022602645509294, 1.440909981184253}, {
            0.8678413596170131, 1.437993886423205}, {0.8311550412809476, 
            1.4347188686788122`}, {0.7985667354329703, 1.4317286675946785`}, {
            0.7640226801658898, 1.428496977819458}, {0.7523787815431557, 
            1.4273890775718043`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.7464057582589179, 1.4268207529762151`}, {
            0.7274236628141972, 1.4250146338295635`}, {0.6886704707123861, 
            1.4212724701014081`}, {0.6477858812334221, 1.4172565761883265`}, {
            0.6047926717502686, 1.4129530416436538`}, {0.562659742085417, 
            1.4086399423416203`}, {0.5189758369341929, 1.404052134939244}, {
            0.5076100228867757, 1.4028233954298734`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5016447807615342, 1.4021785028905738`}, {
            0.4740136156835526, 1.399191342966998}, {0.428045737720452, 
            1.3940592899553537`}, {0.38141465382542394`, 
            1.3886689757046344`}, {0.3344628147790006, 1.383033400015163}, {
            0.2831238972304674, 1.3766321744897687`}, {0.2633034942301193, 
            1.3740532892849546`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.2573536462488289, 1.3732791387830918`}, {
            0.2320459160347847, 1.3699862828802485`}, {0.18173737157520864`, 
            1.3631222923595763`}, {0.1327067642349952, 1.3560667701007258`}, {
            0.08506348491812366, 1.348831800510986}, {0.03868886196898663, 
            1.3414211921315395`}, {0.019937013629275465`, 
            1.3382615983494532`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.014020413693803047`, 
            1.3372646804974877`}, {-0.006250698068539812, 
            1.3338490983362008`}, {-0.04958878865057961, 
            1.3261296724987852`}, {-0.09143104287933718, 
            1.3182983288110282`}, {-0.13203854508334856`, 
            1.3104026305034773`}, {-0.17147806555823514`, 
            1.302474954508165}, {-0.2098163745996183, 
            1.2945476777571236`}, {-0.22166008708204885`, 
            1.2920296869549792`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.2275289190694866, 
            1.2907819645887346`}, {-0.24723607488228727`, 
            1.286592194096866}, {-0.2839859590119842, 
            1.2785450498964643`}, {-0.32023208218076, 
            1.270386350871791}, {-0.35614049958066557`, 
            1.262096202738718}, {-0.4032829777036802, 
            1.2508462340204074`}, {-0.45078469347535666`, 
            1.2390238323732785`}, {-0.4612476597147224, 1.23631167404733}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4670557034746327, 
            1.2348061416886715`}, {-0.4991170726191883, 
            1.226495352255025}, {-0.5487515408586686, 
            1.2131271481233414`}, {-0.6002603554735157, 
            1.1986676089052257`}, {-0.6542733917755728, 
            1.182797714652992}, {-0.697943120894651, 1.1693965026216115`}}]}, {
           Arrowheads[{{0.0006685329578423794, 1.}}], 
           
           ArrowBox[{{-0.7040951482703488, 
            1.1654103792578472`}, {-0.7109324629872322, 
            1.1654103792578472`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.24017776779883498`, 
            0.84040262014396}, {-0.28953895610067754`, 
            0.8556509246177588}, {-0.3407498214628198, 
            0.865305371595066}, {-0.3941264725649757, 
            0.8676062200201089}, {-0.433786577669217, 
            0.8636207712036137}, {-0.4748226934156393, 
            0.8539658359071203}, {-0.4755531760221542, 
            0.8536877728155357}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.4811606538425698, 
            0.8515532488654365}, {-0.5175627004427625, 
            0.8376965662731584}, {-0.5619481719551204, 
            0.8134434398048691}, {-0.6077443328211647, 
            0.7793249353646055}, {-0.6542964897135372, 
            0.7336341798175187}, {-0.6722896926546577, 0.712006817383642}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6761270723605695, 
            0.7073943866803516}, {-0.6776833568003978, 
            0.7055237732192291}, {-0.7010519710508025, 
            0.6734097822526084}, {-0.724072278546205, 
            0.6376366159432564}, {-0.7464142253680595, 
            0.5985486833167715}, {-0.7622291259716752, 
            0.5677433745475925}, {-0.777433860675131, 
            0.5351612509596876}, {-0.7920284294784266, 
            0.5008023125530564}, {-0.7928854209498218, 
            0.49858784315160415`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7950508966239472, 
            0.4929922453189529}, {-0.8060128323815623, 
            0.4646665593276993}, {-0.8191702665574111, 
            0.4271514932015954}, {-0.8312839291788459, 
            0.388654616092724}, {-0.8423538202458666, 
            0.34917592800108527`}, {-0.8523799397584736, 
            0.30871542892667875`}, {-0.8611781463778647, 
            0.2677864976259997}, {-0.8620607432646539, 
            0.2629011289271861}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8631274428867678, 
            0.25699671092740134`}, {-0.8685642987652378, 
            0.2269025128555433}, {-0.8745383969205931, 
            0.18606347461530925`}, {-0.8791004408439307, 
            0.1452693829052975}, {-0.8829286886527589, 
            0.08614600049951272}, {-0.8830630002492001, 
            0.028789717039140364`}, {-0.8823924644814344, 
            0.018318237447939537`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8820090428811448, 
            0.012330500991111184`}, {-0.8795033756332545, \
-0.02679946747581939}, {-0.8722498148049219, -0.08062155304536692}, \
{-0.8654494172584153, -0.11410781286466293`}, {-0.8567086068256258, \
-0.146737176164979}, {-0.8460273835065536, -0.17850964294631483`}, \
{-0.8334057473011991, -0.20942521320867058`}, {-0.8283400282962866, \
-0.21988176323717754`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.825724111430865, -0.22528148350337676`}, \
{-0.8188436982095617, -0.2394838869520462}, {-0.802341236231642, \
-0.26868566417644185`}, {-0.7838983613674395, -0.29703054488185754`}, \
{-0.7635150736169543, -0.3245185290682929}, {-0.7282900643139907, \
-0.36480237513992564`}, {-0.68765066075339, -0.4032395882038069}, \
{-0.6773098039018378, -0.41142623528440475`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6726055589328993, -0.4151504908170202}, \
{-0.6415257677269919, -0.4397557324903194}, {-0.5898442900266359, \
-0.4742763722298458}, {-0.562011055579325, -0.4907507378352243}, \
{-0.5329711222747269, -0.5066509471853268}, {-0.5027244901128419, \
-0.5219770002801528}, {-0.47127115909367, -0.5367288971197026}, \
{-0.4674818859391597, -0.5383183844297995}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4619489473856845, -0.540639287478931}, \
{-0.41612806866077096`, -0.5598597823603965}, {-0.3587648811599246, \
-0.5810866698099164}, {-0.30965110128856876`, -0.597444087568453}, \
{-0.2598947808051624, -0.6123336413128226}, {-0.23530953167893864`, \
-0.6188882389640014}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.22951203582052015`, -0.6204338915030995}, \
{-0.20975053974500216`, -0.6257024431901437}, {-0.1594729981433845, \
-0.6374976053475346}, {-0.10955848737581131`, -0.6477198674946254}, \
{-0.06030996974561996, -0.6563270672910367}, {-0.011692011679860202`, \
-0.6632019638088726}, {0.006069527875835427, -0.665060621243352}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.012036943478777169`, -0.6656850818279908}, {
            0.03633082039441839, -0.6682273161202372}, {
            0.09075873599829468, -0.6715619625676668}, {
            0.14420812295879928`, -0.6722211275981453}, {
            0.19667898127593217`, -0.6702048112116729}, {
            0.24817131094969336`, -0.6655130134082495}, {
            0.25150873325937495`, -0.6650119727000362}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.2574422398688171, -0.6641211869145037}, {
            0.29906658423401605`, -0.6578722052021341}, {
            0.34974627338283343`, -0.647008857607585}, {
            0.40021037839614565`, -0.6329229706246026}, {
            0.45045889927395255`, -0.6156145442531866}, {
            0.4879498236725201, -0.6001919419232449}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.49349866508232765`, -0.5979093208401903}, {
            0.501049271716189, -0.5948032356920655}, {
            0.5525389314227896, -0.5702087021399668}, {
            0.604927878393755, -0.541830943596891}, {
            0.6582161126290844, -0.5096699600628378}, {
            0.6875896534825715, -0.491056546948403}, {
            0.7027408283537734, -0.4810148174694975}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.7077421087279373, -0.47770012372512183`}, {
            0.7174097075307708, -0.47129273864020893`}, {
            0.7648037819629677, -0.43660263959316514`}, {
            0.8132562830774767, -0.3992775729606929}, {
            0.8620935615183223, -0.36076727428072997`}, {
            0.8978334095207153, -0.3313142300792595}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.9024637046491001, -0.3274984251806757}, {
            0.9117003946118417, -0.3198865115057857}, {
            0.9366626479978328, -0.298610600662707}, {
            0.9615577977359504, -0.2768488629559061}, {
            0.9863858438261943, -0.2546012983853829}, {
            1.0111467862685644`, -0.2318679069511374}, {
            1.0356093084895905`, -0.2087189568452523}, {
            1.0595420939158022`, -0.1852247162598103}, {
            1.079155897295327, -0.1652451023926814}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.083351234329103, -0.16095580892668668`}, {
            1.1058184543837828`, -0.13720036365025548`}, {
            1.1392140219519802`, -0.09995958954567058}, {
            1.1704913047588232`, -0.062179843527067034`}, {
            1.1990813822072295`, -0.024027388079503186`}, {1.224415333700114, 
            0.014331514311962848`}, {1.2316539883575226`, 
            0.026998204909215104`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.2346309911834734`, 0.032207567074997064`}, {
            1.2464152813379612`, 0.052828520050336426`}, {1.2652839430484346`,
             0.09145123918894499}, {1.280873291975223, 
            0.13011733971821354`}, {1.293035301262014, 
            0.16874448962856703`}, {1.3021284542086327`, 
            0.20733551778713014`}, {1.3088006684898397`, 
            0.24594191641914168`}, {1.3102303907338324`, 
            0.25810858658245184`}}]}, {
           Arrowheads[{{0.0017189774753443002`, 1.}}], 
           
           ArrowBox[{{1.3115293998450215`, 0.2794590202080621}, {
            1.312739309728405, 0.2794590202080621}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5363362975390406, 
            0.76715324492146}, {-0.5598938430140652, 
            0.744148175903389}, {-0.5831210422301636, 
            0.7166755361695751}, {-0.6056512599614053, 
            0.6847712814021556}, {-0.6271178609818594, 
            0.6484713672832678}, {-0.6471931195411236, 
            0.6071514691819374}, {-0.6633185979416829, 
            0.5662892663209227}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6655205824256971, 
            0.5607079538335761}, {-0.6816797226870436, 
            0.5099917119483619}, {-0.6952644140805726, 
            0.4558084369318584}, {-0.7058144683118281, 
            0.39892966190619755`}, {-0.7129076664681326, 
            0.3401708205652817}, {-0.7136676766191251, 
            0.32631461731613365`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7139962815613958, 
            0.32032362250793067`}, {-0.7161840358496054, 
            0.28043735515079016`}, {-0.7152836037563662, 
            0.22063470790440104`}, {-0.7096198280422824, 
            0.16212779974040872`}, {-0.6987874221182233, 
            0.10591396863501541`}, {-0.6918214338394032, 
            0.08272160132290851}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6900954649043689, 
            0.07697520843386092}, {-0.6826982966198094, 
            0.05234728242276101}, {-0.6612643621826619, 
            0.001781808938186393}, {-0.633824223502503, \
-0.04520461523384077}, {-0.6001751300269739, -0.08821316850871452}, \
{-0.5644338821900554, -0.12366942582092641`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5600945165301228, -0.12780478332421322`}, \
{-0.516649589743801, -0.16195448103040988`}, {-0.46764885183447286`, \
-0.1924343671664885}, {-0.41444981422935157`, -0.21849606213788525`}, \
{-0.35804121064635563`, -0.2401521595413884}, {-0.3509708590633803, \
-0.2422339830865399}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3452151750015952, -0.24392871049261822`}, \
{-0.29941177480340286`, -0.25741525297378665`}, {-0.24001987215183926`, \
-0.2700794181703588}, {-0.18094816275626904`, -0.27811354515559134`}, \
{-0.12262182225449633`, -0.2817924489600838}, {-0.10915469438086645`, \
-0.28169784594961256`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.10315484241611174`, -0.281655698576871}, \
{-0.06546602628432645, -0.2813909446144358}, {-0.017248350761352275`, \
-0.27790735316841764`}, {0.029072432683442343`, -0.2715518448311742}, {
            0.07349632405005738, -0.26232441960270547`}, {
            0.11602332333849281`, -0.2502250774830115}, {
            0.13260896199381422`, -0.24426107784172904`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.13825502710931475`, -0.2422308195548286}, {
            0.15668823477230256`, -0.23560245593408424`}, {
            0.19552586257504062`, -0.2188051924179159}, {
            0.2325362067467069, -0.19983328693450636`}, {
            0.26771926728730167`, -0.17868673948385566`}, {
            0.30128268297383565`, -0.1557598717348549}, {
            0.3334340925833198, -0.13144700535639542`}, {
            0.34456043001812275`, -0.1221451253290927}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.3491636615812815, -0.11829671537484673`}, {
            0.3641734961157542, -0.10574814034847707`}, {
            0.39350089357113893`, -0.07866327671109985}, {
            0.42943120468383206`, -0.04237721058141797}, {
            0.463713055400106, -0.004861630691796993}, {0.4963464457199608, 
            0.033883462957763164`}, {0.5134832509692874, 
            0.055992180446801126`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.5171590225636239, 0.060734405998825104`}, {
            0.5273313756433966, 0.07385807036726261}, {0.5597472800143054, 
            0.1194635132022348}, {0.5904991384076915, 0.16623157310412887`}, {
            0.6128578840435241, 0.20246401644585102`}, {0.6342561057797629, 
            0.23954813837287012`}, {0.6465375385001277, 
            0.26255542844291474`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6493630161166322, 0.26784850658692816`}, {
            0.6546055574253609, 0.2776695650367381}, {0.6738553712027712, 
            0.31700607556544247`}, {0.6895459754311337, 0.3515162928374147}, {
            0.7044778483993148, 0.3870827802756242}, {0.7182941713568991, 
            0.4241452733659825}, {0.7306381255534711, 0.4631435075944013}, {
            0.7374536744016632, 0.4904358951808904}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.7389073728702149, 0.4962571287926372}, {
            0.743116192761504, 0.5131110530052492}, {0.7529341179045385, 
            0.5665928239466254}, {0.7594831646059319, 0.6243024685693059}, {
            0.7621545964890417, 0.6869536350240667}, {0.7618307568776295, 
            0.7202804412072461}, {0.7611404834701337, 0.734400080893801}}]}, {
          
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.7608475085669005, 0.740392923767269}, {
            0.7601266135694245, 0.7551389323859834}, {0.7570421665644269, 
            0.7915291085602786}, {0.7525774158626368, 0.8294509697301317}, {
            0.7483870774277144, 0.8608995897688375}, {0.7431297697776961, 
            0.8933494194634362}, {0.7304264247752716, 0.9457492515581235}, {
            0.7212596538770514, 0.9764235636370747}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.7195416752859157, 0.9821723504273809}, {
            0.7144882248333342, 0.9990824617391078}, {0.6968736747710688, 
            1.0519836020824467`}, {0.6759064244681472, 1.1040206027504944`}, {
            0.6515695177573302, 1.1536418216890516`}, {0.6238459984713784, 
            1.1992956168439177`}, {0.6227462218986457, 
            1.2007353938905165`}}]}, {
           Arrowheads[{{0.018574026191876775`, 1.}}], 
           
           ArrowBox[{{0.6191040908655929, 1.2055035047887732`}, {
            0.5929120423005046, 1.2397929334440048`}, {0.5589438249349217, 
            1.2739447167182247`}, {0.532300256784743, 1.2950494719476662`}, {
            0.5043409394682978, 1.3129025466170388`}, {0.47521347692090943`, 
            1.3272405024209981`}, {0.4450654730779008, 
            1.337799901054198}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9006992167051403, -0.20694155106116677`}, \
{-0.8826894928755505, -0.2592046182166136}, {-0.8596270082485928, \
-0.3097234851892964}, {-0.8308312682060339, -0.35874315117961014`}, \
{-0.796302272747874, -0.40626361618755485`}, {-0.7873509866841664, \
-0.4164952721522941}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7834003122325646, -0.421011041342306}, \
{-0.7560400218741128, -0.4522848802131304}, {-0.7152722444003062, \
-0.49174609775815403`}, {-0.669141593165745, -0.5301725591418353}, \
{-0.6440642436772956, -0.5489778774079446}, {-0.6176442833268866, \
-0.5674847489032626}, {-0.602535498810386, -0.577394031564561}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5975183193543759, -0.5806846105874975}, \
{-0.5898817121145176, -0.5856931736277892}, {-0.5607765300401887, \
-0.6036031515815244}, {-0.5304461702215773, -0.6211766408895218}, \
{-0.49900806577636053`, -0.6383755996768354}, {-0.4664622167045386, \
-0.6552000279434647}, {-0.43280862300611134`, -0.6716499256894098}, \
{-0.3857770763674646, -0.6931389138325371}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.38031974051571765`, -0.6956324024331201}, \
{-0.3787757229318903, -0.6963378730783143}, {-0.3230395836260312, \
-0.7199050696383846}, {-0.283139170860897, -0.7357532113697092}, \
{-0.2429677548336321, -0.7509400872855965}, {-0.2025253355442364, \
-0.7654656973860458}, {-0.1618119129927102, -0.7793300416710577}, \
{-0.156169547300138, -0.7811495392508586}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.15045911217263833`, -0.7829909872285702}, \
{-0.1210586336647713, -0.7924717799323248}, {-0.08049664404613761, \
-0.8048295719615408}, {-0.040125944136809276`, -0.8164034177587052}, {
            0.00005346606321357528, -0.8271933173238182}, {
            0.048197331207703795`, -0.8390642565291309}, {
            0.08093061634980508, -0.8462848441383848}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.08678975861389975, -0.847577303781507}, {
            0.09594650587592207, -0.8495971772996768}, {
            0.14330099006786823`, -0.8587920796354555}, {
            0.1902607837835426, -0.8666489635364674}, {
            0.23706602779223393`, -0.8730376361657224}, {
            0.28395686286323085`, -0.8778279046862306}, {
            0.3242614794335138, -0.8805664457343579}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.330247677192609, -0.8809731844576232}, {
            0.3309332889965336, -0.881019769097992}, {
            0.3779953061921422, -0.8826132294010067}, {
            0.42559308556731423`, -0.8824051553599868}, {
            0.47417679823930736`, -0.8801924167396442}, {
            0.5237464442081216, -0.875975013539979}, {
            0.5696429297740561, -0.8703263581757889}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5755905397829171, -0.8695414833789112}, {
            0.6298785439679233, -0.8606321117227476}, {
            0.6875244744072389, -0.8487071461232338}, {
            0.7474495027187448, -0.8337193084480059}, {
            0.8091958926186638, -0.815605650902036}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.8149059403957947, -0.8137639125925532}, {
            0.8419486789339866, -0.8049369843765326}, {
            0.8745465582371453, -0.793488619518738}, {
            0.907656954738959, -0.7810647636092354}, {
            0.9412798684394273, -0.7676654166480249}, {
            0.9851342464084496, -0.749689481538708}, {
            1.0293899743898307`, -0.7299567053628802}, {
            1.0377816338708947`, -0.7253083887597729}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0430302154497733`, -0.7224010890831217}, {
            1.0850479699520743`, -0.699126571531611}, {
            1.138261902592108, -0.6651305181483697}, {
            1.1892290178827778`, -0.6296444522610597}, {
            1.2357024984747207`, -0.5911783613656129}, {
            1.2402110739150465`, -0.5866518431781684}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.244445280813925, -0.5824007854347958}, {
            1.276734140034962, -0.549983426459586}, {
            1.311375738230528, -0.5063108285405362}, {
            1.339602204255895, -0.4605485569027977}, {
            1.3613884493055401`, -0.413084600840705}, {
            1.3720380334153615`, -0.3823685978956594}}]}, {
           Arrowheads[{{0.00027321485249625526`, 1.}}], 
           
           ArrowBox[{{1.3742605142926956`, -0.37434322129968906`}, {
            1.3748205218538696`, -0.37434322129968906`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, -0.7864170130565192}, {-1.471954889637079, \
-0.8043544247070936}, {-1.4337653581600633`, -0.8332637641713465}, \
{-1.4007232869599495`, -0.8621672120177628}, {-1.370973453954144, \
-0.8910924156858344}, {-1.3433450532682485`, -0.9200505007581241}, \
{-1.321286273480508, -0.9451222904025524}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.3173487949321334`, -0.9496487262529694}, \
{-1.2944525488561895`, -0.9780653151153577}, {-1.272473827554896, \
-1.0069731213422164`}, {-1.2511873034232535`, -1.0356159628571229`}, \
{-1.2305929764612629`, -1.0639938396600774`}, {-1.2106908466689235`, \
-1.09210675175108}, {-1.1786580249399279`, -1.137938756624258}, \
{-1.175123568634828, -1.1428879457334884`}}]}, {
           Arrowheads[{{0.01999999999999999, 1.}}], 
           
           ArrowBox[{{-1.1716365829080644`, -1.1477706632699989`}, \
{-1.1472155064610596`, -1.1819667362028583`}, {-1.1106563205572155`, \
-1.225783791043853}, {-1.0734291388103498`, -1.2646102213257666`}, \
{-1.0355834288160166`, -1.3004976976144207`}, {-1.0078486562701399`, \
-1.3217937476596036`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.003089730688414, -1.325447872357475}, \
{-0.9965006623267483, -1.3305072659165553`}, {-0.9559486267628459, \
-1.3548243499165031`}, {-0.9136951095446104, -1.3736343732985972`}, \
{-0.8695862862678662, -1.3875929017554847`}, {-0.8234683325284372, \
-1.3973555009798135`}, {-0.7790639202736506, -1.402926445780127}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7731105901314913, -1.4036733461874493`}, \
{-0.7671235232562517, -1.4044244791804132`}, {-0.7078963671369601, \
-1.4077708954302883`}, {-0.6459615480113599, -1.4082252714148722`}, \
{-0.5814937497202484, -1.4066181288195985`}, {-0.5484224554218304, \
-1.405149001889673}, {-0.5333273677619416, -1.4043511893964276`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.527335730393085, -1.4040345166313815`}, \
{-0.5149428604004437, -1.4033795229850994`}, {-0.48105496465608816`, \
-1.4013096921058774`}, {-0.4467587681887636, -1.398939509252007}, \
{-0.41369890306609025`, -1.3964343633859768`}, {-0.3805366381594581, \
-1.3937416994059613`}, {-0.3472719734688671, -1.3908615173119605`}, \
{-0.31390490899431744`, -1.3877938171039743`}, {-0.28808795630926365`, \
-1.3852926144687938`}}]}, {
           Arrowheads[{{0.01118534425257845, 1.}}], 
           
           ArrowBox[{{-0.2821159180921656, -1.3847140303923449`}, \
{-0.28055792763969034`, -1.3845630888822118`}, {-0.24735351230886715`, \
-1.3811938227468818`}, {-0.21429166300184782`, -1.377686018697984}, \
{-0.18137237971863232`, -1.3740396767355187`}, {-0.14867268908377224`, \
-1.370273150969758}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.0084517815711076`, 1.5}, {-1.0249862448288576`, 
            1.4728759631187207`}, {-1.0499841031495707`, 
            1.4377043206924498`}, {-1.0744418761015886`, 
            1.4074108654424475`}, {-1.0982598053059658`, 
            1.3803084095104496`}, {-1.1213658343732902`, 
            1.3553477870923785`}, {-1.1612644040661222`, 
            1.3159747972469575`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.1655382636474496`, 
            1.3117637206599513`}, {-1.2026129502164637`, 
            1.2776795868749875`}, {-1.2367506606241034`, 
            1.2468204889809387`}, {-1.2538512253610659`, 
            1.2303008048168182`}, {-1.2696935564196157`, 
            1.214252252247263}, {-1.2987377213215738`, 
            1.1828418183861027`}, {-1.322594831797833, 
            1.1525486181673086`}, {-1.3312009449111717`, 
            1.1391160277333887`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3344377361478366`, 
            1.1340639803770936`}, {-1.3415737613092549`, 
            1.1229259321017444`}, {-1.3639456826070573`, 
            1.074572839477134}, {-1.3764845017523315`, 
            1.0258426546448813`}, {-1.3824659263665902`, 
            0.9759366239668239}, {-1.385165664071347, 
            0.9240559938047997}, {-1.384984309784923, 0.9030940923115796}}]}, {
           Arrowheads[{{0.018410379435117762`, 1.}}], 
           
           ArrowBox[{{-1.384932402041828, 
            0.8970943168502638}, {-1.3846923797292718`, 
            0.8693512501095502}, {-1.3811547382030345`, 
            0.8109728788318165}, {-1.3773592582920187`, 
            0.7683209834001015}, {-1.3729831941278805`, 
            0.7236288158163234}, {-1.3680999907527656`, 
            0.6769147014451757}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8229559166608289, 
            0.12431559072348561`}, {-0.8211573832231699, 
            0.07145960237502327}, {-0.8157407797229232, 
            0.02050090148427367}, {-0.8067061061600888, \
-0.028560511948763176`}, {-0.7940533625346664, -0.07572463792408754}, \
{-0.7811853361278853, -0.11057428837155484`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-0.7791070258007147, -0.11620284290926483`}, \
{-0.7774102571500277, -0.12079809260004118`}, {-0.7564044983095444, \
-0.16358749213496587`}, {-0.7310360860132163, -0.20409283652886204`}, \
{-0.7013050202610435, -0.24231412578172992`}, {-0.6802789972489748, \
-0.2651797069327157}, {-0.6573808922174382, -0.28709103184032425`}, \
{-0.6356529623528308, -0.3054741678726263}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.630999341623912, -0.3092578999626126}, \
{-0.6059684360959606, -0.32805091292541066`}, {-0.5775622401770264, \
-0.3470510805415453}, {-0.5475002725806375, -0.3650002147916168}, \
{-0.5157825333067939, -0.38189831567562516`}, {-0.48240902235549565`, \
-0.3977453831935703}, {-0.44770518664510756`, -0.41247457995873393`}, \
{-0.42065701150599055`, -0.4227340842669007}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.41504701614647277`, -0.42486198277627296`}, \
{-0.4119964730939947, -0.4260190685843978}, {-0.37528288170215723`, \
-0.43837884907056185`}, {-0.33756441246959495`, -0.4495539214172263}, \
{-0.2847646711966765, -0.46291876980896307`}, {-0.23193459445191733`, \
-0.47378301679899637`}, {-0.1822926505129931, -0.4816374320033207}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.17634937735659145`, -0.482448712407455}, \
{-0.12618343454687614`, -0.4880097065739532}, {-0.07612935698636593, \
-0.49119618941824233`}, {-0.027131309834296076`, -0.4919353683451162}, {
            0.02067371890729157, -0.49020630902504475`}, {
            0.06303106941359277, -0.4863618110989587}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.06899384269658401, -0.4857136208274493}, {
            0.11228056172750883`, -0.47927478098809884`}, {
            0.15605598495536394`, -0.47006052893647}, {
            0.19851630047435945`, -0.45835231742362853`}, {
            0.23974682200969344`, -0.4441690671428742}, {
            0.29215466708698673`, -0.42193689062019274`}, {
            0.2983036653395982, -0.4187472483555434}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3036297419381436, -0.4159844765469377}, {
            0.34286817954129156`, -0.3956304979253541}, {
            0.392165130900998, -0.36546654464053385`}, {
            0.4403232926944963, -0.33166168634790744`}, {
            0.48559638746204664`, -0.2964009483074228}, {
            0.5022752327023081, -0.28239370636787764`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5068698672591578, -0.2785350364818933}, {
            0.5306213081382098, -0.2585880812812664}, {
            0.5753980547229863, -0.21822308526943845`}, {
            0.6199266272163758, -0.17530596027193862`}, {
            0.6448395991702189, -0.1503188197700867}, {
            0.6698908665230541, -0.1248086112159883}, {
            0.6808888240143348, -0.11344228174468525`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6850610163689783, -0.10913034355451436`}, {
            0.6950804292748816, -0.0987753346096435}, {
            0.720408287425701, -0.07221898995105225}, {
            0.7459044287863853, -0.04518498734704828}, {
            0.771598841167807, -0.017718736904465435`}, {0.7974915245699662, 
            0.01017976137669635}, {0.8235824789928629, 0.03851050749643708}, {
            0.8488548696095384, 0.06627572133834078}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.852866997752584, 0.07073693688522235}, {
            0.8759968018844718, 0.09654801173429227}, {0.9022295705990852, 
            0.12627458697306596`}, {0.9284794108262376, 
            0.15647304429173708`}, {0.9487158993449821, 
            0.17992785937047379`}, {0.9688116434978846, 
            0.20372173939796345`}, {1.0069054188062916`, 
            0.2533514625520826}, {1.0074752200014083`, 0.254168635880435}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0109070142322738`, 0.25909030108207143`}, {
            1.0427505610323156`, 0.3047583294192268}, {1.0639271884156736`, 
            0.33651344298300656`}, {1.0837946448546791`, 
            0.3691608564954745}, {1.1023529303493327`, 
            0.40270056995663067`}, {1.1196020448996338`, 
            0.43713258336647487`}, {1.1321695748453697`, 
            0.4655774477733148}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.134594375350809, 0.47106564807111934`}, {
            1.135306821985371, 0.4726781724100093}, {1.1492320950863328`, 
            0.509558612772236}, {1.1613778642025194`, 0.5477739044531549}, {
            1.1717441293339304`, 0.5873240474527661}, {1.1803049870420885`, 
            0.6284967581009655}, {1.1870345338885158`, 0.6715797527276488}, {
            1.1905163414513282`, 0.7035622742338861}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.191165700446406, 0.7095270318061191}, {
            1.191932769873213, 0.716573031332816}, {1.1949996949961792`, 
            0.7634765939164674}, {1.196380975994842, 0.8257087138690729}, {
            1.195103722272968, 0.8905595573674072}, {1.1934948959105482`, 
            0.9239790588561904}, {1.1918323865440064`, 
            0.9492640348767425}}]}, {
           Arrowheads[{{0.0102128947069636, 1.}}], 
           
           ArrowBox[{{1.191438731280855, 0.9552511072442518}, {
            1.1912535370904567`, 0.9580677113233663}, {1.188390346220181, 
            0.9928303381329223}, {1.1849160237072085`, 1.0282717626488453`}, {
            1.1792852986023312`, 1.0771891615384939`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6322381920236446, 
            0.48954847901901866`}, {-0.6391550070435292, 
            0.4450960693791035}, {-0.643571038463079, 
            0.398887506085972}, {-0.6452456233482929, 
            0.35155532374369114`}, {-0.6438217272594584, 
            0.30389007229363746`}, {-0.6390354129614322, 
            0.25655588940733953`}, {-0.6379938944025583, 
            0.2506777339966347}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           ArrowBox[{{-0.6369470917384078, 
            0.2447697559853073}, {-0.6307856633270669, 
            0.20999569128409362`}, {-0.6189714612292153, 
            0.1646523941231958}, {-0.6030919362999203, 
            0.12120337263894092`}, {-0.5829661007638727, 
            0.08013843473362553}, {-0.5589727613828972, 
            0.04161914638854658}, {-0.5465198952857125, 
            0.025391711865340862`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5428671203721753, 
            0.02063175016055441}, {-0.5314907249188191, 
            0.0058070735850012795`}, {-0.5088216241196272, \
-0.019045689380904385`}, {-0.4843292958480132, -0.04215690855620659}, \
{-0.4580137401039772, -0.0635265839409053}, {-0.4298749568875192, \
-0.0831547155350005}, {-0.40029295724378844`, -0.10100930091204562`}, \
{-0.369647752217934, -0.11705833764559405`}, {-0.35446315857848004`, \
-0.12387929069473899`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3489899967476489, -0.12633784709505463`}, \
{-0.3379393418099559, -0.13130182573564578`}, {-0.3051677260198538, \
-0.14373976518220102`}, {-0.2718042508285233, -0.15440297938695996`}, \
{-0.23832026221685904`, -0.16332229175162324`}, {-0.20471576018486112`, \
-0.17049770227619088`}, {-0.1709907447325295, -0.1759292109606628}, \
{-0.12512499260572468`, -0.18073794823703732`}, {-0.11661586000283873`, \
-0.18109597816566284`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.1106211641205189, -0.1813482107537589}, \
{-0.08051418939940796, -0.1826149906376302}, {-0.03715833511357984, \
-0.18156033816244127`}, {0.004942570251760023, -0.17757399081147074`}, {
            0.04551990374436398, -0.17098216242330258`}, {
            0.08430504241198439, -0.16211106683652093`}, {
            0.12129798625462121`, -0.1509607040511258}, {
            0.12566648030079794`, -0.14929405603184426`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.13127235593101116`, -0.1471553278072721}, {
            0.15649873527227443`, -0.13753107406711718`}, {
            0.18999472691300107`, -0.12218790388663026`}, {
            0.22187339862485816`, -0.10529692051180019`}, {
            0.2521347504078457, -0.08685812394262701}, {
            0.2807787822619636, -0.06687151417911072}, {
            0.31835921156255476`, -0.03707213099712306}, {
            0.33455084708719673`, -0.02254294035122297}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.33901654266455505`, -0.018535751434992274`}, {
            0.35342358292924136`, -0.00560792618038972}, {0.3859718963620235, 
            0.027521100271089394`}, {0.4160041518609012, 
            0.06231494835731435}, {0.4422182769018579, 0.09642376986269592}, {
            0.4664680055067965, 0.1314050181607898}, {0.48875264417936365`, 
            0.16722679472999308`}, {0.4889792360921372, 
            0.16763528988062146`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.49188965939422513`, 0.172882140002615}, {
            0.5090714994232053, 0.20385720104870253`}, {0.5273319920001198, 
            0.24136759780788936`}, {0.5434415426719059, 0.2798293456985249}, {
            0.5572661425513347, 0.319367688973744}, {0.5685393187700297, 
            0.3602291539103993}, {0.5756155898285069, 
            0.39643093868959484`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5767666118732372, 0.4023194994859648}, {
            0.5768425360927864, 0.40270792330875704`}, {0.5819109082608043, 
            0.4470916107363095}, {0.583238928668991, 0.4938221629795201}, {
            0.5803210907122537, 0.5433415268248523}, {0.575251002292674, 
            0.580362464495829}, {0.5671720833908265, 0.6193958193614255}, {
            0.5616042778119867, 0.640007295211706}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5600395736334213, 0.6457996782129913}, {
            0.5560843340067109, 0.6604415914216422}, {0.5419877541403273, 
            0.7034997806764788}, {0.5256927935817752, 0.7459263926634481}, {
            0.5060729631564663, 0.7905482409401361}, {0.48296421098063547`, 
            0.837249766750162}, {0.46695339431211125`, 
            0.8663651055390811}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           ArrowBox[{{0.4640622450030545, 0.8716226007290685}, {
            0.45620248517051737`, 0.8859154113371454}, {0.4257709363848225, 
            0.9359415034525655}, {0.39165271528226137`, 0.9867243718479026}, {
            0.37383451685485203`, 1.012073702916228}, {0.35515094133691055`, 
            1.0372785096092143`}, {0.3277217015429138, 
            1.0685471606892958`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.32376502584281464`, 1.0730576725675913`}, {
            0.3185277711825085, 1.0790280126069272`}, {0.2799639372642434, 
            1.117773924806448}, {0.240708057870609, 1.154344616822057}, {
            0.20006808752623623`, 1.1865648684698429`}, {0.15847920784060723`,
             1.2140161960213085`}, {0.1389903271272832, 
            1.2243219443437827`}}]}, {
           Arrowheads[{{0.009094684054451267, 1.}}], 
           
           ArrowBox[{{0.13368626162061328`, 1.227126741858926}, {
            0.1163766004232043, 1.2362801157479577`}, {0.07412458453441688, 
            1.2536007417080528`}, {0.032087479434634476`, 
            1.2662221879598576`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.23154267397474682`, 
            0.8975789783991697}, {-0.26528976028608203`, 
            0.9138180206111962}, {-0.30015729362302135`, 
            0.92831255364258}, {-0.33627648180684927`, 
            0.9407000205593665}, {-0.37379582982631543`, 
            0.950688864088019}, {-0.4129898102843838, 
            0.957776948899597}, {-0.45408049895172975`, 
            0.9613967062670189}, {-0.46077908046629135`, 
            0.9613698194214642}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.46677903213481975`, 
            0.9613457367446322}, {-0.4974125533147557, 
            0.9612227795557149}, {-0.5433986248877194, 
            0.9566769971238891}, {-0.5924513651848784, 
            0.9471811873297457}, {-0.6477024097847539, 
            0.9308875610251097}, {-0.6993401150028478, 
            0.9103035603843869}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7049136167933079, 
            0.9080818318249678}, {-0.7073182166079139, 
            0.907123301930669}, {-0.7481173575446678, 
            0.8873229059679819}, {-0.7909187002525161, 
            0.8633411775589165}, {-0.8354960103531153, 
            0.83461432355949}, {-0.8816230534681219, 
            0.8005785508257193}, {-0.9050817487556408, 
            0.7814310755812164}, {-0.9068512353011433, 
            0.7798667724488504}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.9113464901604522, 
            0.7758927714737801}, {-0.9285559249959876, 
            0.7606788819486507}, {-0.9520455821891625, 
            0.7383219699280221}, {-0.975550720335165, 
            0.7143603395193306}, {-0.9971324524742216, 
            0.6916302519412482}, {-1.018435456668925, 
            0.6674655400283498}, {-1.046897609496355, 
            0.6278216856305633}, {-1.0674160424525938`, 
            0.5950381876999645}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0705992424571682`, 
            0.5899522032592807}, {-1.07352445999515, 
            0.5852784124630972}, {-1.0989563520713446`, 
            0.5414740458195905}, {-1.1219983273023388`, 
            0.4951474922240025}, {-1.1423774683481938`, 
            0.4466689837732566}, {-1.1598208578689713`, 
            0.3964087525642764}, {-1.1669191493156843`, 
            0.37107955776481716`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1685382226200316`, 
            0.3653021360530888}, {-1.1742731203098875`, 
            0.3448380086173804}, {-1.1856788801161589`, 
            0.2924279619528874}, {-1.1931823704642868`, 
            0.2466091753844019}, {-1.198659161079715, 
            0.20066524214264275`}, {-1.2021675686713826`, 
            0.15496563856131626`}, {-1.2031092065869184`, 
            0.128404041813934}}]}, {
           Arrowheads[{{0.00838556703362356, 1.}}], 
           
           ArrowBox[{{-1.2033217796710098`, 
            0.12240780860600088`}, {-1.203765909948228, 
            0.10987984097412824`}, {-1.2036196174526668`, 
            0.06551334515985487}, {-1.201955332774814, 
            0.021820800865883547`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           ArrowBox[{{-0.5846294015164717, 
            0.8486035374250669}, {-0.6266336896127048, 
            0.8242199347129426}, {-0.6704506158747108, 
            0.7923935467654227}, {-0.7157906082508622, 
            0.7519641968479027}, {-0.7389897228242118, 
            0.7279522355115287}, {-0.762519166237061, 
            0.7011041229160174}, {-0.7671622324207698, 
            0.6952901973908168}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.770906431167238, 
            0.6906018100617936}, {-0.7861303892439236, 
            0.6715387696151187}, {-0.8095748425993133, 
            0.6393750861625819}, {-0.8282897436689806, 
            0.611384232965095}, {-0.8466862754323692, 
            0.5816110576344427}, {-0.8647644378894791, 
            0.550055560170625}, {-0.8825242310403103, 
            0.5167177405736418}, {-0.8971284677327476, 
            0.48713305232145604`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8997813044571106, 
            0.48175143300908824`}, {-0.916175881166609, 
            0.44569627192693695`}, {-0.9318395310779446, 
            0.40826290711390467`}, {-0.9467283975547376, 
            0.36954778864108573`}, {-0.9606322388887893, 
            0.32998160100709384`}, {-0.9733408133719013, 
            0.2899950287105423}, {-0.9827780631533243, 
            0.2568741777862797}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9844222257076172, 
            0.2511038459504958}, {-0.9848541210040731, 
            0.2495880717514313}, {-0.9951721617853049, 
            0.20876073012976076`}, {-1.006831815093939, 
            0.1545847096454755}, {-1.015977151348547, 
            0.10112082315335996`}, {-1.0226081705491292`, 
            0.048369070653413976`}, {-1.0252491452594055`, 
            0.014984261279620777`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.0257223095204782`, 
            0.009002947412079335}, {-1.0267248726956855`, \
-0.003670547854362726}, {-1.028307473765435, -0.05488088053523592}, \
{-1.0273353137938837`, -0.10488505436659541`}, {-1.0249533154941561`, \
-0.1414800348135072}, {-1.021164146519028, -0.17748926853321081`}, \
{-1.0159678068684994`, -0.21291275552570624`}, {-1.01273562592237, \
-0.22996457716813398`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0116182197685015`, -0.23585960927044664`}, \
{-1.0093642965425706`, -0.24775049579099345`}, {-1.001303157207986, \
-0.28213821682388995`}, {-0.9917339305314903, -0.3162116461192132}, \
{-0.9806566165130832, -0.34997078367696327`}, {-0.9680712151527652, \
-0.38341562949714003`}, {-0.9504674245652674, -0.42384796166963185`}, \
{-0.9316262632197643, -0.4611865069634929}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9288058927409835, -0.4664799440090677}, \
{-0.9068057405146756, -0.5048287238269226}, {-0.8807478470515816, \
-0.5453771538117211}, {-0.851310825605863, -0.5861487241691472}, \
{-0.8179335824867601, -0.6273278760010585}, {-0.7883507228932821, \
-0.6602951340716615}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7843435001337798, -0.6647607992803093}, \
{-0.780616117694273, -0.6689146093074557}, {-0.7393584312284016, \
-0.7109089240883384}, {-0.7164029320229531, -0.7327555570579969}, \
{-0.6922121828611221, -0.7546838896826771}, {-0.6667861837429084, \
-0.7766939219623791}, {-0.640124934668312, -0.7987856538971028}, \
{-0.6122523523575194, -0.8208875685633077}, {-0.6063700988719347, \
-0.8253489686511417}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6015895602980478, -0.8289747721405187}, \
{-0.5831923535307171, -0.8429281490374533}, {-0.5529449381879049, \
-0.8649073953195395}, {-0.5215101063290829, -0.8868253074095663}, \
{-0.489020793323006, -0.9085484520860472}, {-0.45560993453842885`, \
-0.9299433961274947}, {-0.4212775299753516, -0.9510101395339097}, \
{-0.40217611525901586`, -0.9622467669827617}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.397004569263999, -0.9652889885429747}, \
{-0.38602357963377415`, -0.9717486823052917}, {-0.35035506972193875`, \
-0.9922965023136727}, {-0.31401353251420105`, -1.0123097933997725`}, \
{-0.25753346438611585`, -1.0397572450706205`}, {-0.200550757775471, \
-1.065182997542908}, {-0.18273015434818712`, -1.0728861876877729`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.17722267253402277`, -1.0752668691168281`}, \
{-0.16304877645394372`, -1.0813937220622925`}, {-0.12555285851985856`, \
-1.0965563314626254`}, {-0.08806300397321554, -1.1106708257439069`}, \
{-0.05057921281401466, -1.123737204906137}, {-0.013189944386254093`, \
-1.135698696035253}, {0.02401634196606787, -1.1464985262171927`}, {
            0.049526304456228756`, -1.153139460635522}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.05533277668316323, -1.1546510426802152`}, {
            0.061039646242951315`, -1.156136695451956}, {
            0.09787996844439617, -1.164613203739543}, {
            0.13455952486255396`, -1.1719621140329624`}, {
            0.17110053178957604`, -1.178217489285223}, {
            0.20750298922546248`, -1.183379329496325}, {
            0.24376689717021327`, -1.1874476346662686`}, {
            0.29218077115351765`, -1.1912239715541206`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.29816260149323526`, -1.1916905610812578`}, {
            0.2990211994319643, -1.1917575326908625`}, {
            0.3546970756123242, -1.1939763674820427`}, {
            0.4107945257112934, -1.1941041390398095`}, {
            0.46731354972887124`, -1.1921408473641624`}, {
            0.5249518166028997, -1.188270356673535}, {
            0.5378945968570257, -1.1870526384581996`}}]}, {
           Arrowheads[{{0.013846559364612812`, 1.}}], 
           
           ArrowBox[{{0.5438682160501097, -1.1864906120032905`}, {
            0.5844069952712201, -1.1826765311863603`}, {
            0.6456790857338324, -1.175359370902639}, {
            0.7087680879907367, -1.1663188758223704`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7468538202868837, 
            0.07299985600577912}, {-0.7381359897819815, 
            0.03451645140623947}, {-0.7268524426821459, \
-0.0025557205654536917`}, {-0.7129042200906728, -0.03806968147105262}, \
{-0.6962593635894364, -0.0719737046202673}, {-0.6768859147603112, \
-0.10421606332280779`}, {-0.6545519230565767, -0.1347431454844137}, \
{-0.64765537820266, -0.14256222343610309`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6436865031904829, -0.1470620046683095}, \
{-0.6291854316343879, -0.1635028473340015}, {-0.6009944726299323, \
-0.19044570466604638`}, {-0.5701870781793981, -0.21552225327502378`}, \
{-0.5367138887983092, -0.2387969646420793}, {-0.500706907696455, \
-0.2601263274308824}, {-0.46242818957125326`, -0.27946535605999623`}, \
{-0.4496998501672448, -0.28493212756763203`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4441868273019583, -0.2872999491164039}, \
{-0.42213978912012184`, -0.29676906494798405`}, {-0.3802093171777187, \
-0.3119965714850631}, {-0.337004384578701, -0.32510699306145086`}, \
{-0.29283281733977984`, -0.33607451371494124`}, {-0.24821256949496429`, \
-0.34486292133588203`}, {-0.21331748797676278`, -0.34988795838628123`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.20737874842674509`, -0.35074316161186886`}, \
{-0.2003927400811343, -0.35174917590510907`}, {-0.13759818255398706`, \
-0.35705563823453385`}, {-0.07657260602839598, -0.3578860923044697}, \
{-0.01747764950608867, -0.35440284914057624`}, {
            0.03177734175742348, -0.3478059051467061}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.03772423975181774, -0.3470094101722904}, {
            0.039525048011208375`, -0.346768219768513}, {
            0.09392151384563215, -0.3349353807753076}, {
            0.1454796422602285, -0.3190248162988931}, {
            0.19446059466463406`, -0.2994497986912873}, {
            0.24112553246848534`, -0.2766236003045082}, {
            0.2618642717634404, -0.264822981129406}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.26707914757380535`, -0.261855647261694}, {
            0.28037811721703343`, -0.254288356215263}, {
            0.31814820227136775`, -0.22993787165083523`}, {
            0.35443578763148825`, -0.20357214661122494`}, {
            0.389240873297395, -0.1751911810964321}, {
            0.42282952329644247`, -0.1452051678927382}, {
            0.4553452382994599, -0.1141413902717865}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.459546085062976, -0.10985749334183376`}, {
            0.48715570837602384`, -0.08164857677749171}, {
            0.5178932434565577, -0.04807799886593908}, {
            0.5478930590144548, -0.013536054981551157`}, {0.5773678071665829, 
            0.021753765945887762`}, {0.6063174879129418, 
            0.05779146391637767}, {0.6167457299113, 0.07128712254481617}}]}, {
          
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6204143661301069, 0.07603487025231469}, {
            0.6347421012535318, 0.09457703892991859}, {0.6687532238318128, 
            0.14053352316262596`}, {0.7022483773004579, 
            0.18774642945734116`}, {0.7333793617567308, 0.2333644113225668}, {
            0.7585555038299009, 0.2721955249666274}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7618195911630219, 0.2772299796423355}, {
            0.764014054003477, 0.28061466962770826`}, {0.7941862853780965, 
            0.32970729544673494`}, {0.8235128973807799, 
            0.38133551525804815`}, {0.8510066836578649, 0.435997393141185}, {
            0.8743148070957645, 0.4888674702202189}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8767351783171902, 0.4943576253319161}, {
            0.8767822490901752, 0.4944643964927312}, {0.8888575369321114, 
            0.5253690353923763}, {0.9001669454479978, 0.5577133860055608}, {
            0.9107104746378337, 0.5914974483322846}, {0.9204881245016192, 
            0.6267212223725475}, {0.929281688330488, 0.6636688747585354}, {
            0.9368729594155722, 0.7026245721224333}, {0.9403902076499324, 
            0.7251758538341152}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9413148292331355, 0.7311041820072071}, {
            0.9432619377568731, 0.7435883144642417}, {0.9484486233543894, 
            0.7865601017839601}, {0.9523590527635035, 0.8333179185215053}, {
            0.9545815040490387, 0.8824006092008071}, {0.9549864522199956, 
            0.9335113606886563}, {0.9539096293773349, 0.9704105320437095}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.9537346068122364, 0.9764079787589132}, {
            0.9534443722853744, 0.9863533598518435}, {0.9498588531314349, 
            1.0400888804748614`}, {0.9441334836444374, 1.093880196342203}, {
            0.9388566547131613, 1.135673054088635}, {0.9322381119513625, 
            1.17638501402869}, {0.9223364012869996, 1.2138269721142108`}}]}, {
          
           Arrowheads[{{0.013937741304700407`, 1.}}], 
           
           ArrowBox[{{0.9207339442232367, 1.219606894620558}, {
            0.908166990912523, 1.2565533055265548`}, {0.8944413479717293, 
            1.2918228869851553`}, {0.8790628127541699, 1.3217852406509836`}, {
            0.84369600410261, 1.3661069707370226`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0863426908642362`, -1.5}, {
            1.102655010867748, -1.4816324256319815`}, {
            1.1264375557841442`, -1.4578461846519668`}, {
            1.1725144575096142`, -1.4165103341755527`}, {
            1.216315635919208, -1.3808732921477884`}, {
            1.258978952670864, -1.3480856543443493`}, {
            1.2666998521293786`, -1.3423415532800163`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.2715137544508353`, -1.3387601646611318`}, {
            1.2984188487069719`, -1.3187436392053802`}, {
            1.3177792751601805`, -1.3038684150252713`}, {
            1.335857454789662, -1.2895310841955219`}, {
            1.3693034335484058`, -1.2617358875166322`}, {
            1.3973907681201125`, -1.2354873144877294`}, {
            1.4203702807337064`, -1.2104188124885797`}, {
            1.445390689873563, -1.1753999730248845`}}]}, {
           Arrowheads[{{0.018013829478021028`, 1.}}], 
           
           ArrowBox[{{1.4488787607895706`, -1.1705180306568408`}, {
            1.449440104377487, -1.1697323680052294`}, {
            1.4673145049480818`, -1.130644151690877}, {
            1.4730840118049517`, -1.1116427835677127`}, {
            1.4778133919343723`, -1.0928477612674032`}, {
            1.4813052335967902`, -1.0741444656326231`}, {
            1.4854761436476411`, -1.0367288931288388`}, {
            1.4869137937907664`, -0.9989673919499867}, {
            1.4866348776194067`, -0.9604507766278998}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.5, -0.4681793116971826}, {-1.472632075906381, \
-0.4848195158761078}, {-1.4210443654571507`, -0.5214509162300867}, \
{-1.3791798673147313`, -0.5576048460902399}, {-1.3418773703106053`, \
-0.5938108388505017}, {-1.3170832939696473`, -0.6218121441888388}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.313105719008389, -0.6263042369558652}, \
{-1.309886660734279, -0.6299396953772929}, {-1.2869435652397687`, \
-0.6623734010609867}, {-1.2653963939670982`, -0.6951773483295458}, \
{-1.2443240268629343`, -0.7285439386028654}, {-1.2240335039450554`, \
-0.7624090380743139}, {-1.205847698999217, -0.7922691862144895}, \
{-1.1877829780163132`, -0.8225340105253827}, {-1.184239033883532, \
-0.828591366465328}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.1812091209732862`, -0.8337701334765312}, \
{-1.1698393409963437`, -0.8532035110069938}, {-1.152016787939308, \
-0.8842776876593226}, {-1.1340816378769127`, -0.9156321397613956}, \
{-1.115800209840864, -0.9471424665922391}, {-1.0971725038311613`, \
-0.978808668151853}, {-1.0781985198478048`, -1.0106307444402374`}, \
{-1.0596638906767313`, -1.0407005328934344`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0564317980058406`, -1.0457551647365593`}, \
{-1.038539205230097, -1.0732992347143795`}, {-1.0176857464132374`, \
-1.1037848270779023`}, {-0.9961497532577072, -1.1337046509257267`}, \
{-0.9687335449063074, -1.169310265377009}, {-0.940058821999085, \
-1.203004406259903}, {-0.9099451296019088, -1.2342116490486772`}, \
{-0.9093426946679416, -1.2347459641372007`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9048538658689174, -1.2387272222314532`}, \
{-0.8782120127806476, -1.2623565692176009`}, {-0.844832675671131, \
-1.287282807234232}, {-0.809868127592023, -1.3090734692765809`}, \
{-0.7732696213834447, -1.3275123293845925`}, {-0.7349884098855168, \
-1.3423831615982127`}, {-0.6970823796563689, -1.3534258274670399`}}]}, {
           Arrowheads[{{0.003195458095457159, 1.}}], 
           
           ArrowBox[{{-0.6901018885545579, -1.3627347654908197`}, \
{-0.654936944168146, -1.3627347654908197`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, -1.1855648815248672`}, {-1.4662536354371873`, \
-1.2053454756786}, {-1.4210770246915816`, -1.2347686230312511`}, \
{-1.3801255563853987`, -1.263186512457561}, {-1.3441216978288166`, \
-1.2893457058694193`}, {-1.3066626620967432`, -1.3160949342316495`}, \
{-1.3011904079395948`, -1.3197694677525997`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.2962092099510394`, -1.3231142646969316`}, \
{-1.271930477602374, -1.3394170557039629`}, {-1.2380677898788304`, \
-1.361004595509456}, {-1.205944095696938, -1.3791229719813094`}, \
{-1.1751135746300219`, -1.394074266708174}, {-1.1451304062514067`, \
-1.4061605612787016`}, {-1.0866293943405574`, -1.4231483223754495`}, \
{-1.0805151061477967`, -1.4242135022458826`}}]}, {
           Arrowheads[{{0.01624842530950693, 1.}}], 
           
           ArrowBox[{{-1.074604133761836, -1.4252432621462525`}, \
{-1.0365137153641533`, -1.431879054515611}, {-0.9858412983438547, \
-1.436257064379732}, {-0.9340070017437097, -1.4374450239220866`}, \
{-0.8804056840277664, -1.436605605096949}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7197927325727591, 1.5}, {-0.727077761924682, 
            1.486377813124913}, {-0.7590335063067366, 
            1.4362819180656063`}, {-0.7909061191826798, 
            1.3963913455672132`}, {-0.8248553289250299, 
            1.3592885104051617`}, {-0.8589960064784387, 
            1.3284309276801018`}, {-0.8737531925370269, 
            1.3185462973403248`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-0.8787382316759437, 
            1.315207227891591}, {-0.9121387187212575, 
            1.2928349770911542`}, {-0.9659323211875865, 
            1.2605162504054854`}, {-1.0194225336579898`, 
            1.228962958909001}, {-1.072305966136541, 
            1.1989405377908853`}, {-1.0845625289537795`, 
            1.1919112823896187`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0897673158027856`, 
            1.1889262876063047`}, {-1.123356561787279, 
            1.1696625354205046`}, {-1.1713482637742418`, 
            1.1403425001672254`}, {-1.2150658131053205`, 
            1.1105948008737003`}, {-1.2532939507884049`, 
            1.0800338063825825`}, {-1.2793443300385023`, 
            1.0556260788910545`}, {-1.284373751837968, 
            1.0500352001092772`}}]}, {
           Arrowheads[{{0.004350573624300164, 1.}}], 
           
           ArrowBox[{{-1.288386495808791, 
            1.0455744954760804`}, {-1.3019171854037908`, 
            1.0305333141284483`}, {-1.3205808924707474`, 
            1.0045701425079423`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5203024102113541, 1.5}, {-0.5371532318262536, 
            1.467046423782276}, {-0.5566382998562858, 
            1.4335591759601232`}, {-0.5758033955911115, 
            1.4060510591425797`}, {-0.6034250858196214, 
            1.3722607292120585`}, {-0.6378231569715508, 
            1.3429881613054468`}, {-0.6716797518070998, 
            1.3182907585554142`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6766039121777949, 
            1.314863251000504}, {-0.7079849696766667, 
            1.2933014780595276`}, {-0.743979181523161, 
            1.2715277107267564`}, {-0.7808403028214743, 
            1.2514775870250898`}, {-0.8187045986282765, 
            1.232419091153481}, {-0.8575739453279783, 
            1.2139710121663927`}, {-0.887117612953812, 
            1.2004729523887727`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.8925749917034391, 
            1.1979795576781185`}, {-0.8974502193049909, 
            1.195752139118288}, {-0.9365231175041816, 
            1.1780752397853944`}, {-0.9758095158401845, 
            1.1599855152223237`}, {-1.015309414313, 
            1.1414829654290761`}, {-1.0550228129226276`, 
            1.1225675904056511`}, {-1.0939045431789152`, 
            1.102965200990848}, {-1.1090730485348566`, 
            1.0945360733459268`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1143176721382073`, 
            1.0916216397372858`}, {-1.13090943659171, 
            1.0824016080234653`}, {-1.1660374931610127`, 
            1.060876811503503}, {-1.1992887128868222`, 
            1.0383908114309615`}, {-1.229727179584832, 
            1.0147410861492352`}, {-1.2564169770707336`, 
            0.9897251140017185}, {-1.2793581053445275`, 
            0.9633428949884119}, {-1.2961910409252544`, 
            0.9390058292114016}}]}, {
           Arrowheads[{{0.005389957066688717, 1.}}], 
           
           ArrowBox[{{-1.2994294053593252`, 
            0.9339641084509062}, {-1.314308467602703, 
            0.9063622511782664}, {-1.3269459282809057`, 
            0.8755288960091054}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3446033746702703, 1.5}, {-0.3577593085868577, 
            1.4736885121404404`}, {-0.37630357282117743`, 
            1.4411217433113679`}, {-0.39428707142560415`, 
            1.414776892092624}, {-0.4067629544334471, 
            1.4004217344391094`}, {-0.4191177325456056, 
            1.3873414919189009`}, {-0.4436355971370981, 
            1.3632779216723856`}, {-0.46785241275641853`, 
            1.3428052598804736`}, {-0.4919166046515592, 
            1.3249278995509826`}, {-0.49874171369852355`, 
            1.3204655072063356`}}]}, {
           Arrowheads[{{0.013049909238544521`, 1.}}], 
           
           ArrowBox[{{-0.5037635916924529, 
            1.317182103269247}, {-0.5286488296285039, 
            1.3009116386515507`}, {-0.565650297638948, 
            1.2799818952904618`}, {-0.6032391890045617, 
            1.2611881095268642`}, {-0.6417336840470148, 
            1.2435797214199056`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.5, -1.4004968513051506`}, {-1.4826776370242565`, \
-1.4049878506754614`}, {-1.4448726097074143`, -1.4149203348860995`}, \
{-1.4116030399002744`, -1.4234481271917396`}, {-1.387306908214823, \
-1.4290849171447864`}, {-1.36460642920351, -1.4340228778351178`}, \
{-1.3217405936772437`, -1.4426129540807906`}, {-1.2832059636094197`, \
-1.4488904887090375`}, {-1.265604851765152, -1.451092544904854}}]}, {
           Arrowheads[{{0.008410430244037781, 1.}}], 
           
           ArrowBox[{{-1.259651264354409, -1.4518373918305003`}, \
{-1.247770886363392, -1.453323733159118}, {-1.2019804871247175`, \
-1.4572215998704214`}, {-1.159017651013966, -1.45891427446949}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.5, -1.0045132003631996`}, {-1.485708505139749, \
-1.0134207713935024`}, {-1.4446829087510478`, -1.0418114651588632`}, \
{-1.4094301020351148`, -1.0697260819321417`}, {-1.369666527329365, \
-1.1081943780813004`}, {-1.333808613639296, -1.1451978370211096`}, \
{-1.3189434003043092`, -1.160660380007022}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.314785128321807, -1.164985744051763}, \
{-1.2992124396372149`, -1.1811841909065424`}, {-1.2671397450111095`, \
-1.215136334683223}, {-1.2369434473534566`, -1.2467577926187792`}, \
{-1.207976464256733, -1.2757520889808398`}, {-1.1798981927385377`, \
-1.3019590788606767`}, {-1.1523680298164691`, -1.325218617349563}, \
{-1.1428124257819021`, -1.3319136307335158`}}]}, {
           Arrowheads[{{0.003895932708220032, 1.}}], 
           
           ArrowBox[{{-1.1323328070260952`, -1.3582833944855843`}, \
{-1.105175604695955, -1.3582833944855843`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.18382426614256758`, 1.5}, {-0.19093924176723054`, 
            1.486318249652206}, {-0.2094378294878278, 
            1.4551172724355657`}, {-0.22724347466742534`, 
            1.4300542965654337`}, {-0.2387621736815254, 
            1.4172357247488803`}, {-0.25010287446611046`, 
            1.4055621942023706`}, {-0.2724661643092744, 
            1.3841281321638514`}, {-0.29425798236620637`, 
            1.3659997395149817`}, {-0.31559422955116356`, 
            1.3503129825437141`}, {-0.34661685418635585`, 
            1.3301063091735923`}, {-0.34768288275178316`, 
            1.3295023807871185`}}]}, {
           Arrowheads[{{0.002314893300286829, 1.}}], 
           
           ArrowBox[{{-0.35579732021593097`, 
            1.3144917735821473`}, {-0.3741789647762453, 
            1.3144917735821473`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.017229442696264627`, 1.}}], 
           
           ArrowBox[{{-0.03644267847927633, 1.5}, {-0.05512714776299307, 
            1.47054633150413}, {-0.07362434010703414, 
            1.446326164190298}, {-0.08422138144147386, 
            1.435321556711002}, {-0.0946521189201026, 
            1.4252377914358805`}, {-0.11520328369412924`, 
            1.4066402477486206`}, {-0.1351750499613158, 
            1.3907937305587204`}, {-0.15464147435636266`, 
            1.3770425754720212`}, {-0.18391089903206875`, 
            1.358652843760174}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.33668070509341497`, -0.6527031086760351}, \
{-0.3008771323090242, -0.6657329076263793}, {-0.2645504122638067, \
-0.6781584705107697}, {-0.2136123297236373, -0.6943378563616138}, \
{-0.16252287928478576`, -0.7091926553038934}, {-0.13023577055160576`, \
-0.7178848030676176}, {-0.10752998681288317`, -0.7236178814156433}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.10171256188569419`, -0.7250867473783916}, \
{-0.09810857060216295, -0.72599673421839}, {-0.0661412794364574, \
-0.7335284487562107}, {-0.034333897054489165`, -0.7404799466810795}, {
            0.028610174064619572`, -0.7525341476589154}, {
            0.09053267546154724, -0.7620511921188514}, {
            0.134375951271472, -0.7672010542964526}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.14035088817814442`, -0.7677425230901797}, {
            0.18038349536513265`, -0.7710774901505953}, {
            0.22471518288605624`, -0.7732294359003398}, {
            0.2686510554530671, -0.7738072461393326}, {
            0.3124753227735517, -0.772644975354184}, {
            0.35647219455489665`, -0.769576678031504}, {
            0.37988593730675096`, -0.7669398448802857}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3858482463154776, -0.7662683753839885}, {
            0.4006416707971019, -0.7646023541712927}, {
            0.4449837515001672, -0.7577220037735503}, {
            0.49924075550857827`, -0.746463516240014}, {
            0.5549901574703152, -0.7315575045725504}, {
            0.6122319573853785, -0.7130039687711599}, {
            0.6187295320344043, -0.7105479372009244}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.6243419669237573, -0.7084264814241586}, {
            0.6709661552537679, -0.6908029088358421}, {
            0.7231541127232632, -0.6684320972000051}, {
            0.7770730031814228, -0.6427791607421773}, {
            0.8046613989013498, -0.6286859506313733}, {
            0.832642229108639, -0.6137003191677842}, {
            0.8421930128429084, -0.6083555747331024}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.8474289121427168, -0.6054254964880267}, {
            0.8610154938032908, -0.5978222663514102}, {
            0.8897811929853047, -0.5810517921822512}, {
            0.9187950819935035, -0.5633822294357158}, {
            0.9479129161667097, -0.5448069108872122}, {
            0.9771346955049234, -0.5253258365367406}, {
            1.0064604200081442`, -0.504939006384301}, {
            1.0436215822474915`, -0.47857792812366956`}, {
            1.048590966075309, -0.47482612521985224`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0533794872017286`, -0.4712108706753101}, {
            1.0803780851704519`, -0.4508273740955062}, {
            1.1269710009934468`, -0.4088930204317751}, {
            1.170108627168636, -0.3650265421557988}, {
            1.2108542243552294`, -0.32044597374404715`}, {
            1.2241357878545547`, -0.30345370559880575`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.2278307497178238`, -0.29872641707059144`}, {
            1.2468157635646318`, -0.2744372250607448}, {
            1.2776306565936837`, -0.22739158828223655`}, {
            1.3029363152392266`, -0.1797003555848672}, {
            1.3230213983377084`, -0.13170258625661752`}, {
            1.3371534918937518`, -0.08696940402626249}}]}, {
           Arrowheads[{{0.003005248802224667, 1.}}], 
           
           ArrowBox[{{1.3408154676640407`, -0.05469988453526136}, {
            1.3450635805290914`, -0.05469988453526136}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.590014821142007, -0.6526475896914061}, \
{-0.5605863750002678, -0.6716326184270776}, {-0.5298765196740457, \
-0.6904281437017935}, {-0.49802567983963825`, -0.7089891167056167}, \
{-0.4651742801733426, -0.7272704886286089}, {-0.4313223206751592, \
-0.7452722594707706}, {-0.39646980134508747`, -0.7629944292321017}, \
{-0.38107862488328914`, -0.7703851258196748}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.37566988854768996`, -0.7729823495782233}, \
{-0.3432306002479615, -0.7885593873657615}, {-0.2887110164052429, \
-0.8132544719590776}, {-0.2479500726016019, -0.8309085410403179}, \
{-0.2068625429044176, -0.8479846306182507}, {-0.1555139092074973, \
-0.8683731525473327}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.14990869418034636`, -0.8705130746893015}, \
{-0.10122081181147863`, -0.8888330739019915}, {-0.04851101619155888, \
-0.9075189314816987}, {0.004019248884227758, -0.9249404419129299}, {
            0.04021465470943958, -0.936269935879137}, {
            0.07601438633678356, -0.9469359741907255}, {
            0.07739097664753679, -0.9473224869831537}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.08316759617194872, -0.94894442004903}, {
            0.11152193011836595`, -0.9569056215085072}, {
            0.14684077240629334`, -0.9661459424932943}, {
            0.18207439955267232`, -0.9746240018058988}, {
            0.21732629790960933`, -0.9823068641071329}, {
            0.252699953829211, -0.9891615940578085}, {
            0.28829885366358365`, -0.9951552563187376}, {
            0.31759945070889467`, -0.9992929375890314}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.3235405058958053, -1.000131903181939}, {
            0.3259546048654228, -1.0004728099585405`}, {
            0.3639425064363372, -1.0047795131115116`}, {
            0.4022625583763268, -1.0080753657776511`}, {
            0.4409147606853917, -1.0103603679569584`}, {
            0.48015330938558537`, -1.0115729540373493`}, {
            0.5202324004989609, -1.0116515584067383`}, {
            0.5611520340255186, -1.0105961810651256`}, {
            0.5630292558057806, -1.0104977640348833`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.5690210270068257, -1.010183633688806}, {
            0.6029122099652583, -1.008406822012511}, {
            0.6457697732518903, -1.0049866785790522`}, {
            0.6899815688191246, -1.000238948094906}, {
            0.7355475966669613, -0.9941636305600726}, {
            0.7824678567954007, -0.9867607259745519}, {
            0.8071821466228662, -0.9821946801630913}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8130822944123782, -0.9811046085774064}, {
            0.8368214370380871, -0.9767187243982332}, {
            0.8929591872585692, -0.9647137917356359}, {
            0.9504876146754584, -0.9506205787045566}, {
            1.0090132265073664`, -0.9343137360227922}, {
            1.045668812099385, -0.9226464178960343}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0513861784964509`, -0.9208266043117076}, {
            1.067562224562588, -0.9156778371473437}, {
            1.1251608106494186`, -0.8945974555352131}, {
            1.1744942655353157`, -0.8753362451049582}, {
            1.2215538349220842`, -0.8541530008569206}, {
            1.259892806382439, -0.8301422382225747}, {
            1.2693814637717278`, -0.8229862779341267}}]}, {
           Arrowheads[{{0.017871810852133636`, 1.}}], 
           
           ArrowBox[{{1.2741718826731299`, -0.8193735384266215}, {
            1.2940318433884364`, -0.804395962108048}, {
            1.325774752851653, -0.777805215966719}, {
            1.3527254072293091`, -0.749525529771786}, {
            1.375049954264846, -0.7196360195385142}, {
            1.3929145417017075`, -0.6882158012821699}, {
            1.4068069315197282`, -0.65536973947691}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.015190292999712014`, 1.}}], 
           
           ArrowBox[{{0.013823115102344876`, 0.4635058809487205}, {
            0.013310444957492087`, 0.4624492932724729}, {
            0.010001688019841143`, 0.4397932099057668}, {
            0.017845869281084187`, 0.4126631963516861}, {
            0.018744110157493707`, 0.4107700482602931}, {
            0.019688042121585616`, 0.40888294519421703`}, {
            0.02808565531183254, 0.3971147467059466}, {0.03767067165808521, 
            0.38674575325110316`}, {0.0583137152515523, 
            0.36945093194680334`}, {0.08023637068460406, 
            0.3598721505307402}, {0.10027194480670604`, 0.3587776410537689}, {
            0.12261629223420971`, 0.3725893732032201}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.5, 1.2521043105247793`}, {1.4980465521849604`, 
            1.2533580827671333`}, {1.4573966829438039`, 
            1.2838263381374133`}, {1.4234324898742332`, 1.311339639160273}, {
            1.3928111348904557`, 1.3373754630094226`}, {1.3663771930473647`, 
            1.3602390969196259`}, {1.347872021422468, 1.3754119272568803`}, {
            1.3307600970166222`, 1.3887499596505908`}, {1.3126183401979514`, 
            1.4018859804642678`}}]}, {
           Arrowheads[{{0.013173559964671679`, 1.}}], 
           
           ArrowBox[{{1.3077585457848413`, 1.405404843670234}, {
            1.29877861437781, 1.4119070014847825`}, {1.2706732784877433`, 
            1.428716300814758}, {1.2454428232808714`, 1.440520528164035}, {
            1.2004741240981014`, 1.4538211261892482`}, {1.1612139117572573`, 
            1.4581461838959178`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.779495000374682, -1.5}, {
            0.8039566319024228, -1.4737646729030078`}, {
            0.8453875465863334, -1.435032100860241}, {
            0.8870812604305527, -1.402767712203624}, {
            0.939702772501922, -1.367919615748177}, {
            0.967772719732795, -1.353450352774664}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.9731058717532598, -1.3507012639207685`}, {
            0.9791826483321852, -1.3475688576633371`}, {
            1.0187725530462124`, -1.328559304652182}, {
            1.0577787035371713`, -1.310224035205262}, {
            1.096432360840673, -1.2927853564923943`}, {
            1.1295623244806807`, -1.277482676829843}, {
            1.161748701551005, -1.2625318998917898`}, {
            1.190520197669025, -1.2490877917941432`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.195952690424058, -1.2465406422716834`}, {
            1.2232906959826044`, -1.2336860541891776`}, {
            1.2794104392243475`, -1.2057380200050023`}, {
            1.3284600263651116`, -1.1781779979597087`}, {
            1.3698198762936047`, -1.1507935166086192`}, {
            1.4015511944940875`, -1.124466631362044}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3384797699165798`, 1.5}, {-1.342642925313217, 
            1.485750991347845}, {-1.3552381748510594`, 
            1.4441285756266034`}, {-1.3668187113981791`, 
            1.4067224982393405`}, {-1.3765871667768421`, 
            1.3744632795757294`}, {-1.3829413722882737`, 
            1.3510605342460476`}, {-1.3884011801702218`, 
            1.329407436964026}, {-1.3976906999891898`, 
            1.2888401902297038`}, {-1.4013071714336633`, 
            1.2685527237921854`}}]}, {
           Arrowheads[{{0.012958668780858542`, 1.}}], 
           
           ArrowBox[{{-1.4023601403016495`, 
            1.2626458416566546`}, {-1.4040957679355401`, 
            1.2529094209738931`}, {-1.4082860749604547`, 
            1.2202327914195341`}, {-1.4114011364160124`, 
            1.1803505405767956`}, {-1.4122465209390813`, 
            1.1431254510876874`}, {-1.4114817094392373`, 
            1.1077022036567443`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.5, -0.23320093635394684`}, {-1.4542681044556498`, \
-0.2635829724166063}, {-1.4144997509056092`, -0.29566473872311827`}, \
{-1.3774205103883594`, -0.32938787082711857`}, {-1.3467673680191068`, \
-0.3622062283080765}, {-1.3238287573873673`, -0.3937122116124906}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.320297193334532, -0.3985627842942181}, \
{-1.314131583254466, -0.40703119641222607`}, {-1.284889949983278, \
-0.45148260457629885`}, {-1.256616156298548, -0.49597528355841786`}, \
{-1.2302780417867358`, -0.5405505041766295}, {-1.2051405609603099`, \
-0.5855115644649482}, {-1.1954814222315846`, -0.6033837886206316}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.1926286681242915`, -0.6086622158488239}, \
{-1.1804686683317398`, -0.6311617624573886}, {-1.155809104732984, \
-0.6777291967612533}, {-1.1307086109959998`, -0.7254419659838449}, \
{-1.1086774662477568`, -0.766911417903014}, {-1.085591756380107, \
-0.8093068148248418}, {-1.079464856817961, -0.8203019468608698}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.0765442654548238`, -0.8255431438701004}, \
{-1.0614514813930502`, -0.8526281567493285}, {-1.0362566412865868`, \
-0.8968754436764739}, {-1.0095556649258486`, -0.9415023794536542}, \
{-0.9808969811759672, -0.9859626679282455}, {-0.9506617175917466, \
-1.029704920562109}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-0.9471152664166856, -1.0345442624833636`}, \
{-0.9177064915087758, -1.0743833029696608`}, {-0.8907976198704327, \
-1.107901735626248}, {-0.862313716921894, -1.1398800344134195`}, \
{-0.8322547826631593, -1.1703181993311753`}, {-0.8006208170942286, \
-1.1992162303795157`}, {-0.785798991414842, -1.2111820268030966`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7811304702305265, -1.2149509669660068`}, \
{-0.7673881417217422, -1.2260452753784161`}, {-0.73253307805234, \
-1.2502764821478523`}, {-0.6960556260860226, -1.271909850687825}, \
{-0.6579557858227892, -1.2909453809983336`}, {-0.6184281608254989, \
-1.3073888411886805`}, {-0.5776673546570104, -1.3212459993681684`}, \
{-0.5689515918343866, -1.3235852416120417`}}]}, {
           Arrowheads[{{0.0060455746028531725`, 1.}}], 
           
           ArrowBox[{{-0.5631566790834637, -1.325140550651812}, \
{-0.5356733673173236, -1.3325168555367972`}, {-0.49244619880643836`, \
-1.3412014096945668`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5344729750894809, -1.5}, {
            0.535370999646272, -1.4988869297014433`}, {
            0.5682961663935204, -1.4632596737770205`}, {
            0.6011056311071309, -1.4338595131237035`}, {
            0.646344187526227, -1.3994626197894287`}, {
            0.6807581031949483, -1.3805133570336638`}, {
            0.7155915657657345, -1.3631392232944457`}, {
            0.7255273334382875, -1.3585100306234854`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.7309660042315214, -1.355976089029284}, {
            0.7509849827926437, -1.3466490081343414`}, {
            0.7868915517576569, -1.3312731150324961`}, {
            0.8222269935388558, -1.315879276706967}, {
            0.858032355615858, -1.3010726836805724`}, {
            0.8943076379886634, -1.2868533359533134`}, {
            0.9310528406572722, -1.2732212335251891`}, {
            0.9530850390006463, -1.2653070184182134`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9587317813984004, -1.2632786446130664`}, {
            0.9680513544119494, -1.2599309484646892`}, {
            1.0050865700429603`, -1.2467370528403028`}, {
            1.0421584875503047`, -1.2336395466520298`}, {
            1.0792671069339828`, -1.2206384298998705`}, {
            1.1158815748198632`, -1.2076256599015507`}, {
            1.1514710378338142`, -1.1944931939747965`}, {
            1.1844793119252366`, -1.1818376797751353`}}]}, {
           Arrowheads[{{0.009104628674621336, 1.}}], 
           
           ArrowBox[{{1.1900607325930246`, -1.1796362089533796`}, {
            1.2195749492459296`, -1.1678691743359848`}, {
            1.256254271021559, -1.1524683799671966`}, {
            1.2905669483895696`, -1.1368483580857798`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.4264736238456911, -0.4957078902889265}, \
{-0.3879910594759242, -0.5098088301498038}, {-0.34860871336366606`, \
-0.5228253504204573}, {-0.3087579754648996, -0.5346798991363215}, \
{-0.2684388457796248, -0.5453724762973965}, {-0.22765132430784168`, \
-0.5549030819036823}, {-0.19590297426321734`, -0.5611752055150316}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.1900167415815961, -0.5623380747328777}, \
{-0.1717450945079048, -0.5659477750438564}, {-0.11656938525018387`, \
-0.5745285945967015}, {-0.062124196534678926`, -0.5806455405622177}, \
{-0.008409528361389692, -0.5842986129404052}, {
            0.04218278879510662, -0.5854010200229597}, {
            0.04848581207279511, -0.5852264316800909}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.05448351166887361, -0.5850603005415291}, {
            0.09157436456780862, -0.5840329157044567}, {
            0.14279193279836977`, -0.579783618797445}, {
            0.19271391158694667`, -0.5726012507612276}, {
            0.24147837277857123`, -0.5624201009532518}, {
            0.2892233882182756, -0.549174458730965}, {
            0.29083087909327543`, -0.5486178215469943}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.29650057958929715`, -0.546654534434672}, {
            0.3331406611253248, -0.5339669154105988}, {
            0.37663403086960034`, -0.5159565524885097}, {
            0.4197034974511021, -0.49514336996469743`}, {
            0.46234906086983013`, -0.47152736783916227`}, {
            0.5049292186958774, -0.4451773052495899}, {
            0.5111353953120984, -0.44097714608573724`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.5161044033509545, -0.43761426649975993`}, {
            0.5478024684993371, -0.41616194133366624`}, {
            0.5909688102802089, -0.3844812760913912}, {
            0.634428244038493, -0.3501353095227648}, {
            0.6604734439964877, -0.3285450631139188}, {
            0.686788906271294, -0.30617380361534124`}, {
            0.7052031510331602, -0.29013769322965777`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.7097278965021437, -0.2861973025839332}, {
            0.7133746308629123, -0.28302153102703215`}, {
            0.7402306177713421, -0.25908824534899144`}, {
            0.7673638434222855, -0.2344548524563257}, {
            0.7947812842414435, -0.2092022582241414}, {
            0.8224829402288163, -0.1833304626524385}, {
            0.8504688113844039, -0.15683946574121702`}, {
            0.8786168628277982, -0.12980373627251465`}, {
            0.8856315820244437, -0.12295878553466401`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8899258690879873, -0.11876842771988477`}, {
            0.9068050596785907, -0.10229774302836905`}, {
            0.935033401936782, -0.0743214860087803}, {
            0.9633018896023716, -0.045874965213748335`}, {
            0.9874777758886307, -0.021363135530361108`}, {1.0114540325397432`,
             0.0034493461348475926`}, {1.0484194676342093`, 
            0.04472332147855078}, {1.056272118223302, 
            0.05409916143745045}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.0601246351603169`, 0.05869895635135827}, {
            1.08350062938677, 0.08660922413429194}, {1.1072940336747055`, 
            0.11601480460088238`}, {1.1296665128746475`, 
            0.14571771524152105`}, {1.1506180669865969`, 
            0.17571795605620802`}, {1.170148696010553, 0.2060155270449433}, {
            1.1880559923698613`, 0.23663551222149928`}, {1.1974902416768332`, 
            0.2548025948380789}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.200255442887694, 0.2601274105403783}, {
            1.204137548487867, 0.2676029955996484}, {1.2183933643645697`, 
            0.29891797717939067`}, {1.23082343999997, 0.33058045696072613`}, {
            1.241495586896465, 0.36268245648891256`}, {1.2504776165564513`, 
            0.3953159973092079}, {1.2577695289799296`, 0.4284810794216121}, {
            1.2633713241668991`, 0.46217770282612514`}, {1.2663874815577334`, 
            0.4893723901531191}}]}, {
           Arrowheads[{{0.006712480287059476, 1.}}], 
           
           ArrowBox[{{1.267048884848494, 0.4953358242046511}, {
            1.269522981350511, 0.5176431086300645}, {1.2727979618338385`, 
            0.5756564398191182}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7063808538244103, 
            0.8355245592596028}, {-0.7536942642553222, 
            0.8021104549898415}, {-0.8030180760320691, 
            0.760736086232847}, {-0.8283737246941394, 
            0.7365669555014396}, {-0.8541597844154787, 
            0.7098115420439861}, {-0.8800518215562037, 
            0.6805828013659275}, {-0.8841275550333307, 
            0.6755679651693782}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8879117701623255, 
            0.670911816991164}, {-0.9057254024764302, 
            0.6489936889727049}, {-0.9274930337007218, 
            0.6197668729502359}, {-0.9487545429320658, 
            0.5887149301292958}, {-0.969509930170462, 
            0.5558378605098843}, {-0.9897591954159105, 
            0.5211356640920016}, {-1.009168720190749, 
            0.48487861358269835`}, {-1.0168134824254296`, 
            0.46914082898156645`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0194350991604306`, 
            0.4637438737571123}, {-1.0274048860173157`, 
            0.44733698168902497`}, {-1.04446769289561, 
            0.40851076841098166`}, {-1.0603571408256325`, 
            0.36839997374856814`}, {-1.0748490720990997`, 
            0.3274580965597532}, {-1.0877193290077285`, 
            0.28613863570250553`}, {-1.0989679115515185`, 
            0.24444159117682504`}, {-1.1003753536058853`, 
            0.2382903326375866}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1017136036995403`, 
            0.2324414791869663}, {-1.1085948197304702`, 
            0.20236696298271167`}, {-1.1192804172506752`, 
            0.1442899814523662}, {-1.1269218284773128`, 
            0.08710409206512439}, {-1.1315190534103836`, 
            0.030809294820986283`}, {-1.1325255458274697`, \
-0.005096707543836638}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1326936676715689`, -0.01109435166845229}, \
{-1.133072092049887, -0.02459441028004811}, {-1.133088332396487, \
-0.05343672212287785}, {-1.1323619499365305`, -0.0819154006722344}, \
{-1.1279877987947131`, -0.1291775209546952}, {-1.1218147085349446`, \
-0.17542497649720545`}, {-1.1146827100387446`, -0.22188753250697135`}, \
{-1.109334137326999, -0.24940851470580572`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.1081894822162004`, -0.2552983164577599}, \
{-1.1057723063711937`, -0.267735850167602}, {-1.0950834975322923`, \
-0.31296992947909746`}, {-1.0826162835220396`, -0.3575897704414576}, \
{-1.0682414829293163`, -0.4020131275906138}, {-1.0518299143430017`, \
-0.4466577554624973}, {-1.0365176284493445`, -0.4838968562985486}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.0342358643587106`, -0.48944605017105786`}, \
{-1.0333815777630961`, -0.491523654057108}, {-1.0128964731895993`, \
-0.536610823374446}, {-0.9898589337720212, -0.5823368729459207}, \
{-0.9637532926598712, -0.6291194123029419}, {-0.9345795498531493, \
-0.6769584414455093}, {-0.9194832453579722, -0.6998523438759017}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9161802759453657, -0.7048613750256736}, \
{-0.9023377053518555, -0.725853960373623}, {-0.8662099859015995, \
-0.7757057508888765}, {-0.8253786182479905, -0.8264135947928629}, \
{-0.8031990663449287, -0.852088536765631}, {-0.7798436023910287, \
-0.8779774920855824}, {-0.7665655536211159, -0.8921061936690066}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7624565750809563, -0.8964784122541768}, \
{-0.7553122263862904, -0.9040804607527171}, {-0.7296049383307139, \
-0.9303974427670348}, {-0.690813990515847, -0.9675952595548543}, \
{-0.6493526416915236, -1.0039104398120007`}, {-0.6052208918577435, \
-1.0393429835384738`}, {-0.5832393929594015, -1.0555699887781709`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5784122176895762, -1.0591334672633574`}, \
{-0.5584187410145066, -1.073892890734274}, {-0.5093969407907208, \
-1.1067093768386196`}, {-0.4586062428152937, -1.1369416572907292`}, \
{-0.40604664708822524`, -1.164589732090603}, {-0.37184896119335986`, \
-1.1803664685605146`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.36640079210536797`, -1.1828799230734608`}, \
{-0.35171815360951597`, -1.1896536012382404`}, {-0.30674130585499726`, \
-1.2078610331674957`}, {-0.26149319597693504`, -1.2238708269100715`}, \
{-0.21597382397532938`, -1.2376829824659683`}, {-0.17018318985018055`, \
-1.2492974998351862`}, {-0.1383729252165265, -1.2559644096069844`}}]}, {
           Arrowheads[{{0.0006876429688738445, 1.}}], 
           
           ArrowBox[{{-0.132267487316828, -1.258838981315296}, \
{-0.1246572923551649, -1.258838981315296}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, -0.020153319442996274`}, {-1.4966374575492656`, \
-0.022357256074857983`}, {-1.4632806647084757`, -0.04694929109326862}, \
{-1.4357056703958957`, -0.0707938479182172}, {-1.4030865915635076`, \
-0.10315952363622644`}, {-1.3758871835258188`, -0.13869286683354454`}, \
{-1.3521083179179583`, -0.17323958804960937`}, {-1.3380676217064615`, \
-0.1944581865609232}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.334756588136587, -0.1994618908586575}, \
{-1.32951994080983, -0.2073756235894337}, {-1.3093125407011663`, \
-0.24069028777677706`}, {-1.2909149360847767`, -0.27331946143062785`}, \
{-1.2737559454534708`, -0.30539902536997454`}, {-1.257544030828237, \
-0.33703995298905565`}, {-1.241987654230064, -0.36835321768210977`}, \
{-1.2268539948759085`, -0.3994596647671185}, {-1.221386240618148, \
-0.4108094211518136}}]}, {
           Arrowheads[{{0.015770934901140902`, 1.}}], 
           
           ArrowBox[{{-1.2187821651400248`, -0.4162148620130421}, \
{-1.2118844953524759`, -0.43053278268397155`}, {-1.1970791556597675`, \
-0.46157257143266905`}, {-1.182437975797782, -0.4925790310132108}, \
{-1.1677271684079888`, -0.523738024539488}, {-1.1527129461318568`, \
-0.555235415125392}, {-1.1373953089693858`, -0.5870712027709226}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.44875824519260976`, 
            0.7626629198444593}, {-0.48180905526533196`, 
            0.7309281766801876}, {-0.5125309011423449, 
            0.6886363913170149}, {-0.5368291218660507, 
            0.640841495957913}, {-0.5569160749384542, 
            0.5834668452574584}, {-0.5635427373913258, 
            0.5567755486349601}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5649662895181249, 
            0.5509475348351657}, {-0.5712497025623454, 
            0.5169216518963432}, {-0.5757907309298331, 
            0.480679967104944}, {-0.5783423655819634, 
            0.4429830742520161}, {-0.5786527292292866, 
            0.4042059853813568}, {-0.5765281243624814, 
            0.36473821330914596`}, {-0.5718766680874517, 
            0.32499464720323346`}, {-0.5695705525287914, 
            0.31243204850258344`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5684872344094748, 
            0.3065306569842752}, {-0.5646064775101014, 
            0.28539017623146873`}, {-0.5543816300440311, 
            0.24646817830723522`}, {-0.541061434856684, 
            0.20866924034748924`}, {-0.5248468566847282, 
            0.17225406502544224`}, {-0.5059388602648318, 
            0.13748335501430578`}, {-0.4880282129161192, 
            0.10978737983665429`}, {-0.47247903522182544`, 
            0.08924648447893885}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4688576808004878, 
            0.08446257476458821}, {-0.4682740224223064, 
            0.08369154584546555}, {-0.4466762887833939, 
            0.059195853040739765`}, {-0.423235011999381, 
            0.03630030142247649}, {-0.3982557046625148, 
            0.015104491069555224`}, {-0.372043879365042, \
-0.0042919779391446256`}, {-0.34459953610696226`, -0.021889105603623407`}, \
{-0.3159226748882756, -0.037686891923880944`}, {-0.2766918991389217, \
-0.05504239167547449}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.2712048643851568, -0.0574698285152245}, \
{-0.25656091103286305`, -0.06394824052501677}, {-0.1956481002625858, \
-0.08313982373583655}, {-0.15339969993027452`, -0.09246592819429678}, \
{-0.11196919373429873`, -0.09879109364785063}, {-0.07135658167465893, \
-0.10211532009649806`}, {-0.03715976895468929, -0.10239313083986447`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.03116069132997606, -0.10241426832054067`}, {
            0.007021816831564699, -0.1000977270897481}, {
            0.04400131687005089, -0.09542944985569946}, {
            0.0793766363641039, -0.08843377583809309}, {
            0.11314777531372334`, -0.07911070503692913}, {
            0.14531443754268158`, -0.06782291889128711}, {
            0.17587632687475105`, -0.05493309884024659}, {
            0.19882970165831343`, -0.042465460270831826`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.20410212526072574`, -0.03960162554153516}, {
            0.2321857868482226, -0.02434735702197037}, {
            0.2634574954621296, -0.0030894559076768534`}, {0.2926645323693797,
             0.019571280318039244`}, {0.3198068975699731, 
            0.043634851655178025`}, {0.34488459106390995`, 
            0.06910125810373963}, {0.37259462122281095`, 0.101281134480979}, {
            0.38387475649086034`, 0.11629604135798337`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3874786311199401, 0.1210931329412112}, {
            0.397599223081717, 0.13456458006797217`}, {0.41989839664062817`, 
            0.16895159486471922`}, {0.43949214189954433`, 
            0.20444217887122018`}, {0.46459336267340057`, 
            0.2622837526027909}, {0.4821085526700691, 0.32256731734121064`}, {
            0.48431802156250264`, 0.3382082561028299}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.48515726090716615`, 0.34414927262547723`}, {
            0.49103160574422683`, 0.38573404812322126`}, {
            0.49190128867946004`, 0.4185925472534005}, {0.49007283440468025`, 
            0.4524840782075509}, {0.4862609255960793, 0.48148005944635575`}, {
            0.48014736271476544`, 0.5114575084037987}, {0.47173214576073874`, 
            0.5424164250798799}, {0.46101527473399917`, 0.5743568094745993}, {
            0.45894052461446067`, 0.5795356565042331}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.45670920359108574`, 0.5851053249405627}, {
            0.4477321183517398, 0.6075133011053727}, {0.43161804533115355`, 
            0.6421205394896154}, {0.41267305567224055`, 0.6781785246273279}, {
            0.3908971493750007, 0.7156872565185096}, {0.3650727804722286, 
            0.7564757015774699}, {0.3395234739137319, 0.7938905143386392}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.33613990930908966`, 0.7988454604096084}, {
            0.3359793642173871, 0.7990805652071504}, {0.30369331018983425`, 
            0.8433280514558326}, {0.26829102796892795`, 0.8890443643717978}, {
            0.22999566081173, 0.9355852938123792}, {0.1890303519753022, 
            0.9823066296349102}, {0.18587159196463468`, 
            0.9858022665102714}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.18184888522103598`, 0.9902539887000543}, {
            0.17137738337140931`, 1.0018422600097927`}, {0.1533198896210541, 
            1.021185551035423}, {0.10718207513838668`, 1.0642016652757942`}, {
            0.05987234022536127, 1.1029877675338688`}, {0.012955768134153292`,
             1.13838617197609}, {0.0003366208490598252, 
            1.1462905646969967`}}]}, {
           Arrowheads[{{0.019710794300019988`, 1.}}], 
           
           ArrowBox[{{-0.004748210694997435, 
            1.1494756060104745`}, {-0.034581004510847724`, 
            1.1681622979837805`}, {-0.08240043731109997, 
            1.1920631312765324`}, {-0.13016498986806171`, 
            1.209835657573937}, {-0.17774116192261408`, 
            1.2220229691194446`}, {-0.22499545321563813`, 
            1.229168158156505}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.5, 1.0096393731201305`}, {1.4845009095226973`, 
            1.0233620477105159`}, {1.449365735000493, 1.0588947525798424`}, {
            1.4202349087116195`, 1.0938871464388509`}, {1.384127489708439, 
            1.1437216193125088`}, {1.3560682330046843`, 
            1.1915746778627776`}, {1.3527143889160047`, 
            1.1974718489113243`}}]}, {
           Arrowheads[{{0.01659560672596972, 1.}}], 
           
           ArrowBox[{{1.3497482075011025`, 1.2026873803141527`}, {
            1.3309726048823518`, 1.235701121339279}, {1.3069045670577535`, 
            1.2773671462980065`}, {1.2848917098286239`, 1.314112334221186}, {
            1.264509386004598, 1.3457490902670972`}, {1.245332948395312, 
            1.372089819594021}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6493768941287084, 0.41400890409198365`}, {
            0.6591593867569084, 0.46019236771227423`}, {0.6659871777141885, 
            0.5090938645527692}, {0.6693141011972386, 0.5664448389451757}, {
            0.6675884789907284, 0.6285312374755135}, {0.6654100122932207, 
            0.6522898011805877}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6648621593714151, 0.6582647369271936}, {
            0.664559994702382, 0.6615601733673558}, {0.6597264368886326, 
            0.696192870443579}, {0.6530878055494808, 0.7324293287041834}, {
            0.6446441006849262, 0.7702695481491686}, {0.6327633969895321, 
            0.8145096180988469}, {0.6180106577101873, 0.8608625771034852}, {
            0.6070169236511198, 0.890552932351447}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.6049334864493031, 0.8961795911669507}, {
            0.6001849727597272, 0.9090037196737737}, {0.5790854320509872, 
            0.9586083403204017}, {0.5546120194451993, 1.0088076012647487`}, {
            0.5266647188035959, 1.0587326647281938`}, {0.5088965302971649, 
            1.0885343980280249`}, {0.49541214406840384`, 
            1.1091817579361187`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.49213134310638, 1.1142053368443856`}, {
            0.48989348048027326`, 1.117631963335367}, {0.4595354516376262, 
            1.1539622291391456`}, {0.427242782780847, 1.1868265556531228`}, {
            0.3941707615976445, 1.2175583537336976`}, {0.35954003576159577`, 
            1.2440250949474676`}, {0.3236769714452164, 1.266164594411341}, {
            0.31322248415188075`, 1.271211447086947}}]}, {
           Arrowheads[{{0.008496060503542754, 1.}}], 
           
           ArrowBox[{{0.30781914576396213`, 1.273819882300949}, {
            0.2869079348210223, 1.2839146672422264`}, {0.2495525820078091, 
            1.2976312125029794`}, {0.21193056912437253`, 
            1.3076701292564559`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.3763301967882926`, -1.5}, {
            1.3868936435133958`, -1.479301431659909}, {
            1.4049096033418647`, -1.4450837049199963`}, {
            1.4207385461295083`, -1.4151252728760728`}, {
            1.431780391440064, -1.3929972665805554`}, {
            1.4415560627225226`, -1.3724517909460032`}, {
            1.45872129054272, -1.3339006009082115`}, {
            1.4715703236036886`, -1.2997163871152453`}, {
            1.4767915273616712`, -1.282483934723454}}]}, {
           Arrowheads[{{0.006882116107992417, 1.}}], 
           
           ArrowBox[{{1.4785313423736464`, -1.2767417187989083`}, {
            1.480962082350897, -1.2687191223103584`}, {
            1.48953514415676, -1.2307717703985097`}, {
            1.4943256013303756`, -1.1957994133824157`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.5, 0.8004675190663401}, {1.4872274707718425`, 
            0.8115453102031743}, {1.4522319368770327`, 0.8467258694769534}, {
            1.4238628097928117`, 0.8820980216397839}, {1.3951312062874524`, 
            0.9328779765521028}, {1.3701324650524633`, 0.9840687772556409}, {
            1.3647218258541844`, 0.9956844717076626}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.3621883657116112`, 1.001123366789018}, {
            1.34638097396483, 1.03505906752331}, {1.3251239831719086`, 
            1.0856483369192413`}, {1.30569531180163, 1.1350606706663955`}, {
            1.2874287789819256`, 1.182520153987734}, {1.2715552142961444`, 
            1.2232796555205}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.14124974124168843`, 0.4984254268667703}, {
            0.10081701313255512`, 0.5319656722808478}, {0.05642037773507419, 
            0.5593862864203641}, {0.011319770118619229`, 
            0.5787683079884278}, {-0.010600846288473654`, 
            0.5848691761550393}, {-0.03152943457355817, 
            0.5881602695108276}, {-0.06077188389469293, 
            0.587072572462926}, {-0.07293889016940477, 
            0.5825122911800693}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.07855722132096057, 
            0.5804065003377828}, {-0.08538352180928847, 
            0.5778479539176352}, {-0.11221614510445532`, 
            0.5428700344799412}, {-0.11346539773935244`, 
            0.5393714875519076}, {-0.11458747069735058`, 
            0.5357420358152981}, {-0.11624657515431534`, 
            0.5174131021403587}, {-0.11522841227143486`, 
            0.49727779654214943`}, {-0.10785456894870514`, 
            0.45456528262373924`}, {-0.09005352004810824, 
            0.4090992400422999}, {-0.06354792405446026, 
            0.36626036082842095`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.05980439982528157, 
            0.3615845624958017}, {-0.040126115357160076`, 
            0.3383795051305284}, {-0.014892891221609608`, 
            0.31539491820253096`}, {0.038953501948185254`, 
            0.28335658963731025`}, {0.09143732116364209, 
            0.27121858929072545`}, {0.14746621829010892`, 
            0.2817213757985828}, {0.14890966154702567`, 
            0.28297450309493566`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.15344046502754546`, 0.28690792651746594`}, {
            0.1846777957657932, 0.31402665919069417`}, {0.19962703175894195`, 
            0.3597730358809179}, {0.1909519434086748, 0.4116055683226428}, {
            0.1615542727848969, 0.46217066577141325`}, {0.13363458651142868`, 
            0.4900602498739562}}]}, {
           Arrowheads[{{0.001546583614558306, 1.}}], 
           
           ArrowBox[{{0.12697802275455028`, 0.5050076833052989}, {
            0.11867101980988783`, 0.5050076833052989}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.32313378495326023`, -1.5}, {
            0.34147907259288224`, -1.4797058172206803`}, {
            0.37155732503504835`, -1.4520157136735499`}, {
            0.41287501132604876`, -1.419642040119646}, {
            0.44238135597150463`, -1.4027316742246543`}, {
            0.47187143449745883`, -1.3873655933520233`}, {
            0.5015274605826748, -1.3729605192566998`}, {
            0.518920044270944, -1.3652173766007243`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5244013796078213, -1.3627770973288582`}, {
            0.5312886963342317, -1.3597108780203693`}, {
            0.5617111258576675, -1.3459859545787256`}, {
            0.5924254370697946, -1.3329944983204174`}, {
            0.6234316299706133, -1.3207365092454455`}, {
            0.6547297045601235, -1.309211987353809}, {
            0.6864255218506267, -1.2981662356066932`}, {
            0.7186249428544244, -1.287344556965282}, {
            0.7485990518870244, -1.277631272443141}}]}, {
           Arrowheads[{{0.002638154299599981, 1.}}], 
           
           ArrowBox[{{0.7560015568389673, -1.2668996966567212`}, {
            0.7828499329683618, -1.2668996966567212`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, 0.17535835801672126`}, {-1.4797009911027752`, 
            0.15922523643254244`}, {-1.4529290160112522`, 
            0.13386834054777888`}, {-1.4222341492366017`, 
            0.10002403719330386`}, {-1.3925219002458749`, 
            0.055097966015299905`}, {-1.3673543714530438`, 
            0.01166380810862478}, {-1.3541059156683912`, \
-0.012371328645622827`}}]}, {
           Arrowheads[{{0.010016124538564986`, 1.}}], 
           
           ArrowBox[{{-1.3512095149181873`, -0.01762593259779828}, \
{-1.3412099708297678`, -0.035766945675239845`}, {-1.3187236999759278`, \
-0.08150591186046591}, {-1.2988413096339433`, -0.125755928065711}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.783865066004282, 0.4481566502706902}, {
            0.8051998605582156, 0.5084599417695997}, {0.8185318872943566, 
            0.5556158401919321}, {0.8299365201070689, 0.605994808176195}, {
            0.8390088134478466, 0.6601196473510882}, {0.8412194153537547, 
            0.6804960702979513}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.8418665475545746, 0.6864610698716866}, {
            0.8453438217681841, 0.7185131593453115}, {0.8473592202321119, 
            0.7493975890917945}, {0.8484390498137777, 0.7815230299273548}, {
            0.8485833105131816, 0.8148894818519925}, {0.8477920023303235, 
            0.8494969448657079}, {0.844479626658415, 0.9045468768188001}, {
            0.8422101823073426, 0.9259603229236746}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8415778304881667, 0.9319269074723745}, {
            0.8383922754469847, 0.9619843579475217}, {0.8293062651791037, 
            1.020760465328738}, {0.8169979123378429, 1.0798262760393147`}, {
            0.8013368888945209, 1.137270072084386}, {0.791155562969827, 
            1.1659409503260143`}}]}, {
           Arrowheads[{{0.017984123634941195`, 1.}}], 
           
           ArrowBox[{{0.7891477397818654, 1.1715950325721338`}, {
            0.7821928668204564, 1.1911801354690872`}, {0.7683497718163181, 
            1.2257410744653372`}, {0.7529500261915336, 1.2574241850394283`}, {
            0.7402717849986172, 1.2757361751254739`}, {0.7268893802409411, 
            1.2923167454056959`}, {0.6987653601477333, 1.3218828766392046`}, {
            0.668030039291692, 1.3445381523655562`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.058219090505088916`, -0.4112699757291027}, \
{-0.02584519719356819, -0.40975709606779426`}, {
            0.03733257999963281, -0.4032428636526958}, {
            0.08443138702900033, -0.395089398565539}, {
            0.12982921259895047`, -0.3841997408817527}, {
            0.17352605670948326`, -0.3705738906013369}, {
            0.1770864404972297, -0.36918672652096535`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.1826771040175301, -0.36700854347016765`}, {
            0.21552191936059872`, -0.35421184772429154`}, {
            0.25601045796278077`, -0.33535579499658713`}, {
            0.2951853299265135, -0.31424791516419404`}, {
            0.33304653525179667`, -0.29088820822711237`}, {
            0.3695940739386303, -0.2652766741853422}, {
            0.3905162944898067, -0.24906017447291776`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.395258589579711, -0.24538449259328377`}, {
            0.40508727561233626`, -0.23776642529341413`}, {
            0.4397854698982364, -0.20871057380585878`}, {
            0.4736886567963307, -0.17810911972267635`}, {
            0.506796836306619, -0.14596206304386677`}, {
            0.5463560039499014, -0.10528911951029586`}, {
            0.5693746646104111, -0.08060627126638187}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.5734668004720078, -0.07621828492977661}, {
            0.5855411373867534, -0.0632710057588452}, {
            0.6243522366171752, -0.01990772178951462}, {0.6627893016411671, 
            0.024800732397695993`}, {0.6983277765087393, 
            0.06751726835209107}, {0.7296248861222396, 
            0.1059635127766293}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.7334127805764226, 0.1106166682225574}, {
            0.7339138052131896, 0.11123214089354018`}, {0.7545735001268609, 
            0.1369563419960292}, {0.7752915865639767, 0.16306460013368518`}, {
            0.7960287506096644, 0.18962043603373532`}, {0.816745678349051, 
            0.21668737042340697`}, {0.8375206381992445, 
            0.24423676120900334`}, {0.858337832711768, 
            0.27231369655356685`}, {0.879016849173372, 0.3010922925694339}, {
            0.8791356220729373, 0.30126528187204127`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8825317412432522, 0.30621163149383507`}, {
            0.8993772748708069, 0.3307466653689406}, {0.9184731852549827, 
            0.3602225579545436}, {0.9370515607021468, 0.39070380287684797`}, {
            0.9551124012122991, 0.4221904001358537}, {0.9726557067854396, 
            0.4546823497315607}, {0.989415802737045, 0.4884542330361882}, {
            1.0009950569506523`, 0.5144899937775249}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0034332600532831`, 0.5199722529496473}, {
            1.0051270143825917`, 0.5237806314219551}, {1.0197893417220798`, 
            0.5606615448888616}, {1.0334027847555094`, 0.5990969734369076}, {
            1.0457032612191348`, 0.6394310074484029}, {1.0564266888492102`, 
            0.6820077373056566}, {1.0655730676457358`, 0.726827163008669}, {
            1.0693128404011525`, 0.7500791074794605}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.070265617547431, 0.7560029757856882}, {
            1.0731423976087113`, 0.7738892845574402}, {1.0788359394737266`, 
            0.8217779417673563}, {1.0827656067883458`, 0.8719950167268653}, {
            1.084876127014402, 0.9242833171474393}, {1.0851122276137295`, 
            0.9783856507405505}, {1.084607454484232, 0.9952316651847259}}]}, {
          
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{1.084427751440052, 1.0012289734822801`}, {
            1.0834601543723834`, 1.0335210136594342`}, {1.0799061530764205`, 
            1.0889084020573256`}, {1.0762451381893838`, 1.134022042986849}, {
            1.0713293371387702`, 1.1781031044024188`}, {1.0626687995710422`, 
            1.2238226554923544`}, {1.0588701607607007`, 
            1.2394097810629103`}}]}, {
           Arrowheads[{{0.012395795032865043`, 1.}}], 
           
           ArrowBox[{{1.0574495176637047`, 1.2452391698122525`}, {
            1.0526647571413692`, 1.2648726929794571`}, {1.0420499436699906`, 
            1.3030083735616702`}, {1.0302135881152013`, 1.335315340334104}, {
            1.0033965878880047`, 1.3828173837920847`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.2811740296422659, 
            0.9772574802070793}, {-0.3186298913366256, 
            0.9935540335773917}, {-0.3575338656478726, 
            1.0074094145311463`}, {-0.39814443410815975`, 
            1.0183406717485357`}, {-0.4340451050964298, 
            1.0249960795416113`}, {-0.47154605396613897`, 
            1.0291143483084213`}, {-0.5109116795832866, 
            1.0305011465499407`}, {-0.513080237654703, 
            1.0304207165437917`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5190761150892068, 
            1.0301983344617613`}, {-0.552406380813872, 
            1.0289621427671445`}, {-0.604032020259, 
            1.0230808895974168`}, {-0.6595993097695235, 
            1.0124419087848915`}, {-0.6889929658849046, 
            1.005163166961665}, {-0.7196358196878264, 
            0.9963447861259085}, {-0.7515278711782895, 
            0.9859867662776233}, {-0.7537968438421276, 
            0.9851722084867003}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7594439685073932, 
            0.9831448991824869}, {-0.7846691203562932, 
            0.9740891074168084}, {-0.8277379715194735, 
            0.9567252044230441}, {-0.872712886533191, 
            0.9362335446254137}, {-0.9191706758122256, 
            0.9122386876270433}, {-0.9666881497713568, 
            0.8843651930310586}, {-0.9749414159593269, 
            0.8787894415036098}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.9799131676407865, 
            0.8754306195050657}, {-1.014282320479431, 
            0.852211465769722}, {-1.0609702000052945`, 
            0.8153759107752951}, {-1.0864476502366438`, 
            0.7937878869952977}, {-1.1111302124084426`, 
            0.7706553659244927}, {-1.139620737325321, 
            0.735631828861714}, {-1.1546430074773029`, 
            0.7135791135856178}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1580209294345702`, 
            0.7086203190495827}, {-1.1653684891968887`, 
            0.6978340902191061}, {-1.1895039528430753`, 
            0.6587278592134309}, {-1.2104148400384995`, 
            0.6170046434816212}, {-1.2280204255271276`, 
            0.5728821110799347}, {-1.2422399840529261`, 
            0.5265779300646297}, {-1.2507871919595936`, 
            0.4891609768723738}}]}, {
           Arrowheads[{{0.004603781193380076, 1.}}], 
           
           ArrowBox[{{-1.2521233624858048`, 
            0.4833116479942131}, {-1.2532358631471754`, 
            0.47844147452617547`}, {-1.2611704103411563`, 
            0.4288221185550415}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.5, 0.6211177934763256}, {1.4678333849204643`, 
            0.649881126678817}, {1.4411859883457863`, 0.6795547608522278}, {
            1.4147972659599397`, 0.7222453111076074}, {1.3922129980963749`, 
            0.7658126608718185}, {1.3709406979517467`, 0.8098596996018278}, {
            1.3675757705095397`, 0.8179806972807927}}]}, {
           Arrowheads[{{0.015141452680794878`, 1.}}], 
           
           ArrowBox[{{1.365279029038642, 0.8235237089726313}, {
            1.3522923332449925`, 0.8548661162634335}, {1.3355619458861894`, 
            0.900790508779227}, {1.3200435777854163`, 0.9475914750718004}, {
            1.3054065423482548`, 0.9949693864312119}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.1257485529832957, -1.5}, {
            0.13845350371941764`, -1.4871605290437953`}, {
            0.16992878623027252`, -1.460769963743737}, {
            0.20901993475897707`, -1.4328856027289314`}, {
            0.25982997750361586`, -1.4065189917788705`}, {
            0.3099083737259984, -1.383907501871512}, {
            0.3289205925339207, -1.3758364312431268`}}]}, {
           Arrowheads[{{0.008160576066662213, 1.}}], 
           
           ArrowBox[{{0.33444353153020384`, -1.3734918321636818`}, {
            0.36796491873038467`, -1.3592613266983562`}, {
            0.4256528262560104, -1.337916845800049}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, 0.3574810586000434}, {-1.4937127230661964`, 
            0.35236532334821435`}, {-1.4678834600477557`, 
            0.32684900917949194`}, {-1.4364936902389867`, 
            0.2900218735305615}, {-1.4108494575662396`, 
            0.24682145158680055`}, {-1.3890904487052576`, 
            0.20450926989741786`}, {-1.368688482997969, 
            0.1626836644474044}, {-1.3675587010767185`, 
            0.16007428647946412`}}]}, {
           Arrowheads[{{0.006544454941708304, 1.}}], 
           
           ArrowBox[{{-1.3651747416437847`, 
            0.1545682227836714}, {-1.3510006035980688`, 
            0.1218312114761296}, {-1.3353316061475138`, 
            0.0819384150551629}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.5, 0.6349471744177637}, {-1.4988591359966155`, 
            0.6340128694189087}, {-1.476358336546276, 
            0.6111818317894921}, {-1.446665733754519, 
            0.5744238465036111}, {-1.4373521701012135`, 
            0.5580118077707091}, {-1.4287680870021218`, 
            0.5415361637974263}, {-1.4128398459783487`, 
            0.5084747071294488}, {-1.3990674137212828`, 
            0.47520929240913573`}, {-1.3869023001605127`, 
            0.44178196726816943`}, {-1.3827491837261618`, 
            0.4289418558257751}}]}, {
           Arrowheads[{{0.0026132307026085623`, 1.}}], 
           
           ArrowBox[{{-1.3785805514384877`, 
            0.40057549884017374`}, {-1.3735741244668946`, 
            0.40057549884017374`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.2931650392349688, 
            0.709745169221083}, {-0.31771098487825533`, 
            0.6861195953922162}, {-0.34652919300075224`, 
            0.6305662914258824}, {-0.3549783971167772, 
            0.5938549044047154}, {-0.3584138830796887, 
            0.5513674559261958}, {-0.3561269910515872, 
            0.5041631886697051}, {-0.3534592073260186, 
            0.4885988975844848}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.352445564867198, 
            0.48268513998329116`}, {-0.34740906119457304`, 
            0.4533013453146255}, {-0.33198483976891846`, 
            0.4006817009952883}, {-0.3095790730348953, 
            0.3482040308460246}, {-0.2806872664489397, 
            0.2978343384058448}, {-0.25648058128084517`, 
            0.26570731728487884`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.2528699538857285, 
            0.260915306244237}, {-0.2458049254674875, 
            0.25153862721375897`}, {-0.20615094223048075`, 
            0.21051331004188517`}, {-0.16294420887786215`, 
            0.17595479966234173`}, {-0.10822544981419625`, 
            0.14322694439163292`}, {-0.059928136303202845`, 
            0.12364563215715622`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.054367753618986936`, 
            0.12139127096048168`}, {-0.05278232030858539, 
            0.12074848438663122`}, {0.001672417602705447, 
            0.10783202004269693`}, {0.05342600188341215, 
            0.10379015175519003`}, {0.11500449043044317`, 
            0.10971585780783483`}, {0.1692774149552019, 
            0.12646945035886994`}, {0.1795927536093674, 
            0.13209481739687645`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.18486038062264434`, 0.13496746524320136`}, {
            0.2159192695032094, 0.15190512047716537`}, {0.2546045481199866, 
            0.18387705923159106`}, {0.2905281968318204, 0.2291379599116519}, {
            0.3142748766559375, 0.2796058239574759}, {0.32228494487191983`, 
            0.3196888934004693}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.32346071780394464`, 0.32557256215493857`}, {
            0.3251429281817724, 0.3339904873927855}, {0.32243069199875957`, 
            0.39100178624130294`}, {0.3088817977451867, 0.4416586454910327}, {
            0.28449500690222146`, 0.4935284199117792}, {0.2494557158681801, 
            0.5464831388249818}, {0.24877889568717265`, 
            0.5473351649005463}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           ArrowBox[{{0.24504688855491036`, 0.5520332626820685}, {
            0.22810749269175734`, 0.5733576962387544}, {0.20439340370113937`, 
            0.6005122684488381}, {0.1649469459234559, 0.6416603700411914}, {
            0.12119377990775204`, 0.6835817158582403}, {0.09812101214176232, 
            0.7046769479693801}, {0.07734877294380771, 
            0.7232357171831727}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.07286107932407201, 0.7272181394782499}, {
            0.04957819377660784, 0.747566013480293}, {0.0241081431774431, 
            0.769359846880066}, {-0.002099031513618352, 
            0.791298854708681}, {-0.028981360110748144`, 
            0.8132953442987685}, {-0.05653884261394632, 
            0.8353493156503288}, {-0.08477147902321286, 
            0.8574607687633617}, {-0.09597844190764601, 
            0.8661454897766717}, {-0.10729637935669256`, 
            0.874805668946986}, {-0.11307938619442648`, 
            0.8788526890121527}}]}, {
           Arrowheads[{{0.008493939754460523, 1.}}], 
           
           ArrowBox[{{-0.11799521086277556`, 
            0.8822928442165078}, {-0.15427938623325638`, 
            0.9076849611364158}, {-0.20313083696064926`, 
            0.9382788487329112}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.07170592455365979, -1.5}, {-0.0580708729479998, \
-1.4888588579265614`}, {-0.02089151743152478, -1.4625488239345263`}, {
            0.015452113473533542`, -1.4410003914225953`}, {
            0.05891930872416937, -1.4213276150048058`}, {
            0.10151267787561008`, -1.4041279736619363`}, {
            0.13978563179066766`, -1.389573907302118}}]}, {
           Arrowheads[{{0.011703735068257837`, 1.}}], 
           
           ArrowBox[{{0.1453938298255623, -1.387441276344497}, {
            0.1619968704291404, -1.381127633680397}, {
            0.22104256292473784`, -1.3615557752385974`}, {
            0.27903205728585756`, -1.3443895722045578`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, -0.6381256004021509}, {-1.4884312769549646`, \
-0.6445794885407993}, {-1.4498552921895427`, -0.6687335344072585}, \
{-1.417196843409184, -0.6927310267411292}, {-1.3815724832461889`, \
-0.7272707050840744}, {-1.3498932433041089`, -0.7620907606984532}, \
{-1.3210421924872373`, -0.7953349176713929}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3172490566794823`, -0.7999815873922667}, \
{-1.2917752161570175`, -0.832424201695038}, {-1.2659711520660382`, \
-0.8681229437648113}, {-1.2414365342031228`, -0.9041923992097194}, \
{-1.2178021883215426`, -0.940544649524979}, {-1.1946989401745687`, \
-0.9770917762058072}, {-1.1816696103459452`, -0.9978203978268294}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.1784765967920017`, -1.002900227001549}, \
{-1.1726232753359787`, -1.0122123932667368`}, {-1.1504478720230589`, \
-1.0468906185986893`}, {-1.1281727302358089`, -1.0811264522016644`}, \
{-1.1057978499742285`, -1.114919894075662}, {-1.0830754341362698`, \
-1.1476795570765512`}, {-1.0597576856198847`, -1.1788140540602001`}, \
{-1.0423192978321938`, -1.200333453946619}}]}, {
           Arrowheads[{{0.012236189020807175`, 1.}}], 
           
           ArrowBox[{{-1.0385417637088894`, -1.2049950240627143`}, \
{-1.0358446044250729`, -1.2083233850266095`}, {-1.0113361905518345`, \
-1.2362075499757785`}, {-0.9860820969002876, -1.2620528163329003`}, \
{-0.9599319763705502, -1.2854454515231666`}, {-0.9328858289626223, \
-1.306385455546578}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.5, 0.4659338734838492}, {1.4740452263933639`, 
            0.4885355736328016}, {1.4486225895280547`, 0.5161499161852187}, {
            1.4237892820502698`, 0.5553946662182301}, {1.4028505267062166`, 
            0.5950708578840258}, {1.3832777159269944`, 0.6350976590848203}, {
            1.370977869426221, 0.6648435606474133}}]}, {
           Arrowheads[{{0.000490329262122424, 1.}}], 
           
           ArrowBox[{{1.3681566289172957`, 0.6745474826444859}, {
            1.3669653250167564`, 0.6745474826444859}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.188476432146091, 1.5}, {-1.2094249128322465`, 
            1.4607126843974443`}, {-1.2309699289796816`, 
            1.423376621977482}, {-1.2510172763348337`, 
            1.3913672120139786`}, {-1.2741375205818557`, 
            1.3570362093131338`}, {-1.2946781312782063`, 
            1.326294658386884}, {-1.3139066309635445`, 
            1.2967985098646255`}, {-1.3144451260717314`, 
            1.2959226966687785`}}]}, {
           Arrowheads[{{0.002056122462482816, 1.}}], 
           
           ArrowBox[{{-1.3204241335171008`, 
            1.2744063109972958`}, {-1.3276745093293647`, 
            1.2744063109972958`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.8717861399184024, 1.5}, {-0.8759699999178087, 
            1.4922703603850036`}, {-0.8970354162278429, 
            1.457457528973495}, {-0.9179417152726934, 
            1.4279634996961004`}, {-0.949614516228287, 
            1.3942199094744494`}, {-0.9811440409911165, 
            1.36463165943938}, {-1.0125043054308183`, 
            1.3364669396299722`}, {-1.0300902687985867`, 
            1.322114573335111}}]}, {
           Arrowheads[{{0.013010679783420813`, 1.}}], 
           
           ArrowBox[{{-1.0347386920418058`, 
            1.318320873116077}, {-1.0435260492242653`, 
            1.311149280271889}, {-1.0740469747273083`, 
            1.2880023014884103`}, {-1.1039047842957979`, 
            1.2663496234028178`}, {-1.1328763569212952`, 
            1.2458539549497079`}, {-1.1607385715953595`, 
            1.2261780050636772`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.013125799435159255`, 1.}}], 
           ArrowBox[{{1.5, 1.4414804993522718`}, {1.489448283390374, 
            1.4436930749546701`}, {1.4570982495128288`, 
            1.4504390137036873`}, {1.4293289256356878`, 
            1.4558877440097593`}, {1.4054736472559823`, 1.459806463097352}, {
            1.3839986561676378`, 1.4629338641338965`}, {1.3447950935378736`, 
            1.4678220120335799`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.012976768783036267`, 1.}}], 
           
           ArrowBox[{{0.09906610939362587, 1.5}, {0.08773492875454608, 
            1.483334108419489}, {0.06812557147849725, 1.459633710692922}, {
            0.057372138684016825`, 1.4494280961425485`}, {0.04677046039908369,
             1.4400694725667986`}, {0.02585662236906592, 1.422806263165976}, {
            0.00549242321036939, 
            1.4081001112488964`}, {-0.014374601119203358`, 
            1.3953565785537143`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.01465689056562825, 1.}}], 
           
           ArrowBox[{{1.5, 0.32811911627001}, {1.4903064698500328`, 
            0.3361728996610317}, {1.4657910013768511`, 
            0.36139847386548235`}, {1.455479027970718, 
            0.37522157120684374`}, {1.4459917901636494`, 
            0.38898602723779835`}, {1.428428345906122, 
            0.41643098079699037`}, {1.413338582030245, 0.4437605667450232}, {
            1.4001308839796847`, 0.47107347545424305`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8798102077044306, -0.43857092101419837`}, \
{-0.858699925829089, -0.47130346835323195`}, {-0.8351866545713567, \
-0.5039077109227286}, {-0.809106236624489, -0.5364258870094984}, \
{-0.7802945146817423, -0.5689002349003516}, {-0.7486004644167159, \
-0.6013452581491785}, {-0.7263836210041796, -0.6220924682135569}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.721998420782346, -0.6261875895810417}, \
{-0.7138730615030088, -0.6337754603098704}, {-0.676036510785885, \
-0.6661813963120777}, {-0.6350000873940157, -0.6985332981713979}, \
{-0.6020142090450399, -0.7227886079503185}, {-0.5673313656532899, \
-0.7469005873123666}, {-0.5309515572187661, -0.7708692362575421}, \
{-0.5309011045147064, -0.7709008054172966}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.525814756474338, -0.7740834244036411}, \
{-0.4928747837414684, -0.7946945547858449}, {-0.45336871644173454`, \
-0.8182527099081429}, {-0.41270102653990204`, -0.8414198686353037}, \
{-0.3708717140359711, -0.8641960309673276}, {-0.32788077892994166`, \
-0.8865811969042142}, {-0.3169145528008438, -0.89202843101783}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3115409756460039, -0.8946976384958997}, \
{-0.27795827587238764`, -0.9113791135704254}, {-0.22756143056969824`, \
-0.9351666291136067}, {-0.17669024302187372`, -0.9579437435337574}, \
{-0.12534471322891416`, -0.9797104568308779}, {-0.09258939883296699, \
-0.9927825494511644}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.08701677853250485, -0.9950064880714679}, \
{-0.0774856676056407, -0.9988101934276163}, {-0.029804925333131442`, \
-1.0165825390009255`}, {0.017697513588613455`, -1.0330274935508048`}, {
            0.06502164915959381, -1.0481450570772546`}, {
            0.11218537222279998`, -1.0618059475038262`}, {
            0.1410505792772011, -1.0692184655978132`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.14686202040401827`, -1.070710830174429}, {
            0.159206573621222, -1.0738808827540711`}, {
            0.20608525335486003`, -1.0843698628279899`}, {
            0.2528214114237138, -1.0932728877255815`}, {
            0.29968704382271166`, -1.1005715159308314`}, {
            0.3469541465467818, -1.1062473059277234`}, {
            0.3834258764346377, -1.109348262248097}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.38940430629508893`, -1.1098565696390181`}, {
            0.3946227195959243, -1.110300257716258}, {
            0.44269276297013915`, -1.112730371296435}, {
            0.47689851975583913`, -1.1134645003212484`}, {
            0.5118449727032347, -1.1133976391745528`}, {
            0.5475321218123259, -1.1125297878563478`}, {
            0.5839599670831126, -1.1108609463666337`}, {
            0.6211285085155948, -1.1083911147054104`}, {
            0.6291556017043416, -1.1076985343919736`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6351333927351479, -1.1071827685613762`}, {
            0.6590377461097727, -1.1051202928726782`}, {
            0.6976876798656462, -1.1010484808684367`}, {
            0.7370783097832151, -1.096175678692686}, {
            0.7820628137049684, -1.0902096116268758`}, {
            0.8283835039090865, -1.0831661150797611`}, {
            0.8701324199250334, -1.0749426067982517`}, {
            0.8727431421798771, -1.07438571047751}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.8786111256874568, -1.073134003820672}, {
            0.9127603890772786, -1.0658495831579446`}, {
            0.9557229053939469, -1.0557919811356185`}, {
            0.9992014708656637, -1.0448014884056807`}, {
            1.0421759146844916`, -1.0337598412084632`}, {
            1.0845050042206634`, -1.0217202883142962`}, {
            1.1109745024464006`, -1.0134414000393648`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.1167009405225312`, -1.0116503369583314`}, {
            1.1261887394741799`, -1.0086828297231796`}, {
            1.1672271204450397`, -0.994647465435113}, {
            1.2066186068044107`, -0.9795994760991893}, {
            1.2433616582234592`, -0.9635241423645012}, {
            1.2774562747021856`, -0.9464214642310489}, {
            1.3089024562405893`, -0.9282914416988315}, {
            1.3337373123662732`, -0.9115132374493266}}]}, {
           Arrowheads[{{0.005007336926839006, 1.}}], 
           
           ArrowBox[{{1.3386152814805574`, -0.9080280591187164}, {
            1.3620045391892375`, -0.8890032909121209}, {
            1.3831991967726838`, -0.8678586445261318}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3040677946957218, -0.7181862975851201}, {
            0.3569549319490194, -0.7108909005578685}, {
            0.40961412584764556`, -0.7006425990630752}, {
            0.46267235910988935`, -0.6870219218574238}, {
            0.5167566144540398, -0.6696093976975976}, {
            0.536699457055983, -0.6619361386368517}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.542299254524245, -0.6597815462590582}, {
            0.5718668918800967, -0.6484050265835968}, {
            0.6280031913880599, -0.623408808515421}, {
            0.6808073981151166, -0.5968842179566769}, {
            0.7352291852585214, -0.5666762050931063}, {
            0.757190256997766, -0.5536494198404686}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7623506848491598, -0.5505883768171579}, {
            0.763052698240841, -0.5501719591756835}, {
            0.7912926598362209, -0.5327089454393985}, {
            0.8199490700446608, -0.5142871638842512}, {
            0.849021928866161, -0.49490661451024187`}, {
            0.8784007672074626, -0.47458840941091324`}, {
            0.9079751159753063, -0.45335366067980765`}, {
            0.9377449751696925, -0.4312023683169255}, {
            0.9597243353783317, -0.4142822941454956}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9644787331759836, -0.41062228026824293`}, {
            0.9677103447906209, -0.4081345323222666}, {
            1.0016216257999664`, -0.38159702308397025`}, {
            1.0353892382010494`, -0.35398895604274494`}, {
            1.0623917872679816`, -0.32914076097359546`}, {
            1.0888030037699845`, -0.3036775424102503}, {
            1.1140849759877485`, -0.27779182934866975`}, {
            1.13841700782771, -0.25141944545686706`}, {
            1.1409816265033652`, -0.24862154178876994`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.1450358657331432`, -0.24419851745380078`}, {
            1.1623189980573057`, -0.2253432623685083}, {
            1.1848018347712834`, -0.19896110922602855`}, {
            1.2058655179696431`, -0.1722729860294278}, {
            1.2255100476523848`, -0.1452788927787061}, {
            1.259958715372515, -0.09084349590539265}, {
            1.2815595389197418`, -0.048028781002361756`}}]}, {
           Arrowheads[{{0.013688996674990628`, 1.}}], 
           
           ArrowBox[{{1.2842621677315469`, -0.04267193514816723}, {
            1.2875649068331743`, -0.03612561839658121}, {1.3087241210299212`, 
            0.018562216456635958`}, {1.3238318569583143`, 
            0.07290748536316655}, {1.3319820529733, 
            0.11399806119559401`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.37397867707840293`, -0.8237593677219617}, {
            0.41939733219235825`, -0.8208796480747533}, {
            0.4653715920032173, -0.8160839947212383}, {
            0.5119014565109803, -0.8093724076614162}, {
            0.5594300885463623, -0.8004482025049269}, {
            0.6084006509400792, -0.7890146948614101}, {
            0.6109145094524068, -0.7883194256926184}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.6166974077346754, -0.7867200234739958}, {
            0.6588131436921305, -0.775071884730866}, {
            0.7106675668025165, -0.7586197721132943}, {
            0.7627739071104332, -0.7399141867490696}, {
            0.816652433879277, -0.7182981675758072}, {
            0.8426752953022363, -0.7067104033585704}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8481564397009412, -0.704269695248094}, {
            0.8721224851644964, -0.6935978141072201}, {
            0.9290033990215396, -0.665639225857021}, {
            0.9577975157857923, -0.6504135949496228}, {
            0.9865935209355954, -0.6343244078684336}, {
            1.0153914144709488`, -0.6173716646134534}, {
            1.0441911963918526`, -0.599555365184682}, {
            1.0590112569764007`, -0.5901654069847994}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.064079565384923, -0.5869541377846074}, {
            1.0844852564936738`, -0.5740251362155677}, {
            1.123994034282294, -0.5468159671993253}, {
            1.1669893602515085`, -0.5099914595078073}, {
            1.2063943078194408`, -0.47116731261496825`}, {
            1.243491517901551, -0.4315304308560738}, {
            1.2445153271439822`, -0.4302298606532424}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.248226586542539, -0.4255153560476}, {
            1.2759732530120171`, -0.3902680793650686}, {
            1.3036568299157838`, -0.34770156974357935`}, {
            1.326359565377797, -0.30415221359323324`}, {
            1.3444099406606553`, -0.2599412008490704}, {
            1.3581364370269575`, -0.2153897214461312}, {
            1.3583354531278742`, -0.21453112004568806`}}]}, {
           Arrowheads[{{0.0025353410423390797`, 1.}}], 
           
           ArrowBox[{{1.361373942443571, -0.18631147404968978`}, {
            1.3648765138720964`, -0.18631147404968978`}}]}}}}}}, {{}, {{{}, \
{}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 120], 0.008333333333333333]], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwllnk0lokXx5GlpCJbJetItpG1TbmWMqaQbFPWihRTEQ2VJgZRWknJUpKk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          "]]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 120], 0.008333333333333333]], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwllnk01WsXx6WSQoZySypSCG9R0qDLLnRJct1kyJBbKSSliehmDFHqGkpJ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          "]]}, {
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 120], 0.008333333333333333]], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwllnk01esXxg+iLpVu6ZaKDOVSEZUylB2SSIQQCpmTogw5SROFioQoqUwZ
M2WObFOIUpnn4ZgJZ/ier5uh+zt3/fZae73rWfv941lrv896P+K2bkYO3BQK
pZ7T/53/LzrEvPivJlFfRa+Xoc6Ee1uDNb7Xj+Nbv5UWQ9oscFGnmlUYj2Hd
s/kZ50MEHMgMf/0mfAQ3VWn2Ly0QYD+untYeQMO4jz6s4/5syJc+GR2nNYhK
VZRu2TY2REyN6Htz9SJ/7bzZJW4SVi2dksbYDtw1nSicKExC+rugGvULLTg1
8JxLXZIE00MBD8xCmvDmxj3ygxydJWOrXPS4FoO9Q5v3iJLQP9Vyj+r1Ebuv
zvm3byBhxyR1wcLiHT4oTQrl5iPBpvZpiWGUEyQkOr65x+b4OW1/ufJhFtyK
Ye+l09jgnbFqsdT1I2y+TfEubWLD7vZgF5WXn6DSTe7VgRI2SJnL7dtk8gWy
X6nohiewQecTNbDS8wfsMtz7inzIhl1CVPui7Fbovmgq7nGNDYU8HsnOAx0g
bbDim4A5G/a5trrKruoBQ4tNciVqbFDX7XZ/LdcP5xdTEi5KsoFW7v24MmMQ
RAOVx7lWsoGSqso7okmDI2zL9HOTBOyfr1ujRhuGpv3KcjoNBOzxMnjvHDwK
e7dcTgxKI+CiG89PwcPjUKecUP75AQGlFQslzKUJOFJTnxF/gQBB/Vbob5oC
0U18E3eUCfCPE6l9mf8T9lvE+cevIeBI2UAy5sxCyv6Rm1O9LBDju7H43JYO
VYZPcireskD/XwtuQSoDVhxx8C12YEGwprlo8wsmrPqrw1lImAXpxzTVYstZ
8MstcC/vBybs2XmptrWT42ta8NC+o0yQCPduUPzKhsmgtC1r3jLgzQPpXrfr
JKjyl3bqLNKhI6fAQb2OhO0WFJkcVzqQHQrG84MknBZstJRlzMEBceF++0kS
YrsinJqk5qDudWEYTpMgwh0n3e46C2nKSbG6HL3oofM0pXQGpMBYS4Vz/3GR
9P3AtTMgtEpFY+MYCZ2rT1gftf0JfqnrM7bRSDi1vDmFmj8NjlE2plf7SOjZ
rJNkwzMNPtqeLpKdJJRku/L5nJqC65Mh0crNJCxV47zv00mYteQuy28k4as/
O8+waQLyX7zpfFpDwnBHttRv7gk4bkDubiwjQftiklK83Dj8nd7QczafhBU5
Pg89T4/BvHCcrUIGCYOzSXNfnEZBJFR1UCeehIG737VEPUdA4eYHm6goElyi
nWy4vIZhdZGyNP8jEoy6gopUXWiwjX9xzfNbJDy9pnSh3ngI2phtc/uukiB6
Pz16SGEQfKh2x5psSagVLriygb8fvjI7m6yMSdC7Zx20I7YHJvyVr/VokNC9
VTVAbVsX0IpFt6gpkNAufttQN6QdPpxQTw7g5OpAi69cBbMFNOLiynL5Ofsp
qrkXePoHHKw1tv7KyZHT6VubIky+QtMzIYnRATZMWPn0eAnUw40Zq2GBz2w4
dmxfS01DFYidUP59NpcNjyKivJ4oloK+6X2u8eds8MqgfzfjyYUsgbw/m2+z
Ie6dudEliVig8WvuOujIBvcX9jd/vbqPRu9UfGT12HChXOyjmGUqvo7tWmpS
YEP44OiIil0BvnOsj5TdxIbHJ7W2G5mUo/iEo4vZEgFSI3lRW/2rcZmPUm8y
RMCCg19jd1kdtoh/2S9bS0Dc63btM92NmH9mXVlfOgEVmP7JtP8benZSLe2e
EPDhqqrHr9Ef6K4YZVvoQYDAd/UkhZYWpKV0djaaEeAsrhXuV9yGPETsl2eq
BBirk4oh0R2oUesYwrOdgOOxQTIbrnVh9+ZtTVzcBLxKupNQpdODL9/qZ90Y
YYFr4O9MfbE+dMwRTDepZcEaetEpl/l+DC70cbuewoKHeowwe+dBtJLY+7wy
kAXVFut3rzMbwhZh1FzvxIIFBvNTxAkaEs9yQjS1WDB/jlb25cgw0grCOnZJ
cPJYbUC+ODSCfHkRPdHLTJg6+9665+Ao/jEcdd24gwm38hReuh8eQzuxt8Ki
2UwwvCzgeVBnHIXt+LIyA5gQefKTD7fVBObq3qKlmzHBXqqu+qXvJG55VXs3
828mhE0YXc1OmMJtF5ciDxEM0HP2u1jeMo1tfa8HssoYQH7HLorgDO6vytt/
5g4DdkRXdymfmcXM6mJhJTUGTHYunPRImEOHgqqwPWw6/HokMdboS0fd8+c/
5yfSQf7GcBT9bwZW+n6gzGvTQeV9a01oMwNP9S3kUXEO2rS9qhe8mSjilXzx
6I9ZcE/dSB9cy8LVycFWKpUzQJu8w1wdwdHXuE/eDf0J18j2sfhlFqb4VfaJ
qE3Dh4tJzxf1CHxSk6bzvXsSrBx4E60CCDQq1Tru5zYBSqlRWdZpBJ6X7zVP
4xqHj7JfjddWEnh2YkzrytNRcBQTfLbYRCDL6YvYsW0joJstA5faCPz3WACx
4w0N0nm6+pGjP+24rBy6aQgq+TYYfvtOoEEDq/LzygFYpX4hXbiOwMTJ50IH
6nrA7cQ/n6aLCdxsrX/B5UonWKt2Z3slEzhXrKAYTWmDLfLuY11PCFTpcEyu
ufcDOv9JXTzkReDPI698+8hGqNOoiswzJTBfuTbx23ANOFiIU3wOEGhvYvyP
f2EpvBG8f614LYFjQRkqSRkZcGagSz9zlIV3Qhdlf0nqQ+sJm/NPSljoLa82
Os2fjmFZsvLhD1m4tvvMlOFoCR4/4zfdf5aF7s3FAnl7q9HJcYNW2A4WDjtm
DgapfEYTSVHenBkmhl3i8ZrY+A1r5YoHFPOZWBax6ccKu2b0XcdUW+nDxK3B
UUNrpNuwkDYUOK/ExIrHuS9nezswsNLeu55kICWu4lZyQDdqdKzX3pXLwAci
n/WUJfpwxfrUO6VODHQkLri/LB7AYafko6u2MHDW5PEKo51DeHiabyGojo4n
bTO57l6moWt1VkycGx013l2e2Vw4jKmRvuti/qRjv6zHkBJlFI84G1jqms/h
EdqemU69MTxMNfr19vYsmrWeHyiPHUc3sePukpEzGKGVL36FPoGhE84NhpE/
8a5hT9a6E1M4kF6297LfNLqYPhwxTZzGfXEVGdZ6U1g+fHC7HtcM7pBZXGha
nkC9QAp1u80skm33f6uHjuNpAR2xkbI5rKl7wbq0MIrCd80/pAfTUWBdcU86
jGCbjtLHXjkG9utJKH84R0OG812RBw0MnGtX23LTaBA9HW7Efj/LRA39ho2i
Or14t0DuhEQ7E89ohhalvu/A7Z683g3Awn9sNDKozGbkPyfu5x/JQseGX6G2
B7+gtlGEXkgrC/8oSFB94FeFVUqobMtFoKvjGv2H73Mxxy49UFWEQMr4x4LG
dg/ok1mUjt1F4EKJVgtvYR6IZC6wFnYTqL/6o+6V1ioIb5giQyQ576r+/W+h
R43wY42kvPwGAm0e7dxznbsZaLlh2yyWWHhj52thYal2yFcPPi41yMIT1FZX
4mA3mAUeZFgiC8fSRGydDveDl9/P074xLNxZRx/asX0Ign9Sj9ZfZSGv66UW
c4lhsK5gxBhqsXAwxCCZvnsUAm6f5iWEWKgfEPpA6Og4hIfzzpgOMrFdWp5c
sJ2EB+G0yqFkJlp9tNTufD4N2Y6hlW+dOHP3N6vzRmdgnViXg6I4E6sn7e5d
kaLDECP36LkfDLRWdqPWODHA5KYr5bUnAw9v7PNPzGdCvozU71O8DHSxC7D4
zUOAQ9jG1iUqHfNOVUSqcviuUvFrM1/gHNafP9b3VJHzj/4b764QP4MdKiul
LDlcUHR17rym7TQW2G4I5Z0h4fpyh9WE/iTaKeiP1y1zuMFAqmrtjXHsNWM4
anLPQ5rKrwsXakaxfvlQmAdlHnYGyTgtCY/gboMXr2IWSEjyjy+McaOhZ4Pb
VAmDhDuVy3Y55YMYJm1aZMjhnqjlspR9K/tRavNxgTQO1/jvPmfxmNqN3OZ/
Nc7UkyCT8mIsubUdD/S8PKBV9B8neQoGbW3BfmrCcmsiCQFe32ymkpvQIm2Q
uz6UhBDJPxUD+OpQJVIh0sCHhN4qKo5+LsfoETsy3oaEBh/jQ9ma2WjBWhgg
tTl+Mq7Qt3x2QC6bbSv95Ug4nG0/57yYAQGmurMeQiS4xXjKPDEtg/8BZ7vQ
2Q==
          "]]}, {
         Hue[0.37820393249936934`, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 120], 0.008333333333333333]], 
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJzt1PlXzfkfB/BkKcuobBFpE6YFNcnIXE9RGCq0MSOVRArFlDIVKWmohIRW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          "]]}}}, {{}, {}}}, {{}, {{{
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                DiskBox[{0, 0}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 72]], 
                  RGBColor[0.368417, 0.506779, 0.709798], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[6.272]], CompressedData["
1:eJwBNQPK/CFib1JlAwAAADIAAAABAAAAAgAAAAAAAAAAAPA/mpmZmZmZ6b9g
niry/Rj2P9Dko+irRdq/O7cLyoID9j9yqgmEcPaxP+E2CRYpQ/U/omweg6jG
3j/HjeWk9AT0P+6jD5iqZu8/jAzboLHL8T/OJorKy2X2P6uKYS6Xhu4/4qwQ
neHu9j/6CN0l387nP07ZTtf1vfY/8WXoZy8X3D8Echmsn0j2Pxk2VlPLOrs/
0ZRG8g2b9T8MPRRQW4vFv0o8VVt51vQ/ax1VsWrf2b8RoKtfmP3zP989MdHf
/+S/tJ9buj/j8j92UrTkEbDvv9JsOEq1/vA/LEwtGptz9L9wpP1jnyvqP7iM
YPtY4vS/vhXs6TmM2T9JLOmaKtvzvxXI4Z8sNaW/DEU3Vx0x8r+n5cc2PFjZ
v0bFeTprmu6/OHxrtSY06L+ZtB7qSbvhv9XpII01lfK/NNBA6sPrpT9ZFaSr
iIH0v7XTbThgXOI/4n/s/WOJ878TqgSP8Z/zP6xjum4A6PC/zknl840c9z+h
SJwzHMXmv8ieoel+p/Y/LuV7/FHFy7+4u2KRGd/1P3PofBggoc0/frK1cv/p
9D8Msgwpy+vkP9l17zDGRfM/ApV9MvdW8z8IFe9F7tzwPyFXVHUm0/Y/QUeQ
tHpF7D9r163iSOX2PxDkzRjCb+Q/rQgLHYWZ9j/8C5DBqrPTP565zVJaC/Y/
gEn/ZJ/eeb+mUadmllH1PytkYmFgrNC/8xwMaYSH9D/3y3agEK3fv9CKpL04
nvM/5gCRZdau6L+4TxVFW0/yPy5SCrHKEPK/hGcHOiai7z8LZWTS3e/0v/9z
p438n+U/hC4+qYKT9L8M6sRbjUbMP74Z7ZOqS/O/WsXqUZxvx7/jLlybW03x
v5hY3Cv43OC//tASp+/W6r94TYUXEU7tvz9hLed1yNS/XDaVCq/7878BeNM7
NJ/PPxG3MgkPSfS/sJIVfZ606T8EBqPKu8/yv+HE2SsrS/Y/AiqVlzlH7r/t
3sQOvAb3P/d/wGbFCOG/rFgBUUde9j8SvLpEp+6gv5xZx5DNivU/NDnJ2Ra1
2D+pT3EM3mv0PyEzVk2EJOs/ESizwg==
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 72]], 
                  RGBColor[0.880722, 0.611041, 0.142051], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[6.72]], CompressedData["
1:eJwBNQPK/CFib1JlAwAAADIAAAABAAAAAgAAAAAAAAAAAPA/mpmZmZmZ6b9v
KrF36uD0P9BZWSTTxeK/XkmahIUJ9j/ifmUhfpLVv/QKYCrgF/Y/qDYzBc9z
t78m4QWE4dz1P/p0l+t0R8A/IO6bXfyG9T/JcwV/tBHVP11l3LYaGvU/VW0Y
1SYp4T9EEMha1Ij0P6THZjnW3ug/DlyYxHm38z9Q3G9rjCDxP+z67FDAnPI/
mXD+6I4Q9T/13Smq12rxP0J99fdKgfY/DqOaKNIv8D8oZBhYbNf2PzrRw9iw
o+0/vMWdKujh9j/495qVwF3qP0gXpqVGz/Y/X8rOHuBM5j91S36GIan2P5j9
ZzPTXuE/zHR7gKBw9j8Z34ezb87XP8DMMasfJ/Y/SxGRfMr+yT+DLKGiIdH1
PwdguB36MKk/LYSpxjl09T87I/0GPG62v0FnF6m4E/U/7R/cdUsPy78WMcVv
1K/0P+QwO+y4/9S/izoVUxNG9D861N6QaXHcvyJObz1V0fM/ZbFPnlQu4r9M
tQWtw0jzP1JAERlzr+a/F89NIAOd8j8my37ulQjsv1iyetnwsvE/P3m0OkUA
8b/rPg7PmV7wP1CZXvQLdPO/lmTk/fDY7D/qNb39tp30v9msQvtKcOc/wHsa
m6rV9L9+Kytg+4vgP7dViQnjlPS/iizTDdQG0j+mOQYcjRX0v1jIuC172K8/
IEU/+/lt878SKallNKLAv3J9GHRenvK/EoA3A6Rn07/QKuwva5Txv7jjnRTI
Jt6/txZ8EGkl8L86ON0EMb3kv+ziRS4K++u/ZRxVpWMS679o6CeOy0XlvwtK
L15A2fC/OQtKtCMq2L+fRuzb5z/zvyqWCjYTjbO/5Vf7liwg9L/9IaOiSN/I
PwYBfhjoGvS/CVcCxZLm3D9ONTBXOqjzvwz7q7lok+c/hZT6zEzZ8r8iUcJx
YlPxPw6oAHgFffG/jfp83aWy9T/+TC9Ad6Xuv27dcoTx4fY/3gxboUTC6L9m
icnETO/2P7oM/GxqTOG/NaBHL7mv9j9r/OU1/xDSv3zREEGmVvY/TUy45ymf
pL9qthhHqvT1PzB5zX4bSsY/wYWqAg==
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 72]], 
                  RGBColor[0.560181, 0.691569, 0.194885], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[8.16]], CompressedData["
1:eJwBNQPK/CFib1JlAwAAADIAAAABAAAAAgAAAAAAAAAAAPA/mpmZmZmZ6b8Q
9uj+VAP1P7OsGBufYeK/IgncjtAa9j+WqjEdneDSv7FAqFFMEfY/JReG4d7f
pr/eQaPddcn1P0Ql4aXoQMc/f7pHUaxq9T/xVyi0/dbYPzRhHAUe/PQ/E5bs
/Rnc4j9nB0Uk3Xb0Pyi0xc6gxOk/DSNSsOXB8z9bJ1uW/OrwP6SURYfkdvI/
rprpK31f9T/gW8tVmyXwP67q+EQg5vY/1cBSXw9H7T8+waoeHOf2P+Iu1va6
feo/U0b/N8vT9j89/doa+FnnP7BTnyUStvY/et0IOHOZ4z+jrnB5sIz2P1eg
+3MxO94/ooVHYKFU9j+GQsqCWgDUP2TidE4ZC/Y/vHjaspCUwj824KSQWbD1
P1iOHsI7Wo2/9t4bpXxJ9T8qUpsxuDPEvxFKlKrm3PQ/jWcDebJU0r/yp2sP
cm30P/EwPZXX+Nm/NooqDpL58z8qkCZjMrvgv/5yr6RqfPM/6EkKj8mf5L9g
krlU+e3yP+xjy/QQ5Oi/gIthRyRB8j8ZC8cIkrvtvzXIBBFAXfE/09TF8OqM
8b80SomGRwrwP9i9arGn2PO/ho6epdKy6z+XB5kkSrr0vzWPUbmj+uU/EAY1
MuvR9L8y1+gdBr3fP51BTdiKk/S/aOwpyLIU0j9vvjGGkhL0v7SrXGeugK4/
QxmpPOZa8792Rhadg+7Cv3ZTRci9dvK/5PZ80DE21b8HGSC6Y2Hxv0YYdv9S
7t+/bysU8C0D8L8QI2l1vS/lvxb2Gw5nW+y/Qx67/e+O6r9s1/gaHiPnv6da
LSPfC/C/wHmRFZw437/MVUJCvIHyv7UVZQtRcci/umcxie/l878oI3L7AsW7
P7QIXIIyKPS/CHo8vCU52D++/NFza8/zvxTtNt5mTOQ/K1IDaq4p878Tp0Kv
Yg3tP0BuiYcVO/K/gHoSfFWd8z/GyWO8oqTwv0+nRIQa4fY/I/CzGgnR6b//
OrGQrfv2P9bSqlnrveK/yL4R7drK9j+nSQpY4kbXv5UixMSvefY/GhSEHRy5
v7+EVkrucxT2P2+adCmPVrw/jPCsKA==
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[
                 
                 NCache[{{0, 1}, {-1, 1 - 3^Rational[1, 2]}, {
                   1, 1 - 3^Rational[1, 2]}}, {{0, 
                   1}, {-1, -0.7320508075688772}, {
                   1, -0.7320508075688772}}]]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 72]], 
                  RGBColor[0.922526, 0.385626, 0.209179], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[7.6]], CompressedData["
1:eJyNj21QywEAxv/NXUfh5Lx0XaIUeTmhpFCPEudlRaQ6vZCXRqmdFLpdpBsq
qVwSZV+k5a1hW3qh/uuoaNVWVOu/YXWuJrHWtn9DYj746M5z9/vw3O/58jge
ZO8+MokgiNVmLMwwiL8ZQfHNP/lEbpG43Z5YOYYuP12btW03ebE/ZmMeTcN+
V71Mc/kymRWoZXtnG7HDV8IsqpdhcwU9xpEbkBg9xKo81wd2wppjj2YbUGDn
5hUyoQMzLBz88mFYKgVlm0NoqCOmB1oND8Bz3GdTUDwN26HqowqNGrdVV+b4
smhk/OSdkLQqMHnnNsESkxFJcVqdddVzqOvT/cqFRsi5Uy2WWbWSh5v3jjft
McLrDZPx+QNFRklqr59t18PVkdveNHuQZJ+aqCt1HQWf+et5wbcRkpV7oxp2
WtQ4pjO9vXVkhC5NVJjzCQuOM0WlHXryobtxcFVuBxbxX0s39WlIvlMTM3hc
Td7RuTCOJ7SRTbXE0ylEP5nf6S/V7HoH3pR98c/cW0jLioG7ys8U5OWFVKNd
DekS+cSvVaCAh9sZWWxcCeqXv7Vn2/RA8Ep7oWSwAfOmzUh+0NmFoXiX/vEQ
KRzycri96MScWXWaX5I2zHOu0mUb2pFpIzPNDeuCPF+pi+G2IL1gJOoFg0Jh
dNBaZc9LBJ2oLE6SqrDuxX5bzSUh7D/6Xp12Tw0hNCnSDh5cA9V2wQlqtEij
N6TOvQvPzBkHmkNV2LL/fI/K/SEUllFZ65OVsLB5Xzy8oQIRg0SX4guFLytc
Fpv2PkK49ZjcZyYFS8PrcEPRY3Daqhn39b0Y4TcscEoWYmnfjq9+rb3wCNr6
cpQUozaWmajSmJ/UFX3MIyrBTeHRLGcK16q8e0obxPDYbUoN8KQg4/CWOgrF
IFLksbe2U6B6OXTeTTFOhTYe5R6mEPAkQ1/OEcMQcz564TEK2h8WGQ7+Ysxn
6Uty2BS6TzLoS1IRcq1yvjukmfdVh2ZWD4hguiYKFCSZ/fKG05F6ERK9fMrC
2f/f2f/wvwE+naZu
          "]]}}}, {{}, {}}}}, {
    Frame -> True, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     AspectRatio -> 1, DisplayFunction :> Identity, Frame -> True, FrameLabel -> {
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm]}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, PlotRange -> NCache[{{
         Rational[-3, 2], 
         Rational[3, 2]}, {
         Rational[-3, 2], 
         Rational[3, 2]}}, {{-1.5, 1.5}, {-1.5, 1.5}}], PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}, DisplayFunction -> 
     Identity, PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRange -> NCache[{{
         Rational[-3, 2], 
         Rational[3, 2]}, {
         Rational[-3, 2], 
         Rational[3, 2]}}, {{-1.5, 1.5}, {-1.5, 1.5}}], 
     Ticks -> {Automatic, Automatic}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     AspectRatio -> 1, FrameLabel -> {
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm]}, ImageSize -> Medium, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, "MessagesHead" -> 
       StreamPlot, "LegendsFunction" -> Automatic}, DisplayFunction -> 
     Identity, AspectRatio -> 1, DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm]}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, PlotRange -> NCache[{{
         Rational[-3, 2], 
         Rational[3, 2]}, {
         Rational[-3, 2], 
         Rational[3, 2]}}, {{-1.5, 1.5}, {-1.5, 1.5}}], PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"CEG\"", "\"CEG+\"", "\"AdaptiveEG+\"", "\"CurvatureEG+\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 6.272}, {20, 6.272}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.08426020408163262] -> 
                    Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 6.72}, {20, 6.72}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.72}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.051309523809523805`] -> 
                    Baseline)], #2, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 8.16}, {20, 8.16}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 8.16}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.03009803921568628] -> 
                    Baseline)], #3, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 7.6}, {20, 7.6}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[
                    
                    NCache[{{0, 1}, {-1, 1 - 3^Rational[1, 2]}, {
                    1, 1 - 3^Rational[1, 2]}}, {{0, 
                    1}, {-1, -0.7320508075688772}, {
                    1, -0.7320508075688772}}]]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 7.6}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.002105263157894735] -> 
                    Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
