
from efficiency_benchmark.dependencies.lm_eval.base import MultipleChoiceTask

_CITATION = 


class SWAG(MultipleChoiceTask):
    VERSION = 0
    DATASET_PATH = "swag"
    DATASET_NAME = "regular"

    def has_training_docs(self):
        return True

    def has_validation_docs(self):
        return True

    def has_test_docs(self):
        return False

    def training_docs(self):
        if self._training_docs is None:
            self._training_docs = list(map(self._process_doc, self.dataset["train"]))
        return self._training_docs

    def validation_docs(self):
        return map(self._process_doc, self.dataset["validation"])

    def _process_doc(self, doc):
        out_doc = {
            "query": doc["startphrase"],
            "choices": [doc["ending0"], doc["ending1"], doc["ending2"], doc["ending3"]],
            "gold": int(doc["label"]),
        }
        return out_doc

    def doc_to_text(self, doc):
        return doc["query"]
