
from efficiency_benchmark.dependencies.lm_eval.base import MultipleChoiceTask

_CITATION =   


class QA4MRE(MultipleChoiceTask):
    VERSION = 0
    DATASET_PATH = "qa4mre"
    DATASET_NAME = None

    def has_training_docs(self):
        return False

    def has_validation_docs(self):
        return False

    def has_test_docs(self):
        return True

    def test_docs(self):
        
        return map(self._process_doc, self.dataset["train"])

    def _process_doc(self, doc):
        choices = doc["answer_options"]["answer_str"]
        out_doc = {
            "source": doc["document_str"].strip().replace("'", "'"),
            "query": doc["question_str"],
            "choices": choices,
            "gold": int(doc["correct_answer_id"]) - 1,
        }
        return out_doc

    def doc_to_text(self, doc):
        return "{}\nQuestion: {}\nAnswer:".format(doc["source"], doc["query"])

    def should_decontaminate(self):
        return True

    def doc_to_decontamination_query(self, doc):
        return doc["source"] + " " + doc["query"]


class QA4MRE_2011(QA4MRE):
    DATASET_NAME = "2011.main.EN"


class QA4MRE_2012(QA4MRE):
    DATASET_NAME = "2012.main.EN"


class QA4MRE_2013(QA4MRE):
    DATASET_NAME = "2013.main.EN"
