
import inspect

import efficiency_benchmark.dependencies.lm_eval.datasets.quac.quac
from efficiency_benchmark.dependencies.lm_eval.base import Task

_CITATION = 


class QuAC(Task):
    VERSION = 0
    DATASET_PATH = inspect.getfile(efficiency_benchmark.dependencies.lm_eval.datasets.quac.quac)
    DATASET_NAME = None

    def has_training_docs(self):
        return True

    def has_validation_docs(self):
        return True

    def has_test_docs(self):
        return False

    def training_docs(self):
        if self._training_docs is None:
            self._training_docs = list(map(self._process_doc, self.dataset["train"]))
        return self._training_docs

    def validation_docs(self):
        return map(self._process_doc, self.dataset["validation"])

    def test_docs(self):
        raise NotImplementedError("QuAC has no test docs.")

    def _process_doc(self, doc):
        doc["title"] = doc["title"] + " - " + doc["section_title"]
        return doc

    def doc_to_text(self, doc):
        return (
            "TITLE: "
            + doc["title"]
            + "\n"
            + "PARAGRAPH: "
            + doc["paragraph"]
            + "\n\n"
            + "Q: "
            + doc["question"]
            + "\n\n"
            + "A: "
        )

    def should_decontaminate(self):
        return True

    def doc_to_decontamination_query(self, doc):
        return doc["paragraph"]

    def doc_to_target(self, doc):
        return doc["answer"]

    def construct_requests(self, doc, ctx):
        
        
        raise NotImplementedError("Evaluation not implemented")

    def process_results(self, doc, results):
        
        
        raise NotImplementedError("Evaluation not implemented")

    def aggregation(self):
        
        
        raise NotImplementedError("Evaluation not implemented")

    def higher_is_better(self):
        
        
        raise NotImplementedError("Evaluation not implemented")
