
from .lambada import LambadaOpenAI

_CITATION = 


class LambadaOpenAIMultilingualEnglish(LambadaOpenAI):
    VERSION = 0
    DATASET_NAME = "en"


class LambadaOpenAIMultilingualFrench(LambadaOpenAI):
    VERSION = 0
    DATASET_NAME = "fr"


class LambadaOpenAIMultilingualGerman(LambadaOpenAI):
    VERSION = 0
    DATASET_NAME = "de"


class LambadaOpenAIMultilingualItalian(LambadaOpenAI):
    VERSION = 0
    DATASET_NAME = "it"


class LambadaOpenAIMultilingualSpanish(LambadaOpenAI):
    VERSION = 0
    DATASET_NAME = "es"


LANG_CLASSES = [
    LambadaOpenAIMultilingualEnglish,
    LambadaOpenAIMultilingualFrench,
    LambadaOpenAIMultilingualGerman,
    LambadaOpenAIMultilingualItalian,
    LambadaOpenAIMultilingualSpanish,
]


def construct_tasks():
    tasks = {}
    for lang_class in LANG_CLASSES:
        tasks[f"lambada_openai_mt_{lang_class.DATASET_NAME}"] = lang_class
    return tasks
