
from efficiency_benchmark.dependencies.lm_eval.tasks.lambada import (
    LambadaOpenAI,
    LambadaStandard,
)

_CITATION = 


class LambadaStandardCloze(LambadaStandard):
    

    VERSION = 0

    def doc_to_text(self, doc):
        return doc["text"].rsplit(" ", 1)[0] + " ____. ->"

    def should_decontaminate(self):
        return True

    def doc_to_decontamination_query(self, doc):
        return doc["text"]

    def doc_to_target(self, doc):
        return " " + doc["text"].rsplit(" ", 1)[1]


class LambadaOpenAICloze(LambadaOpenAI):
    

    VERSION = 0

    def doc_to_text(self, doc):
        return doc["text"].rsplit(" ", 1)[0] + " ____. ->"

    def should_decontaminate(self):
        return True

    def doc_to_decontamination_query(self, doc):
        return doc["text"]

    def doc_to_target(self, doc):
        return " " + doc["text"].rsplit(" ", 1)[1]
