
import numpy as np
from efficiency_benchmark.dependencies.lm_eval.base import Task, rf
from efficiency_benchmark.dependencies.lm_eval.metrics import mean

_CITATION = 


class StoryCloze(Task):
    VERSION = 0
    DATASET_PATH = "story_cloze"
    DATASET_NAME = None

    def __init__(self, data_dir: str):
        
        super().__init__(data_dir=data_dir)

    def has_training_docs(self):
        return False

    def has_validation_docs(self):
        return True

    def has_test_docs(self):
        return True

    def training_docs(self):
        pass

    def validation_docs(self):
        return self.dataset["validation"]

    def test_docs(self):
        return self.dataset["test"]

    def doc_to_text(self, doc):
        return " ".join(
            [
                doc["input_sentence_1"],
                doc["input_sentence_2"],
                doc["input_sentence_3"],
                doc["input_sentence_4"],
            ]
        )

    def should_decontaminate(self):
        return True

    def doc_to_decontamination_query(self, doc):
        return " ".join(
            [
                doc["input_sentence_1"],
                doc["input_sentence_2"],
                doc["input_sentence_3"],
                doc["input_sentence_4"],
            ]
        )

    def doc_to_target(self, doc):
        clozes = [doc["sentence_quiz1"], doc["sentence_quiz2"]]
        
        return " " + clozes[doc["answer_right_ending"] - 1]

    def construct_requests(self, doc, ctx):
        
        clozes = [doc["sentence_quiz1"], doc["sentence_quiz2"]]
        lls = [rf.loglikelihood(ctx, " {}".format(choice))[0] for choice in clozes]
        return lls

    def process_results(self, doc, results):
        
        gold = doc["answer_right_ending"] - 1
        acc = 1.0 if np.argmax(results) == gold else 0.0
        return {"acc": acc}

    def aggregation(self):
        
        return {"acc": mean}

    def higher_is_better(self):
        
        return {"acc": True}


class StoryCloze2016(StoryCloze):
    DATASET_NAME = "2016"


class StoryCloze2018(StoryCloze):
    DATASET_NAME = "2018"
