from typing import Tuple

import numpy as np


class AdaptiveKLController:
    

    def __init__(self, init_kl_coef, target, horizon):
        self.value = init_kl_coef
        self.target = target
        self.horizon = horizon

    def update(self, current, n_steps):
        target = self.target
        proportional_error = np.clip(current / target - 1, -0.2, 0.2)
        mult = 1 + proportional_error * n_steps / self.horizon
        self.value *= mult


class FixedKLController:
    

    def __init__(self, kl_coef):
        self.value = kl_coef

    def update(self, current, n_steps):
        pass
