import os
import re

replace_keywords = [...]
replace_with_anonymous = "..."

modified_files = []
renamed_files = []
deleted_files = []

def remove_comments(content):
    content = re.sub(r'#.*$', '', content, flags=re.MULTILINE)
    content = re.sub(r'""".*?"""', '', content, flags=re.DOTALL)
    content = re.sub(r"'''.*?'''", '', content, flags=re.DOTALL)
    return content

def replace_in_file(file_path):
    try:
        with open(file_path, 'r', encoding='utf-8') as file:
            content = file.read()

        original_content = content
        
        if file_path.endswith('.py'):
            content = remove_comments(content)
            
        for keyword in replace_keywords:
            content = content.replace(keyword, replace_with_anonymous)

        if content != original_content:
            with open(file_path, 'w', encoding='utf-8') as file:
                file.write(content)
            modified_files.append(file_path)
            print(f"Processed content: {file_path}")
    except Exception as e:
        print(f"Error processing {file_path}: {e}")

def replace_in_filename(file_path):
    try:
        directory, filename = os.path.split(file_path)
        original_filename = filename
        for keyword in replace_keywords:
            filename = filename.replace(keyword, replace_with_anonymous)

        if filename != original_filename:
            new_file_path = os.path.join(directory, filename)
            os.rename(file_path, new_file_path)
            renamed_files.append((file_path, new_file_path))
            print(f"Renamed: {file_path} -> {new_file_path}")
            return new_file_path
        return file_path
    except Exception as e:
        print(f"Error renaming {file_path}: {e}")
        return file_path

def delete_non_py_files(file_path):
    if not file_path.endswith('.py'):
        try:
            os.remove(file_path)
            deleted_files.append(file_path)
            print(f"Deleted: {file_path}")
        except Exception as e:
            print(f"Error deleting {file_path}: {e}")

def traverse_and_replace(root_dir):
    for root, dirs, files in os.walk(root_dir):
        if '.git' in dirs:
            dirs.remove('.git')

        for file in files:
            file_path = os.path.join(root, file)
            delete_non_py_files(file_path) 
            
            if file_path.endswith('.py'): 
                new_file_path = replace_in_filename(file_path)
                replace_in_file(new_file_path)

if __name__ == "__main__":
    root_directory = './' 
    traverse_and_replace(root_directory)

    if modified_files:
        print("\nFiles with modified content:")
        for file in modified_files:
            print(file)
    else:
        print("No file contents were modified.")

    if renamed_files:
        print("\nFiles renamed:")
        for old_name, new_name in renamed_files:
            print(f"{old_name} -> {new_name}")
    else:
        print("No files were renamed.")
        
    if deleted_files:
        print("\nFiles deleted:")
        for file in deleted_files:
            print(file)
    else:
        print("No files were deleted.")