



import os
from typing import List, Optional

import packaging.version

TAG = os.environ["TAG"]

ADDED_HEADER = "
CHANGED_HEADER = "
FIXED_HEADER = "
REMOVED_HEADER = "


def get_change_log_notes() -> str:
    in_current_section = False
    current_section_notes: List[str] = []
    with open("CHANGELOG.md") as changelog:
        for line in changelog:
            if line.startswith("
                if line.startswith("
                    continue
                if line.startswith(f"
                    in_current_section = True
                    continue
                break
            if in_current_section:
                if line.startswith("
                    line = ADDED_HEADER + "\n"
                elif line.startswith("
                    line = CHANGED_HEADER + "\n"
                elif line.startswith("
                    line = FIXED_HEADER + "\n"
                elif line.startswith("
                    line = REMOVED_HEADER + "\n"
                current_section_notes.append(line)
    assert current_section_notes
    return "


def get_commit_history() -> str:
    new_version = packaging.version.parse(TAG)

    
    os.popen("git fetch --tags")

    
    all_tags = os.popen("git tag -l --sort=-version:refname 'v*'").read().split("\n")

    
    
    
    last_tag: Optional[str] = None
    for tag in all_tags:
        if not tag.strip():  
            continue
        version = packaging.version.parse(tag)
        if new_version.pre is None and version.pre is not None:
            continue
        if version < new_version:
            last_tag = tag
            break
    if last_tag is not None:
        commits = os.popen(f"git log {last_tag}..{TAG}^ --oneline --first-parent").read()
    else:
        commits = os.popen("git log --oneline --first-parent").read()
    return "


def main():
    print(get_change_log_notes())
    print(get_commit_history())


if __name__ == "__main__":
    main()
