#!/usr/bin/env bash
#
# Combined CUP and Simmer runs on Hopper-v1

# --- CUP loop (CUDA device 1, cores 14–27) ---
for seed in {0..4}; do
  idx=$((seed + 1))
  echo "=== [CUP] seed=${seed}, run${idx} ==="

  CUDA_VISIBLE_DEVICES=1 taskset -c 14-27 \
    python Main.py \
      --csv-path "/scratch1/dsc5636/CPO/AccRuns/P3O/runNoPen${idx}.csv" \
      --seed "${seed}" \
      --env-id "AccEnv-v1" \
      --algorithm "P3O" \
      --steps 200000 \
    >> "/scratch1/dsc5636/CPO/AccRuns/P3O/runNoPen${idx}.txt"
done

echo " All CUP runs complete!"

# # --- Simmer loop (CUDA device 2, cores 56–69) ---
# for seed in {0..4}; do
#   idx=$((seed + 1))
#   echo "=== [Simmer] seed=${seed}, run${idx} ==="

#   CUDA_VISIBLE_DEVICES=6 taskset -c 84-97 \
#     python Main.py \
#       --csv-path "/scratch1/dsc5636/CPO/AccRuns/Simmer/run${idx}.csv" \
#       --seed "${seed}" \
#       --env-id "AccEnv-v1" \
#       --algorithm "PPOSimmerPID" \
#       --steps 200000 \
#     >> "/scratch1/dsc5636/CPO/AccRuns/Simmer/run${idx}.txt"
# done

# echo "✅ All Simmer runs complete!"
