#!/bin/bash

# List of algorithms to test
algos=("RCEPETS")
# Fixed environment
env="Ant-v1"
# Number of seeds
runs=5

for algo in "${algos[@]}"; do
  for seed in $(seq 1 $runs); do
    csv_path="/scratch1/dsc5636/CPO/Ant/${algo}/run${seed}.csv"
    echo "Running $algo on $env with seed $seed"
    taskset -c 0-13 \
    python Main.py \
      --algorithm $algo \
      --env-id $env \
      --seed $seed \
      --csv-path $csv_path \
      --steps 500000
  done
done
