#!/usr/bin/env bash

# Loop seed=1→4, file index = seed+1 → run2…run5
for seed in {1..4}; do
  idx=$((seed + 1))
  echo "=== Running AccEnv-v1 seed=${seed}, file=run${idx} ==="

  CUDA_VISIBLE_DEVICES=1 taskset -c 14-27 \
    python Main.py \
      --csv-path "/scratch1/dsc5636/CPO/AccRuns/Simmer/run${idx}.csv" \
      --seed "${seed}" \
      --env-id "AccEnv-v1" \
      --algorithm "PPOSimmerPID" \
    >> "/scratch1/dsc5636/CPO/AccRuns/Simmer/run${idx}.txt"
done
