#!/bin/bash

# List of algorithms to test
algos=("SafeLOOP" "CAPPETS")
# Fixed environment
env="Cheetah-v1"
# Number of seeds
runs=5

for algo in "${algos[@]}"; do
  for seed in $(seq 1 $runs); do
    csv_path="/scratch1/dsc5636/CPO/Cheetah/${algo}/run${seed}.csv"
    echo "Running $algo on $env with seed $seed"
    CUDA_VISIBLE_DEVICES=1 taskset -c 14-27 \
    python Main.py \
      --algorithm $algo \
      --env-id $env \
      --seed $seed \
      --csv-path $csv_path \
      --steps 300000
  done
done
