#!/usr/bin/env bash
#
# Combined CUP and Simmer runs on Hopper-v1

# --- CUP loop (CUDA device 1, cores 14–27) ---
for seed in {0..4}; do
  idx=$((seed + 1))
  echo "=== [CUP] seed=${seed}, run${idx} ==="

  CUDA_VISIBLE_DEVICES=3 taskset -c 70-83 \
    python Main.py \
      --csv-path "/scratch1/dsc5636/CPO/Cheetah/CUP/run${idx}.csv" \
      --seed "${seed}" \
      --env-id "Cheetah-v1" \
      --algorithm "CUP" \
      --steps 500000 \
    >> "/scratch1/dsc5636/CPO/Cheetah/CUP/run${idx}.txt"
done

echo " All CUP runs complete!"

