#!/usr/bin/env bash
#
# Combined Saute and Simmer runs on Hopper-v1

# --- Saute loop (CUDA device 1, cores 14–27) ---
for seed in {0..4}; do
  idx=$((seed + 1))
  echo "=== [Saute] seed=${seed}, run${idx} ==="

  CUDA_VISIBLE_DEVICES=3 taskset -c 70-83 \
    python Main.py \
      --csv-path "/scratch1/dsc5636/CPO/Hopper/Saute/run${idx}.csv" \
      --seed "${seed}" \
      --env-id "Hopper-v1" \
      --algorithm "PPOSaute" \
      --steps 300000 \
    >> "/scratch1/dsc5636/CPO/Hopper/Saute/run${idx}.txt"
done

echo "All Saute runs complete!"

