from .double_gate_car import DoubleGateCar
from .double_gate_point import DoubleGatePoint
from .thick_double_gate_car import ThickDoubleGateCar
from .thick_double_gate_point import ThickDoubleGatePoint
from .gate_car import GateCar
from .gate_point import GatePoint
from .obstacles_car import ObstaclesCar
from .obstacles_point import ObstaclesPoint

from .mountain_car import MountainCar
from .obstacle import Obstacle
from .obstacle2 import Obstacle2
from .road import Road
from .road_2d import Road2d
from .hopper import Hopper
from .ant import Ant


def get_env(name):
    """
    Factory function to create and return an environment instance by name.
    """
    if name == "DoubleGateCar":
        env = DoubleGateCar()
    elif name == "DoubleGatePoint":
        env = DoubleGatePoint()
    elif name == "ThickDoubleGateCar":
        env = ThickDoubleGateCar()
    elif name == "ThickDoubleGatePoint":
        env = ThickDoubleGatePoint()
    elif name == "GateCar":
        env = GateCar()
    elif name == "GatePoint":
        env = GatePoint()
    elif name == "ObstaclesCar":
        env = ObstaclesCar()
    elif name == "ObstaclesPoint":
        env = ObstaclesPoint()
    elif name == "MountainCar":
        env = MountainCar()
    elif name == "Obstacle":
        env = Obstacle()
    elif name == "Obstacle2":
        env = Obstacle2()
    elif name == "Road":
        env = Road()
    elif name == "Road2d":
        env = Road2d()
    elif name == "hopper":
        env = Hopper()
    elif name == "ant":
        env = Ant()
    else:
        raise Exception(f"Environment '{name}' not found")
    
    return env
