#!/usr/bin/env bash
#
# Combined CUP and Simmer runs on Hopper-v1

# --- CUP loop (CUDA device 0, cores 14–27) ---
for seed in {0..4}; do
  idx=$((seed + 1))
  echo "=== [CUP] seed=${seed}, run${idx} ==="

  CUDA_VISIBLE_DEVICES=0 taskset -c 0-13 \
    python Main.py \
      --csv-path "/scratch1/dsc5636/CPO/CarRacing/Saute/runNoPen${idx}.csv" \
      --seed "${seed}" \
      --env-id "CarRacing-v1" \
      --algorithm "PPOSaute" \
      --steps 200000 \
    >> "/scratch1/dsc5636/CPO/CarRacing/Saute/runNoPen${idx}.txt"
done

echo "All CUP runs complete!"


