#!/usr/bin/env bash
set -euo pipefail
set -x


# Optional: Set CUDA device visibility
export CUDA_VISIBLE_DEVICES=2

# Now run your script
for seed in {0..0}; do
  idx=$((seed + 1))
  echo "=== [Saute] seed=${seed}, run${idx} ==="
  taskset -c 56-69 \
    python Main.py \
      --csv-path "/scratch1/dsc5636/CPO/HumanoidEnv/P3O/run${idx}.csv" \
      --seed "${seed}" \
      --env-id "HumanoidEnv-v1" \
      --algorithm "P3O" \
      --steps 500000 \
    >> "/scratch1/dsc5636/CPO/HumanoidEnv/P3O/run${idx}.txt" 2>&1
done
