#!/bin/bash

# List of algorithms to test
algos=("CAPPETS")
# Fixed environment
env="Pendulum-v1"
# Number of seeds
runs=5

for algo in "${algos[@]}"; do
  for seed in $(seq 1 $runs); do
    csv_path="/scratch1/dsc5636/CPO/PendulumRuns/${algo}/run${seed}.csv"
    echo "Running $algo on $env with seed $seed"
    CUDA_VISIBLE_DEVICES=1 taskset -c 14-27 \
    python Main.py \
      --algorithm $algo \
      --env-id $env \
      --seed $seed \
      --csv-path $csv_path \
      --steps 200000
  done
done
