#!/usr/bin/env bash

# Loop seed=1→4, file index = seed+1 → run2…run5
for seed in {1..4}; do
  idx=$((seed + 1))
  echo "=== Running seed=${seed}, file=run${idx} ==="

  CUDA_VISIBLE_DEVICES=0 taskset -c 0-13 \
    python Main.py \
      --csv-path "/scratch1/dsc5636/CPO/PendulumRuns/Saute/run${idx}.csv" \
      --seed "${seed}" \
      --env-id "Pendulum-v1" \
      --algorithm "PPOSaute" \
    >> "PendulumRuns/Saute/run${idx}.txt"
done
