#!/bin/bash

# List of algorithms to test
algos=("PPOSaute" "CUP" "P3O")
# Fixed environment
env="HumanoidEnv-v1"
# Number of seeds
runs=5

for algo in "${algos[@]}"; do
  for seed in $(seq 1 $runs); do
    csv_path="/scratch1/dsc5636/CPO/HumanoidEnv/${algo}/run${seed}.csv"
    echo "Running $algo on $env with seed $seed"
    CUDA_VISIBLE_DEVICES=1 taskset -c 14-27 \
    python Main.py \
      --algorithm $algo \
      --env-id $env \
      --seed $seed \
      --csv-path $csv_path
  done
done
