import argparse

def str2bool(v):
    if v.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif v.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')


class TestOptions():
    def __init__(self):
        """Reset the class; indicates the class hasn't been initailized"""
        self.initialized = False
    def initialize(self):
        parser = argparse.ArgumentParser()
        parser.add_argument('--UseCUDA', help='Use CUDA?', type=str2bool, nargs='?', default=True)
        parser.add_argument('--GPU_num', help='Name of GPU', type=int, default=0)
        parser.add_argument('--Train', help='Train or Test', type=str, default='Train')
        parser.add_argument('--ModelName', help='FactorVAE/BetaVAE', type=str, default='BetaVAE')
        parser.add_argument('--Dataset', help='Dataset', type=str, default='MNIST')
        parser.add_argument('--Validation', help='Validation Yes or No', type=str, default='Yes')
        parser.add_argument('--Uncertain', help='Use uncertain Yes or No', type=str, default='Yes')
        parser.add_argument('--Val_percent', help='Validation dataset percentage', type=float, default=0.1)
        ##
        parser.add_argument('--Epoch', help='Epoch', type=int, default=2000)
        parser.add_argument('--Epoch_restart', help='Restarting epoch', type=int, default=0)
        ##
        parser.add_argument('--lr', help='Learning rate', type=float, default=1e-4)
        parser.add_argument('--lr_D', help='Learning rate for discriminator(FactorVAE)', type=float, default=1e-4)
        parser.add_argument('--BatchSize', help='BatchSize', type=int, default=64)
        parser.add_argument('--lambda_class', help='Hyperparameter for classification loss', type=int, default=50)
        parser.add_argument('--lambda_vae', help='Hyperparameter for vae loss', type=int, default=1)
        ##
        parser.add_argument('--Proto_num', help='Number of prototypes', type=int, default=20)
        parser.add_argument('--Beta', help='Beta for BetaVAE', type=float, default=1.0)
        parser.add_argument('--Gamma', help='Gamma for FactorVAE', type=float, default=6.4)
        parser.add_argument('--z_dim', help='z_dimension for VAE', type=int, default=10)
        parser.add_argument('--Metric', help='What metric will be used for distance measure: Dkl/JSD/JTD/WSR', type=str, default='WSR')
        ##
        parser.add_argument('--OutRoot', help='Path for output', type=str, default='./results/')

        self.initialized = True
        self.parser = parser
        return parser

    def print_options(self, opt):
        # This function is adapted from 'cycleGAN' project.
        message = ''
        message += '----------------- Options ---------------\n'
        for k, v in sorted(vars(opt).items()):
            comment = ''
            default = self.parser.get_default(k)
            if v != default:
                comment = '\t[default: %s]' % str(default)
            message += '{:>25}: {:<30}{}\n'.format(str(k), str(v), comment)
        message += '----------------- End -------------------'
        print(message)
        self.message = message

    def parse(self, is_print):
        parser = self.initialize()
        opt = parser.parse_args()
        if(is_print):
            self.print_options(opt)
        self.opt = opt
        return self.opt
