# Beyond Examples: Constructing Explanation Space for Explaining Prototypes

All options are in options/testing_options.py


## Requirements

```
python 3.7.3
pytorch 1.6.0
torchvision 0.7.0
tqdm 4.32.1
```


## Training

Default setting:
vanilla VAE, Wasserstein distance, use uncertainty layer, MNIST dataset, 20 prototype distributions

1. Changing VAE layer
=> --ModelName BetaVAE --Beta 1: vanilla VAE, --ModelName BetaVAE --Beta 4: Beta-VAE, --ModelName FactorVAE --Gamma 6.4: FactorVAE

2. Changing measures
=> --Metric Dkl: KL-divergence, --Metric JSD: Jensen-Shannon divergence, --Metric JTD: Jensen-Tsallis distance, --Metric WSR: Wasserstein distance

3. Using uncertainty layer
=> --Uncertain Yes: use uncertainty layer, --Uncertain No: without uncertainty layer

4. Changing dataset
=> --Dataset MNIST: MNIST dataset, --Dataset FashionMNIST: FashionMNIST dataset

5. Changing prototypes number
=> --Proto_num 30: train with 30 prototype distributions

ex) Want to use FactorVAE, Wasserstein distance, use uncertainty layer, FashionMNIST dataset, 40 prototype distributions
=> 
```
python main.py --ModelName FactorVAE --Gamma 6.4 --Metric WSR --Dataset FashionMNIST --Proto_num 40
```
Model is saved with every 100 epochs with prototype images, reconstruction images, classification accuracy, mu&variance of prototype distributions, and reconstruction error.


## Test and visuallization

After training, for test and visualization =>

```
python main.py --Train Test --Epoch_restart k(epochs that you want to test) ~~~~(settings that you trained)
```
Distances between embedded input distribution and prototype distributions are printed.

## Contributing

Use for construct FactorVAE:

MIT License

Copyright (c) 2018 WonKwang Lee

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
