# CovMatch

## Setup
Run
```
conda env create -f requirements.yaml
```
and activate the conda environment
```
conda activate covmatch
```

Download Flickr30k and COCO datasets and put them here:
```
./distill_utils/data/
├── Flickr30k/
│   ├── flickr30k-images/
│   │   ├── 1234.jpg
│   │   └── ......
│   ├── results_20130124.token
│   └── readme.txt
└── COCO/
    ├── train2014/
    ├── val2014/
    └── test2014/
```

## Distillation & Evaluation
All script files are provided in 'scripts/'. For example, to distill flickr30k with 100 synthetic pairs, run
```
sh scripts/distill_flickr_N100.sh
```
We only provide synthetic set for Flickr30k with N=100 due to space limit, in 'results/'.
To evaluate synthetic sets, run
```
sh scripts/evaluate_all.sh
```