import argparse
import os
from idol_config import d

parser = argparse.ArgumentParser()

parser.add_argument('-size', type=int, default=1)
parser.add_argument('-draw', type=int, default=0)
parser.add_argument('-dataset', type=str, nargs='+')
parser.add_argument('-device', default=0, type=int)
parser.add_argument('-lens', default=[96], type=int, nargs='+')
parser.add_argument('-seed', default=[2024], type=int, nargs='+')

args = parser.parse_args()

comand_list = []

for data in args.dataset:
    for pred_len in args.lens:
        for seed in args.seed:
            command = f"""{d[data][pred_len]} --draw {args.draw} --gpu {args.device} --seed {seed} """
            comand_list.append(command)

i = 0
while i + args.size <= len(comand_list):
    new_comand = "".join(f"{comand_list[i + j]}  &  " for j in range(args.size)).rstrip().rstrip('&')
    os.system(new_comand)
    i = i + args.size

if i < len(comand_list):
    new_comand = "".join(f"{comand_list[i + j]}  &  " for j in range(len(comand_list) - i)).rstrip().rstrip('&')
    os.system(new_comand)
