import argparse
import os
from idol_config import d

parser = argparse.ArgumentParser()

parser.add_argument('-size', type=int, default=1)
parser.add_argument('-lradj', default='type1', type=str)
parser.add_argument('-dataset', type=str, nargs='+')
parser.add_argument('-device', default=0, type=int)
parser.add_argument('-lens', default=[96], type=int, nargs='+')
parser.add_argument('-seed', default=[2024], type=int, nargs='+')

args = parser.parse_args()

comand_list = []

for data in args.dataset:
    for seed in args.seed:
        # for d_ff in [2048, 1024]:
            
                
        for lr in [5e-3]:
            for batch_size in [32]:
                for d_model in [192, 128, 64]:
                    for pred_len in args.lens:
                        command = f"""{d[data][pred_len]} --d_model {d_model} --batch_size {batch_size} --lradj {args.lradj} --learning_rate {lr} --gpu {args.device} --seed {seed} """
                        comand_list.append(command)

i = 0
while i + args.size <= len(comand_list):
    new_comand = "".join(f"{comand_list[i + j]}  &  " for j in range(args.size)).rstrip().rstrip('&')
    os.system(new_comand)
    i = i + args.size

if i < len(comand_list):
    new_comand = "".join(f"{comand_list[i + j]}  &  " for j in range(len(comand_list) - i)).rstrip().rstrip('&')
    os.system(new_comand)
