import torch
from tqdm import tqdm
import torchvision.utils as tvu
import os
import numpy as np

def compute_alpha(beta, t):
    beta = torch.cat([torch.zeros(1).to(beta.device), beta], dim=0)
    a = (1 - beta).cumprod(dim=0).index_select(0, t + 1).view(-1, 1, 1, 1)
    return a


# x: 初始噪声；seq: 时间下标序列；model: 扩散模型；betas: beta序列；H_funcs: 观测矩阵；y_0: 观测；sigma_0: 观测噪声标准差；clas_fn: 分类器；classes: 类别
def efficient_generalized_steps(x, seq, model, b, H_funcs, y_0, sigma_0, etaB, etaA, etaC, cls_fn=None, classes=None):
    with torch.no_grad():
        #initialize x_T as given in the paper
        largest_alphas = compute_alpha(b, (torch.ones(x.size(0)) * seq[-1]).to(x.device).long())
        
        #setup iteration variables
        n = x.size(0)
        seq_next = [-1] + list(seq[:-1])
        x0_preds = []
        xs = [x]


        t = (torch.ones(n) * seq[-1]).to(x.device)
        # alpha_t和alpha_{t-1}
        at = compute_alpha(b, t.long())
        noise = torch.randn_like(x)
        x_T = noise * (1 - at).sqrt()
        et = model(x_T, t)
        if et.size(1) == 6:
            et = et[:, :3]
        x0_t = (x_T - et * (1 - at).sqrt()) / at.sqrt()

        
        # print(x0_t)
        # print(y_upsampling)
        v = None
        beta=0.0
        # 1000steps: 0.1
        # 100steps: 1.8
        # 20steps: 1.7
        lr=0.8
        N=1
        lam=1
        # init_noise = torch.randn_like(x0_t)
        et = None
        eta=0.85
        gamma=0.05
        #iterate over the timesteps
        for i, j in tqdm(zip(reversed(seq), reversed(seq_next))):
            for _ in range(N):
                t = (torch.ones(n) * i).to(x.device)
                next_t = (torch.ones(n) * j).to(x.device)
                # alpha_t和alpha_{t-1}
                at = compute_alpha(b, t.long())
                at_next = compute_alpha(b, next_t.long())
                # at = at_next
                # print(at_next[0])
                # xt = xs[-1].to('cuda')
                # 重新加噪，Stochastic Encoding
                xt = at.sqrt() * x0_t + torch.randn_like(x0_t) * (1 - at).sqrt()

                # et = model(xt, t)
                # et = et[:, :3]
                # #### VPS
                # eta_l = gamma * (1-at[0,0,0,0])
                # eta_g = ((1-at) * gamma * (2-gamma)).sqrt()[0,0,0,0]
                # xt = xt - eta_l * et / (1-at).sqrt() + eta_g * torch.randn_like(xt)
                # 重新加噪，Restricted Resampling
                # print(at)
                # print(at_next)
                # xt = at.sqrt() * x0_t + (1 - eta**2) ** 0.5 * (1 - at).sqrt() * init_noise + eta * (1 - at).sqrt() * torch.randn_like(x0_t)
                
                # if et is None:
                #     xt = at.sqrt() * x0_t + torch.randn_like(x0_t) * (1 - at).sqrt()
                # else:
                #     xt = at.sqrt() * x0_t + (1-at).sqrt() * (1-eta**2)**0.5 * et + torch.randn_like(x0_t) * (1-at).sqrt() * eta
                # print(torch.norm(xt[0]))
                # 计算error。是一个epsilon-predictor
                if cls_fn == None:
                    et = model(xt, t)
                else:
                    et = model(xt, t, classes)
                    et = et[:, :3]
                    et = et - (1 - at).sqrt()[0,0,0,0] * cls_fn(x,t,classes)
                
                if et.size(1) == 6:
                    et = et[:, :3]
                
                # 计算新的x0_t
                x0_t_new = (xt - et * (1 - at).sqrt()) / at.sqrt()

                # 扩散模型的更新方向
                diff = x0_t_new - x0_t
                # 合方向
                # lam = (1-at)[0,0,0,0]
                # lam = torch.sqrt(torch.sum(diff**2, dim=[1,2,3], keepdim=True)) / torch.sqrt(torch.sum(gradient_obs**2, dim=[1,2,3], keepdim=True) + 1e-8)
                # print(lam[0])
                lam=1
                # d = diff - lam * gradient_obs
                d = diff

                # print('diff norm:{}'.format(torch.norm(diff[0])))
                # print('obs gradient norm:{}'.format(torch.norm(gradient_obs[0])))
                # 计算动量
                if v is None:
                    v = d
                else:
                    v = beta * v + (1-beta) * d
                # 更新x0_t
                x0_t += lr * v
                # lr += 0.01
                # v += x0_t + y_upsampling - H_funcs.upsampling(H_funcs.downsampling(x0_t))
                x0_t = x0_t + H_funcs.H_pinv(y_0 - H_funcs.H(x0_t)).view(y_0.shape[0], 3, x0_t.shape[2], x0_t.shape[3])
                # et = (xt - at.sqrt() * x0_t) / (1-at).sqrt()
                # print('x0_t norm:{}'.format(torch.norm(x0_t[0])))
                xt_next = x0_t
                
                # x0_t = y_upsampling

                # print(torch.norm(y_upsampling[0]))
                x0_preds.append(x0_t.to('cpu'))
                xs.append(xt_next.to('cpu'))

    return xs, x0_preds