import torch
from tqdm import tqdm
import torchvision.utils as tvu
import os
import numpy as np

def compute_alpha(beta, t):
    beta = torch.cat([torch.zeros(1).to(beta.device), beta], dim=0)
    a = (1 - beta).cumprod(dim=0).index_select(0, t + 1).view(-1, 1, 1, 1)
    return a


# x: 初始噪声；seq: 时间下标序列；model: 扩散模型；betas: beta序列；H_funcs: 观测矩阵；y_0: 观测；sigma_0: 观测噪声标准差；clas_fn: 分类器；classes: 类别
def efficient_generalized_steps(x, seq, model, b, H_funcs, y_0, sigma_0, etaB, etaA, etaC, cls_fn=None, classes=None):
    with torch.no_grad():
        #initialize x_T as given in the paper
        largest_alphas = compute_alpha(b, (torch.ones(x.size(0)) * seq[-1]).to(x.device).long())
        
        # setup iteration variables
        y_upsampling = H_funcs.upsampling(y_0)
        n = x.size(0)
        seq_next = [-1] + list(seq[:-1])
        x0_preds = []
        xs = [x]

        yt = None
        # pure DDIM, as indicated in DreamClean
        eta=0.85
        gamma=0.05
        N = 1
        #iterate over the timesteps
        for i, j in tqdm(zip(reversed(seq), reversed(seq_next))):
            # 从300开始操作
            if i > 300:
                continue
            for _ in range(N):
                t = (torch.ones(n) * i).to(x.device)
                next_t = (torch.ones(n) * j).to(x.device)
                at = compute_alpha(b, t.long())
                at_next = compute_alpha(b, next_t.long())
                if yt is None:  # initialize yt
                    # print(yt)
                    yt = at.sqrt() * y_upsampling + (1-at).sqrt() * torch.randn_like(y_upsampling)
                # score function
                et = model(yt, t)
                et = et[:, :3]
                #### VPS
                eta_l = gamma * (1-at[0,0,0,0])
                eta_g = ((1-at) * gamma * (2-gamma)).sqrt()[0,0,0,0]
                yt = yt - eta_l * et / (1-at).sqrt() + eta_g * torch.randn_like(yt)
                #### DDIM update
                et = model(yt, t)
                et = et[:, :3]
                y0_t = (yt - (1-at).sqrt() * et)/at.sqrt()
                # DDNM correction
                y0_t = y0_t + H_funcs.upsampling(y_0 - H_funcs.downsampling(y0_t))
                yt = at_next.sqrt() * y0_t + (1-at_next).sqrt() * et * (1 - eta**2)**0.5 + (1-at_next).sqrt() * eta * torch.randn_like(y0_t)
                
                # save images
                xt_next = yt
                x0_t = y0_t
                x0_preds.append(x0_t.to('cpu'))
                xs.append(xt_next.to('cpu'))

    return xs, x0_preds