import torch
from tqdm import tqdm
import torchvision.utils as tvu
import os
import numpy as np

def compute_alpha(beta, t):
    beta = torch.cat([torch.zeros(1).to(beta.device), beta], dim=0)
    a = (1 - beta).cumprod(dim=0).index_select(0, t + 1).view(-1, 1, 1, 1)
    return a


# x: 初始噪声；seq: 时间下标序列；model: 扩散模型；betas: beta序列；H_funcs: 观测矩阵；y_0: 观测；sigma_0: 观测噪声标准差；clas_fn: 分类器；classes: 类别
def efficient_generalized_steps(x, seq, model, b, H_funcs, y_0, sigma_0, etaB, etaA, etaC, cls_fn=None, classes=None):
    with torch.no_grad():
        #initialize x_T as given in the paper
        largest_alphas = compute_alpha(b, (torch.ones(x.size(0)) * seq[-1]).to(x.device).long())
        
        #setup iteration variables
        # x = H_funcs.V(init_y.view(x.size(0), -1)).view(*x.size())
        # y_upsampling = H_funcs.upsampling(y_0)
        n = x.size(0)
        seq_next = [-1] + list(seq[:-1])
        x0_preds = []
        xs = [x]
        c = 0.15
        gamma=0.05
        # 初始化迭代变量
        xt = x
        yt = H_funcs.downsampling(x)
        #iterate over the timesteps
        # for i, j in tqdm(zip(reversed(seq), reversed(seq_next))):
        #     for _ in range(N):
        #         t = (torch.ones(n) * i).to(x.device)
        #         next_t = (torch.ones(n) * j).to(x.device)
        #         # alpha_t和alpha_{t-1}
        #         at = compute_alpha(b, t.long())
        #         at_next = compute_alpha(b, next_t.long())
        #         # at = at_next
        #         pt = ((1-c) * (1-at_next) / (1-at)).sqrt()[0,0,0,0]
        #         qt = (c * (1-at_next)).sqrt()
        #         yt_next = at_next.sqrt()[0,0,0,0] * y_0 + pt * (yt - at.sqrt() * y) + qt * H_funcs.donwsampling(torch.randn_like(x))
        #         Sigma_fps = 0


        #         # print(torch.norm(y_upsampling[0]))
        #         x0_preds.append(x0_t.to('cpu'))
        #         xs.append(xt_next.to('cpu'))
        x0_t = xt_next = H_funcs.upsampling(y_0)
        x0_preds.append(x0_t.to('cpu'))
        xs.append(xt_next.to('cpu'))

    return xs, x0_preds