/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.MutableDouble;
import de.bwaldvogel.liblinear.MutableInt;

class Blas {
    Blas() {
    }

    static double dnrm2_(int n, double[] x, MutableInt incx) {
        return Blas.dnrm2_(new MutableInt(n), x, incx);
    }

    private static double dnrm2_(MutableInt n, double[] x, MutableInt incx) {
        double norm;
        int nn = n.get();
        int iincx = incx.get();
        if (nn > 0 && iincx > 0) {
            if (nn == 1) {
                norm = Math.abs(x[0]);
            } else {
                double scale = 0.0;
                double ssq = 1.0;
                for (int ix = (nn - 1) * iincx; ix >= 0; ix -= iincx) {
                    double temp;
                    if (x[ix] == 0.0) continue;
                    double absxi = Math.abs(x[ix]);
                    if (scale < absxi) {
                        temp = scale / absxi;
                        ssq = ssq * (temp * temp) + 1.0;
                        scale = absxi;
                        continue;
                    }
                    temp = absxi / scale;
                    ssq += temp * temp;
                }
                norm = scale * Math.sqrt(ssq);
            }
        } else {
            norm = 0.0;
        }
        return norm;
    }

    static double ddot_(int n, double[] sx, int incx, double[] sy, int incy) {
        return Blas.ddot_(new MutableInt(n), sx, new MutableInt(incx), sy, new MutableInt(incy));
    }

    private static double ddot_(MutableInt n, double[] sx, MutableInt incx, double[] sy, MutableInt incy) {
        double stemp;
        block7: {
            int nn = n.get();
            int iincx = incx.get();
            int iincy = incy.get();
            stemp = 0.0;
            if (nn <= 0) break block7;
            if (iincx == 1 && iincy == 1) {
                int i;
                int m = nn - 4;
                for (i = 0; i < m; i += 5) {
                    stemp += sx[i] * sy[i] + sx[i + 1] * sy[i + 1] + sx[i + 2] * sy[i + 2] + sx[i + 3] * sy[i + 3] + sx[i + 4] * sy[i + 4];
                }
                while (i < nn) {
                    stemp += sx[i] * sy[i];
                    ++i;
                }
            } else {
                int ix = 0;
                int iy = 0;
                if (iincx < 0) {
                    ix = (1 - nn) * iincx;
                }
                if (iincy < 0) {
                    iy = (1 - nn) * iincy;
                }
                for (int i = 0; i < nn; ++i) {
                    stemp += sx[ix] * sy[iy];
                    ix += iincx;
                    iy += iincy;
                }
            }
        }
        return stemp;
    }

    static int daxpy_(int n, double sa, double[] sx, int incx, double[] sy, int incy) {
        return Blas.daxpy_(new MutableInt(n), new MutableDouble(sa), sx, new MutableInt(incx), sy, new MutableInt(incy));
    }

    static int daxpy_(MutableInt n, MutableDouble sa, double[] sx, MutableInt incx, double[] sy, MutableInt incy) {
        block5: {
            int nn = n.get();
            double ssa = sa.get();
            int iincx = incx.get();
            int iincy = incy.get();
            if (nn <= 0 || ssa == 0.0) break block5;
            if (iincx == 1 && iincy == 1) {
                int i;
                int m = nn - 3;
                for (i = 0; i < m; i += 4) {
                    int n2 = i;
                    sy[n2] = sy[n2] + ssa * sx[i];
                    int n3 = i + 1;
                    sy[n3] = sy[n3] + ssa * sx[i + 1];
                    int n4 = i + 2;
                    sy[n4] = sy[n4] + ssa * sx[i + 2];
                    int n5 = i + 3;
                    sy[n5] = sy[n5] + ssa * sx[i + 3];
                }
                while (i < nn) {
                    int n6 = i;
                    sy[n6] = sy[n6] + ssa * sx[i];
                    ++i;
                }
            } else {
                int ix = iincx >= 0 ? 0 : (1 - nn) * iincx;
                int iy = iincy >= 0 ? 0 : (1 - nn) * iincy;
                for (int i = 0; i < nn; ++i) {
                    int n7 = iy;
                    sy[n7] = sy[n7] + ssa * sx[ix];
                    ix += iincx;
                    iy += iincy;
                }
            }
        }
        return 0;
    }

    static int dscal_(int n, double sa, double[] sx, int incx) {
        return Blas.dscal_(new MutableInt(n), new MutableDouble(sa), sx, new MutableInt(incx));
    }

    static int dscal_(MutableInt n, MutableDouble sa, double[] sx, MutableInt incx) {
        block5: {
            int nn = n.get();
            int iincx = incx.get();
            double ssa = sa.get();
            if (nn <= 0 || iincx <= 0) break block5;
            if (iincx == 1) {
                int i;
                int m = nn - 4;
                for (i = 0; i < m; i += 5) {
                    sx[i] = ssa * sx[i];
                    sx[i + 1] = ssa * sx[i + 1];
                    sx[i + 2] = ssa * sx[i + 2];
                    sx[i + 3] = ssa * sx[i + 3];
                    sx[i + 4] = ssa * sx[i + 4];
                }
                while (i < nn) {
                    sx[i] = ssa * sx[i];
                    ++i;
                }
            } else {
                int nincx = nn * iincx;
                for (int i = 0; i < nincx; i += iincx) {
                    sx[i] = ssa * sx[i];
                }
            }
        }
        return 0;
    }
}

