/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.MutableDouble;

interface Function {
    public double fun(double[] var1);

    public void grad(double[] var1, double[] var2);

    public void Hv(double[] var1, double[] var2);

    public int get_nr_variable();

    public void get_diag_preconditioner(double[] var1);

    default public double linesearch_and_update(double[] w, double[] s, MutableDouble f, double[] g, double alpha) {
        double gTs = 0.0;
        double eta = 0.01;
        int n = this.get_nr_variable();
        int max_num_linesearch = 20;
        double[] w_new = new double[n];
        double fold = f.get();
        for (int i = 0; i < n; ++i) {
            gTs += s[i] * g[i];
        }
        int num_linesearch = 0;
        for (num_linesearch = 0; num_linesearch < max_num_linesearch; ++num_linesearch) {
            for (int i = 0; i < n; ++i) {
                w_new[i] = w[i] + alpha * s[i];
            }
            f.set(this.fun(w_new));
            if (f.get() - fold <= eta * alpha * gTs) break;
            alpha *= 0.5;
        }
        if (num_linesearch >= max_num_linesearch) {
            f.set(fold);
            return 0.0;
        }
        System.arraycopy(w_new, 0, w, 0, n);
        return alpha;
    }
}

