/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison;

import edu.cmu.tetrad.algcomparison.statistic.AdjacencyFn;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyFp;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyFpr;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyTn;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyTp;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyTpr;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecisionCommonEdges;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecallCommonEdges;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadTn;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadTp;
import edu.cmu.tetrad.algcomparison.statistic.AverageDegreeEst;
import edu.cmu.tetrad.algcomparison.statistic.AverageDegreeTrue;
import edu.cmu.tetrad.algcomparison.statistic.BidirectedLatentPrecision;
import edu.cmu.tetrad.algcomparison.statistic.DensityEst;
import edu.cmu.tetrad.algcomparison.statistic.DensityTrue;
import edu.cmu.tetrad.algcomparison.statistic.F1Adj;
import edu.cmu.tetrad.algcomparison.statistic.F1All;
import edu.cmu.tetrad.algcomparison.statistic.F1Arrow;
import edu.cmu.tetrad.algcomparison.statistic.MathewsCorrAdj;
import edu.cmu.tetrad.algcomparison.statistic.MathewsCorrArrow;
import edu.cmu.tetrad.algcomparison.statistic.NumBidirectedEdgesEst;
import edu.cmu.tetrad.algcomparison.statistic.NumCorrectVisibleAncestors;
import edu.cmu.tetrad.algcomparison.statistic.NumDirectedEdges;
import edu.cmu.tetrad.algcomparison.statistic.NumNondirectedEdges;
import edu.cmu.tetrad.algcomparison.statistic.NumPartiallyOrientedEdges;
import edu.cmu.tetrad.algcomparison.statistic.NumUndirectedEdges;
import edu.cmu.tetrad.algcomparison.statistic.NumberOfEdgesEst;
import edu.cmu.tetrad.algcomparison.statistic.NumberOfEdgesTrue;
import edu.cmu.tetrad.algcomparison.statistic.PercentBidirectedEdges;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.algcomparison.statistic.StructuralHammingDistance;
import edu.cmu.tetrad.algcomparison.statistic.TailPrecision;
import edu.cmu.tetrad.algcomparison.statistic.TailRecall;
import edu.cmu.tetrad.algcomparison.statistic.TrueDagPrecisionArrow;
import edu.cmu.tetrad.algcomparison.statistic.TrueDagPrecisionTails;
import edu.cmu.tetrad.algcomparison.statistic.TwoCycleFalseNegative;
import edu.cmu.tetrad.algcomparison.statistic.TwoCycleFalsePositive;
import edu.cmu.tetrad.algcomparison.statistic.TwoCyclePrecision;
import edu.cmu.tetrad.algcomparison.statistic.TwoCycleRecall;
import edu.cmu.tetrad.algcomparison.statistic.TwoCycleTruePositive;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.MisclassificationUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.utils.GraphSearchUtils;
import edu.cmu.tetrad.util.TextTable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompareTwoGraphs {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static String getEdgewiseComparisonString(Graph trueGraph, Graph targetGraph) {
        Edge edge2;
        Edge edge1;
        boolean printStars = false;
        StringBuilder builder = new StringBuilder();
        GraphUtils.GraphComparison comparison = GraphSearchUtils.getGraphComparison(trueGraph, targetGraph);
        List<Edge> edgesAdded = comparison.getEdgesAdded();
        ArrayList<Edge> edgesAdded2 = new ArrayList<Edge>();
        for (Edge e1 : edgesAdded) {
            boolean twoCycle2;
            Node n2;
            Node n1 = e1.getNode1();
            boolean twoCycle1 = trueGraph.getDirectedEdge(n1, n2 = e1.getNode2()) != null && trueGraph.getDirectedEdge(n2, n1) != null;
            boolean bl = twoCycle2 = targetGraph.getDirectedEdge(n1, n2) != null && targetGraph.getDirectedEdge(n2, n1) != null;
            if (twoCycle1 || twoCycle2) continue;
            edgesAdded2.add(e1);
        }
        Collections.sort(edgesAdded2);
        builder.append("\nAdjacencies added (not involving 2-cycles and not reoriented):");
        if (edgesAdded2.isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            for (int i = 0; i < edgesAdded2.size(); ++i) {
                Edge _edge = (Edge)edgesAdded2.get(i);
                builder.append("\n").append(i + 1).append(". ").append(_edge.toString());
            }
        }
        builder.append("\n\nAdjacencies removed:");
        List<Edge> edgesRemoved = comparison.getEdgesRemoved();
        Collections.sort(edgesRemoved);
        if (edgesRemoved.isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            for (int i = 0; i < edgesRemoved.size(); ++i) {
                Edge edge = edgesRemoved.get(i);
                Node node1 = trueGraph.getNode(edge.getNode1().getName());
                Node node2 = trueGraph.getNode(edge.getNode2().getName());
                builder.append("\n").append(i + 1).append(". ").append(edge);
                if (!printStars) continue;
                boolean directedInGraph1 = false;
                if (Edges.isDirectedEdge(edge) && trueGraph.paths().existsSemiDirectedPath(node1, node2)) {
                    directedInGraph1 = true;
                } else if ((Edges.isUndirectedEdge(edge) || Edges.isBidirectedEdge(edge)) && (trueGraph.paths().existsSemiDirectedPath(node1, node2) || trueGraph.paths().existsSemiDirectedPath(node2, node1))) {
                    directedInGraph1 = true;
                }
                if (!directedInGraph1) continue;
                builder.append(" *");
            }
        }
        ArrayList<Edge> edges1 = new ArrayList<Edge>(trueGraph.getEdges());
        ArrayList<Edge> twoCycles = new ArrayList<Edge>();
        ArrayList<Edge> allSingleEdges = new ArrayList<Edge>();
        for (Edge edge : edges1) {
            if (edge.isDirected() && targetGraph.containsEdge(edge) && targetGraph.containsEdge(edge.reverse())) {
                twoCycles.add(edge);
                continue;
            }
            if (!trueGraph.containsEdge(edge)) continue;
            allSingleEdges.add(edge);
        }
        builder.append("\n\nTwo-cycles in true correctly adjacent in estimated");
        Collections.sort(allSingleEdges);
        if (twoCycles.isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            for (int i = 0; i < twoCycles.size(); ++i) {
                Edge adj = (Edge)edges1.get(i);
                builder.append("\n").append(i + 1).append(". ").append(adj).append(" ").append(adj.reverse()).append(" ====> ").append(trueGraph.getEdge(((Edge)twoCycles.get(i)).getNode1(), ((Edge)twoCycles.get(i)).getNode2()));
            }
        }
        ArrayList<Edge> incorrect = new ArrayList<Edge>();
        for (Edge edge : allSingleEdges) {
            Edge edge22;
            Edge edge3 = trueGraph.getEdge(edge.getNode1(), edge.getNode2());
            if (edge3.equals(edge22 = targetGraph.getEdge(edge.getNode1(), edge.getNode2()))) continue;
            incorrect.add(edge);
        }
        builder.append("\n\nEdges incorrectly oriented");
        if (incorrect.isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            int j1 = 0;
            Collections.sort(incorrect);
            for (Edge edge : incorrect) {
                edge1 = trueGraph.getEdge(edge.getNode1(), edge.getNode2());
                edge2 = targetGraph.getEdge(edge.getNode1(), edge.getNode2());
                if (edge1 == null || edge2 == null) continue;
                builder.append("\n").append(++j1).append(". ").append(edge1).append(" ====> ").append(edge2);
            }
        }
        builder.append("\n\nEdges correctly oriented");
        ArrayList<Edge> correct = new ArrayList<Edge>();
        for (Edge edge : allSingleEdges) {
            edge1 = trueGraph.getEdge(edge.getNode1(), edge.getNode2());
            if (!edge1.equals(edge2 = targetGraph.getEdge(edge.getNode1(), edge.getNode2()))) continue;
            correct.add(edge1);
        }
        if (correct.isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            Collections.sort(correct);
            boolean bl = false;
            for (Edge edge : correct) {
                void var13_30;
                builder.append("\n").append((int)(++var13_30)).append(". ").append(edge);
            }
        }
        return builder.toString();
    }

    public static String getStatsListTable(Graph trueGraph, Graph targetGraph) {
        return CompareTwoGraphs.getStatsListTable(trueGraph, targetGraph, null);
    }

    public static String getStatsListTable(Graph trueGraph, Graph targetGraph, DataModel dataModel) {
        Graph _targetGraph = GraphUtils.replaceNodes(targetGraph, trueGraph.getNodes());
        List<Statistic> statistics = CompareTwoGraphs.statistics();
        TextTable table = new TextTable(statistics.size(), 3);
        DecimalFormat nf = new DecimalFormat("0.###");
        ArrayList<String> abbr = new ArrayList<String>();
        ArrayList<String> desc = new ArrayList<String>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (Statistic statistic : statistics) {
            try {
                values.add(statistic.getValue(trueGraph, _targetGraph, dataModel));
                abbr.add(statistic.getAbbreviation());
                desc.add(statistic.getDescription());
            }
            catch (Exception exception) {}
        }
        for (int i = 0; i < abbr.size(); ++i) {
            double value = (Double)values.get(i);
            table.setToken(i, 1, Double.isNaN(value) ? "-" : "" + nf.format(value));
            table.setToken(i, 0, (String)abbr.get(i));
            table.setToken(i, 2, (String)desc.get(i));
        }
        table.setJustification(0);
        return table.toString();
    }

    private static List<Statistic> statistics() {
        ArrayList<Statistic> statistics = new ArrayList<Statistic>();
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new ArrowheadPrecisionCommonEdges());
        statistics.add(new ArrowheadRecallCommonEdges());
        statistics.add(new AdjacencyTn());
        statistics.add(new AdjacencyTp());
        statistics.add(new AdjacencyTpr());
        statistics.add(new AdjacencyFpr());
        statistics.add(new AdjacencyFn());
        statistics.add(new AdjacencyFp());
        statistics.add(new AdjacencyFn());
        statistics.add(new ArrowheadTn());
        statistics.add(new ArrowheadTp());
        statistics.add(new F1Adj());
        statistics.add(new F1All());
        statistics.add(new F1Arrow());
        statistics.add(new MathewsCorrAdj());
        statistics.add(new MathewsCorrArrow());
        statistics.add(new NumberOfEdgesEst());
        statistics.add(new NumberOfEdgesTrue());
        statistics.add(new NumCorrectVisibleAncestors());
        statistics.add(new PercentBidirectedEdges());
        statistics.add(new TailPrecision());
        statistics.add(new TailRecall());
        statistics.add(new TwoCyclePrecision());
        statistics.add(new TwoCycleRecall());
        statistics.add(new TwoCycleFalsePositive());
        statistics.add(new TwoCycleFalseNegative());
        statistics.add(new TwoCycleTruePositive());
        statistics.add(new AverageDegreeEst());
        statistics.add(new AverageDegreeTrue());
        statistics.add(new DensityEst());
        statistics.add(new DensityTrue());
        statistics.add(new StructuralHammingDistance());
        statistics.add(new NumDirectedEdges());
        statistics.add(new NumUndirectedEdges());
        statistics.add(new NumPartiallyOrientedEdges());
        statistics.add(new NumNondirectedEdges());
        statistics.add(new NumBidirectedEdgesEst());
        statistics.add(new TrueDagPrecisionTails());
        statistics.add(new TrueDagPrecisionArrow());
        statistics.add(new BidirectedLatentPrecision());
        return statistics;
    }

    @NotNull
    public static String getMisclassificationTable(Graph trueGraph, Graph targetGraph) {
        return "Edge Misclassification Table:\n" + MisclassificationUtils.edgeMisclassifications(targetGraph, trueGraph) + "\n\nEndpoint Misclassification Table:\n\n" + MisclassificationUtils.endpointMisclassification(targetGraph, trueGraph);
    }
}

