/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.ExternalAlgorithm;
import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.independence.FisherZ;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.BdeuScore;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.simulation.Simulation;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.ParameterColumn;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.HasParameterValues;
import edu.cmu.tetrad.algcomparison.utils.HasParameters;
import edu.cmu.tetrad.algcomparison.utils.TakesExternalGraph;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.DataWriter;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.simulation.LoadDataAndGraphs;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphSaveLoadUtils;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.CombinationGenerator;
import edu.cmu.tetrad.util.Experimental;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.ParamDescription;
import edu.cmu.tetrad.util.ParamDescriptions;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.Params;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TextTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.math3.util.FastMath;
import org.reflections.Reflections;

public class Comparison {
    private boolean parallelized = false;
    private boolean[] graphTypeUsed;
    private PrintStream out;
    private boolean tabDelimitedTables;
    private boolean saveGraphs;
    private boolean showSimulationIndices;
    private boolean showAlgorithmIndices;
    private boolean showUtilities;
    private boolean sortByUtility;
    private String dataPath;
    private String resultsPath;
    private boolean saveData = false;
    private boolean saveCPDAGs = false;
    private boolean savePags = false;
    private ComparisonGraph comparisonGraph = ComparisonGraph.true_DAG;

    public void setParallelized(boolean parallelized) {
        this.parallelized = parallelized;
    }

    public void compareFromFiles(String filePath, Algorithms algorithms, Statistics statistics, Parameters parameters) {
        this.compareFromFiles(filePath, filePath, algorithms, statistics, parameters);
    }

    public void compareFromFiles(String dataPath, String resultsPath, Algorithms algorithms, Statistics statistics, Parameters parameters) {
        for (Algorithm algorithm : algorithms.getAlgorithms()) {
            if (!(algorithm instanceof ExternalAlgorithm)) continue;
            throw new IllegalArgumentException("Not expecting any implementations of ExternalAlgorithm here.");
        }
        this.dataPath = dataPath;
        this.resultsPath = resultsPath;
        Simulations simulations = new Simulations();
        File file = new File(this.dataPath, "save");
        File[] dirs = file.listFiles();
        if (dirs == null) {
            throw new NullPointerException("No files in " + file.getAbsolutePath());
        }
        int count = 0;
        for (File dir : dirs) {
            if (dir.getName().contains("DS_Store")) continue;
            ++count;
        }
        for (int i = 1; i <= count; ++i) {
            File _dir = new File(dataPath, "save/" + i);
            simulations.add(new LoadDataAndGraphs(_dir.getAbsolutePath()));
        }
        this.compareFromSimulations(resultsPath, simulations, algorithms, statistics, parameters);
    }

    public void generateReportFromExternalAlgorithms(String dataPath, String resultsPath, Algorithms algorithms, Statistics statistics, Parameters parameters) {
        this.generateReportFromExternalAlgorithms(dataPath, resultsPath, "Comparison.txt", algorithms, statistics, parameters);
    }

    public void generateReportFromExternalAlgorithms(String dataPath, String resultsPath, String outputFileName, Algorithms algorithms, Statistics statistics, Parameters parameters) {
        this.saveGraphs = false;
        this.dataPath = dataPath;
        this.resultsPath = resultsPath;
        for (Algorithm algorithm : algorithms.getAlgorithms()) {
            if (algorithm instanceof ExternalAlgorithm) continue;
            throw new IllegalArgumentException("Expecting all algorithms to implement ExternalAlgorithm.");
        }
        Simulations simulations = new Simulations();
        File file = new File(this.dataPath, "save");
        File[] dirs = file.listFiles();
        if (dirs == null) {
            throw new NullPointerException("No files in " + file.getAbsolutePath());
        }
        int count = 0;
        for (File dir : dirs) {
            if (dir.getName().contains("DS_Store")) continue;
            ++count;
        }
        for (int i = 1; i <= count; ++i) {
            File _dir = new File(dataPath, "save/" + i);
            simulations.add(new LoadDataAndGraphs(_dir.getAbsolutePath()));
        }
        this.compareFromSimulations(this.resultsPath, simulations, outputFileName, algorithms, statistics, parameters);
    }

    public void compareFromSimulations(String resultsPath, Simulations simulations, Algorithms algorithms, Statistics statistics, Parameters parameters) {
        this.compareFromSimulations(resultsPath, simulations, "Comparison.txt", algorithms, statistics, parameters);
    }

    public void compareFromSimulations(String resultsPath, Simulations simulations, String outputFileName, Algorithms algorithms, Statistics statistics, Parameters parameters) {
        int u;
        int[] newOrder;
        double[][][][] dArray;
        this.resultsPath = resultsPath;
        PrintStream stdout = (PrintStream)parameters.get("printStream", System.out);
        try {
            File dir = new File(resultsPath);
            dir.mkdirs();
            File file = new File(dir, outputFileName);
            this.out = new PrintStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.out.println(new Date());
        ArrayList<SimulationWrapper> simulationWrappers = new ArrayList<SimulationWrapper>();
        int numRuns = parameters.getInt("numRuns");
        for (Simulation simulation : simulations.getSimulations()) {
            List<SimulationWrapper> list = this.getSimulationWrappers(simulation, parameters);
            for (SimulationWrapper wrapper : list) {
                wrapper.createData(wrapper.getSimulationSpecificParameters(), true);
                simulationWrappers.add(wrapper);
            }
        }
        ArrayList<AlgorithmWrapper> algorithmWrappers = new ArrayList<AlgorithmWrapper>();
        for (Algorithm algorithm : algorithms.getAlgorithms()) {
            int[] choice;
            ArrayList<Integer> _dims = new ArrayList<Integer>();
            ArrayList varyingParameters = new ArrayList();
            ArrayList<String> parameters1 = new ArrayList<String>(Params.getAlgorithmParameters(algorithm));
            parameters1.addAll(Params.getTestParameters(algorithm));
            parameters1.addAll(Params.getScoreParameters(algorithm));
            for (String name : parameters1) {
                if (parameters.getNumValues(name) <= 1) continue;
                _dims.add(parameters.getNumValues(name));
                varyingParameters.add(name);
            }
            if (varyingParameters.isEmpty()) {
                algorithmWrappers.add(new AlgorithmWrapper(algorithm, parameters));
                continue;
            }
            int[] dims = new int[_dims.size()];
            for (int i = 0; i < _dims.size(); ++i) {
                dims[i] = (Integer)_dims.get(i);
            }
            CombinationGenerator gen = new CombinationGenerator(dims);
            while ((choice = gen.next()) != null) {
                AlgorithmWrapper wrapper = new AlgorithmWrapper(algorithm, parameters);
                for (int h = 0; h < dims.length; ++h) {
                    String parameter = (String)varyingParameters.get(h);
                    Object[] values = parameters.getValues(parameter);
                    Object value = values[choice[h]];
                    wrapper.setValue(parameter, value);
                }
                algorithmWrappers.add(wrapper);
            }
        }
        ArrayList<AlgorithmSimulationWrapper> arrayList = new ArrayList<AlgorithmSimulationWrapper>();
        for (SimulationWrapper simulationWrapper : simulationWrappers) {
            for (AlgorithmWrapper algorithmWrapper : algorithmWrappers) {
                DataType algDataType = algorithmWrapper.getDataType();
                DataType simDataType = simulationWrapper.getDataType();
                if (algDataType != DataType.Mixed && algDataType != simDataType) {
                    stdout.println("Type mismatch: " + algorithmWrapper.getDescription() + " / " + simulationWrapper.getDescription());
                }
                if (algorithmWrapper.getAlgorithm() instanceof ExternalAlgorithm) {
                    ExternalAlgorithm external = (ExternalAlgorithm)algorithmWrapper.getAlgorithm();
                    external.setSimIndex(simulationWrappers.indexOf(external.getSimulation()));
                }
                arrayList.add(new AlgorithmSimulationWrapper(algorithmWrapper, simulationWrapper));
            }
        }
        double[][][][] dArrayArray = new double[][][][]{};
        try {
            dArray = this.calcStats(arrayList, algorithmWrappers, simulationWrappers, statistics, numRuns, stdout);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int numTables = dArray.length;
        int numStats = dArray[0][0].length - 1;
        double[][][] statTables = this.calcStatTables(dArray, Mode.Average, numTables, arrayList, numStats, statistics);
        double[] utilities = this.calcUtilities(statistics, arrayList, statTables[0]);
        for (int u2 = 0; u2 < numTables; ++u2) {
            for (int t = 0; t < arrayList.size(); ++t) {
                statTables[u2][t][numStats] = utilities[t];
            }
        }
        if (this.isSortByUtility()) {
            newOrder = this.sort(arrayList, utilities);
        } else {
            newOrder = new int[arrayList.size()];
            for (int q = 0; q < arrayList.size(); ++q) {
                newOrder[q] = q;
            }
        }
        this.out.println();
        this.out.println("Simulations:");
        this.out.println();
        int i = 0;
        for (SimulationWrapper simulation : simulationWrappers) {
            this.out.print("Simulation " + ++i + ": ");
            this.out.println(simulation.getDescription());
            this.out.println();
            this.printParameters(simulation.getParameters(), simulation.getSimulationSpecificParameters(), this.out);
            this.out.println();
        }
        this.out.println("Algorithms:");
        this.out.println();
        for (int t = 0; t < arrayList.size(); ++t) {
            AlgorithmSimulationWrapper wrapper = (AlgorithmSimulationWrapper)arrayList.get(t);
            if (wrapper.getSimulationWrapper() != simulationWrappers.get(0)) continue;
            this.out.println(t + 1 + ". " + wrapper.getAlgorithmWrapper().getDescription());
        }
        this.out.println();
        this.out.println("Statistics:");
        this.out.println();
        for (Statistic stat : statistics.getStatistics()) {
            this.out.println(stat.getAbbreviation() + " = " + stat.getDescription());
        }
        this.out.println();
        if (this.isSortByUtility()) {
            this.out.println();
            this.out.println("Sorting by utility, high to low.");
        }
        if (this.isShowUtilities()) {
            this.out.println();
            this.out.println("Weighting of statistics:");
            this.out.println();
            this.out.println("U = ");
            for (Statistic stat : statistics.getStatistics()) {
                String statName = stat.getAbbreviation();
                double weight = statistics.getWeight(stat);
                if (weight == 0.0) continue;
                this.out.println("    " + weight + " * f(" + statName + ")");
            }
            this.out.println();
            this.out.println("...normed to range between 0 and 1.");
            this.out.println();
            this.out.println("Note that f for each statistic is a function that maps the statistic to the ");
            this.out.println("interval [0, 1], with higher being better.");
        }
        this.out.println("Graphs are being compared to the " + this.comparisonGraph.toString().replace("_", " ") + ".");
        this.out.println("All statistics are individually summarized over " + numRuns + " runs using the indicated statistic.");
        this.out.println();
        statTables = this.calcStatTables(dArray, Mode.Average, numTables, arrayList, numStats, statistics);
        for (u = 0; u < numTables; ++u) {
            for (int t = 0; t < arrayList.size(); ++t) {
                statTables[u][t][numStats] = utilities[t];
            }
        }
        this.printStats(statTables, statistics, Mode.Average, newOrder, arrayList, algorithmWrappers, simulationWrappers, utilities, parameters);
        statTables = this.calcStatTables(dArray, Mode.StandardDeviation, numTables, arrayList, numStats, statistics);
        for (u = 0; u < numTables; ++u) {
            for (int t = 0; t < arrayList.size(); ++t) {
                statTables[u][t][numStats] = utilities[t];
            }
        }
        this.printStats(statTables, statistics, Mode.StandardDeviation, newOrder, arrayList, algorithmWrappers, simulationWrappers, utilities, parameters);
        statTables = this.calcStatTables(dArray, Mode.MinValue, numTables, arrayList, numStats, statistics);
        for (u = 0; u < numTables; ++u) {
            for (int t = 0; t < arrayList.size(); ++t) {
                statTables[u][t][numStats] = utilities[t];
            }
        }
        this.printStats(statTables, statistics, Mode.MinValue, newOrder, arrayList, algorithmWrappers, simulationWrappers, utilities, parameters);
        statTables = this.calcStatTables(dArray, Mode.MaxValue, numTables, arrayList, numStats, statistics);
        for (u = 0; u < numTables; ++u) {
            for (int t = 0; t < arrayList.size(); ++t) {
                statTables[u][t][numStats] = utilities[t];
            }
        }
        this.printStats(statTables, statistics, Mode.MaxValue, newOrder, arrayList, algorithmWrappers, simulationWrappers, utilities, parameters);
        statTables = this.calcStatTables(dArray, Mode.MedianValue, numTables, arrayList, numStats, statistics);
        for (u = 0; u < numTables; ++u) {
            for (int t = 0; t < arrayList.size(); ++t) {
                statTables[u][t][numStats] = utilities[t];
            }
        }
        this.printStats(statTables, statistics, Mode.MedianValue, newOrder, arrayList, algorithmWrappers, simulationWrappers, utilities, parameters);
        for (int i2 = 0; i2 < simulations.getSimulations().size(); ++i2) {
            this.saveToFiles(resultsPath + "/simulation" + (i2 + 1), simulations.getSimulations().get(i2), parameters);
        }
        this.out.close();
    }

    public void saveToFiles(String dataPath, Simulation simulation, Parameters parameters) {
        File dir0 = new File(dataPath);
        File dir = new File(dir0, "save");
        this.deleteFilesThenDirectory(dir);
        try {
            List<SimulationWrapper> simulationWrappers = this.getSimulationWrappers(simulation, parameters);
            int index = 0;
            for (SimulationWrapper simulationWrapper : simulationWrappers) {
                for (String param : simulationWrapper.getParameters()) {
                    parameters.set(param, simulationWrapper.getValue(param));
                }
                if (simulation.getNumDataModels() == 0) {
                    simulationWrapper.createData(simulationWrapper.getSimulationSpecificParameters(), true);
                }
                File subdir = dir;
                if (simulationWrappers.size() > 1) {
                    subdir = new File(dir, "" + ++index);
                    subdir.mkdirs();
                }
                File dir1 = new File(subdir, "graph");
                File dir2 = new File(subdir, "data");
                dir1.mkdirs();
                dir2.mkdirs();
                File dir3 = null;
                if (this.isSaveCPDAGs()) {
                    dir3 = new File(subdir, "cpdags");
                    dir3.mkdirs();
                }
                File dir4 = null;
                if (this.isSavePags()) {
                    dir4 = new File(subdir, "pags");
                    dir4.mkdirs();
                }
                for (int j = 0; j < simulationWrapper.getNumDataModels(); ++j) {
                    File file2 = new File(dir1, "graph." + (j + 1) + ".txt");
                    Graph graph = simulationWrapper.getTrueGraph(j);
                    GraphSaveLoadUtils.saveGraph(graph, file2, false);
                    if (this.isSaveData()) {
                        File file = new File(dir2, "data." + (j + 1) + ".txt");
                        FileWriter out = new FileWriter(file);
                        DataModel dataModel = simulationWrapper.getDataModel(j);
                        DataWriter.writeRectangularData((DataSet)dataModel, out, '\t');
                        ((Writer)out).close();
                    }
                    if (this.isSaveCPDAGs()) {
                        File file3 = new File(dir3, "cpdag." + (j + 1) + ".txt");
                        GraphSaveLoadUtils.saveGraph(GraphTransforms.cpdagForDag(graph), file3, false);
                    }
                    if (!this.isSavePags()) continue;
                    File file4 = new File(dir4, "pag." + (j + 1) + ".txt");
                    GraphSaveLoadUtils.saveGraph(GraphTransforms.dagToPag(graph), file4, false);
                }
                PrintStream out = new PrintStream(Files.newOutputStream(new File(subdir, "parameters.txt").toPath(), new OpenOption[0]));
                out.println(simulationWrapper.getDescription());
                out.println(simulationWrapper.getSimulationSpecificParameters());
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveToFilesSingleSimulation(String dataPath, Simulation simulation, Parameters parameters) {
        File dir0 = new File(dataPath);
        File dir = new File(dir0, "save");
        this.deleteFilesThenDirectory(dir);
        dir.mkdirs();
        try {
            PrintStream _out = new PrintStream(Files.newOutputStream(new File(dir, "parameters.txt").toPath(), new OpenOption[0]));
            _out.println(simulation.getDescription());
            _out.println(parameters);
            _out.close();
            int numDataSets = simulation.getNumDataModels();
            if (numDataSets <= 0) {
                File dir1 = new File(dir, "graph");
                File dir2 = new File(dir, "data");
                dir1.mkdirs();
                dir2.mkdirs();
                return;
            }
            File dir1 = new File(dir, "graph");
            File dir2 = new File(dir, "data");
            dir1.mkdirs();
            dir2.mkdirs();
            File dir3 = null;
            if (this.isSaveCPDAGs()) {
                dir3 = new File(dir, "cpdags");
                dir3.mkdirs();
            }
            File dir4 = null;
            if (this.isSavePags()) {
                dir4 = new File(dir, "pags");
                dir4.mkdirs();
            }
            for (int j = 0; j < simulation.getNumDataModels(); ++j) {
                File file2 = new File(dir1, "graph." + (j + 1) + ".txt");
                Graph graph = simulation.getTrueGraph(j);
                GraphSaveLoadUtils.saveGraph(graph, file2, false);
                File file = new File(dir2, "data." + (j + 1) + ".txt");
                FileWriter out = new FileWriter(file);
                DataModel dataModel = simulation.getDataModel(j);
                DataWriter.writeRectangularData((DataSet)dataModel, out, '\t');
                ((Writer)out).close();
                if (this.isSaveCPDAGs()) {
                    File file3 = new File(dir3, "cpdag." + (j + 1) + ".txt");
                    GraphSaveLoadUtils.saveGraph(GraphTransforms.cpdagForDag(graph), file3, false);
                }
                if (!this.isSavePags()) continue;
                File file4 = new File(dir4, "pag." + (j + 1) + ".txt");
                GraphSaveLoadUtils.saveGraph(GraphTransforms.dagToPag(graph), file4, false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void configuration(String path) {
        try {
            Algorithm algorithm;
            Constructor<?>[] constructors;
            new File(path).mkdirs();
            PrintStream out = new PrintStream(Files.newOutputStream(new File(path, "Configuration.txt").toPath(), new OpenOption[0]));
            Parameters allParams = new Parameters();
            ArrayList<Class> algorithms = new ArrayList<Class>(this.getClasses(Algorithm.class));
            ArrayList<Class> statistics = new ArrayList<Class>(this.getClasses(Statistic.class));
            ArrayList<Class> independenceWrappers = new ArrayList<Class>(this.getClasses(IndependenceWrapper.class));
            ArrayList<Class> scoreWrappers = new ArrayList<Class>(this.getClasses(ScoreWrapper.class));
            ArrayList<Class> simulations = new ArrayList<Class>(this.getClasses(Simulation.class));
            out.println("Available Algorithms:");
            out.println();
            out.println("Algorithms that take an independence test (using an example independence test):");
            out.println();
            for (Class clazz : new ArrayList<Class>(algorithms)) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != IndependenceWrapper.class) continue;
                    algorithm = (Algorithm)constructor.newInstance(FisherZ.class.newInstance());
                    out.println(clazz.getSimpleName() + ": " + algorithm.getDescription());
                    if (HasParameters.class.isAssignableFrom(clazz)) {
                        this.printParameters(algorithm.getParameters(), allParams, out);
                    }
                    if (!TakesExternalGraph.class.isAssignableFrom(clazz)) continue;
                    out.println("\t" + clazz.getSimpleName() + " can take an external graph from some other algorithm as input");
                }
            }
            out.println();
            out.println("Algorithms that take a score (using an example score):");
            out.println();
            for (Class clazz : new ArrayList<Class>(algorithms)) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != ScoreWrapper.class) continue;
                    algorithm = (Algorithm)constructor.newInstance(BdeuScore.class.newInstance());
                    out.println(clazz.getSimpleName() + ": " + algorithm.getDescription());
                    if (!HasParameters.class.isAssignableFrom(clazz)) continue;
                    this.printParameters(algorithm.getParameters(), allParams, out);
                }
            }
            out.println();
            out.println("Algorithms with blank constructor:");
            out.println();
            for (Class clazz : new ArrayList<Class>(algorithms)) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    algorithm = (Algorithm)constructor.newInstance(new Object[0]);
                    out.println(clazz.getSimpleName() + ": " + algorithm.getDescription());
                    if (!HasParameters.class.isAssignableFrom(clazz)) continue;
                    this.printParameters(algorithm.getParameters(), allParams, out);
                }
            }
            out.println();
            out.println("Available Statistics:");
            out.println();
            for (Class<Object> clazz : statistics) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    Statistic statistic = (Statistic)constructor.newInstance(new Object[0]);
                    out.println(clazz.getSimpleName() + ": " + statistic.getDescription());
                }
            }
            out.println();
            out.println("Available Independence Tests:");
            out.println();
            for (Class<Object> clazz : independenceWrappers) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    IndependenceWrapper independence = (IndependenceWrapper)constructor.newInstance(new Object[0]);
                    out.println(clazz.getSimpleName() + ": " + independence.getDescription());
                    if (!HasParameters.class.isAssignableFrom(clazz)) continue;
                    this.printParameters(independence.getParameters(), allParams, out);
                }
            }
            out.println();
            out.println("Available Scores:");
            out.println();
            for (Class<Object> clazz : scoreWrappers) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    ScoreWrapper score = (ScoreWrapper)constructor.newInstance(new Object[0]);
                    out.println(clazz.getSimpleName() + ": " + score.getDescription());
                    if (!HasParameters.class.isAssignableFrom(clazz)) continue;
                    this.printParameters(score.getParameters(), allParams, out);
                }
            }
            out.println();
            out.println("Available Simulations:");
            out.println();
            for (Class<Object> clazz : simulations) {
                if (Experimental.class.isAssignableFrom(clazz)) continue;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    Simulation simulation = (Simulation)constructor.newInstance(new Object[0]);
                    out.println(clazz.getSimpleName() + ": " + simulation.getDescription());
                    if (!HasParameters.class.isAssignableFrom(clazz)) continue;
                    this.printParameters(simulation.getParameters(), allParams, out);
                }
            }
            out.println();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Class> getClasses(Class type) {
        Reflections reflections = new Reflections(new Object[0]);
        Set allClasses = reflections.getSubTypesOf(type);
        return new ArrayList<Class>(allClasses);
    }

    private List<SimulationWrapper> getSimulationWrappers(Simulation simulation, Parameters parameters) {
        ArrayList<SimulationWrapper> simulationWrappers = new ArrayList<SimulationWrapper>();
        ArrayList<Integer> _dims = new ArrayList<Integer>();
        ArrayList<String> varyingParams = new ArrayList<String>();
        List<String> parameters1 = simulation.getParameters();
        for (String param : parameters1) {
            int numValues = parameters.getNumValues(param);
            if (numValues <= 1) continue;
            _dims.add(numValues);
            varyingParams.add(param);
        }
        if (varyingParams.isEmpty()) {
            simulationWrappers.add(new SimulationWrapper(simulation, parameters));
        } else {
            int[] choice;
            int[] dims = new int[_dims.size()];
            for (int i = 0; i < _dims.size(); ++i) {
                dims[i] = (Integer)_dims.get(i);
            }
            CombinationGenerator gen = new CombinationGenerator(dims);
            while ((choice = gen.next()) != null) {
                SimulationWrapper wrapper = new SimulationWrapper(simulation, parameters);
                for (int h = 0; h < dims.length; ++h) {
                    String param = (String)varyingParams.get(h);
                    Object[] values = parameters.getValues(param);
                    Object value = values[choice[h]];
                    wrapper.setValue(param, value);
                }
                simulationWrappers.add(wrapper);
            }
        }
        return simulationWrappers;
    }

    private double[][][][] calcStats(List<AlgorithmSimulationWrapper> algorithmSimulationWrappers, List<AlgorithmWrapper> algorithmWrappers, List<SimulationWrapper> simulationWrappers, Statistics statistics, int numRuns, PrintStream stdout) throws Exception {
        int numGraphTypes = 4;
        this.graphTypeUsed = new boolean[4];
        double[][][][] allStats = new double[4][algorithmSimulationWrappers.size()][statistics.size() + 1][numRuns];
        ArrayList<AlgorithmTask> tasks = new ArrayList<AlgorithmTask>();
        int index = 0;
        for (int algSimIndex = 0; algSimIndex < algorithmSimulationWrappers.size(); ++algSimIndex) {
            for (int i = 0; i < numRuns; ++i) {
                AlgorithmSimulationWrapper algorithmSimulationWrapper = algorithmSimulationWrappers.get(algSimIndex);
                Run run = new Run(algSimIndex, i, index++, algorithmSimulationWrapper);
                AlgorithmTask task = new AlgorithmTask(algorithmSimulationWrappers, algorithmWrappers, simulationWrappers, statistics, 4, allStats, run, stdout);
                tasks.add(task);
            }
        }
        if (this.parallelized) {
            ForkJoinPool pool = (ForkJoinPool)Executors.newWorkStealingPool(Runtime.getRuntime().availableProcessors());
            pool.invokeAll(tasks);
            pool.shutdown();
        } else {
            for (Callable callable : tasks) {
                callable.call();
            }
        }
        return allStats;
    }

    public boolean isShowSimulationIndices() {
        return this.showSimulationIndices;
    }

    public void setShowSimulationIndices(boolean showSimulationIndices) {
        this.showSimulationIndices = showSimulationIndices;
    }

    public boolean isShowAlgorithmIndices() {
        return this.showAlgorithmIndices;
    }

    public void setShowAlgorithmIndices(boolean showAlgorithmIndices) {
        this.showAlgorithmIndices = showAlgorithmIndices;
    }

    public boolean isShowUtilities() {
        return this.showUtilities;
    }

    public void setShowUtilities(boolean showUtilities) {
        this.showUtilities = showUtilities;
    }

    public boolean isSortByUtility() {
        return this.sortByUtility;
    }

    public void setSortByUtility(boolean sortByUtility) {
        this.sortByUtility = sortByUtility;
    }

    public boolean isSaveCPDAGs() {
        return this.saveCPDAGs;
    }

    public void setSaveCPDAGs(boolean saveCPDAGs) {
        this.saveCPDAGs = saveCPDAGs;
    }

    public boolean isSavePags() {
        return this.savePags;
    }

    public void setSavePags(boolean savePags) {
        this.savePags = savePags;
    }

    public boolean isSaveData() {
        return this.saveData;
    }

    public void setSaveData(boolean saveData) {
        this.saveData = saveData;
    }

    public boolean isTabDelimitedTables() {
        return this.tabDelimitedTables;
    }

    public void setTabDelimitedTables(boolean tabDelimitedTables) {
        this.tabDelimitedTables = tabDelimitedTables;
    }

    public boolean isSaveGraphs() {
        return this.saveGraphs;
    }

    public void setSaveGraphs(boolean saveGraphs) {
        this.saveGraphs = saveGraphs;
    }

    public ComparisonGraph getComparisonGraph() {
        return this.comparisonGraph;
    }

    public void setComparisonGraph(ComparisonGraph comparisonGraph) {
        if (comparisonGraph == null) {
            throw new NullPointerException("Null compare graph.");
        }
        this.comparisonGraph = comparisonGraph;
    }

    private void printParameters(List<String> names, Parameters parameters, PrintStream out) {
        out.println("Comparison.printParameters");
        ParamDescriptions descriptions = ParamDescriptions.getInstance();
        for (String name : names) {
            ParamDescription description = descriptions.get(name);
            Serializable defaultValue = description.getDefaultValue();
            Object value = parameters.get(name);
            if (defaultValue instanceof Double) {
                out.println(description.getShortDescription() + " = " + value.toString());
                continue;
            }
            if (defaultValue instanceof Integer) {
                out.println(description.getShortDescription() + " = " + value.toString());
                continue;
            }
            if (defaultValue instanceof Boolean) {
                boolean b = (Boolean)value;
                out.println(description.getShortDescription() + " = " + (b ? "Yes" : "No"));
                continue;
            }
            if (!(defaultValue instanceof String)) continue;
            out.println(description.getShortDescription() + " = " + value);
        }
    }

    private void deleteFilesThenDirectory(File dir) {
        if (dir == null) {
            return;
        }
        String[] entries = dir.list();
        if (entries == null) {
            return;
        }
        for (String s : entries) {
            File currentFile = new File(dir.getPath(), s);
            if (currentFile.isDirectory()) {
                this.deleteFilesThenDirectory(currentFile);
                continue;
            }
            currentFile.delete();
        }
        dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun(List<AlgorithmSimulationWrapper> algorithmSimulationWrappers, List<AlgorithmWrapper> algorithmWrappers, List<SimulationWrapper> simulationWrappers, Statistics statistics, int numGraphTypes, double[][][][] allStats, Run run, PrintStream stdout) {
        Graph graphOut;
        stdout.println();
        stdout.println("Run " + (run.getRunIndex() + 1));
        stdout.println();
        AlgorithmSimulationWrapper algorithmSimulationWrapper = algorithmSimulationWrappers.get(run.getAlgSimIndex());
        AlgorithmWrapper algorithmWrapper = algorithmSimulationWrapper.getAlgorithmWrapper();
        SimulationWrapper simulationWrapper = algorithmSimulationWrapper.getSimulationWrapper();
        DataModel data = simulationWrapper.getDataModel(run.getRunIndex());
        Graph trueGraph = simulationWrapper.getTrueGraph(run.getRunIndex());
        stdout.println(run.getAlgSimIndex() + 1 + ". " + algorithmWrapper.getDescription() + " simulationWrapper: " + simulationWrapper.getDescription());
        long start = MillisecondTimes.cpuTimeMillis();
        try {
            Algorithm algorithm = algorithmWrapper.getAlgorithm();
            Simulation simulation = simulationWrapper.getSimulation();
            if (algorithm instanceof HasKnowledge && simulation instanceof HasKnowledge) {
                ((HasKnowledge)((Object)algorithm)).setKnowledge(((HasKnowledge)((Object)simulation)).getKnowledge());
            }
            if (algorithmWrapper.getAlgorithm() instanceof ExternalAlgorithm) {
                ExternalAlgorithm external = (ExternalAlgorithm)algorithmWrapper.getAlgorithm();
                external.setSimulation(simulationWrapper.getSimulation());
                external.setPath(this.resultsPath);
                external.setSimIndex(simulationWrappers.indexOf(simulationWrapper));
            }
            if (algorithm instanceof MultiDataSetAlgorithm) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                int numDataModels = simulationWrapper.getSimulation().getNumDataModels();
                for (int i = 0; i < numDataModels; ++i) {
                    indices.add(i);
                }
                RandomUtil.shuffle(indices);
                ArrayList<DataModel> dataModels = new ArrayList<DataModel>();
                int randomSelectionSize = algorithmWrapper.getAlgorithmSpecificParameters().getInt("randomSelectionSize");
                for (int i = 0; i < FastMath.min(numDataModels, randomSelectionSize); ++i) {
                    dataModels.add(simulationWrapper.getSimulation().getDataModel((Integer)indices.get(i)));
                }
                Parameters _params = algorithmWrapper.getAlgorithmSpecificParameters();
                graphOut = ((MultiDataSetAlgorithm)algorithm).search(dataModels, _params);
            } else {
                boolean copyData = true;
                DataModel dataModel = copyData ? data.copy() : data;
                Parameters _params = algorithmWrapper.getAlgorithmSpecificParameters();
                graphOut = algorithm.search(dataModel, _params);
            }
        }
        catch (Exception e) {
            stdout.println("Could not run " + algorithmWrapper.getDescription());
            e.printStackTrace();
            return;
        }
        int simIndex = simulationWrappers.indexOf(simulationWrapper) + 1;
        int algIndex = algorithmWrappers.indexOf(algorithmWrapper) + 1;
        long stop = MillisecondTimes.cpuTimeMillis();
        long elapsed = stop - start;
        this.saveGraph(this.resultsPath, graphOut, run.getRunIndex(), simIndex, algorithmWrapper, elapsed, stdout);
        if (trueGraph != null) {
            graphOut = GraphUtils.replaceNodes(graphOut, trueGraph.getNodes());
        }
        if (algorithmWrapper.getAlgorithm() instanceof ExternalAlgorithm) {
            ExternalAlgorithm extAlg = (ExternalAlgorithm)algorithmWrapper.getAlgorithm();
            extAlg.setSimIndex(simulationWrappers.indexOf(simulationWrapper));
            extAlg.setSimulation(simulationWrapper.getSimulation());
            extAlg.setPath(this.resultsPath);
            elapsed = extAlg.getElapsedTime(data, simulationWrapper.getSimulationSpecificParameters());
        }
        Comparison comparison = this;
        synchronized (comparison) {
            Graph comparisonGraph;
            Graph[] est = new Graph[numGraphTypes];
            if (this.comparisonGraph == ComparisonGraph.true_DAG) {
                comparisonGraph = new EdgeListGraph(trueGraph);
            } else if (this.comparisonGraph == ComparisonGraph.CPDAG_of_the_true_DAG) {
                EdgeListGraph dag = new EdgeListGraph(trueGraph);
                comparisonGraph = GraphTransforms.cpdagForDag(dag);
            } else if (this.comparisonGraph == ComparisonGraph.PAG_of_the_true_DAG) {
                comparisonGraph = GraphTransforms.dagToPag(trueGraph);
            } else {
                throw new IllegalArgumentException("Unrecognized graph type.");
            }
            est[0] = new EdgeListGraph(graphOut);
            this.graphTypeUsed[0] = true;
            if (data.isMixed()) {
                est[1] = this.getSubgraph(est[0], true, true, simulationWrapper.getDataModel(run.getRunIndex()));
                est[2] = this.getSubgraph(est[0], true, false, simulationWrapper.getDataModel(run.getRunIndex()));
                est[3] = this.getSubgraph(est[0], false, false, simulationWrapper.getDataModel(run.getRunIndex()));
                this.graphTypeUsed[1] = true;
                this.graphTypeUsed[2] = true;
                this.graphTypeUsed[3] = true;
            }
            Graph[] truth = new Graph[numGraphTypes];
            truth[0] = new EdgeListGraph(comparisonGraph);
            if (data.isMixed()) {
                truth[1] = this.getSubgraph(comparisonGraph, true, true, simulationWrapper.getDataModel(run.getRunIndex()));
                truth[2] = this.getSubgraph(comparisonGraph, true, false, simulationWrapper.getDataModel(run.getRunIndex()));
                truth[3] = this.getSubgraph(comparisonGraph, false, false, simulationWrapper.getDataModel(run.getRunIndex()));
            }
            for (int u = 0; u < numGraphTypes; ++u) {
                if (!this.graphTypeUsed[u]) continue;
                int statIndex = -1;
                for (Statistic _stat : statistics.getStatistics()) {
                    ++statIndex;
                    if (_stat instanceof ParameterColumn) continue;
                    double stat = _stat instanceof ElapsedCpuTime ? (double)elapsed / 1000.0 : _stat.getValue(truth[u], est[u], data);
                    allStats[u][run.getAlgSimIndex()][statIndex][run.getRunIndex()] = stat;
                }
            }
        }
    }

    private void saveGraph(String resultsPath, Graph graph, int i, int simIndex, AlgorithmWrapper algorithmWrapper, long elapsed, PrintStream stdout) {
        if (!this.saveGraphs) {
            return;
        }
        try {
            String description = algorithmWrapper.getDescription().replace(" ", "_");
            File dir = new File(resultsPath, "results/" + description + "/" + simIndex);
            dir.mkdirs();
            File dirElapsed = new File(resultsPath, "elapsed/" + description + "/" + simIndex);
            dirElapsed.mkdirs();
            if (resultsPath == null) {
                throw new IllegalArgumentException("Results path not provided.");
            }
            File file = new File(dir, "graph." + (i + 1) + ".txt");
            File fileElapsed = new File(dirElapsed, "graph." + (i + 1) + ".txt");
            PrintStream out = new PrintStream(file);
            stdout.println("Saving graph to " + file.getAbsolutePath());
            out.println(graph);
            out.close();
            PrintStream outElapsed = new PrintStream(fileElapsed);
            outElapsed.println(elapsed);
            outElapsed.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private String getHeader(int u) {
        String header;
        switch (u) {
            case 0: {
                header = "All edges";
                break;
            }
            case 1: {
                header = "Discrete-discrete";
                break;
            }
            case 2: {
                header = "Discrete-continuous";
                break;
            }
            case 3: {
                header = "Continuous-continuous";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return header;
    }

    private double[][][] calcStatTables(double[][][][] allStats, Mode mode, int numTables, List<AlgorithmSimulationWrapper> wrappers, int numStats, Statistics statistics) {
        double[][][] statTables = new double[numTables][wrappers.size()][numStats + 1];
        for (int u = 0; u < numTables; ++u) {
            for (int i = 0; i < wrappers.size(); ++i) {
                for (int j = 0; j < numStats; ++j) {
                    if (statistics.getStatistics().get(j) instanceof ParameterColumn) {
                        String statName = statistics.getStatistics().get(j).getAbbreviation();
                        SimulationWrapper simulationWrapper = wrappers.get(i).getSimulationWrapper();
                        AlgorithmWrapper algorithmWrapper = wrappers.get(i).getAlgorithmWrapper();
                        double stat = Double.NaN;
                        List<String> parameterNames = simulationWrapper.getParameters();
                        Parameters parameters = simulationWrapper.getSimulationSpecificParameters();
                        for (String name : parameterNames) {
                            if (!name.equals(statName)) continue;
                            if (parameters.get(name) instanceof Boolean) {
                                boolean b = parameters.getBoolean(name);
                                stat = b ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                                break;
                            }
                            stat = parameters.getDouble(name);
                            break;
                        }
                        if (Double.isNaN(stat)) {
                            ArrayList<String> _parameterNames = new ArrayList<String>(Params.getAlgorithmParameters(algorithmWrapper.getAlgorithm()));
                            _parameterNames.addAll(Params.getScoreParameters(algorithmWrapper.getAlgorithm()));
                            _parameterNames.addAll(Params.getTestParameters(algorithmWrapper.getAlgorithm()));
                            Parameters _parameters = algorithmWrapper.parameters;
                            for (String name : _parameterNames) {
                                if (!name.equals(statName)) continue;
                                try {
                                    stat = _parameters.getDouble(name);
                                }
                                catch (Exception e) {
                                    boolean b = _parameters.getBoolean(name);
                                    stat = b ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                                }
                                break;
                            }
                        }
                        statTables[u][i][j] = stat;
                        continue;
                    }
                    if (mode == Mode.Average) {
                        double mean;
                        statTables[u][i][j] = mean = StatUtils.mean(allStats[u][i][j]);
                        continue;
                    }
                    if (mode == Mode.MinValue) {
                        statTables[u][i][j] = StatUtils.min(allStats[u][i][j]);
                        continue;
                    }
                    if (mode == Mode.MaxValue) {
                        statTables[u][i][j] = StatUtils.max(allStats[u][i][j]);
                        continue;
                    }
                    if (mode == Mode.StandardDeviation) {
                        statTables[u][i][j] = StatUtils.sd(allStats[u][i][j]);
                        continue;
                    }
                    if (mode == Mode.MedianValue) {
                        statTables[u][i][j] = StatUtils.median(allStats[u][i][j]);
                        continue;
                    }
                    throw new IllegalStateException();
                }
            }
        }
        return statTables;
    }

    private void printStats(double[][][] statTables, Statistics statistics, Mode mode, int[] newOrder, List<AlgorithmSimulationWrapper> algorithmSimulationWrappers, List<AlgorithmWrapper> algorithmWrappers, List<SimulationWrapper> simulationWrappers, double[] utilities, Parameters parameters) {
        if (mode == Mode.Average) {
            this.out.println("AVERAGE VALUE");
        } else if (mode == Mode.StandardDeviation) {
            this.out.println("STANDARD DEVIATION");
        } else if (mode == Mode.MinValue) {
            this.out.println("MIN VALUE");
        } else if (mode == Mode.MaxValue) {
            this.out.println("MAX VALUE");
        } else if (mode == Mode.MedianValue) {
            this.out.println("MEDIAN VALUE");
        } else {
            throw new IllegalStateException();
        }
        int numTables = statTables.length;
        int numStats = statistics.size();
        DecimalFormat nf = new DecimalFormat("0.00");
        DecimalFormat smallNf = new DecimalFormat("0.00E0");
        this.out.println();
        for (int u = 0; u < numTables; ++u) {
            int t;
            if (!this.graphTypeUsed[u]) continue;
            int rows = algorithmSimulationWrappers.size() + 1;
            int cols = (this.isShowSimulationIndices() ? 1 : 0) + (this.isShowAlgorithmIndices() ? 1 : 0) + numStats + (this.isShowUtilities() ? 1 : 0);
            TextTable table = new TextTable(rows, cols);
            table.setDelimiter(TextTable.Delimiter.JUSTIFIED);
            int initialColumn = 0;
            if (this.isShowSimulationIndices()) {
                table.setToken(0, initialColumn, "Sim");
                for (t = 0; t < algorithmSimulationWrappers.size(); ++t) {
                    SimulationWrapper simulation = algorithmSimulationWrappers.get(newOrder[t]).getSimulationWrapper();
                    table.setToken(t + 1, initialColumn, "" + (simulationWrappers.indexOf(simulation) + 1));
                }
                ++initialColumn;
            }
            if (this.isShowAlgorithmIndices()) {
                table.setToken(0, initialColumn, "Alg");
                for (t = 0; t < algorithmSimulationWrappers.size(); ++t) {
                    AlgorithmWrapper algorithm = algorithmSimulationWrappers.get(newOrder[t]).getAlgorithmWrapper();
                    table.setToken(t + 1, initialColumn, "" + (algorithmWrappers.indexOf(algorithm) + 1));
                }
                ++initialColumn;
            }
            for (int statIndex = 0; statIndex < numStats; ++statIndex) {
                String statLabel = statistics.getStatistics().get(statIndex).getAbbreviation();
                table.setToken(0, initialColumn + statIndex, statLabel);
            }
            if (this.isShowUtilities()) {
                table.setToken(0, initialColumn + numStats, "U");
            }
            for (t = 0; t < algorithmSimulationWrappers.size(); ++t) {
                for (int statIndex = 0; statIndex < numStats; ++statIndex) {
                    String abbreviation;
                    Object[] o;
                    Statistic statistic = statistics.getStatistics().get(statIndex);
                    AlgorithmWrapper algorithmWrapper = algorithmSimulationWrappers.get(newOrder[t]).getAlgorithmWrapper();
                    SimulationWrapper simulationWrapper = algorithmSimulationWrappers.get(newOrder[t]).getSimulationWrapper();
                    Algorithm algorithm = algorithmWrapper.getAlgorithm();
                    Simulation simulation = simulationWrapper.getSimulation();
                    if (algorithm instanceof HasParameterValues) {
                        parameters.putAll(((HasParameterValues)((Object)algorithm)).getParameterValues());
                    }
                    if (simulation instanceof HasParameterValues) {
                        parameters.putAll(((HasParameterValues)((Object)simulation)).getParameterValues());
                    }
                    if ((o = parameters.getValues(abbreviation = statistic.getAbbreviation())).length == 1 && o[0] instanceof String) {
                        table.setToken(t + 1, initialColumn + statIndex, (String)o[0]);
                        continue;
                    }
                    double stat = statTables[u][newOrder[t]][statIndex];
                    if (stat == Double.POSITIVE_INFINITY) {
                        table.setToken(t + 1, initialColumn + statIndex, "Yes");
                        continue;
                    }
                    if (stat == Double.NEGATIVE_INFINITY) {
                        table.setToken(t + 1, initialColumn + statIndex, "No");
                        continue;
                    }
                    if (Double.isNaN(stat)) {
                        table.setToken(t + 1, initialColumn + statIndex, "*");
                        continue;
                    }
                    table.setToken(t + 1, initialColumn + statIndex, FastMath.abs(stat) < FastMath.pow(10.0, -((NumberFormat)smallNf).getMaximumFractionDigits()) && stat != 0.0 ? smallNf.format(stat) : nf.format(stat));
                }
                if (!this.isShowUtilities()) continue;
                table.setToken(t + 1, initialColumn + numStats, nf.format(utilities[newOrder[t]]));
            }
            this.out.println(this.getHeader(u));
            this.out.println();
            this.out.println(table);
        }
    }

    private double[] calcUtilities(Statistics statistics, List<AlgorithmSimulationWrapper> wrappers, double[][] stats) {
        double[] utilities = new double[wrappers.size()];
        for (int t = 0; t < wrappers.size(); ++t) {
            int j = -1;
            Iterator<Statistic> it2 = statistics.getStatistics().iterator();
            double sum = 0.0;
            double max = 0.0;
            while (it2.hasNext()) {
                Statistic stat = it2.next();
                ++j;
                double weight = statistics.getWeight(stat);
                if (weight == 0.0) continue;
                sum += weight * stat.getNormValue(stats[t][j]);
                max += weight;
            }
            utilities[t] = sum / max;
        }
        return utilities;
    }

    private int[] sort(List<AlgorithmSimulationWrapper> algorithmSimulationWrappers, double[] utilities) {
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int t = 0; t < algorithmSimulationWrappers.size(); ++t) {
            order.add(t);
        }
        double[] _utilities = Arrays.copyOf(utilities, utilities.length);
        double low = StatUtils.min(utilities);
        for (int t = 0; t < _utilities.length; ++t) {
            low -= 1.0;
            if (!Double.isNaN(_utilities[t])) continue;
            _utilities[t] = low;
        }
        order.sort((o1, o2) -> {
            double u1 = _utilities[o1];
            double u2 = _utilities[o2];
            if (Double.isNaN(u1)) {
                u1 = 0.0;
            }
            if (Double.isNaN(u2)) {
                u2 = 0.0;
            }
            return -Double.compare(u1, u2);
        });
        int[] newOrder = new int[algorithmSimulationWrappers.size()];
        for (int t = 0; t < algorithmSimulationWrappers.size(); ++t) {
            newOrder[t] = (Integer)order.get(t);
        }
        return newOrder;
    }

    private synchronized Graph getSubgraph(Graph graph, boolean discrete1, boolean discrete2, DataModel DataModel2) {
        if (discrete1 && discrete2) {
            EdgeListGraph newGraph = new EdgeListGraph(graph.getNodes());
            for (Edge edge : graph.getEdges()) {
                Node node1 = DataModel2.getVariable(edge.getNode1().getName());
                Node node2 = DataModel2.getVariable(edge.getNode2().getName());
                if (!(node1 instanceof DiscreteVariable) || !(node2 instanceof DiscreteVariable)) continue;
                newGraph.addEdge(edge);
            }
            return newGraph;
        }
        if (!discrete1 && !discrete2) {
            EdgeListGraph newGraph = new EdgeListGraph(graph.getNodes());
            for (Edge edge : graph.getEdges()) {
                Node node1 = DataModel2.getVariable(edge.getNode1().getName());
                Node node2 = DataModel2.getVariable(edge.getNode2().getName());
                if (!(node1 instanceof ContinuousVariable) || !(node2 instanceof ContinuousVariable)) continue;
                newGraph.addEdge(edge);
            }
            return newGraph;
        }
        EdgeListGraph newGraph = new EdgeListGraph(graph.getNodes());
        for (Edge edge : graph.getEdges()) {
            Node node1 = DataModel2.getVariable(edge.getNode1().getName());
            Node node2 = DataModel2.getVariable(edge.getNode2().getName());
            if (node1 instanceof DiscreteVariable && node2 instanceof ContinuousVariable) {
                newGraph.addEdge(edge);
            }
            if (!(node1 instanceof ContinuousVariable) || !(node2 instanceof DiscreteVariable)) continue;
            newGraph.addEdge(edge);
        }
        return newGraph;
    }

    private static class Run {
        private final int algSimIndex;
        private final int runIndex;
        private final int index;
        private final AlgorithmSimulationWrapper wrapper;

        public Run(int algSimIndex, int runIndex, int index, AlgorithmSimulationWrapper wrapper) {
            this.runIndex = runIndex;
            this.algSimIndex = algSimIndex;
            this.index = index;
            this.wrapper = wrapper;
        }

        public int getAlgSimIndex() {
            return this.algSimIndex;
        }

        public int getRunIndex() {
            return this.runIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public AlgorithmSimulationWrapper getWrapper() {
            return this.wrapper;
        }
    }

    public static enum ComparisonGraph {
        true_DAG,
        CPDAG_of_the_true_DAG,
        PAG_of_the_true_DAG;

    }

    private static class SimulationWrapper
    implements Simulation {
        private static final long serialVersionUID = 23L;
        private final Simulation simulation;
        private List<Graph> graphs;
        private List<DataModel> dataModels;
        private Parameters parameters;

        public SimulationWrapper(Simulation simulation, Parameters parameters) {
            this.simulation = simulation;
            this.parameters = new Parameters(parameters);
        }

        @Override
        public void createData(Parameters parameters, boolean newModel) {
            if (newModel) {
                this.simulation.createData(parameters, newModel);
                this.graphs = new ArrayList<Graph>();
                this.dataModels = new ArrayList<DataModel>();
                for (int i = 0; i < this.simulation.getNumDataModels(); ++i) {
                    this.graphs.add(this.simulation.getTrueGraph(i));
                    this.dataModels.add(this.simulation.getDataModel(i));
                }
            }
        }

        @Override
        public int getNumDataModels() {
            if (this.dataModels == null) {
                return 0;
            }
            return this.dataModels.size();
        }

        @Override
        public Graph getTrueGraph(int index) {
            if (this.graphs.get(index) == null) {
                return null;
            }
            return new EdgeListGraph(this.graphs.get(index));
        }

        @Override
        public synchronized DataModel getDataModel(int index) {
            return this.dataModels.get(index);
        }

        @Override
        public DataType getDataType() {
            return this.simulation.getDataType();
        }

        @Override
        public String getDescription() {
            return this.simulation.getDescription();
        }

        @Override
        public List<String> getParameters() {
            return this.simulation.getParameters();
        }

        public void setParameters(Parameters parameters) {
            this.parameters = new Parameters(parameters);
        }

        public void setValue(String name, Object value) {
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException();
            }
            this.parameters.set(name, value);
        }

        public Object getValue(String name) {
            Object[] values = this.parameters.getValues(name);
            if (values == null || values.length == 0) {
                throw new NullPointerException("Expecting parameter to be defined: " + name);
            }
            return values[0];
        }

        public Simulation getSimulation() {
            return this.simulation;
        }

        public Parameters getSimulationSpecificParameters() {
            return this.parameters;
        }
    }

    private static class AlgorithmWrapper
    implements Algorithm {
        private static final long serialVersionUID = 23L;
        private final Algorithm algorithm;
        private final Parameters parameters;
        private final List<String> overriddenParameters = new ArrayList<String>();

        public AlgorithmWrapper(Algorithm algorithm, Parameters parameters) {
            this.algorithm = algorithm;
            this.parameters = new Parameters(parameters);
        }

        @Override
        public Graph search(DataModel DataModel2, Parameters parameters) {
            return this.algorithm.search(DataModel2, this.parameters);
        }

        @Override
        public Graph getComparisonGraph(Graph graph) {
            return this.algorithm.getComparisonGraph(graph);
        }

        @Override
        public String getDescription() {
            StringBuilder description = new StringBuilder();
            description.append(this.algorithm.getDescription());
            if (this.overriddenParameters.size() > 0) {
                for (String name : new ArrayList<String>(this.overriddenParameters)) {
                    description.append(", ").append(name).append(" = ").append(this.parameters.get(name));
                }
            }
            return description.toString();
        }

        @Override
        public DataType getDataType() {
            return this.algorithm.getDataType();
        }

        @Override
        public List<String> getParameters() {
            return this.algorithm.getParameters();
        }

        public void setValue(String name, Object value) {
            if (!(value instanceof Number) && !(value instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            this.parameters.set(name, value);
            this.overriddenParameters.add(name);
        }

        public Algorithm getAlgorithm() {
            return this.algorithm;
        }

        public Parameters getAlgorithmSpecificParameters() {
            return this.parameters;
        }
    }

    private static class AlgorithmSimulationWrapper
    implements Algorithm {
        private static final long serialVersionUID = 23L;
        private final SimulationWrapper simulationWrapper;
        private final AlgorithmWrapper algorithmWrapper;

        public AlgorithmSimulationWrapper(AlgorithmWrapper algorithm, SimulationWrapper simulation) {
            this.algorithmWrapper = algorithm;
            this.simulationWrapper = simulation;
        }

        @Override
        public Graph search(DataModel DataModel2, Parameters parameters) {
            return this.algorithmWrapper.getAlgorithm().search(DataModel2, parameters);
        }

        @Override
        public Graph getComparisonGraph(Graph graph) {
            return this.algorithmWrapper.getComparisonGraph(graph);
        }

        @Override
        public String getDescription() {
            throw new IllegalArgumentException();
        }

        @Override
        public DataType getDataType() {
            return this.algorithmWrapper.getDataType();
        }

        @Override
        public List<String> getParameters() {
            ArrayList<String> params = new ArrayList<String>(this.simulationWrapper.getParameters());
            params.addAll(this.algorithmWrapper.getParameters());
            return params;
        }

        public SimulationWrapper getSimulationWrapper() {
            return this.simulationWrapper;
        }

        public AlgorithmWrapper getAlgorithmWrapper() {
            return this.algorithmWrapper;
        }
    }

    private static enum Mode {
        Average,
        StandardDeviation,
        MinValue,
        MaxValue,
        MedianValue;

    }

    private class AlgorithmTask
    implements Callable<Boolean> {
        private final List<AlgorithmSimulationWrapper> algorithmSimulationWrappers;
        private final List<AlgorithmWrapper> algorithmWrappers;
        private final List<SimulationWrapper> simulationWrappers;
        private final Statistics statistics;
        private final int numGraphTypes;
        private final double[][][][] allStats;
        private final Run run;
        private final PrintStream stdout;

        public AlgorithmTask(List<AlgorithmSimulationWrapper> algorithmSimulationWrappers, List<AlgorithmWrapper> algorithmWrappers, List<SimulationWrapper> simulationWrappers, Statistics statistics, int numGraphTypes, double[][][][] allStats, Run run, PrintStream stdout) {
            this.algorithmSimulationWrappers = algorithmSimulationWrappers;
            this.simulationWrappers = simulationWrappers;
            this.algorithmWrappers = algorithmWrappers;
            this.statistics = statistics;
            this.numGraphTypes = numGraphTypes;
            this.allStats = allStats;
            this.run = run;
            this.stdout = stdout;
        }

        @Override
        public Boolean call() throws Exception {
            Comparison.this.doRun(this.algorithmSimulationWrappers, this.algorithmWrappers, this.simulationWrappers, this.statistics, this.numGraphTypes, this.allStats, this.run, this.stdout);
            return true;
        }
    }
}

